/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseHeapFileStat;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Solaris64FileStat;
import org.jruby.ext.posix.SolarisHeapFileStat;
import org.jruby.ext.posix.SolarisPasswd;
import org.jruby.ext.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new SolarisPasswd((Pointer)arg2) : null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public BaseHeapFileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisHeapFileStat(this) : new Solaris64FileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat2 = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_64_BIT ? this.libc().fstat(fd, stat2) : this.libc().fstat64(fd, stat2)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat2;
    }

    public int lchmod(String filename2, int mode2) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String path2) {
        BaseHeapFileStat stat2 = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().lstat(path2, stat2) : this.libc().lstat64(path2, stat2)) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }

    public FileStat stat(String path2) {
        BaseHeapFileStat stat2 = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().stat(path2, stat2) : this.libc().stat64(path2, stat2)) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }
}

