/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class GemFireClient
extends DB {
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final String SERVERPORT_PROPERTY_NAME = "gemfire.serverport";
    private static final String SERVERHOST_PROPERTY_NAME = "gemfire.serverhost";
    private static final String SERVERHOST_PROPERTY_DEFAULT = "localhost";
    private static final String LOCATOR_PROPERTY_NAME = "gemfire.locator";
    private static final String TOPOLOGY_PROPERTY_NAME = "gemfire.topology";
    private static final String TOPOLOGY_P2P_VALUE = "p2p";
    private GemFireCache cache;
    private boolean isClient;

    public void init() throws DBException {
        Properties props = this.getProperties();
        String serverHost = null;
        int serverPort = 0;
        String locatorStr = null;
        if (props != null && !props.isEmpty()) {
            String serverPortStr = props.getProperty(SERVERPORT_PROPERTY_NAME);
            if (serverPortStr != null) {
                serverPort = Integer.parseInt(serverPortStr);
            }
            serverHost = props.getProperty(SERVERHOST_PROPERTY_NAME, SERVERHOST_PROPERTY_DEFAULT);
            locatorStr = props.getProperty(LOCATOR_PROPERTY_NAME);
            String topology = props.getProperty(TOPOLOGY_PROPERTY_NAME);
            if (topology != null && topology.equals(TOPOLOGY_P2P_VALUE)) {
                CacheFactory cf = new CacheFactory();
                if (locatorStr != null) {
                    cf.set("locators", locatorStr);
                }
                this.cache = cf.create();
                this.isClient = false;
                return;
            }
        }
        this.isClient = true;
        DistributionLocatorId locator = null;
        if (locatorStr != null) {
            locator = new DistributionLocatorId(locatorStr);
        }
        ClientCacheFactory ccf = new ClientCacheFactory();
        if (serverPort != 0) {
            ccf.addPoolServer(serverHost, serverPort);
        } else if (locator != null) {
            ccf.addPoolLocator(locator.getHost().getCanonicalHostName(), locator.getPort());
        }
        this.cache = ccf.create();
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        Region<String, Map<String, byte[]>> r = this.getRegion(table);
        Map val = (Map)r.get((Object)key);
        if (val != null) {
            if (fields == null) {
                for (String k : val.keySet()) {
                    result.put(k, (ByteIterator)new ByteArrayByteIterator((byte[])val.get(k)));
                }
            } else {
                for (String field : fields) {
                    result.put(field, (ByteIterator)new ByteArrayByteIterator((byte[])val.get(field)));
                }
            }
            return 0;
        }
        return -1;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        return -1;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        this.getRegion(table).put((Object)key, this.convertToBytearrayMap(values));
        return 0;
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        this.getRegion(table).put((Object)key, this.convertToBytearrayMap(values));
        return 0;
    }

    public int delete(String table, String key) {
        this.getRegion(table).destroy((Object)key);
        return 0;
    }

    private Map<String, byte[]> convertToBytearrayMap(Map<String, ByteIterator> values) {
        HashMap<String, byte[]> retVal = new HashMap<String, byte[]>();
        for (String key : values.keySet()) {
            retVal.put(key, values.get(key).toArray());
        }
        return retVal;
    }

    private Region<String, Map<String, byte[]>> getRegion(String table) {
        Region r = this.cache.getRegion(table);
        if (r == null) {
            try {
                if (this.isClient) {
                    ClientRegionFactory crf = ((ClientCache)this.cache).createClientRegionFactory(ClientRegionShortcut.PROXY);
                    r = crf.create(table);
                } else {
                    RegionFactory rf = ((Cache)this.cache).createRegionFactory(RegionShortcut.PARTITION);
                    r = rf.create(table);
                }
            }
            catch (RegionExistsException e) {
                r = this.cache.getRegion(table);
            }
        }
        return r;
    }
}

