/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import net.spy.memcached.PersistTo;
import net.spy.memcached.ReplicateTo;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseClient
extends DB {
    public static final String URL_PROPERTY = "couchbase.url";
    public static final String BUCKET_PROPERTY = "couchbase.bucket";
    public static final String PASSWORD_PROPERTY = "couchbase.password";
    public static final String CHECKF_PROPERTY = "couchbase.checkFutures";
    public static final String PERSIST_PROPERTY = "couchbase.persistTo";
    public static final String REPLICATE_PROPERTY = "couchbase.replicateTo";
    public static final String JSON_PROPERTY = "couchbase.json";
    public static final int OK = 0;
    public static final int FAILURE = 1;
    protected static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private com.couchbase.client.CouchbaseClient client;
    private PersistTo persistTo;
    private ReplicateTo replicateTo;
    private boolean checkFutures;
    private boolean useJson;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init() throws DBException {
        Properties props = this.getProperties();
        String url = props.getProperty(URL_PROPERTY, "http://127.0.0.1:8091/pools");
        String bucket = props.getProperty(BUCKET_PROPERTY, "default");
        String password = props.getProperty(PASSWORD_PROPERTY, "");
        this.checkFutures = props.getProperty(CHECKF_PROPERTY, "true").equals("true");
        this.useJson = props.getProperty(JSON_PROPERTY, "true").equals("true");
        this.persistTo = this.parsePersistTo(props.getProperty(PERSIST_PROPERTY, "0"));
        this.replicateTo = this.parseReplicateTo(props.getProperty(REPLICATE_PROPERTY, "0"));
        Properties systemProperties = System.getProperties();
        systemProperties.put("net.spy.log.LoggerImpl", "net.spy.memcached.compat.log.SLF4JLogger");
        System.setProperties(systemProperties);
        try {
            this.client = new com.couchbase.client.CouchbaseClient(Arrays.asList(new URI(url)), bucket, password);
        }
        catch (Exception e) {
            throw new DBException("Could not create CouchbaseClient object.", (Throwable)e);
        }
    }

    private ReplicateTo parseReplicateTo(String property) throws DBException {
        int value = Integer.parseInt(property);
        switch (value) {
            case 0: {
                return ReplicateTo.ZERO;
            }
            case 1: {
                return ReplicateTo.ONE;
            }
            case 2: {
                return ReplicateTo.TWO;
            }
            case 3: {
                return ReplicateTo.THREE;
            }
        }
        throw new DBException("couchbase.replicateTo must be between 0 and 3");
    }

    private PersistTo parsePersistTo(String property) throws DBException {
        int value = Integer.parseInt(property);
        switch (value) {
            case 0: {
                return PersistTo.ZERO;
            }
            case 1: {
                return PersistTo.ONE;
            }
            case 2: {
                return PersistTo.TWO;
            }
            case 3: {
                return PersistTo.THREE;
            }
            case 4: {
                return PersistTo.FOUR;
            }
        }
        throw new DBException("couchbase.persistTo must be between 0 and 4");
    }

    public void cleanup() {
        this.client.shutdown();
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        String formattedKey = this.formatKey(table, key);
        try {
            Object loaded = this.client.get(formattedKey);
            if (loaded == null) {
                return 1;
            }
            this.decode(loaded, fields, result);
            return 0;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not read value for key " + formattedKey, (Throwable)e);
            }
            return 1;
        }
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        return 1;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        String formattedKey = this.formatKey(table, key);
        try {
            OperationFuture future = this.client.replace(formattedKey, this.encode(values), this.persistTo, this.replicateTo);
            return this.checkFutureStatus(future);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not update value for key " + formattedKey, (Throwable)e);
            }
            return 1;
        }
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        String formattedKey = this.formatKey(table, key);
        try {
            OperationFuture future = this.client.add(formattedKey, this.encode(values), this.persistTo, this.replicateTo);
            return this.checkFutureStatus(future);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not insert value for key " + formattedKey, (Throwable)e);
            }
            return 1;
        }
    }

    public int delete(String table, String key) {
        String formattedKey = this.formatKey(table, key);
        try {
            OperationFuture future = this.client.delete(formattedKey, this.persistTo, this.replicateTo);
            return this.checkFutureStatus(future);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not delete value for key " + formattedKey, (Throwable)e);
            }
            return 1;
        }
    }

    private String formatKey(String prefix, String key) {
        return prefix + ":" + key;
    }

    private int checkFutureStatus(OperationFuture<?> future) {
        if (this.checkFutures) {
            return future.getStatus().isSuccess() ? 0 : 1;
        }
        return 0;
    }

    private void decode(Object source, Set<String> fields, HashMap<String, ByteIterator> dest) {
        if (this.useJson) {
            try {
                JsonNode json = JSON_MAPPER.readTree((String)source);
                boolean checkFields = fields != null && fields.size() > 0;
                Iterator jsonFields = json.fields();
                while (jsonFields.hasNext()) {
                    JsonNode jsonValue;
                    Map.Entry jsonField = (Map.Entry)jsonFields.next();
                    String name = (String)jsonField.getKey();
                    if (checkFields && fields.contains(name) || (jsonValue = (JsonNode)jsonField.getValue()) == null || jsonValue.isNull()) continue;
                    dest.put(name, (ByteIterator)new StringByteIterator(jsonValue.asText()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not decode JSON");
            }
        } else {
            HashMap converted = (HashMap)source;
            for (Map.Entry entry : converted.entrySet()) {
                dest.put((String)entry.getKey(), (ByteIterator)new StringByteIterator((String)entry.getValue()));
            }
        }
    }

    private Object encode(HashMap<String, ByteIterator> source) {
        HashMap stringMap = StringByteIterator.getStringMap(source);
        if (!this.useJson) {
            return stringMap;
        }
        ObjectNode node = JSON_MAPPER.createObjectNode();
        for (Map.Entry pair : stringMap.entrySet()) {
            node.put((String)pair.getKey(), (String)pair.getValue());
        }
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)writer);
            JSON_MAPPER.writeTree(jsonGenerator, (JsonNode)node);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encode JSON value");
        }
        return ((Object)writer).toString();
    }
}

