/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public class JobContext {
    protected static final String INPUT_FORMAT_CLASS_ATTR = "mapreduce.inputformat.class";
    protected static final String MAP_CLASS_ATTR = "mapreduce.map.class";
    protected static final String COMBINE_CLASS_ATTR = "mapreduce.combine.class";
    protected static final String REDUCE_CLASS_ATTR = "mapreduce.reduce.class";
    protected static final String OUTPUT_FORMAT_CLASS_ATTR = "mapreduce.outputformat.class";
    protected static final String PARTITIONER_CLASS_ATTR = "mapreduce.partitioner.class";
    protected final JobConf conf;
    protected final Credentials credentials;
    private final JobID jobId;
    public static final String JOB_NAMENODES = "mapreduce.job.hdfs-servers";
    public static final String JOB_ACL_VIEW_JOB = "mapreduce.job.acl-view-job";
    public static final String JOB_ACL_MODIFY_JOB = "mapreduce.job.acl-modify-job";
    public static final String CACHE_FILE_VISIBILITIES = "mapreduce.job.cache.files.visibilities";
    public static final String CACHE_ARCHIVES_VISIBILITIES = "mapreduce.job.cache.archives.visibilities";
    public static final String JOB_CANCEL_DELEGATION_TOKEN = "mapreduce.job.complete.cancel.delegation.tokens";
    public static final String USER_LOG_RETAIN_HOURS = "mapred.userlog.retain.hours";
    protected UserGroupInformation ugi;

    public JobContext(Configuration conf, JobID jobId) {
        this.conf = new JobConf(conf);
        this.credentials = this.conf.getCredentials();
        this.jobId = jobId;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public int getNumReduceTasks() {
        return this.conf.getNumReduceTasks();
    }

    public Path getWorkingDirectory() throws IOException {
        return this.conf.getWorkingDirectory();
    }

    public Class<?> getOutputKeyClass() {
        return this.conf.getOutputKeyClass();
    }

    public Class<?> getOutputValueClass() {
        return this.conf.getOutputValueClass();
    }

    public Class<?> getMapOutputKeyClass() {
        return this.conf.getMapOutputKeyClass();
    }

    public Class<?> getMapOutputValueClass() {
        return this.conf.getMapOutputValueClass();
    }

    public String getJobName() {
        return this.conf.getJobName();
    }

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass(INPUT_FORMAT_CLASS_ATTR, TextInputFormat.class);
    }

    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return this.conf.getClass(MAP_CLASS_ATTR, Mapper.class);
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return this.conf.getClass(COMBINE_CLASS_ATTR, null);
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return this.conf.getClass(REDUCE_CLASS_ATTR, Reducer.class);
    }

    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass(OUTPUT_FORMAT_CLASS_ATTR, TextOutputFormat.class);
    }

    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return this.conf.getClass(PARTITIONER_CLASS_ATTR, HashPartitioner.class);
    }

    public RawComparator<?> getSortComparator() {
        return this.conf.getOutputKeyComparator();
    }

    public String getJar() {
        return this.conf.getJar();
    }

    public RawComparator<?> getGroupingComparator() {
        return this.conf.getOutputValueGroupingComparator();
    }
}

