/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;

public class MetricsCache {
    private static final long serialVersionUID = 1L;
    private final Map<String, RecMap> map = new HashMap<String, RecMap>();

    public Record update(MetricsRecord mr, boolean includingTags) {
        Collection tags;
        Record rec;
        String name = mr.name();
        RecMap recMap = this.map.get(name);
        if (recMap == null) {
            recMap = new RecMap();
            this.map.put(name, recMap);
        }
        if ((rec = (Record)recMap.get(tags = (Collection)mr.tags())) == null) {
            rec = new Record();
            recMap.put(tags, rec);
        }
        for (Metric m : mr.metrics()) {
            rec.metrics.put(m.name(), m.value());
        }
        if (includingTags) {
            for (MetricsTag t : mr.tags()) {
                rec.tags.put(t.name(), t.value());
            }
        }
        return rec;
    }

    public Record update(MetricsRecord mr) {
        return this.update(mr, false);
    }

    public Record get(String name, Collection<MetricsTag> tags) {
        RecMap tmap = this.map.get(name);
        if (tmap == null) {
            return null;
        }
        return (Record)tmap.get(tags);
    }

    public static class Record {
        final Map<String, String> tags = new LinkedHashMap<String, String>();
        final Map<String, Number> metrics = new LinkedHashMap<String, Number>();

        public String getTag(String key) {
            return this.tags.get(key);
        }

        public Number getMetric(String key) {
            return this.metrics.get(key);
        }

        public Set<Map.Entry<String, Number>> metrics() {
            return this.metrics.entrySet();
        }
    }

    static class RecMap
    extends HashMap<Collection<MetricsTag>, Record> {
        private static final long serialVersionUID = 1L;

        RecMap() {
        }
    }
}

