/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class HDFSBlocksDistribution {
    private Map<String, HostAndWeight> hostAndWeights = new TreeMap<String, HostAndWeight>();
    private long uniqueBlocksTotalWeight = 0L;

    public synchronized String toString() {
        return "number of unique hosts in the disribution=" + this.hostAndWeights.size();
    }

    public void addHostsAndBlockWeight(String[] hosts, long weight) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        this.addUniqueWeight(weight);
        for (String hostname : hosts) {
            this.addHostAndBlockWeight(hostname, weight);
        }
    }

    private void addUniqueWeight(long weight) {
        this.uniqueBlocksTotalWeight += weight;
    }

    private void addHostAndBlockWeight(String host, long weight) {
        if (host == null) {
            return;
        }
        HostAndWeight hostAndWeight = this.hostAndWeights.get(host);
        if (hostAndWeight == null) {
            hostAndWeight = new HostAndWeight(host, weight);
            this.hostAndWeights.put(host, hostAndWeight);
        } else {
            hostAndWeight.addWeight(weight);
        }
    }

    public Map<String, HostAndWeight> getHostAndWeights() {
        return this.hostAndWeights;
    }

    public long getWeight(String host) {
        HostAndWeight hostAndWeight;
        long weight = 0L;
        if (host != null && (hostAndWeight = this.hostAndWeights.get(host)) != null) {
            weight = hostAndWeight.getWeight();
        }
        return weight;
    }

    public long getUniqueBlocksTotalWeight() {
        return this.uniqueBlocksTotalWeight;
    }

    public float getBlockLocalityIndex(String host) {
        float localityIndex = 0.0f;
        HostAndWeight hostAndWeight = this.hostAndWeights.get(host);
        if (hostAndWeight != null && this.uniqueBlocksTotalWeight != 0L) {
            localityIndex = (float)hostAndWeight.weight / (float)this.uniqueBlocksTotalWeight;
        }
        return localityIndex;
    }

    public void add(HDFSBlocksDistribution otherBlocksDistribution) {
        Map<String, HostAndWeight> otherHostAndWeights = otherBlocksDistribution.getHostAndWeights();
        for (Map.Entry<String, HostAndWeight> otherHostAndWeight : otherHostAndWeights.entrySet()) {
            this.addHostAndBlockWeight(otherHostAndWeight.getValue().host, otherHostAndWeight.getValue().weight);
        }
        this.addUniqueWeight(otherBlocksDistribution.getUniqueBlocksTotalWeight());
    }

    public List<String> getTopHosts() {
        HostAndWeight[] hostAndWeights = this.getTopHostsWithWeights();
        ArrayList<String> topHosts = new ArrayList<String>(hostAndWeights.length);
        for (HostAndWeight haw : hostAndWeights) {
            topHosts.add(haw.getHost());
        }
        return topHosts;
    }

    public HostAndWeight[] getTopHostsWithWeights() {
        TreeSet<HostAndWeight> orderedHosts = new TreeSet<HostAndWeight>(new HostAndWeight.WeightComparator());
        orderedHosts.addAll(this.hostAndWeights.values());
        return orderedHosts.descendingSet().toArray(new HostAndWeight[orderedHosts.size()]);
    }

    public static class HostAndWeight {
        private String host;
        private long weight;

        public HostAndWeight(String host, long weight) {
            this.host = host;
            this.weight = weight;
        }

        public void addWeight(long weight) {
            this.weight += weight;
        }

        public String getHost() {
            return this.host;
        }

        public long getWeight() {
            return this.weight;
        }

        public static class WeightComparator
        implements Comparator<HostAndWeight> {
            @Override
            public int compare(HostAndWeight l, HostAndWeight r) {
                if (l.getWeight() == r.getWeight()) {
                    return l.getHost().compareTo(r.getHost());
                }
                return l.getWeight() < r.getWeight() ? -1 : 1;
            }
        }
    }
}

