/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;

public class HTableDescriptor
implements WritableComparable<HTableDescriptor> {
    private static final byte TABLE_DESCRIPTOR_VERSION = 5;
    private byte[] name = HConstants.EMPTY_BYTE_ARRAY;
    private String nameAsString = "";
    protected final Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private static final String FAMILIES = "FAMILIES";
    public static final String SPLIT_POLICY = "SPLIT_POLICY";
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    private static final ImmutableBytesWritable MAX_FILESIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes("MAX_FILESIZE"));
    public static final String OWNER = "OWNER";
    public static final ImmutableBytesWritable OWNER_KEY = new ImmutableBytesWritable(Bytes.toBytes("OWNER"));
    public static final String READONLY = "READONLY";
    private static final ImmutableBytesWritable READONLY_KEY = new ImmutableBytesWritable(Bytes.toBytes("READONLY"));
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    private static final ImmutableBytesWritable MEMSTORE_FLUSHSIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes("MEMSTORE_FLUSHSIZE"));
    public static final String IS_ROOT = "IS_ROOT";
    private static final ImmutableBytesWritable IS_ROOT_KEY = new ImmutableBytesWritable(Bytes.toBytes("IS_ROOT"));
    public static final String IS_META = "IS_META";
    private static final ImmutableBytesWritable IS_META_KEY = new ImmutableBytesWritable(Bytes.toBytes("IS_META"));
    public static final String DEFERRED_LOG_FLUSH = "DEFERRED_LOG_FLUSH";
    private static final ImmutableBytesWritable DEFERRED_LOG_FLUSH_KEY = new ImmutableBytesWritable(Bytes.toBytes("DEFERRED_LOG_FLUSH"));
    private static final ImmutableBytesWritable FALSE = new ImmutableBytesWritable(Bytes.toBytes(Boolean.FALSE.toString()));
    private static final ImmutableBytesWritable TRUE = new ImmutableBytesWritable(Bytes.toBytes(Boolean.TRUE.toString()));
    private static final boolean DEFAULT_DEFERRED_LOG_FLUSH = false;
    public static final boolean DEFAULT_READONLY = false;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x8000000L;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<ImmutableBytesWritable> RESERVED_KEYWORDS = new HashSet<ImmutableBytesWritable>();
    private volatile Boolean meta = null;
    private volatile Boolean root = null;
    private Boolean isDeferredLog = null;
    private final Map<byte[], HColumnDescriptor> families = new TreeMap<byte[], HColumnDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    public static final String VALID_USER_TABLE_REGEX = "(?:[a-zA-Z_0-9][a-zA-Z_0-9.-]*)";
    public static final HTableDescriptor ROOT_TABLEDESC;
    public static final HTableDescriptor META_TABLEDESC;

    protected HTableDescriptor(byte[] name, HColumnDescriptor[] families) {
        this.name = (byte[])name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
    }

    protected HTableDescriptor(byte[] name, HColumnDescriptor[] families, Map<ImmutableBytesWritable, ImmutableBytesWritable> values) {
        this.name = (byte[])name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
    }

    public HTableDescriptor() {
    }

    public HTableDescriptor(String name) {
        this(Bytes.toBytes(name));
    }

    public HTableDescriptor(byte[] name) {
        this.setMetaFlags(this.name);
        this.name = this.isMetaRegion() ? name : HTableDescriptor.isLegalTableName(name);
        this.nameAsString = Bytes.toString(this.name);
    }

    public HTableDescriptor(HTableDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(this.name);
        for (HColumnDescriptor hColumnDescriptor : desc.families.values()) {
            this.families.put(hColumnDescriptor.getName(), new HColumnDescriptor(hColumnDescriptor));
        }
        for (Map.Entry entry : desc.values.entrySet()) {
            this.values.put((ImmutableBytesWritable)entry.getKey(), (ImmutableBytesWritable)entry.getValue());
        }
    }

    private void setMetaFlags(byte[] name) {
        this.setRootRegion(Bytes.equals(name, HConstants.ROOT_TABLE_NAME));
        this.setMetaRegion(this.isRootRegion() || Bytes.equals(name, HConstants.META_TABLE_NAME));
    }

    public boolean isRootRegion() {
        if (this.root == null) {
            this.root = this.isSomething(IS_ROOT_KEY, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.root;
    }

    protected void setRootRegion(boolean isRoot) {
        this.values.put(IS_ROOT_KEY, isRoot ? TRUE : FALSE);
    }

    public boolean isMetaRegion() {
        if (this.meta == null) {
            this.meta = this.calculateIsMetaRegion();
        }
        return this.meta;
    }

    private synchronized Boolean calculateIsMetaRegion() {
        byte[] value = this.getValue(IS_META_KEY);
        return value != null ? Boolean.valueOf(Bytes.toString(value)) : Boolean.FALSE;
    }

    private boolean isSomething(ImmutableBytesWritable key, boolean valueIfNull) {
        byte[] value = this.getValue(key);
        if (value != null) {
            return Boolean.valueOf(Bytes.toString(value));
        }
        return valueIfNull;
    }

    protected void setMetaRegion(boolean isMeta) {
        this.values.put(IS_META_KEY, isMeta ? TRUE : FALSE);
    }

    public boolean isMetaTable() {
        return this.isMetaRegion() && !this.isRootRegion();
    }

    public static boolean isMetaTable(byte[] tableName) {
        return Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME) || Bytes.equals(tableName, HConstants.META_TABLE_NAME);
    }

    public static byte[] isLegalTableName(byte[] tableName) {
        return HTableDescriptor.isLegalTableName(tableName, false);
    }

    public static byte[] isLegalTableName(byte[] tableName, boolean isSnapshot) {
        if (tableName == null || tableName.length <= 0) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        if (tableName[0] == 46 || tableName[0] == 45) {
            throw new IllegalArgumentException("Illegal first character <" + tableName[0] + "> at 0. " + (isSnapshot ? "snapshot" : "User-space table") + " can only start with 'word characters': i.e. [a-zA-Z_0-9]: " + Bytes.toString(tableName));
        }
        for (int i = 0; i < tableName.length; ++i) {
            if (Character.isLetterOrDigit(tableName[i]) || tableName[i] == 95 || tableName[i] == 45 || tableName[i] == 46) continue;
            throw new IllegalArgumentException("Illegal character <" + tableName[i] + "> at " + i + ". " + (isSnapshot ? "snapshot" : "User-space table") + " can only contain 'word characters': i.e. [a-zA-Z_0-9-.]: " + Bytes.toString(tableName));
        }
        return tableName;
    }

    public byte[] getValue(byte[] key) {
        return this.getValue(new ImmutableBytesWritable(key));
    }

    private byte[] getValue(ImmutableBytesWritable key) {
        ImmutableBytesWritable ibw = this.values.get(key);
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public void setValue(byte[] key, byte[] value) {
        this.setValue(new ImmutableBytesWritable(key), value);
    }

    private void setValue(ImmutableBytesWritable key, byte[] value) {
        this.values.put(key, new ImmutableBytesWritable(value));
    }

    public void setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        this.values.put(key, value);
    }

    public void setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes(key));
        } else {
            this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
        }
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public void remove(String key) {
        this.remove(Bytes.toBytes(key));
    }

    public boolean isReadOnly() {
        return this.isSomething(READONLY_KEY, false);
    }

    public void setReadOnly(boolean readOnly) {
        this.setValue(READONLY_KEY, readOnly ? TRUE : FALSE);
    }

    public synchronized boolean isDeferredLogFlush() {
        if (this.isDeferredLog == null) {
            this.isDeferredLog = this.isSomething(DEFERRED_LOG_FLUSH_KEY, false);
        }
        return this.isDeferredLog;
    }

    public void setDeferredLogFlush(boolean isDeferredLogFlush) {
        this.setValue(DEFERRED_LOG_FLUSH_KEY, isDeferredLogFlush ? TRUE : FALSE);
        this.isDeferredLog = isDeferredLogFlush;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public String getRegionSplitPolicyClassName() {
        return this.getValue(SPLIT_POLICY);
    }

    public void setName(byte[] name) {
        this.name = name;
        this.nameAsString = Bytes.toString(this.name);
        this.setMetaFlags(this.name);
    }

    public long getMaxFileSize() {
        byte[] value = this.getValue(MAX_FILESIZE_KEY);
        if (value != null) {
            return Long.parseLong(Bytes.toString(value));
        }
        return -1L;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.setValue(MAX_FILESIZE_KEY, Bytes.toBytes(Long.toString(maxFileSize)));
    }

    public long getMemStoreFlushSize() {
        byte[] value = this.getValue(MEMSTORE_FLUSHSIZE_KEY);
        if (value != null) {
            return Long.parseLong(Bytes.toString(value));
        }
        return -1L;
    }

    public void setMemStoreFlushSize(long memstoreFlushSize) {
        this.setValue(MEMSTORE_FLUSHSIZE_KEY, Bytes.toBytes(Long.toString(memstoreFlushSize)));
    }

    public void addFamily(HColumnDescriptor family) {
        if (family.getName() == null || family.getName().length <= 0) {
            throw new NullPointerException("Family name cannot be null or empty");
        }
        this.families.put(family.getName(), family);
    }

    public boolean hasFamily(byte[] familyName) {
        return this.families.containsKey(familyName);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('\'').append(Bytes.toString(this.name)).append('\'');
        s.append((CharSequence)this.getValues(true));
        for (HColumnDescriptor f : this.families.values()) {
            s.append(", ").append(f);
        }
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('\'').append(Bytes.toString(this.name)).append('\'');
        s.append((CharSequence)this.getValues(false));
        for (HColumnDescriptor hcd : this.families.values()) {
            s.append(", ").append(hcd.toStringCustomizedValues());
        }
        return s.toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        String value;
        String key;
        StringBuilder s = new StringBuilder();
        TreeSet<ImmutableBytesWritable> reservedKeys = new TreeSet<ImmutableBytesWritable>();
        TreeSet<ImmutableBytesWritable> configKeys = new TreeSet<ImmutableBytesWritable>();
        for (ImmutableBytesWritable k : this.values.keySet()) {
            if (k == null || k.get() == null) continue;
            key = Bytes.toString(k.get());
            if (!RESERVED_KEYWORDS.contains(k) && !key.startsWith("coprocessor$")) {
                configKeys.add(k);
                continue;
            }
            value = Bytes.toString(this.values.get(k).get());
            if ((key.equalsIgnoreCase(IS_ROOT) || key.equalsIgnoreCase(IS_META)) && value.toLowerCase().equals(Boolean.FALSE.toString()) || !printDefaults && DEFAULT_VALUES.containsKey(key) && DEFAULT_VALUES.get(key).equalsIgnoreCase(value)) continue;
            reservedKeys.add(k);
        }
        if (reservedKeys.isEmpty() && configKeys.isEmpty()) {
            return s;
        }
        s.append(", {METHOD => 'table_att'");
        for (ImmutableBytesWritable k : reservedKeys) {
            key = Bytes.toString(k.get());
            value = Bytes.toString(this.values.get(k).get());
            s.append(", ");
            s.append(key);
            s.append(" => ");
            s.append('\'').append(value).append('\'');
        }
        if (!configKeys.isEmpty()) {
            s.append(", ");
            s.append("CONFIG").append(" => ");
            s.append("{");
            boolean printComma = false;
            for (ImmutableBytesWritable k : configKeys) {
                String key2 = Bytes.toString(k.get());
                String value2 = Bytes.toString(this.values.get(k).get());
                if (printComma) {
                    s.append(", ");
                }
                printComma = true;
                s.append('\'').append(key2).append('\'');
                s.append(" => ");
                s.append('\'').append(value2).append('\'');
            }
            s.append("}");
        }
        s.append('}');
        return s;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTableDescriptor)) {
            return false;
        }
        return this.compareTo((HTableDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)5).hashCode();
        if (this.families != null && this.families.size() > 0) {
            for (HColumnDescriptor e : this.families.values()) {
                result ^= e.hashCode();
            }
        }
        return result ^= this.values.hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        int version = in.readInt();
        if (version < 3) {
            throw new IOException("versions < 3 are not supported (and never existed!?)");
        }
        this.name = Bytes.readByteArray(in);
        this.nameAsString = Bytes.toString(this.name);
        this.setRootRegion(in.readBoolean());
        this.setMetaRegion(in.readBoolean());
        this.values.clear();
        int numVals = in.readInt();
        for (int i = 0; i < numVals; ++i) {
            ImmutableBytesWritable key = new ImmutableBytesWritable();
            ImmutableBytesWritable value = new ImmutableBytesWritable();
            key.readFields(in);
            value.readFields(in);
            this.values.put(key, value);
        }
        this.families.clear();
        int numFamilies = in.readInt();
        for (int i = 0; i < numFamilies; ++i) {
            HColumnDescriptor c = new HColumnDescriptor();
            c.readFields(in);
            this.families.put(c.getName(), c);
        }
        if (version < 4) {
            return;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(5);
        Bytes.writeByteArray(out, this.name);
        out.writeBoolean(this.isRootRegion());
        out.writeBoolean(this.isMetaRegion());
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
        out.writeInt(this.families.size());
        for (HColumnDescriptor family : this.families.values()) {
            family.write(out);
        }
    }

    public int compareTo(HTableDescriptor other) {
        int result = Bytes.compareTo(this.name, other.name);
        if (result == 0) {
            result = this.families.size() - other.families.size();
        }
        if (result == 0 && this.families.size() != other.families.size()) {
            result = Integer.valueOf(this.families.size()).compareTo(other.families.size());
        }
        if (result == 0) {
            Iterator<HColumnDescriptor> it = this.families.values().iterator();
            Iterator<HColumnDescriptor> it2 = other.families.values().iterator();
            while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
            }
        }
        if (result == 0) {
            result = this.values.hashCode() - other.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public Collection<HColumnDescriptor> getFamilies() {
        return Collections.unmodifiableCollection(this.families.values());
    }

    public Set<byte[]> getFamiliesKeys() {
        return Collections.unmodifiableSet(this.families.keySet());
    }

    public HColumnDescriptor[] getColumnFamilies() {
        return this.getFamilies().toArray(new HColumnDescriptor[0]);
    }

    public HColumnDescriptor getFamily(byte[] column) {
        return this.families.get(column);
    }

    public HColumnDescriptor removeFamily(byte[] column) {
        return this.families.remove(column);
    }

    public void addCoprocessor(String className) throws IOException {
        this.addCoprocessor(className, null, 0x3FFFFFFF, null);
    }

    public void addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
        if (this.hasCoprocessor(className)) {
            throw new IOException("Coprocessor " + className + " already exists.");
        }
        StringBuilder kvString = new StringBuilder();
        if (kvs != null) {
            for (Map.Entry<String, String> e : kvs.entrySet()) {
                if (!e.getKey().matches("[^=,]+")) {
                    throw new IOException("Illegal parameter key = " + e.getKey());
                }
                if (!e.getValue().matches("[^,]+")) {
                    throw new IOException("Illegal parameter (" + e.getKey() + ") value = " + e.getValue());
                }
                if (kvString.length() != 0) {
                    kvString.append(',');
                }
                kvString.append(e.getKey());
                kvString.append('=');
                kvString.append(e.getValue());
            }
        }
        int maxCoprocessorNumber = 0;
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString(e.getKey().get()));
            if (!keyMatcher.matches()) continue;
            maxCoprocessorNumber = Math.max(Integer.parseInt(keyMatcher.group(1)), maxCoprocessorNumber);
        }
        String key = "coprocessor$" + Integer.toString(++maxCoprocessorNumber);
        String value = (jarFilePath == null ? "" : jarFilePath.toString()) + "|" + className + "|" + Integer.toString(priority) + "|" + kvString.toString();
        this.setValue(key, value);
    }

    public boolean hasCoprocessor(String className) {
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String clazz;
            Matcher valueMatcher;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString(e.getKey().get()));
            if (!keyMatcher.matches() || !(valueMatcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString(e.getValue().get()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
            return true;
        }
        return false;
    }

    public List<String> getCoprocessors() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            Matcher valueMatcher;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString(e.getKey().get()));
            if (!keyMatcher.matches() || !(valueMatcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString(e.getValue().get()))).matches()) continue;
            result.add(valueMatcher.group(2).trim());
        }
        return result;
    }

    public void removeCoprocessor(String className) {
        ImmutableBytesWritable match = null;
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String clazz;
            Matcher valueMatcher;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString(e.getKey().get()));
            if (!keyMatcher.matches() || !(valueMatcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString(e.getValue().get()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
            match = e.getKey();
            break;
        }
        if (match != null) {
            this.values.remove(match);
        }
    }

    public static Path getTableDir(Path rootdir, byte[] tableName) {
        return new Path(rootdir, Bytes.toString(tableName));
    }

    @Deprecated
    public void setOwner(User owner) {
        this.setOwnerString(owner != null ? owner.getShortName() : null);
    }

    @Deprecated
    public void setOwnerString(String ownerString) {
        if (ownerString != null) {
            this.setValue(OWNER_KEY, Bytes.toBytes(ownerString));
        } else {
            this.values.remove(OWNER_KEY);
        }
    }

    @Deprecated
    public String getOwnerString() {
        if (this.getValue(OWNER_KEY) != null) {
            return Bytes.toString(this.getValue(OWNER_KEY));
        }
        return null;
    }

    static {
        DEFAULT_VALUES.put(MAX_FILESIZE, String.valueOf(0x280000000L));
        DEFAULT_VALUES.put(READONLY, String.valueOf(false));
        DEFAULT_VALUES.put(MEMSTORE_FLUSHSIZE, String.valueOf(0x8000000L));
        DEFAULT_VALUES.put(DEFERRED_LOG_FLUSH, String.valueOf(false));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes(s)));
        }
        RESERVED_KEYWORDS.add(IS_ROOT_KEY);
        RESERVED_KEYWORDS.add(IS_META_KEY);
        ROOT_TABLEDESC = new HTableDescriptor(HConstants.ROOT_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setTimeToLive(Integer.MAX_VALUE).setScope(0)});
        META_TABLEDESC = new HTableDescriptor(HConstants.META_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setScope(0)});
    }
}

