/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.BaseConfigurable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class UserProvider
extends BaseConfigurable {
    private static final String USER_PROVIDER_CONF_KEY = "hbase.client.userprovider.class";

    public static UserProvider instantiate(Configuration conf) {
        Class clazz = conf.getClass(USER_PROVIDER_CONF_KEY, UserProvider.class, UserProvider.class);
        return (UserProvider)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    public static void setUserProviderForTesting(Configuration conf, Class<? extends UserProvider> provider) {
        conf.set(USER_PROVIDER_CONF_KEY, provider.getName());
    }

    public String getCurrentUserName() throws IOException {
        User user = this.getCurrent();
        return user == null ? null : user.getName();
    }

    public boolean isHBaseSecurityEnabled() {
        return User.isHBaseSecurityEnabled(this.getConf());
    }

    public User getCurrent() throws IOException {
        return User.getCurrent();
    }

    public User create(UserGroupInformation ugi) {
        return User.create(ugi);
    }

    public void login(String fileConfKey, String principalConfKey, String localhost) throws IOException {
        User.login(this.getConf(), fileConfKey, principalConfKey, localhost);
    }

    public boolean isHadoopSecurityEnabled() {
        return User.isSecurityEnabled();
    }
}

