/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;

public class ColumnCountGetFilter
extends FilterBase {
    private int limit = 0;
    private int count = 0;

    public ColumnCountGetFilter() {
    }

    public ColumnCountGetFilter(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (String)"limit be positive %s", (Object[])new Object[]{n});
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.count > this.limit;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        ++this.count;
        return this.filterAllRemaining() ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        int limit = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        return new ColumnCountGetFilter(limit);
    }

    public void readFields(DataInput in) throws IOException {
        this.limit = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.limit);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.limit;
    }
}

