/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.io.compress.Compressor;

public class EncodedDataBlock {
    private static final int BUFFER_SIZE = 4096;
    protected DataBlockEncoder dataBlockEncoder;
    ByteArrayOutputStream uncompressedOutputStream;
    ByteBuffer uncompressedBuffer;
    private byte[] cacheCompressData;
    private ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
    private boolean includesMemstoreTS;

    public EncodedDataBlock(DataBlockEncoder dataBlockEncoder, boolean includesMemstoreTS) {
        this.dataBlockEncoder = dataBlockEncoder;
        this.uncompressedOutputStream = new ByteArrayOutputStream(4096);
    }

    public void addKv(KeyValue kv) {
        this.cacheCompressData = null;
        this.uncompressedOutputStream.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
    }

    public Iterator<KeyValue> getIterator() {
        final int uncompressedSize = this.uncompressedOutputStream.size();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.getCompressedData());
        final DataInputStream dis = new DataInputStream(bais);
        return new Iterator<KeyValue>(){
            private ByteBuffer decompressedData = null;

            @Override
            public boolean hasNext() {
                if (this.decompressedData == null) {
                    return uncompressedSize > 0;
                }
                return this.decompressedData.hasRemaining();
            }

            @Override
            public KeyValue next() {
                if (this.decompressedData == null) {
                    try {
                        this.decompressedData = EncodedDataBlock.this.dataBlockEncoder.uncompressKeyValues(dis, EncodedDataBlock.this.includesMemstoreTS);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Problem with data block encoder, most likely it requested more bytes than are available.", e);
                    }
                    this.decompressedData.rewind();
                }
                int offset = this.decompressedData.position();
                KeyValue kv = new KeyValue(this.decompressedData.array(), offset);
                this.decompressedData.position(offset + kv.getLength());
                return kv;
            }

            @Override
            public void remove() {
                throw new NotImplementedException("remove() is not supported!");
            }

            public String toString() {
                return "Iterator of: " + EncodedDataBlock.this.dataBlockEncoder.getClass().getName();
            }
        };
    }

    public int getSize() {
        return this.getCompressedData().length;
    }

    public static int checkCompressedSize(Compressor compressor, byte[] buffer, int offset, int length) {
        byte[] compressedBuffer = new byte[buffer.length];
        compressor.setInput(buffer, offset, length);
        compressor.finish();
        int currentPos = 0;
        while (!compressor.finished()) {
            try {
                currentPos += compressor.compress(compressedBuffer, 0, compressedBuffer.length);
            }
            catch (IOException e) {
                throw new RuntimeException("For some reason compressor couldn't read data. It is likely a problem with " + compressor.getClass().getName(), e);
            }
        }
        return currentPos;
    }

    public int checkCompressedSize(Compressor compressor) {
        byte[] compressedBytes = this.getCompressedData();
        return EncodedDataBlock.checkCompressedSize(compressor, compressedBytes, 0, compressedBytes.length);
    }

    private byte[] getCompressedData() {
        if (this.cacheCompressData != null) {
            return this.cacheCompressData;
        }
        this.cacheCompressData = this.doCompressData();
        return this.cacheCompressData;
    }

    private ByteBuffer getUncompressedBuffer() {
        if (this.uncompressedBuffer == null || this.uncompressedBuffer.limit() < this.uncompressedOutputStream.size()) {
            this.uncompressedBuffer = ByteBuffer.wrap(this.uncompressedOutputStream.toByteArray());
        }
        return this.uncompressedBuffer;
    }

    public byte[] doCompressData() {
        this.compressedStream.reset();
        DataOutputStream dataOut = new DataOutputStream(this.compressedStream);
        try {
            this.dataBlockEncoder.compressKeyValues(dataOut, this.getUncompressedBuffer(), this.includesMemstoreTS);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Bug in decoding part of algorithm %s. Probably it requested more bytes than are available.", this.toString()), e);
        }
        return this.compressedStream.toByteArray();
    }

    public String toString() {
        return this.dataBlockEncoder.toString();
    }

    public byte[] getRawKeyValues() {
        return this.uncompressedOutputStream.toByteArray();
    }
}

