/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.util.StringUtils;

public final class TableSnapshotInputFormat
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final String SNAPSHOT_NAME_KEY = "hbase.mr.snapshot.input.name";
    private static final String TABLE_DIR_KEY = "hbase.mr.snapshot.input.table.dir";
    private static final String LOCALITY_CUTOFF_MULTIPLIER = "hbase.tablesnapshotinputformat.locality.cutoff.multiplier";
    private static final float DEFAULT_LOCALITY_CUTOFF_MULTIPLIER = 0.8f;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new TableSnapshotRegionRecordReader();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        Path snapshotDir;
        Configuration conf = job.getConfiguration();
        String snapshotName = TableSnapshotInputFormat.getSnapshotName(job.getConfiguration());
        Path rootDir = new Path(conf.get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(conf);
        Set<String> snapshotRegionNames = SnapshotReferenceUtil.getSnapshotRegionNames(fs, snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir));
        if (snapshotRegionNames == null) {
            throw new IllegalArgumentException("Snapshot is empty");
        }
        HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(fs, snapshotDir);
        Scan scan = TableMapReduceUtil.convertStringToScan(conf.get("hbase.mapreduce.scan"));
        Path tableDir = new Path(conf.get(TABLE_DIR_KEY));
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(snapshotRegionNames.size());
        for (String regionName : snapshotRegionNames) {
            Path regionDir = new Path(snapshotDir, regionName);
            HRegionInfo hri = HRegion.loadDotRegionInfoFileContent(fs, regionDir);
            if (!this.keyRangesOverlap(scan.getStartRow(), scan.getStopRow(), hri.getStartKey(), hri.getEndKey())) continue;
            List<String> hosts = this.getBestLocations(conf, HRegion.computeHDFSBlocksDistribution(conf, htd, hri.getEncodedName(), tableDir));
            int len = Math.min(3, hosts.size());
            hosts = hosts.subList(0, len);
            splits.add(new TableSnapshotRegionSplit(regionName, hosts));
        }
        return splits;
    }

    private boolean keyRangesOverlap(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }

    @VisibleForTesting
    List<String> getBestLocations(Configuration conf, HDFSBlocksDistribution blockDistribution) {
        ArrayList<String> locations = new ArrayList<String>(3);
        HDFSBlocksDistribution.HostAndWeight[] hostAndWeights = blockDistribution.getTopHostsWithWeights();
        if (hostAndWeights.length == 0) {
            return locations;
        }
        HDFSBlocksDistribution.HostAndWeight topHost = hostAndWeights[0];
        locations.add(topHost.getHost());
        double cutoffMultiplier = conf.getFloat(LOCALITY_CUTOFF_MULTIPLIER, 0.8f);
        double filterWeight = (double)topHost.getWeight() * cutoffMultiplier;
        for (int i = 1; i < hostAndWeights.length && (double)hostAndWeights[i].getWeight() >= filterWeight; ++i) {
            locations.add(hostAndWeights[i].getHost());
        }
        return locations;
    }

    public static void setInput(Job job, String snapshotName, Path restoreDir) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.set(SNAPSHOT_NAME_KEY, snapshotName);
        Path rootDir = new Path(conf.get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(conf);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(fs, snapshotDir);
        Path tableDir = new Path(restoreDir, htd.getNameAsString());
        conf.set(TABLE_DIR_KEY, tableDir.toString());
        MonitoredTask status = TaskMonitor.get().createStatus("Restoring  snapshot '" + snapshotName + "' to directory " + tableDir);
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher();
        RestoreSnapshotHelper helper = new RestoreSnapshotHelper(conf, fs, snapshotDesc, snapshotDir, htd, tableDir, monitor, status);
        helper.restoreHdfsRegions();
    }

    private static String getSnapshotName(Configuration conf) {
        String snapshotName = conf.get(SNAPSHOT_NAME_KEY);
        if (snapshotName == null) {
            throw new IllegalArgumentException("Snapshot name must be provided");
        }
        return snapshotName;
    }

    public static final class TableSnapshotRegionRecordReader
    extends RecordReader<ImmutableBytesWritable, Result> {
        static final Log LOG = LogFactory.getLog(TableSnapshotRegionRecordReader.class);
        private static final String HBASE_COUNTER_GROUP_NAME = "HBase Counters";
        private TableSnapshotRegionSplit split;
        private HRegion region;
        private Scan scan;
        private RegionScanner scanner;
        private List<KeyValue> values;
        private Result result = null;
        private ImmutableBytesWritable row = null;
        private boolean more;
        private ScanMetrics scanMetrics = null;
        private TaskAttemptContext context = null;
        private Method getCounter = null;

        public void initialize(InputSplit aSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.split = (TableSnapshotRegionSplit)aSplit;
            Path rootDir = new Path(conf.get("hbase.rootdir"));
            FileSystem fs = rootDir.getFileSystem(conf);
            String snapshotName = TableSnapshotInputFormat.getSnapshotName(conf);
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
            String regionName = this.split.regionName;
            Path regionDir = new Path(snapshotDir, regionName);
            HRegionInfo hri = HRegion.loadDotRegionInfoFileContent(fs, regionDir);
            this.scan = TableMapReduceUtil.convertStringToScan(conf.get("hbase.mapreduce.scan"));
            this.scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
            this.scan.setCacheBlocks(false);
            HTableDescriptor htd = FSTableDescriptors.getTableDescriptor(fs, snapshotDir);
            Path tableDir = new Path(conf.get(TableSnapshotInputFormat.TABLE_DIR_KEY));
            this.region = this.openRegion(tableDir, fs, conf, hri, htd);
            this.scanner = this.region.getScanner(this.scan);
            this.values = new ArrayList<KeyValue>();
            this.more = true;
            this.scanMetrics = new ScanMetrics();
            if (context != null) {
                this.context = context;
                this.getCounter = this.retrieveGetCounterWithStringsParams(context);
            }
            this.region.startRegionOperation();
        }

        private HRegion openRegion(Path tableDir, FileSystem fs, Configuration conf, HRegionInfo hri, HTableDescriptor htd) throws IOException {
            HRegion r = HRegion.newHRegion(tableDir, null, fs, conf, hri, htd, null);
            r.initialize(null);
            return r;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.values.clear();
            if (!this.more) {
                this.updateCounters();
                return false;
            }
            this.more = this.scanner.nextRaw(this.values, this.scan.getBatch(), null);
            if (this.values.isEmpty()) {
                this.updateCounters();
                return false;
            }
            for (KeyValue kv : this.values) {
                this.scanMetrics.countOfBytesInResults.inc((long)kv.getLength());
            }
            this.result = new Result(this.values);
            if (this.row == null) {
                this.row = new ImmutableBytesWritable();
            }
            this.row.set(this.result.getRow());
            return true;
        }

        public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
            return this.row;
        }

        public Result getCurrentValue() throws IOException, InterruptedException {
            return this.result;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.scanner != null) {
                    this.scanner.close();
                }
            }
            finally {
                if (this.region != null) {
                    this.region.closeRegionOperation();
                    this.region.close(true);
                }
            }
        }

        private void updateCounters() throws IOException {
            if (this.getCounter == null) {
                return;
            }
            MetricsTimeVaryingLong[] mlvs = this.scanMetrics.getMetricsTimeVaryingLongArray();
            try {
                for (MetricsTimeVaryingLong mlv : mlvs) {
                    Counter ct = (Counter)this.getCounter.invoke((Object)this.context, HBASE_COUNTER_GROUP_NAME, mlv.getName());
                    ct.increment(mlv.getCurrentIntervalValue());
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("can't update counter." + StringUtils.stringifyException((Throwable)e)));
            }
        }

        private Method retrieveGetCounterWithStringsParams(TaskAttemptContext context) throws IOException {
            Method m = null;
            try {
                m = context.getClass().getMethod("getCounter", String.class, String.class);
            }
            catch (SecurityException e) {
                throw new IOException("Failed test for getCounter", e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return m;
        }
    }

    public static final class TableSnapshotRegionSplit
    extends InputSplit
    implements Writable {
        private String regionName;
        private String[] locations;

        public TableSnapshotRegionSplit() {
        }

        public TableSnapshotRegionSplit(String regionName, List<String> locationList) {
            this.regionName = regionName;
            List<String> list = locationList.size() > 1 ? locationList.subList(0, 1) : locationList;
            this.locations = list.toArray(new String[list.size()]);
        }

        public long getLength() throws IOException, InterruptedException {
            return this.locations.length;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return this.locations;
        }

        public void readFields(DataInput in) throws IOException {
            this.regionName = Text.readString((DataInput)in);
            int locLength = in.readInt();
            this.locations = new String[locLength];
            for (int i = 0; i < locLength; ++i) {
                this.locations[i] = Text.readString((DataInput)in);
            }
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.regionName);
            out.writeInt(this.locations.length);
            for (String l : this.locations) {
                Text.writeString((DataOutput)out, (String)l);
            }
        }
    }
}

