/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;

public class RegionPlan
implements Comparable<RegionPlan> {
    private final HRegionInfo hri;
    private final ServerName source;
    private ServerName dest;

    public RegionPlan(HRegionInfo hri, ServerName source, ServerName dest) {
        this.hri = hri;
        this.source = source;
        this.dest = dest;
    }

    public void setDestination(ServerName dest) {
        this.dest = dest;
    }

    public ServerName getSource() {
        return this.source;
    }

    public ServerName getDestination() {
        return this.dest;
    }

    public String getRegionName() {
        return this.hri.getEncodedName();
    }

    public HRegionInfo getRegionInfo() {
        return this.hri;
    }

    @Override
    public int compareTo(RegionPlan o) {
        return this.getRegionName().compareTo(o.getRegionName());
    }

    public String toString() {
        return "hri=" + this.hri.getRegionNameAsString() + ", src=" + (this.source == null ? "" : this.source.toString()) + ", dest=" + (this.dest == null ? "" : this.dest.toString());
    }
}

