/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.zookeeper.KeeperException;

public class MetaServerShutdownHandler
extends ServerShutdownHandler {
    private final boolean carryingRoot;
    private final boolean carryingMeta;
    private static final Log LOG = LogFactory.getLog(MetaServerShutdownHandler.class);

    public MetaServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, boolean carryingRoot, boolean carryingMeta) {
        super(server, services, deadServers, serverName, EventHandler.EventType.M_META_SERVER_SHUTDOWN, true);
        this.carryingRoot = carryingRoot;
        this.carryingMeta = carryingMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        boolean gotException = true;
        try {
            try {
                if (this.shouldSplitHlog) {
                    if (this.services.shouldSplitMetaSeparately()) {
                        LOG.info((Object)("Splitting META logs for " + this.serverName));
                        this.services.getMasterFileSystem().splitMetaLog(this.serverName);
                    } else {
                        LOG.info((Object)("Splitting all logs for " + this.serverName));
                        this.services.getMasterFileSystem().splitAllLogs(this.serverName);
                    }
                }
            }
            catch (IOException ioe) {
                this.services.getExecutorService().submit(this);
                this.deadServers.add(this.serverName);
                throw new IOException("failed log splitting for " + this.serverName + ", will retry", ioe);
            }
            if (this.isCarryingRoot()) {
                if (this.services.getAssignmentManager().isCarryingRoot(this.serverName)) {
                    LOG.info((Object)("Server " + this.serverName + " was carrying ROOT. Trying to assign."));
                    this.services.getAssignmentManager().regionOffline(HRegionInfo.ROOT_REGIONINFO);
                    this.verifyAndAssignRootWithRetries();
                } else {
                    LOG.info((Object)"ROOT has been assigned to otherwhere, skip assigning.");
                }
            }
            if (!this.services.isServerShutdownHandlerEnabled()) {
                this.services.getExecutorService().submit(this);
                this.deadServers.add(this.serverName);
                return;
            }
            if (this.isCarryingMeta()) {
                if (this.services.getAssignmentManager().isCarryingMeta(this.serverName)) {
                    LOG.info((Object)("Server " + this.serverName + " was carrying META. Trying to assign."));
                    this.services.getAssignmentManager().regionOffline(HRegionInfo.FIRST_META_REGIONINFO);
                    this.services.getAssignmentManager().assignMeta();
                } else {
                    LOG.info((Object)"META has been assigned to otherwhere, skip assigning.");
                }
            }
            gotException = false;
        }
        finally {
            if (gotException) {
                this.deadServers.finish(this.serverName);
            }
        }
        super.process();
    }

    private void verifyAndAssignRoot() throws InterruptedException, IOException, KeeperException {
        long timeout = this.server.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        if (!this.server.getCatalogTracker().verifyRootRegionLocation(timeout)) {
            this.services.getAssignmentManager().assignRoot();
        } else {
            if (this.serverName.equals(this.server.getCatalogTracker().getRootLocation())) {
                throw new IOException("-ROOT- is onlined on the dead server " + this.serverName);
            }
            LOG.info((Object)("Skip assigning -ROOT-, because it is online on the " + this.server.getCatalogTracker().getRootLocation()));
        }
    }

    private void verifyAndAssignRootWithRetries() throws IOException {
        int iTimes = this.server.getConfiguration().getInt("hbase.catalog.verification.retries", 10);
        long waitTime = this.server.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        int iFlag = 0;
        while (true) {
            try {
                this.verifyAndAssignRoot();
            }
            catch (KeeperException e) {
                this.server.abort("In server shutdown processing, assigning root", e);
                throw new IOException("Aborting", e);
            }
            catch (Exception e) {
                if (iFlag >= iTimes) {
                    this.server.abort("verifyAndAssignRoot failed after" + iTimes + " times retries, aborting", e);
                    throw new IOException("Aborting", e);
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    LOG.warn((Object)"Interrupted when is the thread sleep", (Throwable)e1);
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted", e1);
                }
                ++iFlag;
                continue;
            }
            break;
        }
    }

    @Override
    boolean isCarryingRoot() {
        return this.carryingRoot;
    }

    @Override
    boolean isCarryingMeta() {
        return this.carryingMeta;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }
}

