/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class ReplicationSourceMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private MetricsRegistry registry = new MetricsRegistry();
    private ReplicationStatistics replicationStatistics;
    public final MetricsRate shippedOpsRate = new MetricsRate("shippedOpsRate", this.registry);
    public final MetricsRate shippedKBRate = new MetricsRate("shippedBytesRate", this.registry);
    public final MetricsRate shippedBatchesRate = new MetricsRate("shippedBatchesRate", this.registry);
    public final MetricsRate logEditsReadRate = new MetricsRate("logEditsReadRate", this.registry);
    public final MetricsRate logEditsFilteredRate = new MetricsRate("logEditsFilteredRate", this.registry);
    private final MetricsLongValue ageOfLastShippedOp = new MetricsLongValue("ageOfLastShippedOp", this.registry);
    public final MetricsIntValue sizeOfLogQueue = new MetricsIntValue("sizeOfLogQueue", this.registry);
    private long lastTimestampForAge = System.currentTimeMillis();

    public ReplicationSourceMetrics(String id) {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        String name = Thread.currentThread().getName();
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"replication");
        this.metricsRecord.setTag("RegionServer", name);
        context.registerUpdater((Updater)this);
        try {
            id = URLEncoder.encode(id, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            id = "CAN'T ENCODE UTF8";
        }
        this.replicationStatistics = new ReplicationStatistics(this.registry, "ReplicationSource for " + id);
    }

    public void setAgeOfLastShippedOp(long timestamp) {
        this.lastTimestampForAge = timestamp;
        this.ageOfLastShippedOp.set(System.currentTimeMillis() - this.lastTimestampForAge);
    }

    public void refreshAgeOfLastShippedOp() {
        this.setAgeOfLastShippedOp(this.lastTimestampForAge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext metricsContext) {
        ReplicationSourceMetrics replicationSourceMetrics = this;
        synchronized (replicationSourceMetrics) {
            this.refreshAgeOfLastShippedOp();
            this.shippedOpsRate.pushMetric(this.metricsRecord);
            this.shippedBatchesRate.pushMetric(this.metricsRecord);
            this.shippedKBRate.pushMetric(this.metricsRecord);
            this.logEditsReadRate.pushMetric(this.metricsRecord);
            this.logEditsFilteredRate.pushMetric(this.metricsRecord);
            this.ageOfLastShippedOp.pushMetric(this.metricsRecord);
            this.sizeOfLogQueue.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void stopReportMetrics() {
        if (this.replicationStatistics != null) {
            this.replicationStatistics.unRegisterMBean();
        }
    }
}

