/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.ClassLoaderBase;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class CoprocessorClassLoader
extends ClassLoaderBase {
    private static final Log LOG = LogFactory.getLog(CoprocessorClassLoader.class);
    private static final String TMP_JARS_DIR = File.separator + "jars" + File.separator + "tmp" + File.separator;
    private static final ConcurrentMap<Path, CoprocessorClassLoader> classLoadersCache = new MapMaker().concurrencyLevel(3).weakValues().makeMap();
    private static final String[] CLASS_PREFIX_EXEMPTIONS = new String[]{"com.sun.", "launcher.", "java.", "javax.", "org.ietf", "org.omg", "org.w3c", "org.xml", "sunw.", "org.apache.commons.logging", "org.apache.log4j", "com.hadoop", "org.apache.hadoop", "org.apache.zookeeper"};
    private static final Pattern[] RESOURCE_LOAD_PARENT_FIRST_PATTERNS = new Pattern[]{Pattern.compile("^[^-]+-default\\.xml$")};

    private CoprocessorClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Path path, String pathPrefix, Configuration conf) throws IOException {
        if (path == null) {
            throw new IOException("The jar path is null");
        }
        if (!path.toString().endsWith(".jar")) {
            throw new IOException(path.toString() + ": not a jar file?");
        }
        String parentDirPath = conf.get("hbase.local.dir", "/tmp/hbase-local-dir") + TMP_JARS_DIR;
        File parentDir = new File(parentDirPath);
        if (!parentDir.mkdirs() && !parentDir.isDirectory()) {
            throw new RuntimeException("Failed to create local dir " + parentDir.getPath() + ", CoprocessorClassLoader failed to init");
        }
        FileSystem fs = path.getFileSystem(conf);
        File dst = new File(parentDir, "." + pathPrefix + "." + path.getName() + "." + System.currentTimeMillis() + ".jar");
        fs.copyToLocalFile(path, new Path(dst.toString()));
        dst.deleteOnExit();
        this.addURL(dst.getCanonicalFile().toURI().toURL());
        JarFile jarFile = new JarFile(dst.toString());
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().matches("[/]?lib/[^/]+\\.jar")) continue;
                File file = new File(parentDir, "." + pathPrefix + "." + path.getName() + "." + System.currentTimeMillis() + "." + entry.getName().substring(5));
                IOUtils.copyBytes((InputStream)jarFile.getInputStream(entry), (OutputStream)new FileOutputStream(file), (Configuration)conf, (boolean)true);
                file.deleteOnExit();
                this.addURL(file.toURI().toURL());
            }
        }
        finally {
            jarFile.close();
        }
    }

    public static CoprocessorClassLoader getIfCached(Path path) {
        if (path == null) {
            return null;
        }
        return (CoprocessorClassLoader)classLoadersCache.get(path);
    }

    public static Collection<? extends ClassLoader> getAllCached() {
        return classLoadersCache.values();
    }

    public static void clearCache() {
        classLoadersCache.clear();
    }

    public static CoprocessorClassLoader getClassLoader(Path path, final ClassLoader parent, String pathPrefix, Configuration conf) throws IOException {
        CoprocessorClassLoader cl = CoprocessorClassLoader.getIfCached(path);
        if (cl != null) {
            LOG.debug((Object)("Found classloader " + cl + "for " + path.toString()));
            return cl;
        }
        cl = AccessController.doPrivileged(new PrivilegedAction<CoprocessorClassLoader>(){

            @Override
            public CoprocessorClassLoader run() {
                return new CoprocessorClassLoader(parent);
            }
        });
        cl.init(path, pathPrefix, conf);
        CoprocessorClassLoader prev = classLoadersCache.putIfAbsent(path, cl);
        if (prev != null) {
            cl = prev;
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isClassExempt(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping exempt class " + name + " - delegating directly to parent"));
            }
            return this.parent.loadClass(name);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clasz = this.findLoadedClass(name);
            if (clasz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class " + name + " already loaded"));
                }
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Finding class: " + name));
                    }
                    clasz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Class " + name + " not found - delegating to parent"));
                    }
                    try {
                        clasz = this.parent.loadClass(name);
                    }
                    catch (ClassNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Class " + name + " not found in parent loader"));
                        }
                        throw e2;
                    }
                }
            }
            return clasz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL resource = null;
        boolean parentLoaded = false;
        if (this.loadResourceUsingParentFirst(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking parent first for resource " + name));
            }
            resource = super.getResource(name);
            parentLoaded = true;
        }
        if (resource == null) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                resource = this.findResource(name);
                if (resource == null && !parentLoaded) {
                    resource = super.getResource(name);
                }
            }
        }
        return resource;
    }

    protected boolean isClassExempt(String name) {
        for (String exemptPrefix : CLASS_PREFIX_EXEMPTIONS) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadResourceUsingParentFirst(String name) {
        for (Pattern resourcePattern : RESOURCE_LOAD_PARENT_FIRST_PATTERNS) {
            if (!resourcePattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

