/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseClientIF;
import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseMemcachedConnection;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.ObservedException;
import com.couchbase.client.ObservedModifiedException;
import com.couchbase.client.ObservedTimeoutException;
import com.couchbase.client.ViewConnection;
import com.couchbase.client.clustermanager.FlushResponse;
import com.couchbase.client.internal.HttpFuture;
import com.couchbase.client.internal.ReplicaGetFuture;
import com.couchbase.client.internal.ViewFuture;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.DesignDocFetcherOperation;
import com.couchbase.client.protocol.views.DesignDocFetcherOperationImpl;
import com.couchbase.client.protocol.views.DesignDocOperationImpl;
import com.couchbase.client.protocol.views.DesignDocument;
import com.couchbase.client.protocol.views.DocsOperationImpl;
import com.couchbase.client.protocol.views.HttpOperation;
import com.couchbase.client.protocol.views.InvalidViewException;
import com.couchbase.client.protocol.views.NoDocsOperationImpl;
import com.couchbase.client.protocol.views.Paginator;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.ReducedOperationImpl;
import com.couchbase.client.protocol.views.SpatialView;
import com.couchbase.client.protocol.views.SpatialViewFetcherOperation;
import com.couchbase.client.protocol.views.SpatialViewFetcherOperationImpl;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewFetcherOperation;
import com.couchbase.client.protocol.views.ViewFetcherOperationImpl;
import com.couchbase.client.protocol.views.ViewOperation;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ObserveResponse;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.PersistTo;
import net.spy.memcached.ReplicateTo;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.ObserveOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.ReplicaGetOperation;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.ops.UnlockOperation;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;

public class CouchbaseClient
extends MemcachedClient
implements CouchbaseClientIF,
Reconfigurable {
    private static final String MODE_PRODUCTION = "production";
    private static final String MODE_DEVELOPMENT = "development";
    private static final String DEV_PREFIX = "dev_";
    private static final String PROD_PREFIX = "";
    public static final String MODE_PREFIX;
    private static final String MODE_ERROR;
    private ViewConnection vconn = null;
    protected volatile boolean reconfiguring = false;
    private final CouchbaseConnectionFactory cbConnFactory;

    public CouchbaseClient(List<URI> baseList, String bucketName, String pwd) throws IOException {
        this(new CouchbaseConnectionFactory(baseList, bucketName, pwd));
    }

    public CouchbaseClient(List<URI> baseList, String bucketName, String user, String pwd) throws IOException {
        this(new CouchbaseConnectionFactory(baseList, bucketName, pwd));
    }

    public CouchbaseClient(CouchbaseConnectionFactory cf) throws IOException {
        super((ConnectionFactory)cf, AddrUtil.getAddresses(cf.getVBucketConfig().getServers()));
        this.cbConnFactory = cf;
        if (cf.getVBucketConfig().getConfigType() == ConfigType.COUCHBASE) {
            List addrs = AddrUtil.getAddressesFromURL(cf.getVBucketConfig().getCouchServers());
            this.vconn = cf.createViewConnection(addrs);
        }
        this.getLogger().info((Object)MODE_ERROR);
        cf.getConfigurationProvider().subscribe(cf.getBucketName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        this.reconfiguring = true;
        if (bucket.isNotUpdating()) {
            this.getLogger().info((Object)"Bucket configuration is disconnected from cluster configuration updates, attempting to reconnect.");
            CouchbaseConnectionFactory cbcf = (CouchbaseConnectionFactory)this.connFactory;
            cbcf.requestConfigReconnect(cbcf.getBucketName(), this);
            cbcf.checkConfigUpdate();
        }
        try {
            this.cbConnFactory.getConfigurationProvider().updateBucket(this.cbConnFactory.getBucketName(), bucket);
            if (this.vconn != null) {
                this.vconn.reconfigure(bucket);
            }
            if (this.mconn instanceof CouchbaseConnection) {
                CouchbaseConnection cbConn = (CouchbaseConnection)this.mconn;
                cbConn.reconfigure(bucket);
            } else {
                CouchbaseMemcachedConnection cbMConn = (CouchbaseMemcachedConnection)this.mconn;
                cbMConn.reconfigure(bucket);
            }
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warn((Object)"Failed to reconfigure client, staying with previous configuration.", (Throwable)ex);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    @Override
    public HttpFuture<View> asyncGetView(String designDocumentName, String viewName) {
        CouchbaseConnectionFactory factory = (CouchbaseConnectionFactory)this.connFactory;
        designDocumentName = MODE_PREFIX + designDocumentName;
        String bucket = factory.getBucketName();
        String uri = "/" + bucket + "/_design/" + designDocumentName;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<View> crv = new HttpFuture<View>(couchLatch, factory.getViewTimeout());
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        ViewFetcherOperationImpl op = new ViewFetcherOperationImpl((HttpRequest)request, bucket, designDocumentName, viewName, new ViewFetcherOperation.ViewFetcherCallback(){
            private View view = null;

            public void receivedStatus(OperationStatus status) {
                crv.set(this.view, status);
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(View v) {
                this.view = v;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        assert (crv != null) : "Problem retrieving view";
        return crv;
    }

    @Override
    public HttpFuture<SpatialView> asyncGetSpatialView(String designDocumentName, String viewName) {
        CouchbaseConnectionFactory factory = (CouchbaseConnectionFactory)this.connFactory;
        designDocumentName = MODE_PREFIX + designDocumentName;
        String bucket = factory.getBucketName();
        String uri = "/" + bucket + "/_design/" + designDocumentName;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<SpatialView> crv = new HttpFuture<SpatialView>(couchLatch, factory.getViewTimeout());
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SpatialViewFetcherOperationImpl op = new SpatialViewFetcherOperationImpl((HttpRequest)request, bucket, designDocumentName, viewName, new SpatialViewFetcherOperation.ViewFetcherCallback(){
            private SpatialView view = null;

            public void receivedStatus(OperationStatus status) {
                crv.set(this.view, status);
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(SpatialView v) {
                this.view = v;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        assert (crv != null) : "Problem retrieving spatial view";
        return crv;
    }

    @Override
    public HttpFuture<DesignDocument> asyncGetDesignDocument(String designDocumentName) {
        designDocumentName = MODE_PREFIX + designDocumentName;
        String bucket = ((CouchbaseConnectionFactory)this.connFactory).getBucketName();
        String uri = "/" + bucket + "/_design/" + designDocumentName;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<DesignDocument> crv = new HttpFuture<DesignDocument>(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        DesignDocFetcherOperationImpl op = new DesignDocFetcherOperationImpl((HttpRequest)request, designDocumentName, new DesignDocFetcherOperation.DesignDocFetcherCallback(){
            private DesignDocument design = null;

            public void receivedStatus(OperationStatus status) {
                crv.set(this.design, status);
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(DesignDocument d) {
                this.design = d;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public View getView(String designDocumentName, String viewName) {
        try {
            View view = this.asyncGetView(designDocumentName, viewName).get();
            if (view == null) {
                throw new InvalidViewException("Could not load view \"" + viewName + "\" for design doc \"" + designDocumentName + "\"");
            }
            return view;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted getting views", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed getting views", e);
        }
    }

    @Override
    public SpatialView getSpatialView(String designDocumentName, String viewName) {
        try {
            SpatialView view = this.asyncGetSpatialView(designDocumentName, viewName).get();
            if (view == null) {
                throw new InvalidViewException("Could not load spatial view \"" + viewName + "\" for design doc \"" + designDocumentName + "\"");
            }
            return view;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted getting spatial view", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed getting views", e);
        }
    }

    @Override
    public DesignDocument getDesignDocument(String designDocumentName) {
        try {
            DesignDocument design = this.asyncGetDesignDocument(designDocumentName).get();
            if (design == null) {
                throw new InvalidViewException("Could not load design document \"" + designDocumentName + "\"");
            }
            return design;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted getting design document", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed getting design document", e);
        }
    }

    @Override
    public Boolean createDesignDoc(DesignDocument doc) {
        try {
            return this.asyncCreateDesignDoc(doc).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted creating design document", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed creating design document", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed creating design document", e);
        }
    }

    @Override
    public HttpFuture<Boolean> asyncCreateDesignDoc(String name, String value) throws UnsupportedEncodingException {
        this.getLogger().info((Object)("Creating Design Document:" + name));
        String bucket = ((CouchbaseConnectionFactory)this.connFactory).getBucketName();
        String uri = "/" + bucket + "/_design/" + MODE_PREFIX + name;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<Boolean> crv = new HttpFuture<Boolean>(couchLatch, 60000L);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("PUT", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
        StringEntity entity = new StringEntity(value);
        request.setEntity((HttpEntity)entity);
        DesignDocOperationImpl op = new DesignDocOperationImpl((HttpRequest)request, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                crv.set(status.getMessage().equals("Error Code: 201"), status);
            }

            public void complete() {
                couchLatch.countDown();
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public HttpFuture<Boolean> asyncCreateDesignDoc(DesignDocument doc) throws UnsupportedEncodingException {
        return this.asyncCreateDesignDoc(doc.getName(), doc.toJson());
    }

    @Override
    public Boolean deleteDesignDoc(String name) {
        try {
            return this.asyncDeleteDesignDoc(name).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted deleting design document", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed deleting design document", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed deleting design document", e);
        }
    }

    @Override
    public HttpFuture<Boolean> asyncDeleteDesignDoc(String name) throws UnsupportedEncodingException {
        this.getLogger().info((Object)("Deleting Design Document:" + name));
        String bucket = ((CouchbaseConnectionFactory)this.connFactory).getBucketName();
        String uri = "/" + bucket + "/_design/" + MODE_PREFIX + name;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<Boolean> crv = new HttpFuture<Boolean>(couchLatch, 60000L);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("DELETE", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
        DesignDocOperationImpl op = new DesignDocOperationImpl((HttpRequest)request, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                crv.set(status.getMessage().equals("Error Code: 200"), status);
            }

            public void complete() {
                couchLatch.countDown();
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public HttpFuture<ViewResponse> asyncQuery(AbstractView view, Query query) {
        if (view.hasReduce() && !query.getArgs().containsKey("reduce")) {
            query.setReduce(true);
        }
        if (query.willReduce()) {
            return this.asyncQueryAndReduce(view, query);
        }
        if (query.willIncludeDocs()) {
            return this.asyncQueryAndIncludeDocs(view, query);
        }
        return this.asyncQueryAndExcludeDocs(view, query);
    }

    private HttpFuture<ViewResponse> asyncQueryAndIncludeDocs(AbstractView view, Query query) {
        assert (view != null) : "Who passed me a null view";
        assert (query != null) : "who passed me a null query";
        String viewUri = view.getURI();
        String queryToRun = query.toString();
        assert (viewUri != null) : "view URI seems to be null";
        assert (queryToRun != null) : "query seems to be null";
        String uri = viewUri + queryToRun;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        int timeout = ((CouchbaseConnectionFactory)this.connFactory).getViewTimeout();
        final ViewFuture crv = new ViewFuture(couchLatch, timeout, view);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        DocsOperationImpl op = new DocsOperationImpl((HttpRequest)request, view, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            public void receivedStatus(OperationStatus status) {
                if (this.vr != null) {
                    LinkedList<String> ids = new LinkedList<String>();
                    Iterator<ViewRow> itr = this.vr.iterator();
                    while (itr.hasNext()) {
                        ids.add(itr.next().getId());
                    }
                    crv.set(this.vr, (BulkFuture<Map<String, Object>>)CouchbaseClient.this.asyncGetBulk(ids), status);
                } else {
                    crv.set(null, null, status);
                }
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    private HttpFuture<ViewResponse> asyncQueryAndExcludeDocs(AbstractView view, Query query) {
        String uri = view.getURI() + query.toString();
        final CountDownLatch couchLatch = new CountDownLatch(1);
        int timeout = ((CouchbaseConnectionFactory)this.connFactory).getViewTimeout();
        final HttpFuture<ViewResponse> crv = new HttpFuture<ViewResponse>(couchLatch, timeout);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        NoDocsOperationImpl op = new NoDocsOperationImpl((HttpRequest)request, view, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            public void receivedStatus(OperationStatus status) {
                crv.set(this.vr, status);
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    private HttpFuture<ViewResponse> asyncQueryAndReduce(AbstractView view, Query query) {
        if (!view.hasReduce()) {
            throw new RuntimeException("This view doesn't contain a reduce function");
        }
        String uri = view.getURI() + query.toString();
        final CountDownLatch couchLatch = new CountDownLatch(1);
        int timeout = ((CouchbaseConnectionFactory)this.connFactory).getViewTimeout();
        final HttpFuture<ViewResponse> crv = new HttpFuture<ViewResponse>(couchLatch, timeout);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        ReducedOperationImpl op = new ReducedOperationImpl((HttpRequest)request, view, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            public void receivedStatus(OperationStatus status) {
                crv.set(this.vr, status);
            }

            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public ViewResponse query(AbstractView view, Query query) {
        try {
            return this.asyncQuery(view, query).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while accessing the view", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Failed to access the view", e);
        }
    }

    @Override
    public Paginator paginatedQuery(View view, Query query, int docsPerPage) {
        return new Paginator(this, view, query, docsPerPage);
    }

    public void addOp(HttpOperation op) {
        if (this.vconn != null) {
            this.vconn.checkState();
            this.vconn.addOp(op);
        }
    }

    public <T> OperationFuture<CASValue<T>> asyncGetAndLock(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout);
        GetlOperation op = this.opFact.getl(key, exp, new GetlOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                if (!status.isSuccess()) {
                    this.val = new CASValue(-1L, null);
                }
                rv.set(this.val, status);
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                assert (cas > 0L) : "CAS was less than zero:  " + cas;
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public OperationFuture<CASValue<Object>> asyncGetAndLock(String key, int exp) {
        return this.asyncGetAndLock(key, exp, (Transcoder<T>)this.transcoder);
    }

    @Override
    public Object getFromReplica(String key) {
        return this.getFromReplica(key, this.transcoder);
    }

    @Override
    public <T> T getFromReplica(String key, Transcoder<T> tc) {
        try {
            return this.asyncGetFromReplica(key, tc).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", (Throwable)e);
        }
    }

    @Override
    public ReplicaGetFuture<Object> asyncGetFromReplica(String key) {
        return this.asyncGetFromReplica(key, this.transcoder);
    }

    @Override
    public <T> ReplicaGetFuture<T> asyncGetFromReplica(final String key, final Transcoder<T> tc) {
        int replicaCount = this.cbConnFactory.getVBucketConfig().getReplicasCount();
        if (replicaCount == 0) {
            throw new RuntimeException("Currently, there is no replica available for the given key (\"" + key + "\").");
        }
        ArrayList futures = new ArrayList();
        for (int index = 0; index < replicaCount; ++index) {
            final CountDownLatch latch = new CountDownLatch(1);
            final GetFuture rv = new GetFuture(latch, this.operationTimeout, key);
            ReplicaGetOperation op = this.opFact.replicaGet(key, index, new ReplicaGetOperation.Callback(){
                private Future<T> val = null;

                public void receivedStatus(OperationStatus status) {
                    rv.set(this.val, status);
                }

                public void gotData(String k, int flags, byte[] data) {
                    assert (key.equals(k)) : "Wrong key returned";
                    this.val = CouchbaseClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize()));
                }

                public void complete() {
                    latch.countDown();
                }
            });
            rv.setOperation((Operation)op);
            this.mconn.enqueueOperation(key, (Operation)op);
            futures.add(rv);
        }
        return new ReplicaGetFuture(this.operationTimeout, futures);
    }

    @Override
    public <T> CASValue<T> getAndLock(String key, int exp, Transcoder<T> tc) {
        try {
            return (CASValue)this.asyncGetAndLock(key, exp, tc).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", (Throwable)e);
        }
    }

    @Override
    public CASValue<Object> getAndLock(String key, int exp) {
        return this.getAndLock(key, exp, this.transcoder);
    }

    @Override
    public <T> OperationFuture<Boolean> asyncUnlock(String key, long casId, Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout);
        UnlockOperation op = this.opFact.unlock(key, casId, new OperationCallback(){

            public void receivedStatus(OperationStatus s) {
                rv.set((Object)s.isSuccess(), s);
            }

            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    @Override
    public OperationFuture<Boolean> asyncUnlock(String key, long casId) {
        return this.asyncUnlock(key, casId, this.transcoder);
    }

    @Override
    public <T> Boolean unlock(String key, long casId, Transcoder<T> tc) {
        try {
            return (Boolean)this.asyncUnlock(key, casId, tc).get(this.operationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw (CancellationException)e.getCause();
            }
            throw new RuntimeException("Exception waiting for value", e);
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("Timeout waiting for value", (Throwable)e);
        }
    }

    @Override
    public Boolean unlock(String key, long casId) {
        return this.unlock(key, casId, this.transcoder);
    }

    @Override
    public OperationFuture<Boolean> delete(String key, PersistTo req, ReplicateTo rep) {
        if (this.mconn instanceof CouchbaseMemcachedConnection) {
            throw new IllegalArgumentException("Durability options are not supported on memcached type buckets.");
        }
        OperationFuture deleteOp = this.delete(key);
        if (req == PersistTo.ZERO && rep == ReplicateTo.ZERO) {
            return deleteOp;
        }
        boolean deleteStatus = false;
        try {
            deleteStatus = (Boolean)deleteOp.get();
        }
        catch (InterruptedException e) {
            deleteOp.set((Object)false, new OperationStatus(false, "Delete get timed out"));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                deleteOp.set((Object)false, new OperationStatus(false, "Delete get cancellation exception "));
            }
            deleteOp.set((Object)false, new OperationStatus(false, "Delete get execution exception "));
        }
        if (!deleteStatus) {
            return deleteOp;
        }
        try {
            this.observePoll(key, deleteOp.getCas(), req, rep, true);
            deleteOp.set((Object)true, deleteOp.getStatus());
        }
        catch (ObservedException e) {
            deleteOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedTimeoutException e) {
            deleteOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedModifiedException e) {
            deleteOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        return deleteOp;
    }

    @Override
    public OperationFuture<Boolean> delete(String key, PersistTo req) {
        return this.delete(key, req, ReplicateTo.ZERO);
    }

    @Override
    public OperationFuture<Boolean> delete(String key, ReplicateTo req) {
        return this.delete(key, PersistTo.ZERO, req);
    }

    @Override
    public OperationFuture<Boolean> set(String key, Object value) {
        return this.set(key, 0, value);
    }

    @Override
    public OperationFuture<Boolean> set(String key, int exp, Object value, PersistTo req, ReplicateTo rep) {
        if (this.mconn instanceof CouchbaseMemcachedConnection) {
            throw new IllegalArgumentException("Durability options are not supported on memcached type buckets.");
        }
        OperationFuture setOp = this.set(key, exp, value);
        if (req == PersistTo.ZERO && rep == ReplicateTo.ZERO) {
            return setOp;
        }
        boolean setStatus = false;
        try {
            setStatus = (Boolean)setOp.get();
        }
        catch (InterruptedException e) {
            setOp.set((Object)false, new OperationStatus(false, "Set get timed out"));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                setOp.set((Object)false, new OperationStatus(false, "Set get cancellation exception "));
            }
            setOp.set((Object)false, new OperationStatus(false, "Set get execution exception "));
        }
        if (!setStatus) {
            return setOp;
        }
        try {
            this.observePoll(key, setOp.getCas(), req, rep, false);
            setOp.set((Object)true, setOp.getStatus());
        }
        catch (ObservedException e) {
            setOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedTimeoutException e) {
            setOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedModifiedException e) {
            setOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        return setOp;
    }

    @Override
    public OperationFuture<Boolean> set(String key, Object value, PersistTo req, ReplicateTo rep) {
        return this.set(key, 0, value, req, rep);
    }

    @Override
    public OperationFuture<Boolean> add(String key, Object value) {
        return this.add(key, 0, value);
    }

    @Override
    public OperationFuture<Boolean> set(String key, int exp, Object value, PersistTo req) {
        return this.set(key, exp, value, req, ReplicateTo.ZERO);
    }

    @Override
    public OperationFuture<Boolean> set(String key, Object value, PersistTo req) {
        return this.set(key, 0, value, req);
    }

    @Override
    public OperationFuture<Boolean> set(String key, int exp, Object value, ReplicateTo rep) {
        return this.set(key, exp, value, PersistTo.ZERO, rep);
    }

    @Override
    public OperationFuture<Boolean> set(String key, Object value, ReplicateTo rep) {
        return this.set(key, 0, value, rep);
    }

    @Override
    public OperationFuture<Boolean> add(String key, int exp, Object value, PersistTo req, ReplicateTo rep) {
        if (this.mconn instanceof CouchbaseMemcachedConnection) {
            throw new IllegalArgumentException("Durability options are not supported on memcached type buckets.");
        }
        OperationFuture addOp = this.add(key, exp, value);
        if (req == PersistTo.ZERO && rep == ReplicateTo.ZERO) {
            return addOp;
        }
        boolean addStatus = false;
        try {
            addStatus = (Boolean)addOp.get();
        }
        catch (InterruptedException e) {
            addOp.set((Object)false, new OperationStatus(false, "Add get timed out"));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                addOp.set((Object)false, new OperationStatus(false, "Add get cancellation exception "));
            }
            addOp.set((Object)false, new OperationStatus(false, "Add get execution exception "));
        }
        if (!addStatus) {
            return addOp;
        }
        try {
            this.observePoll(key, addOp.getCas(), req, rep, false);
            addOp.set((Object)true, addOp.getStatus());
        }
        catch (ObservedException e) {
            addOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedTimeoutException e) {
            addOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedModifiedException e) {
            addOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        return addOp;
    }

    @Override
    public OperationFuture<Boolean> add(String key, Object value, PersistTo req, ReplicateTo rep) {
        return this.add(key, 0, value, req, rep);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, Object value) {
        return this.replace(key, 0, value);
    }

    @Override
    public OperationFuture<Boolean> add(String key, int exp, Object value, PersistTo req) {
        return this.add(key, exp, value, req, ReplicateTo.ZERO);
    }

    @Override
    public OperationFuture<Boolean> add(String key, Object value, PersistTo req) {
        return this.add(key, 0, value, req);
    }

    @Override
    public OperationFuture<Boolean> add(String key, int exp, Object value, ReplicateTo rep) {
        return this.add(key, exp, value, PersistTo.ZERO, rep);
    }

    @Override
    public OperationFuture<Boolean> add(String key, Object value, ReplicateTo rep) {
        return this.add(key, 0, value, rep);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, int exp, Object value, PersistTo req, ReplicateTo rep) {
        if (this.mconn instanceof CouchbaseMemcachedConnection) {
            throw new IllegalArgumentException("Durability options are not supported on memcached type buckets.");
        }
        OperationFuture replaceOp = this.replace(key, exp, value);
        if (req == PersistTo.ZERO && rep == ReplicateTo.ZERO) {
            return replaceOp;
        }
        boolean replaceStatus = false;
        try {
            replaceStatus = (Boolean)replaceOp.get();
        }
        catch (InterruptedException e) {
            replaceOp.set((Object)false, new OperationStatus(false, "Replace get timed out"));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                replaceOp.set((Object)false, new OperationStatus(false, "Replace get cancellation exception "));
            }
            replaceOp.set((Object)false, new OperationStatus(false, "Replace get execution exception "));
        }
        if (!replaceStatus) {
            return replaceOp;
        }
        try {
            this.observePoll(key, replaceOp.getCas(), req, rep, false);
            replaceOp.set((Object)true, replaceOp.getStatus());
        }
        catch (ObservedException e) {
            replaceOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedTimeoutException e) {
            replaceOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        catch (ObservedModifiedException e) {
            replaceOp.set((Object)false, new OperationStatus(false, e.getMessage()));
        }
        return replaceOp;
    }

    @Override
    public OperationFuture<Boolean> replace(String key, Object value, PersistTo req, ReplicateTo rep) {
        return this.replace(key, 0, value, req, rep);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, int exp, Object value, PersistTo req) {
        return this.replace(key, exp, value, req, ReplicateTo.ZERO);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, Object value, PersistTo req) {
        return this.replace(key, 0, value, req);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, int exp, Object value, ReplicateTo rep) {
        return this.replace(key, exp, value, PersistTo.ZERO, rep);
    }

    @Override
    public OperationFuture<Boolean> replace(String key, Object value, ReplicateTo rep) {
        return this.replace(key, 0, value, rep);
    }

    @Override
    public CASResponse cas(String key, long cas, Object value, PersistTo req, ReplicateTo rep) {
        if (this.mconn instanceof CouchbaseMemcachedConnection) {
            throw new IllegalArgumentException("Durability options are not supported on memcached type buckets.");
        }
        OperationFuture casOp = this.asyncCAS(key, cas, value);
        CASResponse casr = null;
        try {
            casr = (CASResponse)casOp.get();
        }
        catch (InterruptedException e) {
            casr = CASResponse.EXISTS;
        }
        catch (ExecutionException e) {
            casr = CASResponse.EXISTS;
        }
        if (casr != CASResponse.OK) {
            return casr;
        }
        if (req == PersistTo.ZERO && rep == ReplicateTo.ZERO) {
            return casr;
        }
        try {
            this.observePoll(key, casOp.getCas(), req, rep, false);
        }
        catch (ObservedException e) {
            casr = CASResponse.OBSERVE_ERROR_IN_ARGS;
        }
        catch (ObservedTimeoutException e) {
            casr = CASResponse.OBSERVE_TIMEOUT;
        }
        catch (ObservedModifiedException e) {
            casr = CASResponse.OBSERVE_MODIFIED;
        }
        return casr;
    }

    @Override
    public CASResponse cas(String key, long cas, Object value, PersistTo req) {
        return this.cas(key, cas, value, req, ReplicateTo.ZERO);
    }

    @Override
    public CASResponse cas(String key, long cas, Object value, ReplicateTo rep) {
        return this.cas(key, cas, value, PersistTo.ZERO, rep);
    }

    @Override
    public Map<MemcachedNode, ObserveResponse> observe(final String key, final long cas) {
        Config cfg = ((CouchbaseConnectionFactory)this.connFactory).getVBucketConfig();
        VBucketNodeLocator locator = (VBucketNodeLocator)((CouchbaseConnection)this.mconn).getLocator();
        final int vb = locator.getVBucketIndex(key);
        ArrayList<MemcachedNode> bcastNodes = new ArrayList<MemcachedNode>();
        bcastNodes.add(locator.getServerByIndex(cfg.getMaster(vb)));
        for (int i = 1; i <= cfg.getReplicasCount(); ++i) {
            int replica = cfg.getReplica(vb, i - 1);
            if (replica < 0) continue;
            bcastNodes.add(locator.getServerByIndex(replica));
        }
        final HashMap<MemcachedNode, ObserveResponse> response = new HashMap<MemcachedNode, ObserveResponse>();
        CountDownLatch blatch = this.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                return CouchbaseClient.this.opFact.observe(key, cas, vb, new ObserveOperation.Callback(){

                    public void receivedStatus(OperationStatus s) {
                    }

                    public void gotData(String key, long retCas, MemcachedNode node, ObserveResponse or) {
                        if (cas == retCas) {
                            response.put(node, or);
                        } else if (or == ObserveResponse.NOT_FOUND_PERSISTED) {
                            response.put(node, or);
                        } else {
                            response.put(node, ObserveResponse.MODIFIED);
                        }
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
            }
        }, bcastNodes);
        try {
            blatch.await(this.operationTimeout, TimeUnit.MILLISECONDS);
            return response;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for value", e);
        }
    }

    @Override
    public int getNumVBuckets() {
        return ((CouchbaseConnectionFactory)this.connFactory).getVBucketConfig().getVbucketsCount();
    }

    public boolean shutdown(long timeout, TimeUnit unit) {
        boolean shutdownResult = false;
        try {
            shutdownResult = super.shutdown(timeout, unit);
            CouchbaseConnectionFactory cf = (CouchbaseConnectionFactory)this.connFactory;
            cf.getConfigurationProvider().shutdown();
            if (this.vconn != null) {
                this.vconn.shutdown();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CouchbaseClient.class.getName()).log(Level.SEVERE, "Unexpected IOException in shutdown", ex);
            throw new RuntimeException(null, ex);
        }
        return shutdownResult;
    }

    private void checkObserveReplica(String key, int numPersist, int numReplica) {
        int vBucketIndex;
        int currentReplicaNum;
        Config cfg = ((CouchbaseConnectionFactory)this.connFactory).getVBucketConfig();
        VBucketNodeLocator locator = (VBucketNodeLocator)((CouchbaseConnection)this.mconn).getLocator();
        if (numReplica > 0 && (currentReplicaNum = cfg.getReplica(vBucketIndex = locator.getVBucketIndex(key), numReplica - 1)) < 0) {
            throw new ObservedException("Currently, there is no replica node available for the given replication index (" + numReplica + ").");
        }
        int replicaCount = Math.min(locator.getAll().size() - 1, cfg.getReplicasCount());
        if (numReplica > replicaCount) {
            throw new ObservedException("Requested replication to " + numReplica + " node(s), but only " + replicaCount + " are available.");
        }
        if (numPersist > replicaCount + 1) {
            throw new ObservedException("Requested persistence to " + (numPersist + 1) + " node(s), but only " + (replicaCount + 1) + " are available.");
        }
    }

    @Override
    public void observePoll(String key, long cas, PersistTo persist, ReplicateTo replicate, boolean isDelete) {
        if (persist == null) {
            persist = PersistTo.ZERO;
        }
        if (replicate == null) {
            replicate = ReplicateTo.ZERO;
        }
        int persistReplica = persist.getValue() > 0 ? persist.getValue() - 1 : 0;
        int replicateTo = replicate.getValue();
        int obsPolls = 0;
        int obsPollMax = this.cbConnFactory.getObsPollMax();
        long obsPollInterval = this.cbConnFactory.getObsPollInterval();
        boolean persistMaster = persist.getValue() > 0;
        Config cfg = ((CouchbaseConnectionFactory)this.connFactory).getVBucketConfig();
        VBucketNodeLocator locator = (VBucketNodeLocator)((CouchbaseConnection)this.mconn).getLocator();
        this.checkObserveReplica(key, persistReplica, replicateTo);
        int replicaPersistedTo = 0;
        int replicatedTo = 0;
        boolean persistedMaster = false;
        while (replicateTo > replicatedTo || persistReplica - 1 > replicaPersistedTo || !persistedMaster && persistMaster) {
            this.checkObserveReplica(key, persistReplica, replicateTo);
            if (++obsPolls >= obsPollMax) {
                long timeTried = (long)obsPollMax * obsPollInterval;
                TimeUnit tu = TimeUnit.MILLISECONDS;
                throw new ObservedTimeoutException("Observe Timeout - Polled Unsuccessfully for at least " + tu.toSeconds(timeTried) + " seconds.");
            }
            Map<MemcachedNode, ObserveResponse> response = this.observe(key, cas);
            int vb = locator.getVBucketIndex(key);
            MemcachedNode master = locator.getServerByIndex(cfg.getMaster(vb));
            replicaPersistedTo = 0;
            replicatedTo = 0;
            persistedMaster = false;
            for (Map.Entry<MemcachedNode, ObserveResponse> r : response.entrySet()) {
                boolean isMaster;
                boolean bl = isMaster = r.getKey() == master;
                if (isMaster && r.getValue() == ObserveResponse.MODIFIED) {
                    throw new ObservedModifiedException("Key was modified");
                }
                if (!isDelete) {
                    if (!isMaster && r.getValue() == ObserveResponse.FOUND_NOT_PERSISTED) {
                        ++replicatedTo;
                    }
                    if (r.getValue() != ObserveResponse.FOUND_PERSISTED) continue;
                    if (isMaster) {
                        persistedMaster = true;
                        continue;
                    }
                    ++replicatedTo;
                    ++replicaPersistedTo;
                    continue;
                }
                if (r.getValue() == ObserveResponse.NOT_FOUND_NOT_PERSISTED) {
                    ++replicatedTo;
                }
                if (r.getValue() != ObserveResponse.NOT_FOUND_PERSISTED) continue;
                ++replicatedTo;
                ++replicaPersistedTo;
                if (isMaster) {
                    persistedMaster = true;
                    continue;
                }
                ++replicaPersistedTo;
            }
            try {
                Thread.sleep(obsPollInterval);
            }
            catch (InterruptedException e) {
                this.getLogger().error((Object)"Interrupted while in observe loop.", (Throwable)e);
                throw new ObservedException("Observe was Interrupted ");
            }
        }
    }

    @Override
    public OperationFuture<Map<String, String>> getKeyStats(String key) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.operationTimeout);
        StatsOperation op = this.opFact.keyStats(key, new StatsOperation.Callback(){
            private Map<String, String> stats = new HashMap<String, String>();

            public void gotStat(String name, String val) {
                this.stats.put(name, val);
            }

            public void receivedStatus(OperationStatus status) {
                rv.set(this.stats, status);
            }

            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public OperationFuture<Boolean> flush() {
        return this.flush(-1);
    }

    public OperationFuture<Boolean> flush(int delay) {
        if (((CouchbaseConnection)this.mconn).isShutDown()) {
            throw new IllegalStateException("Flush can not be used after shutdown.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final FlushRunner flushRunner = new FlushRunner(latch);
        OperationFuture<Boolean> rv = new OperationFuture<Boolean>(PROD_PREFIX, latch, this.operationTimeout){
            private CouchbaseConnectionFactory factory;
            {
                super(x0, x1, x2);
                this.factory = (CouchbaseConnectionFactory)CouchbaseClient.this.connFactory;
            }

            public boolean cancel() {
                throw new UnsupportedOperationException("Flush cannot be canceled");
            }

            public boolean isDone() {
                return flushRunner.status();
            }

            public Boolean get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!latch.await(duration, units)) {
                    throw new TimeoutException("Flush not completed within timeout.");
                }
                return flushRunner.status();
            }

            public Boolean get() throws InterruptedException, ExecutionException {
                try {
                    return this.get(this.factory.getViewTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException("Timed out waiting for operation", e);
                }
            }

            public Long getCas() {
                throw new UnsupportedOperationException("Flush has no CAS value.");
            }

            public String getKey() {
                throw new UnsupportedOperationException("Flush has no associated key.");
            }

            public OperationStatus getStatus() {
                throw new UnsupportedOperationException("Flush has no OperationStatus.");
            }

            public boolean isCancelled() {
                throw new UnsupportedOperationException("Flush cannot be canceled.");
            }
        };
        Thread flusher = new Thread((Runnable)flushRunner, "Temporary Flusher");
        flusher.setDaemon(true);
        flusher.start();
        return rv;
    }

    private boolean flushBucket() {
        FlushResponse res = this.cbConnFactory.getClusterManager().flushBucket(this.cbConnFactory.getBucketName());
        return res.equals((Object)FlushResponse.OK);
    }

    static {
        CouchbaseProperties.setPropertyFile("cbclient.properties");
        String viewmode = CouchbaseProperties.getProperty("viewmode");
        if (viewmode == null) {
            viewmode = CouchbaseProperties.getProperty("viewmode", true);
        }
        if (viewmode == null) {
            MODE_ERROR = "viewmode property isn't defined. Setting viewmode to production mode";
            MODE_PREFIX = PROD_PREFIX;
        } else if (viewmode.equals(MODE_PRODUCTION)) {
            MODE_ERROR = "viewmode set to production mode";
            MODE_PREFIX = PROD_PREFIX;
        } else if (viewmode.equals(MODE_DEVELOPMENT)) {
            MODE_ERROR = "viewmode set to development mode";
            MODE_PREFIX = DEV_PREFIX;
        } else {
            MODE_ERROR = "unknown value \"" + viewmode + "\" for property viewmode" + " Setting to production mode";
            MODE_PREFIX = PROD_PREFIX;
        }
    }

    private class FlushRunner
    implements Runnable {
        private final CountDownLatch flatch;
        private Boolean flushStatus = false;

        public FlushRunner(CountDownLatch latch) {
            this.flatch = latch;
        }

        @Override
        public void run() {
            this.flushStatus = CouchbaseClient.this.flushBucket();
            this.flatch.countDown();
        }

        private boolean status() {
            return this.flushStatus;
        }
    }
}

