/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.ViewConnection;
import com.couchbase.client.http.AsyncConnectionManager;
import com.couchbase.client.http.AsyncConnectionRequest;
import com.couchbase.client.http.HttpUtil;
import com.couchbase.client.http.RequestHandle;
import com.couchbase.client.protocol.views.HttpOperation;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.compat.SpyObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.NHttpRequestExecutionHandler;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ViewNode
extends SpyObject {
    private final InetSocketAddress addr;
    private final AsyncConnectionManager connMgr;
    private final long opQueueMaxBlockTime;
    private final long opQueueLen;
    private final long defaultOpTimeout;
    private final String user;
    private final String pass;
    private boolean shuttingDown = false;
    private Thread ioThread;

    public ViewNode(InetSocketAddress a, AsyncConnectionManager mgr, long queueLen, long maxBlockTime, long operationTimeout, String usr, String pwd) {
        this.addr = a;
        this.connMgr = mgr;
        this.opQueueMaxBlockTime = maxBlockTime;
        this.opQueueLen = queueLen;
        this.defaultOpTimeout = operationTimeout;
        this.user = usr;
        this.pass = pwd;
    }

    public void init() throws IOReactorException {
        this.ioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewNode.this.connMgr.execute();
                }
                catch (InterruptedIOException ex) {
                    ViewNode.this.getLogger().error((Object)"I/O reactor Interrupted", (Throwable)ex);
                }
                catch (IOException e) {
                    ViewNode.this.getLogger().error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
                }
                ViewNode.this.getLogger().info((Object)("I/O reactor terminated for " + ViewNode.this.addr.getHostName()));
            }
        }, "Couchbase View Thread for node " + this.addr);
        this.ioThread.start();
    }

    public boolean writeOp(HttpOperation op) {
        AsyncConnectionRequest connRequest = this.connMgr.requestConnection();
        try {
            connRequest.waitFor();
        }
        catch (InterruptedException e) {
            this.getLogger().warn((Object)"Interrupted while trying to get a connection.");
            connRequest.cancel();
            return false;
        }
        NHttpClientConnection conn = connRequest.getConnection();
        if (conn == null) {
            this.getLogger().debug((Object)("Failed to obtain connection on node " + this.addr));
            connRequest.cancel();
            return false;
        }
        if (!this.user.equals("default")) {
            try {
                op.addAuthHeader(HttpUtil.buildAuthHeader(this.user, this.pass));
            }
            catch (UnsupportedEncodingException ex) {
                this.getLogger().error((Object)("Could not create auth header for request, could not encode credentials into base64. Canceling op." + op), (Throwable)ex);
                op.cancel();
                connRequest.cancel();
            }
        }
        HttpContext context = conn.getContext();
        RequestHandle handle = new RequestHandle(this.connMgr, conn);
        context.setAttribute("request-handle", (Object)handle);
        context.setAttribute("operation", (Object)op);
        conn.requestOutput();
        return true;
    }

    public boolean hasWriteOps() {
        return this.connMgr.hasPendingRequests();
    }

    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    public void shutdown() throws IOException {
        this.shutdown(0L, TimeUnit.MILLISECONDS);
    }

    public void shutdown(long time, TimeUnit unit) throws IOException {
        this.shuttingDown = true;
        long waittime = time;
        if (unit != TimeUnit.MILLISECONDS) {
            waittime = TimeUnit.MILLISECONDS.convert(time, unit);
        }
        this.connMgr.shutdown(waittime);
        try {
            this.ioThread.join(waittime);
        }
        catch (InterruptedException ex) {
            this.getLogger().error((Object)("Interrupt " + ex + " received while waiting for node " + this.addr.getHostName() + " to shut down."));
        }
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    static class EventLogger
    extends SpyObject
    implements EventListener {
        EventLogger() {
        }

        public void connectionOpen(NHttpConnection conn) {
            this.getLogger().debug((Object)("Connection open: " + conn));
        }

        public void connectionTimeout(NHttpConnection conn) {
            this.getLogger().error((Object)("Connection timed out: " + conn));
        }

        public void connectionClosed(NHttpConnection conn) {
            this.getLogger().debug((Object)("Connection closed: " + conn));
        }

        public void fatalIOException(IOException ex, NHttpConnection conn) {
            this.getLogger().error((Object)("I/O error: " + ex.getMessage()));
        }

        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            this.getLogger().error((Object)("HTTP error: " + ex.getMessage()));
        }
    }

    static class MyHttpRequestExecutionHandler
    extends SpyObject
    implements NHttpRequestExecutionHandler {
        private final ViewConnection vconn;

        public MyHttpRequestExecutionHandler(ViewConnection vconn) {
            this.vconn = vconn;
        }

        public void initalizeContext(HttpContext context, Object attachment) {
        }

        public void finalizeContext(HttpContext context) {
            RequestHandle handle = (RequestHandle)context.removeAttribute("request-handle");
            if (handle != null) {
                handle.cancel();
            }
        }

        public HttpRequest submitRequest(HttpContext context) {
            HttpOperation op = (HttpOperation)context.getAttribute("operation");
            if (op == null) {
                return null;
            }
            return op.getRequest();
        }

        public void handleResponse(HttpResponse response, HttpContext context) {
            RequestHandle handle = (RequestHandle)context.removeAttribute("request-handle");
            HttpOperation op = (HttpOperation)context.removeAttribute("operation");
            try {
                response.setEntity((HttpEntity)new BufferedHttpEntity(response.getEntity()));
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not convert HttpEntity content.");
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (handle != null) {
                boolean shouldRetry = this.shouldRetry(statusCode, response);
                if (shouldRetry) {
                    if (!op.isTimedOut() && !op.isCancelled()) {
                        this.getLogger().info((Object)("Retrying HTTP operation Request: " + op.getRequest().getRequestLine() + ", Response: " + response.getStatusLine()));
                        this.vconn.addOp(op);
                    }
                } else {
                    op.handleResponse(response);
                }
                handle.completed();
            }
        }

        private boolean shouldRetry(int statusCode, HttpResponse response) {
            switch (statusCode) {
                case 200: {
                    return false;
                }
                case 404: {
                    return this.analyse404Response(response);
                }
                case 500: {
                    return this.analyse500Response(response);
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 307: 
                case 401: 
                case 408: 
                case 409: 
                case 412: 
                case 416: 
                case 417: 
                case 501: 
                case 502: 
                case 503: 
                case 504: {
                    return true;
                }
            }
            return false;
        }

        private boolean analyse404Response(HttpResponse response) {
            try {
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                if (body.contains("not_found") && (body.contains("missing") || body.contains("deleted"))) {
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }

        private boolean analyse500Response(HttpResponse response) {
            try {
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                if (body.contains("error") && body.contains("{not_found, missing_named_view}")) {
                    return false;
                }
            }
            catch (IOException ex) {
                return false;
            }
            return true;
        }

        public ConsumingNHttpEntity responseEntity(HttpResponse response, HttpContext context) throws IOException {
            return new BufferingNHttpEntity(response.getEntity(), (ByteBufferAllocator)new HeapByteBufferAllocator());
        }
    }
}

