/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.http;

import com.couchbase.client.http.AsyncConnectionManager;
import org.apache.http.nio.NHttpClientConnection;

public class RequestHandle {
    private final AsyncConnectionManager connMgr;
    private final NHttpClientConnection conn;
    private volatile boolean completed;

    public RequestHandle(AsyncConnectionManager connMgr, NHttpClientConnection conn) {
        this.connMgr = connMgr;
        this.conn = conn;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.connMgr.releaseConnection(this.conn);
        RequestHandle requestHandle = this;
        synchronized (requestHandle) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.connMgr.releaseConnection(this.conn);
        RequestHandle requestHandle = this;
        synchronized (requestHandle) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        if (this.completed) {
            return;
        }
        RequestHandle requestHandle = this;
        synchronized (requestHandle) {
            while (!this.completed) {
                this.wait();
            }
        }
    }
}

