/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.internal.GetFuture;

public class ReplicaGetFuture<T>
implements Future<T> {
    private final long timeout;
    private final List<GetFuture<T>> futures;
    private boolean cancelled = false;

    public ReplicaGetFuture(long timeout, List<GetFuture<T>> futures) {
        this.timeout = timeout;
        this.futures = futures;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long userTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        long timeoutMs = TimeUnit.MILLISECONDS.convert(userTimeout, unit);
        while (System.currentTimeMillis() - start <= timeoutMs) {
            for (GetFuture<T> future : this.futures) {
                if (!future.isDone() || future.isCancelled()) continue;
                this.cancelOtherFutures(future);
                return (T)future.get();
            }
        }
        throw new TimeoutException("No replica get future returned with success before timeout.");
    }

    public void cancelOtherFutures(GetFuture successFuture) {
        for (GetFuture<T> future : this.futures) {
            if (future.equals((Object)successFuture)) continue;
            future.cancel(true);
        }
    }

    @Override
    public boolean cancel(boolean ign) {
        this.cancelled = true;
        boolean allCancelled = true;
        for (GetFuture<T> future : this.futures) {
            if (future.cancel(ign)) continue;
            allCancelled = false;
        }
        return allCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        boolean allDone = true;
        for (GetFuture<T> future : this.futures) {
            if (future.isDone()) continue;
            allDone = false;
        }
        return allDone;
    }
}

