/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.ConnectionException;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigurationParser;
import com.couchbase.client.vbucket.config.DefaultConfigFactory;
import com.couchbase.client.vbucket.config.Node;
import com.couchbase.client.vbucket.config.Pool;
import com.couchbase.client.vbucket.config.Port;
import com.couchbase.client.vbucket.config.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.compat.SpyObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ConfigurationParserJSON
extends SpyObject
implements ConfigurationParser {
    private static final String NAME_ATTR = "name";
    private static final String URI_ATTR = "uri";
    private static final String STREAMING_URI_ATTR = "streamingUri";

    @Override
    public Map<String, Pool> parseBase(String base) throws ParseException {
        HashMap<String, Pool> parsedBase = new HashMap<String, Pool>();
        JSONArray poolsJA = null;
        try {
            JSONObject baseJO = new JSONObject(base);
            poolsJA = baseJO.getJSONArray("pools");
        }
        catch (JSONException e) {
            this.getLogger().debug((Object)("Received the folloing unparsable response: " + e.getMessage()));
            throw new ConnectionException("Connection URI is either incorrect or invalid as it cannot be parsed.");
        }
        for (int i = 0; i < poolsJA.length(); ++i) {
            try {
                JSONObject poolJO = poolsJA.getJSONObject(i);
                String name = (String)poolJO.get(NAME_ATTR);
                if (name == null || "".equals(name)) {
                    throw new ParseException("Pool's name is missing.", 0);
                }
                String uri = (String)poolJO.get(URI_ATTR);
                if (uri == null || "".equals(uri)) {
                    throw new ParseException("Pool's uri is missing.", 0);
                }
                String streamingUri = (String)poolJO.get(STREAMING_URI_ATTR);
                Pool pool = new Pool(name, new URI(uri), new URI(streamingUri));
                parsedBase.put(name, pool);
                continue;
            }
            catch (JSONException e) {
                this.getLogger().error((Object)"One of the pool configuration can not be parsed.", (Throwable)e);
                continue;
            }
            catch (URISyntaxException e) {
                this.getLogger().error((Object)"Server provided an incorrect uri.", (Throwable)e);
            }
        }
        return parsedBase;
    }

    @Override
    public void loadPool(Pool pool, String sPool) throws ParseException {
        try {
            JSONObject poolJO = new JSONObject(sPool);
            JSONObject poolBucketsJO = poolJO.getJSONObject("buckets");
            URI bucketsUri = new URI((String)poolBucketsJO.get(URI_ATTR));
            pool.setBucketsUri(bucketsUri);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public Map<String, Bucket> parseBuckets(String buckets) throws ParseException {
        HashMap<String, Bucket> bucketsMap = new HashMap<String, Bucket>();
        try {
            JSONArray bucketsJA = new JSONArray(buckets);
            for (int i = 0; i < bucketsJA.length(); ++i) {
                JSONObject bucketJO = bucketsJA.getJSONObject(i);
                Bucket bucket = this.parseBucketFromJSON(bucketJO);
                bucketsMap.put(bucket.getName(), bucket);
            }
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return bucketsMap;
    }

    @Override
    public Bucket parseBucket(String sBucket) throws ParseException {
        try {
            return this.parseBucketFromJSON(new JSONObject(sBucket));
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private Bucket parseBucketFromJSON(JSONObject bucketJO) throws ParseException {
        try {
            String bucketname = bucketJO.get(NAME_ATTR).toString();
            String streamingUri = bucketJO.get(STREAMING_URI_ATTR).toString();
            DefaultConfigFactory cf = new DefaultConfigFactory();
            Config config = cf.create(bucketJO);
            ArrayList<Node> nodes = new ArrayList<Node>();
            JSONArray nodesJA = bucketJO.getJSONArray("nodes");
            for (int i = 0; i < nodesJA.length(); ++i) {
                JSONObject nodeJO = nodesJA.getJSONObject(i);
                String statusValue = nodeJO.get("status").toString();
                Status status = null;
                try {
                    status = Status.valueOf(statusValue);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().error((Object)("Unknown status value: " + statusValue));
                }
                String hostname = nodeJO.get("hostname").toString();
                JSONObject portsJO = nodeJO.getJSONObject("ports");
                HashMap<Port, String> ports = new HashMap<Port, String>();
                for (Port port : Port.values()) {
                    String portValue = portsJO.get(port.toString()).toString();
                    if (portValue == null || portValue.isEmpty()) continue;
                    ports.put(port, portValue);
                }
                Node node = new Node(status, hostname, ports);
                nodes.add(node);
            }
            return new Bucket(bucketname, config, new URI(streamingUri), nodes);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

