/*
   derived from ctctrl.c - chris@alderan.sdata.de

   mbarth219@aol.com '96
*/

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <errno.h>


#define DWORD unsigned long

#include "ntapi.h"

extern HANDLE hTape;
#define TARGET hTape

extern char *getenv();
extern void tapeinit();
extern char *optarg;

char *index (char *s, int c)
{
   return (strchr (s, c));
}

void bcopy (char *s1, char *s2, int n)
{
   (void) memcpy (s2, s1, n);
}


void usage (char *cmd)
{
    fprintf (stderr,"%s: tape control for streamer using WIN32 Tape-API\n",cmd);
    fprintf (stderr,"usage: %s [options]\n",cmd);
    fprintf (stderr,"Options:   -e     -  erase entire tape\n");
    fprintf (stderr,"           -t     -  retention tape\n");
    fprintf (stderr,"           -w     -  rewind tape (DEFAULT)\n");
    fprintf (stderr,"           -p [n] -  position tape to file [n]\n");
    fprintf (stderr,"                     n = 0 , position to logical end-of-tape (LEOT)\n");
    fprintf (stderr,"                     n < 0 , position relative to LEOT\n");
    fprintf (stderr,"           -q     -  quiet mode  -- don't ask questions\n");
}


int main (int argc, char *argv[])
{
    char *cmd;
    int  eflag, tflag, wflag, pflag, qflag, pos, c;

    cmd = argv[0];
    eflag = tflag = wflag = pflag = qflag = pos = 0;

    while ((c = getopt (argc, argv,"etwp:?q")) != -1)
        switch (c)
        {
            case 'e': eflag = 1;
                      break;
            case 't': tflag = 1;
                      break;
            case 'w': wflag = 1;
                      break;
            case 'q': qflag = 1;
                      break;
            case 'p': pflag = 1;
                      if (optarg)
                         pos = atoi (optarg);
                      break;
            case '?': usage (cmd);
                      exit (-1);
        }

    if (!(eflag || tflag || wflag || pflag))
       wflag = 1;  /* default ! */

    /* Our - open() */
    tapeinit ();

    if (eflag)
    {
       if (!qflag)
       {
          printf ("ARE YOU SURE YOU WANT TO ERASE THE TAPE (Y/N) ? ");
          fflush (stdout);
          c = getchar();
          if ((c!='y') && (c!='Y') )
          {
             fprintf (stderr,"%s: operation canceled\n",cmd);
                         CloseHandle (hTape);
             exit(0);
           }
       }
       pflag = 0;
    }

    if (tflag)
    {                        /* retension tape */
       if (APIRewind(TARGET, 0))
       {
          fprintf (stderr,"Error rewinding Tape\n");
          CloseHandle (hTape);
          exit (-1);
       }

       if (!qflag)
          printf ("retention tape .. ");

       fflush (stdout);

       if (APILoad (TARGET, 0, 1, 1, 0))
       {
          fprintf (stderr,"Error retention Tape\n");
          APIRewind (TARGET, 0);
          CloseHandle (hTape);
          exit(-1);
       }

       if (APILoad (TARGET, 0, 0, 0, 0))
       {
          fprintf (stderr,"Error unloading Tape\n");
                  CloseHandle (hTape);
          exit (-1);
       }
    }

    if (wflag)
    {
       if (!qflag)
          printf ("rewinding tape .. ");

       fflush (stdout);

       if (APIRewind(TARGET, 0))
       {
          fprintf (stderr,"Error rewinding Tape\n");
                  CloseHandle (hTape);
          exit (-1);
       }

       if (!qflag)
          printf ("[OK]\n");
    }

    if (eflag)
    {
/*
       if (APILoad(TARGET, 0, 1, 0, 0))
       {
          fprintf (stderr,"Error loading Tape\n");
          APIRewind (TARGET, 0);
          CloseHandle (hTape);
          exit(-1);
       }
*/
       if (!qflag)
          printf ("eraseing tape .. ");

       fflush (stdout);

       if (APIErase(TARGET, 0, 0))
       {
          fprintf (stderr,"Error eraseing Tape\n");
          APIRewind (TARGET, 0);
          CloseHandle (hTape);
          exit(-1);
       }

       if (!qflag)
          printf ("[OK]\n");

       if (APILoad(TARGET, 0, 0, 0, 0))
       {
          fprintf (stderr,"Error unloading Tape\n");
          exit (-1);
       }
    }

    if (pflag)
    {
       if (APIRewind (TARGET, 0))
       {
          fprintf (stderr, "Error rewinding Tape\n");
                  CloseHandle (hTape);
          exit (-1);
       }

       if (pos > 0)
       {
          if (!qflag)
             printf ("seeking to tapefile #%d .. ",pos);
          fflush (stdout);

          if (pos > 1)
          {
             if (APISpace (TARGET, 1, (long) pos - 1l))
             {
                fprintf (stderr,"Error positioning Tape\n");
                            CloseHandle (hTape);
                exit (-1);
             }
          }

          if (!qflag)
             printf ("[OK]\n");
       }
       else
        if (pos == 0)
        {
           if (!qflag)
              printf ("seeking to End of Tape ");

           fflush (stdout);
           pos = 1;

           while (!APISpace(TARGET, 1, 1l))
           {
               ++pos;

               if (!qflag)
                  putchar('.');
               fflush (stdout);
           }
           if (!qflag)
              printf (" next tapefile is #%d [OK]\n",pos);
        }
        else
         if (pos < 0)
         {
            int p;

            if (!qflag)
               printf ("seeking to file EOT%d ",pos);
            fflush(stdout);

            p = 1;
            while (!APISpace(TARGET, 1, 1l))
            {
                ++p;
                if (!qflag)
                   putchar('.');
                fflush (stdout);
            }

            if (APIRewind(TARGET, 0))
            {
               fprintf (stderr,"Error rewinding Tape\n");
                           CloseHandle (hTape);
               exit(-1);
            }

            p += pos;

            if (p < 1)
               p = 1;

            if (!qflag)
               printf (" tapefile #%d .. ",p);

            fflush (stdout);
            if (p > 1)
            {
               if (APISpace (TARGET, 1, (long) p - 1l))
               {
                  fprintf (stderr,"Error positioning Tape\n");
                  CloseHandle (hTape);
                  exit(-1);
               }
            }

            if (!qflag)
               printf ("[OK]\n");
         }
    }

    CloseHandle (hTape);
    return pflag ? pos-1 : 0;
}
