#include <windows.h>
#include <stdio.h>

HANDLE hTape;

DWORD Tstatus;

TAPE_GET_MEDIA_PARAMETERS tapemedia;
TAPE_GET_DRIVE_PARAMETERS tapedrive;

int main (int argc, char *argv[])
{
    DWORD varlen;

    hTape = CreateFile ("\\\\.\\TAPE0",
		                GENERIC_READ | GENERIC_WRITE,
						0,
						0,
						OPEN_EXISTING,
						0,
						NULL);

   if (hTape != INVALID_HANDLE_VALUE)
   {

	  Tstatus = GetTapeStatus (hTape);
      printf ("Get Tape Status returned %lu\n", Tstatus);

      
      Tstatus = GetTapeParameters (hTape,
		                           GET_TAPE_DRIVE_INFORMATION,
								   &varlen,
								   &tapedrive);
	  if (Tstatus == NO_ERROR)
	  {
         printf ("\nTape drive -Information\n\n");

         printf ("ECC %d\n", tapedrive.ECC); 
         printf ("Compression %d\n",            tapedrive.Compression);
	     printf ("DataPadding %d\n",            tapedrive.DataPadding);
         printf ("ReportSetmarks %d\n",         tapedrive.ReportSetmarks); 
         printf ("DefaultBlockSize %ld\n",      tapedrive.DefaultBlockSize); 
         printf ("MaximumBlockSize %ld\n",      tapedrive.MaximumBlockSize);
         printf ("MinimumBlockSize %ld\n",      tapedrive.MinimumBlockSize);
         printf ("MaximumPartitionCount %ld\n", tapedrive.MaximumPartitionCount);
         printf ("FeaturesLow %ld\n",           tapedrive.FeaturesLow);
         printf ("FeaturesHigh %ld\n",          tapedrive.FeaturesHigh);
         printf ("EOTWarningZoneSize %ld\n",    tapedrive.EOTWarningZoneSize);
	  }
	  else
		 printf ("GetTapeParameters (Drive) returned %ld\n", Tstatus);

      Tstatus = GetTapeParameters (hTape,
                                   GET_TAPE_MEDIA_INFORMATION,
								   &varlen,
								   &tapemedia);
	  if (Tstatus == NO_ERROR)
	  {

         printf ("\nTape media -Information\n\n");

         printf ("Capacity  high %lu low %lu\n", tapemedia.Capacity.HighPart, 
			                                     tapemedia.Capacity.LowPart); 

         printf ("Remaining high %lu,low %lu\n", tapemedia.Remaining.HighPart, 
			                                     tapemedia.Remaining.LowPart);

		 printf ("BlockSize %ld\n",      tapemedia.BlockSize); 
         printf ("PartitionCount %ld\n", tapemedia.PartitionCount);
         printf ("WriteProtected %d\n",  tapemedia.WriteProtected);
      }
	  else
		 printf ("GetTapeParameters (Media) returned %ld\n", Tstatus);

	  if (argc > 1)
	  {
         Tstatus = PrepareTape (hTape,
			                    TAPE_UNLOAD,
					            FALSE);
         if (Tstatus != NO_ERROR)
			 printf ("PrepareTape returned: %lu\n", Tstatus);
	  }

      CloseHandle (hTape);
   }

   return (0);
}