  /**********************************************************
   *    This code is generated automatically by mkinl
   *                DO NOT EDIT THIS FILE
   *     Erik Lindahl, David van der Spoel 1999-2000
   **********************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

static int dummy; 
/* avoids warnings about an empty file when using fortran */

#ifndef USE_FORTRAN

#include <stdio.h>
#include <math.h>
#include "typedefs.h"
#include "inner.h"
#include <vec.h>




  /**********************************************************
   * This is gromacs innerloop inl0100
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl0100(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       rinvsix;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinvsq11          = 1.0/(rsq11);
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0110
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl0110(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       rinvsix;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinvsq11          = 1.0/(rsq11);
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ii                = ii + nscoul-nsvdwc;
    ii3               = 3*ii;
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinvsq11          = 1.0/(rsq11);
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0200
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl0200(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       rinvsix;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0210
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl0210(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       rinvsix;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ii                = ii + nscoul-nsvdwc;
    ii3               = 3*ii;
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0300
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl0300(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       c6;
  real       c12;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      fs11              = -((fijD+fijR)*tabscale)*rinv11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0301
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: Lambda (alpha=0)
   **********************************************************/
void inl0301(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	            int typeB[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       c6;
  real       c12;
  real       c6a;
  real       c12a;
  real       c6b;
  real       c12b;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       dvdl;
  real       L1;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 2*ntype*type[ii];
    ntiB              = 2*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      tjB               = ntiB+2*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c6                = L1*c6a + lambda*c6b;
      c12a              = nbfp[tjA+1];
      c12b              = nbfp[tjB+1];
      c12               = L1*c12a + lambda*c12b;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      dvdl              = dvdl + (c6b - c6a)*VV;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      dvdl              = dvdl + (c12b - c12a)*VV;
      fs11              = -((fijD+fijR)*tabscale)*rinv11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl0302
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: Softcore
   **********************************************************/
void inl0302(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	            int typeB[],
	           real Alpha,
	           real defsigma6)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       c6a;
  real       c12a;
  real       c6b;
  real       c12b;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       dvdl;
  real       L1;
  real       L12;
  real       lam2;
  real       sigma6a;
  real       sigma6b;
  real       rA;
  real       rB;
  real       rfour;
  real       rsix;
  real       rinva;
  real       rinvb;
  real       rinv5a;
  real       rinv5b;
  real       Fa;
  real       Fb;
  real       vnbtot;
  real       VVDa;
  real       VVDb;
  real       FFDa;
  real       FFDb;
  real       VVRa;
  real       VVRb;
  real       FFRa;
  real       FFRb;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  const real onesixth  =  0.1666666666666667;
  const real onethird  =  0.3333333333333333;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;
  lam2              = lambda*lambda;
  L12               = L1*L1;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 2*ntype*type[ii];
    ntiB              = 2*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      tjA               = ntiA+2*type[jnr];
      tjB               = ntiB+2*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c12a              = nbfp[tjA+1];
      c12b              = nbfp[tjB+1];
      if((c6a > 0) && (c12a > 0)) {
        sigma6a           = c12a/c6a;
      } else {
        sigma6a           = defsigma6;
      }
      if((c6b > 0) && (c12b > 0)) {
        sigma6b           = c12b/c6b;
      } else {
        sigma6b           = defsigma6;
      }
      rfour             = rsq11*rsq11;
      rsix              = rfour*rsq11;
      if((c6a > 0) || (c12a > 0)) {
        rA                = pow(Alpha*sigma6a*lam2+rsix,onesixth);
        rinva             = 1.0/rA;
        rinv5a            = rinva*rinva;
        rinv5a            = rinv5a*rinv5a*rinva;
        rt                = rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDa              = c6a*VV;
        FFDa              = c6a*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRa              = c12a*VV;
        FFRa              = c12a*tabscale*FF;
      } else {
        VVDa              = 0;
        FFDa              = 0;
        VVRa              = 0;
        FFRa              = 0;
        rinv5a            = 0;
      }
      if((c6b > 0) || (c12b > 0)) {
        rB                = pow(Alpha*sigma6b*L12+rsix,onesixth);
        rinvb             = 1.0/rB;
        rinv5b            = rinvb*rinvb;
        rinv5b            = rinv5b*rinv5b*rinvb;
        rt                = rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDb              = c6b*VV;
        FFDb              = c6b*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRb              = c12b*VV;
        FFRb              = c12b*tabscale*FF;
      } else {
        VVDb              = 0;
        FFDb              = 0;
        VVRb              = 0;
        FFRb              = 0;
        rinv5b            = 0;
      }
      vnbtot            = vnbtot + lambda*(VVDb+VVRb)+L1*(VVDa+VVRa);
      Fa                = -(FFDa+FFRa);
      Fb                = -(FFDb+FFRb);
      fs11              = (L1*Fa*rinv5a + lambda*Fb*rinv5b)*rfour;
      dvdl              = 
        dvdl + VVDb+VVRb-VVDa-VVRa+onethird*Alpha*lambda*L1*(Fb*sigma6b*rinv5b-Fa*sigma6a*rinv5a);
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl0310
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl0310(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       c6;
  real       c12;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijD+fijR)*tabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ii                = ii + nscoul-nsvdwc;
    ii3               = 3*ii;
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijD+fijR)*tabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0400
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl0400(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl0401
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: Lambda (alpha=0)
   **********************************************************/
void inl0401(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	           real lambda,
	           real *dvdlambda,
	            int typeB[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       cexp1a;
  real       cexp2a;
  real       cexp1b;
  real       cexp2b;
  real       c6;
  real       c6a;
  real       c6b;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       dvdl;
  real       L1;
  real       vnbexpa;
  real       vnbexpb;
  real       fijRa;
  real       fijRb;
  real       vnb6;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 3*ntype*type[ii];
    ntiB              = 3*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      tjB               = ntiB+3*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c6                = L1*c6a + lambda*c6b;
      cexp1a            = nbfp[tjA+1];
      cexp1b            = nbfp[tjB+1];
      cexp2a            = nbfp[tjA+2];
      cexp2b            = nbfp[tjB+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      dvdl              = dvdl + (c6b - c6a)*VV;
      rt                = cexp2a*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexpa           = cexp1a*VV;
      fijRa             = cexp1a*cexp2a*FF;
      rt                = cexp2b*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexpb           = cexp1b*VV;
      fijRb             = cexp1b*cexp2b*FF;
      fijR              = L1*fijRa + lambda*fijRb;
      vnbtot            = vnbtot + vnb6 + L1*vnbexpa + lambda*vnbexpb;
      dvdl              = dvdl + vnbexpb - vnbexpa;
      fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl0402
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: Softcore
   **********************************************************/
void inl0402(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	           real lambda,
	           real *dvdlambda,
	            int typeB[],
	           real Alpha,
	           real defsigma6)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       cexp1a;
  real       cexp2a;
  real       cexp1b;
  real       cexp2b;
  real       c6a;
  real       c6b;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       dvdl;
  real       L1;
  real       L12;
  real       lam2;
  real       sigma6a;
  real       sigma6b;
  real       rA;
  real       rB;
  real       rfour;
  real       rsix;
  real       rinva;
  real       rinvb;
  real       rinv5a;
  real       rinv5b;
  real       Fa;
  real       Fb;
  real       vnbtot;
  real       VVDa;
  real       VVDb;
  real       FFDa;
  real       FFDb;
  real       VVRa;
  real       VVRb;
  real       FFRa;
  real       FFRb;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  const real onesixth  =  0.1666666666666667;
  const real onethird  =  0.3333333333333333;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;
  lam2              = lambda*lambda;
  L12               = L1*L1;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ntiA              = 3*ntype*type[ii];
    ntiB              = 3*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      tjA               = ntiA+3*type[jnr];
      tjB               = ntiB+3*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      cexp1a            = nbfp[tjA+1];
      cexp1b            = nbfp[tjB+1];
      cexp2a            = nbfp[tjA+2];
      cexp2b            = nbfp[tjB+2];
      sigma6a           = defsigma6;
      sigma6b           = defsigma6;
      sigma6a           = defsigma6;
      sigma6b           = defsigma6;
      rfour             = rsq11*rsq11;
      rsix              = rfour*rsq11;
      if((c6a > 0) || (cexp1a > 0)) {
        rA                = pow(Alpha*sigma6a*lam2+rsix,onesixth);
        rinva             = 1.0/rA;
        rinv5a            = rinva*rinva;
        rinv5a            = rinv5a*rinv5a*rinva;
        rt                = rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDa              = c6a*VV;
        FFDa              = c6a*tabscale*FF;
        rt                = cexp2a*rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRa              = cexp1a*VV;
        FFRa              = cexp1a*cexp2a*exptabscale*FF;
      } else {
        VVDa              = 0;
        FFDa              = 0;
        VVRa              = 0;
        FFRa              = 0;
        rinv5a            = 0;
      }
      if((c6b > 0) || (cexp1b > 0)) {
        rB                = pow(Alpha*sigma6b*L12+rsix,onesixth);
        rinvb             = 1.0/rB;
        rinv5b            = rinvb*rinvb;
        rinv5b            = rinv5b*rinv5b*rinvb;
        rt                = rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDb              = c6b*VV;
        FFDb              = c6b*tabscale*FF;
        rt                = cexp2b*rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRb              = cexp1b*VV;
        FFRb              = cexp1b*cexp2b*exptabscale*FF;
      } else {
        VVDb              = 0;
        FFDb              = 0;
        VVRb              = 0;
        FFRb              = 0;
        rinv5b            = 0;
      }
      vnbtot            = vnbtot + lambda*(VVDb+VVRb)+L1*(VVDa+VVRa);
      Fa                = -(FFDa+FFRa);
      Fb                = -(FFDb+FFRb);
      fs11              = (L1*Fa*rinv5a + lambda*Fb*rinv5b)*rfour;
      dvdl              = 
        dvdl + VVDb+VVRb-VVDa-VVRa+onethird*Alpha*lambda*L1*(Fb*sigma6b*rinv5b-Fa*sigma6a*rinv5a);
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl0410
   * Forces:      Calculated
   * Coulomb:     Not calculated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl0410(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ii                = ii + nscoul-nsvdwc;
    ii3               = 3*ii;
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1000
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Not calculated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl1000(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      rinvsq11          = rinv11*rinv11;
      qq                = iqA*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1010
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Not calculated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl1010(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1020
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl1020(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinvsq11          = rinv11*rinv11;
      qq                = qO*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1030
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl1030(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      rinvsq11          = rinv11*rinv11;
      vcoul             = qqOO*rinv11;
      fs11              = (vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      vcoul             = qqOH*rinv12;
      fs12              = (vcoul)*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      vcoul             = qqOH*rinv13;
      fs13              = (vcoul)*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      vcoul             = qqOH*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      vcoul             = qqHH*rinv22;
      fs22              = (vcoul)*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      vcoul             = qqHH*rinv23;
      fs23              = (vcoul)*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      vcoul             = qqOH*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      vcoul             = qqHH*rinv32;
      fs32              = (vcoul)*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      vcoul             = qqHH*rinv33;
      fs33              = (vcoul)*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1100
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Lennard-Jones
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl1100(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      qq                = iqA*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (twelve*vnb12-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1110
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Lennard-Jones
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl1110(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (twelve*vnb12-six*vnb6+vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinvsq11          = 1.0/(rsq11);
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1120
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl1120(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      qq                = qO*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (twelve*vnb12-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1130
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl1130(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      vnb12             = c12*rinvsix*rinvsix;
      vnbtot            = vnbtot + vnb12-vnb6;
      vcoul             = qqOO*rinv11;
      fs11              = (twelve*vnb12-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      vcoul             = qqOH*rinv12;
      fs12              = (vcoul)*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      vcoul             = qqOH*rinv13;
      fs13              = (vcoul)*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      vcoul             = qqOH*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      vcoul             = qqHH*rinv22;
      fs22              = (vcoul)*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      vcoul             = qqHH*rinv23;
      fs23              = (vcoul)*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      vcoul             = qqOH*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      vcoul             = qqHH*rinv32;
      fs32              = (vcoul)*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      vcoul             = qqHH*rinv33;
      fs33              = (vcoul)*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1200
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl1200(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      qq                = iqA*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (br*vnbexp-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1210
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl1210(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (br*vnbexp-six*vnb6+vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1220
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl1220(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      qq                = qO*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = (br*vnbexp-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1230
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl1230(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      br                = cexp2*r11;
      vnbexp            = cexp1*exp(-br);
      vnbtot            = vnbtot + vnbexp-vnb6;
      vcoul             = qqOO*rinv11;
      fs11              = (br*vnbexp-six*vnb6+vcoul)*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      vcoul             = qqOH*rinv12;
      fs12              = (vcoul)*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      vcoul             = qqOH*rinv13;
      fs13              = (vcoul)*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      vcoul             = qqOH*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      vcoul             = qqHH*rinv22;
      fs22              = (vcoul)*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      vcoul             = qqHH*rinv23;
      fs23              = (vcoul)*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      vcoul             = qqOH*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      vcoul             = qqHH*rinv32;
      fs32              = (vcoul)*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      vcoul             = qqHH*rinv33;
      fs33              = (vcoul)*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1300
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl1300(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      qq                = iqA*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = ((vcoul)*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1310
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl1310(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = ((vcoul)*rinv11-((fijD+fijR)*tabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijD+fijR)*tabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1320
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl1320(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      qq                = qO*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = ((vcoul)*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1330
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl1330(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      vcoul             = qqOO*rinv11;
      fs11              = ((vcoul)*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      vcoul             = qqOH*rinv12;
      fs12              = (vcoul)*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      vcoul             = qqOH*rinv13;
      fs13              = (vcoul)*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      vcoul             = qqOH*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      vcoul             = qqHH*rinv22;
      fs22              = (vcoul)*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      vcoul             = qqHH*rinv23;
      fs23              = (vcoul)*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      vcoul             = qqOH*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      vcoul             = qqHH*rinv32;
      fs32              = (vcoul)*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      vcoul             = qqHH*rinv33;
      fs33              = (vcoul)*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1400
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl1400(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      qq                = iqA*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = 
        ((vcoul)*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1410
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl1410(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = 
          ((vcoul)*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        vcoul             = qq*rinv11;
        fs11              = (vcoul)*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1420
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl1420(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      qq                = qO*charge[jnr];
      vcoul             = qq*rinv11;
      fs11              = 
        ((vcoul)*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      vcoul             = qq*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl1430
   * Forces:      Calculated
   * Coulomb:     Normal
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl1430(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      vcoul             = qqOO*rinv11;
      fs11              = 
        ((vcoul)*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      vcoul             = qqOH*rinv12;
      fs12              = (vcoul)*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      vcoul             = qqOH*rinv13;
      fs13              = (vcoul)*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      vcoul             = qqOH*rinv21;
      fs21              = (vcoul)*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      vcoul             = qqHH*rinv22;
      fs22              = (vcoul)*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      vcoul             = qqHH*rinv23;
      fs23              = (vcoul)*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      vcoul             = qqOH*rinv31;
      fs31              = (vcoul)*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      vcoul             = qqHH*rinv32;
      fs32              = (vcoul)*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      vcoul             = qqHH*rinv33;
      fs33              = (vcoul)*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2000
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Not calculated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl2000(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      rinvsq11          = rinv11*rinv11;
      qq                = iqA*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2010
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Not calculated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl2010(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       krsq;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2020
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl2020(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qq;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinvsq11          = rinv11*rinv11;
      qq                = qO*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq21;
      vcoul             = qq*(rinv21+krsq-crf);
      fs21              = (qq*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq31;
      vcoul             = qq*(rinv31+krsq-crf);
      fs31              = (qq*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2030
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl2030(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       vctot;
  real       vcoul;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      rinvsq11          = rinv11*rinv11;
      krsq              = krf*rsq11;
      vcoul             = qqOO*(rinv11+krsq-crf);
      fs11              = (qqOO*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      krsq              = krf*rsq12;
      vcoul             = qqOH*(rinv12+krsq-crf);
      fs12              = (qqOH*(rinv12-two*krsq))*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      krsq              = krf*rsq13;
      vcoul             = qqOH*(rinv13+krsq-crf);
      fs13              = (qqOH*(rinv13-two*krsq))*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      krsq              = krf*rsq21;
      vcoul             = qqOH*(rinv21+krsq-crf);
      fs21              = (qqOH*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      krsq              = krf*rsq22;
      vcoul             = qqHH*(rinv22+krsq-crf);
      fs22              = (qqHH*(rinv22-two*krsq))*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      krsq              = krf*rsq23;
      vcoul             = qqHH*(rinv23+krsq-crf);
      fs23              = (qqHH*(rinv23-two*krsq))*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      krsq              = krf*rsq31;
      vcoul             = qqOH*(rinv31+krsq-crf);
      fs31              = (qqOH*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      krsq              = krf*rsq32;
      vcoul             = qqHH*(rinv32+krsq-crf);
      fs32              = (qqHH*(rinv32-two*krsq))*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      krsq              = krf*rsq33;
      vcoul             = qqHH*(rinv33+krsq-crf);
      fs33              = (qqHH*(rinv33-two*krsq))*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2100
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Lennard-Jones
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl2100(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      qq                = iqA*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (twelve*vnb12-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2110
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Lennard-Jones
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl2110(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       krsq;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = 
          (twelve*vnb12-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinvsq11          = 1.0/(rsq11);
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2120
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl2120(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      qq                = qO*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (twelve*vnb12-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq21;
      vcoul             = qq*(rinv21+krsq-crf);
      fs21              = (qq*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq31;
      vcoul             = qq*(rinv31+krsq-crf);
      fs31              = (qq*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2130
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl2130(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      vnb12             = c12*rinvsix*rinvsix;
      vnbtot            = vnbtot + vnb12-vnb6;
      krsq              = krf*rsq11;
      vcoul             = qqOO*(rinv11+krsq-crf);
      fs11              = 
        (twelve*vnb12-six*vnb6+qqOO*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      krsq              = krf*rsq12;
      vcoul             = qqOH*(rinv12+krsq-crf);
      fs12              = (qqOH*(rinv12-two*krsq))*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      krsq              = krf*rsq13;
      vcoul             = qqOH*(rinv13+krsq-crf);
      fs13              = (qqOH*(rinv13-two*krsq))*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      krsq              = krf*rsq21;
      vcoul             = qqOH*(rinv21+krsq-crf);
      fs21              = (qqOH*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      krsq              = krf*rsq22;
      vcoul             = qqHH*(rinv22+krsq-crf);
      fs22              = (qqHH*(rinv22-two*krsq))*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      krsq              = krf*rsq23;
      vcoul             = qqHH*(rinv23+krsq-crf);
      fs23              = (qqHH*(rinv23-two*krsq))*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      krsq              = krf*rsq31;
      vcoul             = qqOH*(rinv31+krsq-crf);
      fs31              = (qqOH*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      krsq              = krf*rsq32;
      vcoul             = qqHH*(rinv32+krsq-crf);
      fs32              = (qqHH*(rinv32-two*krsq))*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      krsq              = krf*rsq33;
      vcoul             = qqHH*(rinv33+krsq-crf);
      fs33              = (qqHH*(rinv33-two*krsq))*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2200
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl2200(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      qq                = iqA*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (br*vnbexp-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2210
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl2210(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  real       krsq;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (br*vnbexp-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2220
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl2220(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      qq                = qO*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = (br*vnbexp-six*vnb6+qq*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq21;
      vcoul             = qq*(rinv21+krsq-crf);
      fs21              = (qq*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq31;
      vcoul             = qq*(rinv31+krsq-crf);
      fs31              = (qq*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2230
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl2230(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  real       krsq;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      br                = cexp2*r11;
      vnbexp            = cexp1*exp(-br);
      vnbtot            = vnbtot + vnbexp-vnb6;
      krsq              = krf*rsq11;
      vcoul             = qqOO*(rinv11+krsq-crf);
      fs11              = (br*vnbexp-six*vnb6+qqOO*(rinv11-two*krsq))*rinvsq11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      krsq              = krf*rsq12;
      vcoul             = qqOH*(rinv12+krsq-crf);
      fs12              = (qqOH*(rinv12-two*krsq))*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      krsq              = krf*rsq13;
      vcoul             = qqOH*(rinv13+krsq-crf);
      fs13              = (qqOH*(rinv13-two*krsq))*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      krsq              = krf*rsq21;
      vcoul             = qqOH*(rinv21+krsq-crf);
      fs21              = (qqOH*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      krsq              = krf*rsq22;
      vcoul             = qqHH*(rinv22+krsq-crf);
      fs22              = (qqHH*(rinv22-two*krsq))*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      krsq              = krf*rsq23;
      vcoul             = qqHH*(rinv23+krsq-crf);
      fs23              = (qqHH*(rinv23-two*krsq))*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      krsq              = krf*rsq31;
      vcoul             = qqOH*(rinv31+krsq-crf);
      fs31              = (qqOH*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      krsq              = krf*rsq32;
      vcoul             = qqHH*(rinv32+krsq-crf);
      fs32              = (qqHH*(rinv32-two*krsq))*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      krsq              = krf*rsq33;
      vcoul             = qqHH*(rinv33+krsq-crf);
      fs33              = (qqHH*(rinv33-two*krsq))*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2300
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl2300(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      qq                = iqA*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = 
        ((qq*(rinv11-two*krsq))*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2310
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl2310(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = 
          ((qq*(rinv11-two*krsq))*rinv11-((fijD+fijR)*tabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijD+fijR)*tabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2320
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl2320(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qO;
  real       qH;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      qq                = qO*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = 
        ((qq*(rinv11-two*krsq))*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq21;
      vcoul             = qq*(rinv21+krsq-crf);
      fs21              = (qq*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq31;
      vcoul             = qq*(rinv31+krsq-crf);
      fs31              = (qq*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2330
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl2330(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      krsq              = krf*rsq11;
      vcoul             = qqOO*(rinv11+krsq-crf);
      fs11              = 
        ((qqOO*(rinv11-two*krsq))*rinv11-((fijD+fijR)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      krsq              = krf*rsq12;
      vcoul             = qqOH*(rinv12+krsq-crf);
      fs12              = (qqOH*(rinv12-two*krsq))*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      krsq              = krf*rsq13;
      vcoul             = qqOH*(rinv13+krsq-crf);
      fs13              = (qqOH*(rinv13-two*krsq))*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      krsq              = krf*rsq21;
      vcoul             = qqOH*(rinv21+krsq-crf);
      fs21              = (qqOH*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      krsq              = krf*rsq22;
      vcoul             = qqHH*(rinv22+krsq-crf);
      fs22              = (qqHH*(rinv22-two*krsq))*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      krsq              = krf*rsq23;
      vcoul             = qqHH*(rinv23+krsq-crf);
      fs23              = (qqHH*(rinv23-two*krsq))*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      krsq              = krf*rsq31;
      vcoul             = qqOH*(rinv31+krsq-crf);
      fs31              = (qqOH*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      krsq              = krf*rsq32;
      vcoul             = qqHH*(rinv32+krsq-crf);
      fs32              = (qqHH*(rinv32-two*krsq))*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      krsq              = krf*rsq33;
      vcoul             = qqHH*(rinv33+krsq-crf);
      fs33              = (qqHH*(rinv33-two*krsq))*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2400
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl2400(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      qq                = iqA*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = 
        ((qq*(rinv11-two*krsq))*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2410
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl2410(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = 
          ((qq*(rinv11-two*krsq))*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        rinvsq11          = rinv11*rinv11;
        qq                = iqA*charge[jnr];
        krsq              = krf*rsq11;
        vcoul             = qq*(rinv11+krsq-crf);
        fs11              = (qq*(rinv11-two*krsq))*rinvsq11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 8*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2420
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl2420(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qO;
  real       qH;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       rinvsq21;
  real       rinvsq31;
  real       r11;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      qq                = qO*charge[jnr];
      krsq              = krf*rsq11;
      vcoul             = qq*(rinv11+krsq-crf);
      fs11              = 
        ((qq*(rinv11-two*krsq))*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq21          = rinv21*rinv21;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq21;
      vcoul             = qq*(rinv21+krsq-crf);
      fs21              = (qq*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq31          = rinv31*rinv31;
      qq                = qH*charge[jnr];
      krsq              = krf*rsq31;
      vcoul             = qq*(rinv31+krsq-crf);
      fs31              = (qq*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl2430
   * Forces:      Calculated
   * Coulomb:     Reaction field
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl2430(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real krf,
	           real crf,
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       krsq;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       rinvsq12;
  real       rinvsq13;
  real       rinvsq21;
  real       rinvsq22;
  real       rinvsq23;
  real       rinvsq31;
  real       rinvsq32;
  real       rinvsq33;
  real       r11;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 8*n0;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      krsq              = krf*rsq11;
      vcoul             = qqOO*(rinv11+krsq-crf);
      fs11              = 
        ((qqOO*(rinv11-two*krsq))*rinv11-((fijD)*tabscale+(fijR)*exptabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      rinvsq12          = rinv12*rinv12;
      krsq              = krf*rsq12;
      vcoul             = qqOH*(rinv12+krsq-crf);
      fs12              = (qqOH*(rinv12-two*krsq))*rinvsq12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      rinvsq13          = rinv13*rinv13;
      krsq              = krf*rsq13;
      vcoul             = qqOH*(rinv13+krsq-crf);
      fs13              = (qqOH*(rinv13-two*krsq))*rinvsq13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      rinvsq21          = rinv21*rinv21;
      krsq              = krf*rsq21;
      vcoul             = qqOH*(rinv21+krsq-crf);
      fs21              = (qqOH*(rinv21-two*krsq))*rinvsq21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      rinvsq22          = rinv22*rinv22;
      krsq              = krf*rsq22;
      vcoul             = qqHH*(rinv22+krsq-crf);
      fs22              = (qqHH*(rinv22-two*krsq))*rinvsq22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      rinvsq23          = rinv23*rinv23;
      krsq              = krf*rsq23;
      vcoul             = qqHH*(rinv23+krsq-crf);
      fs23              = (qqHH*(rinv23-two*krsq))*rinvsq23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      rinvsq31          = rinv31*rinv31;
      krsq              = krf*rsq31;
      vcoul             = qqOH*(rinv31+krsq-crf);
      fs31              = (qqOH*(rinv31-two*krsq))*rinvsq31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      rinvsq32          = rinv32*rinv32;
      krsq              = krf*rsq32;
      vcoul             = qqHH*(rinv32+krsq-crf);
      fs32              = (qqHH*(rinv32-two*krsq))*rinvsq32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      rinvsq33          = rinv33*rinv33;
      krsq              = krf*rsq33;
      vcoul             = qqHH*(rinv33+krsq-crf);
      fs33              = (qqHH*(rinv33-two*krsq))*rinvsq33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3000
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl3000(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = iqA*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = -((fijC)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3001
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: No
   * Free energy: Lambda (alpha=0)
   **********************************************************/
void inl3001(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	           real chargeB[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       qqq;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       dvdl;
  real       L1;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qqA               = iqA*charge[jnr];
      qqB               = iqB*chargeB[jnr];
      qqq               = L1*qqA + lambda*qqB;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqq*VV;
      fijC              = qqq*FF;
      dvdl              = dvdl + (qqB - qqA)*VV;
      fs11              = -((fijC)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3002
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: No
   * Free energy: Softcore
   **********************************************************/
void inl3002(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	           real chargeB[],
	            int typeB[],
	           real Alpha,
	           real defsigma6)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       c6a;
  real       c12a;
  real       c6b;
  real       c12b;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       dvdl;
  real       L1;
  real       L12;
  real       lam2;
  real       sigma6a;
  real       sigma6b;
  real       rA;
  real       rB;
  real       rfour;
  real       rsix;
  real       rinva;
  real       rinvb;
  real       rinv5a;
  real       rinv5b;
  real       Fa;
  real       Fb;
  real       VVCa;
  real       VVCb;
  real       FFCa;
  real       FFCb;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  const real onesixth  =  0.1666666666666667;
  const real onethird  =  0.3333333333333333;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;
  lam2              = lambda*lambda;
  L12               = L1*L1;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    ntiA              = 2*ntype*type[ii];
    ntiB              = 2*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      tjA               = ntiA+2*type[jnr];
      tjB               = ntiB+2*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c12a              = nbfp[tjA+1];
      c12b              = nbfp[tjB+1];
      if((c6a > 0) && (c12a > 0)) {
        sigma6a           = c12a/c6a;
      } else {
        sigma6a           = defsigma6;
      }
      if((c6b > 0) && (c12b > 0)) {
        sigma6b           = c12b/c6b;
      } else {
        sigma6b           = defsigma6;
      }
      rfour             = rsq11*rsq11;
      rsix              = rfour*rsq11;
      qqA               = iqA*charge[jnr];
      if((qqA != 0)) {
        rA                = pow(Alpha*sigma6a*lam2+rsix,onesixth);
        rinva             = 1.0/rA;
        rinv5a            = rinva*rinva;
        rinv5a            = rinv5a*rinv5a*rinva;
        rt                = rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCa              = qqA*VV;
        FFCa              = qqA*tabscale*FF;
      } else {
        VVCa              = 0;
        FFCa              = 0;
        rinv5a            = 0;
      }
      qqB               = iqB*chargeB[jnr];
      if((qqB != 0)) {
        rB                = pow(Alpha*sigma6b*L12+rsix,onesixth);
        rinvb             = 1.0/rB;
        rinv5b            = rinvb*rinvb;
        rinv5b            = rinv5b*rinv5b*rinvb;
        rt                = rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCb              = qqB*VV;
        FFCb              = qqB*tabscale*FF;
      } else {
        VVCb              = 0;
        FFCb              = 0;
        rinv5b            = 0;
      }
      vcoul             = lambda*VVCb+L1*VVCa;
      Fa                = -(FFCa);
      Fb                = -(FFCb);
      fs11              = (L1*Fa*rinv5a + lambda*Fb*rinv5b)*rfour;
      dvdl              = 
        dvdl + VVCb-VVCa+onethird*Alpha*lambda*L1*(Fb*sigma6b*rinv5b-Fa*sigma6a*rinv5a);
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3010
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl3010(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = -((fijC)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3020
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl3020(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       r11;
  real       r21;
  real       r31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qO*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = -((fijC)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3030
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Not calculated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl3030(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       r11;
  real       r12;
  real       r13;
  real       r21;
  real       r22;
  real       r23;
  real       r31;
  real       r32;
  real       r33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOO*VV;
      fijC              = qqOO*FF;
      fs11              = -((fijC)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r12               = rsq12*rinv12;
      rt                = r12*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs12              = -((fijC)*tabscale)*rinv12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      r13               = rsq13*rinv13;
      rt                = r13*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs13              = -((fijC)*tabscale)*rinv13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r22               = rsq22*rinv22;
      rt                = r22*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs22              = -((fijC)*tabscale)*rinv22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      r23               = rsq23*rinv23;
      rt                = r23*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs23              = -((fijC)*tabscale)*rinv23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      r32               = rsq32*rinv32;
      rt                = r32*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs32              = -((fijC)*tabscale)*rinv32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      r33               = rsq33*rinv33;
      rt                = r33*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs33              = -((fijC)*tabscale)*rinv33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3100
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl3100(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = iqA*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = 
        ((twelve*vnb12-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3110
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl3110(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = 
          ((twelve*vnb12-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = -((fijC)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinvsq11          = 1.0/(rsq11);
        r11               = rsq11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+2*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
        vnbtot            = vnbtot + vnb12-vnb6;
        fs11              = (twelve*vnb12-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3120
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl3120(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       r11;
  real       r21;
  real       r31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+2*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      vnb12             = rinvsix*rinvsix*nbfp[tjA+1];
      vnbtot            = vnbtot + vnb12-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qO*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = 
        ((twelve*vnb12-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3130
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Lennard-Jones
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl3130(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  const real twelve  =  12.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       r11;
  real       r12;
  real       r13;
  real       r21;
  real       r22;
  real       r23;
  real       r31;
  real       r32;
  real       r33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      vnb12             = c12*rinvsix*rinvsix;
      vnbtot            = vnbtot + vnb12-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOO*VV;
      fijC              = qqOO*FF;
      fs11              = 
        ((twelve*vnb12-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r12               = rsq12*rinv12;
      rt                = r12*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs12              = -((fijC)*tabscale)*rinv12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      r13               = rsq13*rinv13;
      rt                = r13*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs13              = -((fijC)*tabscale)*rinv13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r22               = rsq22*rinv22;
      rt                = r22*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs22              = -((fijC)*tabscale)*rinv22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      r23               = rsq23*rinv23;
      rt                = r23*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs23              = -((fijC)*tabscale)*rinv23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      r32               = rsq32*rinv32;
      rt                = r32*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs32              = -((fijC)*tabscale)*rinv32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      r33               = rsq33*rinv33;
      rt                = r33*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs33              = -((fijC)*tabscale)*rinv33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3200
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl3200(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = iqA*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = 
        ((br*vnbexp-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3210
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl3210(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       rinvsq11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = 
          ((br*vnbexp-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 4*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = -((fijC)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rinvsq11          = rinv11*rinv11;
        rinvsix           = rinvsq11*rinvsq11*rinvsq11;
        tjA               = ntiA+3*type[jnr];
        vnb6              = rinvsix*nbfp[tjA];
        br                = r11*nbfp[tjA+2];
        vnbexp            = exp(-br)*nbfp[tjA+1];
        vnbtot            = vnbtot + vnbexp-vnb6;
        fs11              = (br*vnbexp-six*vnb6)*rinvsq11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3220
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl3220(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       rinvsix;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       rinvsq11;
  real       r11;
  real       r21;
  real       r31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      tjA               = ntiA+3*type[jnr];
      vnb6              = rinvsix*nbfp[tjA];
      br                = r11*nbfp[tjA+2];
      vnbexp            = exp(-br)*nbfp[tjA+1];
      vnbtot            = vnbtot + vnbexp-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qO*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs11              = 
        ((br*vnbexp-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3230
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl3230(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       rinvsix;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  real       br;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  const real six  =  6.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       rinvsq11;
  real       r11;
  real       r12;
  real       r13;
  real       r21;
  real       r22;
  real       r23;
  real       r31;
  real       r32;
  real       r33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rinvsq11          = rinv11*rinv11;
      rinvsix           = rinvsq11*rinvsq11*rinvsq11;
      vnb6              = c6*rinvsix;
      br                = cexp2*r11;
      vnbexp            = cexp1*exp(-br);
      vnbtot            = vnbtot + vnbexp-vnb6;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOO*VV;
      fijC              = qqOO*FF;
      fs11              = 
        ((br*vnbexp-six*vnb6)*rinv11-((fijC)*tabscale))*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r12               = rsq12*rinv12;
      rt                = r12*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs12              = -((fijC)*tabscale)*rinv12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      r13               = rsq13*rinv13;
      rt                = r13*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs13              = -((fijC)*tabscale)*rinv13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r22               = rsq22*rinv22;
      rt                = r22*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs22              = -((fijC)*tabscale)*rinv22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      r23               = rsq23*rinv23;
      rt                = r23*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs23              = -((fijC)*tabscale)*rinv23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      r32               = rsq32*rinv32;
      rt                = r32*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs32              = -((fijC)*tabscale)*rinv32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      r33               = rsq33*rinv33;
      rt                = r33*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 4*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs33              = -((fijC)*tabscale)*rinv33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3300
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl3300(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 2*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = iqA*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      fs11              = -((fijC+fijD+fijR)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3301
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: Lambda (alpha=0)
   **********************************************************/
void inl3301(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	           real chargeB[],
	            int typeB[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       qqq;
  real       c6;
  real       c12;
  real       c6a;
  real       c12a;
  real       c6b;
  real       c12b;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       dvdl;
  real       L1;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    ntiA              = 2*ntype*type[ii];
    ntiB              = 2*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qqA               = iqA*charge[jnr];
      qqB               = iqB*chargeB[jnr];
      qqq               = L1*qqA + lambda*qqB;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqq*VV;
      fijC              = qqq*FF;
      dvdl              = dvdl + (qqB - qqA)*VV;
      tjA               = ntiA+2*type[jnr];
      tjB               = ntiB+2*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c6                = L1*c6a + lambda*c6b;
      c12a              = nbfp[tjA+1];
      c12b              = nbfp[tjB+1];
      c12               = L1*c12a + lambda*c12b;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      dvdl              = dvdl + (c6b - c6a)*VV;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      dvdl              = dvdl + (c12b - c12a)*VV;
      fs11              = -((fijC+fijD+fijR)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3302
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: No
   * Free energy: Softcore
   **********************************************************/
void inl3302(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real lambda,
	           real *dvdlambda,
	           real chargeB[],
	            int typeB[],
	           real Alpha,
	           real defsigma6)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       c6a;
  real       c12a;
  real       c6b;
  real       c12b;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       dvdl;
  real       L1;
  real       L12;
  real       lam2;
  real       sigma6a;
  real       sigma6b;
  real       rA;
  real       rB;
  real       rfour;
  real       rsix;
  real       rinva;
  real       rinvb;
  real       rinv5a;
  real       rinv5b;
  real       Fa;
  real       Fb;
  real       vnbtot;
  real       VVCa;
  real       VVCb;
  real       FFCa;
  real       FFCb;
  real       VVDa;
  real       VVDb;
  real       FFDa;
  real       FFDb;
  real       VVRa;
  real       VVRb;
  real       FFRa;
  real       FFRb;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  const real onesixth  =  0.1666666666666667;
  const real onethird  =  0.3333333333333333;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;
  lam2              = lambda*lambda;
  L12               = L1*L1;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    ntiA              = 2*ntype*type[ii];
    ntiB              = 2*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      tjA               = ntiA+2*type[jnr];
      tjB               = ntiB+2*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c12a              = nbfp[tjA+1];
      c12b              = nbfp[tjB+1];
      if((c6a > 0) && (c12a > 0)) {
        sigma6a           = c12a/c6a;
      } else {
        sigma6a           = defsigma6;
      }
      if((c6b > 0) && (c12b > 0)) {
        sigma6b           = c12b/c6b;
      } else {
        sigma6b           = defsigma6;
      }
      rfour             = rsq11*rsq11;
      rsix              = rfour*rsq11;
      qqA               = iqA*charge[jnr];
      if((qqA != 0) || (c6a > 0) || (c12a > 0)) {
        rA                = pow(Alpha*sigma6a*lam2+rsix,onesixth);
        rinva             = 1.0/rA;
        rinv5a            = rinva*rinva;
        rinv5a            = rinv5a*rinv5a*rinva;
        rt                = rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCa              = qqA*VV;
        FFCa              = qqA*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDa              = c6a*VV;
        FFDa              = c6a*tabscale*FF;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRa              = c12a*VV;
        FFRa              = c12a*tabscale*FF;
      } else {
        VVCa              = 0;
        FFCa              = 0;
        VVDa              = 0;
        FFDa              = 0;
        VVRa              = 0;
        FFRa              = 0;
        rinv5a            = 0;
      }
      qqB               = iqB*chargeB[jnr];
      if((qqB != 0) || (c6b > 0) || (c12b > 0)) {
        rB                = pow(Alpha*sigma6b*L12+rsix,onesixth);
        rinvb             = 1.0/rB;
        rinv5b            = rinvb*rinvb;
        rinv5b            = rinv5b*rinv5b*rinvb;
        rt                = rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCb              = qqB*VV;
        FFCb              = qqB*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDb              = c6b*VV;
        FFDb              = c6b*tabscale*FF;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRb              = c12b*VV;
        FFRb              = c12b*tabscale*FF;
      } else {
        VVCb              = 0;
        FFCb              = 0;
        VVDb              = 0;
        FFDb              = 0;
        VVRb              = 0;
        FFRb              = 0;
        rinv5b            = 0;
      }
      vcoul             = lambda*VVCb+L1*VVCa;
      vnbtot            = vnbtot + lambda*(VVDb+VVRb)+L1*(VVDa+VVRa);
      Fa                = -(FFCa+FFDa+FFRa);
      Fb                = -(FFCb+FFDb+FFRb);
      fs11              = (L1*Fa*rinv5a + lambda*Fb*rinv5b)*rfour;
      dvdl              = 
        dvdl + VVCb-VVCa+VVDb+VVRb-VVDa-VVRa+onethird*Alpha*lambda*L1*(Fb*sigma6b*rinv5b-Fa*sigma6a*rinv5a);
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3310
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl3310(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijC+fijD+fijR)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = -((fijC)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 2*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        tjA               = ntiA+2*type[jnr];
        c6                = nbfp[tjA];
        c12               = nbfp[tjA+1];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb12             = c12*VV;
        fijR              = c12*FF;
        vnbtot            = vnbtot + vnb6 + vnb12;
        fs11              = -((fijD+fijR)*tabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3320
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl3320(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       r11;
  real       r21;
  real       r31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 2*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qO*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      tjA               = ntiA+2*type[jnr];
      c6                = nbfp[tjA];
      c12               = nbfp[tjA+1];
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      fs11              = -((fijC+fijD+fijR)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3330
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl3330(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       c6;
  real       c12;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnb12;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       r11;
  real       r12;
  real       r13;
  real       r21;
  real       r22;
  real       r23;
  real       r31;
  real       r32;
  real       r33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 2*ntype*type[ii];
  tjA               = ntiA+2*type[ii];
  c6                = nbfp[tjA];
  c12               = nbfp[tjA+1];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOO*VV;
      fijC              = qqOO*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb12             = c12*VV;
      fijR              = c12*FF;
      vnbtot            = vnbtot + vnb6 + vnb12;
      fs11              = -((fijC+fijD+fijR)*tabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r12               = rsq12*rinv12;
      rt                = r12*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs12              = -((fijC)*tabscale)*rinv12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      r13               = rsq13*rinv13;
      rt                = r13*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs13              = -((fijC)*tabscale)*rinv13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r22               = rsq22*rinv22;
      rt                = r22*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs22              = -((fijC)*tabscale)*rinv22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      r23               = rsq23*rinv23;
      rt                = r23*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs23              = -((fijC)*tabscale)*rinv23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      r32               = rsq32*rinv32;
      rt                = r32*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs32              = -((fijC)*tabscale)*rinv32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      r33               = rsq33*rinv33;
      rt                = r33*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs33              = -((fijC)*tabscale)*rinv33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3400
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: No
   **********************************************************/
void inl3400(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;


  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    ntiA              = 3*ntype*type[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = iqA*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      fs11              = -((fijC+fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3401
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: Lambda (alpha=0)
   **********************************************************/
void inl3401(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	           real lambda,
	           real *dvdlambda,
	           real chargeB[],
	            int typeB[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       qqq;
  real       cexp1a;
  real       cexp2a;
  real       cexp1b;
  real       cexp2b;
  real       c6;
  real       c6a;
  real       c6b;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       dvdl;
  real       L1;
  real       vnbexpa;
  real       vnbexpb;
  real       fijRa;
  real       fijRb;
  real       vnb6;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    ntiA              = 3*ntype*type[ii];
    ntiB              = 3*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qqA               = iqA*charge[jnr];
      qqB               = iqB*chargeB[jnr];
      qqq               = L1*qqA + lambda*qqB;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqq*VV;
      fijC              = qqq*FF;
      dvdl              = dvdl + (qqB - qqA)*VV;
      tjA               = ntiA+3*type[jnr];
      tjB               = ntiB+3*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      c6                = L1*c6a + lambda*c6b;
      cexp1a            = nbfp[tjA+1];
      cexp1b            = nbfp[tjB+1];
      cexp2a            = nbfp[tjA+2];
      cexp2b            = nbfp[tjB+2];
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      dvdl              = dvdl + (c6b - c6a)*VV;
      rt                = cexp2a*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexpa           = cexp1a*VV;
      fijRa             = cexp1a*cexp2a*FF;
      rt                = cexp2b*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexpb           = cexp1b*VV;
      fijRb             = cexp1b*cexp2b*FF;
      fijR              = L1*fijRa + lambda*fijRb;
      vnbtot            = vnbtot + vnb6 + L1*vnbexpa + lambda*vnbexpb;
      dvdl              = dvdl + vnbexpb - vnbexpa;
      fs11              = -((fijC+fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3402
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: No
   * Free energy: Softcore
   **********************************************************/
void inl3402(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	           real lambda,
	           real *dvdlambda,
	           real chargeB[],
	            int typeB[],
	           real Alpha,
	           real defsigma6)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qqA;
  real       qqB;
  real       cexp1a;
  real       cexp2a;
  real       cexp1b;
  real       cexp2b;
  real       c6a;
  real       c6b;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       dvdl;
  real       L1;
  real       L12;
  real       lam2;
  real       sigma6a;
  real       sigma6b;
  real       rA;
  real       rB;
  real       rfour;
  real       rsix;
  real       rinva;
  real       rinvb;
  real       rinv5a;
  real       rinv5b;
  real       Fa;
  real       Fb;
  real       vnbtot;
  real       VVCa;
  real       VVCb;
  real       FFCa;
  real       FFCb;
  real       VVDa;
  real       VVDb;
  real       FFDa;
  real       FFDb;
  real       VVRa;
  real       VVRb;
  real       FFRa;
  real       FFRb;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real one  =  1.0000000000000000;
  const real two  =  2.0000000000000000;
  const real onesixth  =  0.1666666666666667;
  const real onethird  =  0.3333333333333333;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  real       iqB;
  int        ntiA;
  int        ntiB;
  int        tjA;
  int        tjB;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;

  dvdl              = nul;
  L1                = one - lambda;
  lam2              = lambda*lambda;
  L12               = L1*L1;

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    iqA               = facel*charge[ii];
    iqB               = facel*chargeB[ii];
    ntiA              = 3*ntype*type[ii];
    ntiB              = 3*ntype*typeB[ii];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      rinv11            = 1.0/sqrt(rsq11);
      r11               = rsq11*rinv11;
      tjA               = ntiA+3*type[jnr];
      tjB               = ntiB+3*typeB[jnr];
      c6a               = nbfp[tjA];
      c6b               = nbfp[tjB];
      cexp1a            = nbfp[tjA+1];
      cexp1b            = nbfp[tjB+1];
      cexp2a            = nbfp[tjA+2];
      cexp2b            = nbfp[tjB+2];
      sigma6a           = defsigma6;
      sigma6b           = defsigma6;
      sigma6a           = defsigma6;
      sigma6b           = defsigma6;
      rfour             = rsq11*rsq11;
      rsix              = rfour*rsq11;
      qqA               = iqA*charge[jnr];
      if((qqA != 0) || (c6a > 0) || (cexp1a > 0)) {
        rA                = pow(Alpha*sigma6a*lam2+rsix,onesixth);
        rinva             = 1.0/rA;
        rinv5a            = rinva*rinva;
        rinv5a            = rinv5a*rinv5a*rinva;
        rt                = rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCa              = qqA*VV;
        FFCa              = qqA*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDa              = c6a*VV;
        FFDa              = c6a*tabscale*FF;
        rt                = cexp2a*rA*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRa              = cexp1a*VV;
        FFRa              = cexp1a*cexp2a*exptabscale*FF;
      } else {
        VVCa              = 0;
        FFCa              = 0;
        VVDa              = 0;
        FFDa              = 0;
        VVRa              = 0;
        FFRa              = 0;
        rinv5a            = 0;
      }
      qqB               = iqB*chargeB[jnr];
      if((qqB != 0) || (c6b > 0) || (cexp1b > 0)) {
        rB                = pow(Alpha*sigma6b*L12+rsix,onesixth);
        rinvb             = 1.0/rB;
        rinv5b            = rinvb*rinvb;
        rinv5b            = rinv5b*rinv5b*rinvb;
        rt                = rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVCb              = qqB*VV;
        FFCb              = qqB*tabscale*FF;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVDb              = c6b*VV;
        FFDb              = c6b*tabscale*FF;
        rt                = cexp2b*rB*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        VVRb              = cexp1b*VV;
        FFRb              = cexp1b*cexp2b*exptabscale*FF;
      } else {
        VVCb              = 0;
        FFCb              = 0;
        VVDb              = 0;
        FFDb              = 0;
        VVRb              = 0;
        FFRb              = 0;
        rinv5b            = 0;
      }
      vcoul             = lambda*VVCb+L1*VVCa;
      vnbtot            = vnbtot + lambda*(VVDb+VVRb)+L1*(VVDa+VVRa);
      Fa                = -(FFCa+FFDa+FFRa);
      Fb                = -(FFCb+FFDb+FFRb);
      fs11              = (L1*Fa*rinv5a + lambda*Fb*rinv5b)*rfour;
      dvdl              = 
        dvdl + VVCb-VVCa+VVDb+VVRb-VVDa-VVRa+onethird*Alpha*lambda*L1*(Fb*sigma6b*rinv5b-Fa*sigma6a*rinv5a);
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      faction[j3]       = faction[j3]-tx11;
      faction[j3+1]     = faction[j3+1]-ty11;
      faction[j3+2]     = faction[j3+2]-tz11;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    fshift[is3]       = fshift[is3] + fix1;
    fshift[is3+1]     = fshift[is3+1] + fiy1;
    fshift[is3+2]     = fshift[is3+2] + fiz1;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
  *dvdlambda        = *dvdlambda + dvdl;
}





  /**********************************************************
   * This is gromacs innerloop inl3410
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: general M:N:O solvent - other atom
   * Free energy: No
   **********************************************************/
void inl3410(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale,
	            int nsatoms[])
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        s;
  int        n0;
  int        n1;
  int        nnn;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       iqA;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       rsq11;
  real       rinv11;
  real       r11;
  real       fs11;
  real       tx11;
  real       ty11;
  real       tz11;
  int        nstot;
  int        nsvdwc;
  int        nscoul;


  for(n=0; (n<nri); n++) {
    nstot             = nsatoms[3*n];
    nsvdwc            = nsatoms[3*n+1];
    nscoul            = nsatoms[3*n+2];
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    for(s=0; (s<nsvdwc); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1+8;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijC+fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nsvdwc; (s<nscoul); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      iqA               = facel*charge[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        qq                = iqA*charge[jnr];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vcoul             = qq*VV;
        fijC              = qq*FF;
        fs11              = -((fijC)*tabscale)*rinv11;
        vctot             = vctot + vcoul;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    for(s=nscoul; (s<nstot); s++) {
      ix1               = shX + pos[ii3];
      iy1               = shY + pos[ii3+1];
      iz1               = shZ + pos[ii3+2];
      ntiA              = 3*ntype*type[ii];
      fix1              = nul;
      fiy1              = nul;
      fiz1              = nul;
      for(k=nj0; (k<nj1); k++) {
        jnr               = jjnr[k];
        j3                = 3*jnr;
        jx1               = pos[j3];
        jy1               = pos[j3+1];
        jz1               = pos[j3+2];
        dx11              = ix1 - jx1;
        dy11              = iy1 - jy1;
        dz11              = iz1 - jz1;
        rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
        rinv11            = 1.0/sqrt(rsq11);
        r11               = rsq11*rinv11;
        rt                = r11*tabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        tjA               = ntiA+3*type[jnr];
        c6                = nbfp[tjA];
        cexp1             = nbfp[tjA+1];
        cexp2             = nbfp[tjA+2];
        nnn               = n1;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnb6              = c6*VV;
        fijD              = c6*FF;
        rt                = cexp2*r11*exptabscale;
        n0                = rt;
        eps               = rt-n0;
        eps2              = eps*eps;
        n1                = 12*n0;
        nnn               = n1+4;
        Y                 = VFtab[nnn];
        F                 = VFtab[nnn+1];
        Geps              = eps*VFtab[nnn+2];
        Heps2             = eps2*VFtab[nnn+3];
        Fp                = F+Geps+Heps2;
        VV                = Y+eps*Fp;
        FF                = Fp+Geps+two*Heps2;
        vnbexp            = cexp1*VV;
        fijR              = cexp1*cexp2*FF;
        vnbtot            = vnbtot + vnb6 + vnbexp;
        fs11              = -((fijD)*tabscale+(fijR)*exptabscale)*rinv11;
        tx11              = dx11*fs11;
        ty11              = dy11*fs11;
        tz11              = dz11*fs11;
        fix1              = fix1 + tx11;
        fiy1              = fiy1 + ty11;
        fiz1              = fiz1 + tz11;
        faction[j3]       = faction[j3]-tx11;
        faction[j3+1]     = faction[j3+1]-ty11;
        faction[j3+2]     = faction[j3+2]-tz11;
      }
      faction[ii3]      = faction[ii3] + fix1;
      faction[ii3+1]    = faction[ii3+1] + fiy1;
      faction[ii3+2]    = faction[ii3+2] + fiz1;
      fshift[is3]       = fshift[is3] + fix1;
      fshift[is3+1]     = fshift[is3+1] + fiy1;
      fshift[is3+2]     = fshift[is3+2] + fiz1;
      ii                = ii + 1;
      ii3               = ii3 + 3;
    }
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3420
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - other atom
   * Free energy: No
   **********************************************************/
void inl3420(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qq;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx31;
  real       dy31;
  real       dz31;
  real       rsq11;
  real       rsq21;
  real       rsq31;
  real       rinv11;
  real       rinv21;
  real       rinv31;
  real       r11;
  real       r21;
  real       r31;
  real       fs11;
  real       fs21;
  real       fs31;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx31;
  real       ty31;
  real       tz31;
  real       fjx1;
  real       fjy1;
  real       fjz1;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qO                = qO*facel;
  qH                = qH*facel;
  ntiA              = 3*ntype*type[ii];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qO*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      tjA               = ntiA+3*type[jnr];
      c6                = nbfp[tjA];
      cexp1             = nbfp[tjA+1];
      cexp2             = nbfp[tjA+2];
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      fs11              = -((fijC+fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      qq                = qH*charge[jnr];
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qq*VV;
      fijC              = qq*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}





  /**********************************************************
   * This is gromacs innerloop inl3430
   * Forces:      Calculated
   * Coulomb:     Tabulated
   * Nonbonded:   Tabulated Buckingham
   * Solvent opt: Water (3 atoms) - water (3 atoms)
   * Free energy: No
   **********************************************************/
void inl3430(
	            int nri,
	            int iinr[],
	            int jindex[],
	            int jjnr[],
	            int shift[],
	           real shiftvec[],
	           real fshift[],
	            int gid[],
	           real pos[],
	           real faction[],
	           real charge[],
	           real facel,
	           real Vc[],
	            int type[],
	            int ntype,
	           real nbfp[],
	           real Vnb[],
	           real tabscale,
	           real VFtab[],
	           real exptabscale)
{
  int        ii;
  int        k;
  int        n;
  int        nj0;
  int        nj1;
  int        is3;
  int        ggid;
  int        ii3;
  int        n0;
  int        n1;
  int        nnn;
  real       qO;
  real       qH;
  real       qqOO;
  real       qqOH;
  real       qqHH;
  real       cexp1;
  real       cexp2;
  real       c6;
  real       vctot;
  real       vcoul;
  real       rt;
  real       eps;
  real       eps2;
  real       Y;
  real       F;
  real       Geps;
  real       Heps2;
  real       Fp;
  real       VV;
  real       FF;
  real       fijC;
  real       fijD;
  real       fijR;
  real       vnb6;
  real       vnbexp;
  real       vnbtot;
  int        j3;
  int        jnr;
  real       shX;
  real       shY;
  real       shZ;
  const real nul  =  0.0000000000000000;
  const real two  =  2.0000000000000000;
  real       ix1;
  real       iy1;
  real       iz1;
  real       ix2;
  real       iy2;
  real       iz2;
  real       ix3;
  real       iy3;
  real       iz3;
  int        ntiA;
  int        tjA;
  real       fix1;
  real       fiy1;
  real       fiz1;
  real       fix2;
  real       fiy2;
  real       fiz2;
  real       fix3;
  real       fiy3;
  real       fiz3;
  real       jx1;
  real       jy1;
  real       jz1;
  real       jx2;
  real       jy2;
  real       jz2;
  real       jx3;
  real       jy3;
  real       jz3;
  real       dx11;
  real       dy11;
  real       dz11;
  real       dx12;
  real       dy12;
  real       dz12;
  real       dx13;
  real       dy13;
  real       dz13;
  real       dx21;
  real       dy21;
  real       dz21;
  real       dx22;
  real       dy22;
  real       dz22;
  real       dx23;
  real       dy23;
  real       dz23;
  real       dx31;
  real       dy31;
  real       dz31;
  real       dx32;
  real       dy32;
  real       dz32;
  real       dx33;
  real       dy33;
  real       dz33;
  real       rsq11;
  real       rsq12;
  real       rsq13;
  real       rsq21;
  real       rsq22;
  real       rsq23;
  real       rsq31;
  real       rsq32;
  real       rsq33;
  real       rinv11;
  real       rinv12;
  real       rinv13;
  real       rinv21;
  real       rinv22;
  real       rinv23;
  real       rinv31;
  real       rinv32;
  real       rinv33;
  real       r11;
  real       r12;
  real       r13;
  real       r21;
  real       r22;
  real       r23;
  real       r31;
  real       r32;
  real       r33;
  real       fs11;
  real       fs12;
  real       fs13;
  real       fs21;
  real       fs22;
  real       fs23;
  real       fs31;
  real       fs32;
  real       fs33;
  real       tx11;
  real       ty11;
  real       tz11;
  real       tx12;
  real       ty12;
  real       tz12;
  real       tx13;
  real       ty13;
  real       tz13;
  real       tx21;
  real       ty21;
  real       tz21;
  real       tx22;
  real       ty22;
  real       tz22;
  real       tx23;
  real       ty23;
  real       tz23;
  real       tx31;
  real       ty31;
  real       tz31;
  real       tx32;
  real       ty32;
  real       tz32;
  real       tx33;
  real       ty33;
  real       tz33;
  real       fjx1;
  real       fjy1;
  real       fjz1;
  real       fjx2;
  real       fjy2;
  real       fjz2;
  real       fjx3;
  real       fjy3;
  real       fjz3;

  ii                = iinr[0];
  qO                = charge[ii];
  qH                = charge[ii+1];
  qqOO              = facel*qO*qO;
  qqOH              = facel*qO*qH;
  qqHH              = facel*qH*qH;
  ntiA              = 3*ntype*type[ii];
  tjA               = ntiA+3*type[ii];
  c6                = nbfp[tjA];
  cexp1             = nbfp[tjA+1];
  cexp2             = nbfp[tjA+2];

  for(n=0; (n<nri); n++) {
    is3               = 3*shift[n];
    shX               = shiftvec[is3];
    shY               = shiftvec[is3+1];
    shZ               = shiftvec[is3+2];
    ii                = iinr[n];
    ii3               = 3*ii;
    vctot             = nul;
    vnbtot            = nul;
    nj0               = jindex[n];
    nj1               = jindex[n+1];
    ix1               = shX + pos[ii3];
    iy1               = shY + pos[ii3+1];
    iz1               = shZ + pos[ii3+2];
    ix2               = shX + pos[ii3+3];
    iy2               = shY + pos[ii3+4];
    iz2               = shZ + pos[ii3+5];
    ix3               = shX + pos[ii3+6];
    iy3               = shY + pos[ii3+7];
    iz3               = shZ + pos[ii3+8];
    fix1              = nul;
    fiy1              = nul;
    fiz1              = nul;
    fix2              = nul;
    fiy2              = nul;
    fiz2              = nul;
    fix3              = nul;
    fiy3              = nul;
    fiz3              = nul;
    for(k=nj0; (k<nj1); k++) {
      jnr               = jjnr[k];
      j3                = 3*jnr;
      jx1               = pos[j3];
      jy1               = pos[j3+1];
      jz1               = pos[j3+2];
      jx2               = pos[j3+3];
      jy2               = pos[j3+4];
      jz2               = pos[j3+5];
      jx3               = pos[j3+6];
      jy3               = pos[j3+7];
      jz3               = pos[j3+8];
      dx11              = ix1 - jx1;
      dy11              = iy1 - jy1;
      dz11              = iz1 - jz1;
      rsq11             = dx11*dx11+dy11*dy11+dz11*dz11;
      dx12              = ix1 - jx2;
      dy12              = iy1 - jy2;
      dz12              = iz1 - jz2;
      rsq12             = dx12*dx12+dy12*dy12+dz12*dz12;
      dx13              = ix1 - jx3;
      dy13              = iy1 - jy3;
      dz13              = iz1 - jz3;
      rsq13             = dx13*dx13+dy13*dy13+dz13*dz13;
      dx21              = ix2 - jx1;
      dy21              = iy2 - jy1;
      dz21              = iz2 - jz1;
      rsq21             = dx21*dx21+dy21*dy21+dz21*dz21;
      dx22              = ix2 - jx2;
      dy22              = iy2 - jy2;
      dz22              = iz2 - jz2;
      rsq22             = dx22*dx22+dy22*dy22+dz22*dz22;
      dx23              = ix2 - jx3;
      dy23              = iy2 - jy3;
      dz23              = iz2 - jz3;
      rsq23             = dx23*dx23+dy23*dy23+dz23*dz23;
      dx31              = ix3 - jx1;
      dy31              = iy3 - jy1;
      dz31              = iz3 - jz1;
      rsq31             = dx31*dx31+dy31*dy31+dz31*dz31;
      dx32              = ix3 - jx2;
      dy32              = iy3 - jy2;
      dz32              = iz3 - jz2;
      rsq32             = dx32*dx32+dy32*dy32+dz32*dz32;
      dx33              = ix3 - jx3;
      dy33              = iy3 - jy3;
      dz33              = iz3 - jz3;
      rsq33             = dx33*dx33+dy33*dy33+dz33*dz33;
      rinv11            = 1.0/sqrt(rsq11);
      rinv21            = 1.0/sqrt(rsq21);
      rinv31            = 1.0/sqrt(rsq31);
      rinv12            = 1.0/sqrt(rsq12);
      rinv22            = 1.0/sqrt(rsq22);
      rinv32            = 1.0/sqrt(rsq32);
      rinv13            = 1.0/sqrt(rsq13);
      rinv23            = 1.0/sqrt(rsq23);
      rinv33            = 1.0/sqrt(rsq33);
      r11               = rsq11*rinv11;
      rt                = r11*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOO*VV;
      fijC              = qqOO*FF;
      nnn               = n1+4;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnb6              = c6*VV;
      fijD              = c6*FF;
      rt                = cexp2*r11*exptabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1+8;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vnbexp            = cexp1*VV;
      fijR              = cexp1*cexp2*FF;
      vnbtot            = vnbtot + vnb6 + vnbexp;
      fs11              = -((fijC+fijD)*tabscale+(fijR)*exptabscale)*rinv11;
      vctot             = vctot + vcoul;
      tx11              = dx11*fs11;
      ty11              = dy11*fs11;
      tz11              = dz11*fs11;
      fix1              = fix1 + tx11;
      fiy1              = fiy1 + ty11;
      fiz1              = fiz1 + tz11;
      fjx1              = faction[j3]-tx11;
      fjy1              = faction[j3+1]-ty11;
      fjz1              = faction[j3+2]-tz11;
      r12               = rsq12*rinv12;
      rt                = r12*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs12              = -((fijC)*tabscale)*rinv12;
      vctot             = vctot + vcoul;
      tx12              = dx12*fs12;
      ty12              = dy12*fs12;
      tz12              = dz12*fs12;
      fix1              = fix1 + tx12;
      fiy1              = fiy1 + ty12;
      fiz1              = fiz1 + tz12;
      fjx2              = faction[j3+3]-tx12;
      fjy2              = faction[j3+4]-ty12;
      fjz2              = faction[j3+5]-tz12;
      r13               = rsq13*rinv13;
      rt                = r13*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs13              = -((fijC)*tabscale)*rinv13;
      vctot             = vctot + vcoul;
      tx13              = dx13*fs13;
      ty13              = dy13*fs13;
      tz13              = dz13*fs13;
      fix1              = fix1 + tx13;
      fiy1              = fiy1 + ty13;
      fiz1              = fiz1 + tz13;
      fjx3              = faction[j3+6]-tx13;
      fjy3              = faction[j3+7]-ty13;
      fjz3              = faction[j3+8]-tz13;
      r21               = rsq21*rinv21;
      rt                = r21*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs21              = -((fijC)*tabscale)*rinv21;
      vctot             = vctot + vcoul;
      tx21              = dx21*fs21;
      ty21              = dy21*fs21;
      tz21              = dz21*fs21;
      fix2              = fix2 + tx21;
      fiy2              = fiy2 + ty21;
      fiz2              = fiz2 + tz21;
      fjx1              = fjx1-tx21;
      fjy1              = fjy1-ty21;
      fjz1              = fjz1-tz21;
      r22               = rsq22*rinv22;
      rt                = r22*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs22              = -((fijC)*tabscale)*rinv22;
      vctot             = vctot + vcoul;
      tx22              = dx22*fs22;
      ty22              = dy22*fs22;
      tz22              = dz22*fs22;
      fix2              = fix2 + tx22;
      fiy2              = fiy2 + ty22;
      fiz2              = fiz2 + tz22;
      fjx2              = fjx2-tx22;
      fjy2              = fjy2-ty22;
      fjz2              = fjz2-tz22;
      r23               = rsq23*rinv23;
      rt                = r23*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs23              = -((fijC)*tabscale)*rinv23;
      vctot             = vctot + vcoul;
      tx23              = dx23*fs23;
      ty23              = dy23*fs23;
      tz23              = dz23*fs23;
      fix2              = fix2 + tx23;
      fiy2              = fiy2 + ty23;
      fiz2              = fiz2 + tz23;
      fjx3              = fjx3-tx23;
      fjy3              = fjy3-ty23;
      fjz3              = fjz3-tz23;
      r31               = rsq31*rinv31;
      rt                = r31*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqOH*VV;
      fijC              = qqOH*FF;
      fs31              = -((fijC)*tabscale)*rinv31;
      vctot             = vctot + vcoul;
      tx31              = dx31*fs31;
      ty31              = dy31*fs31;
      tz31              = dz31*fs31;
      fix3              = fix3 + tx31;
      fiy3              = fiy3 + ty31;
      fiz3              = fiz3 + tz31;
      faction[j3]       = fjx1-tx31;
      faction[j3+1]     = fjy1-ty31;
      faction[j3+2]     = fjz1-tz31;
      r32               = rsq32*rinv32;
      rt                = r32*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs32              = -((fijC)*tabscale)*rinv32;
      vctot             = vctot + vcoul;
      tx32              = dx32*fs32;
      ty32              = dy32*fs32;
      tz32              = dz32*fs32;
      fix3              = fix3 + tx32;
      fiy3              = fiy3 + ty32;
      fiz3              = fiz3 + tz32;
      faction[j3+3]     = fjx2-tx32;
      faction[j3+4]     = fjy2-ty32;
      faction[j3+5]     = fjz2-tz32;
      r33               = rsq33*rinv33;
      rt                = r33*tabscale;
      n0                = rt;
      eps               = rt-n0;
      eps2              = eps*eps;
      n1                = 12*n0;
      nnn               = n1;
      Y                 = VFtab[nnn];
      F                 = VFtab[nnn+1];
      Geps              = eps*VFtab[nnn+2];
      Heps2             = eps2*VFtab[nnn+3];
      Fp                = F+Geps+Heps2;
      VV                = Y+eps*Fp;
      FF                = Fp+Geps+two*Heps2;
      vcoul             = qqHH*VV;
      fijC              = qqHH*FF;
      fs33              = -((fijC)*tabscale)*rinv33;
      vctot             = vctot + vcoul;
      tx33              = dx33*fs33;
      ty33              = dy33*fs33;
      tz33              = dz33*fs33;
      fix3              = fix3 + tx33;
      fiy3              = fiy3 + ty33;
      fiz3              = fiz3 + tz33;
      faction[j3+6]     = fjx3-tx33;
      faction[j3+7]     = fjy3-ty33;
      faction[j3+8]     = fjz3-tz33;
    }
    faction[ii3]      = faction[ii3] + fix1;
    faction[ii3+1]    = faction[ii3+1] + fiy1;
    faction[ii3+2]    = faction[ii3+2] + fiz1;
    faction[ii3+3]    = faction[ii3+3] + fix2;
    faction[ii3+4]    = faction[ii3+4] + fiy2;
    faction[ii3+5]    = faction[ii3+5] + fiz2;
    faction[ii3+6]    = faction[ii3+6] + fix3;
    faction[ii3+7]    = faction[ii3+7] + fiy3;
    faction[ii3+8]    = faction[ii3+8] + fiz3;
    fshift[is3]       = fshift[is3] + fix1+fix2+fix3;
    fshift[is3+1]     = fshift[is3+1] + fiy1+fiy2+fiy3;
    fshift[is3+2]     = fshift[is3+2] + fiz1+fiz2+fiz3;
    ggid              = gid[n];
    Vc[ggid]          = Vc[ggid] + vctot;
    Vnb[ggid]         = Vnb[ggid] + vnbtot;
  }
}


#endif
