/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002 and 2003                         *
 * by the Free Software Foundation.                                  *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 2             *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,           *
 * Boston, MA 02111, USA.                                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h> /* for NULL */
#include "liberty.h"
#include "patterns.h"

static struct patval aa_attackpat0[] = {
  {684,1}
};

static struct patval aa_attackpat1[] = {
  {720,1},	{646,1},	{684,1},	{609,3},
  {757,3}
};

static struct patval aa_attackpat2[] = {
  {685,1},	{720,1},	{684,1},	{723,3},
  {686,3}
};

static struct patval aa_attackpat3[] = {
  {720,1},	{685,1},	{723,3},	{686,3}
};

static struct patval aa_attackpat4[] = {
  {758,1},	{684,1}
};

static struct patval aa_attackpat5[] = {
  {684,1},	{720,1}
};

static struct patval aa_attackpat6[] = {
  {683,1},	{758,1},	{757,1},	{684,1},
  {722,1}
};

static struct patval aa_attackpat7[] = {
  {684,1}
};

static struct patval aa_attackpat8[] = {
  {684,1},	{722,1}
};

static struct patval aa_attackpat9[] = {
  {683,1},	{647,1},	{721,1}
};

static struct patval aa_attackpat10[] = {
  {648,1},	{684,1},	{683,1}
};

static struct patval aa_attackpat11[] = {
  {722,1},	{684,1},	{686,1}
};

static struct patval aa_attackpat12[] = {
  {684,1},	{685,1},	{686,3}
};

static struct patval aa_attackpat13[] = {
  {758,1},	{720,1},	{684,1}
};

static struct patval aa_attackpat14[] = {
  {720,1},	{684,1},	{759,1},	{722,1}
};

static struct patval aa_attackpat15[] = {
  {684,1},	{720,3},	{685,3}
};

static int
autohelperaa_attackpat0(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(647, trans, move);

  return countlib(A) == 2;
}

static int
autohelperaa_attackpat5(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  return accuratelib(move, color, MAX_LIBERTIES, NULL)>3;
}

static int
autohelperaa_attackpat8(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  return safe_move(move, color);
}

static int
autohelperaa_attackpat10(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  return accuratelib(move, color, MAX_LIBERTIES, NULL)>3;
}

static int
autohelperaa_attackpat11(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(722, trans, move);

  return countlib(A)==2 && accuratelib(move, color, MAX_LIBERTIES, NULL)>3;
}

static int
autohelperaa_attackpat12(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(722, trans, move);

  return countlib(A)==3 && accuratelib(move, color, MAX_LIBERTIES, NULL)>=3;
}

static int
autohelperaa_attackpat13(int trans, int move, int color, int action)
{
  int A, B;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(647, trans, move);
  B = AFFINE_TRANSFORM(721, trans, move);

  return safe_move(move, color) && play_attack_defend2_n(color, 1, 1, move, A, B)&& !play_connect_n(color, 1, 1, move, A, B);
}

static int
autohelperaa_attackpat14(int trans, int move, int color, int action)
{
  int b, A;
  UNUSED(color);
  UNUSED(action);

  b = AFFINE_TRANSFORM(721, trans, move);
  A = AFFINE_TRANSFORM(685, trans, move);

  return countlib(A) == 2 && accuratelib(b, OTHER_COLOR(color), MAX_LIBERTIES, NULL) <= 2;
}

static int
autohelperaa_attackpat15(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(685, trans, move);

  return countlib(A) == 3;
}

static struct pattern aa_attackpat[] = {
  {aa_attackpat0,1,4, "A1",0,0,0,1,0,1,0x0,721,
    { 0x003c0000, 0x00303000, 0x00f00000, 0x30300000, 0x30300000, 0x003c0000, 0x00303000, 0x00f00000},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat0,3,0.010000},
  {aa_attackpat1,5,8, "A2",-1,-2,1,2,2,4,0x2,721,
    { 0xfdffff00, 0xfcfcfcf4, 0xfffffd00, 0xfcfcfc7c, 0xfcfcfcf4, 0xfffffd00, 0xfcfcfc7c, 0xfdffff00},
    { 0x98200000, 0x08240800, 0x00209800, 0x80608000, 0x08240800, 0x00209800, 0x80608000, 0x98200000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {aa_attackpat2,5,8, "A3",-1,0,2,1,3,1,0x2,721,
    { 0x3c3c3c14, 0x00fcfc00, 0xf0f0f000, 0xfdfd0000, 0xfcfc0000, 0x3c3c3c00, 0x00fdfd00, 0xf0f0f050},
    { 0x18202000, 0x00a40800, 0x20209000, 0x80680000, 0x08a40000, 0x20201800, 0x00688000, 0x90202000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {aa_attackpat3,4,8, "A4",-1,0,2,1,3,1,0x2,721,
    { 0x0c3c3c14, 0x00f0fc00, 0xf0f0c000, 0xfd3d0000, 0xfcf00000, 0x3c3c0c00, 0x003dfd00, 0xc0f0f050},
    { 0x08102000, 0x00900800, 0x20108000, 0x80180000, 0x08900000, 0x20100800, 0x00188000, 0x80102000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {aa_attackpat4,2,4, "A5",-1,0,1,2,2,2,0x2,721,
    { 0x0c3f3f00, 0x00f0fcf0, 0xf0f0c000, 0xfc3c0000, 0xfcf00000, 0x3f3f0c00, 0x003cfc3c, 0xc0f0f000},
    { 0x04220000, 0x00200420, 0x00204000, 0x40200000, 0x04200000, 0x00220400, 0x00204020, 0x40200000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {aa_attackpat5,2,8, "A6",-1,-1,0,1,1,2,0x0,646,
    { 0xfcbc0000, 0x2c3c3c00, 0x00f8fc00, 0xf0f0e000, 0x3c3c2c00, 0x00bcfc00, 0xe0f0f000, 0xfcf80000},
    { 0x08240000, 0x00201800, 0x00608000, 0x90200000, 0x18200000, 0x00240800, 0x00209000, 0x80600000}
   , 0x100,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat5,3,0.050000},
  {aa_attackpat6,5,4, "A7",-1,0,1,2,2,2,0x0,721,
    { 0x3f3f3f00, 0x00fcfcfc, 0xf0f0f000, 0xfcfc0000, 0xfcfc0000, 0x3f3f3f00, 0x00fcfcfc, 0xf0f0f000},
    { 0x22221900, 0x00688068, 0x90202000, 0x08a40000, 0x80680000, 0x19222200, 0x00a408a4, 0x20209000}
   , 0x10,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {aa_attackpat7,1,8, "A8",-1,-1,1,1,2,2,0x0,721,
    { 0xfc3c0c00, 0x0c3cfc00, 0xc0f0fc00, 0xfcf0c000, 0xfc3c0c00, 0x0c3cfc00, 0xc0f0fc00, 0xfcf0c000},
    { 0x40200400, 0x04204000, 0x40200400, 0x04204000, 0x40200400, 0x04204000, 0x40200400, 0x04204000}
   , 0x100,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {aa_attackpat8,2,4, "A9",0,0,1,1,1,1,0x0,721,
    { 0x003c3c00, 0x00f0f000, 0xf0f00000, 0x3c3c0000, 0xf0f00000, 0x3c3c0000, 0x003c3c00, 0x00f0f000},
    { 0x00201800, 0x00608000, 0x90200000, 0x08240000, 0x80600000, 0x18200000, 0x00240800, 0x00209000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat8,3,1.000000},
  {aa_attackpat9,3,4, "A10",-1,-1,1,1,2,2,0x0,685,
    { 0x30fcfc00, 0xf0fcf000, 0xfcfc3000, 0x3cfc3c00, 0xf0fcf000, 0xfcfc3000, 0x3cfc3c00, 0x30fcfc00},
    { 0x20980000, 0x20182000, 0x00982000, 0x20902000, 0x20182000, 0x00982000, 0x20902000, 0x20980000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {aa_attackpat10,3,8, "A11",-1,-2,1,0,2,2,0x0,609,
    { 0xf0f0f000, 0xfcfc0000, 0x3c3c3f00, 0x00fcfcc0, 0x00fcfc0c, 0xf0f0f000, 0xfcfc0000, 0x3f3c3c00},
    { 0x20209000, 0x80680000, 0x18202000, 0x00a40800, 0x00688000, 0x90202000, 0x08a40000, 0x20201800}
   , 0x100,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat10,3,0.050000},
  {aa_attackpat11,3,8, "A12",0,-1,2,1,2,2,0x2,648,
    { 0x00f0fcf0, 0xf0f0c000, 0xfc3c0000, 0x0c3f3f00, 0xc0f0f000, 0xfcf00000, 0x3f3f0c00, 0x003cfc3c},
    { 0x00200820, 0x00208000, 0x80200000, 0x08220000, 0x80200000, 0x08200000, 0x00220800, 0x00208020}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat11,3,0.040000},
  {aa_attackpat12,3,8, "A13",-1,-1,2,0,3,1,0x2,646,
    { 0xf0f0f0d0, 0xfcfc0000, 0x3c3c3c00, 0x00fdff00, 0x00fcfc00, 0xf0f0f000, 0xfffd0000, 0x3c3c3c1c},
    { 0x10202000, 0x00a40000, 0x20201000, 0x00680000, 0x00a40000, 0x20201000, 0x00680000, 0x10202000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat12,3,0.040000},
  {aa_attackpat13,3,4, "A14",-1,0,1,2,2,2,0x0,721,
    { 0x3f3f0c00, 0x003cfc3c, 0xc0f0f000, 0xfcf00000, 0xfc3c0000, 0x0c3f3f00, 0x00f0fcf0, 0xf0f0c000},
    { 0x08220400, 0x00204820, 0x40208000, 0x84200000, 0x48200000, 0x04220800, 0x00208420, 0x80204000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat13,3,6.400001},
  {aa_attackpat14,4,8, "A15",-1,0,1,2,2,2,0x0,721,
    { 0x0c3f0f00, 0x0030fcf0, 0xc0f0c000, 0xfc300000, 0xfc300000, 0x0f3f0c00, 0x0030fc3c, 0xc0f0c000},
    { 0x08200a00, 0x00208880, 0x80208000, 0x88200000, 0x88200000, 0x0a200800, 0x00208808, 0x80208000}
   , 0x10,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat14,3,0.040000},
  {aa_attackpat15,3,8, "A16",-1,0,1,1,2,1,0x2,683,
    { 0x343c1c00, 0x007cf400, 0xd0f07000, 0x7cf40000, 0xf47c0000, 0x1c3c3400, 0x00f47c00, 0x70f0d000},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x0,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperaa_attackpat15,3,0.010000},
  {NULL, 0,0,NULL,0,0,0,0,0,0,0,0,{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,NULL,NULL,0,0.0}
};

#include "dfa.h"
static const state_rt_t state_aa_attackpat[296] = {
{0,{0,0,0,0}},	{0,{0,1,2,0}},	{0,{2,0,3,0}},
{0,{3,4,5,6}},	{0,{0,0,6,0}},	{0,{6,0,0,0}},
{0,{6,7,8,0}},	{0,{8,9,10,10}},	{0,{10,11,12,12}},
{0,{12,13,0,0}},	{0,{0,0,13,0}},	{0,{13,13,13,0}},
{3,{13,14,15,16}},	{0,{16,15,15,15}},	{0,{14,14,14,14}},
{3,{15,16,17,18}},	{0,{18,0,19,0}},	{0,{0,0,18,0}},
{3,{18,19,20,0}},	{0,{15,20,0,0}},	{0,{0,19,0,0}},
{3,{0,0,0,0}},	{0,{12,0,0,0}},	{0,{0,0,17,0}},
{0,{17,17,17,17}},	{0,{17,18,18,19}},	{0,{19,20,20,20}},
{0,{20,19,19,19}},	{0,{20,0,0,0}},	{0,{20,21,0,0}},
{0,{21,21,21,22}},	{0,{22,22,22,22}},	{0,{22,23,23,23}},
{0,{23,23,23,23}},	{0,{16,16,0,0}},	{0,{22,0,0,0}},
{0,{22,22,22,23}},	{0,{23,24,24,24}},	{0,{24,24,24,24}},
{0,{24,0,0,0}},	{0,{24,24,24,24}},	{0,{24,0,24,0}},
{0,{24,24,25,26}},	{0,{23,23,23,25}},	{0,{25,25,25,26}},
{0,{26,26,27,28}},	{0,{25,25,25,28}},	{0,{24,24,25,27}},
{0,{0,0,27,0}},	{0,{27,27,28,27}},	{0,{26,26,26,26}},
{0,{27,27,27,27}},	{0,{27,27,27,27}},	{0,{27,27,27,27}},
{0,{27,27,27,27}},	{0,{27,27,27,27}},	{0,{27,27,27,27}},
{0,{27,27,27,27}},	{0,{8,8,8,27}},	{0,{10,10,10,27}},
{0,{27,11,27,11}},	{0,{27,10,27,10}},	{0,{9,9,9,9}},
{0,{26,0,26,0}},	{0,{26,0,0,0}},	{0,{26,0,0,0}},
{0,{0,26,27,0}},	{0,{0,25,27,0}},	{0,{27,24,25,0}},
{0,{0,27,24,0}},	{0,{25,26,23,0}},	{0,{0,0,22,0}},
{0,{0,0,22,0}},	{0,{24,0,20,0}},	{0,{24,0,19,0}},
{0,{0,0,24,0}},	{0,{24,24,24,24}},	{0,{23,23,24,23}},
{0,{0,14,24,0}},	{0,{0,17,23,0}},	{0,{0,0,22,0}},
{0,{22,22,23,22}},	{0,{0,0,23,0}},	{0,{0,0,23,0}},
{0,{19,19,19,19}},	{0,{22,7,8,0}},	{0,{21,10,7,0}},
{0,{21,22,23,22}},	{0,{23,0,5,0}},	{0,{20,20,20,20}},
{0,{22,0,0,0}},	{0,{22,22,22,22}},	{0,{22,22,22,23}},
{0,{23,23,23,23}},	{0,{23,22,22,22}},	{0,{23,23,23,23}},
{0,{19,19,19,19}},	{0,{22,23,23,23}},	{0,{22,22,22,22}},
{0,{22,0,0,0}},	{0,{22,22,22,22}},	{0,{22,21,21,21}},
{12,{14,14,14,14}},	{0,{0,0,21,0}},	{12,{21,21,22,21}},
{12,{20,20,20,20}},	{12,{0,0,0,0}},	{0,{20,20,20,20}},
{0,{20,21,21,21}},	{0,{21,0,0,0}},	{0,{21,6,6,6}},
{0,{18,18,18,18}},	{1,{0,0,0,0}},	{0,{19,19,19,19}},
{0,{19,19,20,19}},	{0,{0,0,20,0}},	{0,{20,0,0,0}},
{0,{20,21,21,21}},	{0,{21,21,22,21}},	{0,{22,0,23,0}},
{0,{0,0,22,0}},	{0,{17,17,17,17}},	{0,{21,21,21,21}},
{0,{21,21,21,21}},	{0,{21,21,21,21}},	{0,{11,0,21,0}},
{0,{21,19,22,19}},	{0,{12,12,12,12}},	{0,{21,21,21,21}},
{0,{21,21,21,21}},	{0,{21,21,21,21}},	{0,{21,20,20,20}},
{0,{0,0,21,0}},	{0,{21,0,0,0}},	{0,{20,0,21,0}},
{0,{0,0,20,0}},	{0,{0,0,20,0}},	{0,{20,20,21,20}},
{0,{19,19,19,19}},	{0,{20,0,20,0}},	{0,{19,20,19,0}},
{0,{0,0,20,0}},	{0,{0,18,0,0}},	{0,{0,0,19,0}},
{0,{13,13,19,13}},	{0,{19,19,19,19}},	{0,{19,0,0,0}},
{0,{17,17,19,17}},	{0,{19,16,16,16}},	{0,{19,19,20,19}},
{0,{0,0,20,0}},	{0,{17,17,17,17}},	{0,{16,16,19,16}},
{0,{19,19,19,19}},	{0,{19,19,19,19}},	{0,{19,19,19,19}},
{0,{19,19,19,19}},	{0,{19,19,19,19}},	{0,{19,19,19,19}},
{8,{0,0,0,0}},	{0,{18,18,18,18}},	{0,{18,18,18,18}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{18,18,18,18}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{18,18,18,18}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{18,18,18,18}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{0,18,0,0}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{18,18,18,18}},
{0,{18,18,18,18}},	{0,{18,18,18,18}},	{0,{0,0,18,0}},
{0,{18,0,0,0}},	{0,{18,13,13,13}},	{0,{18,0,0,0}},
{0,{18,18,18,18}},	{0,{18,9,9,9}},	{0,{18,16,16,16}},
{0,{18,0,0,0}},	{0,{18,19,19,19}},	{0,{18,18,18,18}},
{0,{18,4,4,4}},	{0,{18,18,18,18}},	{4,{0,0,0,0}},
{0,{17,17,17,17}},	{0,{17,17,17,17}},	{0,{17,17,17,17}},
{0,{17,17,17,17}},	{0,{17,17,17,17}},	{0,{17,0,0,0}},
{11,{0,0,0,0}},	{11,{12,12,12,12}},	{0,{15,15,15,0}},
{0,{15,15,15,15}},	{0,{15,15,15,8}},	{0,{15,15,15,13}},
{0,{15,15,15,15}},	{0,{15,15,15,15}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{0,0,0,15}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{0,0,0,15}},	{0,{13,13,13,15}},
{0,{0,0,0,15}},	{0,{0,0,0,15}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{15,15,15,15}},	{0,{15,15,15,15}},
{0,{0,0,0,15}},	{0,{0,0,0,15}},	{0,{0,0,0,15}},
{0,{3,3,3,15}},	{0,{15,0,15,0}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{15,15,15,0}},	{0,{15,15,15,13}},
{0,{0,0,0,15}},	{0,{0,0,0,15}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{15,15,15,15}},	{0,{15,15,15,15}},
{0,{15,15,15,15}},	{0,{15,14,15,14}},	{0,{15,0,15,0}},
{0,{15,15,15,15}},	{2,{0,0,0,0}},	{0,{14,14,14,14}},
{0,{14,14,14,14}},	{0,{14,0,0,0}},	{0,{14,12,12,12}},
{0,{0,0,0,14}},	{0,{0,0,0,14}},	{0,{14,14,14,14}},
{0,{14,14,14,14}},	{0,{14,14,14,14}},	{0,{14,14,14,14}},
{0,{14,0,0,0}},	{16,{13,0,0,0}},	{16,{0,0,0,0}},
{0,{12,2,2,2}},	{0,{12,12,12,0}},	{0,{0,0,12,0}},
{7,{0,0,0,0}},	{7,{0,0,10,0}},	{0,{10,0,0,0}},
{0,{10,0,0,0}},	{0,{10,10,10,10}},	{0,{0,10,0,0}},
{0,{8,8,10,8}},	{0,{7,10,7,7}},	{15,{0,0,0,0}},
{15,{0,0,2,0}},	{0,{8,8,8,8}},	{6,{0,0,0,0}},
{9,{0,0,0,0}},	{0,{6,0,0,0}},	{0,{6,6,6,0}},
{0,{6,6,6,6}},	{6,{4,4,4,0}},	{0,{5,5,5,4}},
{0,{5,5,5,5}},	{0,{5,5,5,5}},	{0,{5,5,5,5}},
{0,{5,5,5,5}},	{0,{5,5,5,5}},	{0,{5,0,0,0}},
{0,{5,0,5,0}},	{0,{5,5,5,5}},	{0,{0,0,5,0}},
{0,{3,3,5,3}},	{5,{0,0,0,0}},	{0,{4,4,4,4}},
{0,{4,4,4,4}},	{14,{0,0,0,0}},	{14,{2,2,2,2}},
{0,{2,2,2,2}},	{0,{2,2,2,2}},	{0,{2,2,2,2}},
{0,{2,2,2,2}},	{0,{2,0,2,0}},	{0,{2,0,0,0}},
{10,{0,0,0,0}},	{13,{0,0,0,0}},	};

static const attrib_rt_t idx_aa_attackpat[17] = {
{-1,0},	{9,0},	{3,0},	{0,0},
{7,0},	{13,0},	{14,0},	{11,0},
{15,0},	{4,0},	{1,0},	{5,0},
{8,0},	{10,0},	{6,0},	{12,0},
{2,0},	};

static dfa_rt_t dfa_aa_attackpat = {
 "aa_attackpat",
 0,
state_aa_attackpat,
idx_aa_attackpat};

struct pattern_db aa_attackpat_db = {
  -1,
  0,
  aa_attackpat
 ,& dfa_aa_attackpat
};
