/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is GNU GO, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002 and 2003                         *
 * by the Free Software Foundation.                                  *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 2             *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,           *
 * Boston, MA 02111, USA.                                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h> /* for NULL */
#include "liberty.h"
#include "patterns.h"

static struct patval joseki0[] = {
  {723,1},	{684,2},	{690,2},	{681,0},
  {570,0},	{644,0},	{792,0},	{607,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{755,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{571,0},	{727,0},
  {764,0},	{801,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0}
};

static struct patval joseki1[] = {
  {722,1},	{684,1},	{723,2},	{607,0},
  {570,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki2[] = {
  {686,1},	{723,1},	{684,2},	{690,2},
  {722,2},	{644,0},	{570,0},	{681,0},
  {608,0},	{607,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {645,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {792,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{718,0},	{755,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{571,0},	{727,0},
  {764,0},	{801,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0}
};

static struct patval joseki3[] = {
  {760,1},	{797,1},	{762,1},	{684,2},
  {764,2},	{796,2},	{758,2},	{607,0},
  {608,0},	{681,0},	{682,0},	{644,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{755,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{718,0},	{721,0},
  {719,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{866,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {792,0},	{829,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {794,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {645,0},	{801,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0}
};

static struct patval joseki4[] = {
  {722,1},	{684,1},	{723,2},	{686,2},
  {570,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki5[] = {
  {721,1},	{684,1},	{797,1},	{759,1},
  {798,2},	{685,2},	{761,2},	{722,2},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {645,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {756,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki6[] = {
  {721,1},	{684,1},	{795,1},	{759,1},
  {797,1},	{758,2},	{761,2},	{722,2},
  {685,2},	{798,2},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {645,0},	{830,0},	{720,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {756,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki7[] = {
  {648,1},	{611,1},	{722,1},	{686,1},
  {724,1},	{721,1},	{685,2},	{649,2},
  {612,2},	{725,2},	{684,2},	{688,2},
  {758,0},	{795,0},	{574,0},	{610,0},
  {572,0},	{757,0},	{647,0},	{759,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {683,0},	{723,0},	{760,0},	{797,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{651,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki8[] = {
  {723,1},	{690,2},	{684,2},	{607,0},
  {755,0},	{792,0},	{608,0},	{645,0},
  {682,0},	{718,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{612,0},	{649,0},
  {686,0},	{719,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {644,0},	{727,0},	{764,0},	{801,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki9[] = {
  {835,1},	{796,1},	{684,1},	{838,2},
  {758,2},	{832,2},	{760,2},	{718,0},
  {940,0},	{829,0},	{682,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{755,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {792,0},	{721,0},	{756,0},	{795,0},
  {681,0},	{869,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {645,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {903,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{866,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{941,0},	{875,0},
  {912,0},	{949,0}
};

static struct patval joseki10[] = {
  {724,1},	{690,1},	{684,1},	{755,0},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki11[] = {
  {759,1},	{724,2},	{684,2},	{690,2},
  {755,0},	{681,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki12[] = {
  {724,1},	{690,1},	{684,1},	{722,1},
  {759,2},	{755,0},	{682,0},	{719,0},
  {681,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{756,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki13[] = {
  {684,1},	{760,1},	{685,2},	{725,2},
  {691,2},	{723,2},	{683,0},	{720,0},
  {682,0},	{794,0},	{647,0},	{756,0},
  {721,0},	{758,0},	{795,0},	{648,0},
  {719,0},	{722,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{757,0},	{646,0},
  {797,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {645,0},	{762,0},	{799,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{654,0},	{793,0},	{728,0},
  {765,0},	{802,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki14[] = {
  {724,1},	{690,1},	{684,1},	{755,0},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki15[] = {
  {723,1},	{690,2},	{684,2},	{724,2},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{755,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki16[] = {
  {724,1},	{690,1},	{684,1},	{755,0},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki17[] = {
  {685,1},	{690,2},	{684,2},	{724,2},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{755,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki18[] = {
  {724,1},	{690,1},	{684,1},	{755,0},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki19[] = {
  {721,1},	{690,2},	{684,2},	{724,2},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{755,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki20[] = {
  {724,1},	{690,1},	{684,1},	{722,1},
  {721,2},	{681,0},	{682,0},	{719,0},
  {645,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{755,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{756,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki21[] = {
  {721,1},	{759,1},	{684,2},	{724,2},
  {690,2},	{722,2},	{682,0},	{719,0},
  {681,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{755,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{756,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki22[] = {
  {724,1},	{690,1},	{684,1},	{685,1},
  {722,1},	{759,2},	{721,2},	{719,0},
  {681,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{682,0},	{758,0},	{795,0},
  {648,0},	{755,0},	{756,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki23[] = {
  {758,1},	{759,1},	{721,1},	{684,2},
  {690,2},	{724,2},	{685,2},	{722,2},
  {681,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{682,0},	{719,0},	{795,0},
  {648,0},	{755,0},	{756,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki24[] = {
  {724,1},	{690,1},	{684,1},	{685,1},
  {760,1},	{722,1},	{758,2},	{721,2},
  {759,2},	{793,0},	{681,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{682,0},	{719,0},	{795,0},
  {648,0},	{755,0},	{756,0},	{645,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {646,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki25[] = {
  {759,1},	{760,1},	{684,1},	{722,1},
  {685,2},	{725,2},	{686,2},	{691,2},
  {723,2},	{761,2},	{794,0},	{682,0},
  {721,0},	{758,0},	{795,0},	{648,0},
  {719,0},	{683,0},	{720,0},	{796,0},
  {649,0},	{756,0},	{757,0},	{646,0},
  {797,0},	{650,0},	{687,0},	{724,0},
  {647,0},	{798,0},	{651,0},	{688,0},
  {645,0},	{762,0},	{799,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{654,0},	{793,0},	{728,0},
  {765,0},	{802,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki26[] = {
  {762,1},	{728,1},	{722,1},	{723,1},
  {798,1},	{760,1},	{684,1},	{796,2},
  {797,2},	{759,2},	{721,2},	{831,0},
  {758,0},	{795,0},	{719,0},	{685,0},
  {756,0},	{720,0},	{757,0},	{833,0},
  {686,0},	{793,0},	{794,0},	{683,0},
  {834,0},	{687,0},	{724,0},	{761,0},
  {832,0},	{835,0},	{688,0},	{725,0},
  {682,0},	{799,0},	{836,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{691,0},	{830,0},	{765,0},
  {802,0},	{839,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki27[] = {
  {760,1},	{761,1},	{684,1},	{723,1},
  {685,1},	{726,2},	{686,2},	{692,2},
  {724,2},	{687,2},	{648,2},	{762,2},
  {722,0},	{759,0},	{683,0},	{649,0},
  {720,0},	{795,0},	{721,0},	{797,0},
  {650,0},	{757,0},	{758,0},	{647,0},
  {798,0},	{651,0},	{688,0},	{725,0},
  {796,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki28[] = {
  {763,1},	{684,1},	{723,1},	{724,1},
  {729,1},	{761,1},	{799,1},	{685,1},
  {798,2},	{760,2},	{797,2},	{722,2},
  {721,2},	{796,0},	{759,0},	{686,0},
  {757,0},	{720,0},	{758,0},	{834,0},
  {687,0},	{794,0},	{795,0},	{832,0},
  {835,0},	{688,0},	{725,0},	{762,0},
  {833,0},	{836,0},	{689,0},	{726,0},
  {683,0},	{800,0},	{837,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{692,0},	{831,0},	{766,0},
  {803,0},	{840,0},	{693,0},	{730,0},
  {767,0},	{804,0},	{841,0}
};

static struct patval joseki29[] = {
  {724,1},	{690,1},	{684,1},	{755,0},
  {681,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {718,0},	{721,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{650,0},	{687,0},
  {644,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{653,0},	{792,0},	{727,0},
  {764,0},	{801,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki30[] = {
  {684,1},	{688,2},	{648,2},	{654,2},
  {719,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{610,0},	{647,0},
  {645,0},	{721,0},	{758,0},	{611,0},
  {682,0},	{685,0},	{722,0},	{759,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{614,0},	{651,0},
  {608,0},	{725,0},	{762,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{617,0},	{756,0},	{691,0},
  {728,0},	{765,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki31[] = {
  {725,1},	{691,1},	{685,1},	{684,1},
  {721,2},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{647,0},	{756,0},
  {682,0},	{758,0},	{795,0},	{648,0},
  {719,0},	{722,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {645,0},	{762,0},	{799,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{654,0},	{793,0},	{728,0},
  {765,0},	{802,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki32[] = {
  {722,1},	{721,1},	{685,2},	{725,2},
  {691,2},	{684,2},	{683,0},	{720,0},
  {757,0},	{794,0},	{647,0},	{646,0},
  {682,0},	{758,0},	{795,0},	{648,0},
  {719,0},	{756,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {645,0},	{762,0},	{799,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{654,0},	{793,0},	{728,0},
  {765,0},	{802,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki33[] = {
  {689,1},	{684,1},	{649,1},	{648,1},
  {655,1},	{686,2},	{685,2},	{647,0},
  {721,0},	{758,0},	{611,0},	{610,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {683,0},	{720,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki34[] = {
  {686,1},	{685,1},	{688,1},	{649,2},
  {655,2},	{648,2},	{689,2},	{684,2},
  {721,0},	{758,0},	{611,0},	{610,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {683,0},	{647,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{614,0},	{651,0},	{720,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki35[] = {
  {689,1},	{684,1},	{651,1},	{648,1},
  {655,1},	{649,1},	{686,2},	{685,2},
  {688,2},	{758,0},	{611,0},	{721,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {610,0},	{647,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{614,0},	{683,0},	{720,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki36[] = {
  {686,1},	{685,1},	{687,1},	{688,1},
  {651,2},	{649,2},	{689,2},	{684,2},
  {655,2},	{648,2},	{611,0},	{758,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {610,0},	{647,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{721,0},	{724,0},
  {761,0},	{614,0},	{683,0},	{720,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki37[] = {
  {689,1},	{684,1},	{651,1},	{648,1},
  {655,1},	{649,1},	{652,1},	{686,2},
  {687,2},	{685,2},	{688,2},	{611,0},
  {646,0},	{758,0},	{759,0},	{612,0},
  {610,0},	{647,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{721,0},	{724,0},
  {761,0},	{614,0},	{683,0},	{720,0},
  {725,0},	{762,0},	{615,0},	{722,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki38[] = {
  {721,1},	{685,1},	{686,1},	{688,1},
  {687,1},	{649,2},	{651,2},	{684,2},
  {689,2},	{652,2},	{655,2},	{648,2},
  {646,0},	{758,0},	{611,0},	{612,0},
  {610,0},	{647,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{759,0},	{724,0},
  {761,0},	{614,0},	{683,0},	{720,0},
  {725,0},	{762,0},	{615,0},	{722,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki39[] = {
  {726,1},	{721,1},	{688,1},	{685,1},
  {692,1},	{686,1},	{684,1},	{689,1},
  {758,2},	{723,2},	{724,2},	{725,2},
  {722,2},	{683,0},	{648,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{759,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki40[] = {
  {758,1},	{763,1},	{723,1},	{725,1},
  {724,1},	{722,1},	{688,2},	{721,2},
  {686,2},	{684,2},	{692,2},	{685,2},
  {726,2},	{689,2},	{648,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{759,0},
  {646,0},	{683,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki41[] = {
  {726,1},	{721,1},	{688,1},	{764,1},
  {692,1},	{686,1},	{684,1},	{689,1},
  {685,1},	{723,2},	{725,2},	{758,2},
  {722,2},	{763,2},	{724,2},	{649,0},
  {648,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{647,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{759,0},
  {646,0},	{683,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{796,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki42[] = {
  {689,1},	{684,1},	{649,1},	{648,1},
  {655,1},	{686,2},	{685,2},	{647,0},
  {721,0},	{758,0},	{611,0},	{610,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {683,0},	{720,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki43[] = {
  {721,1},	{685,1},	{686,1},	{649,2},
  {655,2},	{648,2},	{689,2},	{684,2},
  {647,0},	{758,0},	{611,0},	{610,0},
  {646,0},	{722,0},	{759,0},	{612,0},
  {683,0},	{720,0},	{723,0},	{760,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{615,0},	{652,0},
  {609,0},	{726,0},	{763,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{618,0},	{757,0},	{692,0},
  {729,0},	{766,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki44[] = {
  {726,1},	{721,1},	{686,1},	{685,1},
  {692,1},	{684,1},	{723,2},	{722,2},
  {758,2},	{795,0},	{648,0},	{647,0},
  {683,0},	{759,0},	{796,0},	{649,0},
  {720,0},	{757,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki45[] = {
  {758,1},	{722,1},	{723,1},	{725,1},
  {692,2},	{685,2},	{686,2},	{721,2},
  {726,2},	{684,2},	{648,0},	{647,0},
  {683,0},	{759,0},	{796,0},	{649,0},
  {720,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{651,0},	{688,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki46[] = {
  {726,1},	{721,1},	{688,1},	{685,1},
  {692,1},	{686,1},	{684,1},	{722,2},
  {758,2},	{723,2},	{725,2},	{648,0},
  {683,0},	{759,0},	{796,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki47[] = {
  {758,1},	{722,1},	{723,1},	{725,1},
  {724,1},	{686,2},	{688,2},	{721,2},
  {726,2},	{684,2},	{692,2},	{685,2},
  {683,0},	{759,0},	{648,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{763,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki48[] = {
  {726,1},	{763,1},	{688,1},	{685,1},
  {692,1},	{686,1},	{684,1},	{721,1},
  {758,2},	{723,2},	{724,2},	{725,2},
  {722,2},	{759,0},	{648,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{683,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki49[] = {
  {685,1},	{649,1},	{650,1},	{684,1},
  {651,1},	{652,1},	{615,2},	{648,2},
  {653,2},	{613,2},	{619,2},	{612,2},
  {690,2},	{611,2},	{575,0},	{576,0},
  {574,0},	{686,0},	{687,0},	{724,0},
  {577,0},	{614,0},	{723,0},	{688,0},
  {725,0},	{578,0},	{647,0},	{722,0},
  {689,0},	{726,0},	{579,0},	{616,0},
  {573,0},	{610,0},	{727,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{582,0},	{721,0},	{656,0},
  {693,0},	{730,0},	{583,0},	{620,0},
  {657,0},	{694,0},	{731,0}
};

static struct patval joseki50[] = {
  {726,1},	{763,1},	{688,1},	{685,1},
  {692,1},	{686,1},	{684,1},	{721,1},
  {758,2},	{723,2},	{724,2},	{725,2},
  {722,2},	{759,0},	{648,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {762,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{683,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki51[] = {
  {758,1},	{722,1},	{723,1},	{725,1},
  {762,1},	{724,1},	{688,2},	{721,2},
  {726,2},	{684,2},	{692,2},	{686,2},
  {763,2},	{685,2},	{759,0},	{649,0},
  {647,0},	{795,0},	{760,0},	{797,0},
  {650,0},	{687,0},	{796,0},	{761,0},
  {798,0},	{651,0},	{720,0},	{757,0},
  {648,0},	{799,0},	{652,0},	{689,0},
  {646,0},	{683,0},	{800,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{655,0},	{794,0},	{729,0},
  {766,0},	{803,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0}
};

static struct patval joseki52[] = {
  {723,1},	{684,2},	{607,0},	{681,0},
  {718,0},	{755,0},	{792,0},	{571,0},
  {644,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {570,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{608,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki53[] = {
  {684,1},	{725,1},	{723,2},	{681,0},
  {718,0},	{755,0},	{792,0},	{571,0},
  {644,0},	{645,0},	{682,0},	{719,0},
  {607,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {570,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{608,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{756,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki54[] = {
  {685,1},	{726,1},	{684,1},	{724,2},
  {721,2},	{756,0},	{793,0},	{572,0},
  {645,0},	{646,0},	{683,0},	{720,0},
  {608,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {571,0},	{722,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki55[] = {
  {721,1},	{722,1},	{724,1},	{684,2},
  {685,2},	{726,2},	{756,0},	{572,0},
  {645,0},	{646,0},	{683,0},	{720,0},
  {793,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {571,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki56[] = {
  {686,1},	{726,1},	{685,1},	{684,1},
  {721,2},	{722,2},	{724,2},	{572,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {645,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {793,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{571,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki57[] = {
  {685,1},	{686,1},	{688,1},	{684,1},
  {650,2},	{648,2},	{649,2},	{690,2},
  {536,0},	{610,0},	{647,0},	{720,0},
  {609,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{646,0},	{683,0},	{722,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {757,0},	{572,0},	{723,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{535,0},
  {687,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{573,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{721,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0}
};

static struct patval joseki58[] = {
  {650,1},	{690,1},	{649,1},	{648,1},
  {651,1},	{684,2},	{688,2},	{685,2},
  {686,2},	{610,0},	{647,0},	{720,0},
  {609,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{646,0},	{683,0},	{722,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {757,0},	{572,0},	{723,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{535,0},
  {687,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{536,0},	{573,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{721,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0}
};

static struct patval joseki59[] = {
  {685,1},	{686,1},	{688,1},	{684,1},
  {725,1},	{650,2},	{649,2},	{651,2},
  {690,2},	{648,2},	{647,0},	{720,0},
  {609,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{646,0},	{683,0},	{722,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {757,0},	{572,0},	{723,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{535,0},
  {687,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{536,0},	{573,0},
  {610,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{721,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0}
};

static struct patval joseki60[] = {
  {650,1},	{690,1},	{649,1},	{648,1},
  {651,1},	{684,2},	{688,2},	{685,2},
  {686,2},	{610,0},	{647,0},	{720,0},
  {609,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{646,0},	{683,0},	{722,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {757,0},	{572,0},	{723,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{535,0},
  {687,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{536,0},	{573,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{721,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0}
};

static struct patval joseki61[] = {
  {685,1},	{686,1},	{688,1},	{684,1},
  {689,1},	{650,2},	{649,2},	{651,2},
  {690,2},	{648,2},	{647,0},	{610,0},
  {609,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{646,0},	{683,0},	{722,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {757,0},	{572,0},	{723,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{535,0},
  {687,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{536,0},	{573,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{720,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{721,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0}
};

static struct patval joseki62[] = {
  {686,1},	{726,1},	{685,1},	{684,1},
  {721,2},	{722,2},	{724,2},	{572,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {645,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {793,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{571,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki63[] = {
  {721,1},	{722,1},	{724,1},	{761,1},
  {686,2},	{684,2},	{685,2},	{726,2},
  {572,0},	{756,0},	{683,0},	{720,0},
  {645,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {793,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{571,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {646,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki64[] = {
  {686,1},	{726,1},	{685,1},	{684,1},
  {721,2},	{722,2},	{724,2},	{572,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {645,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {793,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{571,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki65[] = {
  {721,1},	{723,1},	{724,1},	{722,1},
  {686,2},	{726,2},	{685,2},	{684,2},
  {756,0},	{646,0},	{683,0},	{720,0},
  {645,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {793,0},	{572,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{571,0},
  {608,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{609,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{757,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki66[] = {
  {687,1},	{684,1},	{689,2},	{648,2},
  {534,0},	{386,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{387,0},
  {424,0},	{461,0},	{571,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{388,0},	{425,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{460,0},	{721,0},
  {758,0},	{389,0},	{426,0},	{463,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {497,0},	{685,0},	{722,0},	{759,0},
  {390,0},	{427,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{391,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{498,0},
  {724,0},	{761,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{393,0},	{430,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{423,0},	{726,0},	{763,0},
  {394,0},	{431,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{395,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki67[] = {
  {648,1},	{685,1},	{689,1},	{684,2},
  {687,2},	{719,0},	{645,0},	{535,0},
  {608,0},	{609,0},	{646,0},	{683,0},
  {756,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {534,0},	{571,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki68[] = {
  {724,1},	{684,1},	{721,1},	{726,2},
  {722,2},	{685,2},	{571,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki69[] = {
  {726,1},	{722,1},	{648,1},	{685,1},
  {684,2},	{724,2},	{721,2},	{571,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki70[] = {
  {759,1},	{684,1},	{724,1},	{721,1},
  {722,2},	{648,2},	{685,2},	{726,2},
  {609,0},	{646,0},	{571,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki71[] = {
  {760,1},	{726,1},	{648,1},	{685,1},
  {722,1},	{684,2},	{721,2},	{724,2},
  {759,2},	{646,0},	{609,0},	{720,0},
  {571,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{757,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki72[] = {
  {759,1},	{684,1},	{724,1},	{758,1},
  {721,1},	{760,2},	{722,2},	{648,2},
  {685,2},	{726,2},	{646,0},	{720,0},
  {609,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{571,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{757,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki73[] = {
  {760,1},	{726,1},	{648,1},	{685,1},
  {723,1},	{722,1},	{721,2},	{724,2},
  {758,2},	{684,2},	{759,2},	{720,0},
  {609,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{571,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{646,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {719,0},	{757,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki74[] = {
  {795,1},	{832,1},	{833,1},	{758,1},
  {684,1},	{798,1},	{800,2},	{796,2},
  {722,2},	{759,2},	{834,2},	{797,2},
  {757,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{756,0},	{867,0},	{794,0},
  {869,0},	{648,0},	{685,0},	{830,0},
  {645,0},	{646,0},	{793,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {682,0},	{719,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{683,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{831,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki75[] = {
  {759,1},	{684,1},	{724,1},	{758,1},
  {721,1},	{760,2},	{722,2},	{648,2},
  {685,2},	{726,2},	{646,0},	{720,0},
  {609,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{571,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{757,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki76[] = {
  {759,1},	{684,1},	{724,1},	{758,1},
  {721,1},	{760,2},	{722,2},	{648,2},
  {685,2},	{726,2},	{646,0},	{720,0},
  {609,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{793,0},	{571,0},
  {795,0},	{574,0},	{611,0},	{572,0},
  {682,0},	{719,0},	{683,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{757,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki77[] = {
  {760,1},	{722,1},	{685,1},	{648,1},
  {761,1},	{726,1},	{759,2},	{721,2},
  {758,2},	{724,2},	{684,2},	{646,0},
  {571,0},	{720,0},	{534,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {608,0},	{793,0},	{535,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{572,0},
  {609,0},	{719,0},	{683,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{757,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{756,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki78[] = {
  {684,1},	{759,1},	{722,1},	{761,2},
  {721,2},	{758,2},	{793,0},	{756,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {608,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {682,0},	{719,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{645,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki79[] = {
  {684,1},	{796,1},	{759,1},	{722,1},
  {761,2},	{721,2},	{795,2},	{758,2},
  {793,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {608,0},	{830,0},	{572,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {682,0},	{719,0},	{756,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{645,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki80[] = {
  {721,1},	{684,1},	{833,1},	{759,1},
  {796,1},	{798,2},	{795,2},	{758,2},
  {722,2},	{832,2},	{830,0},	{646,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{683,0},	{608,0},
  {645,0},	{867,0},	{720,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{609,0},
  {719,0},	{756,0},	{793,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{682,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki81[] = {
  {721,1},	{684,1},	{723,1},	{759,1},
  {796,1},	{833,1},	{798,2},	{758,2},
  {722,2},	{760,2},	{795,2},	{832,2},
  {830,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{757,0},	{608,0},
  {645,0},	{867,0},	{720,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{609,0},
  {646,0},	{756,0},	{793,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{683,0},
  {719,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{682,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki82[] = {
  {684,1},	{796,1},	{686,1},	{722,1},
  {759,1},	{721,2},	{761,2},	{758,2},
  {685,2},	{795,2},	{793,0},	{609,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {608,0},	{830,0},	{683,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{572,0},
  {682,0},	{719,0},	{756,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{646,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{645,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki83[] = {
  {721,1},	{684,1},	{723,1},	{759,1},
  {796,1},	{833,1},	{758,2},	{685,2},
  {722,2},	{795,2},	{798,2},	{832,2},
  {646,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{757,0},	{608,0},
  {830,0},	{867,0},	{720,0},	{869,0},
  {611,0},	{648,0},	{645,0},	{609,0},
  {719,0},	{756,0},	{793,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{683,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{682,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki84[] = {
  {684,1},	{724,1},	{833,1},	{723,1},
  {759,1},	{796,1},	{721,1},	{758,2},
  {795,2},	{832,2},	{685,2},	{760,2},
  {798,2},	{722,2},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{720,0},	{830,0},
  {867,0},	{572,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{645,0},	{609,0},
  {646,0},	{756,0},	{793,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {683,0},	{719,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{608,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki85[] = {
  {684,1},	{687,1},	{689,2},	{648,2},
  {571,0},	{756,0},	{645,0},	{609,0},
  {646,0},	{683,0},	{608,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{574,0},	{611,0},
  {719,0},	{685,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{572,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0}
};

static struct patval joseki86[] = {
  {723,1},	{649,1},	{725,2},	{684,2},
  {718,0},	{755,0},	{681,0},	{571,0},
  {644,0},	{645,0},	{682,0},	{719,0},
  {607,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {570,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{792,0},	{686,0},	{608,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{756,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki87[] = {
  {763,1},	{797,1},	{723,1},	{684,2},
  {758,2},	{799,2},	{866,0},	{645,0},
  {681,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{718,0},	{721,0},
  {792,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{755,0},	{760,0},	{829,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{682,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{644,0},
  {800,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0}
};

static struct patval joseki88[] = {
  {799,1},	{684,1},	{800,1},	{758,1},
  {723,2},	{763,2},	{797,2},	{645,0},
  {682,0},	{719,0},	{829,0},	{866,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {755,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{644,0},	{760,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{792,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{756,0},
  {793,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0}
};

static struct patval joseki89[] = {
  {763,1},	{764,1},	{797,1},	{723,1},
  {758,2},	{684,2},	{799,2},	{800,2},
  {866,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{718,0},	{721,0},
  {792,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{755,0},	{760,0},	{829,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{682,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{644,0},
  {681,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{645,0},	{801,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0}
};

static struct patval joseki90[] = {
  {799,1},	{800,1},	{684,1},	{762,1},
  {758,1},	{797,2},	{764,2},	{723,2},
  {763,2},	{719,0},	{866,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{756,0},	{831,0},
  {868,0},	{647,0},	{718,0},	{721,0},
  {792,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{755,0},	{760,0},	{829,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {794,0},	{682,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{644,0},
  {681,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{645,0},	{801,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0}
};

static struct patval joseki91[] = {
  {723,1},	{763,1},	{764,1},	{725,1},
  {797,1},	{762,2},	{800,2},	{799,2},
  {758,2},	{684,2},	{719,0},	{645,0},
  {830,0},	{867,0},	{829,0},	{683,0},
  {720,0},	{757,0},	{866,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {682,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{644,0},	{760,0},	{794,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{646,0},
  {755,0},	{792,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{756,0},
  {793,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{718,0},	{801,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0}
};

static struct patval joseki92[] = {
  {758,1},	{799,1},	{801,1},	{762,1},
  {684,1},	{800,1},	{763,2},	{764,2},
  {797,2},	{723,2},	{725,2},	{719,0},
  {681,0},	{718,0},	{646,0},	{645,0},
  {720,0},	{757,0},	{794,0},	{755,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{683,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{831,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{756,0},
  {793,0},	{685,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{829,0},
  {866,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{830,0},	{867,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0},
  {656,0},	{693,0},	{730,0},	{767,0},
  {804,0},	{841,0},	{878,0}
};

static struct patval joseki93[] = {
  {797,1},	{764,1},	{725,1},	{765,1},
  {723,1},	{763,1},	{684,2},	{799,2},
  {758,2},	{800,2},	{801,2},	{762,2},
  {681,0},	{719,0},	{646,0},	{645,0},
  {720,0},	{757,0},	{794,0},	{718,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{683,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{831,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{756,0},
  {793,0},	{685,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{829,0},
  {866,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{830,0},	{867,0},
  {838,0},	{875,0},	{654,0},	{691,0},
  {728,0},	{755,0},	{802,0},	{839,0},
  {876,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0},
  {656,0},	{693,0},	{730,0},	{767,0},
  {804,0},	{841,0},	{878,0}
};

static struct patval joseki94[] = {
  {723,1},	{684,2},	{570,0},	{607,0},
  {644,0},	{681,0},	{718,0},	{755,0},
  {792,0},	{533,0},	{534,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {496,0},	{721,0},	{758,0},	{795,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{497,0},
  {760,0},	{797,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki95[] = {
  {684,1},	{758,1},	{797,2},	{496,0},
  {644,0},	{681,0},	{718,0},	{755,0},
  {607,0},	{829,0},	{866,0},	{497,0},
  {570,0},	{571,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{792,0},	{721,0},
  {533,0},	{795,0},	{832,0},	{869,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{534,0},
  {834,0},	{871,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki96[] = {
  {872,1},	{684,1},	{833,2},	{759,2},
  {719,0},	{571,0},	{793,0},	{830,0},
  {682,0},	{904,0},	{941,0},	{572,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{573,0},	{610,0},
  {647,0},	{645,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {943,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{867,0},	{796,0},
  {608,0},	{870,0},	{907,0},	{944,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{908,0},	{945,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{609,0},
  {909,0},	{946,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{911,0},	{948,0}
};

static struct patval joseki97[] = {
  {872,1},	{684,1},	{833,2},	{759,2},
  {719,0},	{571,0},	{793,0},	{830,0},
  {682,0},	{904,0},	{941,0},	{572,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{573,0},	{610,0},
  {647,0},	{645,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {943,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{867,0},	{796,0},
  {608,0},	{870,0},	{907,0},	{944,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{908,0},	{945,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{609,0},
  {909,0},	{946,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{911,0},	{948,0}
};

static struct patval joseki98[] = {
  {758,1},	{684,1},	{797,2},	{755,0},
  {681,0},	{829,0},	{866,0},	{645,0},
  {718,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0}
};

static struct patval joseki99[] = {
  {758,1},	{684,1},	{797,2},	{832,2},
  {792,0},	{644,0},	{866,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {755,0},	{795,0},	{829,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0}
};

static struct patval joseki100[] = {
  {797,1},	{832,1},	{684,2},	{758,2},
  {681,0},	{755,0},	{866,0},	{645,0},
  {829,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{718,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0}
};

static struct patval joseki101[] = {
  {758,1},	{799,1},	{684,1},	{797,2},
  {832,2},	{755,0},	{866,0},	{645,0},
  {829,0},	{719,0},	{756,0},	{793,0},
  {681,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{718,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{830,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0}
};

static struct patval joseki102[] = {
  {684,1},	{687,1},	{722,1},	{648,2},
  {689,2},	{574,2},	{756,0},	{645,0},
  {719,0},	{609,0},	{646,0},	{683,0},
  {571,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{535,0},	{721,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {534,0},	{685,0},	{608,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki103[] = {
  {648,1},	{686,1},	{689,1},	{574,1},
  {684,2},	{687,2},	{722,2},	{645,0},
  {719,0},	{609,0},	{646,0},	{683,0},
  {756,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{535,0},	{721,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {534,0},	{685,0},	{608,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki104[] = {
  {684,1},	{687,1},	{723,1},	{722,1},
  {686,2},	{574,2},	{689,2},	{648,2},
  {719,0},	{645,0},	{572,0},	{609,0},
  {498,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{646,0},	{721,0},	{758,0},
  {500,0},	{537,0},	{682,0},	{611,0},
  {756,0},	{685,0},	{608,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{534,0},	{571,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{535,0},	{724,0},	{761,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{497,0},	{726,0},	{763,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0}
};

static struct patval joseki105[] = {
  {648,1},	{686,1},	{689,1},	{650,1},
  {574,1},	{722,2},	{723,2},	{684,2},
  {687,2},	{719,0},	{645,0},	{683,0},
  {756,0},	{757,0},	{536,0},	{609,0},
  {610,0},	{647,0},	{646,0},	{721,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {534,0},	{685,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{608,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{535,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki106[] = {
  {684,1},	{722,1},	{723,1},	{687,1},
  {651,1},	{574,2},	{686,2},	{650,2},
  {689,2},	{648,2},	{719,0},	{645,0},
  {756,0},	{757,0},	{536,0},	{609,0},
  {610,0},	{647,0},	{646,0},	{721,0},
  {758,0},	{537,0},	{683,0},	{611,0},
  {534,0},	{685,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{608,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{535,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{682,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki107[] = {
  {648,1},	{686,1},	{689,1},	{650,1},
  {574,1},	{688,1},	{723,2},	{651,2},
  {687,2},	{722,2},	{684,2},	{645,0},
  {756,0},	{757,0},	{536,0},	{609,0},
  {610,0},	{647,0},	{646,0},	{721,0},
  {758,0},	{537,0},	{683,0},	{611,0},
  {534,0},	{685,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{608,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{535,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{682,0},	{719,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki108[] = {
  {684,1},	{722,1},	{723,1},	{724,1},
  {651,1},	{687,1},	{686,2},	{650,2},
  {688,2},	{574,2},	{648,2},	{689,2},
  {756,0},	{757,0},	{536,0},	{645,0},
  {610,0},	{647,0},	{646,0},	{721,0},
  {758,0},	{537,0},	{683,0},	{611,0},
  {534,0},	{685,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{608,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{535,0},	{572,0},
  {609,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{682,0},	{719,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki109[] = {
  {684,1},	{722,1},	{723,1},	{724,1},
  {651,1},	{687,1},	{686,2},	{650,2},
  {688,2},	{614,2},	{648,2},	{574,2},
  {689,2},	{757,0},	{536,0},	{756,0},
  {610,0},	{647,0},	{646,0},	{721,0},
  {758,0},	{537,0},	{683,0},	{611,0},
  {534,0},	{685,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {571,0},	{608,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{535,0},	{572,0},
  {609,0},	{761,0},	{540,0},	{577,0},
  {645,0},	{682,0},	{719,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{720,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki110[] = {
  {723,1},	{722,1},	{687,1},	{651,1},
  {684,1},	{689,2},	{686,2},	{650,2},
  {648,2},	{574,2},	{535,0},	{683,0},
  {534,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{609,0},	{721,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {645,0},	{685,0},	{646,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{720,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{719,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki111[] = {
  {797,1},	{723,1},	{832,1},	{799,2},
  {684,2},	{758,2},	{755,0},	{645,0},
  {829,0},	{719,0},	{756,0},	{793,0},
  {681,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{792,0},	{721,0},
  {644,0},	{795,0},	{718,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{866,0},	{760,0},	{682,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{830,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0}
};

static struct patval joseki112[] = {
  {797,1},	{832,1},	{758,2},	{684,2},
  {792,0},	{718,0},	{644,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{755,0},	{721,0},
  {829,0},	{795,0},	{681,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{866,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki113[] = {
  {648,1},	{684,1},	{574,1},	{722,2},
  {687,2},	{756,0},	{571,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{645,0},	{611,0},
  {719,0},	{685,0},	{608,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{572,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0}
};

static struct patval joseki114[] = {
  {690,1},	{722,1},	{687,1},	{684,2},
  {648,2},	{574,2},	{571,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{645,0},	{611,0},
  {719,0},	{685,0},	{608,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{572,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {579,0},	{616,0},	{653,0},	{756,0},
  {727,0},	{764,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0}
};

static struct patval joseki115[] = {
  {722,1},	{687,1},	{648,2},	{684,2},
  {574,2},	{534,0},	{571,0},	{460,0},
  {497,0},	{682,0},	{719,0},	{756,0},
  {386,0},	{387,0},	{424,0},	{461,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {351,0},	{388,0},	{425,0},	{462,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{721,0},	{758,0},
  {352,0},	{389,0},	{426,0},	{463,0},
  {500,0},	{537,0},	{645,0},	{611,0},
  {349,0},	{685,0},	{423,0},	{759,0},
  {353,0},	{390,0},	{427,0},	{464,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {354,0},	{391,0},	{428,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{350,0},	{724,0},	{761,0},
  {355,0},	{392,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {356,0},	{393,0},	{430,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki116[] = {
  {648,1},	{684,1},	{574,1},	{687,2},
  {722,2},	{645,0},	{756,0},	{571,0},
  {719,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{535,0},	{721,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {534,0},	{685,0},	{608,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{572,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki117[] = {
  {796,1},	{684,1},	{758,1},	{797,2},
  {760,2},	{792,0},	{829,0},	{607,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{866,0},	{721,0},
  {718,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{755,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {644,0},	{681,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0}
};

static struct patval joseki118[] = {
  {684,1},	{687,1},	{650,1},	{648,2},
  {574,2},	{686,2},	{645,0},	{719,0},
  {572,0},	{609,0},	{571,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {646,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {534,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{756,0},	{535,0},
  {724,0},	{761,0}
};

static struct patval joseki119[] = {
  {685,1},	{723,1},	{684,1},	{721,2},
  {724,2},	{687,2},	{683,0},	{720,0},
  {757,0},	{794,0},	{647,0},	{719,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{722,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{760,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki120[] = {
  {724,1},	{687,1},	{760,1},	{721,1},
  {685,2},	{723,2},	{684,2},	{720,0},
  {757,0},	{794,0},	{647,0},	{683,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{722,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki121[] = {
  {685,1},	{723,1},	{759,1},	{684,1},
  {721,2},	{687,2},	{760,2},	{724,2},
  {757,0},	{794,0},	{647,0},	{720,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{722,0},	{683,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki122[] = {
  {724,1},	{722,1},	{760,1},	{721,1},
  {687,1},	{685,2},	{759,2},	{684,2},
  {723,2},	{794,0},	{647,0},	{720,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{757,0},	{683,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki123[] = {
  {685,1},	{723,1},	{759,1},	{684,1},
  {758,1},	{687,2},	{721,2},	{760,2},
  {722,2},	{724,2},	{647,0},	{720,0},
  {756,0},	{794,0},	{795,0},	{648,0},
  {793,0},	{757,0},	{683,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki124[] = {
  {724,1},	{722,1},	{760,1},	{721,1},
  {686,1},	{687,1},	{759,2},	{684,2},
  {758,2},	{685,2},	{647,0},	{720,0},
  {756,0},	{757,0},	{795,0},	{648,0},
  {793,0},	{682,0},	{683,0},	{796,0},
  {649,0},	{794,0},	{723,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki125[] = {
  {685,1},	{723,1},	{684,1},	{722,1},
  {724,2},	{721,2},	{760,2},	{687,2},
  {720,0},	{794,0},	{647,0},	{683,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{757,0},	{759,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki126[] = {
  {724,1},	{759,1},	{760,1},	{721,1},
  {687,1},	{685,2},	{723,2},	{684,2},
  {722,2},	{794,0},	{647,0},	{720,0},
  {756,0},	{758,0},	{795,0},	{648,0},
  {793,0},	{757,0},	{683,0},	{796,0},
  {649,0},	{686,0},	{682,0},	{719,0},
  {797,0},	{650,0},	{646,0},	{645,0},
  {761,0},	{798,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki127[] = {
  {796,1},	{684,1},	{758,1},	{760,2},
  {797,2},	{866,0},	{682,0},	{681,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{718,0},	{721,0},
  {719,0},	{795,0},	{832,0},	{869,0},
  {685,0},	{722,0},	{759,0},	{829,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {755,0},	{792,0},	{834,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki128[] = {
  {796,1},	{684,1},	{758,1},	{760,2},
  {797,2},	{866,0},	{682,0},	{681,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{718,0},	{721,0},
  {719,0},	{795,0},	{832,0},	{869,0},
  {685,0},	{722,0},	{759,0},	{829,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {755,0},	{792,0},	{834,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki129[] = {
  {795,1},	{797,1},	{684,2},	{758,2},
  {644,0},	{829,0},	{866,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {755,0},	{792,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki130[] = {
  {648,1},	{574,1},	{684,1},	{685,2},
  {687,2},	{719,0},	{534,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki131[] = {
  {685,1},	{721,1},	{687,1},	{574,2},
  {684,2},	{648,2},	{571,0},	{535,0},
  {608,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{534,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki132[] = {
  {611,1},	{721,1},	{685,1},	{684,1},
  {724,2},	{758,2},	{722,2},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {610,0},	{647,0},	{609,0},	{756,0},
  {793,0},	{795,0},	{608,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{798,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0}
};

static struct patval joseki133[] = {
  {612,1},	{538,1},	{684,1},	{648,1},
  {611,1},	{651,2},	{685,2},	{687,2},
  {649,2},	{720,0},	{536,0},	{573,0},
  {610,0},	{572,0},	{535,0},	{721,0},
  {463,0},	{500,0},	{537,0},	{574,0},
  {609,0},	{499,0},	{683,0},	{722,0},
  {464,0},	{501,0},	{646,0},	{575,0},
  {461,0},	{647,0},	{686,0},	{723,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{498,0},	{724,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{462,0},	{688,0},	{725,0},
  {467,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki134[] = {
  {685,1},	{687,1},	{721,1},	{574,2},
  {684,2},	{648,2},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{719,0},
  {756,0},	{758,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0}
};

static struct patval joseki135[] = {
  {575,1},	{685,1},	{649,1},	{684,1},
  {688,2},	{722,2},	{686,2},	{610,0},
  {647,0},	{573,0},	{721,0},	{758,0},
  {574,0},	{611,0},	{648,0},	{720,0},
  {757,0},	{759,0},	{572,0},	{612,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki136[] = {
  {575,1},	{685,1},	{649,1},	{684,1},
  {721,1},	{722,2},	{724,2},	{688,2},
  {686,2},	{647,0},	{573,0},	{758,0},
  {574,0},	{611,0},	{648,0},	{610,0},
  {757,0},	{759,0},	{572,0},	{612,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki137[] = {
  {575,1},	{612,1},	{649,1},	{684,1},
  {685,1},	{721,1},	{688,2},	{724,2},
  {722,2},	{686,2},	{650,2},	{758,0},
  {574,0},	{611,0},	{648,0},	{610,0},
  {647,0},	{759,0},	{572,0},	{757,0},
  {573,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{646,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki138[] = {
  {575,1},	{685,1},	{649,1},	{759,1},
  {721,1},	{684,1},	{650,2},	{688,2},
  {686,2},	{722,2},	{724,2},	{647,0},
  {574,0},	{611,0},	{648,0},	{610,0},
  {757,0},	{758,0},	{572,0},	{612,0},
  {573,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{646,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki139[] = {
  {685,1},	{687,1},	{721,1},	{684,2},
  {574,2},	{648,2},	{572,0},	{608,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {609,0},	{758,0},	{645,0},	{611,0},
  {719,0},	{571,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{756,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki140[] = {
  {574,1},	{684,1},	{648,1},	{686,1},
  {687,2},	{721,2},	{685,2},	{572,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{719,0},
  {756,0},	{758,0},	{571,0},	{611,0},
  {645,0},	{609,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0}
};

static struct patval joseki141[] = {
  {685,1},	{722,1},	{687,1},	{721,1},
  {684,2},	{574,2},	{648,2},	{686,2},
  {608,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{534,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {535,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki142[] = {
  {649,1},	{686,1},	{574,1},	{684,1},
  {648,1},	{685,2},	{722,2},	{721,2},
  {687,2},	{683,0},	{646,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {609,0},	{758,0},	{645,0},	{611,0},
  {719,0},	{571,0},	{608,0},	{759,0},
  {575,0},	{612,0},	{720,0},	{572,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{756,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki143[] = {
  {723,1},	{722,1},	{687,1},	{685,1},
  {721,1},	{684,2},	{648,2},	{686,2},
  {649,2},	{574,2},	{646,0},	{609,0},
  {608,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{683,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{720,0},
  {535,0},	{534,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki144[] = {
  {684,1},	{687,1},	{650,1},	{575,1},
  {685,1},	{649,1},	{722,2},	{723,2},
  {686,2},	{688,2},	{724,2},	{647,0},
  {610,0},	{758,0},	{609,0},	{574,0},
  {611,0},	{648,0},	{683,0},	{573,0},
  {759,0},	{538,0},	{646,0},	{612,0},
  {720,0},	{537,0},	{572,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{721,0},
  {536,0},	{535,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{757,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0}
};

static struct patval joseki145[] = {
  {722,1},	{685,1},	{687,1},	{721,1},
  {574,2},	{686,2},	{684,2},	{648,2},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{609,0},	{719,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki146[] = {
  {723,1},	{686,1},	{648,1},	{574,1},
  {684,1},	{721,2},	{687,2},	{722,2},
  {685,2},	{609,0},	{646,0},	{608,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{683,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {535,0},	{534,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki147[] = {
  {721,1},	{722,1},	{687,1},	{649,1},
  {685,1},	{574,2},	{684,2},	{686,2},
  {648,2},	{723,2},	{534,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {572,0},	{609,0},	{646,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{645,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki148[] = {
  {723,1},	{724,1},	{686,1},	{574,1},
  {684,1},	{648,1},	{687,2},	{722,2},
  {721,2},	{649,2},	{685,2},	{646,0},
  {609,0},	{608,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{683,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{720,0},
  {757,0},	{534,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {535,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki149[] = {
  {721,1},	{650,1},	{687,1},	{649,1},
  {685,1},	{722,1},	{574,2},	{686,2},
  {648,2},	{684,2},	{724,2},	{723,2},
  {720,0},	{757,0},	{683,0},	{573,0},
  {610,0},	{647,0},	{534,0},	{535,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {572,0},	{609,0},	{536,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{646,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{608,0},
  {645,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki150[] = {
  {688,1},	{574,1},	{684,1},	{724,1},
  {686,1},	{723,1},	{648,1},	{721,2},
  {650,2},	{687,2},	{649,2},	{722,2},
  {685,2},	{720,0},	{683,0},	{573,0},
  {610,0},	{647,0},	{534,0},	{535,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {572,0},	{757,0},	{536,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{646,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{608,0},
  {645,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{609,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki151[] = {
  {721,1},	{650,1},	{687,1},	{649,1},
  {685,1},	{722,1},	{651,1},	{688,2},
  {574,2},	{684,2},	{724,2},	{723,2},
  {648,2},	{686,2},	{683,0},	{573,0},
  {610,0},	{647,0},	{534,0},	{535,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {720,0},	{757,0},	{536,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{646,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{608,0},
  {645,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki152[] = {
  {686,1},	{723,1},	{724,1},	{684,1},
  {574,1},	{648,1},	{721,2},	{685,2},
  {722,2},	{649,2},	{650,2},	{687,2},
  {645,0},	{609,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{720,0},	{719,0},
  {758,0},	{537,0},	{682,0},	{611,0},
  {646,0},	{683,0},	{608,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{757,0},
  {534,0},	{571,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{756,0},	{535,0},
  {572,0},	{761,0}
};

static struct patval joseki153[] = {
  {687,1},	{722,1},	{759,1},	{684,1},
  {724,1},	{758,1},	{686,1},	{611,2},
  {761,2},	{723,2},	{685,2},	{760,2},
  {721,2},	{646,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{757,0},	{756,0},
  {795,0},	{574,0},	{719,0},	{648,0},
  {683,0},	{720,0},	{645,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{794,0},
  {571,0},	{608,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{793,0},	{572,0},
  {609,0},	{798,0}
};

static struct patval joseki154[] = {
  {723,1},	{760,1},	{761,1},	{721,1},
  {611,1},	{648,1},	{685,1},	{684,2},
  {759,2},	{686,2},	{687,2},	{722,2},
  {724,2},	{758,2},	{573,0},	{646,0},
  {647,0},	{682,0},	{757,0},	{610,0},
  {795,0},	{574,0},	{719,0},	{756,0},
  {683,0},	{720,0},	{645,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{794,0},
  {571,0},	{608,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{793,0},	{572,0},
  {609,0},	{798,0}
};

static struct patval joseki155[] = {
  {685,1},	{722,1},	{687,1},	{721,1},
  {684,2},	{574,2},	{648,2},	{686,2},
  {608,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {719,0},	{534,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {535,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki156[] = {
  {684,1},	{686,1},	{648,1},	{574,1},
  {650,1},	{685,2},	{687,2},	{722,2},
  {721,2},	{609,0},	{608,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{572,0},
  {758,0},	{537,0},	{645,0},	{611,0},
  {646,0},	{534,0},	{571,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {535,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{719,0},	{756,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki157[] = {
  {685,1},	{721,1},	{687,1},	{574,2},
  {648,2},	{684,2},	{719,0},	{534,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki158[] = {
  {612,1},	{684,1},	{648,1},	{685,2},
  {651,2},	{649,2},	{646,0},	{647,0},
  {573,0},	{721,0},	{574,0},	{611,0},
  {683,0},	{610,0},	{722,0},	{575,0},
  {720,0},	{609,0},	{686,0},	{723,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0}
};

static struct patval joseki159[] = {
  {687,1},	{651,1},	{685,1},	{649,1},
  {538,2},	{612,2},	{684,2},	{648,2},
  {610,0},	{647,0},	{536,0},	{721,0},
  {537,0},	{574,0},	{611,0},	{573,0},
  {720,0},	{722,0},	{535,0},	{575,0},
  {609,0},	{646,0},	{686,0},	{723,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki160[] = {
  {648,1},	{722,1},	{684,1},	{538,1},
  {612,1},	{687,2},	{685,2},	{649,2},
  {651,2},	{573,0},	{610,0},	{499,0},
  {572,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{646,0},	{536,0},
  {535,0},	{501,0},	{609,0},	{575,0},
  {683,0},	{647,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{498,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{720,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki161[] = {
  {685,1},	{687,1},	{651,1},	{613,1},
  {649,1},	{538,2},	{648,2},	{684,2},
  {612,2},	{722,2},	{610,0},	{573,0},
  {498,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {647,0},	{501,0},	{535,0},	{575,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{609,0},
  {650,0},	{683,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki162[] = {
  {538,1},	{575,1},	{612,1},	{722,1},
  {648,1},	{684,1},	{651,2},	{687,2},
  {685,2},	{649,2},	{613,2},	{721,0},
  {537,0},	{574,0},	{611,0},	{573,0},
  {610,0},	{647,0},	{535,0},	{720,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {539,0},	{576,0},	{609,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki163[] = {
  {686,1},	{651,1},	{613,1},	{649,1},
  {687,1},	{685,1},	{612,2},	{648,2},
  {538,2},	{722,2},	{684,2},	{575,2},
  {721,0},	{574,0},	{611,0},	{573,0},
  {537,0},	{647,0},	{535,0},	{720,0},
  {536,0},	{646,0},	{610,0},	{723,0},
  {539,0},	{576,0},	{609,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki164[] = {
  {685,1},	{687,1},	{651,1},	{613,1},
  {649,1},	{538,2},	{648,2},	{684,2},
  {612,2},	{722,2},	{610,0},	{573,0},
  {498,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {647,0},	{501,0},	{535,0},	{575,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{609,0},
  {650,0},	{683,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki165[] = {
  {722,1},	{686,1},	{684,1},	{538,1},
  {648,1},	{612,1},	{651,2},	{649,2},
  {687,2},	{613,2},	{572,0},	{499,0},
  {536,0},	{610,0},	{500,0},	{537,0},
  {574,0},	{721,0},	{646,0},	{685,0},
  {573,0},	{501,0},	{609,0},	{575,0},
  {683,0},	{647,0},	{535,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{611,0},
  {650,0},	{498,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{720,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki166[] = {
  {685,1},	{721,1},	{687,1},	{574,2},
  {648,2},	{684,2},	{719,0},	{534,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki167[] = {
  {722,1},	{574,1},	{684,1},	{648,1},
  {685,2},	{721,2},	{687,2},	{534,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{719,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki168[] = {
  {685,1},	{686,1},	{687,1},	{721,1},
  {574,2},	{722,2},	{684,2},	{648,2},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{535,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{609,0},	{719,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki169[] = {
  {684,1},	{538,1},	{648,1},	{612,1},
  {686,1},	{650,2},	{651,2},	{685,2},
  {649,2},	{536,0},	{610,0},	{647,0},
  {498,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{535,0},	{575,0},
  {609,0},	{573,0},	{683,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {646,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki170[] = {
  {649,1},	{611,1},	{651,1},	{685,1},
  {650,1},	{686,2},	{648,2},	{612,2},
  {538,2},	{684,2},	{610,0},	{647,0},
  {498,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{536,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{535,0},	{575,0},
  {609,0},	{573,0},	{683,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {646,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki171[] = {
  {721,1},	{575,1},	{685,1},	{649,1},
  {684,1},	{723,1},	{688,2},	{722,2},
  {648,2},	{686,2},	{687,2},	{647,0},
  {535,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{573,0},	{757,0},	{536,0},
  {759,0},	{538,0},	{572,0},	{612,0},
  {646,0},	{610,0},	{720,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0}
};

static struct patval joseki172[] = {
  {686,1},	{648,1},	{688,1},	{722,1},
  {687,1},	{612,1},	{685,2},	{723,2},
  {575,2},	{721,2},	{649,2},	{684,2},
  {535,0},	{758,0},	{537,0},	{574,0},
  {611,0},	{573,0},	{757,0},	{647,0},
  {759,0},	{538,0},	{572,0},	{536,0},
  {646,0},	{610,0},	{720,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0}
};

static struct patval joseki173[] = {
  {611,1},	{575,1},	{685,1},	{649,1},
  {684,1},	{723,1},	{721,1},	{688,2},
  {648,2},	{686,2},	{722,2},	{687,2},
  {612,2},	{758,0},	{537,0},	{574,0},
  {535,0},	{573,0},	{757,0},	{647,0},
  {759,0},	{538,0},	{572,0},	{536,0},
  {646,0},	{610,0},	{720,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0}
};

static struct patval joseki174[] = {
  {687,1},	{684,1},	{648,2},	{574,2},
  {682,0},	{719,0},	{534,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki175[] = {
  {723,1},	{684,2},	{690,2},	{607,0},
  {570,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{718,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{719,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{644,0},	{727,0},
  {764,0},	{801,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki176[] = {
  {684,1},	{686,1},	{723,2},	{570,0},
  {718,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki177[] = {
  {723,1},	{687,1},	{690,2},	{684,2},
  {686,2},	{755,0},	{792,0},	{571,0},
  {570,0},	{645,0},	{682,0},	{718,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{719,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{644,0},	{727,0},
  {764,0},	{801,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki178[] = {
  {723,1},	{684,2},	{607,0},	{681,0},
  {718,0},	{755,0},	{792,0},	{571,0},
  {644,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {570,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{608,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki179[] = {
  {684,1},	{686,1},	{723,2},	{570,0},
  {718,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki180[] = {
  {723,1},	{687,1},	{686,2},	{684,2},
  {681,0},	{607,0},	{570,0},	{571,0},
  {608,0},	{645,0},	{718,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki181[] = {
  {649,1},	{686,1},	{684,1},	{723,2},
  {687,2},	{755,0},	{792,0},	{571,0},
  {718,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki182[] = {
  {723,1},	{722,1},	{687,1},	{684,2},
  {649,2},	{686,2},	{681,0},	{607,0},
  {608,0},	{645,0},	{570,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{718,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki183[] = {
  {721,1},	{649,1},	{686,1},	{684,1},
  {723,2},	{687,2},	{722,2},	{607,0},
  {792,0},	{719,0},	{756,0},	{608,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {645,0},	{793,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{755,0},
  {759,0},	{796,0},	{612,0},	{644,0},
  {681,0},	{718,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{682,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki184[] = {
  {723,1},	{722,1},	{687,1},	{721,2},
  {649,2},	{686,2},	{684,2},	{681,0},
  {608,0},	{645,0},	{607,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{570,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{718,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki185[] = {
  {721,1},	{649,1},	{686,1},	{684,1},
  {723,2},	{687,2},	{722,2},	{607,0},
  {792,0},	{719,0},	{756,0},	{608,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {645,0},	{793,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{755,0},
  {759,0},	{796,0},	{612,0},	{644,0},
  {681,0},	{718,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{682,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki186[] = {
  {723,1},	{722,1},	{687,1},	{725,1},
  {684,2},	{686,2},	{721,2},	{649,2},
  {608,0},	{645,0},	{681,0},	{719,0},
  {756,0},	{607,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {793,0},	{570,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{718,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{682,0},	{762,0},	{799,0}
};

static struct patval joseki187[] = {
  {797,1},	{759,1},	{761,1},	{796,1},
  {799,1},	{760,2},	{795,2},	{684,2},
  {723,2},	{758,2},	{682,0},	{793,0},
  {681,0},	{719,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{755,0},	{721,0},
  {867,0},	{644,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{830,0},
  {645,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{792,0},	{829,0},	{866,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{718,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{756,0},	{836,0},	{873,0}
};

static struct patval joseki188[] = {
  {796,1},	{797,1},	{722,1},	{761,1},
  {759,1},	{799,1},	{758,2},	{760,2},
  {795,2},	{684,2},	{723,2},	{719,0},
  {755,0},	{793,0},	{681,0},	{682,0},
  {645,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{792,0},	{721,0},
  {609,0},	{644,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{830,0},
  {867,0},	{607,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{829,0},
  {866,0},	{608,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {718,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{756,0},	{836,0},	{873,0}
};

static struct patval joseki189[] = {
  {945,1},	{944,1},	{906,2},	{871,2},
  {684,2},	{943,2},	{908,2},	{832,2},
  {903,0},	{977,0},	{755,0},	{866,0},
  {829,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{644,0},	{904,0},	{941,0},
  {978,0},	{1015,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{979,0},
  {1016,0},	{647,0},	{792,0},	{721,0},
  {758,0},	{795,0},	{940,0},	{869,0},
  {867,0},	{718,0},	{980,0},	{1017,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {681,0},	{981,0},	{1018,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{1014,0},	{645,0},	{682,0},
  {982,0},	{1019,0}
};

static struct patval joseki190[] = {
  {725,1},	{723,1},	{722,1},	{687,1},
  {649,2},	{686,2},	{721,2},	{684,2},
  {719,0},	{793,0},	{792,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {756,0},	{682,0},	{758,0},	{795,0},
  {648,0},	{685,0},	{718,0},	{759,0},
  {796,0},	{646,0},	{644,0},	{681,0},
  {760,0},	{797,0},	{650,0},	{645,0},
  {724,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{755,0},	{762,0},	{799,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0}
};

static struct patval joseki191[] = {
  {649,1},	{686,1},	{721,1},	{684,1},
  {723,2},	{722,2},	{687,2},	{571,0},
  {792,0},	{755,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki192[] = {
  {722,1},	{687,1},	{723,1},	{685,1},
  {649,2},	{684,2},	{721,2},	{686,2},
  {571,0},	{792,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki193[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {721,1},	{685,2},	{722,2},	{723,2},
  {687,2},	{571,0},	{682,0},	{719,0},
  {755,0},	{792,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{793,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{645,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki194[] = {
  {684,1},	{724,1},	{760,1},	{722,1},
  {759,1},	{721,2},	{758,2},	{686,2},
  {723,2},	{685,2},	{719,0},	{756,0},
  {792,0},	{829,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{610,0},	{647,0},	{608,0},
  {793,0},	{830,0},	{795,0},	{832,0},
  {611,0},	{648,0},	{682,0},	{718,0},
  {755,0},	{796,0},	{833,0},	{612,0},
  {649,0},	{607,0},	{644,0},	{681,0},
  {797,0},	{834,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{798,0},
  {835,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0}
};

static struct patval joseki195[] = {
  {723,1},	{760,1},	{722,1},	{758,1},
  {795,1},	{684,1},	{759,2},	{721,2},
  {761,2},	{797,2},	{796,2},	{793,0},
  {829,0},	{756,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{866,0},	{645,0},
  {830,0},	{867,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{719,0},	{755,0},
  {792,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{644,0},	{681,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{682,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0}
};

static struct patval joseki196[] = {
  {684,1},	{725,1},	{761,1},	{723,1},
  {760,1},	{685,1},	{648,2},	{722,2},
  {724,2},	{686,2},	{759,2},	{687,2},
  {793,0},	{720,0},	{610,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{683,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki197[] = {
  {687,1},	{724,1},	{686,1},	{722,1},
  {759,1},	{796,1},	{648,1},	{685,2},
  {725,2},	{761,2},	{760,2},	{684,2},
  {723,2},	{720,0},	{610,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{793,0},	{833,0},
  {612,0},	{649,0},	{683,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki198[] = {
  {684,1},	{725,1},	{761,1},	{723,1},
  {760,1},	{762,1},	{685,1},	{648,2},
  {724,2},	{796,2},	{686,2},	{687,2},
  {722,2},	{759,2},	{720,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{793,0},	{833,0},
  {612,0},	{649,0},	{610,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki199[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{833,1},	{685,1},	{684,1},
  {722,2},	{799,2},	{762,2},	{721,2},
  {760,2},	{797,2},	{798,2},	{757,0},
  {794,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {831,0},	{868,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki200[] = {
  {648,1},	{684,1},	{725,1},	{687,1},
  {724,1},	{726,1},	{689,1},	{649,1},
  {612,2},	{760,2},	{688,2},	{651,2},
  {686,2},	{723,2},	{650,2},	{611,2},
  {721,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{574,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki201[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{685,1},
  {684,1},	{800,2},	{723,2},	{722,2},
  {761,2},	{798,2},	{799,2},	{758,2},
  {763,2},	{795,0},	{796,0},	{833,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki202[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{832,1},	{800,1},	{723,1},
  {763,1},	{686,2},	{762,2},	{725,2},
  {834,2},	{797,2},	{724,2},	{685,2},
  {760,2},	{684,2},	{796,0},	{795,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki203[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{759,1},
  {684,1},	{685,1},	{723,2},	{800,2},
  {832,2},	{798,2},	{799,2},	{722,2},
  {763,2},	{758,2},	{761,2},	{796,0},
  {795,0},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{721,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki204[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{832,1},	{800,1},	{723,1},
  {763,1},	{721,1},	{762,2},	{686,2},
  {834,2},	{797,2},	{724,2},	{685,2},
  {725,2},	{759,2},	{684,2},	{760,2},
  {795,0},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki205[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{795,1},
  {684,1},	{685,1},	{759,1},	{721,2},
  {832,2},	{798,2},	{799,2},	{723,2},
  {722,2},	{758,2},	{800,2},	{761,2},
  {763,2},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki206[] = {
  {612,1},	{648,1},	{689,1},	{651,1},
  {684,1},	{722,1},	{690,1},	{613,1},
  {653,1},	{611,1},	{688,1},	{652,2},
  {724,2},	{687,2},	{614,2},	{575,2},
  {615,2},	{649,2},	{576,2},	{650,2},
  {685,2},	{574,2},	{539,0},	{537,0},
  {723,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{538,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{686,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki207[] = {
  {615,1},	{652,1},	{614,1},	{650,1},
  {687,1},	{724,1},	{576,1},	{685,1},
  {574,1},	{686,1},	{649,1},	{575,1},
  {722,2},	{684,2},	{689,2},	{613,2},
  {612,2},	{648,2},	{611,2},	{651,2},
  {688,2},	{690,2},	{653,2},	{537,0},
  {723,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{539,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{538,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki208[] = {
  {649,1},	{685,1},	{726,1},	{684,1},
  {721,1},	{759,1},	{727,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{725,1},
  {761,2},	{724,2},	{651,2},	{689,2},
  {652,2},	{686,2},	{613,2},	{612,2},
  {722,2},	{723,2},	{611,2},	{687,2},
  {574,0},	{796,0},	{758,0},	{798,0},
  {577,0},	{795,0},	{576,0},	{760,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki209[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{758,1},	{613,1},	{722,1},
  {611,1},	{723,1},	{761,1},	{612,1},
  {686,1},	{721,2},	{726,2},	{650,2},
  {649,2},	{759,2},	{648,2},	{688,2},
  {725,2},	{727,2},	{690,2},	{685,2},
  {684,2},	{796,0},	{574,0},	{798,0},
  {577,0},	{795,0},	{576,0},	{760,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki210[] = {
  {759,1},	{649,1},	{725,1},	{726,1},
  {684,1},	{721,1},	{685,1},	{795,1},
  {688,1},	{650,1},	{690,1},	{648,1},
  {727,1},	{613,2},	{612,2},	{724,2},
  {723,2},	{651,2},	{761,2},	{652,2},
  {686,2},	{689,2},	{687,2},	{722,2},
  {611,2},	{576,0},	{538,0},	{574,0},
  {760,0},	{796,0},	{758,0},	{798,0},
  {540,0},	{577,0},	{537,0},	{539,0},
  {536,0},	{797,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {610,0},	{647,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {614,0},	{575,0},	{764,0},	{801,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki211[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{795,1},
  {684,1},	{685,1},	{759,1},	{721,2},
  {832,2},	{798,2},	{799,2},	{723,2},
  {722,2},	{758,2},	{800,2},	{761,2},
  {763,2},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki212[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{832,1},	{796,1},	{723,1},
  {763,1},	{721,1},	{800,1},	{795,2},
  {834,2},	{762,2},	{724,2},	{685,2},
  {725,2},	{759,2},	{686,2},	{760,2},
  {684,2},	{797,2},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki213[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{833,1},
  {684,1},	{795,1},	{759,1},	{685,1},
  {721,2},	{798,2},	{799,2},	{832,2},
  {722,2},	{758,2},	{800,2},	{723,2},
  {763,2},	{761,2},	{868,0},	{647,0},
  {649,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki214[] = {
  {612,1},	{648,1},	{689,1},	{651,1},
  {684,1},	{722,1},	{690,1},	{613,1},
  {653,1},	{611,1},	{688,1},	{652,2},
  {724,2},	{687,2},	{614,2},	{575,2},
  {615,2},	{649,2},	{576,2},	{723,2},
  {685,2},	{650,2},	{574,2},	{537,0},
  {539,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{538,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{686,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki215[] = {
  {615,1},	{652,1},	{614,1},	{650,1},
  {687,1},	{724,1},	{576,1},	{723,1},
  {574,1},	{686,1},	{649,1},	{685,1},
  {575,1},	{684,2},	{689,2},	{722,2},
  {612,2},	{648,2},	{611,2},	{613,2},
  {688,2},	{690,2},	{653,2},	{651,2},
  {537,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{539,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{538,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki216[] = {
  {649,1},	{685,1},	{726,1},	{684,1},
  {721,1},	{759,1},	{727,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{725,1},
  {761,2},	{724,2},	{651,2},	{689,2},
  {652,2},	{686,2},	{613,2},	{760,2},
  {722,2},	{723,2},	{612,2},	{611,2},
  {687,2},	{574,0},	{758,0},	{798,0},
  {577,0},	{796,0},	{576,0},	{795,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki217[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{761,1},	{613,1},	{760,1},
  {611,1},	{723,1},	{686,1},	{722,1},
  {612,1},	{796,1},	{726,2},	{759,2},
  {649,2},	{685,2},	{648,2},	{650,2},
  {725,2},	{727,2},	{688,2},	{721,2},
  {684,2},	{690,2},	{574,0},	{798,0},
  {577,0},	{758,0},	{576,0},	{795,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki218[] = {
  {649,1},	{685,1},	{726,1},	{684,1},
  {721,1},	{758,1},	{727,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{725,1},
  {759,1},	{796,2},	{651,2},	{689,2},
  {652,2},	{686,2},	{613,2},	{760,2},
  {722,2},	{723,2},	{612,2},	{761,2},
  {687,2},	{724,2},	{611,2},	{798,0},
  {577,0},	{574,0},	{576,0},	{795,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki219[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{833,1},	{685,1},	{684,1},
  {722,2},	{799,2},	{762,2},	{721,2},
  {760,2},	{797,2},	{798,2},	{757,0},
  {794,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {831,0},	{868,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki220[] = {
  {685,1},	{726,1},	{762,1},	{724,1},
  {761,1},	{684,1},	{763,1},	{686,1},
  {725,2},	{797,2},	{648,2},	{649,2},
  {723,2},	{760,2},	{687,2},	{688,2},
  {721,0},	{722,0},	{758,0},	{796,0},
  {833,0},	{612,0},	{831,0},	{610,0},
  {795,0},	{832,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{720,0},
  {757,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{800,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki221[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{685,1},
  {684,1},	{721,2},	{723,2},	{800,2},
  {761,2},	{798,2},	{799,2},	{763,2},
  {722,2},	{758,0},	{795,0},	{833,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki222[] = {
  {722,1},	{763,1},	{799,1},	{761,1},
  {798,1},	{721,1},	{800,1},	{723,1},
  {795,1},	{834,2},	{684,2},	{762,2},
  {760,2},	{797,2},	{724,2},	{685,2},
  {725,2},	{686,2},	{758,0},	{833,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki223[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{832,1},
  {684,1},	{685,1},	{721,2},	{795,2},
  {723,2},	{798,2},	{799,2},	{763,2},
  {722,2},	{761,2},	{800,2},	{833,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {758,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki224[] = {
  {575,1},	{616,1},	{652,1},	{614,1},
  {651,1},	{684,1},	{653,1},	{576,1},
  {648,1},	{574,1},	{687,2},	{615,2},
  {685,2},	{650,2},	{577,2},	{538,2},
  {578,2},	{537,2},	{539,2},	{613,2},
  {723,0},	{502,0},	{721,0},	{500,0},
  {686,0},	{722,0},	{611,0},	{724,0},
  {503,0},	{540,0},	{501,0},	{610,0},
  {647,0},	{688,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki225[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{687,1},	{539,1},	{685,1},
  {537,1},	{722,1},	{538,1},	{648,2},
  {576,2},	{574,2},	{652,2},	{684,2},
  {575,2},	{616,2},	{653,2},	{614,2},
  {651,2},	{502,0},	{721,0},	{500,0},
  {686,0},	{723,0},	{611,0},	{724,0},
  {503,0},	{540,0},	{501,0},	{610,0},
  {647,0},	{688,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki226[] = {
  {575,1},	{616,1},	{652,1},	{614,1},
  {651,1},	{684,1},	{653,1},	{576,1},
  {688,1},	{574,1},	{648,1},	{687,2},
  {615,2},	{722,2},	{577,2},	{538,2},
  {578,2},	{537,2},	{539,2},	{613,2},
  {650,2},	{685,2},	{721,0},	{500,0},
  {686,0},	{723,0},	{611,0},	{724,0},
  {503,0},	{540,0},	{501,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki227[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{687,1},	{724,1},	{685,1},
  {537,1},	{722,1},	{539,1},	{538,1},
  {576,2},	{574,2},	{652,2},	{648,2},
  {575,2},	{616,2},	{653,2},	{614,2},
  {651,2},	{688,2},	{684,2},	{500,0},
  {686,0},	{723,0},	{611,0},	{721,0},
  {503,0},	{540,0},	{501,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki228[] = {
  {575,1},	{616,1},	{652,1},	{614,1},
  {651,1},	{684,1},	{649,1},	{576,1},
  {653,1},	{574,1},	{688,1},	{648,1},
  {687,2},	{615,2},	{577,2},	{538,2},
  {578,2},	{537,2},	{724,2},	{613,2},
  {722,2},	{685,2},	{539,2},	{650,2},
  {686,0},	{723,0},	{611,0},	{721,0},
  {503,0},	{540,0},	{500,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{501,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki229[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{687,1},	{724,1},	{685,1},
  {537,1},	{722,1},	{539,1},	{538,1},
  {612,1},	{574,2},	{652,2},	{648,2},
  {575,2},	{576,2},	{649,2},	{614,2},
  {616,2},	{688,2},	{684,2},	{653,2},
  {651,2},	{686,0},	{611,0},	{721,0},
  {503,0},	{723,0},	{500,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{540,0},	{501,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki230[] = {
  {575,1},	{611,1},	{652,1},	{614,1},
  {651,1},	{684,1},	{649,1},	{576,1},
  {616,1},	{574,1},	{653,1},	{648,1},
  {688,1},	{615,2},	{577,2},	{538,2},
  {578,2},	{612,2},	{724,2},	{687,2},
  {537,2},	{685,2},	{539,2},	{650,2},
  {613,2},	{722,2},	{686,0},	{721,0},
  {503,0},	{723,0},	{500,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{540,0},	{501,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki231[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{687,1},	{724,1},	{686,1},
  {537,1},	{722,1},	{539,1},	{538,1},
  {685,1},	{612,1},	{652,2},	{648,2},
  {575,2},	{574,2},	{649,2},	{576,2},
  {616,2},	{688,2},	{611,2},	{653,2},
  {614,2},	{651,2},	{684,2},	{721,0},
  {503,0},	{723,0},	{500,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{540,0},	{501,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki232[] = {
  {575,1},	{611,1},	{652,1},	{614,1},
  {651,1},	{684,1},	{725,1},	{576,1},
  {616,1},	{574,1},	{653,1},	{648,1},
  {688,1},	{649,1},	{615,2},	{538,2},
  {578,2},	{612,2},	{577,2},	{686,2},
  {537,2},	{685,2},	{539,2},	{650,2},
  {613,2},	{722,2},	{687,2},	{724,2},
  {503,0},	{723,0},	{500,0},	{610,0},
  {647,0},	{502,0},	{721,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{540,0},	{501,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki233[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{687,1},	{724,1},	{685,1},
  {537,1},	{722,1},	{539,1},	{538,1},
  {576,2},	{574,2},	{652,2},	{648,2},
  {575,2},	{616,2},	{653,2},	{614,2},
  {651,2},	{688,2},	{684,2},	{500,0},
  {686,0},	{723,0},	{611,0},	{721,0},
  {503,0},	{540,0},	{501,0},	{610,0},
  {647,0},	{502,0},	{725,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {689,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{690,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki234[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{801,1},	{724,1},
  {764,1},	{722,1},	{836,1},	{796,1},
  {763,2},	{870,2},	{725,2},	{686,2},
  {726,2},	{685,2},	{872,2},	{835,2},
  {798,2},	{833,2},	{687,2},	{761,2},
  {648,0},	{871,0},	{834,0},	{869,0},
  {651,0},	{688,0},	{649,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{760,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki235[] = {
  {726,1},	{763,1},	{725,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{722,2},	{800,2},	{796,2},
  {723,2},	{764,2},	{801,2},	{832,2},
  {799,2},	{836,2},	{684,2},	{724,2},
  {762,2},	{871,0},	{834,0},	{869,0},
  {651,0},	{688,0},	{649,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{760,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki236[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{801,1},	{796,1},
  {836,1},	{763,2},	{725,2},	{686,2},
  {726,2},	{685,2},	{872,2},	{835,2},
  {870,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{834,0},	{869,0},
  {651,0},	{688,0},	{871,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{760,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki237[] = {
  {726,1},	{763,1},	{725,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{760,1},	{800,2},	{796,2},
  {723,2},	{722,2},	{797,2},	{832,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {762,2},	{799,2},	{801,2},	{869,0},
  {651,0},	{871,0},	{834,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki238[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{759,1},	{796,1},
  {836,1},	{801,1},	{725,2},	{686,2},
  {726,2},	{760,2},	{872,2},	{835,2},
  {685,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{870,2},	{798,2},	{763,2},
  {651,0},	{869,0},	{834,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{871,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki239[] = {
  {726,1},	{763,1},	{725,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{760,1},	{834,1},	{796,2},
  {723,2},	{722,2},	{797,2},	{800,2},
  {764,2},	{836,2},	{759,2},	{724,2},
  {762,2},	{799,2},	{832,2},	{801,2},
  {684,2},	{651,0},	{869,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{871,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki240[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{759,1},	{796,1},
  {836,1},	{801,1},	{799,1},	{686,2},
  {725,2},	{760,2},	{872,2},	{834,2},
  {726,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{870,2},	{835,2},	{763,2},
  {798,2},	{685,2},	{651,0},	{869,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{758,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki241[] = {
  {726,1},	{763,1},	{725,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{722,2},	{800,2},	{796,2},
  {723,2},	{764,2},	{801,2},	{832,2},
  {799,2},	{836,2},	{684,2},	{724,2},
  {762,2},	{871,0},	{834,0},	{869,0},
  {651,0},	{688,0},	{649,0},	{758,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{760,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki242[] = {
  {836,1},	{723,1},	{684,1},	{800,1},
  {762,1},	{799,1},	{832,1},	{801,1},
  {760,1},	{724,1},	{764,1},	{722,1},
  {796,1},	{687,2},	{686,2},	{870,2},
  {835,2},	{725,2},	{798,2},	{726,2},
  {763,2},	{872,2},	{761,2},	{685,2},
  {833,2},	{648,2},	{611,0},	{650,0},
  {834,0},	{610,0},	{612,0},	{869,0},
  {614,0},	{651,0},	{871,0},	{649,0},
  {758,0},	{795,0},	{613,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{647,0},
  {759,0},	{721,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {688,0},	{797,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0}
};

static struct patval joseki243[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{761,1},	{800,2},	{796,2},
  {723,2},	{722,2},	{801,2},	{762,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{869,0},
  {651,0},	{871,0},	{649,0},	{834,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki244[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{801,1},	{724,1},
  {764,1},	{722,1},	{760,1},	{796,1},
  {836,1},	{799,1},	{725,2},	{686,2},
  {870,2},	{763,2},	{872,2},	{758,2},
  {726,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{685,2},
  {651,0},	{869,0},	{649,0},	{834,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki245[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{797,1},	{687,1},	{686,1},
  {833,1},	{870,1},	{761,1},	{796,2},
  {723,2},	{800,2},	{722,2},	{762,2},
  {799,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{795,2},	{832,2},	{801,2},
  {764,2},	{651,0},	{869,0},	{834,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki246[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{801,1},	{724,1},
  {764,1},	{722,1},	{834,1},	{796,1},
  {836,1},	{760,1},	{799,1},	{686,2},
  {725,2},	{870,2},	{872,2},	{763,2},
  {726,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{758,2},
  {797,2},	{685,2},	{651,0},	{869,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki247[] = {
  {726,1},	{763,1},	{721,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{725,1},	{687,1},	{797,1},
  {833,1},	{870,1},	{761,1},	{686,1},
  {723,2},	{722,2},	{796,2},	{834,2},
  {799,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{795,2},	{832,2},	{800,2},
  {762,2},	{764,2},	{801,2},	{651,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{869,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki248[] = {
  {836,1},	{723,1},	{684,1},	{800,1},
  {762,1},	{795,1},	{832,1},	{801,1},
  {834,1},	{724,1},	{764,1},	{722,1},
  {759,1},	{796,1},	{760,1},	{799,1},
  {835,2},	{725,2},	{798,2},	{870,2},
  {686,2},	{872,2},	{687,2},	{726,2},
  {833,2},	{797,2},	{763,2},	{648,2},
  {761,2},	{685,2},	{650,0},	{869,0},
  {614,0},	{651,0},	{612,0},	{610,0},
  {758,0},	{871,0},	{613,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{647,0},
  {611,0},	{721,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {688,0},	{649,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0}
};

static struct patval joseki249[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{761,1},	{800,2},	{796,2},
  {723,2},	{722,2},	{801,2},	{762,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{869,0},
  {651,0},	{871,0},	{649,0},	{834,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki250[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{760,1},	{796,1},
  {836,1},	{801,1},	{725,2},	{686,2},
  {726,2},	{763,2},	{872,2},	{758,2},
  {685,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{870,2},	{835,2},	{798,2},
  {651,0},	{871,0},	{869,0},	{834,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki251[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{761,1},	{834,1},	{796,2},
  {723,2},	{722,2},	{797,2},	{800,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{762,2},
  {801,2},	{871,0},	{651,0},	{869,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki252[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{760,1},	{796,1},
  {836,1},	{801,1},	{799,1},	{686,2},
  {725,2},	{763,2},	{872,2},	{834,2},
  {726,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{870,2},	{835,2},	{758,2},
  {798,2},	{685,2},	{651,0},	{869,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki253[] = {
  {726,1},	{763,1},	{721,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{725,1},	{687,1},	{686,1},
  {833,1},	{870,1},	{834,1},	{761,1},
  {723,2},	{796,2},	{797,2},	{722,2},
  {799,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{795,2},	{832,2},	{800,2},
  {762,2},	{764,2},	{801,2},	{651,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{869,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki254[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{797,1},	{724,1},
  {764,1},	{722,1},	{759,1},	{796,1},
  {836,1},	{801,1},	{760,1},	{799,1},
  {686,2},	{725,2},	{872,2},	{834,2},
  {726,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{870,2},	{835,2},	{763,2},
  {798,2},	{685,2},	{651,0},	{869,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{758,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki255[] = {
  {726,1},	{763,1},	{721,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{725,1},	{687,1},	{686,1},
  {833,1},	{870,1},	{834,1},	{796,2},
  {723,2},	{760,2},	{797,2},	{722,2},
  {799,2},	{836,2},	{759,2},	{724,2},
  {762,2},	{795,2},	{832,2},	{800,2},
  {684,2},	{764,2},	{801,2},	{651,0},
  {871,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{758,0},	{869,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki256[] = {
  {726,1},	{763,1},	{725,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{834,1},	{722,2},	{796,2},
  {723,2},	{760,2},	{797,2},	{800,2},
  {799,2},	{836,2},	{759,2},	{724,2},
  {758,2},	{795,2},	{832,2},	{762,2},
  {801,2},	{764,2},	{684,2},	{651,0},
  {871,0},	{869,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{650,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki257[] = {
  {648,1},	{685,1},	{833,1},	{870,1},
  {796,2},	{758,2},	{795,2},	{832,2},
  {759,2},	{684,2},	{722,2},	{869,0},
  {721,0},	{611,0},	{573,0},	{610,0},
  {647,0},	{574,0}
};

static struct patval joseki258[] = {
  {759,1},	{796,1},	{833,1},	{684,1},
  {721,1},	{869,1},	{795,1},	{832,1},
  {685,2},	{907,2},	{870,2},	{722,2},
  {906,0},	{758,0},	{648,0},	{573,0},
  {610,0},	{647,0},	{574,0},	{611,0}
};

static struct patval joseki259[] = {
  {722,1},	{648,1},	{685,1},	{870,1},
  {907,1},	{833,2},	{759,2},	{832,2},
  {869,2},	{796,2},	{684,2},	{721,2},
  {795,2},	{758,0},	{906,0},	{573,0},
  {610,0},	{647,0},	{574,0},	{611,0}
};

static struct patval joseki260[] = {
  {796,1},	{833,1},	{684,1},	{721,1},
  {758,1},	{870,1},	{832,1},	{869,1},
  {906,1},	{722,2},	{907,2},	{944,2},
  {685,2},	{759,2},	{795,0},	{610,0},
  {647,0},	{943,0},	{611,0},	{648,0}
};

static struct patval joseki261[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{870,1},	{687,1},	{686,1},
  {833,1},	{761,1},	{800,2},	{796,2},
  {723,2},	{722,2},	{801,2},	{762,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{869,0},
  {651,0},	{871,0},	{649,0},	{834,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki262[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{873,1},	{724,1},
  {764,1},	{722,1},	{760,1},	{796,1},
  {836,1},	{801,1},	{725,2},	{686,2},
  {726,2},	{763,2},	{870,2},	{758,2},
  {685,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{872,2},
  {651,0},	{871,0},	{649,0},	{834,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{797,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki263[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{797,1},	{687,1},	{686,1},
  {833,1},	{870,1},	{761,1},	{796,2},
  {723,2},	{800,2},	{722,2},	{762,2},
  {764,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{873,2},
  {801,2},	{871,0},	{651,0},	{834,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki264[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{873,1},	{724,1},
  {764,1},	{722,1},	{834,1},	{796,1},
  {836,1},	{801,1},	{760,1},	{686,2},
  {726,2},	{725,2},	{870,2},	{763,2},
  {685,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{872,2},
  {758,2},	{797,2},	{871,0},	{651,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki265[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{797,1},	{687,1},	{871,1},
  {833,1},	{870,1},	{761,1},	{686,1},
  {723,2},	{800,2},	{722,2},	{762,2},
  {796,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{873,2},
  {801,2},	{764,2},	{651,0},	{834,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki266[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {799,1},	{832,1},	{873,1},	{724,1},
  {764,1},	{722,1},	{759,1},	{796,1},
  {836,1},	{801,1},	{760,1},	{686,2},
  {726,2},	{725,2},	{870,2},	{758,2},
  {871,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{872,2},
  {763,2},	{685,2},	{797,2},	{651,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{834,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki267[] = {
  {684,1},	{800,1},	{762,1},	{795,1},
  {835,1},	{872,1},	{909,1},	{685,1},
  {722,1},	{763,1},	{724,1},	{908,1},
  {870,1},	{907,1},	{834,1},	{723,1},
  {798,1},	{760,2},	{837,2},	{799,2},
  {833,2},	{759,2},	{796,2},	{761,2},
  {797,2},	{836,2},	{869,2},	{910,2},
  {873,2},	{801,2},	{838,2},	{721,2},
  {832,0},	{688,0},	{906,0},	{689,0},
  {726,0},	{687,0},	{871,0},	{758,0},
  {874,0},	{911,0},	{690,0},	{727,0},
  {764,0},	{725,0},	{686,0},	{875,0},
  {912,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0}
};

static struct patval joseki268[] = {
  {760,1},	{721,1},	{837,1},	{799,1},
  {832,1},	{869,1},	{910,1},	{761,1},
  {801,1},	{759,1},	{796,1},	{833,1},
  {873,1},	{838,1},	{797,1},	{836,1},
  {723,2},	{762,2},	{907,2},	{795,2},
  {908,2},	{763,2},	{724,2},	{685,2},
  {798,2},	{835,2},	{872,2},	{909,2},
  {870,2},	{722,2},	{834,2},	{800,2},
  {684,2},	{688,0},	{906,0},	{689,0},
  {726,0},	{687,0},	{871,0},	{758,0},
  {874,0},	{911,0},	{690,0},	{727,0},
  {764,0},	{725,0},	{686,0},	{875,0},
  {912,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0}
};

static struct patval joseki269[] = {
  {684,1},	{800,1},	{758,1},	{795,1},
  {835,1},	{872,1},	{909,1},	{685,1},
  {722,1},	{763,1},	{724,1},	{908,1},
  {870,1},	{907,1},	{762,1},	{723,1},
  {834,1},	{798,1},	{760,2},	{799,2},
  {833,2},	{759,2},	{796,2},	{761,2},
  {797,2},	{832,2},	{869,2},	{910,2},
  {873,2},	{801,2},	{838,2},	{837,2},
  {836,2},	{688,0},	{871,0},	{689,0},
  {726,0},	{687,0},	{721,0},	{906,0},
  {874,0},	{911,0},	{690,0},	{727,0},
  {764,0},	{725,0},	{686,0},	{875,0},
  {912,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0}
};

static struct patval joseki270[] = {
  {760,1},	{721,1},	{837,1},	{799,1},
  {832,1},	{869,1},	{910,1},	{761,1},
  {801,1},	{759,1},	{796,1},	{833,1},
  {873,1},	{838,1},	{797,1},	{836,1},
  {723,2},	{762,2},	{907,2},	{872,2},
  {908,2},	{763,2},	{724,2},	{685,2},
  {798,2},	{835,2},	{870,2},	{909,2},
  {684,2},	{722,2},	{834,2},	{800,2},
  {688,0},	{871,0},	{906,0},	{689,0},
  {726,0},	{687,0},	{795,0},	{758,0},
  {874,0},	{911,0},	{690,0},	{727,0},
  {764,0},	{725,0},	{686,0},	{875,0},
  {912,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0}
};

static struct patval joseki271[] = {
  {726,1},	{763,1},	{725,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{797,1},	{687,1},	{871,1},
  {833,1},	{870,1},	{761,1},	{686,1},
  {723,2},	{800,2},	{722,2},	{762,2},
  {796,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{799,2},	{832,2},	{873,2},
  {801,2},	{764,2},	{651,0},	{834,0},
  {795,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki272[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{873,1},	{724,1},
  {764,1},	{722,1},	{760,1},	{796,1},
  {836,1},	{801,1},	{799,1},	{686,2},
  {725,2},	{763,2},	{870,2},	{758,2},
  {871,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{835,2},	{872,2},
  {726,2},	{685,2},	{797,2},	{834,0},
  {651,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki273[] = {
  {726,1},	{763,1},	{721,1},	{758,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{725,1},	{687,1},	{871,1},
  {833,1},	{870,1},	{797,1},	{686,1},
  {761,1},	{723,2},	{722,2},	{762,2},
  {796,2},	{836,2},	{684,2},	{724,2},
  {760,2},	{795,2},	{832,2},	{873,2},
  {799,2},	{764,2},	{801,2},	{800,2},
  {651,0},	{650,0},	{834,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{869,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki274[] = {
  {723,1},	{684,1},	{800,1},	{762,1},
  {795,1},	{832,1},	{873,1},	{724,1},
  {764,1},	{722,1},	{759,1},	{796,1},
  {836,1},	{801,1},	{760,1},	{799,1},
  {686,2},	{725,2},	{870,2},	{835,2},
  {871,2},	{833,2},	{687,2},	{648,2},
  {761,2},	{798,2},	{763,2},	{872,2},
  {726,2},	{685,2},	{797,2},	{834,0},
  {651,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{758,0},	{721,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki275[] = {
  {726,1},	{763,1},	{721,1},	{761,1},
  {798,1},	{835,1},	{872,1},	{648,1},
  {685,1},	{725,1},	{687,1},	{871,1},
  {833,1},	{870,1},	{797,1},	{686,1},
  {723,2},	{760,2},	{722,2},	{832,2},
  {796,2},	{836,2},	{759,2},	{724,2},
  {762,2},	{795,2},	{684,2},	{873,2},
  {799,2},	{764,2},	{801,2},	{800,2},
  {651,0},	{650,0},	{834,0},	{652,0},
  {689,0},	{647,0},	{758,0},	{869,0},
  {837,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki276[] = {
  {835,1},	{872,1},	{870,1},	{648,1},
  {687,1},	{833,1},	{725,1},	{798,1},
  {685,1},	{797,1},	{686,1},	{761,1},
  {871,1},	{722,2},	{759,2},	{799,2},
  {758,2},	{684,2},	{832,2},	{760,2},
  {795,2},	{873,2},	{762,2},	{796,2},
  {836,2},	{724,2},	{723,2},	{576,0},
  {612,0},	{650,0},	{647,0},	{834,0},
  {613,0},	{575,0},	{573,0},	{610,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {649,0},	{721,0},	{869,0},	{574,0},
  {611,0}
};

static struct patval joseki277[] = {
  {833,1},	{873,1},	{684,1},	{721,1},
  {797,1},	{795,1},	{832,1},	{869,1},
  {836,1},	{759,1},	{910,1},	{761,1},
  {760,1},	{799,1},	{796,1},	{909,2},
  {724,2},	{907,2},	{835,2},	{722,2},
  {762,2},	{872,2},	{870,2},	{908,2},
  {834,2},	{685,2},	{798,2},	{723,2},
  {649,0},	{687,0},	{613,0},	{871,0},
  {650,0},	{612,0},	{610,0},	{647,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {686,0},	{758,0},	{906,0},	{611,0},
  {648,0}
};

static struct patval joseki278[] = {
  {685,1},	{723,1},	{907,1},	{722,1},
  {834,1},	{870,1},	{908,1},	{648,1},
  {684,2},	{797,2},	{721,2},	{796,2},
  {869,2},	{833,2},	{832,2},	{759,2},
  {760,2},	{795,2},	{758,0},	{611,0},
  {575,0},	{612,0},	{573,0},	{686,0},
  {610,0},	{647,0},	{906,0},	{574,0},
  {871,0},	{649,0}
};

static struct patval joseki279[] = {
  {796,1},	{833,1},	{684,1},	{721,1},
  {758,1},	{870,1},	{832,1},	{869,1},
  {906,1},	{722,2},	{907,2},	{944,2},
  {685,2},	{759,2},	{795,0},	{610,0},
  {647,0},	{943,0},	{611,0},	{648,0}
};

static struct patval joseki280[] = {
  {796,1},	{833,1},	{684,1},	{721,1},
  {758,1},	{870,1},	{832,1},	{869,1},
  {906,1},	{722,2},	{907,2},	{944,2},
  {685,2},	{759,2},	{795,0},	{610,0},
  {647,0},	{943,0},	{611,0},	{648,0}
};

static struct patval joseki281[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{685,1},
  {684,1},	{721,2},	{723,2},	{800,2},
  {761,2},	{798,2},	{799,2},	{763,2},
  {722,2},	{758,0},	{795,0},	{833,0},
  {870,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki282[] = {
  {722,1},	{763,1},	{799,1},	{761,1},
  {798,1},	{721,1},	{796,1},	{723,1},
  {800,1},	{834,2},	{684,2},	{686,2},
  {760,2},	{762,2},	{724,2},	{685,2},
  {725,2},	{797,2},	{795,0},	{833,0},
  {870,0},	{758,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki283[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{759,1},
  {684,1},	{685,1},	{723,2},	{721,2},
  {761,2},	{798,2},	{799,2},	{796,2},
  {722,2},	{800,2},	{763,2},	{833,0},
  {795,0},	{758,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki284[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{721,1},	{796,1},	{723,1},
  {763,1},	{800,1},	{762,2},	{686,2},
  {760,2},	{834,2},	{724,2},	{685,2},
  {725,2},	{759,2},	{797,2},	{684,2},
  {833,0},	{795,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki285[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{795,1},
  {684,1},	{685,1},	{759,1},	{721,2},
  {761,2},	{798,2},	{799,2},	{723,2},
  {722,2},	{758,2},	{796,2},	{800,2},
  {763,2},	{833,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki286[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{832,1},	{796,1},	{723,1},
  {763,1},	{721,1},	{800,1},	{795,2},
  {834,2},	{762,2},	{724,2},	{685,2},
  {725,2},	{759,2},	{686,2},	{760,2},
  {684,2},	{797,2},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{649,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{648,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki287[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{834,1},	{686,1},	{833,1},
  {684,1},	{795,1},	{759,1},	{685,1},
  {721,2},	{798,2},	{799,2},	{832,2},
  {722,2},	{758,2},	{800,2},	{723,2},
  {763,2},	{761,2},	{868,0},	{647,0},
  {649,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki288[] = {
  {612,1},	{648,1},	{689,1},	{651,1},
  {684,1},	{722,1},	{690,1},	{613,1},
  {653,1},	{611,1},	{688,1},	{652,2},
  {724,2},	{687,2},	{614,2},	{575,2},
  {615,2},	{649,2},	{576,2},	{723,2},
  {685,2},	{650,2},	{574,2},	{537,0},
  {539,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{538,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{686,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki289[] = {
  {615,1},	{652,1},	{614,1},	{650,1},
  {687,1},	{724,1},	{576,1},	{723,1},
  {574,1},	{686,1},	{649,1},	{685,1},
  {575,1},	{684,2},	{689,2},	{722,2},
  {612,2},	{648,2},	{611,2},	{613,2},
  {688,2},	{690,2},	{653,2},	{651,2},
  {537,0},	{759,0},	{721,0},	{761,0},
  {540,0},	{758,0},	{539,0},	{647,0},
  {760,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{538,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki290[] = {
  {759,1},	{649,1},	{725,1},	{726,1},
  {684,1},	{721,1},	{685,1},	{727,1},
  {688,1},	{650,1},	{690,1},	{648,1},
  {613,2},	{689,2},	{612,2},	{724,2},
  {760,2},	{651,2},	{761,2},	{652,2},
  {686,2},	{723,2},	{687,2},	{722,2},
  {611,2},	{576,0},	{539,0},	{574,0},
  {538,0},	{796,0},	{758,0},	{798,0},
  {540,0},	{577,0},	{537,0},	{795,0},
  {536,0},	{797,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {610,0},	{647,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {614,0},	{575,0},	{764,0},	{801,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki291[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{761,1},	{613,1},	{760,1},
  {611,1},	{723,1},	{686,1},	{722,1},
  {612,1},	{796,1},	{726,2},	{759,2},
  {649,2},	{685,2},	{648,2},	{650,2},
  {725,2},	{727,2},	{688,2},	{721,2},
  {684,2},	{690,2},	{574,0},	{798,0},
  {577,0},	{758,0},	{576,0},	{795,0},
  {797,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{575,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki292[] = {
  {759,1},	{649,1},	{725,1},	{726,1},
  {684,1},	{721,1},	{762,1},	{727,1},
  {685,1},	{650,1},	{690,1},	{648,1},
  {688,1},	{689,2},	{613,2},	{796,2},
  {761,2},	{651,2},	{612,2},	{652,2},
  {686,2},	{723,2},	{760,2},	{722,2},
  {687,2},	{724,2},	{611,2},	{574,0},
  {539,0},	{576,0},	{538,0},	{798,0},
  {540,0},	{577,0},	{537,0},	{795,0},
  {536,0},	{797,0},	{758,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {610,0},	{647,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {614,0},	{575,0},	{764,0},	{801,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki293[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{833,1},	{685,1},	{684,1},
  {722,2},	{799,2},	{762,2},	{721,2},
  {760,2},	{797,2},	{798,2},	{757,0},
  {794,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {831,0},	{868,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki294[] = {
  {721,1},	{758,1},	{798,1},	{760,1},
  {797,1},	{799,1},	{762,1},	{722,1},
  {685,2},	{833,2},	{761,2},	{724,2},
  {759,2},	{796,2},	{723,2},	{684,2},
  {794,0},	{757,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{867,0},	{646,0},
  {831,0},	{868,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki295[] = {
  {614,1},	{651,1},	{613,1},	{649,1},
  {686,1},	{723,1},	{575,1},	{684,1},
  {574,1},	{689,2},	{648,2},	{612,2},
  {650,2},	{687,2},	{688,2},	{652,2},
  {611,2},	{647,0},	{685,0},	{722,0},
  {759,0},	{538,0},	{757,0},	{536,0},
  {721,0},	{758,0},	{720,0},	{760,0},
  {539,0},	{576,0},	{537,0},	{646,0},
  {683,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0}
};

static struct patval joseki296[] = {
  {648,1},	{685,1},	{725,1},	{687,1},
  {724,1},	{684,1},	{726,1},	{649,1},
  {689,1},	{612,2},	{760,2},	{721,2},
  {686,2},	{723,2},	{650,2},	{611,2},
  {651,2},	{688,2},	{722,0},	{759,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{574,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki297[] = {
  {651,1},	{688,1},	{650,1},	{686,1},
  {723,1},	{760,1},	{612,1},	{758,1},
  {611,1},	{721,1},	{684,2},	{726,2},
  {649,2},	{724,2},	{725,2},	{689,2},
  {648,2},	{685,2},	{687,2},	{722,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {759,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{574,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki298[] = {
  {722,1},	{759,1},	{799,1},	{761,1},
  {798,1},	{763,1},	{758,1},	{723,1},
  {684,1},	{800,1},	{686,2},	{795,2},
  {834,2},	{797,2},	{724,2},	{685,2},
  {725,2},	{762,2},	{760,2},	{832,2},
  {796,0},	{649,0},	{868,0},	{647,0},
  {833,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{721,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki299[] = {
  {762,1},	{799,1},	{761,1},	{797,1},
  {834,1},	{871,1},	{723,1},	{684,1},
  {722,1},	{869,1},	{832,1},	{795,2},
  {837,2},	{835,2},	{836,2},	{721,2},
  {759,2},	{796,2},	{760,2},	{798,2},
  {800,2},	{686,0},	{905,0},	{833,0},
  {870,0},	{906,0},	{868,0},	{908,0},
  {687,0},	{907,0},	{685,0},	{794,0},
  {831,0},	{872,0},	{909,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{910,0},	{689,0},	{726,0},
  {763,0},	{724,0},	{758,0},	{874,0},
  {911,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki300[] = {
  {759,1},	{796,1},	{836,1},	{798,1},
  {835,1},	{800,1},	{907,1},	{760,1},
  {721,1},	{837,1},	{795,1},	{723,2},
  {871,2},	{834,2},	{761,2},	{722,2},
  {762,2},	{799,2},	{684,2},	{869,2},
  {832,2},	{797,2},	{686,0},	{833,0},
  {870,0},	{906,0},	{868,0},	{908,0},
  {687,0},	{905,0},	{685,0},	{794,0},
  {831,0},	{872,0},	{909,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{910,0},	{689,0},	{726,0},
  {763,0},	{724,0},	{758,0},	{874,0},
  {911,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki301[] = {
  {762,1},	{799,1},	{761,1},	{797,1},
  {834,1},	{871,1},	{908,1},	{684,1},
  {722,1},	{869,1},	{723,1},	{832,1},
  {837,2},	{835,2},	{836,2},	{721,2},
  {759,2},	{796,2},	{760,2},	{798,2},
  {907,2},	{800,2},	{795,2},	{833,0},
  {686,0},	{906,0},	{868,0},	{905,0},
  {687,0},	{870,0},	{685,0},	{794,0},
  {831,0},	{872,0},	{909,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{910,0},	{689,0},	{726,0},
  {763,0},	{724,0},	{758,0},	{874,0},
  {911,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki302[] = {
  {759,1},	{796,1},	{836,1},	{798,1},
  {835,1},	{800,1},	{906,1},	{760,1},
  {721,1},	{837,1},	{795,1},	{907,1},
  {871,2},	{908,2},	{761,2},	{722,2},
  {762,2},	{799,2},	{834,2},	{869,2},
  {832,2},	{797,2},	{723,2},	{684,2},
  {686,0},	{833,0},	{868,0},	{905,0},
  {687,0},	{870,0},	{685,0},	{794,0},
  {831,0},	{872,0},	{909,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{910,0},	{689,0},	{726,0},
  {763,0},	{724,0},	{758,0},	{874,0},
  {911,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki303[] = {
  {762,1},	{799,1},	{761,1},	{797,1},
  {834,1},	{871,1},	{908,1},	{684,1},
  {722,1},	{833,1},	{723,1},	{832,1},
  {869,1},	{906,2},	{836,2},	{721,2},
  {759,2},	{796,2},	{837,2},	{798,2},
  {907,2},	{835,2},	{795,2},	{760,2},
  {800,2},	{686,0},	{868,0},	{905,0},
  {687,0},	{870,0},	{685,0},	{794,0},
  {831,0},	{872,0},	{909,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{910,0},	{689,0},	{726,0},
  {763,0},	{724,0},	{758,0},	{874,0},
  {911,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki304[] = {
  {612,1},	{649,1},	{689,1},	{651,1},
  {684,1},	{653,1},	{759,1},	{613,1},
  {574,1},	{690,1},	{648,1},	{688,1},
  {760,1},	{724,2},	{614,2},	{575,2},
  {615,2},	{652,2},	{686,2},	{722,2},
  {761,2},	{687,2},	{576,2},	{537,2},
  {650,2},	{685,2},	{721,0},	{539,0},
  {540,0},	{723,0},	{538,0},	{647,0},
  {758,0},	{725,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{611,0},	{727,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki305[] = {
  {687,1},	{724,1},	{686,1},	{722,1},
  {759,1},	{796,1},	{648,1},	{685,2},
  {725,2},	{761,2},	{760,2},	{684,2},
  {723,2},	{720,0},	{610,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{793,0},	{833,0},
  {612,0},	{649,0},	{683,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki306[] = {
  {684,1},	{725,1},	{761,1},	{723,1},
  {760,1},	{797,1},	{685,1},	{648,2},
  {724,2},	{686,2},	{796,2},	{687,2},
  {722,2},	{759,2},	{610,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{683,0},	{719,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki307[] = {
  {687,1},	{724,1},	{686,1},	{722,1},
  {759,1},	{796,1},	{648,1},	{762,1},
  {725,2},	{685,2},	{797,2},	{684,2},
  {723,2},	{760,2},	{761,2},	{647,0},
  {757,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{610,0},	{719,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki308[] = {
  {684,1},	{799,1},	{761,1},	{723,1},
  {760,1},	{797,1},	{725,1},	{685,1},
  {648,2},	{762,2},	{724,2},	{687,2},
  {722,2},	{759,2},	{686,2},	{796,2},
  {757,0},	{647,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{721,0},	{833,0},
  {612,0},	{649,0},	{610,0},	{719,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki309[] = {
  {687,1},	{724,1},	{686,1},	{722,1},
  {759,1},	{763,1},	{648,1},	{796,1},
  {762,1},	{725,2},	{685,2},	{684,2},
  {797,2},	{760,2},	{761,2},	{723,2},
  {799,2},	{757,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {647,0},	{831,0},	{721,0},	{833,0},
  {612,0},	{649,0},	{610,0},	{719,0},
  {756,0},	{794,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{793,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki310[] = {
  {684,1},	{799,1},	{761,1},	{723,1},
  {760,1},	{797,1},	{800,1},	{685,1},
  {725,1},	{762,2},	{724,2},	{687,2},
  {763,2},	{759,2},	{686,2},	{722,2},
  {648,2},	{796,2},	{757,0},	{795,0},
  {832,0},	{611,0},	{758,0},	{609,0},
  {647,0},	{831,0},	{721,0},	{833,0},
  {612,0},	{649,0},	{610,0},	{719,0},
  {756,0},	{794,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{793,0},	{830,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki311[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{800,1},	{685,1},	{833,1},
  {684,1},	{799,1},	{722,2},	{721,2},
  {834,2},	{797,2},	{798,2},	{762,2},
  {760,2},	{836,2},	{837,2},	{794,0},
  {869,0},	{648,0},	{795,0},	{646,0},
  {832,0},	{868,0},	{758,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{831,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{830,0},	{867,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki312[] = {
  {648,1},	{684,1},	{725,1},	{687,1},
  {724,1},	{761,1},	{764,1},	{649,1},
  {689,1},	{763,1},	{726,2},	{651,2},
  {727,2},	{723,2},	{650,2},	{611,2},
  {688,2},	{760,2},	{612,2},	{686,2},
  {721,0},	{575,0},	{722,0},	{573,0},
  {796,0},	{795,0},	{685,0},	{797,0},
  {576,0},	{613,0},	{574,0},	{683,0},
  {720,0},	{758,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{759,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{757,0},	{794,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki313[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{686,1},	{834,1},
  {684,1},	{800,1},	{685,1},	{723,2},
  {835,2},	{798,2},	{799,2},	{722,2},
  {837,2},	{763,2},	{838,2},	{758,2},
  {761,2},	{795,0},	{796,0},	{647,0},
  {870,0},	{869,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{832,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki314[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{832,1},	{837,1},	{725,2},
  {800,2},	{797,2},	{724,2},	{685,2},
  {801,2},	{684,2},	{686,2},	{762,2},
  {760,2},	{834,2},	{796,0},	{647,0},
  {870,0},	{869,0},	{795,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{649,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki315[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{686,1},	{795,1},
  {684,1},	{800,1},	{834,1},	{685,1},
  {832,2},	{798,2},	{799,2},	{723,2},
  {722,2},	{763,2},	{838,2},	{837,2},
  {761,2},	{835,2},	{758,2},	{647,0},
  {870,0},	{869,0},	{796,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{649,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki316[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{796,1},	{837,1},	{832,1},
  {795,2},	{797,2},	{724,2},	{685,2},
  {725,2},	{684,2},	{800,2},	{762,2},
  {760,2},	{801,2},	{686,2},	{834,2},
  {870,0},	{869,0},	{647,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{649,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki317[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{686,1},	{795,1},
  {684,1},	{800,1},	{834,1},	{685,1},
  {759,1},	{798,2},	{799,2},	{723,2},
  {722,2},	{832,2},	{796,2},	{837,2},
  {763,2},	{835,2},	{838,2},	{758,2},
  {761,2},	{869,0},	{647,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{649,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki318[] = {
  {832,1},	{722,1},	{763,1},	{799,1},
  {761,1},	{798,1},	{835,1},	{838,1},
  {837,1},	{723,1},	{796,1},	{721,1},
  {758,1},	{762,2},	{685,2},	{797,2},
  {834,2},	{724,2},	{801,2},	{725,2},
  {759,2},	{795,2},	{686,2},	{684,2},
  {760,2},	{800,2},	{610,0},	{649,0},
  {609,0},	{869,0},	{611,0},	{871,0},
  {613,0},	{650,0},	{870,0},	{647,0},
  {757,0},	{794,0},	{612,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{646,0},
  {683,0},	{720,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {687,0},	{648,0},	{833,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0}
};

static struct patval joseki319[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{686,1},	{833,1},
  {684,1},	{800,1},	{834,1},	{795,1},
  {759,1},	{685,1},	{799,2},	{798,2},
  {722,2},	{832,2},	{721,2},	{723,2},
  {763,2},	{835,2},	{838,2},	{758,2},
  {761,2},	{837,2},	{647,0},	{869,0},
  {650,0},	{870,0},	{648,0},	{871,0},
  {794,0},	{649,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{796,0},	{757,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki320[] = {
  {612,1},	{648,1},	{689,1},	{651,1},
  {684,1},	{725,1},	{728,1},	{613,1},
  {653,1},	{611,1},	{727,1},	{688,1},
  {722,1},	{687,2},	{614,2},	{575,2},
  {615,2},	{649,2},	{690,2},	{652,2},
  {685,2},	{691,2},	{576,2},	{724,2},
  {650,2},	{574,2},	{723,2},	{537,0},
  {540,0},	{759,0},	{538,0},	{761,0},
  {760,0},	{539,0},	{762,0},	{541,0},
  {578,0},	{536,0},	{573,0},	{610,0},
  {726,0},	{763,0},	{542,0},	{579,0},
  {616,0},	{577,0},	{686,0},	{647,0},
  {764,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{721,0},	{758,0},	{765,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0}
};

static struct patval joseki321[] = {
  {689,1},	{726,1},	{684,1},	{724,1},
  {761,1},	{765,1},	{650,1},	{797,1},
  {648,1},	{764,1},	{798,1},	{759,1},
  {723,1},	{649,1},	{688,1},	{758,2},
  {686,2},	{796,2},	{685,2},	{687,2},
  {762,2},	{799,2},	{802,2},	{763,2},
  {725,2},	{727,2},	{722,2},	{801,2},
  {614,0},	{833,0},	{612,0},	{835,0},
  {834,0},	{613,0},	{836,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {800,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{651,0},	{760,0},	{721,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{795,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki322[] = {
  {796,1},	{686,1},	{762,1},	{763,1},
  {725,1},	{758,1},	{799,1},	{802,1},
  {801,1},	{687,1},	{727,1},	{685,1},
  {722,1},	{760,1},	{649,2},	{761,2},
  {798,2},	{688,2},	{765,2},	{689,2},
  {723,2},	{726,2},	{650,2},	{684,2},
  {724,2},	{797,2},	{648,2},	{764,2},
  {573,0},	{833,0},	{575,0},	{835,0},
  {577,0},	{614,0},	{574,0},	{611,0},
  {613,0},	{834,0},	{576,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{610,0},
  {647,0},	{759,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {651,0},	{612,0},	{721,0},	{838,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{795,0},	{832,0},	{839,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0}
};

static struct patval joseki323[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{686,1},	{834,1},
  {684,1},	{800,1},	{685,1},	{723,2},
  {835,2},	{798,2},	{799,2},	{722,2},
  {837,2},	{763,2},	{838,2},	{758,2},
  {761,2},	{795,0},	{796,0},	{647,0},
  {870,0},	{869,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{757,0},
  {794,0},	{832,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{833,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki324[] = {
  {722,1},	{758,1},	{799,1},	{761,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{837,1},	{833,1},	{725,2},
  {801,2},	{797,2},	{800,2},	{685,2},
  {762,2},	{684,2},	{686,2},	{834,2},
  {760,2},	{724,2},	{795,0},	{647,0},
  {870,0},	{869,0},	{796,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{649,0},
  {794,0},	{832,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{757,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki325[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{834,1},
  {684,1},	{800,1},	{686,1},	{685,1},
  {835,2},	{723,2},	{799,2},	{722,2},
  {833,2},	{763,2},	{798,2},	{838,2},
  {761,2},	{758,2},	{837,2},	{795,0},
  {870,0},	{796,0},	{647,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{649,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{757,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki326[] = {
  {722,1},	{758,1},	{799,1},	{836,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{837,1},	{833,1},	{761,1},
  {801,2},	{872,2},	{800,2},	{725,2},
  {762,2},	{684,2},	{797,2},	{686,2},
  {760,2},	{724,2},	{834,2},	{685,2},
  {795,0},	{796,0},	{870,0},	{871,0},
  {647,0},	{687,0},	{648,0},	{649,0},
  {794,0},	{832,0},	{869,0},	{650,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{651,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki327[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{796,1},
  {684,1},	{800,1},	{834,1},	{685,1},
  {686,1},	{835,2},	{799,2},	{723,2},
  {722,2},	{763,2},	{798,2},	{833,2},
  {836,2},	{758,2},	{838,2},	{837,2},
  {761,2},	{795,0},	{870,0},	{871,0},
  {647,0},	{687,0},	{648,0},	{649,0},
  {794,0},	{832,0},	{869,0},	{650,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{651,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki328[] = {
  {722,1},	{758,1},	{799,1},	{836,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{837,1},	{833,1},	{795,1},
  {761,1},	{872,2},	{800,2},	{801,2},
  {725,2},	{684,2},	{796,2},	{762,2},
  {797,2},	{724,2},	{686,2},	{834,2},
  {760,2},	{685,2},	{870,0},	{871,0},
  {647,0},	{687,0},	{648,0},	{649,0},
  {794,0},	{832,0},	{869,0},	{650,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{651,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki329[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{832,1},
  {684,1},	{800,1},	{834,1},	{796,1},
  {685,1},	{686,1},	{799,2},	{723,2},
  {722,2},	{763,2},	{795,2},	{833,2},
  {798,2},	{835,2},	{838,2},	{837,2},
  {836,2},	{761,2},	{758,2},	{870,0},
  {647,0},	{687,0},	{648,0},	{871,0},
  {794,0},	{649,0},	{869,0},	{650,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{721,0},	{651,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki330[] = {
  {575,1},	{611,1},	{652,1},	{689,1},
  {651,1},	{684,1},	{691,1},	{576,1},
  {616,1},	{690,1},	{686,1},	{648,1},
  {688,1},	{614,1},	{653,2},	{725,2},
  {578,2},	{537,2},	{649,2},	{615,2},
  {654,2},	{685,2},	{539,2},	{687,2},
  {613,2},	{650,2},	{577,2},	{538,2},
  {500,0},	{540,0},	{501,0},	{724,0},
  {723,0},	{502,0},	{722,0},	{503,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{574,0},	{504,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{647,0},	{721,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki331[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{800,1},	{685,1},	{833,1},
  {684,1},	{799,1},	{722,2},	{721,2},
  {834,2},	{797,2},	{798,2},	{762,2},
  {760,2},	{836,2},	{837,2},	{794,0},
  {869,0},	{648,0},	{795,0},	{646,0},
  {832,0},	{868,0},	{758,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{831,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{830,0},	{867,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki332[] = {
  {685,1},	{800,1},	{762,1},	{724,1},
  {761,1},	{798,1},	{801,1},	{686,1},
  {726,1},	{684,1},	{725,2},	{763,2},
  {764,2},	{760,2},	{687,2},	{648,2},
  {688,2},	{797,2},	{649,2},	{723,2},
  {833,0},	{612,0},	{758,0},	{610,0},
  {796,0},	{832,0},	{722,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{720,0},
  {757,0},	{795,0},	{835,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{794,0},	{831,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki333[] = {
  {688,1},	{725,1},	{687,1},	{723,1},
  {760,1},	{764,1},	{835,1},	{797,1},
  {648,1},	{763,1},	{649,1},	{684,2},
  {798,2},	{686,2},	{762,2},	{726,2},
  {685,2},	{800,2},	{761,2},	{724,2},
  {801,2},	{612,0},	{833,0},	{610,0},
  {796,0},	{758,0},	{722,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{720,0},
  {757,0},	{795,0},	{832,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{794,0},	{831,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki334[] = {
  {685,1},	{800,1},	{762,1},	{799,1},
  {761,1},	{798,1},	{801,1},	{686,1},
  {726,1},	{684,1},	{724,1},	{763,2},
  {764,2},	{835,2},	{687,2},	{725,2},
  {688,2},	{797,2},	{760,2},	{648,2},
  {723,2},	{649,2},	{612,0},	{610,0},
  {833,0},	{758,0},	{722,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{796,0},
  {757,0},	{795,0},	{832,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{794,0},	{831,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki335[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{834,1},
  {684,1},	{800,1},	{686,1},	{685,1},
  {835,2},	{723,2},	{799,2},	{721,2},
  {722,2},	{763,2},	{798,2},	{761,2},
  {836,2},	{837,2},	{838,2},	{647,0},
  {870,0},	{795,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki336[] = {
  {722,1},	{837,1},	{799,1},	{836,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{721,1},	{761,1},	{795,1},
  {801,2},	{872,2},	{724,2},	{762,2},
  {725,2},	{684,2},	{800,2},	{685,2},
  {797,2},	{834,2},	{686,2},	{760,2},
  {647,0},	{870,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki337[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{832,1},
  {684,1},	{800,1},	{834,1},	{685,1},
  {686,1},	{723,2},	{799,2},	{795,2},
  {722,2},	{763,2},	{721,2},	{761,2},
  {798,2},	{835,2},	{838,2},	{837,2},
  {836,2},	{870,0},	{647,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{649,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki338[] = {
  {575,1},	{690,1},	{652,1},	{689,1},
  {651,1},	{684,1},	{691,1},	{576,1},
  {616,1},	{574,1},	{614,1},	{648,1},
  {688,1},	{725,2},	{577,2},	{615,2},
  {578,2},	{537,2},	{653,2},	{538,2},
  {654,2},	{685,2},	{539,2},	{687,2},
  {613,2},	{650,2},	{500,0},	{724,0},
  {503,0},	{540,0},	{501,0},	{686,0},
  {723,0},	{502,0},	{722,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{611,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{647,0},	{721,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki339[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{654,1},	{725,1},	{685,1},
  {537,1},	{653,1},	{687,1},	{649,1},
  {538,1},	{539,1},	{652,2},	{576,2},
  {575,2},	{616,2},	{648,2},	{614,2},
  {684,2},	{688,2},	{691,2},	{574,2},
  {689,2},	{651,2},	{690,2},	{724,0},
  {503,0},	{540,0},	{500,0},	{686,0},
  {723,0},	{502,0},	{722,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{501,0},	{611,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{647,0},	{721,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki340[] = {
  {686,1},	{801,1},	{684,1},	{800,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{725,1},	{759,1},
  {799,1},	{763,1},	{688,2},	{726,2},
  {689,2},	{648,2},	{836,2},	{649,2},
  {765,2},	{796,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{764,2},
  {614,0},	{651,0},	{835,0},	{797,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {721,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{722,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki341[] = {
  {689,1},	{726,1},	{688,1},	{724,1},
  {761,1},	{765,1},	{836,1},	{798,1},
  {648,1},	{764,1},	{722,1},	{760,1},
  {796,1},	{650,1},	{649,1},	{687,2},
  {686,2},	{727,2},	{759,2},	{801,2},
  {795,2},	{799,2},	{802,2},	{763,2},
  {800,2},	{762,2},	{684,2},	{725,2},
  {685,2},	{651,0},	{614,0},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {721,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki342[] = {
  {686,1},	{801,1},	{684,1},	{721,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{799,1},	{759,1},
  {800,1},	{763,1},	{725,1},	{688,2},
  {689,2},	{726,2},	{836,2},	{722,2},
  {765,2},	{648,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{649,2},
  {796,2},	{764,2},	{651,0},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki343[] = {
  {689,1},	{726,1},	{688,1},	{724,1},
  {761,1},	{765,1},	{836,1},	{798,1},
  {648,1},	{764,1},	{722,1},	{760,1},
  {796,1},	{650,1},	{723,1},	{649,1},
  {686,2},	{687,2},	{759,2},	{801,2},
  {795,2},	{799,2},	{802,2},	{763,2},
  {721,2},	{762,2},	{684,2},	{725,2},
  {800,2},	{727,2},	{685,2},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{651,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki344[] = {
  {686,1},	{833,1},	{684,1},	{721,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{801,1},	{759,1},
  {800,1},	{763,1},	{799,1},	{725,1},
  {689,2},	{688,2},	{726,2},	{722,2},
  {765,2},	{723,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{836,2},
  {796,2},	{648,2},	{764,2},	{649,2},
  {834,0},	{613,0},	{835,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{651,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki345[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{834,1},
  {684,1},	{800,1},	{686,1},	{685,1},
  {835,2},	{723,2},	{799,2},	{721,2},
  {722,2},	{763,2},	{798,2},	{761,2},
  {836,2},	{837,2},	{838,2},	{647,0},
  {870,0},	{795,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki346[] = {
  {722,1},	{837,1},	{799,1},	{836,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{721,1},	{761,1},	{796,1},
  {801,2},	{872,2},	{724,2},	{762,2},
  {725,2},	{684,2},	{797,2},	{685,2},
  {760,2},	{800,2},	{686,2},	{834,2},
  {870,0},	{795,0},	{647,0},	{871,0},
  {650,0},	{687,0},	{649,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{648,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki347[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{834,1},
  {684,1},	{800,1},	{686,1},	{685,1},
  {835,2},	{723,2},	{799,2},	{721,2},
  {722,2},	{763,2},	{798,2},	{761,2},
  {836,2},	{837,2},	{838,2},	{647,0},
  {870,0},	{795,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki348[] = {
  {722,1},	{837,1},	{799,1},	{836,1},
  {798,1},	{835,1},	{838,1},	{723,1},
  {763,1},	{721,1},	{761,1},	{795,1},
  {801,2},	{872,2},	{724,2},	{762,2},
  {725,2},	{684,2},	{800,2},	{685,2},
  {797,2},	{834,2},	{686,2},	{760,2},
  {647,0},	{870,0},	{649,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{832,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki349[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{801,1},	{872,1},	{832,1},
  {684,1},	{800,1},	{834,1},	{685,1},
  {686,1},	{723,2},	{799,2},	{795,2},
  {722,2},	{763,2},	{721,2},	{761,2},
  {798,2},	{835,2},	{838,2},	{837,2},
  {836,2},	{870,0},	{647,0},	{871,0},
  {650,0},	{687,0},	{648,0},	{833,0},
  {794,0},	{649,0},	{869,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{759,0},	{796,0},	{758,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{831,0},	{868,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki350[] = {
  {575,1},	{690,1},	{652,1},	{689,1},
  {651,1},	{684,1},	{691,1},	{576,1},
  {616,1},	{574,1},	{614,1},	{648,1},
  {688,1},	{725,2},	{577,2},	{615,2},
  {578,2},	{537,2},	{653,2},	{538,2},
  {654,2},	{685,2},	{539,2},	{687,2},
  {613,2},	{650,2},	{500,0},	{724,0},
  {503,0},	{540,0},	{501,0},	{686,0},
  {723,0},	{502,0},	{722,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{649,0},	{611,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{647,0},	{721,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki351[] = {
  {578,1},	{615,1},	{577,1},	{613,1},
  {650,1},	{654,1},	{725,1},	{685,1},
  {537,1},	{653,1},	{687,1},	{649,1},
  {538,1},	{539,1},	{652,2},	{576,2},
  {575,2},	{616,2},	{648,2},	{614,2},
  {684,2},	{688,2},	{691,2},	{574,2},
  {689,2},	{651,2},	{690,2},	{724,0},
  {503,0},	{540,0},	{500,0},	{686,0},
  {723,0},	{502,0},	{722,0},	{504,0},
  {541,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{726,0},	{505,0},	{542,0},
  {579,0},	{612,0},	{501,0},	{611,0},
  {727,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{647,0},	{721,0},	{728,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0}
};

static struct patval joseki352[] = {
  {686,1},	{801,1},	{684,1},	{800,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{725,1},	{759,1},
  {799,1},	{763,1},	{688,2},	{726,2},
  {689,2},	{648,2},	{836,2},	{649,2},
  {765,2},	{796,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{764,2},
  {614,0},	{651,0},	{835,0},	{797,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {721,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{722,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki353[] = {
  {689,1},	{726,1},	{688,1},	{724,1},
  {761,1},	{765,1},	{836,1},	{798,1},
  {648,1},	{764,1},	{722,1},	{760,1},
  {796,1},	{650,1},	{649,1},	{687,2},
  {686,2},	{727,2},	{759,2},	{801,2},
  {795,2},	{799,2},	{802,2},	{763,2},
  {800,2},	{762,2},	{684,2},	{725,2},
  {685,2},	{651,0},	{614,0},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {721,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki354[] = {
  {686,1},	{801,1},	{684,1},	{721,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{799,1},	{759,1},
  {800,1},	{763,1},	{725,1},	{688,2},
  {689,2},	{726,2},	{836,2},	{722,2},
  {765,2},	{648,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{649,2},
  {796,2},	{764,2},	{651,0},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{723,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki355[] = {
  {689,1},	{726,1},	{688,1},	{724,1},
  {761,1},	{765,1},	{836,1},	{798,1},
  {648,1},	{764,1},	{722,1},	{760,1},
  {796,1},	{650,1},	{723,1},	{649,1},
  {686,2},	{687,2},	{759,2},	{801,2},
  {795,2},	{799,2},	{802,2},	{763,2},
  {721,2},	{762,2},	{684,2},	{725,2},
  {800,2},	{727,2},	{685,2},	{835,0},
  {834,0},	{613,0},	{833,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{651,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki356[] = {
  {686,1},	{833,1},	{684,1},	{721,1},
  {762,1},	{795,1},	{802,1},	{687,1},
  {727,1},	{685,1},	{801,1},	{759,1},
  {800,1},	{763,1},	{799,1},	{725,1},
  {689,2},	{688,2},	{726,2},	{722,2},
  {765,2},	{723,2},	{650,2},	{760,2},
  {724,2},	{761,2},	{798,2},	{836,2},
  {796,2},	{648,2},	{764,2},	{649,2},
  {834,0},	{613,0},	{835,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{611,0},
  {614,0},	{837,0},	{616,0},	{653,0},
  {690,0},	{651,0},	{612,0},	{797,0},
  {838,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{758,0},	{832,0},	{839,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0}
};

static struct patval joseki357[] = {
  {724,1},	{761,1},	{723,1},	{759,1},
  {796,1},	{800,1},	{685,1},	{833,1},
  {684,1},	{799,1},	{722,2},	{721,2},
  {834,2},	{797,2},	{798,2},	{762,2},
  {760,2},	{836,2},	{837,2},	{794,0},
  {869,0},	{648,0},	{795,0},	{646,0},
  {832,0},	{868,0},	{758,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{831,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{830,0},	{867,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki358[] = {
  {721,1},	{758,1},	{798,1},	{760,1},
  {797,1},	{834,1},	{837,1},	{722,1},
  {762,1},	{836,1},	{799,2},	{724,2},
  {800,2},	{796,2},	{723,2},	{684,2},
  {833,2},	{761,2},	{685,2},	{759,2},
  {794,0},	{648,0},	{795,0},	{646,0},
  {869,0},	{868,0},	{832,0},	{870,0},
  {649,0},	{686,0},	{647,0},	{756,0},
  {793,0},	{831,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{757,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{830,0},	{867,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki359[] = {
  {614,1},	{651,1},	{613,1},	{649,1},
  {686,1},	{690,1},	{575,1},	{684,1},
  {574,1},	{689,1},	{723,1},	{612,2},
  {724,2},	{687,2},	{688,2},	{652,2},
  {611,2},	{648,2},	{727,2},	{726,2},
  {650,2},	{538,0},	{685,0},	{536,0},
  {759,0},	{758,0},	{722,0},	{760,0},
  {539,0},	{576,0},	{537,0},	{646,0},
  {683,0},	{721,0},	{761,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{720,0},	{757,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0}
};

static struct patval joseki360[] = {
  {611,1},	{648,1},	{688,1},	{650,1},
  {687,1},	{724,1},	{727,1},	{612,1},
  {652,1},	{685,1},	{726,1},	{684,2},
  {690,2},	{686,2},	{613,2},	{574,2},
  {614,2},	{651,2},	{689,2},	{723,2},
  {649,2},	{575,2},	{538,0},	{536,0},
  {759,0},	{758,0},	{722,0},	{760,0},
  {539,0},	{576,0},	{537,0},	{646,0},
  {683,0},	{721,0},	{761,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{720,0},	{757,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0}
};

static struct patval joseki361[] = {
  {614,1},	{651,1},	{613,1},	{649,1},
  {686,1},	{690,1},	{575,1},	{722,1},
  {574,1},	{689,1},	{723,1},	{684,1},
  {724,2},	{687,2},	{688,2},	{652,2},
  {611,2},	{648,2},	{685,2},	{612,2},
  {650,2},	{726,2},	{727,2},	{536,0},
  {759,0},	{758,0},	{538,0},	{760,0},
  {539,0},	{576,0},	{537,0},	{646,0},
  {683,0},	{721,0},	{761,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{720,0},	{757,0},	{764,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0}
};

static struct patval joseki362[] = {
  {648,1},	{685,1},	{725,1},	{687,1},
  {724,1},	{761,1},	{764,1},	{649,1},
  {689,1},	{722,1},	{684,1},	{763,1},
  {721,2},	{723,2},	{650,2},	{611,2},
  {651,2},	{688,2},	{726,2},	{727,2},
  {686,2},	{760,2},	{612,2},	{759,2},
  {796,0},	{795,0},	{573,0},	{797,0},
  {576,0},	{613,0},	{574,0},	{575,0},
  {720,0},	{758,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{647,0},	{683,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{757,0},	{794,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki363[] = {
  {688,1},	{725,1},	{687,1},	{723,1},
  {760,1},	{764,1},	{649,1},	{796,1},
  {648,1},	{684,1},	{797,1},	{758,1},
  {763,1},	{798,2},	{762,2},	{726,2},
  {685,2},	{722,2},	{761,2},	{686,2},
  {724,2},	{759,2},	{801,2},	{721,2},
  {800,2},	{832,0},	{610,0},	{833,0},
  {613,0},	{650,0},	{612,0},	{834,0},
  {757,0},	{795,0},	{835,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{611,0},	{720,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{794,0},	{831,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki364[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{762,1},	{765,1},	{650,1},
  {690,1},	{723,1},	{685,1},	{688,1},
  {764,1},	{724,2},	{651,2},	{722,2},
  {652,2},	{689,2},	{648,2},	{728,2},
  {687,2},	{727,2},	{613,2},	{760,2},
  {612,2},	{761,2},	{796,0},	{797,0},
  {574,0},	{614,0},	{576,0},	{798,0},
  {721,0},	{759,0},	{799,0},	{577,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{611,0},	{575,0},	{578,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{758,0},	{795,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki365[] = {
  {649,1},	{686,1},	{721,1},	{684,1},
  {723,2},	{722,2},	{687,2},	{571,0},
  {792,0},	{755,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki366[] = {
  {758,1},	{687,1},	{723,1},	{722,1},
  {684,2},	{649,2},	{721,2},	{686,2},
  {571,0},	{792,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{755,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki367[] = {
  {576,1},	{613,1},	{684,1},	{611,1},
  {648,1},	{685,2},	{649,2},	{650,2},
  {614,2},	{719,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{498,0},
  {721,0},	{500,0},	{537,0},	{574,0},
  {608,0},	{572,0},	{682,0},	{722,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {645,0},	{686,0},	{723,0},	{502,0},
  {539,0},	{497,0},	{534,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki368[] = {
  {685,1},	{614,1},	{650,1},	{612,1},
  {649,1},	{576,2},	{648,2},	{684,2},
  {613,2},	{611,2},	{609,0},	{646,0},
  {719,0},	{720,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{498,0},
  {721,0},	{500,0},	{537,0},	{574,0},
  {683,0},	{572,0},	{682,0},	{722,0},
  {501,0},	{538,0},	{575,0},	{608,0},
  {645,0},	{686,0},	{723,0},	{502,0},
  {539,0},	{497,0},	{534,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki369[] = {
  {576,1},	{613,1},	{575,1},	{611,1},
  {648,1},	{684,1},	{649,2},	{685,2},
  {614,2},	{650,2},	{612,2},	{646,0},
  {609,0},	{719,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{498,0},
  {721,0},	{500,0},	{537,0},	{574,0},
  {683,0},	{720,0},	{682,0},	{722,0},
  {501,0},	{538,0},	{572,0},	{608,0},
  {645,0},	{686,0},	{723,0},	{502,0},
  {539,0},	{497,0},	{534,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki370[] = {
  {574,1},	{614,1},	{650,1},	{612,1},
  {649,1},	{685,1},	{648,2},	{576,2},
  {613,2},	{575,2},	{684,2},	{611,2},
  {646,0},	{719,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{609,0},
  {721,0},	{500,0},	{537,0},	{498,0},
  {683,0},	{720,0},	{682,0},	{722,0},
  {501,0},	{538,0},	{572,0},	{608,0},
  {645,0},	{686,0},	{723,0},	{502,0},
  {539,0},	{497,0},	{534,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki371[] = {
  {576,1},	{613,1},	{575,1},	{611,1},
  {648,1},	{684,1},	{537,1},	{685,2},
  {614,2},	{650,2},	{574,2},	{649,2},
  {612,2},	{646,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{609,0},
  {721,0},	{500,0},	{719,0},	{498,0},
  {683,0},	{720,0},	{682,0},	{722,0},
  {501,0},	{538,0},	{572,0},	{608,0},
  {645,0},	{686,0},	{723,0},	{502,0},
  {539,0},	{497,0},	{534,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki372[] = {
  {684,1},	{725,1},	{761,1},	{723,1},
  {760,1},	{796,1},	{685,1},	{648,2},
  {724,2},	{686,2},	{795,2},	{687,2},
  {722,2},	{759,2},	{610,0},	{647,0},
  {757,0},	{721,0},	{758,0},	{720,0},
  {832,0},	{611,0},	{830,0},	{609,0},
  {794,0},	{831,0},	{793,0},	{833,0},
  {612,0},	{649,0},	{683,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{646,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki373[] = {
  {651,1},	{688,1},	{650,1},	{686,1},
  {723,1},	{684,1},	{612,1},	{759,1},
  {689,2},	{725,2},	{760,2},	{648,2},
  {687,2},	{724,2},	{649,2},	{611,0},
  {721,0},	{685,0},	{722,0},	{574,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{647,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{726,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki374[] = {
  {685,1},	{726,1},	{762,1},	{724,1},
  {761,1},	{797,1},	{684,1},	{686,1},
  {725,2},	{649,2},	{721,2},	{688,2},
  {723,2},	{760,2},	{687,2},	{796,2},
  {758,0},	{722,0},	{759,0},	{648,0},
  {833,0},	{612,0},	{831,0},	{610,0},
  {795,0},	{832,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{720,0},
  {757,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{763,0},	{800,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki375[] = {
  {651,1},	{688,1},	{650,1},	{686,1},
  {723,1},	{684,1},	{612,1},	{759,1},
  {689,2},	{725,2},	{760,2},	{648,2},
  {687,2},	{724,2},	{649,2},	{611,0},
  {721,0},	{685,0},	{722,0},	{574,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{647,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{726,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki376[] = {
  {648,1},	{685,1},	{725,1},	{687,1},
  {724,1},	{760,1},	{689,1},	{649,1},
  {612,2},	{650,2},	{684,2},	{651,2},
  {686,2},	{723,2},	{759,2},	{688,2},
  {721,0},	{611,0},	{722,0},	{574,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{647,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{726,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki377[] = {
  {651,1},	{688,1},	{650,1},	{686,1},
  {723,1},	{684,1},	{612,1},	{759,1},
  {722,1},	{689,2},	{760,2},	{725,2},
  {687,2},	{724,2},	{649,2},	{685,2},
  {648,2},	{611,0},	{721,0},	{574,0},
  {796,0},	{575,0},	{794,0},	{573,0},
  {758,0},	{795,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{647,0},	{683,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{646,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{610,0},	{726,0},	{763,0},
  {800,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0}
};

static struct patval joseki378[] = {
  {685,1},	{722,1},	{762,1},	{724,1},
  {761,1},	{797,1},	{684,1},	{686,1},
  {726,1},	{649,2},	{721,2},	{759,2},
  {723,2},	{760,2},	{687,2},	{796,2},
  {688,2},	{725,2},	{758,0},	{648,0},
  {833,0},	{612,0},	{831,0},	{610,0},
  {795,0},	{832,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{611,0},	{720,0},
  {757,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{609,0},	{646,0},	{683,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{647,0},	{763,0},	{800,0},
  {837,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0}
};

static struct patval joseki379[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{758,1},	{686,1},	{833,1},
  {684,1},	{796,1},	{834,2},	{721,2},
  {761,2},	{798,2},	{799,2},	{763,2},
  {722,2},	{759,2},	{723,2},	{795,0},
  {685,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{800,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki380[] = {
  {722,1},	{759,1},	{799,1},	{761,1},
  {798,1},	{834,1},	{795,1},	{723,1},
  {763,1},	{721,1},	{758,2},	{686,2},
  {760,2},	{797,2},	{724,2},	{684,2},
  {725,2},	{762,2},	{796,2},	{833,2},
  {685,0},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{800,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki381[] = {
  {725,1},	{762,1},	{724,1},	{760,1},
  {797,1},	{758,1},	{686,1},	{833,1},
  {684,1},	{796,1},	{685,1},	{795,2},
  {761,2},	{798,2},	{799,2},	{834,2},
  {722,2},	{759,2},	{721,2},	{723,2},
  {763,2},	{649,0},	{868,0},	{647,0},
  {832,0},	{869,0},	{831,0},	{871,0},
  {650,0},	{870,0},	{648,0},	{757,0},
  {794,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{646,0},	{683,0},	{720,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{687,0},	{800,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki382[] = {
  {648,1},	{649,1},	{686,1},	{726,1},
  {684,1},	{725,1},	{761,1},	{722,1},
  {688,1},	{650,1},	{690,1},	{612,2},
  {613,2},	{723,2},	{687,2},	{724,2},
  {760,2},	{651,2},	{689,2},	{652,2},
  {611,2},	{536,0},	{538,0},	{795,0},
  {539,0},	{576,0},	{537,0},	{574,0},
  {759,0},	{796,0},	{758,0},	{798,0},
  {540,0},	{577,0},	{797,0},	{575,0},
  {685,0},	{721,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {610,0},	{647,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {614,0},	{727,0},	{764,0},	{801,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki383[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{759,1},	{613,1},	{760,1},
  {611,1},	{723,1},	{612,1},	{722,2},
  {761,2},	{725,2},	{726,2},	{688,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {690,2},	{684,2},	{795,0},	{574,0},
  {576,0},	{796,0},	{758,0},	{798,0},
  {577,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki384[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{758,1},	{722,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{761,1},
  {759,2},	{724,2},	{613,2},	{612,2},
  {652,2},	{689,2},	{723,2},	{760,2},
  {611,2},	{651,2},	{687,2},	{574,0},
  {795,0},	{796,0},	{576,0},	{798,0},
  {577,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{762,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki385[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{613,1},	{760,1},
  {611,1},	{723,1},	{612,1},	{759,1},
  {722,2},	{725,2},	{726,2},	{688,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {690,2},	{758,2},	{761,2},	{684,2},
  {574,0},	{796,0},	{795,0},	{798,0},
  {577,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki386[] = {
  {648,1},	{649,1},	{686,1},	{726,1},
  {684,1},	{725,1},	{758,1},	{798,1},
  {761,1},	{650,1},	{690,1},	{722,1},
  {688,1},	{612,2},	{759,2},	{724,2},
  {613,2},	{651,2},	{762,2},	{652,2},
  {689,2},	{723,2},	{760,2},	{611,2},
  {687,2},	{576,0},	{537,0},	{574,0},
  {536,0},	{796,0},	{538,0},	{795,0},
  {540,0},	{577,0},	{797,0},	{575,0},
  {685,0},	{721,0},	{539,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {610,0},	{647,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {614,0},	{727,0},	{764,0},	{801,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0}
};

static struct patval joseki387[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{799,1},	{760,1},
  {611,1},	{723,1},	{613,1},	{612,1},
  {759,1},	{725,2},	{726,2},	{722,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {690,2},	{758,2},	{688,2},	{798,2},
  {684,2},	{761,2},	{796,0},	{574,0},
  {577,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki388[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{758,1},	{798,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{722,1},
  {763,1},	{761,1},	{724,2},	{612,2},
  {652,2},	{689,2},	{723,2},	{760,2},
  {611,2},	{762,2},	{613,2},	{759,2},
  {687,2},	{799,2},	{651,2},	{796,0},
  {574,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki389[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{799,1},	{760,1},
  {611,1},	{723,1},	{613,1},	{797,1},
  {759,1},	{612,1},	{726,2},	{725,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {722,2},	{758,2},	{688,2},	{763,2},
  {684,2},	{690,2},	{761,0},	{798,0},
  {574,0},	{796,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki390[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{758,1},	{728,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{722,1},
  {763,1},	{799,2},	{651,2},	{612,2},
  {652,2},	{689,2},	{723,2},	{760,2},
  {797,2},	{762,2},	{613,2},	{724,2},
  {687,2},	{611,2},	{759,2},	{798,0},
  {761,0},	{796,0},	{575,0},	{685,0},
  {574,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{721,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki391[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {798,1},	{836,1},	{873,1},	{834,1},
  {685,1},	{797,1},	{763,1},	{871,1},
  {833,1},	{687,1},	{686,1},	{800,2},
  {723,2},	{760,2},	{722,2},	{724,2},
  {796,2},	{832,2},	{799,2},	{802,2},
  {758,2},	{764,2},	{762,2},	{837,2},
  {872,0},	{870,0},	{649,0},	{835,0},
  {648,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{795,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki392[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {799,1},	{832,1},	{800,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{802,1},	{725,2},	{686,2},
  {726,2},	{684,2},	{873,2},	{834,2},
  {871,2},	{836,2},	{687,2},	{797,2},
  {761,2},	{798,2},	{763,2},	{685,2},
  {833,2},	{872,0},	{649,0},	{835,0},
  {870,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{795,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki393[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {798,1},	{836,1},	{869,1},	{834,1},
  {685,1},	{797,1},	{763,1},	{871,1},
  {833,1},	{873,1},	{687,1},	{686,1},
  {723,2},	{721,2},	{722,2},	{724,2},
  {796,2},	{832,2},	{760,2},	{800,2},
  {758,2},	{799,2},	{762,2},	{802,2},
  {837,2},	{764,2},	{649,0},	{835,0},
  {872,0},	{650,0},	{870,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{795,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki394[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {798,1},	{836,1},	{873,1},	{834,1},
  {685,1},	{797,1},	{763,1},	{871,1},
  {833,1},	{687,1},	{686,1},	{721,2},
  {723,2},	{760,2},	{722,2},	{724,2},
  {796,2},	{832,2},	{870,2},	{800,2},
  {758,2},	{799,2},	{762,2},	{802,2},
  {837,2},	{764,2},	{649,0},	{835,0},
  {872,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{795,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki395[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {799,1},	{832,1},	{800,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{870,1},	{835,1},	{802,1},
  {686,2},	{684,2},	{873,2},	{834,2},
  {871,2},	{836,2},	{687,2},	{797,2},
  {761,2},	{726,2},	{725,2},	{798,2},
  {833,2},	{685,2},	{763,2},	{649,0},
  {872,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{795,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki396[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{799,1},	{760,1},
  {611,1},	{723,1},	{613,1},	{797,1},
  {759,1},	{612,1},	{726,2},	{725,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {722,2},	{758,2},	{688,2},	{763,2},
  {684,2},	{690,2},	{761,0},	{798,0},
  {574,0},	{796,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki397[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {800,1},	{758,1},	{722,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{725,1},
  {763,1},	{724,2},	{651,2},	{612,2},
  {799,2},	{689,2},	{723,2},	{760,2},
  {797,2},	{762,2},	{613,2},	{652,2},
  {687,2},	{611,2},	{759,2},	{798,0},
  {761,0},	{796,0},	{575,0},	{685,0},
  {574,0},	{576,0},	{795,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{721,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki398[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {798,1},	{836,1},	{873,1},	{834,1},
  {685,1},	{797,1},	{763,1},	{871,1},
  {833,1},	{687,1},	{686,1},	{800,2},
  {723,2},	{760,2},	{722,2},	{724,2},
  {796,2},	{832,2},	{874,2},	{799,2},
  {758,2},	{764,2},	{762,2},	{837,2},
  {872,0},	{870,0},	{649,0},	{835,0},
  {648,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {651,0},	{795,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki399[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {874,1},	{832,1},	{800,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{799,1},	{725,2},	{686,2},
  {798,2},	{684,2},	{873,2},	{834,2},
  {871,2},	{836,2},	{687,2},	{797,2},
  {761,2},	{726,2},	{763,2},	{685,2},
  {833,2},	{872,0},	{649,0},	{835,0},
  {870,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{795,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki400[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {765,1},	{836,1},	{873,1},	{834,1},
  {685,1},	{798,1},	{763,1},	{871,1},
  {833,1},	{687,1},	{797,1},	{686,1},
  {723,2},	{760,2},	{721,2},	{724,2},
  {796,2},	{832,2},	{874,2},	{800,2},
  {758,2},	{722,2},	{762,2},	{799,2},
  {837,2},	{764,2},	{649,0},	{835,0},
  {872,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{870,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {795,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki401[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {874,1},	{832,1},	{800,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{802,1},	{799,1},	{686,2},
  {725,2},	{684,2},	{873,2},	{834,2},
  {871,2},	{836,2},	{687,2},	{797,2},
  {761,2},	{765,2},	{763,2},	{726,2},
  {833,2},	{685,2},	{798,2},	{835,0},
  {872,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{649,0},	{759,0},	{648,0},
  {651,0},	{870,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {795,0},	{647,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki402[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {765,1},	{836,1},	{873,1},	{727,1},
  {685,1},	{798,1},	{763,1},	{871,1},
  {833,1},	{687,1},	{834,1},	{686,1},
  {797,1},	{760,2},	{723,2},	{721,2},
  {796,2},	{832,2},	{874,2},	{724,2},
  {758,2},	{722,2},	{762,2},	{800,2},
  {837,2},	{764,2},	{802,2},	{799,2},
  {835,0},	{650,0},	{869,0},	{652,0},
  {689,0},	{649,0},	{759,0},	{872,0},
  {651,0},	{870,0},	{653,0},	{690,0},
  {648,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {795,0},	{647,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki403[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {874,1},	{832,1},	{801,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{802,1},	{800,1},	{799,1},
  {686,2},	{684,2},	{873,2},	{834,2},
  {871,2},	{836,2},	{687,2},	{725,2},
  {761,2},	{765,2},	{763,2},	{727,2},
  {833,2},	{685,2},	{797,2},	{798,2},
  {726,2},	{835,0},	{869,0},	{652,0},
  {689,0},	{650,0},	{759,0},	{872,0},
  {651,0},	{870,0},	{653,0},	{690,0},
  {648,0},	{688,0},	{649,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {795,0},	{647,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki404[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{613,1},	{760,1},
  {611,1},	{723,1},	{612,1},	{759,1},
  {722,2},	{725,2},	{726,2},	{688,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {690,2},	{758,2},	{761,2},	{684,2},
  {574,0},	{796,0},	{795,0},	{798,0},
  {577,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {763,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki405[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{758,1},	{722,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{761,1},
  {763,1},	{724,2},	{613,2},	{612,2},
  {652,2},	{689,2},	{723,2},	{760,2},
  {611,2},	{762,2},	{651,2},	{759,2},
  {687,2},	{796,0},	{795,0},	{798,0},
  {574,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki406[] = {
  {652,1},	{689,1},	{651,1},	{687,1},
  {724,1},	{762,1},	{798,1},	{760,1},
  {611,1},	{723,1},	{613,1},	{612,1},
  {759,1},	{725,2},	{726,2},	{722,2},
  {649,2},	{686,2},	{648,2},	{650,2},
  {690,2},	{758,2},	{688,2},	{763,2},
  {684,2},	{796,0},	{761,0},	{795,0},
  {574,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki407[] = {
  {649,1},	{686,1},	{726,1},	{684,1},
  {725,1},	{758,1},	{796,1},	{650,1},
  {690,1},	{648,1},	{688,1},	{722,1},
  {763,1},	{798,2},	{651,2},	{612,2},
  {652,2},	{689,2},	{723,2},	{760,2},
  {611,2},	{762,2},	{613,2},	{759,2},
  {687,2},	{724,2},	{761,0},	{795,0},
  {574,0},	{797,0},	{575,0},	{685,0},
  {721,0},	{576,0},	{799,0},	{578,0},
  {615,0},	{573,0},	{610,0},	{647,0},
  {577,0},	{800,0},	{579,0},	{616,0},
  {653,0},	{614,0},	{727,0},	{764,0},
  {801,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0}
};

static struct patval joseki408[] = {
  {726,1},	{684,1},	{725,1},	{761,1},
  {798,1},	{836,1},	{872,1},	{834,1},
  {685,1},	{797,1},	{763,1},	{686,1},
  {833,1},	{687,1},	{800,2},	{796,2},
  {723,2},	{760,2},	{722,2},	{724,2},
  {764,2},	{832,2},	{870,2},	{837,2},
  {758,2},	{799,2},	{762,2},	{869,0},
  {648,0},	{871,0},	{649,0},	{835,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{721,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki409[] = {
  {723,1},	{760,1},	{721,1},	{758,1},
  {799,1},	{832,1},	{800,1},	{724,1},
  {764,1},	{722,1},	{762,1},	{796,1},
  {837,1},	{870,1},	{725,2},	{686,2},
  {726,2},	{684,2},	{872,2},	{834,2},
  {685,2},	{836,2},	{687,2},	{797,2},
  {761,2},	{798,2},	{763,2},	{833,2},
  {869,0},	{871,0},	{649,0},	{835,0},
  {795,0},	{650,0},	{873,0},	{652,0},
  {689,0},	{647,0},	{759,0},	{648,0},
  {651,0},	{874,0},	{653,0},	{690,0},
  {727,0},	{688,0},	{801,0},	{838,0},
  {875,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0}
};

static struct patval joseki410[] = {
  {686,1},	{649,1},	{684,1},	{721,1},
  {722,2},	{723,2},	{687,2},	{792,0},
  {682,0},	{719,0},	{755,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {681,0},	{756,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{718,0},
  {759,0},	{796,0},	{612,0},	{645,0},
  {607,0},	{644,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{608,0},	{724,0},
  {761,0},	{798,0}
};

static struct patval joseki411[] = {
  {762,1},	{798,1},	{684,1},	{797,1},
  {759,2},	{724,2},	{761,2},	{796,2},
  {867,0},	{794,0},	{757,0},	{868,0},
  {830,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{831,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{720,0},
  {682,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki412[] = {
  {761,1},	{724,1},	{759,1},	{796,1},
  {721,1},	{684,2},	{762,2},	{798,2},
  {797,2},	{794,0},	{757,0},	{868,0},
  {830,0},	{867,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{831,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{720,0},
  {682,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki413[] = {
  {685,1},	{798,1},	{762,1},	{797,1},
  {684,1},	{721,2},	{759,2},	{724,2},
  {761,2},	{796,2},	{794,0},	{868,0},
  {757,0},	{867,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{830,0},	{722,0},
  {756,0},	{831,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{720,0},
  {682,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki414[] = {
  {724,1},	{761,1},	{721,1},	{759,1},
  {796,1},	{797,2},	{684,2},	{798,2},
  {762,2},	{830,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{867,0},
  {646,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{720,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki415[] = {
  {762,1},	{798,1},	{684,1},	{797,1},
  {759,2},	{721,2},	{761,2},	{724,2},
  {796,2},	{794,0},	{757,0},	{868,0},
  {830,0},	{867,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{831,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{720,0},
  {682,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki416[] = {
  {721,1},	{649,1},	{686,1},	{684,1},
  {727,1},	{687,2},	{723,2},	{722,2},
  {792,0},	{719,0},	{756,0},	{607,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {645,0},	{793,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{755,0},
  {759,0},	{796,0},	{612,0},	{644,0},
  {681,0},	{718,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{682,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{608,0},	{764,0},	{801,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki417[] = {
  {690,1},	{649,1},	{686,1},	{684,1},
  {721,1},	{723,2},	{722,2},	{687,2},
  {607,0},	{719,0},	{756,0},	{608,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {645,0},	{793,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{755,0},
  {759,0},	{796,0},	{612,0},	{644,0},
  {681,0},	{718,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{682,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {792,0},	{727,0},	{764,0},	{801,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0}
};

static struct patval joseki418[] = {
  {650,1},	{687,1},	{723,1},	{722,1},
  {684,2},	{721,2},	{686,2},	{649,2},
  {792,0},	{755,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki419[] = {
  {649,1},	{686,1},	{684,1},	{723,2},
  {687,2},	{755,0},	{792,0},	{571,0},
  {718,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki420[] = {
  {721,1},	{687,1},	{723,1},	{684,2},
  {649,2},	{686,2},	{792,0},	{571,0},
  {755,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{718,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki421[] = {
  {649,1},	{686,1},	{722,1},	{684,1},
  {723,2},	{721,2},	{687,2},	{571,0},
  {792,0},	{755,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki422[] = {
  {759,1},	{687,1},	{723,1},	{721,1},
  {684,2},	{649,2},	{722,2},	{686,2},
  {571,0},	{792,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{645,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{755,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki423[] = {
  {722,1},	{649,1},	{686,1},	{685,1},
  {684,1},	{687,2},	{721,2},	{723,2},
  {759,2},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{647,0},
  {756,0},	{682,0},	{758,0},	{795,0},
  {648,0},	{719,0},	{792,0},	{645,0},
  {796,0},	{681,0},	{718,0},	{755,0},
  {760,0},	{797,0},	{650,0},	{644,0},
  {724,0},	{761,0},	{798,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki424[] = {
  {759,1},	{761,1},	{723,1},	{721,1},
  {687,1},	{686,2},	{684,2},	{649,2},
  {685,2},	{722,2},	{792,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {608,0},	{756,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{682,0},	{718,0},
  {755,0},	{796,0},	{612,0},	{607,0},
  {644,0},	{681,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{645,0},	{724,0},
  {719,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0}
};

static struct patval joseki425[] = {
  {613,1},	{650,1},	{649,1},	{686,1},
  {684,1},	{648,1},	{725,2},	{651,2},
  {687,2},	{723,2},	{685,2},	{756,0},
  {573,0},	{610,0},	{647,0},	{757,0},
  {721,0},	{758,0},	{574,0},	{611,0},
  {572,0},	{720,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{646,0},	{682,0},
  {719,0},	{760,0},	{576,0},	{571,0},
  {608,0},	{645,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{609,0},	{688,0},
  {683,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0}
};

static struct patval joseki426[] = {
  {723,1},	{725,1},	{687,1},	{651,1},
  {685,1},	{722,1},	{684,2},	{613,2},
  {649,2},	{686,2},	{650,2},	{648,2},
  {683,0},	{757,0},	{535,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {720,0},	{609,0},	{536,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{645,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{534,0},	{571,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{646,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki427[] = {
  {613,1},	{650,1},	{684,1},	{649,1},
  {686,1},	{648,1},	{614,1},	{687,2},
  {723,2},	{685,2},	{725,2},	{722,2},
  {651,2},	{757,0},	{683,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {720,0},	{609,0},	{536,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{645,0},
  {682,0},	{719,0},	{760,0},	{539,0},
  {576,0},	{534,0},	{571,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {535,0},	{572,0},	{688,0},	{646,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki428[] = {
  {650,1},	{687,1},	{723,1},	{684,2},
  {686,2},	{649,2},	{792,0},	{755,0},
  {718,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki429[] = {
  {687,1},	{651,1},	{684,1},	{613,2},
  {650,2},	{648,2},	{719,0},	{535,0},
  {682,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {645,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{534,0},	{571,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0}
};

static struct patval joseki430[] = {
  {650,1},	{687,1},	{684,1},	{685,1},
  {688,2},	{724,2},	{721,2},	{572,0},
  {719,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{722,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{571,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki431[] = {
  {722,1},	{688,1},	{724,1},	{721,1},
  {650,2},	{684,2},	{685,2},	{687,2},
  {572,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{571,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki432[] = {
  {650,1},	{687,1},	{684,1},	{685,1},
  {723,1},	{724,2},	{721,2},	{722,2},
  {688,2},	{572,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{646,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {719,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{571,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki433[] = {
  {760,1},	{688,1},	{724,1},	{721,1},
  {722,1},	{650,2},	{685,2},	{684,2},
  {687,2},	{723,2},	{572,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{683,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{646,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {719,0},	{756,0},	{797,0},	{576,0},
  {613,0},	{571,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki434[] = {
  {650,1},	{687,1},	{684,1},	{686,1},
  {723,1},	{685,1},	{721,2},	{688,2},
  {724,2},	{722,2},	{760,2},	{720,0},
  {572,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{683,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {757,0},	{646,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {719,0},	{756,0},	{797,0},	{576,0},
  {613,0},	{571,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {799,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0}
};

static struct patval joseki435[] = {
  {760,1},	{762,1},	{688,1},	{724,1},
  {721,1},	{722,1},	{723,2},	{686,2},
  {685,2},	{684,2},	{687,2},	{650,2},
  {534,0},	{720,0},	{535,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {572,0},	{793,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {757,0},	{646,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{719,0},	{756,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{571,0},
  {608,0},	{645,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {609,0},	{725,0},	{683,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki436[] = {
  {723,1},	{687,1},	{686,2},	{684,2},
  {681,0},	{607,0},	{570,0},	{571,0},
  {608,0},	{645,0},	{718,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki437[] = {
  {686,1},	{684,1},	{722,1},	{687,2},
  {723,2},	{607,0},	{681,0},	{645,0},
  {718,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{608,0},
  {759,0},	{796,0},	{612,0},	{649,0},
  {755,0},	{792,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{644,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki438[] = {
  {723,1},	{687,1},	{649,1},	{722,2},
  {686,2},	{684,2},	{681,0},	{645,0},
  {607,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{608,0},
  {759,0},	{796,0},	{612,0},	{718,0},
  {755,0},	{792,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{644,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki439[] = {
  {722,1},	{686,1},	{684,1},	{685,1},
  {723,2},	{687,2},	{649,2},	{571,0},
  {792,0},	{645,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki440[] = {
  {723,1},	{650,1},	{687,1},	{649,1},
  {722,2},	{686,2},	{685,2},	{684,2},
  {608,0},	{645,0},	{681,0},	{719,0},
  {570,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{756,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{718,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {607,0},	{644,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki441[] = {
  {649,1},	{687,1},	{723,1},	{650,1},
  {685,2},	{684,2},	{722,2},	{686,2},
  {755,0},	{792,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {719,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{682,0},	{718,0},
  {759,0},	{796,0},	{612,0},	{607,0},
  {644,0},	{681,0},	{760,0},	{797,0},
  {613,0},	{608,0},	{645,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0}
};

static struct patval joseki442[] = {
  {722,1},	{685,1},	{686,1},	{684,1},
  {724,1},	{650,2},	{723,2},	{649,2},
  {687,2},	{719,0},	{644,0},	{793,0},
  {609,0},	{646,0},	{645,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{683,0},	{607,0},
  {759,0},	{796,0},	{612,0},	{756,0},
  {792,0},	{608,0},	{760,0},	{797,0},
  {613,0},	{681,0},	{718,0},	{755,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki443[] = {
  {649,1},	{687,1},	{723,1},	{650,1},
  {725,1},	{684,2},	{722,2},	{686,2},
  {724,2},	{685,2},	{756,0},	{793,0},
  {792,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {719,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{609,0},	{718,0},
  {759,0},	{796,0},	{612,0},	{607,0},
  {644,0},	{681,0},	{760,0},	{797,0},
  {613,0},	{608,0},	{645,0},	{682,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0}
};

static struct patval joseki444[] = {
  {722,1},	{685,1},	{760,1},	{684,1},
  {724,1},	{686,1},	{649,2},	{650,2},
  {687,2},	{725,2},	{644,0},	{793,0},
  {609,0},	{646,0},	{719,0},	{608,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{683,0},	{607,0},
  {759,0},	{796,0},	{612,0},	{720,0},
  {792,0},	{723,0},	{645,0},	{797,0},
  {613,0},	{681,0},	{718,0},	{755,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{756,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki445[] = {
  {649,1},	{761,1},	{650,1},	{687,1},
  {725,1},	{722,2},	{685,2},	{724,2},
  {760,2},	{684,2},	{686,2},	{719,0},
  {644,0},	{793,0},	{572,0},	{792,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{609,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{723,0},
  {681,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki446[] = {
  {685,1},	{722,1},	{684,1},	{686,1},
  {687,2},	{723,2},	{649,2},	{681,0},
  {755,0},	{645,0},	{644,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{570,0},
  {607,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{792,0},	{571,0},	{608,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{718,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki447[] = {
  {723,1},	{649,1},	{687,1},	{724,1},
  {685,2},	{686,2},	{684,2},	{722,2},
  {608,0},	{645,0},	{570,0},	{719,0},
  {607,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{756,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{718,0},	{755,0},	{792,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{644,0},	{681,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki448[] = {
  {796,1},	{759,1},	{684,1},	{760,1},
  {758,1},	{723,2},	{797,2},	{719,0},
  {792,0},	{793,0},	{718,0},	{867,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{755,0},	{721,0},
  {756,0},	{795,0},	{832,0},	{869,0},
  {685,0},	{722,0},	{830,0},	{681,0},
  {833,0},	{870,0},	{686,0},	{829,0},
  {866,0},	{682,0},	{834,0},	{871,0}
};

static struct patval joseki449[] = {
  {613,1},	{687,1},	{684,1},	{574,2},
  {686,2},	{650,2},	{649,2},	{648,2},
  {609,0},	{683,0},	{608,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{645,0},	{611,0},
  {646,0},	{685,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{720,0},	{571,0},
  {723,0},	{760,0},	{576,0},	{719,0},
  {756,0},	{572,0},	{724,0},	{761,0}
};

static struct patval joseki450[] = {
  {724,1},	{687,1},	{612,1},	{684,1},
  {686,1},	{688,1},	{725,2},	{651,2},
  {722,2},	{721,0},	{646,0},	{647,0},
  {611,0},	{648,0},	{685,0},	{720,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {761,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki451[] = {
  {651,1},	{760,1},	{725,1},	{722,1},
  {724,2},	{688,2},	{612,2},	{686,2},
  {684,2},	{687,2},	{721,0},	{647,0},
  {611,0},	{648,0},	{685,0},	{720,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{646,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {761,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki452[] = {
  {724,1},	{761,1},	{612,1},	{687,1},
  {686,1},	{688,1},	{684,1},	{651,2},
  {725,2},	{760,2},	{722,2},	{647,0},
  {611,0},	{721,0},	{685,0},	{720,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{648,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {646,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki453[] = {
  {651,1},	{760,1},	{685,1},	{722,1},
  {725,1},	{688,2},	{724,2},	{612,2},
  {684,2},	{761,2},	{687,2},	{686,2},
  {611,0},	{721,0},	{647,0},	{720,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{648,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {646,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki454[] = {
  {724,1},	{761,1},	{612,1},	{687,1},
  {686,1},	{688,1},	{648,1},	{684,1},
  {685,2},	{725,2},	{722,2},	{651,2},
  {760,2},	{721,0},	{647,0},	{611,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{720,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {646,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki455[] = {
  {721,1},	{760,1},	{685,1},	{722,1},
  {651,1},	{725,1},	{688,2},	{612,2},
  {684,2},	{724,2},	{687,2},	{686,2},
  {761,2},	{648,2},	{647,0},	{611,0},
  {759,0},	{796,0},	{683,0},	{649,0},
  {795,0},	{723,0},	{720,0},	{797,0},
  {613,0},	{650,0},	{758,0},	{609,0},
  {646,0},	{798,0},	{614,0},	{757,0},
  {794,0},	{610,0},	{762,0},	{799,0}
};

static struct patval joseki456[] = {
  {722,1},	{686,1},	{684,1},	{685,1},
  {723,2},	{687,2},	{649,2},	{571,0},
  {792,0},	{645,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki457[] = {
  {723,1},	{760,1},	{649,1},	{687,1},
  {686,2},	{684,2},	{722,2},	{685,2},
  {681,0},	{607,0},	{755,0},	{645,0},
  {644,0},	{719,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {533,0},	{570,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{792,0},
  {534,0},	{571,0},	{608,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {718,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki458[] = {
  {685,1},	{722,1},	{684,1},	{650,1},
  {686,1},	{760,2},	{649,2},	{687,2},
  {723,2},	{755,0},	{644,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{570,0},
  {607,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{792,0},	{571,0},	{608,0},
  {645,0},	{797,0},	{576,0},	{613,0},
  {681,0},	{718,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki459[] = {
  {688,1},	{760,1},	{723,1},	{649,1},
  {687,1},	{685,2},	{650,2},	{686,2},
  {684,2},	{722,2},	{644,0},	{755,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{570,0},
  {607,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{792,0},	{571,0},	{608,0},
  {645,0},	{797,0},	{576,0},	{613,0},
  {681,0},	{718,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {719,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0}
};

static struct patval joseki460[] = {
  {685,1},	{722,1},	{684,1},	{686,1},
  {650,1},	{612,1},	{687,2},	{723,2},
  {649,2},	{688,2},	{760,2},	{645,0},
  {644,0},	{607,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {533,0},	{570,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{755,0},	{792,0},
  {534,0},	{571,0},	{608,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{681,0},
  {718,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {719,0},	{725,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki461[] = {
  {760,1},	{649,1},	{687,1},	{723,1},
  {651,1},	{688,1},	{612,2},	{722,2},
  {685,2},	{650,2},	{686,2},	{684,2},
  {534,0},	{792,0},	{755,0},	{793,0},
  {535,0},	{645,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {572,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{533,0},	{570,0},
  {607,0},	{644,0},	{756,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{571,0},
  {608,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{681,0},
  {718,0},	{725,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0}
};

static struct patval joseki462[] = {
  {650,1},	{686,1},	{613,1},	{685,1},
  {722,1},	{684,1},	{612,1},	{649,2},
  {723,2},	{760,2},	{651,2},	{688,2},
  {687,2},	{793,0},	{572,0},	{645,0},
  {646,0},	{755,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {683,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{759,0},	{796,0},	{575,0},
  {609,0},	{570,0},	{607,0},	{644,0},
  {756,0},	{797,0},	{576,0},	{792,0},
  {571,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{681,0},
  {718,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki463[] = {
  {759,1},	{687,1},	{688,1},	{649,1},
  {760,1},	{723,1},	{651,1},	{612,2},
  {613,2},	{686,2},	{685,2},	{722,2},
  {650,2},	{684,2},	{683,0},	{719,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {720,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{756,0},	{793,0},
  {609,0},	{796,0},	{681,0},	{718,0},
  {755,0},	{792,0},	{646,0},	{797,0},
  {682,0},	{607,0},	{644,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{608,0},
  {645,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki464[] = {
  {650,1},	{758,1},	{612,1},	{613,1},
  {686,1},	{685,1},	{722,1},	{684,1},
  {649,2},	{760,2},	{723,2},	{688,2},
  {759,2},	{651,2},	{687,2},	{683,0},
  {719,0},	{794,0},	{610,0},	{647,0},
  {757,0},	{721,0},	{720,0},	{795,0},
  {611,0},	{648,0},	{756,0},	{793,0},
  {609,0},	{796,0},	{681,0},	{718,0},
  {755,0},	{792,0},	{646,0},	{797,0},
  {682,0},	{607,0},	{644,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{608,0},
  {645,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki465[] = {
  {577,1},	{614,1},	{648,1},	{576,1},
  {722,1},	{650,1},	{649,1},	{686,1},
  {685,1},	{652,2},	{651,2},	{615,2},
  {613,2},	{724,2},	{723,2},	{687,2},
  {684,2},	{647,0},	{610,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {646,0},	{683,0},	{573,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{720,0},
  {757,0},	{536,0},	{760,0},	{539,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {535,0},	{761,0},	{540,0},	{534,0},
  {571,0},	{608,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{572,0},
  {609,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki466[] = {
  {723,1},	{687,1},	{684,2},	{686,2},
  {570,0},	{755,0},	{792,0},	{571,0},
  {718,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki467[] = {
  {724,1},	{686,1},	{684,1},	{723,2},
  {687,2},	{755,0},	{792,0},	{571,0},
  {718,0},	{570,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki468[] = {
  {685,1},	{687,1},	{723,1},	{724,2},
  {686,2},	{684,2},	{792,0},	{571,0},
  {718,0},	{570,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki469[] = {
  {649,1},	{686,1},	{724,1},	{684,1},
  {723,2},	{685,2},	{687,2},	{571,0},
  {792,0},	{718,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {722,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki470[] = {
  {722,1},	{687,1},	{723,1},	{685,1},
  {649,2},	{684,2},	{724,2},	{686,2},
  {571,0},	{792,0},	{682,0},	{719,0},
  {755,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki471[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {724,1},	{723,2},	{722,2},	{685,2},
  {687,2},	{792,0},	{682,0},	{719,0},
  {571,0},	{793,0},	{755,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki472[] = {
  {725,1},	{687,1},	{723,1},	{685,1},
  {722,1},	{649,2},	{724,2},	{648,2},
  {686,2},	{684,2},	{682,0},	{719,0},
  {792,0},	{793,0},	{571,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki473[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {724,1},	{761,1},	{725,2},	{723,2},
  {687,2},	{722,2},	{685,2},	{719,0},
  {792,0},	{793,0},	{571,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{762,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki474[] = {
  {725,1},	{687,1},	{723,1},	{685,1},
  {722,1},	{762,1},	{649,2},	{648,2},
  {686,2},	{724,2},	{761,2},	{684,2},
  {719,0},	{793,0},	{571,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki475[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {724,1},	{761,1},	{650,1},	{762,2},
  {687,2},	{722,2},	{725,2},	{723,2},
  {685,2},	{793,0},	{719,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki476[] = {
  {725,1},	{687,1},	{723,1},	{685,1},
  {688,1},	{722,1},	{762,1},	{649,2},
  {686,2},	{724,2},	{761,2},	{650,2},
  {684,2},	{648,2},	{793,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {719,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {718,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki477[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {721,1},	{761,1},	{724,1},	{650,1},
  {687,2},	{762,2},	{725,2},	{722,2},
  {685,2},	{688,2},	{723,2},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{793,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{681,0},
  {719,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {718,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki478[] = {
  {725,1},	{685,1},	{723,1},	{760,1},
  {688,1},	{687,1},	{762,1},	{722,1},
  {649,2},	{724,2},	{686,2},	{650,2},
  {684,2},	{721,2},	{648,2},	{761,2},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{793,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{609,0},
  {719,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {681,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {718,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki479[] = {
  {649,1},	{686,1},	{648,1},	{684,1},
  {721,1},	{759,1},	{761,1},	{650,1},
  {724,1},	{687,2},	{762,2},	{722,2},
  {725,2},	{688,2},	{723,2},	{685,2},
  {760,2},	{646,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {683,0},	{793,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{609,0},
  {719,0},	{756,0},	{796,0},	{575,0},
  {612,0},	{570,0},	{607,0},	{644,0},
  {681,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {718,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki480[] = {
  {798,1},	{685,1},	{723,1},	{760,1},
  {688,1},	{725,1},	{762,1},	{722,1},
  {687,1},	{649,2},	{686,2},	{650,2},
  {759,2},	{721,2},	{648,2},	{684,2},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {609,0},	{793,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{572,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{575,0},
  {612,0},	{645,0},	{607,0},	{644,0},
  {681,0},	{797,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{724,0},	{761,0},
  {570,0},	{577,0},	{614,0},	{651,0},
  {718,0},	{755,0},	{792,0},	{799,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki481[] = {
  {722,1},	{723,1},	{684,2},	{686,2},
  {755,0},	{792,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{718,0},
  {759,0},	{796,0},	{612,0},	{649,0},
  {607,0},	{644,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0}
};

static struct patval joseki482[] = {
  {723,1},	{758,1},	{686,2},	{684,2},
  {681,0},	{607,0},	{608,0},	{645,0},
  {718,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{644,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{612,0},	{649,0},
  {755,0},	{792,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki483[] = {
  {759,1},	{758,1},	{723,1},	{684,2},
  {686,2},	{722,2},	{681,0},	{645,0},
  {718,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{644,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{608,0},
  {607,0},	{796,0},	{612,0},	{649,0},
  {755,0},	{792,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki484[] = {
  {759,1},	{758,1},	{760,1},	{723,1},
  {686,2},	{684,2},	{724,2},	{722,2},
  {718,0},	{719,0},	{756,0},	{645,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{644,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{793,0},
  {607,0},	{796,0},	{612,0},	{649,0},
  {755,0},	{792,0},	{608,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{681,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki485[] = {
  {687,1},	{684,1},	{650,2},	{648,2},
  {645,0},	{571,0},	{572,0},	{609,0},
  {608,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{574,0},	{611,0},
  {646,0},	{685,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {719,0},	{756,0},	{724,0},	{761,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki486[] = {
  {723,1},	{684,2},	{607,0},	{644,0},
  {681,0},	{718,0},	{755,0},	{792,0},
  {570,0},	{571,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {533,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{534,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki487[] = {
  {759,1},	{684,1},	{798,2},	{756,0},
  {793,0},	{719,0},	{645,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki488[] = {
  {833,1},	{798,1},	{759,2},	{684,2},
  {682,0},	{867,0},	{793,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {683,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{796,0},	{830,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki489[] = {
  {684,1},	{759,1},	{795,1},	{798,2},
  {833,2},	{719,0},	{867,0},	{682,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{646,0},
  {721,0},	{758,0},	{756,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {793,0},	{796,0},	{645,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{830,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0},
  {877,0}
};

static struct patval joseki490[] = {
  {759,1},	{684,1},	{795,1},	{801,2},
  {798,2},	{833,2},	{534,0},	{645,0},
  {793,0},	{830,0},	{867,0},	{498,0},
  {497,0},	{572,0},	{756,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{719,0},
  {721,0},	{758,0},	{571,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {608,0},	{796,0},	{682,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{609,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {535,0},	{838,0},	{875,0},	{506,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki491[] = {
  {758,1},	{869,1},	{833,1},	{907,2},
  {684,2},	{875,2},	{872,2},	{793,0},
  {904,0},	{719,0},	{608,0},	{646,0},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {610,0},	{647,0},	{867,0},	{721,0},
  {941,0},	{795,0},	{832,0},	{645,0},
  {906,0},	{943,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {682,0},	{870,0},	{756,0},	{944,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{683,0},	{909,0},	{946,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{911,0},	{948,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{609,0},
  {912,0},	{949,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0},	{950,0}
};

static struct patval joseki492[] = {
  {537,1},	{612,1},	{684,1},	{648,1},
  {651,2},	{463,2},	{686,2},	{685,2},
  {461,0},	{609,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {498,0},	{721,0},	{426,0},	{683,0},
  {500,0},	{424,0},	{574,0},	{611,0},
  {720,0},	{425,0},	{722,0},	{427,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {572,0},	{649,0},	{646,0},	{723,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{429,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{535,0},
  {688,0},	{725,0},	{430,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0}
};

static struct patval joseki493[] = {
  {611,1},	{721,1},	{758,1},	{722,1},
  {686,1},	{759,2},	{725,2},	{684,2},
  {760,2},	{537,2},	{536,0},	{683,0},
  {610,0},	{647,0},	{572,0},	{535,0},
  {573,0},	{795,0},	{500,0},	{757,0},
  {574,0},	{498,0},	{648,0},	{685,0},
  {794,0},	{499,0},	{796,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {646,0},	{723,0},	{720,0},	{797,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{609,0},
  {762,0},	{799,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0}
};

static struct patval joseki494[] = {
  {684,1},	{765,1},	{759,1},	{795,1},
  {798,2},	{833,2},	{719,0},	{682,0},
  {683,0},	{867,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{756,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {793,0},	{796,0},	{645,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{830,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{654,0},
  {691,0},	{728,0},	{646,0},	{802,0},
  {839,0},	{876,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0},
  {877,0}
};

static struct patval joseki495[] = {
  {759,1},	{684,1},	{795,1},	{833,2},
  {798,2},	{803,2},	{645,0},	{646,0},
  {793,0},	{720,0},	{682,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{796,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{757,0},	{840,0},
  {877,0},	{656,0},	{693,0},	{730,0},
  {767,0},	{804,0},	{841,0},	{878,0}
};

static struct patval joseki496[] = {
  {759,1},	{684,1},	{795,1},	{763,2},
  {833,2},	{798,2},	{608,0},	{756,0},
  {571,0},	{830,0},	{867,0},	{498,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {497,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{534,0},
  {721,0},	{758,0},	{645,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {719,0},	{796,0},	{683,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {793,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki497[] = {
  {796,1},	{798,1},	{684,2},	{759,2},
  {645,0},	{830,0},	{682,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{867,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki498[] = {
  {759,1},	{684,1},	{795,1},	{796,2},
  {798,2},	{830,0},	{682,0},	{646,0},
  {645,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki499[] = {
  {796,1},	{832,1},	{798,1},	{759,2},
  {795,2},	{684,2},	{756,0},	{646,0},
  {719,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{645,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki500[] = {
  {758,1},	{795,1},	{759,1},	{684,1},
  {796,2},	{832,2},	{798,2},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {683,0},	{721,0},	{682,0},	{830,0},
  {867,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki501[] = {
  {648,1},	{537,1},	{684,1},	{611,1},
  {612,1},	{687,2},	{685,2},	{649,2},
  {651,2},	{573,0},	{610,0},	{499,0},
  {572,0},	{721,0},	{500,0},	{535,0},
  {574,0},	{609,0},	{646,0},	{536,0},
  {722,0},	{501,0},	{538,0},	{575,0},
  {683,0},	{647,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{498,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{720,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki502[] = {
  {574,1},	{685,1},	{649,1},	{684,1},
  {688,2},	{722,2},	{686,2},	{572,0},
  {647,0},	{610,0},	{721,0},	{758,0},
  {573,0},	{611,0},	{648,0},	{720,0},
  {757,0},	{759,0},	{575,0},	{612,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki503[] = {
  {574,1},	{685,1},	{649,1},	{684,1},
  {721,1},	{722,2},	{688,2},	{724,2},
  {686,2},	{647,0},	{572,0},	{758,0},
  {573,0},	{611,0},	{648,0},	{610,0},
  {757,0},	{759,0},	{575,0},	{612,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki504[] = {
  {685,1},	{612,1},	{649,1},	{684,1},
  {574,1},	{721,1},	{650,2},	{688,2},
  {722,2},	{686,2},	{724,2},	{758,0},
  {572,0},	{611,0},	{648,0},	{610,0},
  {647,0},	{759,0},	{575,0},	{757,0},
  {573,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{646,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki505[] = {
  {574,1},	{685,1},	{649,1},	{759,1},
  {721,1},	{684,1},	{650,2},	{688,2},
  {686,2},	{722,2},	{724,2},	{647,0},
  {572,0},	{611,0},	{648,0},	{610,0},
  {757,0},	{758,0},	{575,0},	{612,0},
  {573,0},	{683,0},	{723,0},	{760,0},
  {576,0},	{613,0},	{646,0},	{687,0},
  {720,0},	{761,0},	{577,0},	{614,0},
  {651,0},	{609,0},	{725,0},	{762,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki506[] = {
  {796,1},	{798,1},	{832,1},	{795,2},
  {759,2},	{684,2},	{683,0},	{719,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {756,0},	{721,0},	{758,0},	{793,0},
  {720,0},	{869,0},	{685,0},	{722,0},
  {830,0},	{682,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{867,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki507[] = {
  {684,1},	{795,1},	{759,1},	{797,1},
  {796,2},	{832,2},	{798,2},	{682,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {683,0},	{721,0},	{758,0},	{830,0},
  {867,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{720,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki508[] = {
  {796,1},	{833,1},	{798,1},	{832,1},
  {795,2},	{797,2},	{759,2},	{684,2},
  {719,0},	{756,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{645,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {646,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki509[] = {
  {684,1},	{797,1},	{760,1},	{795,1},
  {759,1},	{832,2},	{833,2},	{796,2},
  {798,2},	{794,0},	{757,0},	{868,0},
  {756,0},	{721,0},	{758,0},	{793,0},
  {720,0},	{869,0},	{685,0},	{722,0},
  {830,0},	{682,0},	{719,0},	{870,0},
  {686,0},	{723,0},	{831,0},	{683,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{867,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki510[] = {
  {834,1},	{833,1},	{798,1},	{796,1},
  {832,1},	{795,2},	{759,2},	{797,2},
  {760,2},	{684,2},	{757,0},	{756,0},
  {719,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{794,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{831,0},
  {646,0},	{645,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki511[] = {
  {684,1},	{574,1},	{650,1},	{687,1},
  {685,1},	{649,1},	{722,2},	{724,2},
  {686,2},	{723,2},	{688,2},	{646,0},
  {647,0},	{758,0},	{609,0},	{610,0},
  {611,0},	{648,0},	{683,0},	{573,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {720,0},	{537,0},	{572,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{721,0},
  {536,0},	{535,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{757,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0}
};

static struct patval joseki512[] = {
  {833,1},	{796,1},	{798,1},	{832,1},
  {795,2},	{797,2},	{684,2},	{759,2},
  {682,0},	{645,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{720,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki513[] = {
  {834,1},	{684,1},	{759,1},	{797,1},
  {795,1},	{832,2},	{798,2},	{796,2},
  {833,2},	{719,0},	{757,0},	{756,0},
  {831,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{794,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {646,0},	{645,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki514[] = {
  {832,1},	{833,1},	{798,1},	{760,1},
  {796,1},	{834,2},	{795,2},	{797,2},
  {759,2},	{684,2},	{645,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {683,0},	{720,0},	{757,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{756,0},
  {793,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki515[] = {
  {834,1},	{684,1},	{797,1},	{835,1},
  {795,1},	{759,1},	{798,2},	{796,2},
  {832,2},	{833,2},	{760,2},	{756,0},
  {757,0},	{719,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{794,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{831,0},
  {868,0},	{645,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {646,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki516[] = {
  {832,1},	{761,1},	{798,1},	{760,1},
  {796,1},	{833,1},	{795,2},	{797,2},
  {759,2},	{834,2},	{835,2},	{684,2},
  {831,0},	{868,0},	{645,0},	{794,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {683,0},	{720,0},	{647,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{757,0},
  {793,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{682,0},	{719,0},
  {756,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki517[] = {
  {799,1},	{759,1},	{795,1},	{835,1},
  {797,1},	{834,1},	{684,1},	{832,2},
  {761,2},	{833,2},	{760,2},	{798,2},
  {796,2},	{831,0},	{645,0},	{794,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {683,0},	{868,0},	{647,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{757,0},
  {793,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{682,0},	{719,0},
  {756,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki518[] = {
  {832,1},	{761,1},	{798,1},	{760,1},
  {796,1},	{833,1},	{762,1},	{799,2},
  {795,2},	{834,2},	{835,2},	{684,2},
  {759,2},	{797,2},	{645,0},	{794,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {831,0},	{868,0},	{647,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{757,0},
  {793,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{682,0},	{719,0},
  {756,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{683,0},	{720,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki519[] = {
  {797,1},	{834,1},	{835,1},	{684,1},
  {795,1},	{759,1},	{832,2},	{796,2},
  {833,2},	{798,2},	{761,2},	{760,2},
  {831,0},	{756,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{830,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {757,0},	{794,0},	{719,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{868,0},
  {645,0},	{682,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{867,0},	{646,0},
  {683,0},	{872,0}
};

static struct patval joseki520[] = {
  {761,1},	{796,1},	{833,1},	{758,1},
  {798,1},	{832,1},	{760,1},	{795,2},
  {835,2},	{797,2},	{759,2},	{834,2},
  {684,2},	{831,0},	{647,0},	{720,0},
  {721,0},	{756,0},	{793,0},	{830,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {757,0},	{794,0},	{719,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{868,0},
  {645,0},	{682,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{867,0},	{646,0},
  {683,0},	{872,0}
};

static struct patval joseki521[] = {
  {797,1},	{834,1},	{835,1},	{684,1},
  {795,1},	{722,1},	{759,1},	{758,2},
  {833,2},	{798,2},	{761,2},	{796,2},
  {832,2},	{760,2},	{647,0},	{831,0},
  {721,0},	{756,0},	{793,0},	{720,0},
  {869,0},	{648,0},	{685,0},	{830,0},
  {757,0},	{794,0},	{719,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{868,0},
  {645,0},	{682,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{867,0},	{646,0},
  {683,0},	{872,0}
};

static struct patval joseki522[] = {
  {796,1},	{833,1},	{798,1},	{832,1},
  {795,2},	{797,2},	{759,2},	{684,2},
  {719,0},	{756,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{720,0},
  {721,0},	{758,0},	{793,0},	{683,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{645,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {646,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{867,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki523[] = {
  {761,1},	{795,1},	{759,1},	{797,1},
  {684,1},	{832,2},	{833,2},	{796,2},
  {798,2},	{757,0},	{831,0},	{868,0},
  {683,0},	{721,0},	{758,0},	{794,0},
  {867,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{720,0},	{830,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{793,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {682,0},	{719,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki524[] = {
  {796,1},	{832,1},	{798,1},	{795,2},
  {759,2},	{684,2},	{682,0},	{645,0},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki525[] = {
  {612,1},	{684,1},	{648,1},	{685,2},
  {651,2},	{649,2},	{646,0},	{647,0},
  {573,0},	{721,0},	{574,0},	{611,0},
  {683,0},	{610,0},	{722,0},	{575,0},
  {720,0},	{609,0},	{686,0},	{723,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0}
};

static struct patval joseki526[] = {
  {687,1},	{651,1},	{685,1},	{649,1},
  {648,2},	{612,2},	{537,2},	{684,2},
  {610,0},	{647,0},	{535,0},	{721,0},
  {536,0},	{574,0},	{611,0},	{573,0},
  {720,0},	{722,0},	{538,0},	{575,0},
  {609,0},	{646,0},	{686,0},	{723,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki527[] = {
  {648,1},	{722,1},	{684,1},	{537,1},
  {612,1},	{687,2},	{685,2},	{649,2},
  {651,2},	{573,0},	{610,0},	{609,0},
  {572,0},	{721,0},	{500,0},	{499,0},
  {574,0},	{611,0},	{646,0},	{536,0},
  {535,0},	{501,0},	{538,0},	{575,0},
  {683,0},	{647,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{498,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{720,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki528[] = {
  {685,1},	{687,1},	{651,1},	{613,1},
  {649,1},	{612,2},	{648,2},	{684,2},
  {537,2},	{722,2},	{610,0},	{573,0},
  {498,0},	{721,0},	{500,0},	{535,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {647,0},	{501,0},	{538,0},	{575,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{609,0},
  {650,0},	{683,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki529[] = {
  {648,1},	{575,1},	{612,1},	{722,1},
  {537,1},	{684,1},	{613,2},	{651,2},
  {685,2},	{649,2},	{687,2},	{721,0},
  {535,0},	{574,0},	{611,0},	{573,0},
  {610,0},	{647,0},	{538,0},	{720,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {539,0},	{576,0},	{609,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki530[] = {
  {686,1},	{651,1},	{613,1},	{649,1},
  {687,1},	{685,1},	{612,2},	{648,2},
  {575,2},	{722,2},	{684,2},	{537,2},
  {721,0},	{574,0},	{611,0},	{573,0},
  {535,0},	{647,0},	{538,0},	{720,0},
  {536,0},	{646,0},	{610,0},	{723,0},
  {539,0},	{576,0},	{609,0},	{650,0},
  {683,0},	{724,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{688,0},	{725,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki531[] = {
  {685,1},	{687,1},	{651,1},	{613,1},
  {649,1},	{612,2},	{648,2},	{684,2},
  {537,2},	{722,2},	{610,0},	{573,0},
  {498,0},	{721,0},	{500,0},	{535,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {647,0},	{501,0},	{538,0},	{575,0},
  {536,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{609,0},
  {650,0},	{683,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki532[] = {
  {722,1},	{686,1},	{684,1},	{537,1},
  {648,1},	{612,1},	{651,2},	{649,2},
  {687,2},	{613,2},	{610,0},	{572,0},
  {536,0},	{721,0},	{500,0},	{499,0},
  {574,0},	{609,0},	{646,0},	{685,0},
  {573,0},	{501,0},	{538,0},	{575,0},
  {683,0},	{647,0},	{535,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{611,0},
  {650,0},	{498,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{720,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki533[] = {
  {796,1},	{832,1},	{798,1},	{795,2},
  {759,2},	{684,2},	{682,0},	{645,0},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki534[] = {
  {833,1},	{684,1},	{795,1},	{759,1},
  {796,2},	{832,2},	{798,2},	{645,0},
  {682,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki535[] = {
  {796,1},	{797,1},	{798,1},	{832,1},
  {795,2},	{833,2},	{684,2},	{759,2},
  {682,0},	{645,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{646,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{720,0},	{830,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki536[] = {
  {684,1},	{537,1},	{648,1},	{612,1},
  {686,1},	{650,2},	{649,2},	{685,2},
  {651,2},	{535,0},	{610,0},	{647,0},
  {498,0},	{721,0},	{500,0},	{536,0},
  {574,0},	{611,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{538,0},	{575,0},
  {609,0},	{573,0},	{683,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {646,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki537[] = {
  {649,1},	{611,1},	{651,1},	{685,1},
  {650,1},	{686,2},	{648,2},	{612,2},
  {537,2},	{684,2},	{610,0},	{647,0},
  {498,0},	{721,0},	{500,0},	{536,0},
  {574,0},	{535,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{538,0},	{575,0},
  {609,0},	{573,0},	{683,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {646,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki538[] = {
  {721,1},	{574,1},	{685,1},	{649,1},
  {684,1},	{723,1},	{648,2},	{722,2},
  {688,2},	{686,2},	{687,2},	{647,0},
  {535,0},	{758,0},	{537,0},	{573,0},
  {611,0},	{572,0},	{757,0},	{536,0},
  {759,0},	{538,0},	{575,0},	{612,0},
  {646,0},	{610,0},	{720,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{724,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{609,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0}
};

static struct patval joseki539[] = {
  {649,1},	{684,1},	{723,2},	{718,0},
  {607,0},	{792,0},	{681,0},	{645,0},
  {644,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{612,0},	{755,0},
  {686,0},	{608,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0}
};

static struct patval joseki540[] = {
  {684,1},	{723,2},	{570,0},	{533,0},
  {496,0},	{681,0},	{718,0},	{755,0},
  {792,0},	{497,0},	{534,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {644,0},	{721,0},	{758,0},	{795,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{607,0},
  {760,0},	{797,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0}
};

static struct patval joseki541[] = {
  {684,1},	{798,1},	{759,2},	{645,0},
  {793,0},	{830,0},	{682,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{867,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki542[] = {
  {759,1},	{723,1},	{684,2},	{798,2},
  {793,0},	{830,0},	{682,0},	{646,0},
  {683,0},	{645,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{867,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{720,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki543[] = {
  {684,1},	{795,1},	{798,1},	{723,2},
  {759,2},	{830,0},	{682,0},	{646,0},
  {793,0},	{645,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{796,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{720,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki544[] = {
  {796,1},	{759,1},	{723,1},	{795,2},
  {798,2},	{684,2},	{682,0},	{646,0},
  {830,0},	{645,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{758,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{720,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki545[] = {
  {684,1},	{758,1},	{798,1},	{795,1},
  {759,2},	{796,2},	{723,2},	{608,0},
  {793,0},	{646,0},	{830,0},	{720,0},
  {609,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{757,0},	{721,0},
  {645,0},	{867,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {719,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{683,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{682,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki546[] = {
  {649,1},	{796,1},	{723,1},	{759,1},
  {758,2},	{798,2},	{795,2},	{684,2},
  {646,0},	{830,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{682,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki547[] = {
  {722,1},	{758,1},	{798,1},	{684,1},
  {795,1},	{723,2},	{796,2},	{649,2},
  {759,2},	{830,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{683,0},
  {721,0},	{682,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{646,0},
  {756,0},	{793,0},	{833,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki548[] = {
  {649,1},	{759,1},	{723,1},	{760,1},
  {796,1},	{798,2},	{795,2},	{722,2},
  {758,2},	{684,2},	{830,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{757,0},
  {721,0},	{682,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{646,0},
  {683,0},	{793,0},	{833,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{756,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki549[] = {
  {722,1},	{758,1},	{798,1},	{684,1},
  {795,1},	{833,1},	{796,2},	{649,2},
  {759,2},	{723,2},	{760,2},	{794,0},
  {831,0},	{868,0},	{647,0},	{757,0},
  {721,0},	{682,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{646,0},
  {683,0},	{793,0},	{830,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{756,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki550[] = {
  {649,1},	{759,1},	{723,1},	{760,1},
  {796,1},	{834,1},	{795,2},	{722,2},
  {758,2},	{798,2},	{833,2},	{684,2},
  {831,0},	{868,0},	{647,0},	{794,0},
  {721,0},	{682,0},	{867,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{646,0},
  {683,0},	{793,0},	{757,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{756,0},
  {797,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki551[] = {
  {722,1},	{758,1},	{798,1},	{832,1},
  {684,1},	{833,1},	{795,1},	{649,2},
  {796,2},	{723,2},	{834,2},	{759,2},
  {760,2},	{868,0},	{647,0},	{794,0},
  {721,0},	{682,0},	{867,0},	{831,0},
  {869,0},	{648,0},	{685,0},	{646,0},
  {683,0},	{793,0},	{757,0},	{870,0},
  {645,0},	{686,0},	{720,0},	{756,0},
  {797,0},	{830,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki552[] = {
  {684,1},	{798,1},	{759,2},	{645,0},
  {608,0},	{756,0},	{793,0},	{830,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki553[] = {
  {759,1},	{685,1},	{684,2},	{798,2},
  {608,0},	{756,0},	{793,0},	{830,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{645,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki554[] = {
  {684,1},	{648,1},	{798,1},	{685,2},
  {759,2},	{756,0},	{793,0},	{830,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{645,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki555[] = {
  {685,1},	{759,1},	{686,1},	{798,2},
  {648,2},	{684,2},	{793,0},	{830,0},
  {867,0},	{756,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{572,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{645,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki556[] = {
  {684,1},	{648,1},	{795,1},	{798,1},
  {686,2},	{685,2},	{759,2},	{830,0},
  {793,0},	{756,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{572,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{645,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki557[] = {
  {685,1},	{721,1},	{686,1},	{759,1},
  {798,2},	{684,2},	{648,2},	{795,2},
  {830,0},	{756,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{572,0},	{722,0},
  {719,0},	{796,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{645,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki558[] = {
  {684,1},	{648,1},	{796,1},	{798,1},
  {795,1},	{686,2},	{721,2},	{685,2},
  {759,2},	{830,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{572,0},	{722,0},
  {719,0},	{756,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{645,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki559[] = {
  {685,1},	{796,1},	{686,1},	{759,1},
  {798,2},	{648,2},	{684,2},	{795,2},
  {830,0},	{793,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{572,0},	{722,0},
  {719,0},	{756,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{645,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki560[] = {
  {798,1},	{684,1},	{759,2},	{802,2},
  {719,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{756,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {608,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {645,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{646,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{610,0},	{839,0},	{876,0}
};

static struct patval joseki561[] = {
  {684,1},	{723,2},	{570,0},	{533,0},
  {496,0},	{681,0},	{718,0},	{755,0},
  {792,0},	{497,0},	{534,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {644,0},	{721,0},	{758,0},	{795,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{607,0},
  {760,0},	{797,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0}
};

static struct patval joseki562[] = {
  {797,1},	{684,1},	{758,2},	{644,0},
  {792,0},	{829,0},	{866,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {755,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki563[] = {
  {758,1},	{722,1},	{684,2},	{797,2},
  {792,0},	{829,0},	{866,0},	{645,0},
  {682,0},	{644,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{681,0},	{721,0},
  {755,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{719,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{718,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki564[] = {
  {687,1},	{574,1},	{684,1},	{612,2},
  {648,2},	{719,0},	{682,0},	{535,0},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{609,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki565[] = {
  {685,1},	{648,1},	{612,1},	{574,2},
  {687,2},	{684,2},	{719,0},	{535,0},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{537,0},	{571,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{609,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki566[] = {
  {684,1},	{611,1},	{724,1},	{721,1},
  {722,2},	{649,2},	{685,2},	{572,0},
  {609,0},	{571,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{758,0},
  {795,0},	{574,0},	{608,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{646,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki567[] = {
  {758,1},	{722,1},	{649,1},	{685,1},
  {611,2},	{684,2},	{721,2},	{724,2},
  {609,0},	{571,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{572,0},
  {795,0},	{574,0},	{608,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{646,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki568[] = {
  {648,1},	{611,1},	{724,1},	{721,1},
  {684,1},	{722,2},	{685,2},	{649,2},
  {758,2},	{571,0},	{609,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{793,0},	{683,0},
  {795,0},	{574,0},	{608,0},	{572,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{646,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki569[] = {
  {758,1},	{687,1},	{649,1},	{685,1},
  {722,1},	{684,2},	{611,2},	{724,2},
  {648,2},	{721,2},	{609,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{571,0},	{683,0},
  {795,0},	{574,0},	{793,0},	{572,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{646,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{608,0},	{645,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki570[] = {
  {684,1},	{538,1},	{651,1},	{575,1},
  {648,1},	{611,1},	{649,2},	{612,2},
  {614,2},	{576,2},	{685,2},	{536,0},
  {498,0},	{721,0},	{500,0},	{537,0},
  {574,0},	{683,0},	{647,0},	{610,0},
  {722,0},	{501,0},	{720,0},	{499,0},
  {609,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{573,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{572,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki571[] = {
  {758,1},	{760,1},	{797,2},	{684,2},
  {792,0},	{681,0},	{644,0},	{645,0},
  {682,0},	{719,0},	{718,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{755,0},	{721,0},
  {756,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{829,0},	{866,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki572[] = {
  {945,1},	{684,2},	{906,2},	{644,0},
  {792,0},	{829,0},	{681,0},	{903,0},
  {940,0},	{977,0},	{1014,0},	{645,0},
  {682,0},	{719,0},	{718,0},	{793,0},
  {830,0},	{867,0},	{904,0},	{941,0},
  {978,0},	{1015,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{979,0},
  {1016,0},	{647,0},	{866,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {755,0},	{943,0},	{980,0},	{1017,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{981,0},	{1018,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{756,0},
  {982,0},	{1019,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{983,0},
  {1020,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{984,0},	{1021,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{985,0},	{1022,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {986,0},	{1023,0}
};

static struct patval joseki573[] = {
  {906,1},	{947,1},	{684,1},	{945,2},
  {681,0},	{792,0},	{829,0},	{607,0},
  {903,0},	{940,0},	{977,0},	{1014,0},
  {608,0},	{645,0},	{682,0},	{755,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{978,0},	{1015,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{979,0},	{1016,0},
  {610,0},	{647,0},	{866,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {718,0},	{943,0},	{980,0},	{1017,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {907,0},	{944,0},	{981,0},	{1018,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{719,0},	{982,0},	{1019,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{983,0},	{1020,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{644,0},	{984,0},	{1021,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{985,0},	{1022,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {912,0},	{949,0},	{986,0},	{1023,0}
};

static struct patval joseki574[] = {
  {687,1},	{684,1},	{689,2},	{648,2},
  {426,2},	{386,0},	{534,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{387,0},
  {424,0},	{461,0},	{571,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{388,0},	{425,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{460,0},	{721,0},
  {758,0},	{389,0},	{608,0},	{463,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {497,0},	{685,0},	{722,0},	{759,0},
  {390,0},	{427,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{391,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{498,0},
  {724,0},	{761,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{393,0},	{430,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{423,0},	{726,0},	{763,0},
  {394,0},	{431,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{395,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki575[] = {
  {686,1},	{684,2},	{570,0},	{644,0},
  {681,0},	{718,0},	{755,0},	{607,0},
  {534,0},	{571,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {533,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {792,0},	{723,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki576[] = {
  {758,1},	{684,1},	{760,2},	{644,0},
  {792,0},	{829,0},	{718,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{866,0},	{721,0},
  {755,0},	{795,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{681,0},	{797,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki577[] = {
  {795,1},	{760,1},	{684,2},	{758,2},
  {644,0},	{829,0},	{718,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{866,0},	{721,0},
  {755,0},	{792,0},	{832,0},	{869,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{681,0},	{797,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki578[] = {
  {648,1},	{574,1},	{684,1},	{685,2},
  {650,2},	{719,0},	{534,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki579[] = {
  {685,1},	{650,1},	{686,1},	{648,2},
  {684,2},	{574,2},	{719,0},	{535,0},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {645,0},	{609,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki580[] = {
  {721,1},	{574,1},	{684,1},	{648,1},
  {686,2},	{685,2},	{650,2},	{719,0},
  {572,0},	{534,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{535,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {645,0},	{609,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{545,0},	{582,0},	{619,0},
  {656,0},	{693,0},	{730,0},	{767,0}
};

static struct patval joseki581[] = {
  {685,1},	{686,1},	{650,1},	{684,2},
  {574,2},	{721,2},	{648,2},	{423,0},
  {682,0},	{719,0},	{460,0},	{387,0},
  {424,0},	{461,0},	{498,0},	{386,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{388,0},	{425,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{571,0},
  {758,0},	{389,0},	{426,0},	{463,0},
  {500,0},	{537,0},	{534,0},	{611,0},
  {608,0},	{535,0},	{722,0},	{759,0},
  {390,0},	{427,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {645,0},	{723,0},	{760,0},	{391,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{497,0},	{687,0},
  {724,0},	{761,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki582[] = {
  {684,1},	{650,1},	{648,2},	{574,2},
  {682,0},	{719,0},	{534,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{756,0},	{611,0},
  {645,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{571,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki583[] = {
  {684,1},	{758,1},	{760,2},	{792,0},
  {718,0},	{866,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{829,0},	{721,0},
  {755,0},	{795,0},	{832,0},	{869,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {681,0},	{797,0},	{834,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0}
};

static struct patval joseki584[] = {
  {760,1},	{684,2},	{758,2},	{718,0},
  {755,0},	{644,0},	{829,0},	{681,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{792,0},	{721,0},
  {607,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {866,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki585[] = {
  {758,1},	{797,1},	{684,1},	{764,2},
  {760,2},	{607,0},	{755,0},	{866,0},
  {608,0},	{681,0},	{682,0},	{644,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{718,0},	{721,0},
  {719,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {792,0},	{829,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {645,0},	{801,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0}
};

static struct patval joseki586[] = {
  {760,1},	{798,1},	{758,2},	{684,2},
  {797,2},	{718,0},	{829,0},	{681,0},
  {644,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{792,0},	{721,0},
  {607,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {866,0},	{608,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{755,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki587[] = {
  {796,1},	{797,1},	{758,1},	{684,1},
  {764,2},	{798,2},	{760,2},	{607,0},
  {608,0},	{755,0},	{682,0},	{644,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{718,0},	{721,0},
  {719,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{866,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {792,0},	{829,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{681,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {645,0},	{801,0},	{838,0},	{875,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0}
};

static struct patval joseki588[] = {
  {684,1},	{648,2},	{645,0},	{608,0},
  {571,0},	{756,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{574,0},	{611,0},
  {719,0},	{685,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0}
};

static struct patval joseki589[] = {
  {685,1},	{648,1},	{684,2},	{645,0},
  {608,0},	{756,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {721,0},	{758,0},	{574,0},	{611,0},
  {719,0},	{571,0},	{722,0},	{759,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0}
};

static struct patval joseki590[] = {
  {721,1},	{684,1},	{685,2},	{722,2},
  {645,0},	{793,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {610,0},	{647,0},	{682,0},	{719,0},
  {758,0},	{795,0},	{611,0},	{648,0},
  {756,0},	{608,0},	{759,0},	{796,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0}
};

static struct patval joseki591[] = {
  {759,1},	{684,1},	{722,1},	{758,2},
  {721,2},	{830,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{682,0},	{719,0},	{756,0},
  {795,0},	{832,0},	{648,0},	{685,0},
  {793,0},	{645,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki592[] = {
  {759,1},	{684,1},	{722,1},	{685,2},
  {723,2},	{760,2},	{831,0},	{610,0},
  {647,0},	{794,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{611,0},	{648,0},
  {683,0},	{720,0},	{757,0},	{796,0},
  {833,0},	{612,0},	{649,0},	{686,0},
  {609,0},	{646,0},	{797,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki593[] = {
  {723,1},	{760,1},	{685,1},	{648,1},
  {722,2},	{684,2},	{759,2},	{831,0},
  {647,0},	{794,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{611,0},	{610,0},
  {683,0},	{720,0},	{757,0},	{796,0},
  {833,0},	{612,0},	{649,0},	{686,0},
  {609,0},	{646,0},	{797,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki594[] = {
  {796,1},	{684,1},	{721,1},	{759,1},
  {722,2},	{760,2},	{685,2},	{797,2},
  {610,0},	{647,0},	{868,0},	{831,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {609,0},	{646,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki595[] = {
  {797,1},	{722,1},	{760,1},	{685,1},
  {759,2},	{796,2},	{684,2},	{721,2},
  {758,0},	{795,0},	{832,0},	{869,0},
  {868,0},	{720,0},	{757,0},	{794,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {831,0},	{683,0},	{834,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki596[] = {
  {759,1},	{796,1},	{684,1},	{721,1},
  {834,1},	{722,2},	{760,2},	{797,2},
  {685,2},	{795,0},	{832,0},	{869,0},
  {758,0},	{868,0},	{683,0},	{720,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {757,0},	{794,0},	{831,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0}
};

static struct patval joseki597[] = {
  {797,1},	{835,1},	{722,1},	{685,1},
  {760,1},	{796,2},	{759,2},	{721,2},
  {684,2},	{834,2},	{795,0},	{869,0},
  {868,0},	{758,0},	{757,0},	{794,0},
  {833,0},	{870,0},	{686,0},	{723,0},
  {831,0},	{683,0},	{832,0},	{871,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {720,0},	{872,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki598[] = {
  {721,1},	{759,1},	{796,1},	{833,1},
  {684,1},	{834,1},	{685,2},	{760,2},
  {797,2},	{722,2},	{835,2},	{648,2},
  {832,0},	{869,0},	{795,0},	{868,0},
  {646,0},	{683,0},	{720,0},	{647,0},
  {870,0},	{649,0},	{686,0},	{723,0},
  {757,0},	{794,0},	{758,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{831,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {874,0}
};

static struct patval joseki599[] = {
  {758,1},	{796,1},	{721,1},	{759,2},
  {722,2},	{684,2},	{830,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{646,0},	{719,0},	{756,0},
  {795,0},	{832,0},	{648,0},	{685,0},
  {793,0},	{645,0},	{682,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki600[] = {
  {759,1},	{797,1},	{684,1},	{722,1},
  {758,2},	{796,2},	{721,2},	{683,0},
  {830,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{720,0},	{719,0},	{756,0},
  {795,0},	{832,0},	{648,0},	{685,0},
  {793,0},	{645,0},	{646,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {682,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki601[] = {
  {721,1},	{758,1},	{795,1},	{796,1},
  {759,2},	{722,2},	{797,2},	{684,2},
  {646,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{683,0},	{645,0},	{682,0},
  {830,0},	{832,0},	{648,0},	{685,0},
  {719,0},	{756,0},	{720,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki602[] = {
  {759,1},	{797,1},	{761,1},	{684,1},
  {722,1},	{758,2},	{721,2},	{795,2},
  {796,2},	{757,0},	{830,0},	{831,0},
  {647,0},	{720,0},	{719,0},	{756,0},
  {683,0},	{832,0},	{648,0},	{685,0},
  {793,0},	{645,0},	{794,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {682,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{646,0},	{798,0},	{835,0}
};

static struct patval joseki603[] = {
  {759,1},	{796,1},	{797,1},	{722,1},
  {684,1},	{723,2},	{798,2},	{762,2},
  {685,2},	{760,2},	{721,0},	{831,0},
  {795,0},	{832,0},	{611,0},	{648,0},
  {647,0},	{720,0},	{757,0},	{794,0},
  {833,0},	{612,0},	{649,0},	{686,0},
  {609,0},	{758,0},	{683,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{646,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{610,0},
  {799,0},	{836,0}
};

static struct patval joseki604[] = {
  {723,1},	{798,1},	{685,1},	{760,1},
  {648,1},	{762,1},	{684,2},	{796,2},
  {797,2},	{722,2},	{759,2},	{831,0},
  {721,0},	{832,0},	{611,0},	{795,0},
  {647,0},	{720,0},	{757,0},	{794,0},
  {833,0},	{612,0},	{649,0},	{686,0},
  {609,0},	{758,0},	{683,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{646,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{610,0},
  {799,0},	{836,0}
};

static struct patval joseki605[] = {
  {796,1},	{833,1},	{834,1},	{684,1},
  {759,1},	{721,1},	{760,2},	{835,2},
  {799,2},	{685,2},	{722,2},	{797,2},
  {758,0},	{868,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{647,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {609,0},	{795,0},	{683,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{646,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{610,0},	{836,0},	{873,0}
};

static struct patval joseki606[] = {
  {796,1},	{721,1},	{758,1},	{795,1},
  {759,2},	{684,2},	{797,2},	{722,2},
  {646,0},	{683,0},	{830,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{682,0},	{609,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {719,0},	{756,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki607[] = {
  {758,1},	{796,1},	{721,1},	{759,2},
  {722,2},	{684,2},	{830,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{646,0},	{719,0},	{756,0},
  {795,0},	{832,0},	{648,0},	{685,0},
  {793,0},	{645,0},	{682,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki608[] = {
  {722,1},	{684,2},	{644,0},	{607,0},
  {570,0},	{755,0},	{792,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {718,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0}
};

static struct patval joseki609[] = {
  {685,1},	{722,1},	{721,2},	{684,2},
  {718,0},	{681,0},	{644,0},	{607,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {755,0},	{570,0},	{758,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{792,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki610[] = {
  {759,1},	{722,1},	{684,1},	{721,2},
  {758,2},	{685,2},	{755,0},	{644,0},
  {718,0},	{608,0},	{645,0},	{682,0},
  {681,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {719,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{829,0},
  {571,0},	{570,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki611[] = {
  {722,1},	{797,1},	{759,1},	{684,1},
  {758,2},	{685,2},	{796,2},	{721,2},
  {645,0},	{682,0},	{644,0},	{718,0},
  {793,0},	{681,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{610,0},	{647,0},	{755,0},
  {719,0},	{756,0},	{795,0},	{832,0},
  {611,0},	{648,0},	{792,0},	{829,0},
  {830,0},	{607,0},	{833,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {608,0},	{834,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki612[] = {
  {722,1},	{685,1},	{649,1},	{684,2},
  {721,2},	{648,2},	{718,0},	{607,0},
  {681,0},	{571,0},	{608,0},	{645,0},
  {644,0},	{719,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{570,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{792,0},
  {534,0},	{533,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{755,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki613[] = {
  {722,1},	{758,1},	{684,2},	{721,2},
  {718,0},	{644,0},	{792,0},	{681,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{573,0},	{610,0},	{647,0},
  {755,0},	{570,0},	{607,0},	{795,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {571,0},	{759,0},	{796,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki614[] = {
  {758,1},	{723,1},	{722,1},	{685,2},
  {684,2},	{721,2},	{607,0},	{792,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{755,0},	{795,0},
  {611,0},	{648,0},	{681,0},	{718,0},
  {759,0},	{796,0},	{612,0},	{649,0},
  {686,0},	{644,0},	{760,0},	{797,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0}
};

static struct patval joseki615[] = {
  {684,1},	{685,1},	{649,1},	{648,2},
  {611,2},	{612,2},	{645,0},	{608,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {572,0},	{721,0},	{537,0},	{574,0},
  {682,0},	{534,0},	{571,0},	{722,0},
  {538,0},	{575,0},	{719,0},	{535,0},
  {686,0},	{723,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0}
};

static struct patval joseki616[] = {
  {686,1},	{685,1},	{649,1},	{684,1},
  {650,2},	{648,2},	{611,2},	{612,2},
  {719,0},	{497,0},	{534,0},	{646,0},
  {683,0},	{720,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{498,0},
  {721,0},	{500,0},	{537,0},	{574,0},
  {535,0},	{572,0},	{609,0},	{722,0},
  {501,0},	{538,0},	{575,0},	{608,0},
  {645,0},	{682,0},	{723,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{571,0},
  {687,0},	{724,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0}
};

static struct patval joseki617[] = {
  {684,1},	{648,2},	{537,2},	{608,0},
  {571,0},	{719,0},	{756,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{645,0},	{574,0},	{611,0},
  {534,0},	{685,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0}
};

static struct patval joseki618[] = {
  {648,1},	{685,1},	{537,1},	{684,2},
  {608,0},	{719,0},	{756,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{645,0},	{574,0},	{611,0},
  {534,0},	{571,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0}
};

static struct patval joseki619[] = {
  {721,1},	{684,1},	{574,2},	{722,2},
  {685,2},	{756,0},	{645,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{793,0},	{719,0},	{758,0},
  {795,0},	{682,0},	{611,0},	{648,0},
  {571,0},	{608,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0}
};

static struct patval joseki620[] = {
  {722,1},	{759,1},	{684,1},	{611,1},
  {758,2},	{721,2},	{793,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {682,0},	{830,0},	{756,0},	{795,0},
  {832,0},	{719,0},	{648,0},	{685,0},
  {608,0},	{645,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0}
};

static struct patval joseki621[] = {
  {759,1},	{684,1},	{722,1},	{685,2},
  {723,2},	{760,2},	{612,2},	{610,0},
  {647,0},	{794,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{611,0},	{648,0},
  {683,0},	{831,0},	{757,0},	{796,0},
  {833,0},	{720,0},	{649,0},	{686,0},
  {609,0},	{646,0},	{797,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki622[] = {
  {723,1},	{760,1},	{685,1},	{612,1},
  {648,1},	{684,2},	{722,2},	{759,2},
  {647,0},	{794,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{611,0},	{610,0},
  {683,0},	{831,0},	{757,0},	{796,0},
  {833,0},	{720,0},	{649,0},	{686,0},
  {609,0},	{646,0},	{797,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki623[] = {
  {684,1},	{722,1},	{759,1},	{797,1},
  {760,2},	{723,2},	{648,2},	{685,2},
  {612,2},	{647,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{611,0},	{831,0},
  {610,0},	{646,0},	{683,0},	{796,0},
  {833,0},	{609,0},	{649,0},	{686,0},
  {720,0},	{757,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0}
};

static struct patval joseki624[] = {
  {723,1},	{798,1},	{685,1},	{612,1},
  {648,1},	{760,1},	{722,2},	{797,2},
  {759,2},	{684,2},	{721,0},	{647,0},
  {795,0},	{832,0},	{611,0},	{758,0},
  {794,0},	{831,0},	{757,0},	{796,0},
  {833,0},	{720,0},	{649,0},	{686,0},
  {609,0},	{610,0},	{683,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{646,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki625[] = {
  {795,1},	{759,2},	{684,2},	{756,0},
  {719,0},	{867,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {682,0},	{721,0},	{758,0},	{793,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {830,0},	{796,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0}
};

static struct patval joseki626[] = {
  {795,1},	{758,1},	{684,2},	{796,2},
  {759,2},	{719,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {867,0},	{721,0},	{756,0},	{793,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {830,0},	{682,0},	{833,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0}
};

static struct patval joseki627[] = {
  {758,1},	{795,1},	{833,1},	{796,2},
  {759,2},	{721,2},	{684,2},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {683,0},	{867,0},	{682,0},	{719,0},
  {832,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{830,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki628[] = {
  {758,1},	{795,1},	{832,1},	{833,1},
  {796,2},	{759,2},	{684,2},	{721,2},
  {834,2},	{794,0},	{831,0},	{868,0},
  {683,0},	{720,0},	{682,0},	{719,0},
  {867,0},	{869,0},	{685,0},	{722,0},
  {756,0},	{793,0},	{757,0},	{870,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {830,0},	{871,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki629[] = {
  {833,1},	{684,2},	{759,2},	{756,0},
  {645,0},	{719,0},	{867,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{793,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{722,0},
  {830,0},	{796,0},	{682,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki630[] = {
  {833,1},	{684,2},	{759,2},	{682,0},
  {608,0},	{645,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {719,0},	{796,0},	{793,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki631[] = {
  {832,1},	{796,2},	{684,2},	{756,0},
  {719,0},	{867,0},	{904,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{793,0},	{721,0},
  {758,0},	{795,0},	{830,0},	{869,0},
  {906,0},	{685,0},	{722,0},	{759,0},
  {682,0},	{833,0},	{870,0},	{907,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0}
};

static struct patval joseki632[] = {
  {796,1},	{833,1},	{684,1},	{832,2},
  {756,0},	{867,0},	{904,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{793,0},	{721,0},
  {758,0},	{795,0},	{830,0},	{869,0},
  {906,0},	{685,0},	{722,0},	{759,0},
  {682,0},	{719,0},	{870,0},	{907,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0}
};

static struct patval joseki633[] = {
  {832,1},	{795,1},	{684,2},	{833,2},
  {796,2},	{867,0},	{756,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{904,0},	{721,0},
  {758,0},	{793,0},	{830,0},	{869,0},
  {906,0},	{685,0},	{722,0},	{759,0},
  {682,0},	{719,0},	{870,0},	{907,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0}
};

static struct patval joseki634[] = {
  {796,1},	{833,1},	{758,1},	{684,1},
  {832,2},	{795,2},	{867,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{904,0},	{721,0},
  {756,0},	{793,0},	{830,0},	{869,0},
  {906,0},	{685,0},	{722,0},	{759,0},
  {682,0},	{719,0},	{870,0},	{907,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0}
};

static struct patval joseki635[] = {
  {759,1},	{684,1},	{722,1},	{685,2},
  {723,2},	{760,2},	{611,2},	{610,0},
  {647,0},	{794,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{831,0},	{648,0},
  {683,0},	{720,0},	{757,0},	{796,0},
  {833,0},	{612,0},	{649,0},	{686,0},
  {609,0},	{646,0},	{797,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki636[] = {
  {760,1},	{797,1},	{722,1},	{648,1},
  {684,1},	{721,2},	{759,2},	{796,2},
  {647,0},	{831,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{868,0},	{685,0},
  {720,0},	{757,0},	{794,0},	{833,0},
  {870,0},	{649,0},	{686,0},	{723,0},
  {646,0},	{683,0},	{834,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki637[] = {
  {796,1},	{721,1},	{723,1},	{759,1},
  {760,2},	{722,2},	{648,2},	{797,2},
  {684,2},	{647,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{868,0},	{685,0},
  {720,0},	{757,0},	{794,0},	{833,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{683,0},	{834,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki638[] = {
  {760,1},	{797,1},	{722,1},	{648,1},
  {685,1},	{684,1},	{759,2},	{796,2},
  {723,2},	{721,2},	{758,0},	{795,0},
  {832,0},	{869,0},	{868,0},	{647,0},
  {720,0},	{757,0},	{794,0},	{833,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{683,0},	{834,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki639[] = {
  {796,1},	{721,1},	{834,1},	{759,1},
  {723,1},	{760,2},	{648,2},	{685,2},
  {684,2},	{797,2},	{722,2},	{795,0},
  {832,0},	{869,0},	{868,0},	{647,0},
  {758,0},	{757,0},	{794,0},	{833,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{683,0},	{720,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki640[] = {
  {760,1},	{835,1},	{722,1},	{648,1},
  {685,1},	{684,1},	{797,1},	{759,2},
  {723,2},	{721,2},	{834,2},	{796,2},
  {832,0},	{869,0},	{868,0},	{795,0},
  {758,0},	{757,0},	{794,0},	{833,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{647,0},	{720,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{683,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki641[] = {
  {721,1},	{759,1},	{723,1},	{833,1},
  {796,1},	{834,1},	{797,2},	{760,2},
  {684,2},	{722,2},	{835,2},	{685,2},
  {648,2},	{869,0},	{832,0},	{795,0},
  {646,0},	{683,0},	{868,0},	{647,0},
  {870,0},	{649,0},	{686,0},	{720,0},
  {757,0},	{794,0},	{758,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{831,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {874,0}
};

static struct patval joseki642[] = {
  {760,1},	{835,1},	{722,1},	{648,1},
  {685,1},	{797,1},	{684,1},	{799,1},
  {759,2},	{721,2},	{834,2},	{723,2},
  {796,2},	{833,2},	{868,0},	{832,0},
  {758,0},	{757,0},	{794,0},	{869,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{795,0},	{720,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{683,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{647,0},
  {836,0},	{873,0}
};

static struct patval joseki643[] = {
  {723,1},	{760,1},	{761,1},	{684,1},
  {686,1},	{650,1},	{648,1},	{687,2},
  {611,2},	{726,2},	{649,2},	{724,2},
  {612,2},	{762,2},	{575,2},	{759,0},
  {685,0},	{795,0},	{721,0},	{796,0},
  {797,0},	{576,0},	{613,0},	{758,0},
  {573,0},	{722,0},	{647,0},	{798,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{610,0},	{799,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{574,0},
  {763,0},	{800,0}
};

static struct patval joseki644[] = {
  {760,1},	{835,1},	{722,1},	{648,1},
  {685,1},	{797,1},	{684,1},	{799,1},
  {759,2},	{721,2},	{834,2},	{723,2},
  {796,2},	{833,2},	{868,0},	{832,0},
  {758,0},	{757,0},	{794,0},	{869,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{795,0},	{720,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{683,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{647,0},
  {836,0},	{873,0}
};

static struct patval joseki645[] = {
  {796,1},	{833,1},	{834,1},	{759,1},
  {758,1},	{723,1},	{721,1},	{799,2},
  {684,2},	{648,2},	{760,2},	{797,2},
  {722,2},	{835,2},	{685,2},	{868,0},
  {832,0},	{757,0},	{794,0},	{869,0},
  {870,0},	{649,0},	{686,0},	{831,0},
  {646,0},	{795,0},	{720,0},	{871,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{683,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{647,0},
  {836,0},	{873,0}
};

static struct patval joseki646[] = {
  {685,1},	{684,2},	{607,0},	{644,0},
  {681,0},	{718,0},	{755,0},	{792,0},
  {570,0},	{571,0},	{608,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {533,0},	{721,0},	{758,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {534,0},	{722,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0}
};

static struct patval joseki647[] = {
  {758,1},	{722,1},	{721,2},	{684,2},
  {718,0},	{644,0},	{681,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{610,0},	{647,0},	{755,0},
  {792,0},	{607,0},	{795,0},	{832,0},
  {611,0},	{648,0},	{685,0},	{829,0},
  {759,0},	{796,0},	{833,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki648[] = {
  {684,1},	{758,2},	{644,0},	{718,0},
  {607,0},	{792,0},	{829,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{610,0},	{647,0},	{681,0},
  {721,0},	{755,0},	{795,0},	{832,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0}
};

static struct patval joseki649[] = {
  {684,1},	{759,1},	{685,2},	{682,0},
  {608,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{645,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki650[] = {
  {722,1},	{684,1},	{796,2},	{721,2},
  {645,0},	{756,0},	{867,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{793,0},
  {719,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{685,0},	{830,0},
  {759,0},	{682,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0}
};

static struct patval joseki651[] = {
  {721,1},	{758,1},	{796,1},	{684,2},
  {722,2},	{793,0},	{830,0},	{719,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{608,0},
  {645,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki652[] = {
  {722,1},	{684,1},	{685,1},	{721,2},
  {796,2},	{758,2},	{830,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{682,0},
  {719,0},	{867,0},	{795,0},	{832,0},
  {869,0},	{648,0},	{756,0},	{793,0},
  {759,0},	{645,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki653[] = {
  {721,1},	{758,1},	{796,1},	{798,1},
  {684,2},	{722,2},	{685,2},	{608,0},
  {534,0},	{830,0},	{867,0},	{498,0},
  {756,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{645,0},
  {682,0},	{719,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{793,0},	{497,0},
  {759,0},	{571,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{535,0},
  {835,0},	{872,0}
};

static struct patval joseki654[] = {
  {684,1},	{833,1},	{832,1},	{870,1},
  {906,2},	{946,2},	{869,2},	{944,2},
  {830,0},	{904,0},	{941,0},	{571,0},
  {1015,0},	{572,0},	{609,0},	{608,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{573,0},	{610,0},
  {647,0},	{978,0},	{721,0},	{758,0},
  {795,0},	{645,0},	{682,0},	{719,0},
  {943,0},	{980,0},	{1017,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{646,0},	{793,0},
  {907,0},	{867,0},	{981,0},	{1018,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{908,0},	{945,0},	{982,0},
  {1019,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0},	{756,0},
  {983,0},	{1020,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{984,0},	{1021,0}
};

static struct patval joseki655[] = {
  {1018,1},	{684,1},	{1020,1},	{943,1},
  {980,1},	{906,2},	{944,2},	{907,2},
  {758,2},	{904,0},	{1015,0},	{645,0},
  {1089,0},	{646,0},	{683,0},	{682,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{979,0},	{1016,0},
  {1053,0},	{1090,0},	{647,0},	{978,0},
  {721,0},	{1052,0},	{795,0},	{832,0},
  {869,0},	{719,0},	{756,0},	{793,0},
  {1017,0},	{1054,0},	{1091,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{870,0},	{720,0},	{867,0},
  {981,0},	{941,0},	{1055,0},	{1092,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {945,0},	{982,0},	{1019,0},	{1056,0},
  {1093,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{983,0},	{830,0},
  {1057,0},	{1094,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{947,0},	{984,0},
  {1021,0},	{1058,0},	{1095,0}
};

static struct patval joseki656[] = {
  {907,1},	{758,1},	{906,1},	{944,1},
  {980,2},	{1018,2},	{943,2},	{1020,2},
  {684,2},	{682,0},	{719,0},	{1089,0},
  {1015,0},	{720,0},	{941,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{1053,0},	{1090,0},
  {683,0},	{721,0},	{1052,0},	{795,0},
  {832,0},	{869,0},	{756,0},	{793,0},
  {830,0},	{1017,0},	{1054,0},	{1091,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{870,0},	{757,0},	{904,0},
  {981,0},	{978,0},	{1055,0},	{1092,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{908,0},	{945,0},
  {982,0},	{1019,0},	{1056,0},	{1093,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0},	{946,0},
  {983,0},	{867,0},	{1057,0},	{1094,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {984,0},	{1021,0},	{1058,0},	{1095,0}
};

static struct patval joseki657[] = {
  {832,1},	{684,1},	{1018,1},	{943,1},
  {980,1},	{1020,1},	{944,2},	{758,2},
  {906,2},	{907,2},	{1015,0},	{904,0},
  {1089,0},	{646,0},	{683,0},	{682,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{979,0},	{1016,0},
  {1053,0},	{1090,0},	{647,0},	{978,0},
  {721,0},	{1052,0},	{795,0},	{645,0},
  {869,0},	{719,0},	{756,0},	{793,0},
  {1017,0},	{1054,0},	{1091,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{870,0},	{720,0},	{867,0},
  {981,0},	{941,0},	{1055,0},	{1092,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {945,0},	{982,0},	{1019,0},	{1056,0},
  {1093,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{983,0},	{830,0},
  {1057,0},	{1094,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{947,0},	{984,0},
  {1021,0},	{1058,0},	{1095,0}
};

static struct patval joseki658[] = {
  {758,1},	{721,1},	{796,1},	{684,2},
  {685,2},	{722,2},	{756,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{719,0},
  {759,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki659[] = {
  {684,1},	{797,1},	{685,1},	{722,1},
  {796,2},	{721,2},	{758,2},	{756,0},
  {609,0},	{646,0},	{683,0},	{867,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{719,0},
  {759,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki660[] = {
  {834,1},	{721,1},	{758,1},	{796,1},
  {797,2},	{722,2},	{684,2},	{685,2},
  {609,0},	{756,0},	{683,0},	{867,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {646,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{719,0},
  {759,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{830,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki661[] = {
  {684,1},	{797,1},	{685,1},	{722,1},
  {759,1},	{721,2},	{834,2},	{796,2},
  {758,2},	{609,0},	{683,0},	{867,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {646,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{719,0},
  {756,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{830,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki662[] = {
  {834,1},	{721,1},	{758,1},	{796,1},
  {832,1},	{722,2},	{684,2},	{797,2},
  {759,2},	{685,2},	{683,0},	{867,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {646,0},	{795,0},	{609,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{719,0},
  {756,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{830,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki663[] = {
  {684,1},	{722,1},	{685,1},	{798,1},
  {759,1},	{797,1},	{834,2},	{796,2},
  {832,2},	{721,2},	{758,2},	{867,0},
  {683,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {757,0},	{795,0},	{609,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{646,0},
  {756,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{830,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{719,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki664[] = {
  {832,1},	{721,1},	{758,1},	{834,1},
  {835,1},	{796,1},	{798,2},	{797,2},
  {684,2},	{722,2},	{759,2},	{685,2},
  {867,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {757,0},	{795,0},	{609,0},	{869,0},
  {611,0},	{648,0},	{682,0},	{646,0},
  {683,0},	{720,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{793,0},	{830,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{719,0},	{756,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki665[] = {
  {722,1},	{685,1},	{684,1},	{758,2},
  {796,2},	{721,2},	{608,0},	{756,0},
  {534,0},	{830,0},	{867,0},	{498,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{645,0},
  {682,0},	{719,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{793,0},	{497,0},
  {759,0},	{571,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0}
};

static struct patval joseki666[] = {
  {758,1},	{574,1},	{721,1},	{796,1},
  {685,2},	{722,2},	{684,2},	{497,0},
  {793,0},	{830,0},	{867,0},	{498,0},
  {719,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki667[] = {
  {685,1},	{684,1},	{722,1},	{797,1},
  {796,2},	{721,2},	{574,2},	{758,2},
  {793,0},	{830,0},	{867,0},	{498,0},
  {719,0},	{572,0},	{609,0},	{497,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {759,0},	{646,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {756,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki668[] = {
  {834,1},	{574,1},	{721,1},	{758,1},
  {796,1},	{722,2},	{684,2},	{685,2},
  {797,2},	{830,0},	{867,0},	{498,0},
  {719,0},	{572,0},	{609,0},	{497,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {759,0},	{646,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {756,0},	{793,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki669[] = {
  {759,1},	{684,1},	{722,1},	{797,1},
  {685,1},	{721,2},	{796,2},	{758,2},
  {834,2},	{574,2},	{867,0},	{498,0},
  {830,0},	{572,0},	{609,0},	{497,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {719,0},	{646,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {756,0},	{793,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0}
};

static struct patval joseki670[] = {
  {758,1},	{574,1},	{721,1},	{832,1},
  {796,1},	{834,1},	{722,2},	{685,2},
  {797,2},	{759,2},	{684,2},	{497,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{498,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{830,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki671[] = {
  {797,1},	{684,1},	{722,1},	{759,1},
  {685,1},	{798,1},	{758,2},	{796,2},
  {832,2},	{834,2},	{721,2},	{574,2},
  {497,0},	{867,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{498,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{572,0},
  {719,0},	{756,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{830,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {835,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki672[] = {
  {835,1},	{758,1},	{574,1},	{832,1},
  {834,1},	{721,1},	{796,1},	{722,2},
  {685,2},	{759,2},	{797,2},	{684,2},
  {798,2},	{498,0},	{682,0},	{646,0},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{719,0},
  {683,0},	{793,0},	{795,0},	{867,0},
  {869,0},	{500,0},	{537,0},	{756,0},
  {611,0},	{648,0},	{534,0},	{571,0},
  {535,0},	{572,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {608,0},	{645,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{609,0},
  {497,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{506,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki673[] = {
  {835,1},	{574,1},	{721,1},	{758,1},
  {796,1},	{832,1},	{834,1},	{685,2},
  {797,2},	{798,2},	{759,2},	{722,2},
  {684,2},	{497,0},	{867,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{535,0},
  {571,0},	{608,0},	{795,0},	{498,0},
  {869,0},	{500,0},	{537,0},	{534,0},
  {611,0},	{648,0},	{645,0},	{572,0},
  {609,0},	{756,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {793,0},	{830,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{682,0},
  {719,0},	{872,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0}
};

static struct patval joseki674[] = {
  {684,1},	{685,1},	{722,1},	{796,2},
  {721,2},	{758,2},	{793,0},	{719,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{608,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki675[] = {
  {760,1},	{758,1},	{796,1},	{721,1},
  {684,2},	{685,2},	{722,2},	{756,0},
  {534,0},	{608,0},	{867,0},	{498,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{645,0},
  {682,0},	{719,0},	{795,0},	{832,0},
  {869,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{793,0},	{830,0},
  {759,0},	{571,0},	{833,0},	{870,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{497,0},
  {797,0},	{834,0},	{871,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0}
};

static struct patval joseki676[] = {
  {870,1},	{833,1},	{684,1},	{832,1},
  {869,2},	{908,2},	{944,2},	{906,2},
  {867,0},	{682,0},	{719,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{647,0},	{978,0},
  {721,0},	{758,0},	{795,0},	{756,0},
  {793,0},	{830,0},	{943,0},	{980,0},
  {1017,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{904,0},	{941,0},
  {907,0},	{645,0},	{981,0},	{1018,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{1015,0},
  {945,0},	{982,0},	{1019,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0},	{946,0},
  {983,0},	{1020,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{947,0},	{984,0},
  {1021,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{985,0},	{1022,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {949,0},	{986,0},	{1023,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0},	{950,0},
  {987,0},	{1024,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0},
  {877,0},	{914,0},	{951,0},	{988,0},
  {1025,0}
};

static struct patval joseki677[] = {
  {870,1},	{833,1},	{684,1},	{832,1},
  {869,2},	{908,2},	{950,2},	{906,2},
  {944,2},	{682,0},	{719,0},	{646,0},
  {683,0},	{720,0},	{867,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{647,0},	{978,0},
  {721,0},	{758,0},	{795,0},	{756,0},
  {793,0},	{830,0},	{943,0},	{980,0},
  {1017,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{904,0},	{941,0},
  {907,0},	{645,0},	{981,0},	{1018,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{1015,0},
  {945,0},	{982,0},	{1019,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0},	{946,0},
  {983,0},	{1020,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{947,0},	{984,0},
  {1021,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{985,0},	{1022,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {949,0},	{986,0},	{1023,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0},	{757,0},
  {987,0},	{1024,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0},
  {877,0},	{914,0},	{951,0},	{988,0},
  {1025,0}
};

static struct patval joseki678[] = {
  {796,1},	{721,1},	{758,1},	{684,2},
  {722,2},	{719,0},	{645,0},	{793,0},
  {830,0},	{867,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {534,0},	{571,0},	{608,0},	{795,0},
  {832,0},	{869,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0}
};

static struct patval joseki679[] = {
  {722,1},	{684,1},	{648,1},	{758,2},
  {796,2},	{721,2},	{867,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{647,0},	{682,0},
  {830,0},	{756,0},	{795,0},	{832,0},
  {869,0},	{719,0},	{685,0},	{793,0},
  {759,0},	{645,0},	{833,0},	{870,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki680[] = {
  {758,1},	{721,1},	{798,1},	{796,1},
  {684,2},	{648,2},	{722,2},	{534,0},
  {608,0},	{645,0},	{830,0},	{867,0},
  {461,0},	{498,0},	{756,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{719,0},
  {460,0},	{795,0},	{832,0},	{869,0},
  {463,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{793,0},	{685,0},	{497,0},
  {759,0},	{571,0},	{833,0},	{870,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{535,0},	{835,0},	{872,0}
};

static struct patval joseki681[] = {
  {648,1},	{684,1},	{722,1},	{796,2},
  {758,2},	{721,2},	{830,0},	{719,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{793,0},
  {645,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{608,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki682[] = {
  {721,1},	{686,1},	{758,1},	{796,1},
  {684,2},	{648,2},	{722,2},	{719,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{793,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{608,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{645,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki683[] = {
  {648,1},	{684,1},	{723,1},	{722,1},
  {686,2},	{796,2},	{758,2},	{721,2},
  {719,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{793,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{608,0},	{685,0},	{609,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{645,0},	{682,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki684[] = {
  {722,1},	{687,1},	{684,1},	{759,1},
  {797,1},	{649,2},	{685,2},	{724,2},
  {723,2},	{647,0},	{720,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{868,0},	{794,0},
  {831,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{609,0},	{686,0},	{610,0},
  {760,0},	{757,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{646,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki685[] = {
  {649,1},	{688,1},	{724,1},	{723,1},
  {685,1},	{687,2},	{759,2},	{797,2},
  {722,2},	{684,2},	{720,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{868,0},	{794,0},
  {831,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{609,0},	{686,0},	{610,0},
  {760,0},	{757,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{646,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{647,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki686[] = {
  {759,1},	{724,1},	{721,1},	{684,1},
  {834,1},	{796,1},	{686,2},	{722,2},
  {760,2},	{725,2},	{761,2},	{758,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{757,0},	{905,0},	{831,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{723,0},	{647,0},
  {797,0},	{794,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{685,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki687[] = {
  {686,1},	{725,1},	{761,1},	{722,1},
  {835,1},	{760,1},	{796,2},	{684,2},
  {759,2},	{724,2},	{721,2},	{834,2},
  {795,0},	{832,0},	{869,0},	{758,0},
  {648,0},	{757,0},	{905,0},	{831,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{723,0},	{647,0},
  {797,0},	{906,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{794,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{685,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki688[] = {
  {759,1},	{724,1},	{721,1},	{684,1},
  {834,1},	{872,1},	{796,1},	{722,2},
  {760,2},	{725,2},	{761,2},	{686,2},
  {835,2},	{832,0},	{869,0},	{795,0},
  {648,0},	{757,0},	{905,0},	{758,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{723,0},	{647,0},
  {797,0},	{906,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{794,0},	{831,0},	{909,0},
  {651,0},	{688,0},	{685,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki689[] = {
  {722,1},	{687,1},	{684,1},	{759,1},
  {797,1},	{649,2},	{685,2},	{724,2},
  {723,2},	{647,0},	{720,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{868,0},	{794,0},
  {831,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{609,0},	{686,0},	{610,0},
  {760,0},	{757,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{646,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki690[] = {
  {686,1},	{684,1},	{761,1},	{760,1},
  {722,1},	{724,2},	{796,2},	{834,2},
  {759,2},	{721,2},	{757,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{905,0},	{831,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{723,0},	{647,0},
  {797,0},	{794,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki691[] = {
  {759,1},	{724,1},	{721,1},	{723,1},
  {834,1},	{796,1},	{686,2},	{684,2},
  {760,2},	{722,2},	{761,2},	{758,0},
  {757,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{795,0},	{831,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{905,0},	{647,0},
  {797,0},	{794,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki692[] = {
  {686,1},	{684,1},	{761,1},	{685,1},
  {722,1},	{760,1},	{796,2},	{723,2},
  {759,2},	{724,2},	{721,2},	{834,2},
  {758,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{757,0},	{795,0},	{831,0},
  {868,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{646,0},	{905,0},	{647,0},
  {797,0},	{794,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{683,0},	{720,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki693[] = {
  {721,1},	{686,1},	{758,1},	{796,1},
  {684,2},	{648,2},	{722,2},	{719,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{867,0},	{793,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{608,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{645,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki694[] = {
  {648,1},	{685,1},	{722,1},	{684,1},
  {686,2},	{721,2},	{758,2},	{796,2},
  {609,0},	{646,0},	{719,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{683,0},	{793,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{608,0},	{867,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{645,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki695[] = {
  {760,1},	{796,1},	{686,1},	{721,1},
  {758,1},	{684,2},	{722,2},	{685,2},
  {648,2},	{793,0},	{830,0},	{497,0},
  {461,0},	{498,0},	{460,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{534,0},	{571,0},
  {867,0},	{795,0},	{832,0},	{869,0},
  {463,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{608,0},	{535,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{645,0},	{723,0},
  {719,0},	{797,0},	{834,0},	{871,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki696[] = {
  {870,1},	{907,1},	{684,1},	{833,1},
  {869,1},	{871,2},	{943,2},	{945,2},
  {981,2},	{906,2},	{682,0},	{756,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{719,0},	{868,0},	{905,0},
  {942,0},	{979,0},	{1016,0},	{1053,0},
  {647,0},	{1015,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{793,0},	{830,0},
  {867,0},	{980,0},	{1017,0},	{1054,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{904,0},	{941,0},	{831,0},
  {944,0},	{645,0},	{1018,0},	{1055,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{978,0},	{908,0},
  {1052,0},	{982,0},	{1019,0},	{1056,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {946,0},	{983,0},	{1020,0},	{1057,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{984,0},	{1021,0},	{1058,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{985,0},	{1022,0},	{1059,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {949,0},	{986,0},	{1023,0},	{1060,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {950,0},	{987,0},	{1024,0},	{1061,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0},	{914,0},
  {951,0},	{988,0},	{1025,0},	{1062,0}
};

static struct patval joseki697[] = {
  {684,1},	{648,1},	{722,1},	{758,2},
  {721,2},	{796,2},	{719,0},	{830,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{645,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki698[] = {
  {760,1},	{796,1},	{758,1},	{721,1},
  {684,2},	{648,2},	{722,2},	{645,0},
  {497,0},	{793,0},	{830,0},	{460,0},
  {461,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{534,0},	{571,0},
  {867,0},	{795,0},	{832,0},	{869,0},
  {463,0},	{500,0},	{537,0},	{574,0},
  {611,0},	{608,0},	{685,0},	{682,0},
  {759,0},	{756,0},	{833,0},	{870,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {719,0},	{797,0},	{834,0},	{871,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki699[] = {
  {684,1},	{907,1},	{869,1},	{833,1},
  {906,2},	{945,2},	{981,2},	{943,2},
  {830,0},	{645,0},	{1015,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {942,0},	{979,0},	{1016,0},	{1053,0},
  {647,0},	{978,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{719,0},	{756,0},
  {1052,0},	{980,0},	{1017,0},	{1054,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{793,0},	{870,0},	{867,0},
  {944,0},	{941,0},	{1018,0},	{1055,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {904,0},	{982,0},	{1019,0},	{1056,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {946,0},	{983,0},	{1020,0},	{1057,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{984,0},	{1021,0},	{1058,0}
};

static struct patval joseki700[] = {
  {945,1},	{981,1},	{871,1},	{906,1},
  {943,1},	{869,2},	{907,2},	{684,2},
  {833,2},	{645,0},	{1015,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {942,0},	{979,0},	{1016,0},	{1053,0},
  {647,0},	{978,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{719,0},	{756,0},
  {1052,0},	{980,0},	{1017,0},	{1054,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{793,0},	{870,0},	{867,0},
  {944,0},	{941,0},	{1018,0},	{1055,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{830,0},	{908,0},
  {904,0},	{982,0},	{1019,0},	{1056,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {946,0},	{983,0},	{1020,0},	{1057,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {947,0},	{984,0},	{1021,0},	{1058,0}
};

static struct patval joseki701[] = {
  {759,1},	{684,1},	{685,2},	{719,0},
  {645,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{756,0},
  {722,0},	{608,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki702[] = {
  {722,1},	{685,1},	{759,2},	{684,2},
  {719,0},	{830,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{682,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{648,0},	{756,0},
  {793,0},	{645,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki703[] = {
  {721,1},	{759,1},	{684,1},	{685,2},
  {722,2},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{830,0},	{645,0},	{758,0},
  {795,0},	{832,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki704[] = {
  {760,1},	{685,1},	{722,1},	{721,2},
  {759,2},	{684,2},	{646,0},	{793,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{830,0},	{645,0},	{758,0},
  {795,0},	{832,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{756,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki705[] = {
  {684,1},	{721,1},	{758,1},	{759,1},
  {722,2},	{760,2},	{685,2},	{609,0},
  {646,0},	{793,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{830,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki706[] = {
  {760,1},	{648,1},	{685,1},	{722,1},
  {684,2},	{758,2},	{721,2},	{759,2},
  {756,0},	{609,0},	{572,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {793,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{608,0},	{645,0},
  {682,0},	{646,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{719,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki707[] = {
  {758,1},	{795,1},	{832,1},	{684,1},
  {833,1},	{796,2},	{722,2},	{759,2},
  {834,2},	{830,0},	{646,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {647,0},	{683,0},	{721,0},	{645,0},
  {867,0},	{904,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{682,0},	{719,0},
  {756,0},	{720,0},	{870,0},	{907,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{793,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0}
};

static struct patval joseki708[] = {
  {760,1},	{685,1},	{722,1},	{648,1},
  {721,2},	{684,2},	{759,2},	{758,2},
  {572,0},	{645,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{609,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{793,0},
  {830,0},	{608,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki709[] = {
  {758,1},	{797,1},	{721,1},	{684,1},
  {759,1},	{760,2},	{685,2},	{722,2},
  {648,2},	{645,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{609,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{793,0},
  {830,0},	{572,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki710[] = {
  {760,1},	{761,1},	{722,1},	{685,1},
  {648,1},	{721,2},	{684,2},	{758,2},
  {797,2},	{759,2},	{646,0},	{683,0},
  {720,0},	{645,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{609,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{793,0},
  {830,0},	{757,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{572,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki711[] = {
  {797,1},	{684,1},	{721,1},	{758,1},
  {798,1},	{759,1},	{760,2},	{761,2},
  {648,2},	{685,2},	{722,2},	{571,0},
  {572,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{608,0},
  {720,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{645,0},	{609,0},
  {646,0},	{683,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{756,0},	{793,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{682,0},	{719,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki712[] = {
  {722,1},	{762,1},	{760,1},	{648,1},
  {761,1},	{685,1},	{721,2},	{797,2},
  {758,2},	{684,2},	{759,2},	{798,2},
  {534,0},	{535,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {830,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{645,0},	{572,0},
  {609,0},	{646,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{756,0},	{793,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{682,0},
  {719,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {683,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki713[] = {
  {833,1},	{758,1},	{795,1},	{832,1},
  {871,1},	{872,1},	{684,1},	{835,2},
  {796,2},	{836,2},	{834,2},	{759,2},
  {722,2},	{572,0},	{571,0},	{867,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {573,0},	{610,0},	{647,0},	{757,0},
  {721,0},	{608,0},	{645,0},	{904,0},
  {869,0},	{906,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{682,0},	{609,0},
  {646,0},	{683,0},	{870,0},	{907,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{793,0},
  {830,0},	{908,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{719,0},	{756,0},	{909,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{720,0},
  {873,0},	{910,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0},	{912,0}
};

static struct patval joseki714[] = {
  {836,1},	{649,1},	{834,1},	{722,1},
  {835,1},	{796,1},	{759,1},	{795,2},
  {758,2},	{832,2},	{833,2},	{871,2},
  {872,2},	{684,2},	{867,0},	{572,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {573,0},	{610,0},	{647,0},	{757,0},
  {721,0},	{571,0},	{645,0},	{904,0},
  {869,0},	{906,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{682,0},	{609,0},
  {646,0},	{683,0},	{870,0},	{907,0},
  {575,0},	{612,0},	{608,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{793,0},
  {830,0},	{908,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{719,0},	{756,0},	{909,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{720,0},
  {873,0},	{910,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0},	{912,0}
};

static struct patval joseki715[] = {
  {722,1},	{760,1},	{685,1},	{684,2},
  {721,2},	{759,2},	{645,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {534,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{646,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{756,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki716[] = {
  {648,1},	{684,1},	{721,1},	{759,1},
  {685,2},	{722,2},	{760,2},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {534,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{645,0},	{682,0},
  {719,0},	{646,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{756,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki717[] = {
  {722,1},	{760,1},	{685,1},	{758,1},
  {721,2},	{759,2},	{684,2},	{648,2},
  {793,0},	{535,0},	{572,0},	{609,0},
  {534,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {830,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{645,0},	{682,0},
  {719,0},	{646,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{756,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki718[] = {
  {796,1},	{684,1},	{721,1},	{648,1},
  {759,1},	{722,2},	{685,2},	{760,2},
  {758,2},	{535,0},	{572,0},	{609,0},
  {534,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {830,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{645,0},	{682,0},
  {719,0},	{646,0},	{793,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{756,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki719[] = {
  {649,1},	{687,1},	{612,1},	{685,1},
  {684,1},	{648,2},	{611,2},	{723,2},
  {686,2},	{575,2},	{462,0},	{536,0},
  {461,0},	{610,0},	{647,0},	{499,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{572,0},	{609,0},
  {646,0},	{573,0},	{720,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki720[] = {
  {724,1},	{611,1},	{648,1},	{575,1},
  {723,1},	{686,1},	{649,2},	{687,2},
  {685,2},	{612,2},	{684,2},	{536,0},
  {461,0},	{462,0},	{647,0},	{499,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{572,0},	{609,0},
  {646,0},	{573,0},	{610,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki721[] = {
  {649,1},	{685,1},	{687,1},	{651,1},
  {612,1},	{684,1},	{648,2},	{724,2},
  {686,2},	{575,2},	{611,2},	{723,2},
  {461,0},	{536,0},	{647,0},	{499,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{609,0},
  {646,0},	{573,0},	{610,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki722[] = {
  {724,1},	{611,1},	{648,1},	{575,1},
  {688,1},	{723,1},	{686,1},	{687,2},
  {649,2},	{651,2},	{612,2},	{684,2},
  {685,2},	{461,0},	{647,0},	{536,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {646,0},	{573,0},	{610,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki723[] = {
  {574,1},	{685,1},	{687,1},	{651,1},
  {612,1},	{649,1},	{684,1},	{724,2},
  {648,2},	{575,2},	{688,2},	{611,2},
  {686,2},	{723,2},	{647,0},	{536,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {646,0},	{573,0},	{610,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki724[] = {
  {724,1},	{611,1},	{648,1},	{575,1},
  {688,1},	{650,1},	{686,1},	{723,1},
  {574,2},	{651,2},	{612,2},	{649,2},
  {684,2},	{685,2},	{647,0},	{573,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {536,0},	{683,0},	{610,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{646,0},	{687,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki725[] = {
  {574,1},	{612,1},	{684,1},	{651,1},
  {613,1},	{649,1},	{685,1},	{724,2},
  {648,2},	{575,2},	{611,2},	{650,2},
  {686,2},	{688,2},	{723,2},	{573,0},
  {721,0},	{758,0},	{647,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{535,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {536,0},	{683,0},	{463,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {610,0},	{646,0},	{687,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki726[] = {
  {724,1},	{611,1},	{614,1},	{575,1},
  {688,1},	{650,1},	{686,1},	{648,1},
  {723,1},	{651,2},	{612,2},	{574,2},
  {684,2},	{685,2},	{649,2},	{613,2},
  {721,0},	{758,0},	{573,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{647,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {536,0},	{683,0},	{463,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {610,0},	{646,0},	{687,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki727[] = {
  {574,1},	{612,1},	{684,1},	{651,1},
  {613,1},	{649,1},	{685,1},	{576,1},
  {614,2},	{575,2},	{611,2},	{650,2},
  {724,2},	{688,2},	{648,2},	{686,2},
  {723,2},	{758,0},	{721,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{647,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {536,0},	{683,0},	{463,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{573,0},
  {610,0},	{646,0},	{687,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki728[] = {
  {652,1},	{611,1},	{614,1},	{575,1},
  {688,1},	{650,1},	{686,1},	{724,1},
  {723,1},	{648,1},	{612,2},	{576,2},
  {574,2},	{685,2},	{649,2},	{684,2},
  {613,2},	{758,0},	{721,0},	{500,0},
  {537,0},	{461,0},	{498,0},	{647,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{462,0},	{499,0},
  {536,0},	{683,0},	{463,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{572,0},
  {610,0},	{646,0},	{687,0},	{720,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{535,0},	{651,0},	{609,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{573,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki729[] = {
  {687,1},	{651,1},	{612,1},	{649,1},
  {684,1},	{685,1},	{724,2},	{611,2},
  {648,2},	{686,2},	{723,2},	{575,2},
  {721,0},	{536,0},	{537,0},	{574,0},
  {535,0},	{573,0},	{758,0},	{722,0},
  {759,0},	{538,0},	{757,0},	{609,0},
  {646,0},	{610,0},	{647,0},	{760,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {683,0},	{720,0},	{761,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0}
};

static struct patval joseki730[] = {
  {760,1},	{722,1},	{685,1},	{721,2},
  {684,2},	{759,2},	{756,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {534,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{608,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{645,0},
  {682,0},	{646,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{719,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0}
};

static struct patval joseki731[] = {
  {684,1},	{721,1},	{758,1},	{796,1},
  {759,2},	{722,2},	{797,2},	{793,0},
  {867,0},	{572,0},	{609,0},	{646,0},
  {830,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{608,0},	{645,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{682,0},
  {719,0},	{683,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki732[] = {
  {797,1},	{759,1},	{685,1},	{722,1},
  {721,2},	{684,2},	{796,2},	{758,2},
  {793,0},	{572,0},	{609,0},	{646,0},
  {867,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{608,0},	{830,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{645,0},	{682,0},
  {719,0},	{683,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki733[] = {
  {684,1},	{648,1},	{758,1},	{721,1},
  {796,1},	{759,2},	{722,2},	{685,2},
  {797,2},	{572,0},	{609,0},	{646,0},
  {867,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{830,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{683,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki734[] = {
  {797,1},	{795,1},	{685,1},	{722,1},
  {759,1},	{684,2},	{721,2},	{758,2},
  {648,2},	{796,2},	{609,0},	{646,0},
  {572,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{830,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{683,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki735[] = {
  {684,1},	{648,1},	{758,1},	{721,1},
  {833,1},	{796,1},	{759,2},	{685,2},
  {795,2},	{797,2},	{722,2},	{646,0},
  {572,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{609,0},	{830,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{683,0},	{793,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki736[] = {
  {687,1},	{685,1},	{575,1},	{612,1},
  {649,1},	{684,1},	{574,2},	{648,2},
  {538,2},	{686,2},	{611,2},	{723,2},
  {462,0},	{610,0},	{647,0},	{536,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{461,0},	{499,0},	{720,0},
  {757,0},	{722,0},	{759,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{573,0},	{683,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{646,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0}
};

static struct patval joseki737[] = {
  {574,1},	{611,1},	{538,1},	{723,1},
  {722,1},	{648,1},	{686,1},	{575,2},
  {649,2},	{685,2},	{612,2},	{684,2},
  {687,2},	{499,0},	{573,0},	{610,0},
  {647,0},	{462,0},	{721,0},	{758,0},
  {426,0},	{463,0},	{500,0},	{537,0},
  {424,0},	{461,0},	{720,0},	{757,0},
  {425,0},	{759,0},	{427,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{536,0},	{683,0},	{760,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{646,0},
  {724,0},	{761,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0}
};

static struct patval joseki738[] = {
  {687,1},	{685,1},	{537,1},	{575,1},
  {612,1},	{649,1},	{684,1},	{723,2},
  {648,2},	{538,2},	{722,2},	{611,2},
  {574,2},	{686,2},	{573,0},	{610,0},
  {647,0},	{462,0},	{721,0},	{758,0},
  {426,0},	{463,0},	{500,0},	{499,0},
  {424,0},	{461,0},	{720,0},	{757,0},
  {425,0},	{759,0},	{427,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{536,0},	{683,0},	{760,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{646,0},
  {724,0},	{761,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{431,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki739[] = {
  {574,1},	{611,1},	{538,1},	{500,1},
  {722,1},	{648,1},	{686,1},	{723,1},
  {649,2},	{685,2},	{612,2},	{575,2},
  {537,2},	{687,2},	{684,2},	{610,0},
  {647,0},	{573,0},	{721,0},	{758,0},
  {426,0},	{463,0},	{462,0},	{499,0},
  {424,0},	{461,0},	{720,0},	{757,0},
  {425,0},	{759,0},	{427,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{536,0},	{683,0},	{760,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{646,0},
  {724,0},	{761,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{431,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki740[] = {
  {721,1},	{685,1},	{687,1},	{575,1},
  {612,1},	{649,1},	{684,1},	{537,1},
  {723,2},	{538,2},	{722,2},	{500,2},
  {648,2},	{686,2},	{574,2},	{611,2},
  {647,0},	{610,0},	{573,0},	{758,0},
  {426,0},	{463,0},	{462,0},	{499,0},
  {424,0},	{461,0},	{720,0},	{757,0},
  {425,0},	{759,0},	{427,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{536,0},	{683,0},	{760,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{646,0},
  {724,0},	{761,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{431,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki741[] = {
  {574,1},	{611,1},	{538,1},	{723,1},
  {722,1},	{500,1},	{686,1},	{724,1},
  {648,1},	{685,2},	{612,2},	{649,2},
  {537,2},	{687,2},	{575,2},	{721,2},
  {684,2},	{647,0},	{610,0},	{758,0},
  {426,0},	{463,0},	{462,0},	{499,0},
  {424,0},	{461,0},	{720,0},	{757,0},
  {425,0},	{759,0},	{427,0},	{464,0},
  {501,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{536,0},	{573,0},	{760,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{646,0},
  {683,0},	{761,0},	{429,0},	{466,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{431,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {432,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki742[] = {
  {685,1},	{869,1},	{833,1},	{684,1},
  {723,1},	{760,1},	{797,1},	{832,1},
  {835,1},	{722,2},	{759,2},	{686,2},
  {872,2},	{870,2},	{796,2},	{834,2},
  {871,2},	{648,2},	{795,0},	{610,0},
  {573,0},	{906,0},	{537,0},	{574,0},
  {611,0},	{758,0},	{535,0},	{572,0},
  {609,0},	{647,0},	{905,0},	{536,0},
  {907,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{721,0},	{908,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {831,0},	{868,0},	{909,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki743[] = {
  {871,1},	{722,1},	{759,1},	{686,1},
  {648,1},	{870,1},	{796,1},	{834,1},
  {721,1},	{872,1},	{723,2},	{760,2},
  {869,2},	{832,2},	{797,2},	{684,2},
  {685,2},	{833,2},	{835,2},	{610,0},
  {573,0},	{906,0},	{795,0},	{574,0},
  {611,0},	{758,0},	{535,0},	{572,0},
  {609,0},	{647,0},	{905,0},	{536,0},
  {907,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{537,0},	{908,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {831,0},	{868,0},	{909,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0},	{913,0}
};

static struct patval joseki744[] = {
  {797,1},	{872,1},	{869,1},	{722,1},
  {684,1},	{721,1},	{834,1},	{870,1},
  {760,1},	{906,1},	{833,2},	{871,2},
  {685,2},	{908,2},	{759,2},	{796,2},
  {758,2},	{723,2},	{907,2},	{909,2},
  {795,0},	{943,0},	{574,0},	{611,0},
  {648,0},	{610,0},	{905,0},	{720,0},
  {757,0},	{794,0},	{647,0},	{832,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{831,0},	{868,0},	{572,0},
  {942,0},	{573,0},	{683,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {609,0},	{646,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0}
};

static struct patval joseki745[] = {
  {908,1},	{759,1},	{796,1},	{723,1},
  {685,1},	{907,1},	{833,1},	{871,1},
  {758,1},	{909,1},	{832,1},	{797,2},
  {760,2},	{869,2},	{834,2},	{721,2},
  {722,2},	{870,2},	{906,2},	{872,2},
  {684,2},	{610,0},	{647,0},	{611,0},
  {648,0},	{795,0},	{572,0},	{609,0},
  {646,0},	{943,0},	{942,0},	{573,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki746[] = {
  {722,1},	{648,1},	{870,1},	{684,1},
  {760,1},	{797,1},	{834,1},	{721,1},
  {872,1},	{906,1},	{869,1},	{796,2},
  {759,2},	{909,2},	{723,2},	{871,2},
  {758,2},	{685,2},	{832,2},	{907,2},
  {908,2},	{833,2},	{610,0},	{611,0},
  {647,0},	{795,0},	{572,0},	{609,0},
  {646,0},	{943,0},	{942,0},	{573,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki747[] = {
  {908,1},	{759,1},	{796,1},	{723,1},
  {724,1},	{907,1},	{833,1},	{871,1},
  {758,1},	{909,1},	{685,1},	{832,1},
  {797,2},	{648,2},	{834,2},	{721,2},
  {722,2},	{870,2},	{760,2},	{869,2},
  {906,2},	{684,2},	{872,2},	{611,0},
  {647,0},	{795,0},	{572,0},	{609,0},
  {646,0},	{943,0},	{942,0},	{573,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{683,0},	{610,0},	{757,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki748[] = {
  {722,1},	{648,1},	{870,1},	{799,1},
  {760,1},	{797,1},	{834,1},	{721,1},
  {872,1},	{906,1},	{684,1},	{869,1},
  {759,2},	{909,2},	{796,2},	{871,2},
  {758,2},	{685,2},	{832,2},	{723,2},
  {724,2},	{833,2},	{908,2},	{907,2},
  {647,0},	{795,0},	{572,0},	{609,0},
  {646,0},	{943,0},	{942,0},	{611,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{573,0},	{610,0},	{757,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{683,0},	{836,0},	{873,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki749[] = {
  {907,1},	{759,1},	{796,1},	{723,1},
  {724,1},	{873,1},	{833,1},	{871,1},
  {908,1},	{909,1},	{685,1},	{758,1},
  {832,1},	{722,2},	{834,2},	{721,2},
  {797,2},	{870,2},	{760,2},	{869,2},
  {906,2},	{684,2},	{872,2},	{799,2},
  {648,2},	{795,0},	{572,0},	{609,0},
  {646,0},	{943,0},	{942,0},	{611,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{573,0},	{610,0},	{647,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{683,0},	{836,0},	{757,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki750[] = {
  {722,1},	{648,1},	{762,1},	{799,1},
  {760,1},	{797,1},	{834,1},	{721,1},
  {872,1},	{906,1},	{870,1},	{869,1},
  {684,1},	{873,2},	{759,2},	{871,2},
  {758,2},	{796,2},	{832,2},	{723,2},
  {724,2},	{833,2},	{908,2},	{907,2},
  {909,2},	{685,2},	{572,0},	{609,0},
  {795,0},	{943,0},	{942,0},	{611,0},
  {944,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{573,0},	{610,0},	{647,0},
  {794,0},	{831,0},	{574,0},	{945,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{835,0},
  {868,0},	{905,0},	{946,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{683,0},	{836,0},	{757,0},
  {910,0},	{947,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki751[] = {
  {685,1},	{833,1},	{759,1},	{796,1},
  {650,1},	{723,1},	{724,1},	{873,1},
  {907,1},	{871,1},	{908,1},	{909,1},
  {758,1},	{832,1},	{834,2},	{799,2},
  {722,2},	{762,2},	{648,2},	{869,2},
  {684,2},	{721,2},	{760,2},	{797,2},
  {870,2},	{872,2},	{906,2},	{943,0},
  {647,0},	{500,0},	{537,0},	{795,0},
  {611,0},	{610,0},	{461,0},	{498,0},
  {535,0},	{572,0},	{905,0},	{942,0},
  {462,0},	{944,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{499,0},	{536,0},	{574,0},
  {757,0},	{794,0},	{463,0},	{945,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{573,0},	{687,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{831,0},
  {868,0},	{946,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{609,0},	{646,0},
  {836,0},	{720,0},	{910,0},	{947,0},
  {467,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0}
};

static struct patval joseki752[] = {
  {906,1},	{722,1},	{870,1},	{684,1},
  {762,1},	{799,1},	{760,1},	{797,1},
  {834,1},	{537,1},	{872,1},	{869,1},
  {648,1},	{721,1},	{909,2},	{796,2},
  {724,2},	{650,2},	{833,2},	{723,2},
  {871,2},	{759,2},	{758,2},	{873,2},
  {832,2},	{907,2},	{685,2},	{908,2},
  {943,0},	{500,0},	{647,0},	{795,0},
  {611,0},	{610,0},	{461,0},	{498,0},
  {535,0},	{572,0},	{905,0},	{942,0},
  {462,0},	{944,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{499,0},	{536,0},	{574,0},
  {757,0},	{794,0},	{463,0},	{945,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{573,0},	{687,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{831,0},
  {868,0},	{946,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{609,0},	{646,0},
  {836,0},	{720,0},	{910,0},	{947,0},
  {467,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0}
};

static struct patval joseki753[] = {
  {908,1},	{871,1},	{689,1},	{685,1},
  {758,1},	{759,1},	{796,1},	{650,1},
  {723,1},	{724,1},	{832,1},	{873,1},
  {833,1},	{907,1},	{909,1},	{870,2},
  {872,2},	{684,2},	{762,2},	{760,2},
  {869,2},	{721,2},	{722,2},	{648,2},
  {797,2},	{834,2},	{906,2},	{537,2},
  {799,2},	{498,0},	{795,0},	{574,0},
  {500,0},	{535,0},	{572,0},	{573,0},
  {646,0},	{683,0},	{943,0},	{499,0},
  {536,0},	{944,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{610,0},	{647,0},	{831,0},
  {463,0},	{905,0},	{461,0},	{945,0},
  {465,0},	{502,0},	{539,0},	{609,0},
  {613,0},	{720,0},	{687,0},	{611,0},
  {761,0},	{798,0},	{835,0},	{942,0},
  {462,0},	{946,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{757,0},	{794,0},
  {836,0},	{868,0},	{910,0},	{947,0},
  {467,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{576,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0},	{470,0},	{507,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0},	{951,0},
  {471,0},	{508,0},	{545,0},	{582,0},
  {619,0},	{656,0},	{693,0},	{730,0},
  {767,0},	{804,0},	{841,0},	{878,0},
  {915,0},	{952,0}
};

static struct patval joseki754[] = {
  {834,1},	{869,1},	{648,1},	{802,1},
  {722,1},	{760,1},	{537,1},	{721,1},
  {762,1},	{799,1},	{797,1},	{870,1},
  {906,1},	{872,1},	{684,1},	{908,2},
  {907,2},	{689,2},	{723,2},	{759,2},
  {909,2},	{650,2},	{758,2},	{685,2},
  {832,2},	{873,2},	{871,2},	{833,2},
  {796,2},	{724,2},	{498,0},	{574,0},
  {500,0},	{535,0},	{795,0},	{573,0},
  {646,0},	{683,0},	{943,0},	{499,0},
  {536,0},	{944,0},	{464,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{610,0},	{647,0},	{831,0},
  {463,0},	{905,0},	{461,0},	{945,0},
  {465,0},	{502,0},	{539,0},	{609,0},
  {613,0},	{720,0},	{687,0},	{611,0},
  {761,0},	{798,0},	{835,0},	{942,0},
  {462,0},	{946,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{757,0},	{794,0},
  {836,0},	{868,0},	{910,0},	{947,0},
  {467,0},	{504,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{576,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {911,0},	{948,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0},	{875,0},	{912,0},	{949,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{572,0},	{839,0},	{876,0},
  {913,0},	{950,0},	{470,0},	{507,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0},	{877,0},	{914,0},	{951,0},
  {471,0},	{508,0},	{545,0},	{582,0},
  {619,0},	{656,0},	{693,0},	{730,0},
  {767,0},	{804,0},	{841,0},	{878,0},
  {915,0},	{952,0}
};

static struct patval joseki755[] = {
  {684,1},	{648,1},	{758,1},	{721,1},
  {796,1},	{759,2},	{722,2},	{685,2},
  {797,2},	{572,0},	{609,0},	{646,0},
  {867,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{793,0},	{830,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{683,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{756,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0}
};

static struct patval joseki756[] = {
  {760,1},	{722,1},	{685,1},	{721,2},
  {684,2},	{759,2},	{830,0},	{609,0},
  {646,0},	{793,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki757[] = {
  {684,1},	{721,1},	{797,1},	{759,1},
  {722,2},	{685,2},	{760,2},	{609,0},
  {646,0},	{830,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki758[] = {
  {796,1},	{760,1},	{685,1},	{722,1},
  {721,2},	{684,2},	{797,2},	{759,2},
  {646,0},	{609,0},	{830,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki759[] = {
  {684,1},	{721,1},	{758,1},	{797,1},
  {759,1},	{722,2},	{685,2},	{796,2},
  {760,2},	{646,0},	{609,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{830,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki760[] = {
  {760,1},	{722,1},	{685,1},	{798,1},
  {796,1},	{684,2},	{759,2},	{758,2},
  {797,2},	{721,2},	{793,0},	{572,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {608,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{645,0},
  {609,0},	{646,0},	{683,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{719,0},	{756,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{682,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki761[] = {
  {684,1},	{648,1},	{758,1},	{721,1},
  {759,1},	{797,1},	{798,2},	{685,2},
  {796,2},	{722,2},	{760,2},	{572,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {793,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{608,0},	{645,0},
  {609,0},	{646,0},	{683,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{719,0},	{756,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{682,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki762[] = {
  {760,1},	{685,1},	{796,1},	{722,1},
  {798,1},	{724,1},	{797,2},	{648,2},
  {759,2},	{721,2},	{758,2},	{684,2},
  {683,0},	{757,0},	{646,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{794,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{793,0},
  {720,0},	{572,0},	{645,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {830,0},	{761,0},	{609,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki763[] = {
  {687,1},	{648,1},	{758,1},	{721,1},
  {759,1},	{797,1},	{684,1},	{724,2},
  {798,2},	{760,2},	{796,2},	{685,2},
  {722,2},	{831,0},	{610,0},	{647,0},
  {609,0},	{794,0},	{757,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {719,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki764[] = {
  {688,1},	{724,1},	{685,1},	{798,1},
  {760,1},	{796,1},	{722,1},	{687,2},
  {648,2},	{759,2},	{797,2},	{758,2},
  {721,2},	{684,2},	{610,0},	{647,0},
  {831,0},	{794,0},	{757,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {719,0},	{835,0},	{614,0},	{651,0},
  {609,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki765[] = {
  {687,1},	{649,1},	{758,1},	{721,1},
  {759,1},	{797,1},	{648,1},	{684,1},
  {798,2},	{760,2},	{796,2},	{685,2},
  {722,2},	{724,2},	{688,2},	{647,0},
  {610,0},	{831,0},	{757,0},	{795,0},
  {832,0},	{611,0},	{830,0},	{682,0},
  {794,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{646,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {719,0},	{835,0},	{614,0},	{651,0},
  {609,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki766[] = {
  {688,1},	{724,1},	{685,1},	{798,1},
  {760,1},	{796,1},	{651,1},	{722,1},
  {687,2},	{759,2},	{797,2},	{758,2},
  {649,2},	{648,2},	{721,2},	{684,2},
  {647,0},	{610,0},	{757,0},	{795,0},
  {832,0},	{611,0},	{831,0},	{682,0},
  {794,0},	{683,0},	{720,0},	{833,0},
  {612,0},	{646,0},	{686,0},	{723,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {719,0},	{835,0},	{614,0},	{830,0},
  {609,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki767[] = {
  {687,1},	{649,1},	{758,1},	{723,1},
  {759,1},	{797,1},	{648,1},	{684,1},
  {721,1},	{760,2},	{798,2},	{685,2},
  {722,2},	{651,2},	{796,2},	{724,2},
  {688,2},	{647,0},	{757,0},	{795,0},
  {832,0},	{611,0},	{831,0},	{682,0},
  {794,0},	{683,0},	{610,0},	{833,0},
  {612,0},	{646,0},	{686,0},	{720,0},
  {756,0},	{793,0},	{834,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {719,0},	{835,0},	{614,0},	{830,0},
  {609,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki768[] = {
  {685,1},	{760,1},	{722,1},	{796,1},
  {688,1},	{798,1},	{724,1},	{797,2},
  {759,2},	{758,2},	{648,2},	{721,2},
  {687,2},	{684,2},	{793,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{794,0},
  {683,0},	{609,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{571,0},
  {720,0},	{757,0},	{682,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{608,0},	{645,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{830,0},
  {572,0},	{761,0},	{646,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{719,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0}
};

static struct patval joseki769[] = {
  {758,1},	{759,1},	{797,1},	{651,1},
  {721,1},	{648,1},	{684,1},	{687,1},
  {760,2},	{796,2},	{724,2},	{688,2},
  {722,2},	{798,2},	{685,2},	{793,0},
  {573,0},	{610,0},	{647,0},	{831,0},
  {683,0},	{794,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{571,0},
  {720,0},	{757,0},	{609,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{608,0},	{645,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{830,0},
  {572,0},	{761,0},	{646,0},	{835,0},
  {577,0},	{614,0},	{682,0},	{719,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0}
};

static struct patval joseki770[] = {
  {685,1},	{760,1},	{722,1},	{796,1},
  {688,1},	{689,1},	{798,1},	{724,1},
  {797,2},	{651,2},	{759,2},	{721,2},
  {648,2},	{687,2},	{758,2},	{684,2},
  {793,0},	{610,0},	{647,0},	{831,0},
  {683,0},	{794,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{571,0},
  {573,0},	{757,0},	{609,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{608,0},	{645,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{830,0},
  {572,0},	{761,0},	{646,0},	{835,0},
  {577,0},	{614,0},	{682,0},	{719,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{720,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0}
};

static struct patval joseki771[] = {
  {758,1},	{649,1},	{797,1},	{651,1},
  {721,1},	{648,1},	{684,1},	{687,1},
  {759,1},	{796,2},	{760,2},	{688,2},
  {689,2},	{724,2},	{685,2},	{798,2},
  {722,2},	{793,0},	{647,0},	{831,0},
  {683,0},	{794,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{571,0},
  {573,0},	{610,0},	{609,0},	{833,0},
  {575,0},	{612,0},	{757,0},	{686,0},
  {723,0},	{608,0},	{645,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{830,0},
  {572,0},	{761,0},	{646,0},	{835,0},
  {577,0},	{614,0},	{682,0},	{719,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{720,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0}
};

static struct patval joseki772[] = {
  {797,1},	{758,1},	{684,1},	{648,1},
  {687,1},	{721,1},	{759,1},	{796,2},
  {798,2},	{724,2},	{722,2},	{685,2},
  {760,2},	{646,0},	{610,0},	{647,0},
  {682,0},	{757,0},	{794,0},	{795,0},
  {832,0},	{611,0},	{719,0},	{683,0},
  {720,0},	{830,0},	{645,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {831,0},	{608,0},	{834,0},	{613,0},
  {650,0},	{756,0},	{793,0},	{761,0},
  {609,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki773[] = {
  {684,1},	{648,1},	{758,1},	{721,1},
  {759,1},	{797,1},	{798,2},	{724,2},
  {796,2},	{722,2},	{760,2},	{685,2},
  {720,0},	{572,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {793,0},	{757,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{830,0},	{645,0},
  {609,0},	{646,0},	{683,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{719,0},	{756,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {608,0},	{761,0},	{682,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki774[] = {
  {795,1},	{724,1},	{685,1},	{798,1},
  {760,1},	{796,1},	{722,1},	{648,2},
  {684,2},	{721,2},	{759,2},	{797,2},
  {758,2},	{720,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {793,0},	{757,0},	{572,0},	{832,0},
  {574,0},	{611,0},	{830,0},	{645,0},
  {609,0},	{646,0},	{683,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{719,0},	{756,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {608,0},	{761,0},	{682,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki775[] = {
  {760,1},	{795,1},	{796,1},	{722,1},
  {798,1},	{724,1},	{685,1},	{648,2},
  {759,2},	{721,2},	{797,2},	{758,2},
  {684,2},	{757,0},	{683,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{794,0},	{646,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{793,0},
  {720,0},	{572,0},	{645,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {830,0},	{761,0},	{609,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki776[] = {
  {758,1},	{797,1},	{687,1},	{684,1},
  {721,1},	{648,1},	{759,1},	{724,2},
  {796,2},	{798,2},	{795,2},	{685,2},
  {722,2},	{760,2},	{757,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{794,0},	{646,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{683,0},
  {720,0},	{572,0},	{645,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{793,0},
  {830,0},	{761,0},	{609,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki777[] = {
  {760,1},	{795,1},	{688,1},	{722,1},
  {798,1},	{796,1},	{685,1},	{724,1},
  {759,2},	{721,2},	{797,2},	{687,2},
  {684,2},	{758,2},	{648,2},	{831,0},
  {757,0},	{610,0},	{647,0},	{682,0},
  {719,0},	{573,0},	{646,0},	{832,0},
  {574,0},	{611,0},	{756,0},	{683,0},
  {720,0},	{572,0},	{794,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{793,0},
  {830,0},	{761,0},	{609,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{645,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki778[] = {
  {651,1},	{687,1},	{648,1},	{758,1},
  {684,1},	{759,1},	{797,1},	{721,1},
  {760,2},	{798,2},	{722,2},	{685,2},
  {796,2},	{795,2},	{688,2},	{724,2},
  {573,0},	{610,0},	{647,0},	{757,0},
  {794,0},	{830,0},	{571,0},	{832,0},
  {574,0},	{611,0},	{831,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{756,0},	{793,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {645,0},	{761,0},	{719,0},	{835,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki779[] = {
  {798,1},	{688,1},	{724,1},	{685,1},
  {689,1},	{760,1},	{796,1},	{722,1},
  {795,1},	{687,2},	{758,2},	{759,2},
  {797,2},	{684,2},	{651,2},	{648,2},
  {721,2},	{610,0},	{647,0},	{757,0},
  {573,0},	{830,0},	{571,0},	{832,0},
  {574,0},	{611,0},	{831,0},	{682,0},
  {646,0},	{683,0},	{720,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{756,0},	{793,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {645,0},	{761,0},	{794,0},	{835,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{719,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki780[] = {
  {651,1},	{687,1},	{649,1},	{758,1},
  {648,1},	{759,1},	{797,1},	{684,1},
  {721,1},	{798,2},	{724,2},	{685,2},
  {689,2},	{760,2},	{722,2},	{796,2},
  {795,2},	{688,2},	{647,0},	{757,0},
  {610,0},	{830,0},	{573,0},	{832,0},
  {574,0},	{611,0},	{831,0},	{682,0},
  {571,0},	{683,0},	{720,0},	{833,0},
  {575,0},	{612,0},	{646,0},	{686,0},
  {723,0},	{756,0},	{793,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{608,0},
  {645,0},	{761,0},	{794,0},	{835,0},
  {577,0},	{614,0},	{572,0},	{609,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{719,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki781[] = {
  {798,1},	{760,1},	{723,1},	{724,1},
  {685,1},	{689,1},	{688,1},	{796,1},
  {722,1},	{795,1},	{651,2},	{758,2},
  {649,2},	{797,2},	{687,2},	{648,2},
  {684,2},	{759,2},	{721,2},	{757,0},
  {610,0},	{647,0},	{571,0},	{573,0},
  {830,0},	{536,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{535,0},	{682,0},
  {534,0},	{831,0},	{683,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{646,0},
  {686,0},	{720,0},	{756,0},	{793,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{645,0},	{761,0},
  {794,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{572,0},	{609,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{719,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki782[] = {
  {760,1},	{722,1},	{685,1},	{721,2},
  {684,2},	{759,2},	{830,0},	{609,0},
  {646,0},	{793,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{645,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{683,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki783[] = {
  {684,1},	{758,2},	{570,0},	{681,0},
  {718,0},	{755,0},	{644,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki784[] = {
  {723,1},	{758,1},	{684,2},	{681,0},
  {718,0},	{755,0},	{644,0},	{570,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {829,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki785[] = {
  {684,1},	{611,1},	{650,2},	{685,2},
  {645,0},	{682,0},	{608,0},	{571,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{497,0},	{721,0},	{758,0},
  {500,0},	{537,0},	{574,0},	{719,0},
  {648,0},	{534,0},	{722,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {756,0},	{687,0},	{724,0},	{761,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki786[] = {
  {650,1},	{685,1},	{721,1},	{611,2},
  {684,2},	{682,0},	{645,0},	{571,0},
  {498,0},	{535,0},	{608,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{497,0},	{572,0},	{758,0},
  {500,0},	{537,0},	{574,0},	{719,0},
  {648,0},	{534,0},	{722,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {756,0},	{687,0},	{724,0},	{761,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0}
};

static struct patval joseki787[] = {
  {721,1},	{648,1},	{684,1},	{758,2},
  {687,2},	{722,2},	{719,0},	{608,0},
  {535,0},	{572,0},	{645,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{534,0},	{609,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{756,0},
  {685,0},	{571,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {793,0},	{724,0},	{761,0},	{798,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0}
};

static struct patval joseki788[] = {
  {722,1},	{760,1},	{687,1},	{758,1},
  {721,2},	{648,2},	{684,2},	{645,0},
  {460,0},	{793,0},	{497,0},	{498,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{571,0},
  {461,0},	{795,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{611,0},	{608,0},
  {685,0},	{682,0},	{759,0},	{796,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {719,0},	{797,0},	{465,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {534,0},	{724,0},	{761,0},	{798,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0}
};

static struct patval joseki789[] = {
  {687,1},	{760,1},	{758,1},	{722,1},
  {721,2},	{684,2},	{648,2},	{645,0},
  {571,0},	{719,0},	{535,0},	{608,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{682,0},
  {497,0},	{572,0},	{795,0},	{500,0},
  {537,0},	{574,0},	{611,0},	{756,0},
  {685,0},	{498,0},	{759,0},	{796,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{534,0},
  {797,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{793,0},	{724,0},
  {761,0},	{798,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0}
};

static struct patval joseki790[] = {
  {648,1},	{721,1},	{684,1},	{687,2},
  {758,2},	{722,2},	{719,0},	{497,0},
  {534,0},	{498,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{756,0},
  {793,0},	{645,0},	{795,0},	{500,0},
  {537,0},	{574,0},	{611,0},	{608,0},
  {685,0},	{682,0},	{759,0},	{796,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{571,0},	{724,0},
  {761,0},	{798,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0}
};

static struct patval joseki791[] = {
  {684,1},	{685,1},	{614,1},	{649,1},
  {648,2},	{611,2},	{575,2},	{424,0},
  {572,0},	{720,0},	{646,0},	{425,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{387,0},	{721,0},
  {389,0},	{426,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{683,0},	{498,0},
  {388,0},	{722,0},	{390,0},	{427,0},
  {464,0},	{501,0},	{538,0},	{535,0},
  {612,0},	{609,0},	{686,0},	{723,0},
  {391,0},	{428,0},	{465,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {461,0},	{651,0},	{688,0},	{725,0},
  {393,0},	{430,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0}
};

static struct patval joseki792[] = {
  {426,1},	{648,1},	{575,1},	{611,1},
  {649,2},	{685,2},	{614,2},	{684,2},
  {683,0},	{424,0},	{388,0},	{425,0},
  {498,0},	{499,0},	{535,0},	{573,0},
  {610,0},	{647,0},	{461,0},	{721,0},
  {389,0},	{720,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{572,0},	{609,0},
  {462,0},	{722,0},	{390,0},	{427,0},
  {464,0},	{501,0},	{538,0},	{536,0},
  {612,0},	{387,0},	{686,0},	{723,0},
  {391,0},	{428,0},	{465,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {646,0},	{651,0},	{688,0},	{725,0},
  {393,0},	{430,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{394,0},	{431,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {395,0},	{432,0},	{469,0},	{506,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{396,0},	{433,0},
  {470,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {397,0},	{434,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0}
};

static struct patval joseki793[] = {
  {614,1},	{649,1},	{684,1},	{685,1},
  {648,2},	{611,2},	{575,2},	{646,0},
  {572,0},	{425,0},	{462,0},	{535,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {498,0},	{721,0},	{426,0},	{463,0},
  {500,0},	{537,0},	{574,0},	{609,0},
  {424,0},	{499,0},	{722,0},	{427,0},
  {464,0},	{501,0},	{538,0},	{683,0},
  {612,0},	{461,0},	{686,0},	{723,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{429,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{720,0},	{651,0},
  {688,0},	{725,0},	{430,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{431,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0}
};

static struct patval joseki794[] = {
  {575,1},	{463,1},	{648,1},	{611,1},
  {649,2},	{685,2},	{684,2},	{614,2},
  {683,0},	{535,0},	{388,0},	{425,0},
  {498,0},	{499,0},	{720,0},	{573,0},
  {610,0},	{647,0},	{461,0},	{721,0},
  {389,0},	{426,0},	{424,0},	{500,0},
  {537,0},	{574,0},	{572,0},	{609,0},
  {462,0},	{722,0},	{390,0},	{427,0},
  {464,0},	{501,0},	{538,0},	{536,0},
  {612,0},	{387,0},	{686,0},	{723,0},
  {391,0},	{428,0},	{465,0},	{502,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{392,0},	{429,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {646,0},	{651,0},	{688,0},	{725,0},
  {393,0},	{430,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{394,0},	{431,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {395,0},	{432,0},	{469,0},	{506,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{396,0},	{433,0},
  {470,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {397,0},	{434,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0}
};

static struct patval joseki795[] = {
  {723,1},	{758,1},	{684,2},	{681,0},
  {718,0},	{755,0},	{644,0},	{570,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {829,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki796[] = {
  {723,1},	{758,1},	{684,2},	{681,0},
  {718,0},	{755,0},	{644,0},	{570,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {829,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki797[] = {
  {684,1},	{758,2},	{607,0},	{681,0},
  {570,0},	{755,0},	{792,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{644,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki798[] = {
  {758,1},	{685,1},	{684,2},	{681,0},
  {607,0},	{755,0},	{792,0},	{829,0},
  {570,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{644,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki799[] = {
  {684,1},	{648,1},	{685,2},	{758,2},
  {681,0},	{755,0},	{792,0},	{829,0},
  {570,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{607,0},	{644,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki800[] = {
  {758,1},	{722,1},	{685,1},	{648,2},
  {684,2},	{533,0},	{755,0},	{792,0},
  {829,0},	{534,0},	{570,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {537,0},	{574,0},	{611,0},	{607,0},
  {644,0},	{681,0},	{759,0},	{796,0},
  {833,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0}
};

static struct patval joseki801[] = {
  {758,1},	{684,1},	{722,1},	{832,2},
  {796,2},	{759,2},	{829,0},	{866,0},
  {903,0},	{608,0},	{607,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {867,0},	{904,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{610,0},
  {647,0},	{644,0},	{721,0},	{645,0},
  {795,0},	{792,0},	{869,0},	{906,0},
  {611,0},	{648,0},	{685,0},	{681,0},
  {718,0},	{755,0},	{833,0},	{870,0},
  {907,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {871,0},	{908,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0}
};

static struct patval joseki802[] = {
  {759,1},	{684,1},	{723,1},	{686,1},
  {649,2},	{685,2},	{611,2},	{793,0},
  {830,0},	{535,0},	{534,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{571,0},	{648,0},	{572,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{608,0},
  {645,0},	{682,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0}
};

static struct patval joseki803[] = {
  {758,1},	{686,1},	{685,1},	{648,2},
  {684,2},	{681,0},	{755,0},	{792,0},
  {829,0},	{534,0},	{533,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{571,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {537,0},	{574,0},	{611,0},	{607,0},
  {644,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{570,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0}
};

static struct patval joseki804[] = {
  {684,1},	{722,1},	{758,1},	{760,2},
  {832,2},	{759,2},	{755,0},	{903,0},
  {829,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{867,0},	{904,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {647,0},	{866,0},	{721,0},	{645,0},
  {795,0},	{792,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{681,0},	{718,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {649,0},	{686,0},	{723,0},	{644,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0}
};

static struct patval joseki805[] = {
  {832,1},	{760,1},	{795,1},	{759,1},
  {722,2},	{758,2},	{684,2},	{866,0},
  {829,0},	{608,0},	{607,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {867,0},	{904,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{610,0},
  {647,0},	{903,0},	{721,0},	{645,0},
  {755,0},	{792,0},	{869,0},	{906,0},
  {611,0},	{648,0},	{685,0},	{681,0},
  {718,0},	{796,0},	{833,0},	{870,0},
  {907,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{644,0},	{797,0},	{834,0},
  {871,0},	{908,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0}
};

static struct patval joseki806[] = {
  {795,1},	{684,1},	{722,1},	{685,2},
  {721,2},	{829,0},	{755,0},	{644,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{647,0},	{866,0},	{645,0},
  {758,0},	{792,0},	{832,0},	{869,0},
  {648,0},	{681,0},	{718,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0}
};

static struct patval joseki807[] = {
  {722,1},	{795,1},	{723,1},	{684,1},
  {685,2},	{759,2},	{721,2},	{607,0},
  {718,0},	{645,0},	{682,0},	{681,0},
  {756,0},	{755,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{792,0},	{719,0},
  {758,0},	{644,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{793,0},	{866,0},
  {608,0},	{796,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{829,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki808[] = {
  {722,1},	{795,1},	{648,1},	{723,1},
  {684,1},	{758,2},	{721,2},	{759,2},
  {685,2},	{755,0},	{608,0},	{645,0},
  {681,0},	{644,0},	{756,0},	{718,0},
  {830,0},	{867,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{719,0},
  {570,0},	{607,0},	{832,0},	{869,0},
  {574,0},	{611,0},	{792,0},	{793,0},
  {866,0},	{571,0},	{796,0},	{833,0},
  {870,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{829,0},	{760,0},	{797,0},
  {834,0},	{871,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0}
};

static struct patval joseki809[] = {
  {649,1},	{796,1},	{723,1},	{724,1},
  {685,1},	{687,1},	{760,2},	{684,2},
  {722,2},	{759,2},	{756,0},	{646,0},
  {719,0},	{645,0},	{609,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{648,0},	{683,0},	{720,0},
  {571,0},	{608,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{757,0},	{686,0},
  {867,0},	{572,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {793,0},	{830,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki810[] = {
  {723,1},	{724,1},	{685,1},	{796,1},
  {648,1},	{649,1},	{684,2},	{760,2},
  {686,2},	{759,2},	{722,2},	{720,0},
  {757,0},	{830,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{867,0},	{609,0},	{794,0},
  {683,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{646,0},	{682,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{645,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki811[] = {
  {684,1},	{758,2},	{607,0},	{644,0},
  {533,0},	{718,0},	{570,0},	{792,0},
  {829,0},	{534,0},	{571,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{535,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{681,0},
  {721,0},	{755,0},	{795,0},	{832,0},
  {537,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {833,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0}
};

static struct patval joseki812[] = {
  {869,1},	{684,1},	{795,2},	{755,0},
  {644,0},	{829,0},	{718,0},	{903,0},
  {940,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{792,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki813[] = {
  {795,1},	{797,1},	{684,2},	{869,2},
  {644,0},	{829,0},	{755,0},	{903,0},
  {940,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{792,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki814[] = {
  {871,1},	{684,1},	{869,1},	{795,2},
  {797,2},	{829,0},	{644,0},	{903,0},
  {940,0},	{645,0},	{755,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki815[] = {
  {799,1},	{795,1},	{797,1},	{871,2},
  {684,2},	{869,2},	{644,0},	{903,0},
  {940,0},	{645,0},	{755,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{829,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki816[] = {
  {869,1},	{873,1},	{684,1},	{871,1},
  {797,2},	{799,2},	{795,2},	{718,0},
  {866,0},	{792,0},	{940,0},	{571,0},
  {608,0},	{607,0},	{682,0},	{570,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {942,0},	{573,0},	{610,0},	{647,0},
  {644,0},	{721,0},	{758,0},	{645,0},
  {832,0},	{719,0},	{906,0},	{943,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {870,0},	{907,0},	{944,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{681,0},	{834,0},	{755,0},
  {908,0},	{945,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {946,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{829,0},
  {836,0},	{903,0},	{910,0},	{947,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {874,0},	{911,0},	{948,0}
};

static struct patval joseki817[] = {
  {795,1},	{797,1},	{684,2},	{869,2},
  {644,0},	{829,0},	{755,0},	{903,0},
  {940,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{792,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki818[] = {
  {684,1},	{872,1},	{869,1},	{797,2},
  {795,2},	{755,0},	{866,0},	{681,0},
  {829,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {792,0},	{721,0},	{758,0},	{644,0},
  {832,0},	{718,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{940,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {903,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {912,0},	{949,0}
};

static struct patval joseki819[] = {
  {795,1},	{799,1},	{797,1},	{869,2},
  {684,2},	{872,2},	{866,0},	{755,0},
  {792,0},	{681,0},	{682,0},	{644,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {940,0},	{721,0},	{758,0},	{719,0},
  {832,0},	{903,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{829,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {718,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{645,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {912,0},	{949,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki820[] = {
  {869,1},	{872,1},	{684,1},	{837,1},
  {795,2},	{797,2},	{799,2},	{681,0},
  {792,0},	{570,0},	{533,0},	{903,0},
  {940,0},	{497,0},	{534,0},	{718,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {755,0},	{721,0},	{758,0},	{866,0},
  {832,0},	{496,0},	{906,0},	{943,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{829,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {644,0},	{909,0},	{946,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{571,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{607,0},	{874,0},	{911,0},
  {948,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {912,0},	{949,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0},	{950,0}
};

static struct patval joseki821[] = {
  {869,1},	{684,1},	{795,2},	{755,0},
  {644,0},	{829,0},	{718,0},	{903,0},
  {940,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{792,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki822[] = {
  {835,1},	{795,1},	{869,2},	{684,2},
  {755,0},	{829,0},	{718,0},	{903,0},
  {940,0},	{645,0},	{682,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{792,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki823[] = {
  {796,1},	{684,1},	{869,1},	{795,2},
  {835,2},	{829,0},	{718,0},	{903,0},
  {940,0},	{645,0},	{755,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {792,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki824[] = {
  {835,1},	{795,1},	{759,1},	{869,2},
  {684,2},	{796,2},	{718,0},	{903,0},
  {940,0},	{645,0},	{829,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {792,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki825[] = {
  {796,1},	{684,1},	{797,1},	{869,1},
  {835,2},	{795,2},	{759,2},	{903,0},
  {940,0},	{645,0},	{829,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {832,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {792,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki826[] = {
  {835,1},	{832,1},	{795,1},	{759,1},
  {797,2},	{684,2},	{869,2},	{796,2},
  {940,0},	{645,0},	{903,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {792,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki827[] = {
  {833,1},	{684,1},	{797,1},	{869,1},
  {796,1},	{835,2},	{759,2},	{832,2},
  {795,2},	{645,0},	{940,0},	{903,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {719,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {792,0},	{829,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki828[] = {
  {651,1},	{684,1},	{648,1},	{575,1},
  {611,1},	{613,2},	{685,2},	{649,2},
  {500,2},	{612,2},	{461,0},	{719,0},
  {460,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {497,0},	{537,0},	{574,0},	{498,0},
  {535,0},	{682,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {608,0},	{645,0},	{686,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{534,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki829[] = {
  {685,1},	{500,1},	{613,1},	{686,1},
  {612,1},	{649,1},	{575,2},	{648,2},
  {684,2},	{651,2},	{611,2},	{719,0},
  {461,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{460,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {497,0},	{537,0},	{574,0},	{498,0},
  {535,0},	{757,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{534,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki830[] = {
  {684,1},	{795,1},	{759,1},	{686,1},
  {722,1},	{762,1},	{797,2},	{724,2},
  {611,2},	{796,2},	{723,2},	{760,2},
  {572,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{830,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {608,0},	{648,0},	{685,0},	{609,0},
  {646,0},	{868,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{683,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0}
};

static struct patval joseki831[] = {
  {796,1},	{611,1},	{724,1},	{797,1},
  {723,1},	{760,1},	{832,1},	{684,2},
  {795,2},	{686,2},	{722,2},	{759,2},
  {762,2},	{720,0},	{757,0},	{794,0},
  {831,0},	{830,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{572,0},	{869,0},	{574,0},
  {608,0},	{648,0},	{685,0},	{609,0},
  {646,0},	{868,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{683,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0}
};

static struct patval joseki832[] = {
  {835,1},	{832,1},	{795,1},	{759,1},
  {797,2},	{684,2},	{869,2},	{796,2},
  {940,0},	{645,0},	{903,0},	{719,0},
  {644,0},	{793,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {792,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{871,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki833[] = {
  {871,1},	{684,1},	{797,1},	{869,1},
  {796,1},	{832,2},	{759,2},	{795,2},
  {835,2},	{645,0},	{903,0},	{719,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki834[] = {
  {651,1},	{684,1},	{648,1},	{575,1},
  {611,1},	{613,2},	{685,2},	{687,2},
  {500,2},	{612,2},	{719,0},	{535,0},
  {460,0},	{461,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {497,0},	{537,0},	{574,0},	{498,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {609,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{534,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki835[] = {
  {685,1},	{500,1},	{613,1},	{686,1},
  {687,1},	{612,1},	{575,2},	{611,2},
  {648,2},	{684,2},	{651,2},	{535,0},
  {719,0},	{461,0},	{646,0},	{683,0},
  {720,0},	{460,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {497,0},	{537,0},	{574,0},	{498,0},
  {645,0},	{757,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {609,0},	{649,0},	{682,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{534,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki836[] = {
  {684,1},	{795,1},	{759,1},	{686,1},
  {722,1},	{762,1},	{797,2},	{724,2},
  {611,2},	{723,2},	{798,2},	{796,2},
  {646,0},	{572,0},	{757,0},	{794,0},
  {831,0},	{830,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{832,0},	{869,0},	{574,0},
  {608,0},	{648,0},	{685,0},	{609,0},
  {756,0},	{868,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {720,0},	{760,0},	{793,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{683,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0}
};

static struct patval joseki837[] = {
  {796,1},	{611,1},	{724,1},	{797,1},
  {798,1},	{832,1},	{723,1},	{684,2},
  {686,2},	{759,2},	{722,2},	{795,2},
  {762,2},	{646,0},	{757,0},	{794,0},
  {831,0},	{830,0},	{573,0},	{610,0},
  {647,0},	{571,0},	{721,0},	{758,0},
  {867,0},	{572,0},	{869,0},	{574,0},
  {608,0},	{648,0},	{685,0},	{609,0},
  {756,0},	{868,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{682,0},
  {720,0},	{760,0},	{793,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{761,0},	{719,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{683,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0}
};

static struct patval joseki838[] = {
  {684,1},	{652,1},	{574,1},	{612,1},
  {685,1},	{576,1},	{649,1},	{688,2},
  {687,2},	{614,2},	{501,2},	{722,2},
  {613,2},	{686,2},	{462,0},	{572,0},
  {721,0},	{758,0},	{647,0},	{500,0},
  {537,0},	{461,0},	{611,0},	{648,0},
  {609,0},	{499,0},	{759,0},	{464,0},
  {535,0},	{538,0},	{575,0},	{536,0},
  {573,0},	{463,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{610,0},
  {683,0},	{650,0},	{757,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{646,0},	{651,0},	{720,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{498,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{470,0},	{507,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0}
};

static struct patval joseki839[] = {
  {574,1},	{652,1},	{576,1},	{612,1},
  {649,1},	{685,1},	{684,1},	{501,2},
  {687,2},	{722,2},	{613,2},	{688,2},
  {686,2},	{614,2},	{610,0},	{683,0},
  {721,0},	{758,0},	{463,0},	{498,0},
  {537,0},	{647,0},	{611,0},	{648,0},
  {757,0},	{462,0},	{759,0},	{464,0},
  {720,0},	{538,0},	{575,0},	{500,0},
  {609,0},	{573,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{536,0},
  {572,0},	{650,0},	{646,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{461,0},	{651,0},	{535,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{499,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{470,0},	{507,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0},	{472,0},
  {509,0},	{546,0},	{583,0},	{620,0},
  {657,0},	{694,0},	{731,0},	{768,0}
};

static struct patval joseki840[] = {
  {612,1},	{649,1},	{685,1},	{574,1},
  {684,1},	{576,1},	{652,1},	{722,2},
  {688,2},	{613,2},	{686,2},	{501,2},
  {687,2},	{614,2},	{573,0},	{536,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{646,0},	{611,0},	{648,0},
  {610,0},	{720,0},	{759,0},	{464,0},
  {609,0},	{538,0},	{575,0},	{461,0},
  {647,0},	{535,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{572,0},
  {462,0},	{650,0},	{498,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{757,0},	{651,0},	{499,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{683,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{470,0},	{507,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0},	{472,0},
  {509,0},	{546,0},	{583,0},	{620,0},
  {657,0},	{694,0},	{731,0},	{768,0},
  {473,0},	{510,0},	{547,0},	{584,0},
  {621,0},	{658,0},	{695,0},	{732,0},
  {769,0}
};

static struct patval joseki841[] = {
  {871,1},	{684,1},	{797,1},	{869,1},
  {796,1},	{832,2},	{759,2},	{795,2},
  {835,2},	{645,0},	{903,0},	{719,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki842[] = {
  {835,1},	{760,1},	{832,1},	{759,1},
  {795,1},	{797,2},	{869,2},	{684,2},
  {796,2},	{871,2},	{645,0},	{719,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {903,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {681,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki843[] = {
  {871,1},	{684,1},	{797,1},	{869,1},
  {796,1},	{798,1},	{759,2},	{832,2},
  {835,2},	{760,2},	{795,2},	{645,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {903,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {681,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{719,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki844[] = {
  {651,1},	{576,1},	{648,1},	{575,1},
  {611,1},	{684,1},	{685,2},	{500,2},
  {613,2},	{612,2},	{687,2},	{614,2},
  {460,0},	{461,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {719,0},	{537,0},	{574,0},	{498,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {609,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {497,0},	{534,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki845[] = {
  {685,1},	{500,1},	{613,1},	{686,1},
  {687,1},	{612,1},	{614,1},	{575,2},
  {648,2},	{684,2},	{611,2},	{576,2},
  {651,2},	{461,0},	{646,0},	{683,0},
  {720,0},	{460,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {719,0},	{537,0},	{574,0},	{498,0},
  {645,0},	{757,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {609,0},	{649,0},	{682,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {497,0},	{534,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki846[] = {
  {649,1},	{686,1},	{722,1},	{684,1},
  {613,1},	{614,1},	{689,1},	{652,2},
  {538,2},	{650,2},	{723,2},	{651,2},
  {724,2},	{725,2},	{609,0},	{573,0},
  {758,0},	{795,0},	{610,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {647,0},	{759,0},	{796,0},	{501,0},
  {646,0},	{575,0},	{612,0},	{498,0},
  {500,0},	{572,0},	{760,0},	{797,0},
  {502,0},	{539,0},	{576,0},	{721,0},
  {499,0},	{687,0},	{535,0},	{761,0},
  {798,0},	{503,0},	{540,0},	{577,0},
  {757,0},	{794,0},	{688,0},	{536,0},
  {762,0},	{799,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{683,0},	{720,0},
  {726,0},	{763,0},	{800,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{508,0},	{545,0},
  {582,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{509,0},
  {546,0},	{583,0},	{620,0},	{657,0},
  {694,0},	{731,0},	{768,0},	{805,0},
  {510,0},	{547,0},	{584,0},	{621,0},
  {658,0},	{695,0},	{732,0},	{769,0},
  {806,0}
};

static struct patval joseki847[] = {
  {684,1},	{689,1},	{613,1},	{649,1},
  {686,1},	{722,1},	{614,1},	{538,2},
  {651,2},	{652,2},	{650,2},	{725,2},
  {723,2},	{724,2},	{647,0},	{535,0},
  {758,0},	{795,0},	{720,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {794,0},	{759,0},	{796,0},	{501,0},
  {757,0},	{575,0},	{612,0},	{721,0},
  {646,0},	{610,0},	{760,0},	{797,0},
  {502,0},	{539,0},	{576,0},	{500,0},
  {609,0},	{687,0},	{683,0},	{761,0},
  {798,0},	{503,0},	{540,0},	{577,0},
  {573,0},	{498,0},	{688,0},	{572,0},
  {762,0},	{799,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{499,0},	{536,0},
  {726,0},	{763,0},	{800,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{508,0},	{545,0},
  {582,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{509,0},
  {546,0},	{583,0},	{620,0},	{657,0},
  {694,0},	{731,0},	{768,0},	{805,0}
};

static struct patval joseki848[] = {
  {685,1},	{500,1},	{613,1},	{686,1},
  {687,1},	{612,1},	{614,1},	{575,2},
  {648,2},	{684,2},	{611,2},	{576,2},
  {651,2},	{461,0},	{646,0},	{683,0},
  {720,0},	{460,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{463,0},
  {719,0},	{537,0},	{574,0},	{498,0},
  {645,0},	{757,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{571,0},
  {609,0},	{649,0},	{682,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {497,0},	{534,0},	{650,0},	{608,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{572,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki849[] = {
  {611,1},	{648,1},	{684,1},	{721,1},
  {575,1},	{576,1},	{651,1},	{614,2},
  {500,2},	{612,2},	{685,2},	{686,2},
  {613,2},	{687,2},	{571,0},	{572,0},
  {720,0},	{757,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {609,0},	{535,0},	{758,0},	{463,0},
  {608,0},	{537,0},	{574,0},	{460,0},
  {646,0},	{534,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{683,0},
  {461,0},	{649,0},	{497,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {719,0},	{756,0},	{650,0},	{498,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{645,0},	{682,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki850[] = {
  {613,1},	{686,1},	{685,1},	{612,1},
  {500,1},	{614,1},	{687,1},	{653,1},
  {576,2},	{648,2},	{651,2},	{721,2},
  {611,2},	{684,2},	{575,2},	{571,0},
  {720,0},	{757,0},	{572,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {609,0},	{535,0},	{758,0},	{463,0},
  {608,0},	{537,0},	{574,0},	{460,0},
  {646,0},	{534,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{683,0},
  {461,0},	{649,0},	{497,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {719,0},	{462,0},	{650,0},	{498,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{645,0},	{682,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{756,0},	{690,0},	{727,0},
  {764,0},	{469,0},	{506,0},	{543,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0}
};

static struct patval joseki851[] = {
  {871,1},	{684,1},	{797,1},	{869,1},
  {796,1},	{832,2},	{759,2},	{795,2},
  {835,2},	{645,0},	{903,0},	{719,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {829,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{833,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki852[] = {
  {835,1},	{833,1},	{832,1},	{759,1},
  {795,1},	{684,2},	{869,2},	{797,2},
  {796,2},	{871,2},	{645,0},	{903,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {719,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{755,0},
  {793,0},	{829,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{834,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki853[] = {
  {871,1},	{684,1},	{797,1},	{834,1},
  {796,1},	{869,1},	{833,2},	{832,2},
  {835,2},	{759,2},	{795,2},	{903,0},
  {644,0},	{940,0},	{830,0},	{867,0},
  {904,0},	{941,0},	{645,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {719,0},	{866,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{829,0},	{870,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki854[] = {
  {835,1},	{870,1},	{832,1},	{759,1},
  {795,1},	{833,1},	{684,2},	{797,2},
  {869,2},	{834,2},	{871,2},	{796,2},
  {644,0},	{903,0},	{830,0},	{867,0},
  {904,0},	{940,0},	{645,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{758,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{829,0},	{866,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki855[] = {
  {758,1},	{684,1},	{797,1},	{834,1},
  {871,1},	{796,1},	{869,1},	{832,2},
  {833,2},	{835,2},	{795,2},	{759,2},
  {870,2},	{644,0},	{903,0},	{867,0},
  {904,0},	{940,0},	{830,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{645,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{829,0},	{866,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {908,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki856[] = {
  {835,1},	{870,1},	{833,1},	{759,1},
  {795,1},	{908,1},	{832,1},	{797,2},
  {869,2},	{758,2},	{871,2},	{684,2},
  {834,2},	{796,2},	{644,0},	{867,0},
  {904,0},	{940,0},	{903,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{645,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{830,0},	{866,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {829,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{909,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki857[] = {
  {758,1},	{684,1},	{797,1},	{834,1},
  {871,1},	{909,1},	{869,1},	{796,1},
  {908,2},	{835,2},	{795,2},	{832,2},
  {870,2},	{833,2},	{759,2},	{867,0},
  {904,0},	{644,0},	{903,0},	{683,0},
  {940,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{645,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{720,0},	{866,0},	{907,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {829,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{830,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki858[] = {
  {835,1},	{870,1},	{833,1},	{759,1},
  {795,1},	{908,1},	{832,1},	{907,1},
  {909,2},	{758,2},	{871,2},	{684,2},
  {869,2},	{796,2},	{797,2},	{834,2},
  {904,0},	{644,0},	{867,0},	{683,0},
  {940,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{645,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {793,0},	{720,0},	{866,0},	{903,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {829,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {872,0},	{830,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki859[] = {
  {758,1},	{684,1},	{797,1},	{834,1},
  {871,1},	{909,1},	{869,1},	{796,1},
  {872,1},	{835,2},	{795,2},	{832,2},
  {907,2},	{833,2},	{908,2},	{759,2},
  {870,2},	{904,0},	{867,0},	{644,0},
  {940,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{942,0},	{647,0},
  {681,0},	{721,0},	{645,0},	{682,0},
  {719,0},	{941,0},	{906,0},	{943,0},
  {648,0},	{685,0},	{722,0},	{646,0},
  {683,0},	{720,0},	{866,0},	{903,0},
  {944,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{718,0},	{755,0},	{792,0},
  {829,0},	{945,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{756,0},
  {793,0},	{830,0},	{946,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{947,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {948,0}
};

static struct patval joseki860[] = {
  {684,1},	{797,1},	{760,1},	{686,1},
  {722,1},	{835,1},	{759,1},	{834,1},
  {762,1},	{685,2},	{798,2},	{611,2},
  {836,2},	{799,2},	{724,2},	{723,2},
  {761,2},	{796,2},	{831,0},	{794,0},
  {867,0},	{571,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {608,0},	{648,0},	{572,0},	{609,0},
  {646,0},	{868,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{573,0},
  {610,0},	{647,0},	{793,0},	{830,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{683,0},
  {720,0},	{757,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {875,0}
};

static struct patval joseki861[] = {
  {684,1},	{759,2},	{682,0},	{719,0},
  {645,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki862[] = {
  {759,1},	{723,1},	{684,2},	{645,0},
  {608,0},	{534,0},	{756,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{682,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0}
};

static struct patval joseki863[] = {
  {684,1},	{611,1},	{759,2},	{723,2},
  {497,0},	{682,0},	{571,0},	{756,0},
  {793,0},	{830,0},	{608,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{645,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {574,0},	{719,0},	{648,0},	{685,0},
  {722,0},	{534,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{498,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki864[] = {
  {723,1},	{759,1},	{721,1},	{684,2},
  {611,2},	{534,0},	{608,0},	{793,0},
  {830,0},	{645,0},	{572,0},	{609,0},
  {756,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{646,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{719,0},	{648,0},	{685,0},
  {722,0},	{571,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{535,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki865[] = {
  {723,1},	{759,1},	{684,2},	{608,0},
  {534,0},	{682,0},	{719,0},	{756,0},
  {793,0},	{830,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{645,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{571,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{497,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki866[] = {
  {908,1},	{684,1},	{944,1},	{758,2},
  {869,2},	{793,0},	{756,0},	{904,0},
  {682,0},	{978,0},	{1015,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{647,0},	{867,0},
  {721,0},	{941,0},	{795,0},	{832,0},
  {830,0},	{906,0},	{943,0},	{980,0},
  {1017,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {907,0},	{719,0},	{981,0},	{1018,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{645,0},
  {945,0},	{982,0},	{1019,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{909,0},	{946,0},
  {983,0},	{1020,0}
};

static struct patval joseki867[] = {
  {684,1},	{759,2},	{723,2},	{682,0},
  {645,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{719,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki868[] = {
  {648,1},	{759,1},	{723,1},	{684,2},
  {608,0},	{719,0},	{534,0},	{793,0},
  {830,0},	{645,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{756,0},	{685,0},
  {722,0},	{571,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{535,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki869[] = {
  {758,1},	{684,1},	{833,2},	{797,2},
  {722,2},	{793,0},	{608,0},	{867,0},
  {904,0},	{719,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{756,0},	{795,0},
  {832,0},	{869,0},	{906,0},	{611,0},
  {648,0},	{685,0},	{830,0},	{759,0},
  {796,0},	{645,0},	{870,0},	{907,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{609,0},	{834,0},	{871,0},
  {908,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki870[] = {
  {758,1},	{721,1},	{684,1},	{833,2},
  {722,2},	{795,2},	{797,2},	{682,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {647,0},	{867,0},	{904,0},	{793,0},
  {830,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{645,0},	{759,0},
  {796,0},	{756,0},	{870,0},	{907,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {719,0},	{834,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0},	{914,0},
  {656,0},	{693,0},	{730,0},	{767,0},
  {804,0},	{841,0},	{878,0},	{915,0}
};

static struct patval joseki871[] = {
  {721,1},	{684,1},	{796,2},	{685,2},
  {760,2},	{608,0},	{830,0},	{867,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{682,0},	{719,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{793,0},	{722,0},
  {759,0},	{645,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {609,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki872[] = {
  {685,1},	{796,1},	{648,1},	{760,1},
  {721,2},	{684,2},	{645,0},	{830,0},
  {867,0},	{571,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {831,0},	{868,0},	{573,0},	{610,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{832,0},	{869,0},	{574,0},
  {611,0},	{756,0},	{793,0},	{722,0},
  {759,0},	{608,0},	{833,0},	{870,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{572,0},	{797,0},	{834,0},
  {871,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki873[] = {
  {684,1},	{758,1},	{795,1},	{722,2},
  {759,2},	{870,2},	{834,2},	{867,0},
  {645,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{830,0},	{831,0},	{868,0},
  {905,0},	{942,0},	{647,0},	{941,0},
  {721,0},	{682,0},	{719,0},	{832,0},
  {869,0},	{906,0},	{943,0},	{648,0},
  {685,0},	{756,0},	{793,0},	{796,0},
  {833,0},	{794,0},	{907,0},	{944,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{904,0},	{871,0},	{908,0},
  {945,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{910,0},	{947,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0},	{874,0},	{911,0},	{948,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0},	{875,0},	{912,0},
  {949,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{803,0},	{840,0},
  {877,0},	{914,0},	{951,0}
};

static struct patval joseki874[] = {
  {684,1},	{759,2},	{460,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{497,0},
  {756,0},	{793,0},	{830,0},	{461,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {534,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki875[] = {
  {759,1},	{574,1},	{684,2},	{534,0},
  {682,0},	{719,0},	{608,0},	{793,0},
  {830,0},	{535,0},	{645,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {571,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki876[] = {
  {687,1},	{684,1},	{574,2},	{759,2},
  {682,0},	{719,0},	{534,0},	{793,0},
  {830,0},	{535,0},	{645,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {571,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki877[] = {
  {684,1},	{687,1},	{574,2},	{759,2},
  {571,0},	{497,0},	{719,0},	{756,0},
  {608,0},	{830,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{645,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {682,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{534,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{793,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki878[] = {
  {686,1},	{574,1},	{759,1},	{684,2},
  {687,2},	{719,0},	{534,0},	{793,0},
  {830,0},	{535,0},	{645,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {571,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {682,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki879[] = {
  {649,1},	{687,1},	{684,1},	{574,2},
  {686,2},	{759,2},	{682,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{756,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {534,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{608,0},
  {645,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{571,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0}
};

static struct patval joseki880[] = {
  {686,1},	{759,1},	{574,1},	{723,1},
  {684,2},	{687,2},	{649,2},	{608,0},
  {756,0},	{719,0},	{572,0},	{534,0},
  {646,0},	{683,0},	{720,0},	{645,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{609,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {682,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{571,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{757,0},
  {830,0},	{535,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{793,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki881[] = {
  {648,1},	{649,1},	{684,1},	{687,1},
  {686,2},	{723,2},	{759,2},	{574,2},
  {608,0},	{719,0},	{572,0},	{534,0},
  {646,0},	{683,0},	{720,0},	{645,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{609,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {682,0},	{611,0},	{756,0},	{685,0},
  {722,0},	{571,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{757,0},
  {830,0},	{535,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{793,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki882[] = {
  {574,1},	{650,1},	{759,1},	{723,1},
  {686,1},	{649,2},	{687,2},	{648,2},
  {684,2},	{534,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {793,0},	{611,0},	{535,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{645,0},
  {682,0},	{719,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {571,0},	{608,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki883[] = {
  {613,1},	{684,1},	{687,1},	{649,1},
  {648,1},	{723,2},	{759,2},	{650,2},
  {574,2},	{686,2},	{830,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {793,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {608,0},	{645,0},	{682,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{497,0},	{534,0},	{571,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0}
};

static struct patval joseki884[] = {
  {651,1},	{650,1},	{574,1},	{759,1},
  {686,1},	{723,1},	{649,2},	{684,2},
  {687,2},	{613,2},	{648,2},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {793,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {608,0},	{645,0},	{682,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{497,0},	{534,0},	{571,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {535,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0}
};

static struct patval joseki885[] = {
  {613,1},	{575,1},	{687,1},	{649,1},
  {648,1},	{684,1},	{759,2},	{723,2},
  {574,2},	{650,2},	{686,2},	{651,2},
  {830,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{572,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {793,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{794,0},	{612,0},
  {608,0},	{645,0},	{682,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{497,0},	{534,0},	{571,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {535,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0}
};

static struct patval joseki886[] = {
  {651,1},	{650,1},	{574,1},	{759,1},
  {686,1},	{723,1},	{688,1},	{684,2},
  {649,2},	{687,2},	{648,2},	{613,2},
  {575,2},	{609,0},	{830,0},	{683,0},
  {720,0},	{757,0},	{646,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {793,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{794,0},	{612,0},
  {608,0},	{645,0},	{682,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{497,0},	{534,0},	{571,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {535,0},	{572,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0}
};

static struct patval joseki887[] = {
  {649,1},	{613,1},	{648,1},	{687,1},
  {575,1},	{684,1},	{651,2},	{723,2},
  {759,2},	{650,2},	{574,2},	{686,2},
  {423,0},	{461,0},	{571,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{756,0},	{794,0},	{831,0},
  {425,0},	{462,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{793,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {426,0},	{463,0},	{500,0},	{537,0},
  {424,0},	{611,0},	{757,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {427,0},	{464,0},	{501,0},	{538,0},
  {535,0},	{612,0},	{608,0},	{645,0},
  {682,0},	{760,0},	{797,0},	{834,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{460,0},	{497,0},	{534,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {429,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{498,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {430,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {431,0},	{468,0},	{505,0},	{542,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki888[] = {
  {500,1},	{723,1},	{650,1},	{686,1},
  {759,1},	{651,1},	{574,1},	{687,2},
  {684,2},	{648,2},	{613,2},	{575,2},
  {649,2},	{498,0},	{572,0},	{461,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{793,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{460,0},	{537,0},
  {830,0},	{611,0},	{608,0},	{685,0},
  {722,0},	{609,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{831,0},
  {612,0},	{645,0},	{682,0},	{719,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{497,0},
  {534,0},	{571,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{535,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki889[] = {
  {613,1},	{575,1},	{687,1},	{649,1},
  {761,1},	{684,1},	{648,1},	{723,2},
  {574,2},	{500,2},	{759,2},	{651,2},
  {686,2},	{650,2},	{830,0},	{609,0},
  {720,0},	{757,0},	{683,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{572,0},	{537,0},
  {793,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{794,0},	{612,0},
  {608,0},	{646,0},	{682,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{497,0},	{534,0},	{571,0},
  {724,0},	{645,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {535,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{838,0}
};

static struct patval joseki890[] = {
  {500,1},	{723,1},	{650,1},	{686,1},
  {724,1},	{651,1},	{759,1},	{574,1},
  {684,2},	{687,2},	{613,2},	{575,2},
  {648,2},	{761,2},	{649,2},	{461,0},
  {646,0},	{683,0},	{572,0},	{757,0},
  {794,0},	{793,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{720,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{460,0},	{537,0},
  {830,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{610,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{831,0},
  {612,0},	{609,0},	{682,0},	{719,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{497,0},
  {534,0},	{571,0},	{608,0},	{645,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{535,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki891[] = {
  {649,1},	{613,1},	{684,1},	{687,1},
  {648,1},	{761,1},	{688,1},	{575,1},
  {650,2},	{500,2},	{574,2},	{651,2},
  {724,2},	{723,2},	{686,2},	{759,2},
  {646,0},	{683,0},	{461,0},	{757,0},
  {794,0},	{793,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{720,0},	{647,0},
  {756,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{460,0},	{537,0},
  {830,0},	{611,0},	{498,0},	{685,0},
  {722,0},	{610,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{831,0},
  {612,0},	{609,0},	{682,0},	{719,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{497,0},
  {534,0},	{571,0},	{608,0},	{645,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{535,0},
  {572,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki892[] = {
  {725,1},	{686,1},	{723,1},	{574,1},
  {759,1},	{724,1},	{500,1},	{651,1},
  {650,1},	{649,2},	{613,2},	{648,2},
  {687,2},	{575,2},	{761,2},	{688,2},
  {684,2},	{645,0},	{720,0},	{571,0},
  {794,0},	{831,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {646,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{682,0},	{537,0},
  {609,0},	{611,0},	{683,0},	{685,0},
  {722,0},	{608,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{757,0},
  {612,0},	{460,0},	{497,0},	{534,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{830,0},
  {461,0},	{498,0},	{535,0},	{572,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{719,0},
  {756,0},	{793,0},	{762,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{469,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0}
};

static struct patval joseki893[] = {
  {648,1},	{688,1},	{649,1},	{761,1},
  {684,1},	{613,1},	{575,1},	{687,1},
  {689,1},	{500,2},	{723,2},	{574,2},
  {725,2},	{686,2},	{651,2},	{724,2},
  {650,2},	{759,2},	{609,0},	{535,0},
  {794,0},	{831,0},	{461,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{571,0},	{537,0},
  {462,0},	{611,0},	{572,0},	{685,0},
  {722,0},	{683,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{646,0},
  {612,0},	{720,0},	{757,0},	{830,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{645,0},
  {682,0},	{719,0},	{756,0},	{793,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{460,0},
  {497,0},	{534,0},	{762,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{498,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{469,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{470,0},	{507,0},
  {544,0},	{581,0},	{618,0},	{655,0},
  {692,0},	{729,0},	{766,0},	{803,0},
  {840,0}
};

static struct patval joseki894[] = {
  {759,1},	{574,1},	{684,2},	{571,0},
  {645,0},	{682,0},	{497,0},	{608,0},
  {793,0},	{830,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{756,0},	{721,0},	{758,0},
  {795,0},	{832,0},	{500,0},	{537,0},
  {534,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki895[] = {
  {648,1},	{684,1},	{759,2},	{574,2},
  {682,0},	{534,0},	{608,0},	{793,0},
  {830,0},	{535,0},	{719,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {571,0},	{611,0},	{645,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki896[] = {
  {724,1},	{574,1},	{759,1},	{648,2},
  {684,2},	{682,0},	{608,0},	{793,0},
  {830,0},	{534,0},	{719,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{572,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {571,0},	{611,0},	{535,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki897[] = {
  {684,1},	{611,1},	{575,1},	{501,2},
  {651,2},	{686,2},	{609,0},	{720,0},
  {757,0},	{462,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{572,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{683,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{464,0},
  {461,0},	{538,0},	{535,0},	{612,0},
  {649,0},	{646,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{498,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{470,0},	{507,0},	{544,0},
  {581,0},	{618,0},	{655,0},	{692,0},
  {729,0},	{766,0},	{471,0},	{508,0},
  {545,0},	{582,0},	{619,0},	{656,0},
  {693,0},	{730,0},	{767,0},	{472,0},
  {509,0},	{546,0},	{583,0},	{620,0},
  {657,0},	{694,0},	{731,0},	{768,0}
};

static struct patval joseki898[] = {
  {684,1},	{759,2},	{460,0},	{571,0},
  {608,0},	{645,0},	{682,0},	{497,0},
  {756,0},	{793,0},	{830,0},	{461,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {534,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{719,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki899[] = {
  {684,1},	{759,2},	{571,0},	{645,0},
  {534,0},	{719,0},	{756,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{608,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0}
};

static struct patval joseki900[] = {
  {833,1},	{684,1},	{758,2},	{719,0},
  {682,0},	{830,0},	{867,0},	{904,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {647,0},	{756,0},	{721,0},	{645,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{793,0},	{870,0},	{907,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0}
};

static struct patval joseki901[] = {
  {760,1},	{758,1},	{684,2},	{833,2},
  {793,0},	{719,0},	{867,0},	{645,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{868,0},	{905,0},
  {647,0},	{830,0},	{721,0},	{756,0},
  {795,0},	{832,0},	{869,0},	{906,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{682,0},	{870,0},	{907,0},
  {649,0},	{686,0},	{723,0},	{904,0},
  {797,0},	{834,0},	{871,0},	{908,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{909,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki902[] = {
  {798,1},	{833,1},	{684,1},	{760,2},
  {758,2},	{719,0},	{830,0},	{867,0},
  {608,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {793,0},	{905,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{756,0},	{795,0},
  {832,0},	{869,0},	{906,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {796,0},	{645,0},	{870,0},	{907,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {868,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{904,0},	{835,0},
  {872,0},	{909,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki903[] = {
  {798,1},	{833,1},	{684,1},	{648,1},
  {758,2},	{685,2},	{760,2},	{867,0},
  {830,0},	{609,0},	{646,0},	{719,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {608,0},	{905,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{683,0},	{795,0},
  {832,0},	{869,0},	{906,0},	{611,0},
  {756,0},	{793,0},	{722,0},	{759,0},
  {796,0},	{645,0},	{870,0},	{907,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {868,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{904,0},	{835,0},
  {872,0},	{909,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0},	{911,0}
};

static struct patval joseki904[] = {
  {648,1},	{833,1},	{798,1},	{721,1},
  {684,1},	{760,2},	{758,2},	{686,2},
  {685,2},	{867,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {868,0},	{905,0},	{610,0},	{647,0},
  {756,0},	{609,0},	{830,0},	{795,0},
  {832,0},	{869,0},	{906,0},	{611,0},
  {608,0},	{904,0},	{722,0},	{759,0},
  {796,0},	{793,0},	{870,0},	{907,0},
  {612,0},	{649,0},	{645,0},	{723,0},
  {719,0},	{797,0},	{834,0},	{871,0},
  {908,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{682,0},	{835,0},
  {872,0},	{909,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{873,0},	{910,0}
};

static struct patval joseki905[] = {
  {684,1},	{497,0},	{534,0},	{460,0},
  {608,0},	{645,0},	{682,0},	{719,0},
  {756,0},	{461,0},	{498,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {571,0},	{721,0},	{758,0},	{463,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{467,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {468,0},	{505,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0}
};

static struct patval joseki906[] = {
  {648,1},	{684,2},	{645,0},	{608,0},
  {756,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{611,0},
  {719,0},	{685,0},	{722,0},	{759,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0}
};

static struct patval joseki907[] = {
  {685,1},	{684,1},	{648,2},	{571,0},
  {534,0},	{719,0},	{756,0},	{535,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {645,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki908[] = {
  {649,1},	{648,1},	{684,2},	{685,2},
  {534,0},	{719,0},	{756,0},	{535,0},
  {571,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{721,0},
  {758,0},	{537,0},	{574,0},	{611,0},
  {572,0},	{682,0},	{722,0},	{759,0},
  {538,0},	{575,0},	{612,0},	{645,0},
  {686,0},	{723,0},	{760,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0}
};

static struct patval joseki909[] = {
  {684,1},	{760,1},	{759,1},	{724,2},
  {723,2},	{757,0},	{794,0},	{831,0},
  {573,0},	{609,0},	{647,0},	{572,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{646,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {610,0},	{720,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {683,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki910[] = {
  {799,1},	{684,1},	{760,1},	{759,1},
  {723,2},	{724,2},	{612,2},	{535,0},
  {831,0},	{536,0},	{573,0},	{683,0},
  {647,0},	{572,0},	{794,0},	{758,0},
  {795,0},	{832,0},	{537,0},	{574,0},
  {611,0},	{648,0},	{685,0},	{722,0},
  {646,0},	{796,0},	{833,0},	{538,0},
  {575,0},	{609,0},	{649,0},	{686,0},
  {610,0},	{757,0},	{797,0},	{834,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{721,0},	{761,0},	{798,0},
  {835,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {720,0},	{836,0},	{541,0},	{578,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{542,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0}
};

static struct patval joseki911[] = {
  {650,1},	{684,2},	{534,0},	{608,0},
  {645,0},	{682,0},	{719,0},	{571,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{497,0},	{721,0},	{758,0},
  {500,0},	{537,0},	{574,0},	{611,0},
  {648,0},	{685,0},	{722,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {756,0},	{687,0},	{724,0},	{761,0}
};

static struct patval joseki912[] = {
  {684,1},	{721,2},	{571,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{645,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {685,0},	{722,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki913[] = {
  {722,1},	{684,1},	{721,2},	{685,2},
  {571,0},	{756,0},	{793,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{645,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{719,0},	{759,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki914[] = {
  {759,1},	{684,1},	{722,1},	{685,2},
  {721,2},	{723,2},	{793,0},	{572,0},
  {609,0},	{571,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{573,0},	{610,0},
  {647,0},	{608,0},	{645,0},	{758,0},
  {795,0},	{574,0},	{611,0},	{648,0},
  {682,0},	{646,0},	{756,0},	{796,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {719,0},	{760,0},	{797,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0}
};

static struct patval joseki915[] = {
  {760,1},	{685,1},	{723,1},	{684,1},
  {722,2},	{648,2},	{686,2},	{724,2},
  {610,0},	{573,0},	{794,0},	{721,0},
  {758,0},	{795,0},	{574,0},	{611,0},
  {572,0},	{609,0},	{646,0},	{759,0},
  {796,0},	{575,0},	{612,0},	{649,0},
  {683,0},	{647,0},	{757,0},	{797,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0}
};

static struct patval joseki916[] = {
  {759,1},	{684,2},	{682,0},	{719,0},
  {645,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki917[] = {
  {684,1},	{723,1},	{759,2},	{682,0},
  {645,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{719,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki918[] = {
  {759,1},	{760,1},	{684,2},	{723,2},
  {756,0},	{793,0},	{719,0},	{645,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{608,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{830,0},
  {609,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki919[] = {
  {723,1},	{724,1},	{684,1},	{759,2},
  {760,2},	{756,0},	{719,0},	{645,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {682,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{608,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{830,0},
  {609,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{793,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki920[] = {
  {762,1},	{760,1},	{759,1},	{723,2},
  {724,2},	{684,2},	{682,0},	{571,0},
  {756,0},	{793,0},	{830,0},	{608,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{462,0},	{499,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {645,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{463,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{534,0},	{796,0},	{833,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{460,0},
  {497,0},	{797,0},	{834,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{461,0},	{761,0},
  {798,0},	{835,0},	{466,0},	{503,0},
  {540,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{719,0},	{799,0},
  {836,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki921[] = {
  {759,1},	{760,1},	{761,1},	{723,2},
  {724,2},	{684,2},	{830,0},	{609,0},
  {646,0},	{793,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{683,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{719,0},
  {756,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{682,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0}
};

static struct patval joseki922[] = {
  {761,1},	{759,1},	{760,1},	{723,2},
  {724,2},	{725,2},	{684,2},	{497,0},
  {645,0},	{756,0},	{793,0},	{830,0},
  {424,0},	{461,0},	{498,0},	{535,0},
  {423,0},	{460,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {425,0},	{462,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{534,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {426,0},	{463,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{609,0},	{796,0},	{833,0},
  {427,0},	{464,0},	{501,0},	{538,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {682,0},	{719,0},	{797,0},	{834,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {571,0},	{608,0},	{798,0},	{835,0},
  {429,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {572,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki923[] = {
  {944,1},	{945,1},	{946,1},	{909,2},
  {869,2},	{684,2},	{908,2},	{910,2},
  {830,0},	{978,0},	{682,0},	{646,0},
  {683,0},	{720,0},	{1015,0},	{645,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{647,0},	{941,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {719,0},	{906,0},	{943,0},	{980,0},
  {1017,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {907,0},	{794,0},	{981,0},	{1018,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{867,0},
  {904,0},	{982,0},	{1019,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{756,0},	{793,0},
  {983,0},	{1020,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{757,0},	{947,0},	{984,0},
  {1021,0}
};

static struct patval joseki924[] = {
  {758,1},	{684,2},	{645,0},	{719,0},
  {756,0},	{793,0},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{721,0},	{682,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki925[] = {
  {760,1},	{758,1},	{723,2},	{684,2},
  {608,0},	{534,0},	{756,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{721,0},
  {645,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{682,0},	{719,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0}
};

static struct patval joseki926[] = {
  {760,1},	{761,1},	{758,1},	{723,2},
  {684,2},	{724,2},	{719,0},	{793,0},
  {608,0},	{571,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{645,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{682,0},	{721,0},
  {756,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{831,0},	{534,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{830,0},	{535,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki927[] = {
  {758,1},	{760,1},	{761,1},	{684,2},
  {724,2},	{723,2},	{725,2},	{645,0},
  {460,0},	{756,0},	{793,0},	{830,0},
  {497,0},	{461,0},	{498,0},	{535,0},
  {423,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {425,0},	{462,0},	{499,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{534,0},
  {721,0},	{424,0},	{795,0},	{832,0},
  {426,0},	{463,0},	{500,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {427,0},	{464,0},	{501,0},	{538,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {682,0},	{719,0},	{797,0},	{834,0},
  {428,0},	{465,0},	{502,0},	{539,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {571,0},	{608,0},	{798,0},	{835,0},
  {429,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {572,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki928[] = {
  {946,1},	{945,1},	{943,1},	{909,2},
  {684,2},	{910,2},	{908,2},	{869,2},
  {830,0},	{978,0},	{682,0},	{646,0},
  {683,0},	{720,0},	{645,0},	{794,0},
  {831,0},	{868,0},	{905,0},	{942,0},
  {979,0},	{1016,0},	{647,0},	{941,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {719,0},	{906,0},	{1015,0},	{980,0},
  {1017,0},	{648,0},	{685,0},	{722,0},
  {759,0},	{796,0},	{833,0},	{870,0},
  {907,0},	{944,0},	{981,0},	{1018,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{871,0},	{867,0},
  {904,0},	{982,0},	{1019,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{756,0},	{793,0},
  {983,0},	{1020,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {873,0},	{757,0},	{947,0},	{984,0},
  {1021,0}
};

static struct patval joseki929[] = {
  {758,1},	{684,2},	{570,0},	{681,0},
  {718,0},	{755,0},	{644,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{607,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0}
};

static struct patval joseki930[] = {
  {684,1},	{611,1},	{685,2},	{608,0},
  {645,0},	{682,0},	{571,0},	{756,0},
  {498,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{497,0},	{721,0},	{758,0},
  {500,0},	{537,0},	{574,0},	{719,0},
  {648,0},	{534,0},	{722,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0}
};

static struct patval joseki931[] = {
  {721,1},	{685,1},	{684,2},	{611,2},
  {645,0},	{682,0},	{571,0},	{756,0},
  {498,0},	{535,0},	{608,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {499,0},	{536,0},	{573,0},	{610,0},
  {647,0},	{497,0},	{572,0},	{758,0},
  {500,0},	{537,0},	{574,0},	{719,0},
  {648,0},	{534,0},	{722,0},	{759,0},
  {501,0},	{538,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{761,0}
};

static struct patval joseki932[] = {
  {721,1},	{648,1},	{684,1},	{758,2},
  {722,2},	{719,0},	{608,0},	{793,0},
  {535,0},	{572,0},	{645,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {536,0},	{573,0},	{610,0},	{647,0},
  {682,0},	{534,0},	{609,0},	{795,0},
  {537,0},	{574,0},	{611,0},	{756,0},
  {685,0},	{571,0},	{759,0},	{796,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0}
};

static struct patval joseki933[] = {
  {760,1},	{722,1},	{758,1},	{648,2},
  {684,2},	{721,2},	{534,0},	{719,0},
  {571,0},	{793,0},	{460,0},	{497,0},
  {535,0},	{572,0},	{609,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {462,0},	{499,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {498,0},	{795,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{611,0},	{682,0},
  {685,0},	{756,0},	{759,0},	{796,0},
  {464,0},	{501,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {461,0},	{797,0}
};

static struct patval joseki934[] = {
  {648,1},	{721,1},	{684,1},	{760,2},
  {758,2},	{722,2},	{645,0},	{646,0},
  {683,0},	{720,0},	{757,0},	{794,0},
  {610,0},	{647,0},	{682,0},	{609,0},
  {756,0},	{795,0},	{611,0},	{719,0},
  {685,0},	{793,0},	{759,0},	{796,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {608,0},	{797,0},	{613,0},	{650,0},
  {687,0},	{724,0},	{761,0},	{798,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0}
};

static struct patval joseki935[] = {
  {758,1},	{684,2},	{607,0},	{681,0},
  {570,0},	{755,0},	{792,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{644,0},
  {721,0},	{718,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki936[] = {
  {759,1},	{684,1},	{758,2},	{607,0},
  {570,0},	{755,0},	{681,0},	{829,0},
  {571,0},	{608,0},	{792,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{644,0},
  {721,0},	{645,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{718,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki937[] = {
  {758,1},	{796,1},	{684,2},	{759,2},
  {570,0},	{607,0},	{681,0},	{829,0},
  {571,0},	{608,0},	{792,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{644,0},
  {721,0},	{645,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{718,0},	{755,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki938[] = {
  {759,1},	{722,1},	{684,1},	{796,2},
  {758,2},	{755,0},	{644,0},	{829,0},
  {681,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {571,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki939[] = {
  {758,1},	{796,1},	{760,1},	{684,2},
  {759,2},	{722,2},	{644,0},	{829,0},
  {755,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{681,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {830,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki940[] = {
  {759,1},	{722,1},	{797,1},	{684,1},
  {758,2},	{796,2},	{760,2},	{829,0},
  {755,0},	{644,0},	{645,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{681,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {830,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki941[] = {
  {798,1},	{796,1},	{758,1},	{760,1},
  {797,2},	{759,2},	{684,2},	{722,2},
  {829,0},	{644,0},	{645,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{681,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {830,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{755,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki942[] = {
  {759,1},	{722,1},	{795,1},	{684,1},
  {797,1},	{798,2},	{760,2},	{758,2},
  {796,2},	{829,0},	{645,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{681,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{644,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {830,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{608,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{755,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0}
};

static struct patval joseki943[] = {
  {758,1},	{796,1},	{760,1},	{834,1},
  {795,2},	{722,2},	{684,2},	{759,2},
  {829,0},	{608,0},	{755,0},	{682,0},
  {719,0},	{718,0},	{793,0},	{681,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{792,0},
  {721,0},	{756,0},	{644,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {830,0},	{570,0},	{607,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{571,0},	{797,0},	{645,0}
};

static struct patval joseki944[] = {
  {758,1},	{684,2},	{644,0},	{570,0},
  {718,0},	{607,0},	{792,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{681,0},
  {721,0},	{755,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki945[] = {
  {684,1},	{723,1},	{758,2},	{570,0},
  {718,0},	{607,0},	{792,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{681,0},
  {721,0},	{755,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {644,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static struct patval joseki946[] = {
  {759,1},	{684,1},	{685,2},	{724,2},
  {534,0},	{719,0},	{608,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki947[] = {
  {684,1},	{722,1},	{761,1},	{721,2},
  {796,2},	{756,0},	{830,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {758,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{719,0},
  {759,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {682,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki948[] = {
  {758,1},	{721,1},	{796,1},	{684,2},
  {761,2},	{722,2},	{756,0},	{867,0},
  {609,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{685,0},	{719,0},
  {759,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {682,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki949[] = {
  {684,1},	{685,1},	{761,1},	{722,1},
  {721,2},	{796,2},	{758,2},	{867,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{609,0},	{719,0},
  {759,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {682,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki950[] = {
  {758,1},	{721,1},	{796,1},	{684,2},
  {685,2},	{722,2},	{761,2},	{867,0},
  {756,0},	{646,0},	{683,0},	{720,0},
  {757,0},	{794,0},	{831,0},	{868,0},
  {610,0},	{647,0},	{608,0},	{645,0},
  {830,0},	{795,0},	{832,0},	{869,0},
  {611,0},	{648,0},	{609,0},	{719,0},
  {759,0},	{793,0},	{833,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {682,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0}
};

static struct patval joseki951[] = {
  {759,1},	{684,1},	{685,2},	{724,2},
  {534,0},	{719,0},	{608,0},	{793,0},
  {830,0},	{535,0},	{572,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{536,0},	{573,0},
  {610,0},	{647,0},	{571,0},	{721,0},
  {758,0},	{795,0},	{832,0},	{537,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {722,0},	{756,0},	{796,0},	{833,0},
  {538,0},	{575,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{797,0},
  {834,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{761,0},
  {798,0},	{835,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{836,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {838,0}
};

static struct patval joseki952[] = {
  {722,1},	{685,1},	{724,1},	{684,2},
  {759,2},	{571,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{608,0},
  {721,0},	{758,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {645,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki953[] = {
  {721,1},	{684,1},	{759,1},	{724,2},
  {722,2},	{685,2},	{571,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{608,0},
  {793,0},	{758,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {645,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki954[] = {
  {722,1},	{758,1},	{724,1},	{685,1},
  {721,2},	{759,2},	{684,2},	{571,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{608,0},
  {793,0},	{830,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {645,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki955[] = {
  {795,1},	{684,1},	{721,1},	{759,1},
  {722,2},	{685,2},	{724,2},	{758,2},
  {571,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{608,0},
  {793,0},	{830,0},	{572,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {723,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {645,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {579,0},	{616,0},	{653,0},	{690,0},
  {727,0},	{764,0},	{801,0},	{838,0}
};

static struct patval joseki956[] = {
  {649,1},	{685,1},	{684,1},	{651,1},
  {612,1},	{722,2},	{648,2},	{686,2},
  {611,2},	{461,0},	{720,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{499,0},
  {721,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{462,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{575,0},	{609,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki957[] = {
  {721,1},	{611,1},	{648,1},	{686,1},
  {722,1},	{649,2},	{651,2},	{684,2},
  {685,2},	{612,2},	{720,0},	{536,0},
  {573,0},	{610,0},	{647,0},	{499,0},
  {461,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{462,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{575,0},	{609,0},
  {646,0},	{683,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki958[] = {
  {649,1},	{685,1},	{687,1},	{651,1},
  {612,1},	{684,1},	{648,2},	{686,2},
  {721,2},	{722,2},	{611,2},	{536,0},
  {720,0},	{610,0},	{647,0},	{499,0},
  {461,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{462,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{575,0},	{609,0},
  {646,0},	{573,0},	{723,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki959[] = {
  {721,1},	{611,1},	{648,1},	{723,1},
  {722,1},	{686,1},	{649,2},	{651,2},
  {685,2},	{612,2},	{684,2},	{687,2},
  {536,0},	{610,0},	{647,0},	{499,0},
  {461,0},	{758,0},	{463,0},	{500,0},
  {537,0},	{574,0},	{498,0},	{535,0},
  {757,0},	{462,0},	{759,0},	{464,0},
  {501,0},	{538,0},	{575,0},	{609,0},
  {646,0},	{573,0},	{720,0},	{760,0},
  {465,0},	{502,0},	{539,0},	{576,0},
  {613,0},	{650,0},	{683,0},	{724,0},
  {761,0},	{466,0},	{503,0},	{540,0},
  {577,0},	{614,0},	{572,0},	{688,0},
  {725,0},	{762,0},	{467,0},	{504,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{468,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {469,0},	{506,0},	{543,0},	{580,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0}
};

static struct patval joseki960[] = {
  {758,1},	{648,1},	{685,1},	{760,1},
  {759,1},	{684,1},	{723,1},	{688,2},
  {722,2},	{649,2},	{721,2},	{611,2},
  {724,2},	{686,2},	{647,0},	{536,0},
  {573,0},	{795,0},	{500,0},	{537,0},
  {574,0},	{498,0},	{535,0},	{572,0},
  {794,0},	{499,0},	{796,0},	{501,0},
  {538,0},	{575,0},	{612,0},	{646,0},
  {683,0},	{610,0},	{757,0},	{797,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{720,0},	{761,0},
  {798,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{609,0},	{725,0},
  {762,0},	{799,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0}
};

static struct patval joseki961[] = {
  {722,1},	{612,1},	{649,1},	{687,1},
  {723,1},	{648,1},	{684,1},	{724,1},
  {688,2},	{613,2},	{650,2},	{575,2},
  {652,2},	{611,2},	{500,0},	{758,0},
  {537,0},	{759,0},	{464,0},	{501,0},
  {538,0},	{462,0},	{499,0},	{536,0},
  {686,0},	{463,0},	{760,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{610,0},
  {647,0},	{574,0},	{721,0},	{761,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{685,0},	{725,0},
  {762,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{573,0},	{689,0},
  {726,0},	{763,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{469,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {470,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0}
};

static struct patval joseki962[] = {
  {724,1},	{685,1},	{721,1},	{684,2},
  {759,2},	{793,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{682,0},	{719,0},	{758,0},
  {795,0},	{832,0},	{648,0},	{756,0},
  {722,0},	{645,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {830,0},	{761,0},	{798,0},	{835,0}
};

static struct patval joseki963[] = {
  {684,1},	{759,1},	{722,1},	{685,2},
  {724,2},	{721,2},	{830,0},	{609,0},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{793,0},	{758,0},	{795,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki964[] = {
  {724,1},	{685,1},	{758,1},	{721,1},
  {722,2},	{684,2},	{759,2},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {647,0},	{830,0},	{646,0},	{793,0},
  {795,0},	{832,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {649,0},	{686,0},	{723,0},	{760,0},
  {797,0},	{834,0},	{650,0},	{687,0},
  {645,0},	{761,0},	{798,0},	{835,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {799,0},	{836,0}
};

static struct patval joseki965[] = {
  {684,1},	{759,1},	{795,1},	{722,1},
  {724,2},	{721,2},	{758,2},	{685,2},
  {646,0},	{683,0},	{720,0},	{757,0},
  {794,0},	{831,0},	{610,0},	{647,0},
  {608,0},	{793,0},	{830,0},	{609,0},
  {832,0},	{611,0},	{648,0},	{682,0},
  {719,0},	{756,0},	{796,0},	{833,0},
  {612,0},	{649,0},	{686,0},	{723,0},
  {760,0},	{797,0},	{834,0},	{613,0},
  {650,0},	{687,0},	{645,0},	{761,0},
  {798,0},	{835,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {836,0}
};

static struct patval joseki966[] = {
  {684,1},	{614,1},	{575,1},	{648,1},
  {611,1},	{649,2},	{612,2},	{685,2},
  {574,2},	{573,0},	{610,0},	{647,0},
  {536,0},	{721,0},	{500,0},	{537,0},
  {498,0},	{683,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{538,0},	{572,0},
  {609,0},	{646,0},	{686,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{651,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki967[] = {
  {574,1},	{686,1},	{685,1},	{612,1},
  {649,1},	{614,2},	{648,2},	{575,2},
  {611,2},	{684,2},	{610,0},	{647,0},
  {573,0},	{721,0},	{500,0},	{537,0},
  {498,0},	{536,0},	{720,0},	{499,0},
  {722,0},	{501,0},	{538,0},	{572,0},
  {609,0},	{646,0},	{683,0},	{723,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {650,0},	{687,0},	{724,0},	{503,0},
  {540,0},	{577,0},	{535,0},	{651,0},
  {688,0},	{725,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0}
};

static struct patval joseki968[] = {
  {795,1},	{725,1},	{686,1},	{759,1},
  {684,1},	{722,1},	{723,2},	{796,2},
  {797,2},	{760,2},	{685,2},	{758,0},
  {721,0},	{832,0},	{611,0},	{648,0},
  {609,0},	{647,0},	{831,0},	{610,0},
  {833,0},	{612,0},	{649,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{646,0},	{762,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0}
};

static struct patval joseki969[] = {
  {685,1},	{648,1},	{796,1},	{723,1},
  {760,1},	{797,1},	{725,2},	{686,2},
  {722,2},	{684,2},	{759,2},	{795,2},
  {758,0},	{832,0},	{611,0},	{721,0},
  {609,0},	{647,0},	{831,0},	{610,0},
  {833,0},	{612,0},	{649,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{834,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{614,0},
  {651,0},	{688,0},	{646,0},	{762,0},
  {799,0},	{836,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{800,0},
  {837,0}
};

static struct patval joseki970[] = {
  {832,1},	{762,1},	{723,1},	{721,1},
  {684,1},	{796,1},	{759,1},	{834,2},
  {833,2},	{685,2},	{797,2},	{760,2},
  {722,2},	{795,0},	{647,0},	{869,0},
  {611,0},	{648,0},	{758,0},	{609,0},
  {831,0},	{868,0},	{610,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki971[] = {
  {685,1},	{722,1},	{833,1},	{648,1},
  {760,1},	{797,1},	{834,1},	{759,2},
  {723,2},	{762,2},	{721,2},	{796,2},
  {684,2},	{832,2},	{758,0},	{795,0},
  {610,0},	{869,0},	{574,0},	{611,0},
  {647,0},	{572,0},	{609,0},	{831,0},
  {868,0},	{573,0},	{870,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{871,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{646,0},	{799,0},
  {836,0},	{873,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {800,0},	{837,0},	{874,0}
};

static struct patval joseki972[] = {
  {832,1},	{762,1},	{724,1},	{721,1},
  {684,1},	{723,1},	{759,1},	{796,1},
  {834,2},	{648,2},	{797,2},	{760,2},
  {685,2},	{833,2},	{722,2},	{869,0},
  {795,0},	{647,0},	{758,0},	{609,0},
  {831,0},	{868,0},	{611,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{610,0},
  {720,0},	{757,0},	{794,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki973[] = {
  {722,1},	{869,1},	{833,1},	{760,1},
  {797,1},	{834,1},	{648,1},	{685,1},
  {724,2},	{759,2},	{684,2},	{721,2},
  {796,2},	{723,2},	{832,2},	{762,2},
  {795,0},	{647,0},	{758,0},	{609,0},
  {831,0},	{868,0},	{611,0},	{870,0},
  {612,0},	{649,0},	{686,0},	{610,0},
  {720,0},	{757,0},	{794,0},	{871,0},
  {613,0},	{650,0},	{687,0},	{683,0},
  {761,0},	{798,0},	{835,0},	{872,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{799,0},	{836,0},	{873,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{874,0}
};

static struct patval joseki974[] = {
  {832,1},	{762,1},	{724,1},	{684,1},
  {795,1},	{759,1},	{796,1},	{723,1},
  {721,1},	{760,2},	{833,2},	{797,2},
  {722,2},	{869,2},	{648,2},	{685,2},
  {834,2},	{646,0},	{868,0},	{758,0},
  {870,0},	{649,0},	{686,0},	{647,0},
  {757,0},	{794,0},	{831,0},	{871,0},
  {650,0},	{687,0},	{720,0},	{761,0},
  {798,0},	{835,0},	{872,0},	{651,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {874,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0}
};

static struct patval joseki975[] = {
  {685,1},	{722,1},	{834,1},	{648,1},
  {833,1},	{760,1},	{797,1},	{869,1},
  {800,1},	{724,2},	{759,2},	{796,2},
  {684,2},	{762,2},	{721,2},	{795,2},
  {832,2},	{723,2},	{574,0},	{611,0},
  {647,0},	{758,0},	{609,0},	{646,0},
  {868,0},	{573,0},	{870,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{610,0},
  {757,0},	{572,0},	{831,0},	{871,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {720,0},	{761,0},	{798,0},	{835,0},
  {872,0},	{577,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{683,0},	{799,0},
  {836,0},	{873,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {794,0},	{837,0},	{874,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {764,0},	{801,0},	{838,0},	{875,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0}
};

static struct patval joseki976[] = {
  {832,1},	{721,1},	{759,1},	{762,1},
  {724,1},	{723,1},	{795,1},	{764,1},
  {684,1},	{796,1},	{833,2},	{760,2},
  {800,2},	{797,2},	{869,2},	{722,2},
  {834,2},	{648,2},	{685,2},	{647,0},
  {758,0},	{574,0},	{611,0},	{831,0},
  {535,0},	{572,0},	{609,0},	{868,0},
  {536,0},	{870,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{573,0},
  {610,0},	{757,0},	{537,0},	{871,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{683,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{799,0},	{836,0},	{873,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{720,0},
  {837,0},	{874,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {794,0},	{801,0},	{838,0},	{875,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki977[] = {
  {685,1},	{722,1},	{869,1},	{574,1},
  {833,1},	{760,1},	{797,1},	{834,1},
  {800,1},	{648,1},	{724,2},	{723,2},
  {684,2},	{762,2},	{759,2},	{721,2},
  {764,2},	{795,2},	{832,2},	{796,2},
  {758,0},	{647,0},	{611,0},	{831,0},
  {535,0},	{572,0},	{609,0},	{868,0},
  {536,0},	{870,0},	{538,0},	{575,0},
  {612,0},	{649,0},	{686,0},	{573,0},
  {610,0},	{757,0},	{537,0},	{871,0},
  {539,0},	{576,0},	{613,0},	{650,0},
  {687,0},	{683,0},	{761,0},	{798,0},
  {835,0},	{872,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {646,0},	{799,0},	{836,0},	{873,0},
  {541,0},	{578,0},	{615,0},	{652,0},
  {689,0},	{726,0},	{763,0},	{720,0},
  {837,0},	{874,0},	{542,0},	{579,0},
  {616,0},	{653,0},	{690,0},	{727,0},
  {794,0},	{801,0},	{838,0},	{875,0},
  {543,0},	{580,0},	{617,0},	{654,0},
  {691,0},	{728,0},	{765,0},	{802,0},
  {839,0},	{876,0}
};

static struct patval joseki978[] = {
  {869,1},	{758,1},	{796,1},	{799,1},
  {761,1},	{684,1},	{832,1},	{801,1},
  {721,1},	{833,1},	{760,1},	{870,2},
  {837,2},	{797,2},	{906,2},	{759,2},
  {871,2},	{834,2},	{722,2},	{685,2},
  {611,2},	{795,0},	{648,0},	{868,0},
  {572,0},	{609,0},	{646,0},	{905,0},
  {573,0},	{907,0},	{575,0},	{612,0},
  {649,0},	{686,0},	{723,0},	{610,0},
  {647,0},	{794,0},	{574,0},	{908,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{720,0},	{798,0},	{835,0},
  {872,0},	{909,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{762,0},
  {683,0},	{836,0},	{873,0},	{910,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{757,0},
  {874,0},	{911,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {831,0},	{838,0},	{875,0},	{912,0},
  {580,0},	{617,0},	{654,0},	{691,0},
  {728,0},	{765,0},	{802,0},	{839,0},
  {876,0},	{913,0}
};

static struct patval joseki979[] = {
  {759,1},	{796,1},	{943,1},	{648,1},
  {907,1},	{834,1},	{871,1},	{908,1},
  {874,1},	{722,1},	{684,1},	{797,2},
  {798,2},	{721,2},	{833,2},	{795,2},
  {758,2},	{869,2},	{906,2},	{870,2},
  {838,2},	{836,2},	{832,0},	{905,0},
  {609,0},	{646,0},	{683,0},	{942,0},
  {610,0},	{944,0},	{612,0},	{649,0},
  {686,0},	{723,0},	{760,0},	{647,0},
  {685,0},	{831,0},	{611,0},	{945,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{757,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {720,0},	{873,0},	{910,0},	{947,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{794,0},
  {911,0},	{948,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {868,0},	{875,0},	{912,0},	{949,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0}
};

static struct patval joseki980[] = {
  {906,1},	{686,1},	{833,1},	{836,1},
  {798,1},	{721,1},	{869,1},	{838,1},
  {758,1},	{870,1},	{795,1},	{797,1},
  {907,2},	{834,2},	{943,2},	{684,2},
  {874,2},	{871,2},	{759,2},	{796,2},
  {908,2},	{648,2},	{722,2},	{832,0},
  {609,0},	{905,0},	{683,0},	{942,0},
  {610,0},	{944,0},	{612,0},	{649,0},
  {646,0},	{723,0},	{760,0},	{647,0},
  {685,0},	{831,0},	{611,0},	{945,0},
  {613,0},	{650,0},	{687,0},	{724,0},
  {761,0},	{757,0},	{835,0},	{872,0},
  {909,0},	{946,0},	{614,0},	{651,0},
  {688,0},	{725,0},	{762,0},	{799,0},
  {720,0},	{873,0},	{910,0},	{947,0},
  {615,0},	{652,0},	{689,0},	{726,0},
  {763,0},	{800,0},	{837,0},	{794,0},
  {911,0},	{948,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {868,0},	{875,0},	{912,0},	{949,0},
  {617,0},	{654,0},	{691,0},	{728,0},
  {765,0},	{802,0},	{839,0},	{876,0},
  {913,0},	{950,0}
};

static struct patval joseki981[] = {
  {759,1},	{796,1},	{648,1},	{685,1},
  {907,1},	{834,1},	{871,1},	{908,1},
  {722,1},	{874,1},	{684,1},	{943,1},
  {721,2},	{798,2},	{795,2},	{869,2},
  {906,2},	{758,2},	{833,2},	{836,2},
  {870,2},	{838,2},	{686,2},	{797,2},
  {832,0},	{647,0},	{944,0},	{649,0},
  {683,0},	{723,0},	{760,0},	{942,0},
  {831,0},	{646,0},	{905,0},	{945,0},
  {650,0},	{687,0},	{724,0},	{720,0},
  {794,0},	{835,0},	{872,0},	{909,0},
  {946,0},	{651,0},	{688,0},	{725,0},
  {762,0},	{799,0},	{757,0},	{873,0},
  {910,0},	{947,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0},
  {761,0},	{911,0},	{948,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {868,0},	{875,0},	{912,0},	{949,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {802,0},	{839,0},	{876,0},	{913,0},
  {950,0}
};

static struct patval joseki982[] = {
  {870,1},	{650,1},	{684,1},	{800,1},
  {762,1},	{722,1},	{802,1},	{797,1},
  {834,1},	{759,1},	{761,1},	{685,1},
  {833,1},	{871,2},	{872,2},	{798,2},
  {723,2},	{907,2},	{612,2},	{649,2},
  {686,2},	{835,2},	{760,2},	{838,2},
  {648,2},	{611,0},	{908,0},	{796,0},
  {647,0},	{687,0},	{724,0},	{906,0},
  {795,0},	{610,0},	{869,0},	{909,0},
  {614,0},	{651,0},	{688,0},	{613,0},
  {758,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{721,0},	{837,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {725,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {832,0},	{839,0},	{876,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{877,0},
  {914,0}
};

static struct patval joseki983[] = {
  {649,1},	{686,1},	{723,1},	{760,1},
  {648,1},	{837,1},	{871,1},	{798,1},
  {835,1},	{872,1},	{838,1},	{612,1},
  {907,1},	{762,2},	{834,2},	{761,2},
  {800,2},	{650,2},	{722,2},	{759,2},
  {684,2},	{833,2},	{870,2},	{685,2},
  {797,2},	{802,2},	{575,0},	{501,0},
  {574,0},	{536,0},	{573,0},	{869,0},
  {906,0},	{500,0},	{537,0},	{908,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {610,0},	{687,0},	{724,0},	{611,0},
  {499,0},	{795,0},	{538,0},	{909,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{721,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {647,0},	{796,0},	{874,0},	{911,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{758,0},	{875,0},	{912,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {832,0},	{839,0},	{876,0},	{913,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0},	{914,0}
};

static struct patval joseki984[] = {
  {833,1},	{870,1},	{722,1},	{650,1},
  {800,1},	{684,1},	{762,1},	{759,1},
  {685,1},	{802,1},	{839,1},	{797,1},
  {834,1},	{761,1},	{907,2},	{871,2},
  {648,2},	{835,2},	{723,2},	{798,2},
  {837,2},	{649,2},	{686,2},	{838,2},
  {760,2},	{872,2},	{612,2},	{575,0},
  {574,0},	{536,0},	{573,0},	{501,0},
  {906,0},	{500,0},	{537,0},	{908,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {610,0},	{687,0},	{724,0},	{611,0},
  {499,0},	{795,0},	{538,0},	{909,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{721,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {647,0},	{796,0},	{874,0},	{911,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{758,0},	{875,0},	{912,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {832,0},	{869,0},	{876,0},	{913,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0},	{914,0}
};

static struct patval joseki985[] = {
  {760,1},	{837,1},	{876,1},	{798,1},
  {835,1},	{872,1},	{723,1},	{686,1},
  {648,1},	{612,1},	{838,1},	{649,1},
  {907,1},	{871,1},	{802,2},	{839,2},
  {650,2},	{685,2},	{722,2},	{759,2},
  {797,2},	{833,2},	{870,2},	{761,2},
  {762,2},	{834,2},	{684,2},	{800,2},
  {537,0},	{906,0},	{721,0},	{758,0},
  {575,0},	{538,0},	{796,0},	{908,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {832,0},	{687,0},	{724,0},	{500,0},
  {610,0},	{647,0},	{795,0},	{909,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{501,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {574,0},	{611,0},	{874,0},	{911,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{727,0},	{764,0},
  {801,0},	{869,0},	{875,0},	{912,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {499,0},	{536,0},	{573,0},	{913,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0},	{766,0},
  {803,0},	{840,0},	{877,0},	{914,0},
  {508,0},	{545,0},	{582,0},	{619,0},
  {656,0},	{693,0},	{730,0},	{767,0},
  {804,0},	{841,0},	{878,0},	{915,0}
};

static struct patval joseki986[] = {
  {839,1},	{833,1},	{684,1},	{802,1},
  {650,1},	{797,1},	{834,1},	{761,1},
  {762,1},	{800,1},	{877,1},	{685,1},
  {722,1},	{759,1},	{870,1},	{876,2},
  {871,2},	{907,2},	{612,2},	{649,2},
  {686,2},	{723,2},	{798,2},	{838,2},
  {872,2},	{835,2},	{648,2},	{760,2},
  {837,2},	{832,0},	{724,0},	{758,0},
  {906,0},	{796,0},	{721,0},	{909,0},
  {614,0},	{795,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{611,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{801,0},
  {869,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki987[] = {
  {612,1},	{876,1},	{835,1},	{872,1},
  {760,1},	{649,1},	{801,1},	{838,1},
  {798,1},	{837,1},	{648,1},	{871,1},
  {686,1},	{723,1},	{907,1},	{833,2},
  {870,2},	{685,2},	{839,2},	{797,2},
  {722,2},	{759,2},	{650,2},	{761,2},
  {834,2},	{684,2},	{877,2},	{800,2},
  {802,2},	{762,2},	{724,0},	{758,0},
  {906,0},	{796,0},	{721,0},	{909,0},
  {614,0},	{795,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{611,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{764,0},	{832,0},
  {869,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki988[] = {
  {839,1},	{833,1},	{684,1},	{802,1},
  {650,1},	{764,1},	{834,1},	{761,1},
  {762,1},	{800,1},	{877,1},	{685,1},
  {722,1},	{759,1},	{870,1},	{797,1},
  {871,2},	{907,2},	{612,2},	{649,2},
  {686,2},	{723,2},	{798,2},	{876,2},
  {801,2},	{835,2},	{648,2},	{872,2},
  {838,2},	{760,2},	{837,2},	{758,0},
  {906,0},	{724,0},	{721,0},	{909,0},
  {614,0},	{796,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{611,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{795,0},	{832,0},
  {869,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{765,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki989[] = {
  {612,1},	{876,1},	{835,1},	{872,1},
  {760,1},	{649,1},	{801,1},	{838,1},
  {798,1},	{837,1},	{648,1},	{871,1},
  {686,1},	{723,1},	{765,1},	{907,1},
  {870,2},	{833,2},	{839,2},	{764,2},
  {722,2},	{759,2},	{650,2},	{797,2},
  {834,2},	{685,2},	{877,2},	{800,2},
  {761,2},	{762,2},	{684,2},	{802,2},
  {758,0},	{724,0},	{906,0},	{909,0},
  {614,0},	{721,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{611,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{727,0},	{795,0},	{832,0},
  {869,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki990[] = {
  {839,1},	{833,1},	{684,1},	{802,1},
  {727,1},	{764,1},	{834,1},	{761,1},
  {762,1},	{800,1},	{877,1},	{685,1},
  {722,1},	{759,1},	{650,1},	{797,1},
  {870,1},	{907,2},	{612,2},	{649,2},
  {686,2},	{723,2},	{798,2},	{876,2},
  {801,2},	{871,2},	{648,2},	{872,2},
  {765,2},	{760,2},	{835,2},	{838,2},
  {837,2},	{724,0},	{906,0},	{909,0},
  {614,0},	{721,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{611,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{875,0},	{912,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki991[] = {
  {612,1},	{876,1},	{835,1},	{872,1},
  {760,1},	{649,1},	{801,1},	{838,1},
  {798,1},	{912,1},	{648,1},	{871,1},
  {686,1},	{837,1},	{765,1},	{723,1},
  {907,1},	{870,2},	{839,2},	{764,2},
  {722,2},	{833,2},	{727,2},	{797,2},
  {834,2},	{685,2},	{877,2},	{759,2},
  {650,2},	{762,2},	{684,2},	{761,2},
  {800,2},	{802,2},	{724,0},	{909,0},
  {614,0},	{721,0},	{688,0},	{725,0},
  {687,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{906,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{875,0},	{611,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {766,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki992[] = {
  {802,1},	{839,1},	{761,1},	{800,1},
  {870,1},	{722,1},	{684,1},	{877,1},
  {727,1},	{764,1},	{650,1},	{762,1},
  {766,1},	{759,1},	{797,1},	{833,1},
  {834,1},	{685,1},	{648,2},	{871,2},
  {760,2},	{912,2},	{765,2},	{723,2},
  {835,2},	{907,2},	{838,2},	{876,2},
  {837,2},	{798,2},	{612,2},	{649,2},
  {686,2},	{801,2},	{872,2},	{500,0},
  {538,0},	{611,0},	{908,0},	{465,0},
  {502,0},	{539,0},	{576,0},	{613,0},
  {721,0},	{687,0},	{724,0},	{501,0},
  {573,0},	{610,0},	{647,0},	{909,0},
  {466,0},	{503,0},	{540,0},	{577,0},
  {614,0},	{651,0},	{688,0},	{725,0},
  {464,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{467,0},	{504,0},	{541,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{575,0},	{574,0},
  {874,0},	{911,0},	{468,0},	{505,0},
  {542,0},	{579,0},	{616,0},	{653,0},
  {690,0},	{758,0},	{795,0},	{832,0},
  {869,0},	{875,0},	{463,0},	{469,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {462,0},	{499,0},	{536,0},	{913,0},
  {470,0},	{507,0},	{544,0},	{581,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {906,0},	{803,0},	{840,0},	{537,0},
  {914,0},	{471,0},	{508,0},	{545,0},
  {582,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki993[] = {
  {760,1},	{837,1},	{876,1},	{798,1},
  {835,1},	{872,1},	{723,1},	{612,1},
  {648,1},	{801,1},	{838,1},	{686,1},
  {912,1},	{501,1},	{649,1},	{907,1},
  {765,1},	{871,1},	{727,2},	{722,2},
  {685,2},	{833,2},	{759,2},	{839,2},
  {764,2},	{761,2},	{870,2},	{800,2},
  {877,2},	{766,2},	{650,2},	{802,2},
  {797,2},	{834,2},	{762,2},	{684,2},
  {502,0},	{721,0},	{576,0},	{613,0},
  {575,0},	{687,0},	{724,0},	{538,0},
  {610,0},	{647,0},	{908,0},	{909,0},
  {503,0},	{540,0},	{577,0},	{614,0},
  {651,0},	{688,0},	{725,0},	{537,0},
  {799,0},	{836,0},	{873,0},	{910,0},
  {504,0},	{541,0},	{578,0},	{615,0},
  {652,0},	{689,0},	{726,0},	{763,0},
  {539,0},	{611,0},	{874,0},	{911,0},
  {505,0},	{542,0},	{579,0},	{616,0},
  {653,0},	{690,0},	{758,0},	{795,0},
  {832,0},	{869,0},	{875,0},	{500,0},
  {506,0},	{543,0},	{580,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {499,0},	{536,0},	{573,0},	{913,0},
  {507,0},	{544,0},	{581,0},	{618,0},
  {655,0},	{692,0},	{729,0},	{906,0},
  {803,0},	{840,0},	{574,0},	{914,0},
  {508,0},	{545,0},	{582,0},	{619,0},
  {656,0},	{693,0},	{730,0},	{767,0},
  {804,0},	{841,0},	{878,0},	{915,0}
};

static struct patval joseki994[] = {
  {839,1},	{833,1},	{684,1},	{802,1},
  {727,1},	{764,1},	{834,1},	{766,1},
  {762,1},	{800,1},	{877,1},	{685,1},
  {722,1},	{759,1},	{650,1},	{797,1},
  {870,1},	{761,1},	{612,2},	{649,2},
  {686,2},	{723,2},	{798,2},	{876,2},
  {801,2},	{871,2},	{648,2},	{872,2},
  {765,2},	{838,2},	{760,2},	{907,2},
  {912,2},	{835,2},	{837,2},	{909,0},
  {614,0},	{724,0},	{688,0},	{725,0},
  {721,0},	{799,0},	{836,0},	{873,0},
  {910,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{906,0},	{651,0},
  {874,0},	{911,0},	{616,0},	{653,0},
  {690,0},	{758,0},	{795,0},	{832,0},
  {687,0},	{875,0},	{611,0},	{617,0},
  {654,0},	{691,0},	{728,0},	{796,0},
  {613,0},	{610,0},	{647,0},	{913,0},
  {618,0},	{655,0},	{692,0},	{729,0},
  {869,0},	{803,0},	{840,0},	{908,0},
  {914,0},	{619,0},	{656,0},	{693,0},
  {730,0},	{767,0},	{804,0},	{841,0},
  {878,0},	{915,0}
};

static struct patval joseki995[] = {
  {758,1},	{684,2},	{723,2},	{570,0},
  {718,0},	{607,0},	{792,0},	{829,0},
  {571,0},	{608,0},	{645,0},	{682,0},
  {719,0},	{756,0},	{793,0},	{830,0},
  {572,0},	{609,0},	{646,0},	{683,0},
  {720,0},	{757,0},	{794,0},	{831,0},
  {573,0},	{610,0},	{647,0},	{681,0},
  {721,0},	{755,0},	{795,0},	{832,0},
  {574,0},	{611,0},	{648,0},	{685,0},
  {722,0},	{759,0},	{796,0},	{833,0},
  {575,0},	{612,0},	{649,0},	{686,0},
  {644,0},	{760,0},	{797,0},	{834,0},
  {576,0},	{613,0},	{650,0},	{687,0},
  {724,0},	{761,0},	{798,0},	{835,0},
  {577,0},	{614,0},	{651,0},	{688,0},
  {725,0},	{762,0},	{799,0},	{836,0},
  {578,0},	{615,0},	{652,0},	{689,0},
  {726,0},	{763,0},	{800,0},	{837,0}
};

static int
autohelperjoseki10(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki12(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki14(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki16(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki18(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki20(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki22(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki24(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki26(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki28(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki29(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki31(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki33(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki35(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki37(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki39(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki41(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki42(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki44(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki46(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki48(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki50(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki60(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki64(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki75(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki85(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki88(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki110(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki116(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(723, trans, move);

  return (whose_moyo(OPPOSITE_INFLUENCE(color), A) == color);
}

static int
autohelperjoseki117(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(687, trans, move);

  return !DRAGON_WEAK(A) || (dragon[A].status == DEAD);
}

static int
autohelperjoseki134(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki145(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki155(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki164(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki166(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki190(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki191(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki193(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki195(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki197(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki199(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki201(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki203(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki205(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki207(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki209(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki211(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki213(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki215(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki217(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki219(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki221(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki223(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki225(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki227(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki229(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki231(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki233(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki235(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki237(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki239(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki241(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki243(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki245(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki247(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki249(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki251(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki253(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki255(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki256(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki257(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki259(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki261(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki263(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki265(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki267(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki269(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki271(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki273(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki275(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki276(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki278(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki280(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki281(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki283(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki285(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki287(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki289(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki291(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki293(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki295(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki297(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki299(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki301(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki303(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki305(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki307(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki309(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki311(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki313(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki315(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki317(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki319(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki321(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki323(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki325(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki327(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki329(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki331(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki333(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki335(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki337(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki339(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki341(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki343(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki345(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki347(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki349(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki351(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki353(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki355(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki357(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki359(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki361(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki363(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki365(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki367(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki369(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki371(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki373(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki375(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki377(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki379(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki381(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki383(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki385(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki387(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki389(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki391(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki393(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki394(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki396(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki398(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki400(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki402(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki404(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki406(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki408(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki410(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki412(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki414(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki448(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki450(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki452(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki454(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki456(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki512(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki522(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki531(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki607(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki689(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki697(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki715(int trans, int move, int color, int action)
{
  int A, B, C, D, E, F, G, H, I, J, K, L, M;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(794, trans, move);
  B = AFFINE_TRANSFORM(832, trans, move);
  C = AFFINE_TRANSFORM(793, trans, move);
  D = AFFINE_TRANSFORM(833, trans, move);
  E = AFFINE_TRANSFORM(797, trans, move);
  F = AFFINE_TRANSFORM(834, trans, move);
  G = AFFINE_TRANSFORM(683, trans, move);
  H = AFFINE_TRANSFORM(722, trans, move);
  I = AFFINE_TRANSFORM(759, trans, move);
  J = AFFINE_TRANSFORM(798, trans, move);
  K = AFFINE_TRANSFORM(760, trans, move);
  L = AFFINE_TRANSFORM(723, trans, move);
  M = AFFINE_TRANSFORM(761, trans, move);

  return  play_attack_defend_n(OTHER_COLOR(color), 1, 13, A, B, C, D, E, F, G, H, I, J, K, L, M, M);
}

static int
autohelperjoseki729(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki730(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki755(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki764(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki766(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki772(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki782(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki795(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki796(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki848(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki851(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  add_antisuji_move(move);;

  return 0;
}

static int
autohelperjoseki899(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(610, trans, move);

  return !(whose_area(OPPOSITE_INFLUENCE(color), A) == OTHER_COLOR(color));
}

static int
autohelperjoseki992(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(948, trans, move);

  return !DEFEND_MACRO(A);
}

static int
autohelperjoseki994(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  return safe_move(move, color);
}

static struct pattern joseki[] = {
  {joseki0,77,8, "JH1",-3,-3,7,3,10,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki1,63,8, "JH2",-3,-3,5,3,8,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200804, 0x00208000, 0x80200000, 0x09200000, 0x80200000, 0x08200000, 0x00200900, 0x00208040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki2,77,8, "JH3",-3,-3,7,3,10,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100428, 0x00104000, 0x40100000, 0x06120000, 0x40100000, 0x04100000, 0x00120600, 0x001040a0}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki3,88,8, "JH4",-3,-2,7,5,10,7,0x5,833,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110002, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100012, 0x00100000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki4,63,8, "JH5",-3,-3,5,3,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200814, 0x00208000, 0x80200000, 0x09210000, 0x80200000, 0x08200000, 0x00210900, 0x00208050}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki5,63,8, "JH6",-2,-1,6,5,8,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00281600, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242408, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki6,63,8, "JH7",-2,-1,6,5,8,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00291600, 0x00606090, 0x50a00000, 0x24240000, 0x60600000, 0x16290000, 0x00242418, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki7,63,8, "JH8",-1,-3,7,3,8,6,0x5,687,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00189860, 0x8050a000, 0x9a900000, 0x28160909, 0xa0508080, 0x98180000, 0x09162800, 0x00909a25}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki8,72,8, "JH9",-3,-2,8,3,11,5,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki9,90,8, "JH10",-3,-1,6,7,9,8,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210001, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200011, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki10,55,8, "JH11",-3,-1,7,3,10,4,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki10,3,0.000000},
  {joseki11,55,8, "JH12",-3,-1,7,3,10,4,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki12,55,8, "JH13",-3,-1,7,3,10,4,0x5,683,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200900, 0x00208040, 0x80200000, 0x08200000, 0x80200000, 0x09200000, 0x00200804, 0x00208000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki12,3,0.000000},
  {joseki13,55,8, "JH14",-2,-1,8,3,10,4,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00201006, 0x00600000, 0x10200000, 0x01240000, 0x00600000, 0x10200000, 0x00240102, 0x00201040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki14,55,8, "JH15",-3,-1,7,3,10,4,0x5,723,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki14,3,0.000000},
  {joseki15,55,8, "JH16",-3,-1,7,3,10,4,0x5,687,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki16,55,8, "JH17",-3,-1,7,3,10,4,0x5,685,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki16,3,0.000000},
  {joseki17,55,8, "JH18",-3,-1,7,3,10,4,0x5,721,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00102000, 0x00900000, 0x20100000, 0x00180000, 0x00900000, 0x20100000, 0x00180000, 0x00102000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki18,55,8, "JH19",-3,-1,7,3,10,4,0x5,721,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki18,3,0.000000},
  {joseki19,55,8, "JH20",-3,-1,7,3,10,4,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00180000, 0x00102000, 0x00900000, 0x20100000, 0x20100000, 0x00180000, 0x00102000, 0x00900000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki20,55,8, "JH21",-3,-1,7,3,10,4,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00240800, 0x00209000, 0x80600000, 0x18200000, 0x90200000, 0x08240000, 0x00201800, 0x00608000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki20,3,0.000000},
  {joseki21,55,8, "JH22",-3,-1,7,3,10,4,0x5,685,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00180600, 0x00106080, 0x40900000, 0x24100000, 0x60100000, 0x06180000, 0x00102408, 0x00904000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki22,55,8, "JH23",-3,-1,7,3,10,4,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242900, 0x00a09040, 0xa0600000, 0x18280000, 0x90a00000, 0x29240000, 0x00281804, 0x0060a000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki22,3,0.000000},
  {joseki23,55,8, "JH24",-3,-1,7,3,10,4,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1600, 0x005060a0, 0x50900000, 0x24140000, 0x60500000, 0x161a0000, 0x00142428, 0x00905000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki24,55,8, "JH25",-3,-1,7,3,10,4,0x5,683,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00252902, 0x00a09050, 0xa0600000, 0x18280000, 0x90a00000, 0x29250000, 0x00281816, 0x0060a000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki24,3,0.000000},
  {joseki25,55,8, "JH26",-2,-1,8,3,10,4,0x5,647,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00201a16, 0x00608080, 0x90200000, 0x09250000, 0x80600000, 0x1a200000, 0x0025090a, 0x00209050}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki26,55,8, "JH27",-2,0,8,4,10,4,0x5,720,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x0024090a, 0x00209040, 0x80600000, 0x1a200000, 0x90200000, 0x09240000, 0x00201a06, 0x00608080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki26,3,0.000000},
  {joseki27,55,8, "JH28",-1,-1,9,3,10,4,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x0020601a, 0x40a00000, 0x24200000, 0x02290400, 0x00a04000, 0x60200000, 0x04290202, 0x00202490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki28,55,8, "JH29",-1,0,9,4,10,4,0x5,795,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00242409, 0x00a05000, 0x60600000, 0x16280000, 0x50a00000, 0x24240000, 0x00281601, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki28,3,0.000000},
  {joseki29,55,8, "JH30",-3,-1,7,3,10,4,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki29,3,0.000000},
  {joseki30,55,8, "JH31",-2,-2,8,2,10,4,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki31,55,8, "JH32",-2,-1,8,3,10,4,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242000, 0x00a01000, 0x20600000, 0x10280000, 0x10a00000, 0x20240000, 0x00281000, 0x00602000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki31,3,0.000000},
  {joseki32,55,8, "JH33",-2,-1,8,3,10,4,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00181800, 0x0050a000, 0x90900000, 0x28140000, 0xa0500000, 0x18180000, 0x00142800, 0x00909000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki33,55,8, "JH34",-1,-2,9,2,10,4,0x5,688,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00209090, 0x80600000, 0x18200000, 0x00250a00, 0x00608000, 0x90200000, 0x0a250000, 0x00201818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki33,3,0.000000},
  {joseki34,55,8, "JH35",-1,-2,9,2,10,4,0x5,651,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00106060, 0x40900000, 0x24100000, 0x001a0500, 0x00904000, 0x60100000, 0x051a0000, 0x00102424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki35,55,8, "JH36",-1,-2,9,2,10,4,0x5,687,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00209090, 0x80600000, 0x18200000, 0x00250a00, 0x00608000, 0x90200000, 0x0a250000, 0x00201818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki35,3,0.000000},
  {joseki36,55,8, "JH37",-1,-2,9,2,10,4,0x5,652,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00106060, 0x40900000, 0x24100000, 0x001a0500, 0x00904000, 0x60100000, 0x051a0000, 0x00102424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki37,55,8, "JH38",-1,-2,9,2,10,4,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00209090, 0x80600000, 0x18200000, 0x00250a00, 0x00608000, 0x90200000, 0x0a250000, 0x00201818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki37,3,0.000000},
  {joseki38,55,8, "JH39",-1,-2,9,2,10,4,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00186060, 0x40902000, 0x24900000, 0x201a0500, 0x20904000, 0x60180000, 0x051a2000, 0x00902424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki39,55,8, "JH40",-1,-1,9,3,10,4,0x5,763,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki39,3,0.000000},
  {joseki40,55,8, "JH41",-1,-1,9,3,10,4,0x5,764,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00161818, 0x00509020, 0x90500000, 0x1a150000, 0x90500000, 0x18160000, 0x00151a20, 0x00509090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki41,55,8, "JH42",-1,-1,9,3,10,4,0x5,800,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki41,3,0.000000},
  {joseki42,55,8, "JH43",-1,-2,9,2,10,4,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00209090, 0x80600000, 0x18200000, 0x00250a00, 0x00608000, 0x90200000, 0x0a250000, 0x00201818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki42,3,0.000000},
  {joseki43,55,8, "JH44",-1,-2,9,2,10,4,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00186060, 0x40902000, 0x24900000, 0x201a0500, 0x20904000, 0x60180000, 0x051a2000, 0x00902424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki44,55,8, "JH45",-1,-1,9,3,10,4,0x5,725,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki44,3,0.000000},
  {joseki45,55,8, "JH46",-1,-1,9,3,10,4,0x5,688,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00161818, 0x00509020, 0x90500000, 0x1a150000, 0x90500000, 0x18160000, 0x00151a20, 0x00509090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki46,55,8, "JH47",-1,-1,9,3,10,4,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki46,3,0.000000},
  {joseki47,55,8, "JH48",-1,-1,9,3,10,4,0x5,763,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00161818, 0x00509020, 0x90500000, 0x1a150000, 0x90500000, 0x18160000, 0x00151a20, 0x00509090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki48,55,8, "JH49",-1,-1,9,3,10,4,0x5,757,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki48,3,0.000000},
  {joseki49,55,8, "JH50",0,-3,10,1,10,4,0x5,724,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00206080, 0x40a00000, 0x25200000, 0x00280605, 0x00a04040, 0x60200000, 0x06280000, 0x00202509}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki50,55,8, "JH51",-1,-1,9,3,10,4,0x5,762,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00292424, 0x00a06010, 0x60a00000, 0x252a0000, 0x60a00000, 0x24290000, 0x002a2510, 0x00a06060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki50,3,0.000000},
  {joseki51,55,8, "JH52",-1,-1,9,3,10,4,0x5,757,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00161818, 0x00509020, 0x90500000, 0x1a150000, 0x90500000, 0x18160000, 0x00151a20, 0x00509090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki52,70,8, "JH53",-3,-3,6,3,9,6,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki53,70,8, "JH54",-3,-3,6,3,9,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200004, 0x00200000, 0x00200000, 0x01200000, 0x00200000, 0x00200000, 0x00200100, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki54,70,8, "JH55",-2,-3,7,3,9,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242000, 0x00a01000, 0x20600000, 0x10280000, 0x10a00000, 0x20240000, 0x00281000, 0x00602000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki55,70,8, "JH56",-2,-3,7,3,9,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181800, 0x0050a000, 0x90900000, 0x28140000, 0xa0500000, 0x18180000, 0x00142800, 0x00909000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki56,70,8, "JH57",-2,-3,7,3,9,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242420, 0x00a05000, 0x60600000, 0x142a0000, 0x50a00000, 0x24240000, 0x002a1400, 0x00606020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki57,70,8, "JH58",-1,-4,8,2,9,6,0x5,651,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206060, 0x40a00000, 0x24200000, 0x002a0500, 0x00a04000, 0x60200000, 0x052a0000, 0x00202424}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki58,70,8, "JH59",-1,-4,8,2,9,6,0x5,725,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109090, 0x80500000, 0x18100000, 0x00150a00, 0x00508000, 0x90100000, 0x0a150000, 0x00101818}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki59,70,8, "JH60",-1,-4,8,2,9,6,0x5,616,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206060, 0x40a00000, 0x24200000, 0x002a0500, 0x00a04000, 0x60200000, 0x052a0000, 0x00202424}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki60,70,8, "JH61",-1,-4,8,2,9,6,0x5,689,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109090, 0x80500000, 0x18100000, 0x00150a00, 0x00508000, 0x90100000, 0x0a150000, 0x00101818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki60,0,0.000000},
  {joseki61,70,8, "JH62",-1,-4,8,2,9,6,0x5,652,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206060, 0x40a00000, 0x24200000, 0x002a0500, 0x00a04000, 0x60200000, 0x052a0000, 0x00202424}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki62,70,8, "JH63",-2,-3,7,3,9,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242420, 0x00a05000, 0x60600000, 0x142a0000, 0x50a00000, 0x24240000, 0x002a1400, 0x00606020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki63,70,8, "JH64",-2,-3,7,3,9,6,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181810, 0x0050a000, 0x90900000, 0x28150000, 0xa0500000, 0x18180000, 0x00152800, 0x00909010}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki64,70,8, "JH65",-2,-3,7,3,9,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242420, 0x00a05000, 0x60600000, 0x142a0000, 0x50a00000, 0x24240000, 0x002a1400, 0x00606020}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki64,3,0.000000},
  {joseki65,70,8, "JH66",-2,-3,7,3,9,6,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181818, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a00, 0x00909090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki66,110,8, "JH67",-2,-8,7,2,9,10,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki67,70,8, "JH68",-2,-4,7,2,9,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a000, 0x80900000, 0x28100000, 0x00180800, 0x00908000, 0xa0100000, 0x08180000, 0x00102800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki68,63,8, "JH69",-2,-3,6,3,8,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281400, 0x00606000, 0x50a00000, 0x24240000, 0x60600000, 0x14280000, 0x00242400, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki69,63,8, "JH70",-2,-3,6,3,8,6,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0014a800, 0x80909000, 0xa8500000, 0x18180800, 0x90908000, 0xa8140000, 0x08181800, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki70,63,8, "JH71",-2,-3,6,3,8,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00285600, 0x40606080, 0x54a00000, 0x24240400, 0x60604000, 0x56280000, 0x04242408, 0x00a05400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki71,63,8, "JH72",-2,-3,6,3,8,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0014a902, 0x80909040, 0xa8500000, 0x18180800, 0x90908000, 0xa9140000, 0x08181806, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki72,63,8, "JH73",-2,-3,6,3,8,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a5601, 0x406060a0, 0x54a00000, 0x24240400, 0x60604000, 0x562a0000, 0x04242429, 0x00a05400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki73,63,8, "JH74",-2,-3,6,3,8,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a90a, 0x80909050, 0xa8500000, 0x1a180800, 0x90908000, 0xa9150000, 0x08181a16, 0x0050a880}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki74,70,8, "JH75",-2,-1,7,5,9,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220500, 0x00204060, 0x40200000, 0x04200000, 0x40200000, 0x05220000, 0x00200424, 0x00204000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki75,63,8, "JH76",-2,-3,6,3,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a5601, 0x406060a0, 0x54a00000, 0x24240400, 0x60604000, 0x562a0000, 0x04242429, 0x00a05400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki75,3,0.000000},
  {joseki76,63,8, "JH77",-2,-3,6,3,8,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a5601, 0x406060a0, 0x54a00000, 0x24240400, 0x60604000, 0x562a0000, 0x04242429, 0x00a05400}
   , 0xa00010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki77,72,8, "JH78",-2,-4,6,3,8,7,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a902, 0x80909050, 0xa8500000, 0x18180800, 0x90908000, 0xa9150000, 0x08181816, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki78,56,8, "JH79",-2,-3,4,4,6,7,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00250a00, 0x00209090, 0x80600000, 0x18200000, 0x90200000, 0x0a250000, 0x00201818, 0x00608000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki79,56,8, "JH80",-2,-3,4,4,6,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00250a00, 0x00209090, 0x80600000, 0x18200000, 0x90200000, 0x0a250000, 0x00201818, 0x00608000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki80,56,8, "JH81",-2,-2,4,5,6,7,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00290600, 0x00206090, 0x40a00000, 0x24200000, 0x60200000, 0x06290000, 0x00202418, 0x00a04000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki81,56,8, "JH82",-2,-2,4,5,6,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00290609, 0x00206090, 0x40a00000, 0x26200000, 0x60200000, 0x06290000, 0x00202619, 0x00a04080}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki82,56,8, "JH83",-2,-3,4,4,6,7,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00251a20, 0x00609090, 0x90600000, 0x18260000, 0x90600000, 0x1a250000, 0x00261818, 0x00609020}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki83,56,8, "JH84",-2,-2,4,5,6,7,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00291608, 0x00606090, 0x50a00000, 0x26240000, 0x60600000, 0x16290000, 0x00242618, 0x00a05080}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki84,63,8, "JH85",-2,-3,4,5,6,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00291609, 0x00606090, 0x50a00000, 0x26240000, 0x60600000, 0x16290000, 0x00242619, 0x00a05080}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki85,60,8, "JH86",-2,-3,7,2,9,5,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki85,3,0.000000},
  {joseki86,70,8, "JH87",-3,-3,6,3,9,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100088, 0x00100000, 0x00100000, 0x02100200, 0x00100000, 0x00100000, 0x02100200, 0x00100088}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki87,77,8, "JH88",-3,-1,7,5,10,6,0x5,800,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110008, 0x00100010, 0x00100000, 0x02100000, 0x00100000, 0x00110000, 0x00100210, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki88,84,8, "JH89",-3,-1,8,5,11,6,0x5,764,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220004, 0x00200020, 0x00200000, 0x01200000, 0x00200000, 0x00220000, 0x00200120, 0x00200040}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki88,3,0.000000},
  {joseki89,77,8, "JH90",-3,-1,7,5,10,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110008, 0x00100010, 0x00100000, 0x02100000, 0x00100000, 0x00110000, 0x00100210, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki90,77,8, "JH91",-3,-1,7,5,10,6,0x5,725,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220004, 0x00200020, 0x00200000, 0x01200000, 0x00200000, 0x00220000, 0x00200120, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki91,84,8, "JH92",-3,-1,8,5,11,6,0x5,801,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110008, 0x00100010, 0x00100000, 0x02100000, 0x00100000, 0x00110000, 0x00100210, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki92,91,8, "JH93",-3,-1,9,5,12,6,0x5,765,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220004, 0x00200020, 0x00200000, 0x01200000, 0x00200000, 0x00220000, 0x00200120, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki93,91,8, "JH94",-3,-1,9,5,12,6,0x5,803,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110008, 0x00100010, 0x00100000, 0x02100000, 0x00100000, 0x00110000, 0x00100210, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki94,72,8, "JH95",-3,-5,4,3,7,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki95,88,8, "JH96",-3,-5,4,5,7,10,0x5,609,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220000, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200020, 0x00200000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki96,88,8, "JH97",-2,-3,5,7,7,10,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki97,88,8, "JH98",-2,-3,5,7,7,10,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki98,70,8, "JH99",-3,-1,6,5,9,6,0x5,832,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220000, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200020, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki99,63,8, "JH100",-3,-1,5,5,8,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220000, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200020, 0x00200000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki100,70,8, "JH101",-3,-1,6,5,9,6,0x5,799,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110000, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100010, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki101,70,8, "JH102",-3,-1,6,5,9,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220000, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200020, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki102,70,8, "JH103",-2,-4,7,2,9,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204800, 0x40208000, 0x84200000, 0x08200400, 0x80204000, 0x48200000, 0x04200800, 0x00208400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki103,70,8, "JH104",-2,-4,7,2,9,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00108420, 0x80104000, 0x48100000, 0x04120800, 0x40108000, 0x84100000, 0x08120400, 0x00104820}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki104,80,8, "JH105",-2,-5,7,2,9,7,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204818, 0x40208000, 0x84200000, 0x0a210400, 0x80204000, 0x48200000, 0x04210a00, 0x00208490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki105,70,8, "JH106",-2,-4,7,2,9,6,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00108424, 0x80104000, 0x48100000, 0x05120800, 0x40108000, 0x84100000, 0x08120500, 0x00104860}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki106,70,8, "JH107",-2,-4,7,2,9,6,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204818, 0x40208000, 0x84200000, 0x0a210400, 0x80204000, 0x48200000, 0x04210a00, 0x00208490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki107,70,8, "JH108",-2,-4,7,2,9,6,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00108424, 0x80104000, 0x48100000, 0x05120800, 0x40108000, 0x84100000, 0x08120500, 0x00104860}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki108,70,8, "JH109",-2,-4,7,2,9,6,0x5,614,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204818, 0x40208000, 0x84200000, 0x0a210400, 0x80204000, 0x48200000, 0x04210a00, 0x00208490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki109,70,8, "JH110",-2,-4,7,2,9,6,0x5,652,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204818, 0x40208000, 0x84200000, 0x0a210400, 0x80204000, 0x48200000, 0x04210a00, 0x00208490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki110,63,8, "JH111",-2,-4,6,2,8,6,0x5,613,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204818, 0x40208000, 0x84200000, 0x0a210400, 0x80204000, 0x48200000, 0x04210a00, 0x00208490}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki110,3,0.000000},
  {joseki111,70,8, "JH112",-3,-1,6,5,9,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110008, 0x00100010, 0x00100000, 0x02100000, 0x00100000, 0x00110000, 0x00100210, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki112,56,8, "JH113",-3,-1,4,5,7,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110000, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100010, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki113,60,8, "JH114",-2,-3,7,2,9,5,0x5,690,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00208400, 0x80204000, 0x48200000, 0x04200800, 0x40208000, 0x84200000, 0x08200400, 0x00204800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki114,60,8, "JH115",-2,-3,7,2,9,5,0x5,614,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00104800, 0x40108000, 0x84100000, 0x08100400, 0x80104000, 0x48100000, 0x04100800, 0x00108400}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki115,96,8, "JH116",-2,-9,5,2,7,11,0x5,425,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00104800, 0x40108000, 0x84100000, 0x08100400, 0x80104000, 0x48100000, 0x04100800, 0x00108400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki116,70,8, "JH117",-2,-4,7,2,9,6,0x5,652,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00208400, 0x80204000, 0x48200000, 0x04200800, 0x40208000, 0x84200000, 0x08200400, 0x00204800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperjoseki116,3,0.010000},
  {joseki117,56,8, "JH118",-3,-2,3,5,6,7,0x5,794,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperjoseki117,3,0.016000},
  {joseki118,42,8, "JH119",-2,-4,3,2,5,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204010, 0x40200000, 0x04200000, 0x00210400, 0x00204000, 0x40200000, 0x04210000, 0x00200410}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki119,35,8, "JH120",-2,-1,4,3,6,4,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242008, 0x00a01000, 0x20600000, 0x12280000, 0x10a00000, 0x20240000, 0x00281200, 0x00602080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki120,35,8, "JH121",-2,-1,4,3,6,4,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00181006, 0x00502000, 0x10900000, 0x21140000, 0x20500000, 0x10180000, 0x00142102, 0x00901040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki121,35,8, "JH122",-2,-1,4,3,6,4,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242209, 0x00a01080, 0x20600000, 0x12280000, 0x10a00000, 0x22240000, 0x00281209, 0x00602080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki122,35,8, "JH123",-2,-1,4,3,6,4,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00181906, 0x0050a040, 0x90900000, 0x29140000, 0xa0500000, 0x19180000, 0x00142906, 0x00909040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki123,35,8, "JH124",-2,-1,4,3,6,4,0x5,686,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00262609, 0x00a050a0, 0x60600000, 0x16280000, 0x50a00000, 0x26260000, 0x00281629, 0x00606080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki124,35,8, "JH125",-2,-1,4,3,6,4,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00191922, 0x0050a050, 0x90900000, 0x28160000, 0xa0500000, 0x19190000, 0x00162816, 0x00909020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki125,35,8, "JH126",-2,-1,4,3,6,4,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242809, 0x00a09000, 0xa0600000, 0x1a280000, 0x90a00000, 0x28240000, 0x00281a01, 0x0060a080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki126,35,8, "JH127",-2,-1,4,3,6,4,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00181606, 0x00506080, 0x50900000, 0x25140000, 0x60500000, 0x16180000, 0x0014250a, 0x00905040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki127,66,8, "JH128",-3,0,7,5,10,5,0x5,764,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki128,66,8, "JH129",-3,0,7,5,10,5,0x5,801,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki129,49,8, "JH130",-3,-1,3,5,6,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110000, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100010, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki130,49,8, "JH131",-2,-4,4,2,6,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209000, 0x80600000, 0x18200000, 0x00240800, 0x00608000, 0x90200000, 0x08240000, 0x00201800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki131,56,8, "JH132",-2,-4,5,2,7,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186000, 0x40902000, 0x24900000, 0x20180400, 0x20904000, 0x60180000, 0x04182000, 0x00902400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki132,42,8, "JH133",-2,-2,4,3,6,5,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00292400, 0x00a06010, 0x62a00000, 0x24280008, 0x60a00080, 0x24290000, 0x00282410, 0x00a06200}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki133,64,8, "JH134",-1,-6,6,1,7,7,0x5,721,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x0024090a, 0x00608080, 0x90200000, 0x09240000, 0x00201a06}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki134,42,8, "JH135",-2,-3,4,2,6,5,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186000, 0x40902000, 0x24900000, 0x20180400, 0x20904000, 0x60180000, 0x04182000, 0x00902400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki134,0,0.000000},
  {joseki135,42,8, "JH136",-1,-3,5,2,6,5,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202490, 0x00a04000, 0x60200000, 0x04290200, 0x40a00000, 0x24200000, 0x02290400, 0x00206018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki136,42,8, "JH137",-1,-3,5,2,6,5,0x5,650,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282490, 0x00a06000, 0x60a00000, 0x24290200, 0x60a00000, 0x24280000, 0x02292400, 0x00a06018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki137,42,8, "JH138",-1,-3,5,2,6,5,0x5,758,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282490, 0x00a06000, 0x60a00000, 0x24290202, 0x60a00000, 0x24280000, 0x02292400, 0x00a0601a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki138,42,8, "JH139",-1,-3,5,2,6,5,0x5,612,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282690, 0x00a06080, 0x60a00000, 0x24290200, 0x60a00000, 0x26280000, 0x02292408, 0x00a06018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki139,48,8, "JH140",-2,-3,5,2,7,5,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186000, 0x40902000, 0x24900000, 0x20180400, 0x20904000, 0x60180000, 0x04182000, 0x00902400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki140,42,8, "JH141",-2,-3,4,2,6,5,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249020, 0x80601000, 0x18600000, 0x10260800, 0x10608000, 0x90240000, 0x08261000, 0x00601820}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki141,56,8, "JH142",-2,-4,5,2,7,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186810, 0x4090a000, 0xa4900000, 0x28190400, 0xa0904000, 0x68180000, 0x04192800, 0x0090a410}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki142,48,8, "JH143",-2,-3,5,2,7,5,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002494a0, 0x80605000, 0x58600000, 0x14260a00, 0x50608000, 0x94240000, 0x0a261400, 0x00605828}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki143,56,8, "JH144",-2,-4,5,2,7,6,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186858, 0x4090a000, 0xa4900000, 0x2a190500, 0xa0904000, 0x68180000, 0x05192a00, 0x0090a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki144,56,8, "JH145",-1,-4,6,2,7,6,0x5,651,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202494, 0x00a04000, 0x60200000, 0x05290200, 0x40a00000, 0x24200000, 0x02290500, 0x00206058}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki145,63,8, "JH146",-2,-4,6,2,8,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186810, 0x4090a000, 0xa4900000, 0x28190400, 0xa0904000, 0x68180000, 0x04192800, 0x0090a410}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki145,0,0.000000},
  {joseki146,56,8, "JH147",-2,-4,5,2,7,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249428, 0x80605000, 0x58600000, 0x16260800, 0x50608000, 0x94240000, 0x08261600, 0x006058a0}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki147,63,8, "JH148",-2,-4,6,2,8,6,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186894, 0x4090a000, 0xa4900000, 0x29190600, 0xa0904000, 0x68180000, 0x06192900, 0x0090a458}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki148,56,8, "JH149",-2,-4,5,2,7,6,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249468, 0x80605000, 0x58600000, 0x16260900, 0x50608000, 0x94240000, 0x09261600, 0x006058a4}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki149,63,8, "JH150",-2,-4,6,2,8,6,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186894, 0x4090a000, 0xa4900000, 0x29190600, 0xa0904000, 0x68180000, 0x06192900, 0x0090a458}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki150,63,8, "JH151",-2,-4,6,2,8,6,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249468, 0x80605000, 0x58600000, 0x16260900, 0x50608000, 0x94240000, 0x09261600, 0x006058a4}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki151,63,8, "JH152",-2,-4,6,2,8,6,0x5,689,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186894, 0x4090a000, 0xa4900000, 0x29190600, 0xa0904000, 0x68180000, 0x06192900, 0x0090a458}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki152,42,8, "JH153",-2,-4,3,2,5,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249468, 0x80605000, 0x58600000, 0x16260900, 0x50608000, 0x94240000, 0x09261600, 0x006058a4}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki153,42,8, "JH154",-2,-3,3,3,5,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00261a25, 0x006090a0, 0x91600000, 0x19260004, 0x90600040, 0x1a260000, 0x00261929, 0x00609160}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki154,42,8, "JH155",-2,-3,3,3,5,6,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0019a51a, 0x80906050, 0x6a900000, 0x26190808, 0x60908080, 0xa5190000, 0x08192616, 0x00906a90}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki155,56,8, "JH156",-2,-4,5,2,7,6,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186810, 0x4090a000, 0xa4900000, 0x28190400, 0xa0904000, 0x68180000, 0x04192800, 0x0090a410}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki155,0,0.000000},
  {joseki156,56,8, "JH157",-2,-4,5,2,7,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249420, 0x80605000, 0x58600000, 0x14260800, 0x50608000, 0x94240000, 0x08261400, 0x00605820}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki157,49,8, "JH158",-2,-4,4,2,6,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186000, 0x40902000, 0x24900000, 0x20180400, 0x20904000, 0x60180000, 0x04182000, 0x00902400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki158,35,8, "JH159",-1,-3,5,1,6,4,0x5,687,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x18200000, 0x00240902, 0x00608000, 0x90200000, 0x09240000, 0x00201806}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki159,42,8, "JH160",-1,-4,5,1,6,5,0x5,722,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106080, 0x40900000, 0x24100000, 0x00180601, 0x00904000, 0x60100000, 0x06180000, 0x00102409}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki160,56,8, "JH161",-1,-5,6,1,7,6,0x5,613,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209840, 0x80608000, 0x98200000, 0x08240902, 0x80608000, 0x98200000, 0x09240800, 0x00209806}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki161,49,8, "JH162",-1,-5,5,1,6,6,0x5,575,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106480, 0x40904000, 0x64100000, 0x04180601, 0x40904000, 0x64100000, 0x06180400, 0x00106409}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki162,42,8, "JH163",-1,-4,5,1,6,5,0x5,686,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209840, 0x80608000, 0x98200000, 0x08240902, 0x80608000, 0x98200000, 0x09240800, 0x00209806}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki163,42,8, "JH164",-1,-4,5,1,6,5,0x5,610,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x001064a0, 0x40904000, 0x64100000, 0x041a0601, 0x40904000, 0x64100000, 0x061a0400, 0x00106429}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki164,49,8, "JH165",-1,-5,5,1,6,6,0x5,686,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106480, 0x40904000, 0x64100000, 0x04180601, 0x40904000, 0x64100000, 0x06180400, 0x00106409}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki164,0,0.000000},
  {joseki165,56,8, "JH166",-1,-5,6,1,7,6,0x5,575,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00208860, 0x80208000, 0x88200000, 0x08220902, 0x80208000, 0x88200000, 0x09220800, 0x00208826}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki166,49,8, "JH167",-2,-4,4,2,6,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186000, 0x40902000, 0x24900000, 0x20180400, 0x20904000, 0x60180000, 0x04182000, 0x00902400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki166,0,0.000000},
  {joseki167,49,8, "JH168",-2,-4,4,2,6,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249800, 0x80609000, 0x98600000, 0x18240800, 0x90608000, 0x98240000, 0x08241800, 0x00609800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki168,49,8, "JH169",-2,-4,4,2,6,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186420, 0x40906000, 0x64900000, 0x241a0400, 0x60904000, 0x64180000, 0x041a2400, 0x00906420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki169,49,8, "JH170",-1,-5,5,1,6,6,0x5,611,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209060, 0x80600000, 0x18200000, 0x00260902, 0x00608000, 0x90200000, 0x09260000, 0x00201826}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki170,49,8, "JH171",-1,-5,5,1,6,6,0x5,647,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106090, 0x40900000, 0x26100000, 0x00190609, 0x00904080, 0x60100000, 0x06190000, 0x00102619}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki171,49,8, "JH172",-1,-4,5,2,6,6,0x5,612,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00286498, 0x40a06000, 0x64a00000, 0x26290600, 0x60a04000, 0x64280000, 0x06292600, 0x00a06498}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki172,49,8, "JH173",-1,-4,5,2,6,6,0x5,611,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00149864, 0x80509000, 0x98500000, 0x19160902, 0x90508000, 0x98140000, 0x09161900, 0x00509866}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki173,49,8, "JH174",-1,-4,5,2,6,6,0x5,650,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00286498, 0x40a06000, 0x66a00000, 0x26290609, 0x60a04080, 0x64280000, 0x06292600, 0x00a06699}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki174,49,8, "JH175",-2,-4,4,2,6,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki175,84,8, "JH176",-3,-3,8,3,11,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki176,63,8, "JH177",-3,-3,5,3,8,6,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200024, 0x00200000, 0x00200000, 0x01220000, 0x00200000, 0x00200000, 0x00220100, 0x00200060}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki177,84,8, "JH178",-3,-3,8,3,11,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100018, 0x00100000, 0x00100000, 0x02110000, 0x00100000, 0x00100000, 0x00110200, 0x00100090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki178,70,8, "JH179",-3,-3,6,3,9,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki179,63,8, "JH180",-3,-3,5,3,8,6,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200024, 0x00200000, 0x00200000, 0x01220000, 0x00200000, 0x00200000, 0x00220100, 0x00200060}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki180,56,8, "JH181",-3,-3,4,3,7,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100018, 0x00100000, 0x00100000, 0x02110000, 0x00100000, 0x00100000, 0x00110200, 0x00100090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki181,63,8, "JH182",-3,-3,5,3,8,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002000a4, 0x00200000, 0x00200000, 0x01220200, 0x00200000, 0x00200000, 0x02220100, 0x00200068}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki182,56,8, "JH183",-3,-3,4,3,7,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100858, 0x00108000, 0x80100000, 0x0a110100, 0x80100000, 0x08100000, 0x01110a00, 0x00108094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki183,66,8, "JH184",-3,-2,7,3,10,5,0x5,727,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki184,56,8, "JH185",-3,-3,4,3,7,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00140858, 0x00109000, 0x80500000, 0x1a110100, 0x90100000, 0x08140000, 0x01111a00, 0x00508094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki185,66,8, "JH186",-3,-2,7,3,10,5,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki186,56,8, "JH187",-3,-3,4,3,7,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00140858, 0x00109000, 0x80500000, 0x1a110100, 0x90100000, 0x08140000, 0x01111a00, 0x00508094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki187,56,8, "JH188",-3,-1,4,5,7,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110205, 0x00100090, 0x00100000, 0x01100000, 0x00100000, 0x02110000, 0x00100119, 0x00100040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki188,64,8, "JH189",-3,-2,4,5,7,7,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110a05, 0x00108090, 0x80100000, 0x09100000, 0x80100000, 0x0a110000, 0x00100919, 0x00108040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki189,66,8, "JH190",-3,-1,2,9,5,10,0x5,683,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki190,45,8, "JH191",-3,-1,5,3,8,4,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00140858, 0x00109000, 0x80500000, 0x1a110100, 0x90100000, 0x08140000, 0x01111a00, 0x00508094}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki190,0,0.000000},
  {joseki191,63,8, "JH192",-3,-3,5,3,8,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki191,3,0.000000},
  {joseki192,63,8, "JH193",-3,-3,5,3,8,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142858, 0x00909000, 0xa0500000, 0x1a190100, 0x90900000, 0x28140000, 0x01191a00, 0x0050a094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki193,63,8, "JH194",-3,-3,5,3,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002894a4, 0x80606000, 0x58a00000, 0x25260a00, 0x60608000, 0x94280000, 0x0a262500, 0x00a05868}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki193,3,0.000000},
  {joseki194,63,8, "JH195",-3,-2,5,4,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00251a16, 0x00609090, 0x90600000, 0x19250000, 0x90600000, 0x1a250000, 0x0025191a, 0x00609050}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki195,63,8, "JH196",-3,-1,5,5,8,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x0026090a, 0x00209060, 0x80600000, 0x1a200000, 0x90200000, 0x09260000, 0x00201a26, 0x00608080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki195,3,0.000000},
  {joseki196,63,8, "JH197",-2,-2,6,4,8,6,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki197,63,8, "JH198",-2,-2,6,4,8,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00109a25, 0x80508080, 0x98100000, 0x09160800, 0x80508000, 0x9a100000, 0x08160909, 0x00109860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki197,0,0.000000},
  {joseki198,63,8, "JH199",-2,-2,6,4,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki199,63,8, "JH200",-2,-1,6,5,8,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki199,3,0.000000},
  {joseki200,63,8, "JH201",-1,-3,7,3,8,6,0x5,610,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00208095, 0x80200000, 0x09200000, 0x01210a05, 0x00208040, 0x80200000, 0x0a210101, 0x00200959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki201,63,8, "JH202",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki201,3,0.000000},
  {joseki202,63,8, "JH203",-1,-1,7,5,8,6,0x5,759,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki203,63,8, "JH204",-1,-1,7,5,8,6,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212626, 0x00a04090, 0x60200000, 0x052a0000, 0x40a00000, 0x26210000, 0x002a051a, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki203,3,0.000000},
  {joseki204,63,8, "JH205",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1919, 0x0050a060, 0x90900000, 0x2a150000, 0xa0500000, 0x191a0000, 0x00152a25, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki205,63,8, "JH206",-1,-1,7,5,8,6,0x5,794,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki205,3,0.000000},
  {joseki206,63,8, "JH207",0,-4,8,2,8,6,0x5,686,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00209840, 0x80608000, 0x9a200000, 0x0824090a, 0x80608080, 0x98200000, 0x09240800, 0x00209a06}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki207,63,8, "JH208",0,-4,8,2,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x001064a0, 0x40904000, 0x65100000, 0x041a0605, 0x40904040, 0x64100000, 0x061a0400, 0x00106529}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki207,0,0.000000},
  {joseki208,63,8, "JH209",0,-3,8,3,8,6,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0028a694, 0x80a06080, 0x69a00000, 0x25290a05, 0x60a08040, 0xa6280000, 0x0a292508, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki209,63,8, "JH210",0,-3,8,3,8,6,0x5,795,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00165968, 0x40509060, 0x96500000, 0x1a16050a, 0x90504080, 0x59160000, 0x05161a24, 0x005096a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki209,0,0.000000},
  {joseki210,72,8, "JH211",0,-4,8,3,8,7,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0028a694, 0x80a06080, 0x69a00000, 0x25290a05, 0x60a08040, 0xa6280000, 0x0a292508, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki211,63,8, "JH212",-1,-1,7,5,8,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki211,3,0.000000},
  {joseki212,63,8, "JH213",-1,-1,7,5,8,6,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1919, 0x0050a060, 0x90900000, 0x2a150000, 0xa0500000, 0x191a0000, 0x00152a25, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki213,63,8, "JH214",-1,-1,7,5,8,6,0x5,794,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki213,3,0.000000},
  {joseki214,63,8, "JH215",0,-4,8,2,8,6,0x5,686,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00209844, 0x80608000, 0x9a200000, 0x0924090a, 0x80608080, 0x98200000, 0x09240900, 0x00209a46}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki215,63,8, "JH216",0,-4,8,2,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x001064a8, 0x40904000, 0x65100000, 0x061a0605, 0x40904040, 0x64100000, 0x061a0600, 0x001065a9}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki215,0,0.000000},
  {joseki216,63,8, "JH217",0,-3,8,3,8,6,0x5,796,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0028a695, 0x80a06080, 0x69a00000, 0x25290a05, 0x60a08040, 0xa6280000, 0x0a292509, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki217,63,8, "JH218",0,-3,8,3,8,6,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0014596a, 0x40509040, 0x96500000, 0x1a16050a, 0x90504080, 0x59140000, 0x05161a06, 0x005096a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki217,0,0.000000},
  {joseki218,63,8, "JH219",0,-3,8,3,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002aa695, 0x80a060a0, 0x69a00000, 0x25290a05, 0x60a08040, 0xa62a0000, 0x0a292529, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki219,63,8, "JH220",-2,-1,6,5,8,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki219,3,0.000000},
  {joseki220,63,8, "JH221",-1,-2,7,4,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206065, 0x40a00000, 0x24200000, 0x012a0500, 0x00a04000, 0x60200000, 0x052a0101, 0x00202464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki221,63,8, "JH222",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki221,3,0.000000},
  {joseki222,63,8, "JH223",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00181819, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a01, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki223,63,8, "JH224",-1,-1,7,5,8,6,0x5,831,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki223,3,0.000000},
  {joseki224,63,8, "JH225",0,-5,8,1,8,6,0x5,722,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209000, 0x80600000, 0x18200000, 0x00240800, 0x00608000, 0x90200000, 0x08240000, 0x00201800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki225,63,8, "JH226",0,-5,8,1,8,6,0x5,688,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106800, 0x40908000, 0xa4100000, 0x08180400, 0x80904000, 0x68100000, 0x04180800, 0x0010a400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki225,0,0.000000},
  {joseki226,63,8, "JH227",0,-5,8,1,8,6,0x5,724,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209400, 0x80604000, 0x58200000, 0x04240800, 0x40608000, 0x94200000, 0x08240400, 0x00205800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki227,63,8, "JH228",0,-5,8,1,8,6,0x5,649,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106800, 0x40908000, 0xa4100000, 0x08180400, 0x80904000, 0x68100000, 0x04180800, 0x0010a400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki227,0,0.000000},
  {joseki228,63,8, "JH229",0,-5,8,1,8,6,0x5,612,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209480, 0x80604000, 0x58200000, 0x04240a00, 0x40608000, 0x94200000, 0x0a240400, 0x00205808}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki229,63,8, "JH230",0,-5,8,1,8,6,0x5,611,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106840, 0x40908000, 0xa4100000, 0x08180502, 0x80904000, 0x68100000, 0x05180800, 0x0010a406}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki229,0,0.000000},
  {joseki230,63,8, "JH231",0,-5,8,1,8,6,0x5,686,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209480, 0x80604000, 0x5a200000, 0x04240a09, 0x40608080, 0x94200000, 0x0a240400, 0x00205a09}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki231,63,8, "JH232",0,-5,8,1,8,6,0x5,725,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106860, 0x40908000, 0xa5100000, 0x081a0506, 0x80904040, 0x68100000, 0x051a0800, 0x0010a526}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki231,0,0.000000},
  {joseki232,63,8, "JH233",0,-5,8,1,8,6,0x5,573,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209490, 0x80604000, 0x5a200000, 0x04250a09, 0x40608080, 0x94200000, 0x0a250400, 0x00205a19}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki233,63,8, "JH234",0,-5,8,1,8,6,0x5,536,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106800, 0x40908000, 0xa4100000, 0x08180400, 0x80904000, 0x68100000, 0x04180800, 0x0010a400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki233,0,0.000000},
  {joseki234,63,8, "JH235",0,-1,8,5,8,6,0x5,648,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00201818, 0x00608000, 0x90200000, 0x0a250000, 0x80600000, 0x18200000, 0x00250a00, 0x00209090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki235,63,8, "JH236",0,-1,8,5,8,6,0x5,797,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0010a424, 0x80904000, 0x68100000, 0x051a0800, 0x40908000, 0xa4100000, 0x081a0500, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki235,0,0.000000},
  {joseki236,63,8, "JH237",0,-1,8,5,8,6,0x5,760,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00205818, 0x40608000, 0x94200000, 0x0a250400, 0x80604000, 0x58200000, 0x04250a00, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki237,63,8, "JH238",0,-1,8,5,8,6,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0010a426, 0x80904000, 0x68100000, 0x051a0800, 0x40908000, 0xa4100000, 0x081a0502, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki237,0,0.000000},
  {joseki238,63,8, "JH239",0,-1,8,5,8,6,0x5,834,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00205a19, 0x40608080, 0x94200000, 0x0a250400, 0x80604000, 0x5a200000, 0x04250a09, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki239,63,8, "JH240",0,-1,8,5,8,6,0x5,795,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0010a526, 0x80904040, 0x68100000, 0x051a0800, 0x40908000, 0xa5100000, 0x081a0506, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki239,0,0.000000},
  {joseki240,63,8, "JH241",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00205a19, 0x40608080, 0x94200000, 0x0a250400, 0x80604000, 0x5a200000, 0x04250a09, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki241,63,8, "JH242",0,-1,8,5,8,6,0x5,760,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0010a424, 0x80904000, 0x68100000, 0x051a0800, 0x40908000, 0xa4100000, 0x081a0500, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki241,0,0.000000},
  {joseki242,72,8, "JH243",0,-2,8,5,8,7,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0020581a, 0x40608000, 0x94200000, 0x0a250400, 0x80604000, 0x58200000, 0x04250a02, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki243,63,8, "JH244",0,-1,8,5,8,6,0x5,795,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki243,0,0.000000},
  {joseki244,63,8, "JH245",0,-1,8,5,8,6,0x5,797,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki245,63,8, "JH246",0,-1,8,5,8,6,0x5,834,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki245,0,0.000000},
  {joseki246,63,8, "JH247",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki247,63,8, "JH248",0,-1,8,5,8,6,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001aa425, 0x80906020, 0x68900000, 0x251a0800, 0x60908000, 0xa41a0000, 0x081a2521, 0x00906860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki247,0,0.000000},
  {joseki248,72,8, "JH249",0,-2,8,5,8,7,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00205a1a, 0x40608080, 0x94200000, 0x0a250400, 0x80604000, 0x5a200000, 0x04250a0a, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki249,63,8, "JH250",0,-1,8,5,8,6,0x5,797,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki249,0,0.000000},
  {joseki250,63,8, "JH251",0,-1,8,5,8,6,0x5,834,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki251,63,8, "JH252",0,-1,8,5,8,6,0x5,795,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki251,0,0.000000},
  {joseki252,63,8, "JH253",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki253,63,8, "JH254",0,-1,8,5,8,6,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001aa425, 0x80906020, 0x68900000, 0x251a0800, 0x60908000, 0xa41a0000, 0x081a2521, 0x00906860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki253,0,0.000000},
  {joseki254,63,8, "JH255",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00205a1a, 0x40608080, 0x94200000, 0x0a250400, 0x80604000, 0x5a200000, 0x04250a0a, 0x00209490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki255,63,8, "JH256",0,-1,8,5,8,6,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0018a525, 0x80906040, 0x68900000, 0x251a0800, 0x60908000, 0xa5180000, 0x081a2505, 0x00906860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki255,0,0.000000},
  {joseki256,63,8, "JH257",0,-1,8,5,8,6,0x5,873,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0011a525, 0x80904050, 0x68100000, 0x051a0800, 0x40908000, 0xa5110000, 0x081a0515, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki256,0,0.000000},
  {joseki257,18,8, "JH258",0,-3,1,5,1,8,0x5,647,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x0011a500, 0x80904050, 0x68100000, 0x04180800, 0x40908000, 0xa5110000, 0x08180414, 0x00106800}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki257,0,0.000000},
  {joseki258,20,8, "JH259",0,-3,1,6,1,9,0x5,648,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x00281600, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242408, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki259,20,8, "JH260",0,-3,1,6,1,9,0x5,647,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x0014a900, 0x80909040, 0xa8500000, 0x18180800, 0x90908000, 0xa9140000, 0x08181804, 0x0050a800}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki259,0,0.000000},
  {joseki260,20,8, "JH261",0,-2,1,7,1,9,0x5,648,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x002a1500, 0x00606060, 0x50a00000, 0x24240000, 0x60600000, 0x152a0000, 0x00242424, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki261,63,8, "JH262",0,-1,8,5,8,6,0x5,873,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki261,0,0.000000},
  {joseki262,63,8, "JH263",0,-1,8,5,8,6,0x5,797,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki263,63,8, "JH264",0,-1,8,5,8,6,0x5,834,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki263,0,0.000000},
  {joseki264,63,8, "JH265",0,-1,8,5,8,6,0x5,871,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki265,63,8, "JH266",0,-1,8,5,8,6,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki265,0,0.000000},
  {joseki266,63,8, "JH267",0,-1,8,5,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00215a1a, 0x40608090, 0x94200000, 0x0a250400, 0x80604000, 0x5a210000, 0x04250a1a, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki267,63,8, "JH268",0,0,8,6,8,6,0x5,832,
    { 0x003f3f3f, 0x00f0f0f0, 0xf0f00000, 0x3f3f0000, 0xf0f00000, 0x3f3f0000, 0x003f3f3f, 0x00f0f0f0},
    { 0x00242909, 0x00a09040, 0xa0600000, 0x1a280000, 0x90a00000, 0x29240000, 0x00281a05, 0x0060a080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki267,3,0.000000},
  {joseki268,63,8, "JH269",0,0,8,6,8,6,0x5,758,
    { 0x003f3f3f, 0x00f0f0f0, 0xf0f00000, 0x3f3f0000, 0xf0f00000, 0x3f3f0000, 0x003f3f3f, 0x00f0f0f0},
    { 0x00181606, 0x00506080, 0x50900000, 0x25140000, 0x60500000, 0x16180000, 0x0014250a, 0x00905040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki269,63,8, "JH270",0,0,8,6,8,6,0x5,721,
    { 0x003f3f3f, 0x00f0f0f0, 0xf0f00000, 0x3f3f0000, 0xf0f00000, 0x3f3f0000, 0x003f3f3f, 0x00f0f0f0},
    { 0x00222909, 0x00a08060, 0xa0200000, 0x0a280000, 0x80a00000, 0x29220000, 0x00280a25, 0x0020a080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki269,3,0.000000},
  {joseki270,63,8, "JH271",0,0,8,6,8,6,0x5,758,
    { 0x003f3f3f, 0x00f0f0f0, 0xf0f00000, 0x3f3f0000, 0xf0f00000, 0x3f3f0000, 0x003f3f3f, 0x00f0f0f0},
    { 0x00181606, 0x00506080, 0x50900000, 0x25140000, 0x60500000, 0x16180000, 0x0014250a, 0x00905040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki271,63,8, "JH272",0,-1,8,5,8,6,0x5,795,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0012a425, 0x80904020, 0x68100000, 0x051a0800, 0x40908000, 0xa4120000, 0x081a0521, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki271,0,0.000000},
  {joseki272,63,8, "JH273",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0021581a, 0x40608010, 0x94200000, 0x0a250400, 0x80604000, 0x58210000, 0x04250a12, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki273,63,8, "JH274",0,-1,8,5,8,6,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001aa425, 0x80906020, 0x68900000, 0x251a0800, 0x60908000, 0xa41a0000, 0x081a2521, 0x00906860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki273,0,0.000000},
  {joseki274,63,8, "JH275",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00205a1a, 0x40608080, 0x94200000, 0x0a250400, 0x80604000, 0x5a200000, 0x04250a0a, 0x00209490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki275,63,8, "JH276",0,-1,8,5,8,6,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x0018a525, 0x80906040, 0x68900000, 0x251a0800, 0x60908000, 0xa5180000, 0x081a2505, 0x00906860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki275,0,0.000000},
  {joseki276,45,8, "JH277",0,-3,4,5,4,8,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011a525, 0x80904050, 0x68100000, 0x051a0800, 0x40908000, 0xa5110000, 0x081a0515, 0x00106860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki276,0,0.000000},
  {joseki277,45,8, "JH278",0,-2,4,6,4,8,0x5,648,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00281606, 0x00606080, 0x50a00000, 0x25240000, 0x60600000, 0x16280000, 0x0024250a, 0x00a05040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki278,30,8, "JH279",0,-3,2,6,2,9,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0014a909, 0x80909040, 0xa8500000, 0x1a180800, 0x90908000, 0xa9140000, 0x08181a05, 0x0050a880}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki278,0,0.000000},
  {joseki279,20,8, "JH280",0,-2,1,7,1,9,0x5,648,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x002a1500, 0x00606060, 0x50a00000, 0x24240000, 0x60600000, 0x152a0000, 0x00242424, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki280,20,8, "JH281",0,-2,1,7,1,9,0x5,647,
    { 0x00ffff00, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0xf0f0f0f0, 0xffff0000, 0x3c3c3c3c, 0x00ffff00},
    { 0x002a1500, 0x00606060, 0x50a00000, 0x24240000, 0x60600000, 0x152a0000, 0x00242424, 0x00a05000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki280,3,0.000000},
  {joseki281,63,8, "JH282",-1,-1,7,5,8,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki281,3,0.000000},
  {joseki282,63,8, "JH283",-1,-1,7,5,8,6,0x5,759,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00181819, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a01, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki283,63,8, "JH284",-1,-1,7,5,8,6,0x5,758,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242626, 0x00a05080, 0x60600000, 0x152a0000, 0x50a00000, 0x26240000, 0x002a150a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki283,3,0.000000},
  {joseki284,63,8, "JH285",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1919, 0x0050a060, 0x90900000, 0x2a150000, 0xa0500000, 0x191a0000, 0x00152a25, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki285,63,8, "JH286",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki285,3,0.000000},
  {joseki286,63,8, "JH287",-1,-1,7,5,8,6,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1919, 0x0050a060, 0x90900000, 0x2a150000, 0xa0500000, 0x191a0000, 0x00152a25, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki287,63,8, "JH288",-1,-1,7,5,8,6,0x5,794,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki287,3,0.000000},
  {joseki288,63,8, "JH289",0,-4,8,2,8,6,0x5,686,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00209844, 0x80608000, 0x9a200000, 0x0924090a, 0x80608080, 0x98200000, 0x09240900, 0x00209a46}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki289,63,8, "JH290",0,-4,8,2,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x001064a8, 0x40904000, 0x65100000, 0x061a0605, 0x40904040, 0x64100000, 0x061a0600, 0x001065a9}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki289,0,0.000000},
  {joseki290,72,8, "JH291",0,-4,8,3,8,7,0x5,796,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0028a695, 0x80a06080, 0x69a00000, 0x25290a05, 0x60a08040, 0xa6280000, 0x0a292509, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki291,63,8, "JH292",0,-3,8,3,8,6,0x5,762,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0014596a, 0x40509040, 0x96500000, 0x1a16050a, 0x90504080, 0x59140000, 0x05161a06, 0x005096a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki291,0,0.000000},
  {joseki292,72,8, "JH293",0,-4,8,3,8,7,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0028a695, 0x80a06080, 0x69a00000, 0x25290a05, 0x60a08040, 0xa6280000, 0x0a292509, 0x00a06959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki293,63,8, "JH294",-2,-1,6,5,8,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki293,3,0.000000},
  {joseki294,63,8, "JH295",-2,-1,6,5,8,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1906, 0x0050a060, 0x90900000, 0x29140000, 0xa0500000, 0x191a0000, 0x00142926, 0x00909040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki295,63,8, "JH296",-1,-4,7,2,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x002040a8, 0x40200000, 0x05200000, 0x02220605, 0x00204040, 0x40200000, 0x06220200, 0x002005a9}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki295,3,0.000000},
  {joseki296,63,8, "JH297",-1,-3,7,3,8,6,0x5,758,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0024a095, 0x80a01000, 0x29600000, 0x11290a05, 0x10a08040, 0xa0240000, 0x0a291101, 0x00602959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki297,63,8, "JH298",-1,-3,7,3,8,6,0x5,610,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x001a506a, 0x40502020, 0x16900000, 0x2216050a, 0x20504080, 0x501a0000, 0x05162222, 0x009016a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki297,0,0.000000},
  {joseki298,63,8, "JH299",-1,-1,7,5,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00221a19, 0x006080a0, 0x90200000, 0x0a250000, 0x80600000, 0x1a220000, 0x00250a29, 0x00209090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki299,63,8, "JH300",-1,0,7,6,8,6,0x5,907,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00240909, 0x00209040, 0x80600000, 0x1a200000, 0x90200000, 0x09240000, 0x00201a05, 0x00608080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki299,3,0.000000},
  {joseki300,63,8, "JH301",-1,0,7,6,8,6,0x5,908,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00180606, 0x00106080, 0x40900000, 0x25100000, 0x60100000, 0x06180000, 0x0010250a, 0x00904040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki301,63,8, "JH302",-1,0,7,6,8,6,0x5,906,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00240909, 0x00209040, 0x80600000, 0x1a200000, 0x90200000, 0x09240000, 0x00201a05, 0x00608080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki301,3,0.000000},
  {joseki302,63,8, "JH303",-1,0,7,6,8,6,0x5,833,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00180606, 0x00106080, 0x40900000, 0x25100000, 0x60100000, 0x06180000, 0x0010250a, 0x00904040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki303,63,8, "JH304",-1,0,7,6,8,6,0x5,831,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00240909, 0x00209040, 0x80600000, 0x1a200000, 0x90200000, 0x09240000, 0x00201a05, 0x00608080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki303,3,0.000000},
  {joseki304,63,8, "JH305",0,-4,8,2,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00209692, 0x80604080, 0x58200000, 0x04250a02, 0x40608000, 0x96200000, 0x0a25040a, 0x0020581a}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki305,63,8, "JH306",-2,-2,6,4,8,6,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00109a25, 0x80508080, 0x98100000, 0x09160800, 0x80508000, 0x9a100000, 0x08160909, 0x00109860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki305,0,0.000000},
  {joseki306,63,8, "JH307",-2,-2,6,4,8,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki307,63,8, "JH308",-2,-2,6,4,8,6,0x5,799,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00109a25, 0x80508080, 0x98100000, 0x09160800, 0x80508000, 0x9a100000, 0x08160909, 0x00109860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki307,0,0.000000},
  {joseki308,63,8, "JH309",-2,-2,6,4,8,6,0x5,763,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki309,63,8, "JH310",-2,-2,6,4,8,6,0x5,800,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00109a25, 0x80508080, 0x98100000, 0x09160800, 0x80508000, 0x9a100000, 0x08160909, 0x00109860}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki309,0,0.000000},
  {joseki310,63,8, "JH311",-2,-2,6,4,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki311,63,8, "JH312",-2,-1,6,5,8,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki311,3,0.000000},
  {joseki312,63,8, "JH313",-1,-3,7,3,8,6,0x5,610,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00208095, 0x80200000, 0x09200000, 0x01210a05, 0x00208040, 0x80200000, 0x0a210101, 0x00200959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki313,63,8, "JH314",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki313,3,0.000000},
  {joseki314,63,8, "JH315",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki315,63,8, "JH316",-1,-1,7,5,8,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki315,3,0.000000},
  {joseki316,63,8, "JH317",-1,-1,7,5,8,6,0x5,759,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki317,63,8, "JH318",-1,-1,7,5,8,6,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212626, 0x00a04090, 0x60200000, 0x052a0000, 0x40a00000, 0x26210000, 0x002a051a, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki317,3,0.000000},
  {joseki318,72,8, "JH319",-1,-2,7,5,8,7,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x001a1919, 0x0050a060, 0x90900000, 0x2a150000, 0xa0500000, 0x191a0000, 0x00152a25, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki319,63,8, "JH320",-1,-1,7,5,8,6,0x5,794,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00252626, 0x00a05090, 0x60600000, 0x152a0000, 0x50a00000, 0x26250000, 0x002a151a, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki319,3,0.000000},
  {joseki320,63,8, "JH321",0,-4,8,2,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00209844, 0x80608000, 0x9a200000, 0x0924090a, 0x80608080, 0x98200000, 0x09240900, 0x00209a46}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki321,63,8, "JH322",0,-2,8,4,8,6,0x5,760,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00219698, 0x80604090, 0x58200000, 0x06250a00, 0x40608000, 0x96210000, 0x0a250618, 0x00205898}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki321,3,0.000000},
  {joseki322,72,8, "JH323",0,-3,8,4,8,7,0x5,836,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00126866, 0x40908020, 0xa4100000, 0x091a0500, 0x80904000, 0x68120000, 0x051a0922, 0x0010a464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki323,63,8, "JH324",-1,-1,7,5,8,6,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki323,3,0.000000},
  {joseki324,63,8, "JH325",-1,-1,7,5,8,6,0x5,872,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki325,63,8, "JH326",-1,-1,7,5,8,6,0x5,836,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki325,3,0.000000},
  {joseki326,63,8, "JH327",-1,-1,7,5,8,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki327,63,8, "JH328",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki327,3,0.000000},
  {joseki328,63,8, "JH329",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00121819, 0x00508020, 0x90100000, 0x0a150000, 0x80500000, 0x18120000, 0x00150a21, 0x00109090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki329,63,8, "JH330",-1,-1,7,5,8,6,0x5,831,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00212426, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0512, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki329,3,0.000000},
  {joseki330,63,8, "JH331",0,-5,8,1,8,6,0x5,722,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209060, 0x80600000, 0x1a200000, 0x00260908, 0x00608080, 0x90200000, 0x09260000, 0x00201a24}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki331,63,8, "JH332",-2,-1,6,5,8,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki331,3,0.000000},
  {joseki332,63,8, "JH333",-1,-2,7,4,8,6,0x5,835,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206065, 0x40a00000, 0x24200000, 0x012a0500, 0x00a04000, 0x60200000, 0x052a0101, 0x00202464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki333,63,8, "JH334",-1,-2,7,4,8,6,0x5,799,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010909a, 0x80500000, 0x18100000, 0x02150a00, 0x00508000, 0x90100000, 0x0a150202, 0x00101898}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki333,0,0.000000},
  {joseki334,63,8, "JH335",-1,-2,7,4,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206065, 0x40a00000, 0x24200000, 0x012a0500, 0x00a04000, 0x60200000, 0x052a0101, 0x00202464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki335,63,8, "JH336",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki335,3,0.000000},
  {joseki336,63,8, "JH337",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00181819, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a01, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki337,63,8, "JH338",-1,-1,7,5,8,6,0x5,831,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki337,3,0.000000},
  {joseki338,63,8, "JH339",0,-5,8,1,8,6,0x5,649,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209000, 0x80600000, 0x18200000, 0x00240800, 0x00608000, 0x90200000, 0x08240000, 0x00201800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki339,63,8, "JH340",0,-5,8,1,8,6,0x5,573,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106080, 0x40900000, 0x24100000, 0x00180600, 0x00904000, 0x60100000, 0x06180000, 0x00102408}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki339,0,0.000000},
  {joseki340,63,8, "JH341",0,-2,8,4,8,6,0x5,722,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00206261, 0x40a00080, 0x24200000, 0x002a0500, 0x00a04000, 0x62200000, 0x052a0009, 0x00202424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki341,63,8, "JH342",0,-2,8,4,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00109992, 0x80508040, 0x98100000, 0x08150a00, 0x80508000, 0x99100000, 0x0a150806, 0x00109818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki341,0,0.000000},
  {joseki342,63,8, "JH343",0,-2,8,4,8,6,0x5,723,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00286661, 0x40a06080, 0x64a00000, 0x242a0500, 0x60a04000, 0x66280000, 0x052a2409, 0x00a06424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki343,63,8, "JH344",0,-2,8,4,8,6,0x5,833,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0014999a, 0x80509040, 0x98500000, 0x1a150a00, 0x90508000, 0x99140000, 0x0a151a06, 0x00509898}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki343,0,0.000000},
  {joseki344,63,8, "JH345",0,-2,8,4,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00286665, 0x40a06080, 0x64a00000, 0x252a0500, 0x60a04000, 0x66280000, 0x052a2509, 0x00a06464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki345,63,8, "JH346",-1,-1,7,5,8,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki345,3,0.000000},
  {joseki346,63,8, "JH347",-1,-1,7,5,8,6,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00181819, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a01, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki347,63,8, "JH348",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki347,3,0.000000},
  {joseki348,63,8, "JH349",-1,-1,7,5,8,6,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00181819, 0x0050a000, 0x90900000, 0x2a150000, 0xa0500000, 0x18180000, 0x00152a01, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki349,63,8, "JH350",-1,-1,7,5,8,6,0x5,831,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242426, 0x00a05000, 0x60600000, 0x152a0000, 0x50a00000, 0x24240000, 0x002a1502, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki349,3,0.000000},
  {joseki350,63,8, "JH351",0,-5,8,1,8,6,0x5,649,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00209000, 0x80600000, 0x18200000, 0x00240800, 0x00608000, 0x90200000, 0x08240000, 0x00201800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki351,63,8, "JH352",0,-5,8,1,8,6,0x5,573,
    { 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff},
    { 0x00106080, 0x40900000, 0x24100000, 0x00180600, 0x00904000, 0x60100000, 0x06180000, 0x00102408}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki351,0,0.000000},
  {joseki352,63,8, "JH353",0,-2,8,4,8,6,0x5,722,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00206261, 0x40a00080, 0x24200000, 0x002a0500, 0x00a04000, 0x62200000, 0x052a0009, 0x00202424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki353,63,8, "JH354",0,-2,8,4,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00109992, 0x80508040, 0x98100000, 0x08150a00, 0x80508000, 0x99100000, 0x0a150806, 0x00109818}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki353,0,0.000000},
  {joseki354,63,8, "JH355",0,-2,8,4,8,6,0x5,723,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00286661, 0x40a06080, 0x64a00000, 0x242a0500, 0x60a04000, 0x66280000, 0x052a2409, 0x00a06424}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki355,63,8, "JH356",0,-2,8,4,8,6,0x5,833,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0014999a, 0x80509040, 0x98500000, 0x1a150a00, 0x90508000, 0x99140000, 0x0a151a06, 0x00509898}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki355,0,0.000000},
  {joseki356,63,8, "JH357",0,-2,8,4,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x00286665, 0x40a06080, 0x64a00000, 0x252a0500, 0x60a04000, 0x66280000, 0x052a2509, 0x00a06464}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki357,63,8, "JH358",-2,-1,6,5,8,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00242609, 0x00a05080, 0x60600000, 0x16280000, 0x50a00000, 0x26240000, 0x00281609, 0x00606080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki357,3,0.000000},
  {joseki358,63,8, "JH359",-2,-1,6,5,8,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a1906, 0x0050a060, 0x90900000, 0x29140000, 0xa0500000, 0x191a0000, 0x00142926, 0x00909040}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki359,63,8, "JH360",-1,-4,7,2,8,6,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x002040a8, 0x40200000, 0x05200000, 0x02220605, 0x00204040, 0x40200000, 0x06220200, 0x002005a9}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki359,3,0.000000},
  {joseki360,63,8, "JH361",-1,-4,7,2,8,6,0x5,722,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a054, 0x80900000, 0x2a100000, 0x0119090a, 0x00908080, 0xa0100000, 0x09190100, 0x00102a56}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki361,63,8, "JH362",-1,-4,7,2,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x002058a8, 0x40608000, 0x95200000, 0x0a260605, 0x80604040, 0x58200000, 0x06260a00, 0x002095a9}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki361,3,0.000000},
  {joseki362,63,8, "JH363",-1,-3,7,3,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0024a995, 0x80a09040, 0xa9600000, 0x19290a05, 0x90a08040, 0xa9240000, 0x0a291905, 0x0060a959}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki363,63,8, "JH364",-1,-2,7,4,8,6,0x5,720,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0026959a, 0x80605060, 0x58600000, 0x16250a00, 0x50608000, 0x95260000, 0x0a251626, 0x00605898}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki363,3,0.000000},
  {joseki364,63,8, "JH365",0,-3,8,3,8,6,0x5,647,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002064a9, 0x40a04000, 0x64200000, 0x062a0601, 0x40a04000, 0x64200000, 0x062a0601, 0x002064a9}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki365,63,8, "JH366",-3,-3,5,3,8,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki365,3,0.000000},
  {joseki366,63,8, "JH367",-3,-3,5,3,8,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00160858, 0x00109020, 0x80500000, 0x1a110100, 0x90100000, 0x08160000, 0x01111a20, 0x00508094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki367,63,8, "JH368",-2,-5,6,1,8,6,0x5,612,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x00240908, 0x00608080, 0x90200000, 0x09240000, 0x00201a04}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki367,3,0.000000},
  {joseki368,63,8, "JH369",-2,-5,6,1,8,6,0x5,575,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00106080, 0x40900000, 0x25100000, 0x00180606, 0x00904040, 0x60100000, 0x06180000, 0x0010250a}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki369,63,8, "JH370",-2,-5,6,1,8,6,0x5,574,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x00240909, 0x00608080, 0x90200000, 0x09240000, 0x00201a05}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki369,3,0.000000},
  {joseki370,63,8, "JH371",-2,-5,6,1,8,6,0x5,537,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00106080, 0x40900000, 0x25100000, 0x00180606, 0x00904040, 0x60100000, 0x06180000, 0x0010250a}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki371,63,8, "JH372",-2,-5,6,1,8,6,0x5,573,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x00240909, 0x00608080, 0x90200000, 0x09240000, 0x00201a05}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki371,3,0.000000},
  {joseki372,63,8, "JH373",-2,-2,6,4,8,6,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki373,63,8, "JH374",-1,-3,7,3,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00204269, 0x40200080, 0x04200000, 0x02220502, 0x00204000, 0x42200000, 0x05220209, 0x002004a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki373,3,0.000000},
  {joseki374,63,8, "JH375",-1,-2,7,4,8,6,0x5,722,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00242065, 0x00a01000, 0x20600000, 0x112a0100, 0x10a00000, 0x20240000, 0x012a1101, 0x00602064}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki375,63,8, "JH376",-1,-3,7,3,8,6,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00204269, 0x40200080, 0x04200000, 0x02220502, 0x00204000, 0x42200000, 0x05220209, 0x002004a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki375,3,0.000000},
  {joseki376,63,8, "JH377",-1,-3,7,3,8,6,0x5,722,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a196, 0x80900040, 0x28100000, 0x01190a01, 0x00908000, 0xa1100000, 0x0a190106, 0x00102859}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki377,63,8, "JH378",-1,-3,7,3,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00205a69, 0x40608080, 0x94200000, 0x0a260502, 0x80604000, 0x5a200000, 0x05260a09, 0x002094a6}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki377,3,0.000000},
  {joseki378,63,8, "JH379",-1,-2,7,4,8,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00242965, 0x00a09040, 0xa0600000, 0x192a0100, 0x90a00000, 0x29240000, 0x012a1905, 0x0060a064}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki379,63,8, "JH380",-1,-1,7,5,8,6,0x5,795,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00260526, 0x00205060, 0x40600000, 0x15220000, 0x50200000, 0x05260000, 0x00221526, 0x00604060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki379,3,0.000000},
  {joseki380,63,8, "JH381",-1,-1,7,5,8,6,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00190a19, 0x0010a090, 0x80900000, 0x2a110000, 0xa0100000, 0x0a190000, 0x00112a19, 0x00908090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki381,63,8, "JH382",-1,-1,7,5,8,6,0x5,757,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00262526, 0x00a05060, 0x60600000, 0x152a0000, 0x50a00000, 0x25260000, 0x002a1526, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki381,3,0.000000},
  {joseki382,72,8, "JH383",0,-4,8,3,8,7,0x5,759,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002088a5, 0x80208000, 0x89200000, 0x09220a05, 0x80208040, 0x88200000, 0x0a220901, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki383,63,8, "JH384",0,-3,8,3,8,6,0x5,758,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0010465a, 0x40104080, 0x46100000, 0x0611050a, 0x40104080, 0x46100000, 0x0511060a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki383,0,0.000000},
  {joseki384,63,8, "JH385",0,-3,8,3,8,6,0x5,762,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki385,63,8, "JH386",0,-3,8,3,8,6,0x5,798,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki385,0,0.000000},
  {joseki386,72,8, "JH387",0,-4,8,3,8,7,0x5,799,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki387,63,8, "JH388",0,-3,8,3,8,6,0x5,763,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki387,0,0.000000},
  {joseki388,63,8, "JH389",0,-3,8,3,8,6,0x5,797,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki389,63,8, "JH390",0,-3,8,3,8,6,0x5,728,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki389,0,0.000000},
  {joseki390,63,8, "JH391",0,-3,8,3,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki391,63,8, "JH392",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00212425, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0511, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki391,3,0.000000},
  {joseki392,63,8, "JH393",0,-1,8,5,8,6,0x5,869,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki393,63,8, "JH394",0,-1,8,5,8,6,0x5,870,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00252425, 0x00a05010, 0x60600000, 0x152a0000, 0x50a00000, 0x24250000, 0x002a1511, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki393,3,0.000000},
  {joseki394,63,8, "JH395",0,-1,8,5,8,6,0x5,835,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00252425, 0x00a05010, 0x60600000, 0x152a0000, 0x50a00000, 0x24250000, 0x002a1511, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki394,3,0.000000},
  {joseki395,63,8, "JH396",0,-1,8,5,8,6,0x5,872,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki396,63,8, "JH397",0,-3,8,3,8,6,0x5,800,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki396,0,0.000000},
  {joseki397,63,8, "JH398",0,-3,8,3,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki398,63,8, "JH399",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00212425, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0511, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki398,3,0.000000},
  {joseki399,63,8, "JH400",0,-1,8,5,8,6,0x5,765,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki400,63,8, "JH401",0,-1,8,5,8,6,0x5,802,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00252425, 0x00a05010, 0x60600000, 0x152a0000, 0x50a00000, 0x24250000, 0x002a1511, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki400,3,0.000000},
  {joseki401,63,8, "JH402",0,-1,8,5,8,6,0x5,727,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki402,63,8, "JH403",0,-1,8,5,8,6,0x5,801,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00252425, 0x00a05010, 0x60600000, 0x152a0000, 0x50a00000, 0x24250000, 0x002a1511, 0x00606060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki402,3,0.000000},
  {joseki403,63,8, "JH404",0,-1,8,5,8,6,0x5,766,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki404,63,8, "JH405",0,-3,8,3,8,6,0x5,763,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki404,0,0.000000},
  {joseki405,63,8, "JH406",0,-3,8,3,8,6,0x5,798,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki406,63,8, "JH407",0,-3,8,3,8,6,0x5,796,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0011465a, 0x40104090, 0x46100000, 0x0611050a, 0x40104080, 0x46110000, 0x0511061a, 0x00104696}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki406,0,0.000000},
  {joseki407,63,8, "JH408",0,-3,8,3,8,6,0x5,610,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x002289a5, 0x80208060, 0x89200000, 0x09220a05, 0x80208040, 0x89220000, 0x0a220925, 0x00208969}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki408,63,8, "JH409",0,-1,8,5,8,6,0x5,721,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x00212425, 0x00a04010, 0x60200000, 0x052a0000, 0x40a00000, 0x24210000, 0x002a0511, 0x00206060}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki408,3,0.000000},
  {joseki409,63,8, "JH410",0,-1,8,5,8,6,0x5,871,
    { 0x00ffffff, 0xf0f0f0f0, 0xfcfc0000, 0x3f3f3f00, 0xf0f0f000, 0xffff0000, 0x3f3f3f3f, 0x00fcfcfc},
    { 0x001a181a, 0x0050a020, 0x90900000, 0x2a150000, 0xa0500000, 0x181a0000, 0x00152a22, 0x00909090}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki410,42,8, "JH411",-3,-2,3,3,6,5,0x5,609,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki410,3,0.000000},
  {joseki411,42,8, "JH412",-2,0,4,5,6,5,0x5,721,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki412,42,8, "JH413",-2,0,4,5,6,5,0x5,685,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00180200, 0x00102080, 0x00900000, 0x20100000, 0x20100000, 0x02180000, 0x00102008, 0x00900000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki412,0,0.000000},
  {joseki413,42,8, "JH414",-2,0,4,5,6,5,0x5,760,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00242100, 0x00a01040, 0x20600000, 0x10280000, 0x10a00000, 0x21240000, 0x00281004, 0x00602000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki414,49,8, "JH415",-2,-1,4,5,6,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00180200, 0x00102080, 0x00900000, 0x20100000, 0x20100000, 0x02180000, 0x00102008, 0x00900000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki414,0,0.000000},
  {joseki415,42,8, "JH416",-2,0,4,5,6,5,0x5,685,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00240100, 0x00201040, 0x00600000, 0x10200000, 0x10200000, 0x01240000, 0x00201004, 0x00600000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki416,66,8, "JH417",-3,-2,7,3,10,5,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki417,66,8, "JH418",-3,-2,7,3,10,5,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002804a4, 0x00206000, 0x40a00000, 0x25220200, 0x60200000, 0x04280000, 0x02222500, 0x00a04068}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki418,63,8, "JH419",-3,-3,5,3,8,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00140858, 0x00109000, 0x80500000, 0x1a110100, 0x90100000, 0x08140000, 0x01111a00, 0x00508094}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki419,63,8, "JH420",-3,-3,5,3,8,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002000a4, 0x00200000, 0x00200000, 0x01220200, 0x00200000, 0x00200000, 0x02220100, 0x00200068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki420,63,8, "JH421",-3,-3,5,3,8,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00180058, 0x00102000, 0x00900000, 0x22110100, 0x20100000, 0x00180000, 0x01112200, 0x00900094}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki421,63,8, "JH422",-3,-3,5,3,8,6,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002408a4, 0x00209000, 0x80600000, 0x19220200, 0x90200000, 0x08240000, 0x02221900, 0x00608068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki422,63,8, "JH423",-3,-3,5,3,8,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00180658, 0x00106080, 0x40900000, 0x26110100, 0x60100000, 0x06180000, 0x01112608, 0x00904094}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki423,40,8, "JH424",-3,-1,4,3,7,4,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x002429a4, 0x00a09040, 0xa0600000, 0x192a0200, 0x90a00000, 0x29240000, 0x022a1904, 0x0060a068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki424,54,8, "JH425",-3,-2,5,3,8,5,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181658, 0x00506080, 0x50900000, 0x26150100, 0x60500000, 0x16180000, 0x01152608, 0x00905094}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki425,54,8, "JH426",-2,-3,6,2,8,5,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002090a4, 0x80600000, 0x18200000, 0x01260a00, 0x00608000, 0x90200000, 0x0a260100, 0x00201868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki426,63,8, "JH427",-2,-4,6,2,8,6,0x5,614,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106858, 0x40908000, 0xa4100000, 0x0a190500, 0x80904000, 0x68100000, 0x05190a00, 0x0010a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki427,63,8, "JH428",-2,-4,6,2,8,6,0x5,652,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002094a4, 0x80604000, 0x58200000, 0x05260a00, 0x40608000, 0x94200000, 0x0a260500, 0x00205868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki428,63,8, "JH429",-3,-3,5,3,8,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100058, 0x00100000, 0x00100000, 0x02110100, 0x00100000, 0x00100000, 0x01110200, 0x00100094}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki429,63,8, "JH430",-2,-4,6,2,8,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki430,63,8, "JH431",-2,-3,6,3,8,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242000, 0x00a01000, 0x20600000, 0x10280000, 0x10a00000, 0x20240000, 0x00281000, 0x00602000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki431,63,8, "JH432",-2,-3,6,3,8,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181800, 0x0050a000, 0x90900000, 0x28140000, 0xa0500000, 0x18180000, 0x00142800, 0x00909000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki432,63,8, "JH433",-2,-3,6,3,8,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242408, 0x00a05000, 0x60600000, 0x16280000, 0x50a00000, 0x24240000, 0x00281600, 0x00606080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki433,63,8, "JH434",-2,-3,6,3,8,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181806, 0x0050a000, 0x90900000, 0x29140000, 0xa0500000, 0x18180000, 0x00142902, 0x00909040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki434,63,8, "JH435",-2,-3,6,3,8,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00242429, 0x00a05000, 0x60600000, 0x162a0000, 0x50a00000, 0x24240000, 0x002a1601, 0x006060a0}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki435,72,8, "JH436",-2,-4,6,3,8,7,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00181816, 0x0050a000, 0x90900000, 0x29150000, 0xa0500000, 0x18180000, 0x00152902, 0x00909050}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki436,56,8, "JH437",-3,-3,4,3,7,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100018, 0x00100000, 0x00100000, 0x02110000, 0x00100000, 0x00100000, 0x00110200, 0x00100090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki437,48,8, "JH438",-3,-2,4,3,7,5,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200824, 0x00208000, 0x80200000, 0x09220000, 0x80200000, 0x08200000, 0x00220900, 0x00208060}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki438,48,8, "JH439",-3,-2,4,3,7,5,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100498, 0x00104000, 0x40100000, 0x06110200, 0x40100000, 0x04100000, 0x02110600, 0x00104098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki439,63,8, "JH440",-3,-3,5,3,8,6,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202864, 0x00a08000, 0xa0200000, 0x092a0100, 0x80a00000, 0x28200000, 0x012a0900, 0x0020a064}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki440,56,8, "JH441",-3,-3,4,3,7,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00101498, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150600, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki441,54,8, "JH442",-3,-2,5,3,8,5,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00101498, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150600, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki442,60,8, "JH443",-3,-2,6,3,9,5,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202864, 0x00a08000, 0xa0200000, 0x092a0100, 0x80a00000, 0x28200000, 0x012a0900, 0x0020a064}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki443,54,8, "JH444",-3,-2,5,3,8,5,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00101498, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150600, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki444,60,8, "JH445",-3,-2,6,3,9,5,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202862, 0x00a08000, 0xa0200000, 0x082a0100, 0x80a00000, 0x28200000, 0x012a0802, 0x0020a024}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki445,63,8, "JH446",-3,-3,5,3,8,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00101491, 0x00504000, 0x50100000, 0x04150200, 0x40500000, 0x14100000, 0x02150401, 0x00105018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki446,70,8, "JH447",-3,-3,6,3,9,6,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202864, 0x00a08000, 0xa0200000, 0x092a0100, 0x80a00000, 0x28200000, 0x012a0900, 0x0020a064}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki447,56,8, "JH448",-3,-3,4,3,7,6,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00101498, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150600, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki448,36,8, "JH449",-3,0,2,5,5,5,0x5,794,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220206, 0x002000a0, 0x00200000, 0x01200000, 0x00200000, 0x02220000, 0x0020012a, 0x00200040}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki448,3,0.000000},
  {joseki449,36,8, "JH450",-2,-3,3,2,5,5,0x5,646,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204050, 0x40200000, 0x04200000, 0x00210500, 0x00204000, 0x40200000, 0x05210000, 0x00200414}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki450,36,8, "JH451",-1,-2,4,3,5,5,0x5,760,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00200420, 0x00204000, 0x40200000, 0x04220002, 0x40200000, 0x04200000, 0x00220400, 0x00204022}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki450,3,0.000000},
  {joseki451,36,8, "JH452",-1,-2,4,3,5,5,0x5,761,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00100812, 0x00108000, 0x80100000, 0x08110001, 0x80100000, 0x08100000, 0x00110802, 0x00108011}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki452,36,8, "JH453",-1,-2,4,3,5,5,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00200421, 0x00204000, 0x40200000, 0x04220002, 0x40200000, 0x04200000, 0x00220401, 0x00204022}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki452,3,0.000000},
  {joseki453,36,8, "JH454",-1,-2,4,3,5,5,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00102812, 0x00908000, 0xa0100000, 0x08190001, 0x80900000, 0x28100000, 0x00190802, 0x0010a011}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki454,36,8, "JH455",-1,-2,4,3,5,5,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00209421, 0x80604000, 0x58200000, 0x04260802, 0x40608000, 0x94200000, 0x08260401, 0x00205822}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki454,3,0.000000},
  {joseki455,36,8, "JH456",-1,-2,4,3,5,5,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00186812, 0x4090a000, 0xa4900000, 0x28190401, 0xa0904000, 0x68180000, 0x04192802, 0x0090a411}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki456,63,8, "JH457",-3,-3,5,3,8,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202864, 0x00a08000, 0xa0200000, 0x092a0100, 0x80a00000, 0x28200000, 0x012a0900, 0x0020a064}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki456,3,0.000000},
  {joseki457,80,8, "JH458",-3,-4,6,3,9,7,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010149a, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150602, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki458,70,8, "JH459",-3,-3,6,3,9,6,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202865, 0x00a08000, 0xa0200000, 0x092a0100, 0x80a00000, 0x28200000, 0x012a0901, 0x0020a064}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki459,70,8, "JH460",-3,-3,6,3,9,6,0x5,612,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010149a, 0x00504000, 0x50100000, 0x06150200, 0x40500000, 0x14100000, 0x02150602, 0x00105098}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki460,80,8, "JH461",-3,-4,6,3,9,7,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202865, 0x00a08000, 0xa0200000, 0x092a0102, 0x80a00000, 0x28200000, 0x012a0901, 0x0020a066}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki461,72,8, "JH462",-3,-4,5,3,8,7,0x5,613,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010149a, 0x00504000, 0x50100000, 0x06150201, 0x40500000, 0x14100000, 0x02150602, 0x00105099}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki462,63,8, "JH463",-3,-3,5,3,8,6,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00202865, 0x00a08000, 0xa0200000, 0x092a0102, 0x80a00000, 0x28200000, 0x012a0901, 0x0020a066}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki463,48,8, "JH464",-3,-2,4,3,7,5,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010169a, 0x00504080, 0x50100000, 0x06150201, 0x40500000, 0x16100000, 0x0215060a, 0x00105099}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki464,48,8, "JH465",-3,-2,4,3,7,5,0x5,720,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00222965, 0x00a08060, 0xa0200000, 0x092a0102, 0x80a00000, 0x29220000, 0x012a0925, 0x0020a066}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki465,56,8, "JH466",-2,-4,5,2,7,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a8a4, 0x80908000, 0xa8100000, 0x091a0a00, 0x80908000, 0xa8100000, 0x0a1a0900, 0x0010a868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki466,63,8, "JH467",-3,-3,5,3,8,6,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100018, 0x00100000, 0x00100000, 0x02110000, 0x00100000, 0x00100000, 0x00110200, 0x00100090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki467,63,8, "JH468",-3,-3,5,3,8,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200024, 0x00200000, 0x00200000, 0x01220000, 0x00200000, 0x00200000, 0x00220100, 0x00200060}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki468,63,8, "JH469",-3,-3,5,3,8,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00102018, 0x00900000, 0x20100000, 0x02190000, 0x00900000, 0x20100000, 0x00190200, 0x00102090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki469,63,8, "JH470",-3,-3,5,3,8,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002010a4, 0x00600000, 0x10200000, 0x01260200, 0x00600000, 0x10200000, 0x02260100, 0x00201068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki470,63,8, "JH471",-3,-3,5,3,8,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00102858, 0x00908000, 0xa0100000, 0x0a190100, 0x80900000, 0x28100000, 0x01190a00, 0x0010a094}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki471,63,8, "JH472",-3,-3,5,3,8,6,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002094a4, 0x80604000, 0x58200000, 0x05260a00, 0x40608000, 0x94200000, 0x0a260500, 0x00205868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki472,63,8, "JH473",-3,-3,5,3,8,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106858, 0x40908000, 0xa4100000, 0x0a190500, 0x80904000, 0x68100000, 0x05190a00, 0x0010a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki473,63,8, "JH474",-3,-3,5,3,8,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002094a4, 0x80604000, 0x58200000, 0x05260a00, 0x40608000, 0x94200000, 0x0a260500, 0x00205868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki474,63,8, "JH475",-3,-3,5,3,8,6,0x5,650,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106858, 0x40908000, 0xa4100000, 0x0a190500, 0x80904000, 0x68100000, 0x05190a00, 0x0010a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki475,63,8, "JH476",-3,-3,5,3,8,6,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002094a4, 0x80604000, 0x58200000, 0x05260a00, 0x40608000, 0x94200000, 0x0a260500, 0x00205868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki476,63,8, "JH477",-3,-3,5,3,8,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106858, 0x40908000, 0xa4100000, 0x0a190500, 0x80904000, 0x68100000, 0x05190a00, 0x0010a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki477,63,8, "JH478",-3,-3,5,3,8,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002894a4, 0x80606000, 0x58a00000, 0x25260a00, 0x60608000, 0x94280000, 0x0a262500, 0x00a05868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki478,63,8, "JH479",-3,-3,5,3,8,6,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0014685a, 0x40909000, 0xa4500000, 0x1a190500, 0x90904000, 0x68140000, 0x05191a02, 0x0050a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki479,63,8, "JH480",-3,-3,5,3,8,6,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002896a5, 0x80606080, 0x58a00000, 0x25260a00, 0x60608000, 0x96280000, 0x0a262509, 0x00a05868}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki480,63,8, "JH481",-3,-3,5,3,8,6,0x5,609,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0014695a, 0x40909040, 0xa4500000, 0x1a190500, 0x90904000, 0x69140000, 0x05191a06, 0x0050a494}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki481,42,8, "JH482",-3,-2,3,3,6,5,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100818, 0x00108000, 0x80100000, 0x0a110000, 0x80100000, 0x08100000, 0x00110a00, 0x00108090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki482,48,8, "JH483",-3,-2,4,3,7,5,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120018, 0x00100020, 0x00100000, 0x02110000, 0x00100000, 0x00120000, 0x00110220, 0x00100090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki483,48,8, "JH484",-3,-2,4,3,7,5,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120618, 0x001040a0, 0x40100000, 0x06110000, 0x40100000, 0x06120000, 0x00110628, 0x00104090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki484,48,8, "JH485",-3,-2,4,3,7,5,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0012061a, 0x001040a0, 0x40100000, 0x06110000, 0x40100000, 0x06120000, 0x0011062a, 0x00104090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki485,48,8, "JH486",-2,-3,5,2,7,5,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki486,64,8, "JH487",-3,-4,4,3,7,7,0x5,609,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100008, 0x00100000, 0x00100000, 0x02100000, 0x00100000, 0x00100000, 0x00100200, 0x00100080}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki487,56,8, "JH488",-2,-1,5,5,7,6,0x5,833,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki488,42,8, "JH489",-2,0,4,5,6,5,0x5,795,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki489,77,8, "JH490",-2,-1,8,5,10,6,0x5,801,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki490,110,8, "JH491",-2,-5,7,5,9,10,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki491,100,8, "JH492",-2,-2,7,7,9,9,0x5,906,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120000, 0x00100020, 0x00100000, 0x00100000, 0x00100000, 0x00120000, 0x00100020, 0x00100000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki492,63,8, "JH493",-1,-7,5,1,6,8,0x5,610,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209010, 0x80600000, 0x18200000, 0x00250802, 0x00608000, 0x90200000, 0x08250000, 0x00201812}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki493,63,8, "JH494",-1,-5,5,3,6,8,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x001a0921, 0x0010a060, 0x82900000, 0x28120008, 0xa0100080, 0x091a0000, 0x00122825, 0x00908220}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki494,77,8, "JH495",-2,-1,8,5,10,6,0x5,763,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki495,84,8, "JH496",-2,-1,9,5,11,6,0x5,763,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki496,99,8, "JH497",-2,-5,6,5,8,10,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki497,49,8, "JH498",-2,-1,4,5,6,6,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki498,49,8, "JH499",-2,-1,4,5,6,6,0x5,832,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki499,56,8, "JH500",-2,-1,5,5,7,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki500,42,8, "JH501",-2,0,4,5,6,5,0x5,834,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220200, 0x002000a0, 0x00200000, 0x00200000, 0x00200000, 0x02220000, 0x00200028, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki501,56,8, "JH502",-1,-5,6,1,7,6,0x5,721,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x0024090a, 0x00608080, 0x90200000, 0x09240000, 0x00201a06}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki502,42,8, "JH503",-1,-3,5,2,6,5,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202490, 0x00a04000, 0x60200000, 0x04290200, 0x40a00000, 0x24200000, 0x02290400, 0x00206018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki503,42,8, "JH504",-1,-3,5,2,6,5,0x5,650,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282490, 0x00a06000, 0x60a00000, 0x24290200, 0x60a00000, 0x24280000, 0x02292400, 0x00a06018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki504,42,8, "JH505",-1,-3,5,2,6,5,0x5,758,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282490, 0x00a06000, 0x60a00000, 0x24290202, 0x60a00000, 0x24280000, 0x02292400, 0x00a0601a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki505,42,8, "JH506",-1,-3,5,2,6,5,0x5,612,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00282690, 0x00a06080, 0x60a00000, 0x24290200, 0x60a00000, 0x26280000, 0x02292408, 0x00a06018}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki506,48,8, "JH507",-2,0,5,5,7,5,0x5,797,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki507,42,8, "JH508",-2,0,4,5,6,5,0x5,833,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki508,56,8, "JH509",-2,-1,5,5,7,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki509,48,8, "JH510",-2,0,5,5,7,5,0x5,834,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00200202, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x0020000a, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki510,56,8, "JH511",-2,-1,5,5,7,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100101, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100005, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki511,56,8, "JH512",-1,-4,6,2,7,6,0x5,651,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202494, 0x00a04000, 0x60200000, 0x05290200, 0x40a00000, 0x24200000, 0x02290500, 0x00206058}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki512,63,8, "JH513",-2,-1,6,5,8,6,0x5,834,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki512,0,0.000000},
  {joseki513,56,8, "JH514",-2,-1,5,5,7,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki514,63,8, "JH515",-2,-1,6,5,8,6,0x5,835,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100102, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100006, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki515,56,8, "JH516",-2,-1,5,5,7,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200201, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200009, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki516,63,8, "JH517",-2,-1,6,5,8,6,0x5,799,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100102, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100006, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki517,63,8, "JH518",-2,-1,6,5,8,6,0x5,762,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200201, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200009, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki518,63,8, "JH519",-2,-1,6,5,8,6,0x5,800,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100102, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100006, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki519,42,8, "JH520",-2,-1,3,5,5,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200201, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200009, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki520,42,8, "JH521",-2,-1,3,5,5,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00120102, 0x00100060, 0x00100000, 0x00100000, 0x00100000, 0x01120000, 0x00100026, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki521,42,8, "JH522",-2,-1,3,5,5,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210a01, 0x00208090, 0x80200000, 0x08200000, 0x80200000, 0x0a210000, 0x00200819, 0x00208000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki522,56,8, "JH523",-2,-1,5,5,7,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki522,0,0.000000},
  {joseki523,42,8, "JH524",-2,0,4,5,6,5,0x5,834,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki524,49,8, "JH525",-2,-1,4,5,6,6,0x5,831,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki525,35,8, "JH526",-1,-3,5,1,6,4,0x5,687,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x18200000, 0x00240902, 0x00608000, 0x90200000, 0x09240000, 0x00201806}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki526,42,8, "JH527",-1,-4,5,1,6,5,0x5,722,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106080, 0x40900000, 0x24100000, 0x00180601, 0x00904000, 0x60100000, 0x06180000, 0x00102409}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki527,56,8, "JH528",-1,-5,6,1,7,6,0x5,613,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209840, 0x80608000, 0x98200000, 0x08240902, 0x80608000, 0x98200000, 0x09240800, 0x00209806}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki528,49,8, "JH529",-1,-5,5,1,6,6,0x5,575,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106480, 0x40904000, 0x64100000, 0x04180601, 0x40904000, 0x64100000, 0x06180400, 0x00106409}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki529,42,8, "JH530",-1,-4,5,1,6,5,0x5,686,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209840, 0x80608000, 0x98200000, 0x08240902, 0x80608000, 0x98200000, 0x09240800, 0x00209806}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki530,42,8, "JH531",-1,-4,5,1,6,5,0x5,610,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x001064a0, 0x40904000, 0x64100000, 0x041a0601, 0x40904000, 0x64100000, 0x061a0400, 0x00106429}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki531,49,8, "JH532",-1,-5,5,1,6,6,0x5,686,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106480, 0x40904000, 0x64100000, 0x04180601, 0x40904000, 0x64100000, 0x06180400, 0x00106409}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki531,0,0.000000},
  {joseki532,56,8, "JH533",-1,-5,6,1,7,6,0x5,575,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00208860, 0x80208000, 0x88200000, 0x08220902, 0x80208000, 0x88200000, 0x09220800, 0x00208826}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki533,49,8, "JH534",-2,-1,4,5,6,6,0x5,833,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki534,49,8, "JH535",-2,-1,4,5,6,6,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200200, 0x00200080, 0x00200000, 0x00200000, 0x00200000, 0x02200000, 0x00200008, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki535,49,8, "JH536",-2,-1,4,5,6,6,0x5,831,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki536,49,8, "JH537",-1,-5,5,1,6,6,0x5,611,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209060, 0x80600000, 0x18200000, 0x00260902, 0x00608000, 0x90200000, 0x09260000, 0x00201826}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki537,49,8, "JH538",-1,-5,5,1,6,6,0x5,647,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00106090, 0x40900000, 0x26100000, 0x00190609, 0x00904080, 0x60100000, 0x06190000, 0x00102619}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki538,49,8, "JH539",-1,-4,5,2,6,6,0x5,612,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00286498, 0x40a06000, 0x64a00000, 0x26290600, 0x60a04000, 0x64280000, 0x06292600, 0x00a06498}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki539,60,8, "JH540",-3,-2,6,3,9,5,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200084, 0x00200000, 0x00200000, 0x01200200, 0x00200000, 0x00200000, 0x02200100, 0x00200048}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki540,63,8, "JH541",-3,-5,3,3,6,8,0x5,609,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200004, 0x00200000, 0x00200000, 0x01200000, 0x00200000, 0x00200000, 0x00200100, 0x00200040}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki541,49,8, "JH542",-2,-1,4,5,6,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki542,49,8, "JH543",-2,-1,4,5,6,6,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100208, 0x00100080, 0x00100000, 0x02100000, 0x00100000, 0x02100000, 0x00100208, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki543,49,8, "JH544",-2,-1,4,5,6,6,0x5,796,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200104, 0x00200040, 0x00200000, 0x01200000, 0x00200000, 0x01200000, 0x00200104, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki544,49,8, "JH545",-2,-1,4,5,6,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100208, 0x00100080, 0x00100000, 0x02100000, 0x00100000, 0x02100000, 0x00100208, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki545,56,8, "JH546",-2,-2,4,5,6,7,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220104, 0x00200060, 0x00200000, 0x01200000, 0x00200000, 0x01220000, 0x00200124, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki546,49,8, "JH547",-2,-1,4,5,6,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110288, 0x00100090, 0x00100000, 0x02100200, 0x00100000, 0x02110000, 0x02100218, 0x00100088}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki547,49,8, "JH548",-2,-1,4,5,6,6,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220944, 0x00208060, 0x80200000, 0x09200100, 0x80200000, 0x09220000, 0x01200924, 0x00208044}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki548,49,8, "JH549",-2,-1,4,5,6,6,0x5,833,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x0011068a, 0x00104090, 0x40100000, 0x06100200, 0x40100000, 0x06110000, 0x0210061a, 0x00104088}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki549,49,8, "JH550",-2,-1,4,5,6,6,0x5,834,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220945, 0x00208060, 0x80200000, 0x09200100, 0x80200000, 0x09220000, 0x01200925, 0x00208044}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki550,49,8, "JH551",-2,-1,4,5,6,6,0x5,832,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x0011068a, 0x00104090, 0x40100000, 0x06100200, 0x40100000, 0x06110000, 0x0210061a, 0x00104088}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki551,49,8, "JH552",-2,-1,4,5,6,6,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220945, 0x00208060, 0x80200000, 0x09200100, 0x80200000, 0x09220000, 0x01200925, 0x00208044}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki552,63,8, "JH553",-2,-3,4,5,6,8,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki553,63,8, "JH554",-2,-3,4,5,6,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00102200, 0x00900080, 0x20100000, 0x00180000, 0x00900000, 0x22100000, 0x00180008, 0x00102000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki554,63,8, "JH555",-2,-3,4,5,6,8,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209100, 0x80600040, 0x18200000, 0x00240800, 0x00608000, 0x91200000, 0x08240004, 0x00201800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki555,63,8, "JH556",-2,-3,4,5,6,8,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106220, 0x40900080, 0x24100000, 0x001a0400, 0x00904000, 0x62100000, 0x041a0008, 0x00102420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki556,63,8, "JH557",-2,-3,4,5,6,8,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209110, 0x80600040, 0x18200000, 0x00250800, 0x00608000, 0x91200000, 0x08250004, 0x00201810}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki557,63,8, "JH558",-2,-3,4,5,6,8,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00186220, 0x40902080, 0x24900000, 0x201a0400, 0x20904000, 0x62180000, 0x041a2008, 0x00902420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki558,63,8, "JH559",-2,-3,4,5,6,8,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00249110, 0x80601040, 0x18600000, 0x10250800, 0x10608000, 0x91240000, 0x08251004, 0x00601810}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki559,63,8, "JH560",-2,-3,4,5,6,8,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106220, 0x40900080, 0x24100000, 0x001a0400, 0x00904000, 0x62100000, 0x041a0008, 0x00102420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki560,80,8, "JH561",-2,-2,7,5,9,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki561,63,8, "JH562",-3,-5,3,3,6,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200004, 0x00200000, 0x00200000, 0x01200000, 0x00200000, 0x00200000, 0x00200100, 0x00200040}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki562,49,8, "JH563",-3,-1,3,5,6,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki563,49,8, "JH564",-3,-1,3,5,6,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00120800, 0x00108020, 0x80100000, 0x08100000, 0x80100000, 0x08120000, 0x00100820, 0x00108000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki564,49,8, "JH565",-2,-4,4,2,6,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200401, 0x00204000, 0x40200000, 0x04200000, 0x00200401}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki565,49,8, "JH566",-2,-4,4,2,6,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a000, 0x80900000, 0x28100000, 0x00180802, 0x00908000, 0xa0100000, 0x08180000, 0x00102802}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki566,49,8, "JH567",-2,-3,4,3,6,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281440, 0x00606000, 0x52a00000, 0x24240108, 0x60600080, 0x14280000, 0x01242400, 0x00a05204}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki567,49,8, "JH568",-2,-3,4,3,6,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00162880, 0x00909020, 0xa1500000, 0x18180204, 0x90900040, 0x28160000, 0x02181820, 0x0050a108}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki568,49,8, "JH569",-2,-3,4,3,6,6,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00299440, 0x80606010, 0x5aa00000, 0x24240908, 0x60608080, 0x94290000, 0x09242410, 0x00a05a04}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki569,49,8, "JH570",-2,-3,4,3,6,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00166880, 0x40909020, 0xa5500000, 0x18180604, 0x90904040, 0x68160000, 0x06181820, 0x0050a508}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki570,49,8, "JH571",-1,-5,5,1,6,6,0x5,686,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x00240909, 0x00608080, 0x90200000, 0x09240000, 0x00201a05}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki571,56,8, "JH572",-3,-1,4,5,7,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00120002, 0x00100020, 0x00100000, 0x00100000, 0x00100000, 0x00120000, 0x00100022, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki572,110,8, "JH573",-3,-1,6,9,9,10,0x5,947,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki573,120,8, "JH574",-3,-2,6,9,9,11,0x5,942,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki574,110,8, "JH575",-2,-8,7,2,9,10,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki575,64,8, "JH576",-3,-4,4,3,7,7,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100020, 0x00100000, 0x00100000, 0x00120000, 0x00100000, 0x00100000, 0x00120000, 0x00100020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki576,49,8, "JH577",-3,-1,3,5,6,6,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki577,49,8, "JH578",-3,-1,3,5,6,6,0x5,794,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110002, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100012, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki578,49,8, "JH579",-2,-4,4,2,6,6,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209000, 0x80600000, 0x18200000, 0x00240800, 0x00608000, 0x90200000, 0x08240000, 0x00201800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki579,49,8, "JH580",-2,-4,4,2,6,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106020, 0x40900000, 0x24100000, 0x001a0400, 0x00904000, 0x60100000, 0x041a0000, 0x00102420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki580,84,8, "JH581",-2,-4,9,2,11,6,0x5,691,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00289010, 0x80602000, 0x18a00000, 0x20250800, 0x20608000, 0x90280000, 0x08252000, 0x00a01810}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki581,77,8, "JH582",-2,-8,4,2,6,10,0x5,425,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00146020, 0x40901000, 0x24500000, 0x101a0400, 0x10904000, 0x60140000, 0x041a1000, 0x00502420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki582,49,8, "JH583",-2,-4,4,2,6,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki583,72,8, "JH584",-3,0,8,5,11,5,0x5,764,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki584,64,8, "JH585",-3,-2,4,5,7,7,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110002, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100012, 0x00100000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki585,88,8, "JH586",-3,-2,7,5,10,7,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki586,64,8, "JH587",-3,-2,4,5,7,7,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110002, 0x00100010, 0x00100000, 0x00100000, 0x00100000, 0x00110000, 0x00100012, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki587,88,8, "JH588",-3,-2,7,5,10,7,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220001, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200021, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki588,36,8, "JH589",-2,-3,3,2,5,5,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki589,36,8, "JH590",-2,-3,3,2,5,5,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a000, 0x80900000, 0x28100000, 0x00180800, 0x00908000, 0xa0100000, 0x08180000, 0x00102800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki590,36,8, "JH591",-2,-2,3,3,5,5,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281400, 0x00606000, 0x50a00000, 0x24240000, 0x60600000, 0x14280000, 0x00242400, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki591,36,8, "JH592",-2,-1,3,4,5,5,0x5,683,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00250a00, 0x00209090, 0x80600000, 0x18200000, 0x90200000, 0x0a250000, 0x00201818, 0x00608000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki592,42,8, "JH593",-1,-2,4,4,5,6,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a05, 0x00608080, 0x90200000, 0x09240000, 0x80600000, 0x1a200000, 0x00240909, 0x00209040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki593,42,8, "JH594",-1,-2,4,4,5,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a50a, 0x80904040, 0x68100000, 0x06180800, 0x40908000, 0xa5100000, 0x08180606, 0x00106880}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki594,48,8, "JH595",-1,-2,4,5,5,7,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00281601, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242409, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki595,36,8, "JH596",-1,0,4,5,5,5,0x5,834,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki596,42,8, "JH597",-1,0,5,5,6,5,0x5,835,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00281601, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242409, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki597,36,8, "JH598",-1,0,4,5,5,5,0x5,833,
    { 0x3f3f3f3f, 0x00fcfcfc, 0xf0f0f000, 0xffff0000, 0xfcfc0000, 0x3f3f3f00, 0x00ffffff, 0xf0f0f0f0},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki598,49,8, "JH599",-1,-1,5,5,6,6,0x5,799,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00285601, 0x40606080, 0x54a00000, 0x24240400, 0x60604000, 0x56280000, 0x04242409, 0x00a05400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki599,36,8, "JH600",-2,-1,3,4,5,5,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a0500, 0x00106060, 0x40900000, 0x24100000, 0x60100000, 0x051a0000, 0x00102424, 0x00904000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki600,36,8, "JH601",-2,-1,3,4,5,5,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00250a00, 0x00209090, 0x80600000, 0x18200000, 0x90200000, 0x0a250000, 0x00201818, 0x00608000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki601,42,8, "JH602",-2,-1,4,4,6,5,0x5,761,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a0500, 0x00106060, 0x40900000, 0x24100000, 0x60100000, 0x051a0000, 0x00102424, 0x00904000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki602,36,8, "JH603",-2,-1,3,4,5,5,0x5,683,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00250a00, 0x00209090, 0x80600000, 0x18200000, 0x90200000, 0x0a250000, 0x00201818, 0x00608000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki603,42,8, "JH604",-1,-2,4,4,5,6,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a05, 0x00608080, 0x90200000, 0x09240000, 0x80600000, 0x1a200000, 0x00240909, 0x00209040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki604,42,8, "JH605",-1,-2,4,4,5,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a50a, 0x80904040, 0x68100000, 0x06180800, 0x40908000, 0xa5100000, 0x08180606, 0x00106880}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki605,48,8, "JH606",-1,-2,4,5,5,7,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00281601, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242409, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki606,49,8, "JH607",-2,-2,4,4,6,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a0500, 0x00106060, 0x40900000, 0x24100000, 0x60100000, 0x051a0000, 0x00102424, 0x00904000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki607,36,8, "JH608",-2,-1,3,4,5,5,0x5,685,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x001a0500, 0x00106060, 0x40900000, 0x24100000, 0x60100000, 0x051a0000, 0x00102424, 0x00904000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki607,0,0.000000},
  {joseki608,49,8, "JH609",-3,-3,3,3,6,6,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100800, 0x00108000, 0x80100000, 0x08100000, 0x80100000, 0x08100000, 0x00100800, 0x00108000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki609,56,8, "JH610",-3,-3,4,3,7,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142800, 0x00909000, 0xa0500000, 0x18180000, 0x90900000, 0x28140000, 0x00181800, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki610,64,8, "JH611",-3,-3,4,4,7,7,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00251a00, 0x00609090, 0x90600000, 0x18240000, 0x90600000, 0x1a250000, 0x00241818, 0x00609000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki611,56,8, "JH612",-3,-2,4,4,7,6,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00251a00, 0x00609090, 0x90600000, 0x18240000, 0x90600000, 0x1a250000, 0x00241818, 0x00609000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki612,64,8, "JH613",-3,-4,4,3,7,7,0x5,611,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00146880, 0x40909000, 0xa4500000, 0x18180600, 0x90904000, 0x68140000, 0x06181800, 0x0050a408}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki613,56,8, "JH614",-3,-3,4,3,7,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00160800, 0x00109020, 0x80500000, 0x18100000, 0x90100000, 0x08160000, 0x00101820, 0x00508000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki614,42,8, "JH615",-3,-2,3,3,6,5,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00161808, 0x00509020, 0x90500000, 0x1a140000, 0x90500000, 0x18160000, 0x00141a20, 0x00509080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki615,48,8, "JH616",-2,-4,5,1,7,5,0x5,650,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x00206080, 0x40a00000, 0x25200000, 0x00280605, 0x00a04040, 0x60200000, 0x06280000, 0x00202509}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki616,63,8, "JH617",-2,-5,6,1,8,6,0x5,613,
    { 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff},
    { 0x002060a0, 0x40a00000, 0x25200000, 0x002a0605, 0x00a04040, 0x60200000, 0x062a0000, 0x00202529}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki617,42,8, "JH618",-2,-4,3,2,5,6,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00204000, 0x40200000, 0x04200000, 0x00200400, 0x00204000, 0x40200000, 0x04200000, 0x00200400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki618,42,8, "JH619",-2,-4,3,2,5,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a000, 0x80900000, 0x28100000, 0x00180800, 0x00908000, 0xa0100000, 0x08180000, 0x00102800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki619,42,8, "JH620",-2,-3,3,3,5,6,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281400, 0x00606000, 0x50a00000, 0x24240000, 0x60600000, 0x14280000, 0x00242400, 0x00a05000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki620,42,8, "JH621",-2,-2,3,4,5,6,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00250a00, 0x00209090, 0x82600000, 0x18200008, 0x90200080, 0x0a250000, 0x00201818, 0x00608200}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki621,42,8, "JH622",-1,-2,4,4,5,6,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a05, 0x00608080, 0x90200000, 0x09240001, 0x80600000, 0x1a200000, 0x00240909, 0x00209041}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki622,42,8, "JH623",-1,-2,4,4,5,6,0x5,797,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a50a, 0x80904040, 0x68100000, 0x06180802, 0x40908000, 0xa5100000, 0x08180606, 0x00106882}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki623,49,8, "JH624",-1,-2,5,4,6,6,0x5,798,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00205a05, 0x40608080, 0x94200000, 0x09240401, 0x80604000, 0x5a200000, 0x04240909, 0x00209441}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki624,42,8, "JH625",-1,-2,4,4,5,6,0x5,796,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0010a50a, 0x80904040, 0x68100000, 0x06180802, 0x40908000, 0xa5100000, 0x08180606, 0x00106882}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki625,36,8, "JH626",-2,0,3,5,5,5,0x5,796,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki626,36,8, "JH627",-2,0,3,5,5,5,0x5,721,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00120100, 0x00100060, 0x00100000, 0x00100000, 0x00100000, 0x01120000, 0x00100024, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki627,42,8, "JH628",-2,0,4,5,6,5,0x5,834,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00160100, 0x00101060, 0x00500000, 0x10100000, 0x10100000, 0x01160000, 0x00101024, 0x00500000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki628,42,8, "JH629",-2,0,4,5,6,5,0x5,798,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00160100, 0x00101060, 0x00500000, 0x10100000, 0x10100000, 0x01160000, 0x00101024, 0x00500000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki629,56,8, "JH630",-2,-1,5,5,7,6,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki630,56,8, "JH631",-2,-2,4,5,6,7,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100100, 0x00100040, 0x00100000, 0x00100000, 0x00100000, 0x01100000, 0x00100004, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki631,42,8, "JH632",-2,0,3,6,5,6,0x5,833,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki632,42,8, "JH633",-2,0,3,6,5,6,0x5,795,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki633,42,8, "JH634",-2,0,3,6,5,6,0x5,758,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki634,42,8, "JH635",-2,0,3,6,5,6,0x5,757,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00220000, 0x00200020, 0x00200000, 0x00200000, 0x00200000, 0x00220000, 0x00200020, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki635,42,8, "JH636",-1,-2,4,4,5,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a05, 0x00608080, 0x91200000, 0x09240004, 0x80600040, 0x1a200000, 0x00240909, 0x00209140}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki636,42,8, "JH637",-1,-1,4,5,5,6,0x5,723,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00248902, 0x80209040, 0x88600000, 0x18200800, 0x90208000, 0x89240000, 0x08201806, 0x00608800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki637,42,8, "JH638",-1,-1,4,5,5,6,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00184609, 0x40106080, 0x44900000, 0x26100400, 0x60104000, 0x46180000, 0x04102609, 0x00904480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki638,42,8, "JH639",-1,-1,4,5,5,6,0x5,834,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x0024a906, 0x80a09040, 0xa8600000, 0x19280800, 0x90a08000, 0xa9240000, 0x08281906, 0x0060a840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki639,42,8, "JH640",-1,-1,4,5,5,6,0x5,835,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00185609, 0x40506080, 0x54900000, 0x26140400, 0x60504000, 0x56180000, 0x04142609, 0x00905480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki640,42,8, "JH641",-1,-1,4,5,5,6,0x5,833,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x0024a906, 0x80a09040, 0xa8600000, 0x19280800, 0x90a08000, 0xa9240000, 0x08281906, 0x0060a840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki641,49,8, "JH642",-1,-1,5,5,6,6,0x5,799,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00185609, 0x40506080, 0x54900000, 0x26140400, 0x60504000, 0x56180000, 0x04142609, 0x00905480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki642,42,8, "JH643",-1,-1,4,5,5,6,0x5,757,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x0024a906, 0x80a09040, 0xa8600000, 0x19280800, 0x90a08000, 0xa9240000, 0x08281906, 0x0060a840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki643,42,8, "JH644",0,-3,5,3,5,6,0x5,651,
    { 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0xf0f0f0f0, 0xffff0000, 0x3f3f3f3f, 0x00ffffff},
    { 0x0020806a, 0x80200000, 0x09200000, 0x02220905, 0x00208040, 0x80200000, 0x09220202, 0x002009a5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki644,42,8, "JH645",-1,-1,4,5,5,6,0x5,758,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x0024a906, 0x80a09040, 0xa8600000, 0x19280800, 0x90a08000, 0xa9240000, 0x08281906, 0x0060a840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki645,42,8, "JH646",-1,-1,4,5,5,6,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x001a5609, 0x405060a0, 0x54900000, 0x26140400, 0x60504000, 0x561a0000, 0x04142629, 0x00905480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki646,64,8, "JH647",-3,-4,4,3,7,7,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00102000, 0x00900000, 0x20100000, 0x00180000, 0x00900000, 0x20100000, 0x00180000, 0x00102000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki647,56,8, "JH648",-3,-2,4,4,7,6,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00160800, 0x00109020, 0x80500000, 0x18100000, 0x90100000, 0x08160000, 0x00101820, 0x00508000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki648,49,8, "JK1",-3,-2,3,4,6,6,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki649,56,8, "JK2",-2,-3,4,4,6,7,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00201200, 0x00600080, 0x10200000, 0x00240000, 0x00600000, 0x12200000, 0x00240008, 0x00201000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki650,42,8, "JK3",-2,-1,3,5,5,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00240800, 0x00209000, 0x80600000, 0x18200000, 0x90200000, 0x08240000, 0x00201800, 0x00608000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki651,56,8, "JK4",-2,-2,4,5,6,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a0400, 0x00106020, 0x40900000, 0x24100000, 0x60100000, 0x041a0000, 0x00102420, 0x00904000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki652,56,8, "JK5",-2,-1,5,5,7,6,0x5,798,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00252800, 0x00a09010, 0xa0600000, 0x18280000, 0x90a00000, 0x28250000, 0x00281810, 0x0060a000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki653,66,8, "JK6",-2,-5,3,5,5,10,0x5,536,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1400, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142420, 0x00905000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki654,91,8, "JK7",-2,-3,4,9,6,12,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki655,91,8, "JK8",-2,-1,4,11,6,12,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki656,84,8, "JK9",-2,0,4,11,6,11,0x5,832,
    { 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0, 0xffff0000, 0xffff0000, 0x3f3f3f3f, 0x00ffffff, 0xf0f0f0f0},
    { 0x00120000, 0x00100020, 0x00100000, 0x00100000, 0x00100000, 0x00120000, 0x00100020, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki657,91,8, "JK10",-2,-1,4,11,6,12,0x5,831,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki658,72,8, "JK11",-2,-2,6,5,8,7,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1400, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142420, 0x00905000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki659,72,8, "JK12",-2,-2,6,5,8,7,0x5,834,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252800, 0x00a09010, 0xa0600000, 0x18280000, 0x90a00000, 0x28250000, 0x00281810, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki660,72,8, "JK13",-2,-2,6,5,8,7,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1400, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142420, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki661,72,8, "JK14",-2,-2,6,5,8,7,0x5,832,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252a00, 0x00a09090, 0xa0600000, 0x18280000, 0x90a00000, 0x2a250000, 0x00281818, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki662,72,8, "JK15",-2,-2,6,5,8,7,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1500, 0x00506060, 0x50900000, 0x24140000, 0x60500000, 0x151a0000, 0x00142424, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki663,72,8, "JK16",-2,-2,6,5,8,7,0x5,835,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252a00, 0x00a09090, 0xa0600000, 0x18280000, 0x90a00000, 0x2a250000, 0x00281818, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki664,72,8, "JK17",-2,-2,6,5,8,7,0x5,799,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1500, 0x00506060, 0x50900000, 0x24140000, 0x60500000, 0x151a0000, 0x00142424, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki665,66,8, "JK18",-2,-5,3,5,5,10,0x5,574,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252800, 0x00a09010, 0xa0600000, 0x18280000, 0x90a00000, 0x28250000, 0x00281810, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki666,77,8, "JK19",-2,-5,4,5,6,10,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1400, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142420, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki667,77,8, "JK20",-2,-5,4,5,6,10,0x5,834,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252800, 0x00a09010, 0xa0600000, 0x18280000, 0x90a00000, 0x28250000, 0x00281810, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki668,77,8, "JK21",-2,-5,4,5,6,10,0x5,759,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1400, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142420, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki669,77,8, "JK22",-2,-5,4,5,6,10,0x5,832,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252a00, 0x00a09090, 0xa0600000, 0x18280000, 0x90a00000, 0x2a250000, 0x00281818, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki670,99,8, "JK23",-2,-5,6,5,8,10,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1500, 0x00506060, 0x50900000, 0x24140000, 0x60500000, 0x151a0000, 0x00142424, 0x00905000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki671,99,8, "JK24",-2,-5,6,5,8,10,0x5,835,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252a00, 0x00a09090, 0xa0600000, 0x18280000, 0x90a00000, 0x2a250000, 0x00281818, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki672,110,8, "JK25",-2,-5,7,5,9,10,0x5,800,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1500, 0x00506060, 0x50900000, 0x24140000, 0x60500000, 0x151a0000, 0x00142424, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki673,99,8, "JK26",-2,-5,6,5,8,10,0x5,799,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1500, 0x00506060, 0x50900000, 0x24140000, 0x60500000, 0x151a0000, 0x00142424, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki674,56,8, "JK27",-2,-2,4,5,6,7,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00252800, 0x00a09010, 0xa0600000, 0x18280000, 0x90a00000, 0x28250000, 0x00281810, 0x0060a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki675,66,8, "JK28",-2,-5,3,5,5,10,0x5,536,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a1402, 0x00506020, 0x50900000, 0x24140000, 0x60500000, 0x141a0000, 0x00142422, 0x00905000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki676,121,8, "JK29",-2,-1,8,9,10,10,0x5,950,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki677,121,8, "JK30",-2,-1,8,9,10,10,0x5,835,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki678,70,8, "JK31",-2,-4,4,5,6,9,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a0400, 0x00106020, 0x40900000, 0x24100000, 0x60100000, 0x041a0000, 0x00102420, 0x00904000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki679,56,8, "JK32",-2,-1,5,5,7,6,0x5,798,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00258800, 0x80209010, 0x88600000, 0x18200800, 0x90208000, 0x88250000, 0x08201810, 0x00608800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki680,72,8, "JK33",-2,-6,3,5,5,11,0x5,499,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a4400, 0x40106020, 0x44900000, 0x24100400, 0x60104000, 0x441a0000, 0x04102420, 0x00904400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki681,56,8, "JK34",-2,-2,4,5,6,7,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00258800, 0x80209010, 0x88600000, 0x18200800, 0x90208000, 0x88250000, 0x08201810, 0x00608800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki682,56,8, "JK35",-2,-2,4,5,6,7,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a4420, 0x40106020, 0x44900000, 0x24120400, 0x60104000, 0x441a0000, 0x04122420, 0x00904420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki683,56,8, "JK36",-2,-2,4,5,6,7,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00258818, 0x80209010, 0x88600000, 0x1a210800, 0x90208000, 0x88250000, 0x08211a10, 0x00608890}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki684,56,8, "JK37",-1,-2,5,5,6,7,0x5,688,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a44, 0x00608080, 0x90200000, 0x09240100, 0x80600000, 0x1a200000, 0x01240908, 0x00209044}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki685,56,8, "JK38",-1,-2,5,5,6,7,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00102588, 0x00904040, 0x60100000, 0x06180200, 0x40900000, 0x25100000, 0x02180604, 0x00106088}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki686,56,8, "JK39",-1,-1,5,6,6,7,0x5,835,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00280611, 0x00206080, 0x40a00000, 0x24210000, 0x60200000, 0x06280000, 0x00212409, 0x00a04010}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki687,56,8, "JK40",-1,-1,5,6,6,7,0x5,872,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00140922, 0x00109040, 0x80500000, 0x18120000, 0x90100000, 0x09140000, 0x00121806, 0x00508020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki688,56,8, "JK41",-1,-1,5,6,6,7,0x5,837,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00280611, 0x00206080, 0x40a00000, 0x24210000, 0x60200000, 0x06280000, 0x00212409, 0x00a04010}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki689,56,8, "JK42",-1,-2,5,5,6,7,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00201a44, 0x00608080, 0x90200000, 0x09240100, 0x80600000, 0x1a200000, 0x01240908, 0x00209044}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki689,3,0.000000},
  {joseki690,56,8, "JK43",-1,-1,5,6,6,7,0x5,723,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00240922, 0x00209040, 0x80600000, 0x18220000, 0x90200000, 0x09240000, 0x00221806, 0x00608020}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki691,56,8, "JK44",-1,-1,5,6,6,7,0x5,685,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00180619, 0x00106080, 0x40900000, 0x26110000, 0x60100000, 0x06180000, 0x00112609, 0x00904090}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki692,56,8, "JK45",-1,-1,5,6,6,7,0x5,762,
    { 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc},
    { 0x00242926, 0x00a09040, 0xa0600000, 0x192a0000, 0x90a00000, 0x29240000, 0x002a1906, 0x0060a060}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki693,56,8, "JK46",-2,-2,4,5,6,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a4420, 0x40106020, 0x44900000, 0x24120400, 0x60104000, 0x441a0000, 0x04122420, 0x00904420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki694,56,8, "JK47",-2,-2,4,5,6,7,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0025a810, 0x80a09010, 0xa8600000, 0x18290800, 0x90a08000, 0xa8250000, 0x08291810, 0x0060a810}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki695,84,8, "JK48",-2,-6,4,5,6,11,0x5,499,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a5422, 0x40506020, 0x54900000, 0x24160400, 0x60504000, 0x541a0000, 0x04162422, 0x00905420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki696,132,8, "JK49",-2,-1,8,10,10,11,0x5,987,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x10880010,0.000000,0.000000,0.000000,0.000000,8.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki697,63,8, "JK50",-2,-3,4,5,6,8,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00258800, 0x80209010, 0x88600000, 0x18200800, 0x90208000, 0x88250000, 0x08201810, 0x00608800}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki697,3,0.000000},
  {joseki698,84,8, "JK51",-2,-6,4,5,6,11,0x5,499,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001a4402, 0x40106020, 0x44900000, 0x24100400, 0x60104000, 0x441a0000, 0x04102422, 0x00904400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki699,84,8, "JK52",-2,-1,4,10,6,11,0x5,871,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki700,84,8, "JK53",-2,-1,4,10,6,11,0x5,834,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,8.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki701,56,8, "JK54",-2,-2,5,4,7,6,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00201200, 0x00600080, 0x10200000, 0x00240000, 0x00600000, 0x12200000, 0x00240008, 0x00201000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki702,36,8, "JK55",-2,-1,3,4,5,5,0x5,721,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00102900, 0x00908040, 0xa0100000, 0x08180000, 0x80900000, 0x29100000, 0x00180804, 0x0010a000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki703,42,8, "JK56",-2,-1,4,4,6,5,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00281600, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242408, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki704,42,8, "JK57",-2,-1,4,4,6,5,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki705,49,8, "JK58",-2,-2,4,4,6,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a1601, 0x006060a0, 0x50a00000, 0x24240000, 0x60600000, 0x162a0000, 0x00242429, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki706,56,8, "JK59",-2,-3,4,4,6,7,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a902, 0x80909050, 0xa8500000, 0x18180800, 0x90908000, 0xa9150000, 0x08181816, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki707,56,8, "JK60",-2,-1,4,6,6,7,0x5,798,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220500, 0x00204060, 0x40200000, 0x04200000, 0x40200000, 0x05220000, 0x00200424, 0x00204000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki708,64,8, "JK61",-2,-3,5,4,7,7,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a902, 0x80909050, 0xa8500000, 0x18180800, 0x90908000, 0xa9150000, 0x08181816, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki709,64,8, "JK62",-2,-3,5,4,7,7,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a5601, 0x406060a0, 0x54a00000, 0x24240400, 0x60604000, 0x562a0000, 0x04242429, 0x00a05400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki710,64,8, "JK63",-2,-3,5,4,7,7,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a902, 0x80909050, 0xa8500000, 0x18180800, 0x90908000, 0xa9150000, 0x08181816, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki711,72,8, "JK64",-2,-3,6,4,8,7,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a5601, 0x406060a0, 0x54a00000, 0x24240400, 0x60604000, 0x562a0000, 0x04242429, 0x00a05400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki712,81,8, "JK65",-2,-4,6,4,8,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015a902, 0x80909050, 0xa8500000, 0x18180800, 0x90908000, 0xa9150000, 0x08181816, 0x0050a800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki713,90,8, "JK66",-2,-3,6,6,8,9,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220500, 0x00204060, 0x40200000, 0x04200000, 0x40200000, 0x05220000, 0x00200424, 0x00204000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki714,90,8, "JK67",-2,-3,6,6,8,9,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110a80, 0x00108090, 0x80100000, 0x08100200, 0x80100000, 0x0a110000, 0x02100818, 0x00108008}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki715,81,8, "JK68",-2,-4,6,4,8,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,1,NULL,autohelperjoseki715,0,1.000000},
  {joseki716,81,8, "JK69",-2,-4,6,4,8,8,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00289601, 0x80606080, 0x58a00000, 0x24240800, 0x60608000, 0x96280000, 0x08242409, 0x00a05800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki717,81,8, "JK70",-2,-4,6,4,8,8,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00166902, 0x40909060, 0xa4500000, 0x18180400, 0x90904000, 0x69160000, 0x04181826, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki718,81,8, "JK71",-2,-4,6,4,8,8,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00299601, 0x80606090, 0x58a00000, 0x24240800, 0x60608000, 0x96290000, 0x08242419, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki719,81,8, "JK72",-1,-6,7,2,8,8,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki720,81,8, "JK73",-1,-6,7,2,8,8,0x5,651,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109068, 0x80500000, 0x1a100000, 0x02160909, 0x00508080, 0x90100000, 0x09160200, 0x00101aa5}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki721,81,8, "JK74",-1,-6,7,2,8,8,0x5,688,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki722,81,8, "JK75",-1,-6,7,2,8,8,0x5,574,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109068, 0x80500000, 0x1a100000, 0x02160909, 0x00508080, 0x90100000, 0x09160200, 0x00101aa5}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki723,81,8, "JK76",-1,-6,7,2,8,8,0x5,650,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki724,81,8, "JK77",-1,-6,7,2,8,8,0x5,613,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109068, 0x80500000, 0x1a100000, 0x02160909, 0x00508080, 0x90100000, 0x09160200, 0x00101aa5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki725,81,8, "JK78",-1,-6,7,2,8,8,0x5,614,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki726,81,8, "JK79",-1,-6,7,2,8,8,0x5,576,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109068, 0x80500000, 0x1a100000, 0x02160909, 0x00508080, 0x90100000, 0x09160200, 0x00101aa5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki727,81,8, "JK80",-1,-6,7,2,8,8,0x5,652,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki728,81,8, "JK81",-1,-6,7,2,8,8,0x5,538,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109068, 0x80500000, 0x1a100000, 0x02160909, 0x00508080, 0x90100000, 0x09160200, 0x00101aa5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki729,49,8, "JK82",-1,-4,5,2,6,6,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki729,3,0.000000},
  {joseki730,63,8, "JK83",-2,-4,4,4,6,8,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki730,0,0.000000},
  {joseki731,63,8, "JK84",-2,-3,4,5,6,8,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a0500, 0x00206060, 0x40a00000, 0x24200000, 0x60200000, 0x052a0000, 0x00202424, 0x00a04000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki732,63,8, "JK85",-2,-3,4,5,6,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00152a00, 0x00909090, 0xa0500000, 0x18180000, 0x90900000, 0x2a150000, 0x00181818, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki733,63,8, "JK86",-2,-3,4,5,6,8,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9500, 0x80606060, 0x58a00000, 0x24240800, 0x60608000, 0x952a0000, 0x08242424, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki734,63,8, "JK87",-2,-3,4,5,6,8,0x5,833,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156a00, 0x40909090, 0xa4500000, 0x18180400, 0x90904000, 0x6a150000, 0x04181818, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki735,63,8, "JK88",-2,-3,4,5,6,8,0x5,794,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9500, 0x80606060, 0x58a00000, 0x24240800, 0x60608000, 0x952a0000, 0x08242424, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki736,63,8, "JK89",-1,-6,5,2,6,8,0x5,722,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206094, 0x40a00000, 0x25200000, 0x01290606, 0x00a04040, 0x60200000, 0x06290100, 0x0020255a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki737,70,8, "JK90",-1,-7,5,2,6,9,0x5,537,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109868, 0x80508000, 0x9a100000, 0x0a160909, 0x80508080, 0x98100000, 0x09160a00, 0x00109aa5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki738,90,8, "JK91",-1,-7,7,2,8,9,0x5,500,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00206494, 0x40a04000, 0x65200000, 0x05290606, 0x40a04040, 0x64200000, 0x06290500, 0x0020655a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki739,90,8, "JK92",-1,-7,7,2,8,9,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00109868, 0x80508000, 0x9a100000, 0x0a160909, 0x80508080, 0x98100000, 0x09160a00, 0x00109aa5}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki740,90,8, "JK93",-1,-7,7,2,8,9,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00286494, 0x40a06000, 0x65a00000, 0x25290606, 0x60a04040, 0x64280000, 0x06292500, 0x00a0655a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki741,90,8, "JK94",-1,-7,7,2,8,9,0x5,536,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00149868, 0x80509000, 0x9a500000, 0x1a160909, 0x90508080, 0x98140000, 0x09161a00, 0x00509aa5}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki742,99,8, "JK95",-1,-4,7,6,8,10,0x5,721,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x0020651a, 0x40a04040, 0x64200000, 0x06290400, 0x40a04000, 0x65200000, 0x04290606, 0x00206490}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki743,99,8, "JK96",-1,-4,7,6,8,10,0x5,647,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00189a25, 0x8050a080, 0x98900000, 0x29160800, 0xa0508000, 0x9a180000, 0x08162909, 0x00909860}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki744,88,8, "JK97",-1,-3,6,7,7,10,0x5,832,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00291906, 0x0060a050, 0x90a00000, 0x29240000, 0xa0600000, 0x19290000, 0x00242916, 0x00a09040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki745,99,8, "JK98",-1,-3,7,7,8,10,0x5,648,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00162609, 0x009050a0, 0x60500000, 0x16180000, 0x50900000, 0x26160000, 0x00181629, 0x00506080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki746,99,8, "JK99",-1,-3,7,7,8,10,0x5,724,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00299906, 0x8060a050, 0x98a00000, 0x29240800, 0xa0608000, 0x99290000, 0x08242916, 0x00a09840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki747,99,8, "JK100",-1,-3,7,7,8,10,0x5,799,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00166609, 0x409050a0, 0x64500000, 0x16180400, 0x50904000, 0x66160000, 0x04181629, 0x00506480}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki748,99,8, "JK101",-1,-3,7,7,8,10,0x5,873,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00299906, 0x8060a050, 0x98a00000, 0x29240800, 0xa0608000, 0x99290000, 0x08242916, 0x00a09840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki749,99,8, "JK102",-1,-3,7,7,8,10,0x5,762,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00166609, 0x409050a0, 0x64500000, 0x16180400, 0x50904000, 0x66160000, 0x04181629, 0x00506480}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki750,99,8, "JK103",-1,-3,7,7,8,10,0x5,650,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00299906, 0x8060a050, 0x98a00000, 0x29240800, 0xa0608000, 0x99290000, 0x08242916, 0x00a09840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki751,126,8, "JK104",-1,-6,7,7,8,13,0x5,537,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00166609, 0x409050a0, 0x64500000, 0x16180400, 0x50904000, 0x66160000, 0x04181629, 0x00506480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki752,126,8, "JK105",-1,-6,7,7,8,13,0x5,689,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00299906, 0x8060a050, 0x98a00000, 0x29240800, 0xa0608000, 0x99290000, 0x08242916, 0x00a09840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki753,154,8, "JK106",-1,-6,9,7,10,13,0x5,802,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00166609, 0x409050a0, 0x64500000, 0x16180400, 0x50904000, 0x66160000, 0x04181629, 0x00506480}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki754,154,8, "JK107",-1,-6,9,7,10,13,0x5,876,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00299906, 0x8060a050, 0x98a00000, 0x29240800, 0xa0608000, 0x99290000, 0x08242916, 0x00a09840}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki755,63,8, "JK108",-2,-3,4,5,6,8,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9500, 0x80606060, 0x58a00000, 0x24240800, 0x60608000, 0x952a0000, 0x08242424, 0x00a05800}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki755,3,0.000000},
  {joseki756,49,8, "JK109",-2,-2,4,4,6,6,0x5,797,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki757,49,8, "JK110",-2,-2,4,4,6,6,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281601, 0x00606080, 0x50a00000, 0x24240000, 0x60600000, 0x16280000, 0x00242409, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki758,49,8, "JK111",-2,-2,4,4,6,6,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki759,49,8, "JK112",-2,-2,4,4,6,6,0x5,798,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a1601, 0x006060a0, 0x50a00000, 0x24240000, 0x60600000, 0x162a0000, 0x00242429, 0x00a05000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki760,56,8, "JK113",-2,-3,4,4,6,7,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00152902, 0x00909050, 0xa0500000, 0x18180000, 0x90900000, 0x29150000, 0x00181816, 0x0050a000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki761,56,8, "JK114",-2,-3,4,4,6,7,0x5,724,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki762,64,8, "JK115",-2,-3,5,4,7,7,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x880010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki763,63,8, "JK116",-2,-2,6,4,8,6,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki764,63,8, "JK117",-2,-2,6,4,8,6,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki764,0,0.000000},
  {joseki765,63,8, "JK118",-2,-2,6,4,8,6,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9681, 0x806060a0, 0x58a00000, 0x24240a00, 0x60608000, 0x962a0000, 0x0a242429, 0x00a05808}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,8.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki766,63,8, "JK119",-2,-2,6,4,8,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156942, 0x40909050, 0xa4500000, 0x18180500, 0x90904000, 0x69150000, 0x05181816, 0x0050a404}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki766,0,0.000000},
  {joseki767,63,8, "JK120",-2,-2,6,4,8,6,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9689, 0x806060a0, 0x58a00000, 0x26240a00, 0x60608000, 0x962a0000, 0x0a242629, 0x00a05888}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki768,80,8, "JK121",-2,-3,7,4,9,7,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki769,80,8, "JK122",-2,-3,7,4,9,7,0x5,689,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki770,80,8, "JK123",-2,-3,7,4,9,7,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki771,80,8, "JK124",-2,-3,7,4,9,7,0x5,652,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9681, 0x806060a0, 0x58a00000, 0x24240a00, 0x60608000, 0x962a0000, 0x0a242429, 0x00a05808}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki772,56,8, "JK125",-2,-2,5,4,7,6,0x5,725,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki772,3,0.000000},
  {joseki773,56,8, "JK126",-2,-3,4,4,6,7,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x10880010,0.000000,0.000000,0.000000,0.000000,6.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki774,56,8, "JK127",-2,-3,4,4,6,7,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,8.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki775,64,8, "JK128",-2,-3,5,4,7,7,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki776,64,8, "JK129",-2,-3,5,4,7,7,0x5,688,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki777,64,8, "JK130",-2,-3,5,4,7,7,0x5,651,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki778,72,8, "JK131",-2,-3,6,4,8,7,0x5,689,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9601, 0x806060a0, 0x58a00000, 0x24240800, 0x60608000, 0x962a0000, 0x08242429, 0x00a05800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki779,72,8, "JK132",-2,-3,6,4,8,7,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00156902, 0x40909050, 0xa4500000, 0x18180400, 0x90904000, 0x69150000, 0x04181816, 0x0050a400}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki780,72,8, "JK133",-2,-3,6,4,8,7,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x002a9681, 0x806060a0, 0x58a00000, 0x24240a00, 0x60608000, 0x962a0000, 0x0a242429, 0x00a05808}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki781,81,8, "JK134",-2,-4,6,4,8,8,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0015694a, 0x40909050, 0xa4500000, 0x1a180500, 0x90904000, 0x69150000, 0x05181a16, 0x0050a484}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki782,49,8, "JK135",-2,-2,4,4,6,6,0x5,796,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00142902, 0x00909040, 0xa0500000, 0x18180000, 0x90900000, 0x29140000, 0x00181806, 0x0050a000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki782,0,0.000000},
  {joseki783,64,8, "JK136",-3,-3,4,4,7,7,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki784,64,8, "JK137",-3,-3,4,4,7,7,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120008, 0x00100020, 0x00100000, 0x02100000, 0x00100000, 0x00120000, 0x00100220, 0x00100080}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,3.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki785,64,8, "JK138",-2,-5,5,2,7,7,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00201000, 0x00600000, 0x12200000, 0x00240008, 0x00600080, 0x10200000, 0x00240000, 0x00201200}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki786,64,8, "JK139",-2,-5,5,2,7,7,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00182000, 0x00902000, 0x21900000, 0x20180004, 0x20900040, 0x20180000, 0x00182000, 0x00902100}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki787,64,8, "JK140",-2,-4,5,3,7,7,0x5,760,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00298400, 0x80206010, 0x48a00000, 0x24200800, 0x60208000, 0x84290000, 0x08202410, 0x00a04800}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,8.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki788,70,8, "JK141",-2,-6,4,3,6,9,0x5,499,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00164802, 0x40109020, 0x84500000, 0x18100400, 0x90104000, 0x48160000, 0x04101822, 0x00508400}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki789,72,8, "JK142",-2,-5,5,3,7,8,0x5,536,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00164802, 0x40109020, 0x84500000, 0x18100400, 0x90104000, 0x48160000, 0x04101822, 0x00508400}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki790,63,8, "JK143",-2,-5,4,3,6,8,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00298400, 0x80206010, 0x48a00000, 0x24200800, 0x60208000, 0x84290000, 0x08202410, 0x00a04800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki791,70,8, "JK144",-1,-8,5,1,6,9,0x5,426,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00206080, 0x40a00000, 0x25200000, 0x00280604, 0x00a04040, 0x60200000, 0x06280000, 0x00202508}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki792,110,8, "JK145",-1,-8,9,1,10,9,0x5,655,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00109040, 0x80500000, 0x1a100000, 0x00140908, 0x00508080, 0x90100000, 0x09140000, 0x00101a04}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki793,72,8, "JK146",-1,-7,6,1,7,8,0x5,463,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00206080, 0x40a00000, 0x25200000, 0x00280604, 0x00a04040, 0x60200000, 0x06280000, 0x00202508}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki794,110,8, "JK147",-1,-8,9,1,10,9,0x5,655,
    { 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xfcfcfc00, 0xffffff00, 0xffffffff},
    { 0x00109040, 0x80500000, 0x1a100000, 0x00140908, 0x00508080, 0x90100000, 0x09140000, 0x00101a04}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,10.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki795,64,8, "JK148",-3,-3,4,4,7,7,0x5,572,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120008, 0x00100020, 0x00100000, 0x02100000, 0x00100000, 0x00120000, 0x00100220, 0x00100080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki795,0,0.000000},
  {joseki796,64,8, "JK149",-3,-3,4,4,7,7,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00120008, 0x00100020, 0x00100000, 0x02100000, 0x00100000, 0x00120000, 0x00100220, 0x00100080}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki796,0,0.000000},
  {joseki797,56,8, "JK150",-3,-3,3,4,6,7,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki798,56,8, "JK151",-3,-3,3,4,6,7,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00122000, 0x00900020, 0x20100000, 0x00180000, 0x00900000, 0x20120000, 0x00180020, 0x00102000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki799,56,8, "JK152",-3,-3,3,4,6,7,0x5,722,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00219000, 0x80600010, 0x18200000, 0x00240800, 0x00608000, 0x90210000, 0x08240010, 0x00201800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki800,63,8, "JK153",-3,-4,3,4,6,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00126800, 0x40908020, 0xa4100000, 0x08180400, 0x80904000, 0x68120000, 0x04180820, 0x0010a400}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki801,63,8, "JK154",-3,-2,3,6,6,8,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220900, 0x00208060, 0x80200000, 0x08200000, 0x80200000, 0x09220000, 0x00200824, 0x00208000}
   , 0x840010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki802,63,8, "JK155",-2,-4,4,4,6,8,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00201268, 0x00600080, 0x11200000, 0x02260104, 0x00600040, 0x12200000, 0x01260208, 0x002011a4}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki803,63,8, "JK156",-3,-4,3,4,6,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00126020, 0x40900020, 0x24100000, 0x001a0400, 0x00904000, 0x60120000, 0x041a0020, 0x00102420}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki804,56,8, "JK157",-3,-1,3,6,6,7,0x5,795,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220901, 0x00208060, 0x80200000, 0x08200000, 0x80200000, 0x09220000, 0x00200825, 0x00208000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki805,63,8, "JK158",-3,-2,3,6,6,8,0x5,757,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00110602, 0x00104090, 0x40100000, 0x04100000, 0x40100000, 0x06110000, 0x0010041a, 0x00104000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki806,49,8, "JK159",-3,-1,3,5,6,6,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00241800, 0x00609000, 0x90600000, 0x18240000, 0x90600000, 0x18240000, 0x00241800, 0x00609000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki807,64,8, "JK160",-3,-2,4,5,7,7,0x5,758,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00241908, 0x00609040, 0x90600000, 0x1a240000, 0x90600000, 0x19240000, 0x00241a04, 0x00609080}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki808,72,8, "JK161",-3,-3,4,5,7,8,0x5,683,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00259908, 0x80609050, 0x98600000, 0x1a240800, 0x90608000, 0x99250000, 0x08241a14, 0x00609880}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki809,72,8, "JK162",-2,-3,5,5,7,8,0x5,647,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00102589, 0x00904040, 0x60100000, 0x06180200, 0x40900000, 0x25100000, 0x02180605, 0x00106088}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki810,72,8, "JK163",-2,-2,6,5,8,7,0x5,761,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010a599, 0x80904040, 0x68100000, 0x06190a00, 0x40908000, 0xa5100000, 0x0a190605, 0x00106898}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki811,81,8, "JK164",-3,-4,5,4,8,8,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki812,81,8, "JK165",-3,-1,5,7,8,8,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki813,81,8, "JK166",-3,-1,5,7,8,8,0x5,871,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki814,81,8, "JK167",-3,-1,5,7,8,8,0x5,799,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki815,81,8, "JK168",-3,-1,5,7,8,8,0x5,873,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki816,99,8, "JK169",-3,-3,5,7,8,10,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki817,81,8, "JK170",-3,-1,5,7,8,8,0x5,872,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki818,90,8, "JK171",-3,-1,6,7,9,8,0x5,799,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki819,99,8, "JK172",-3,-1,7,7,10,8,0x5,837,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki820,143,8, "JK173",-3,-5,7,7,10,12,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki821,81,8, "JK174",-3,-1,5,7,8,8,0x5,835,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki822,81,8, "JK175",-3,-1,5,7,8,8,0x5,796,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki823,81,8, "JK176",-3,-1,5,7,8,8,0x5,759,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki824,81,8, "JK177",-3,-1,5,7,8,8,0x5,797,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki825,81,8, "JK178",-3,-1,5,7,8,8,0x5,832,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki826,81,8, "JK179",-3,-1,5,7,8,8,0x5,833,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki827,81,8, "JK180",-3,-1,5,7,8,8,0x5,868,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki828,81,8, "JK181",-2,-6,6,2,8,8,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209040, 0x80600000, 0x1a200000, 0x00240909, 0x00608080, 0x90200000, 0x09240000, 0x00201a05}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki829,81,8, "JK182",-2,-6,6,2,8,8,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x001060a0, 0x40900000, 0x25100000, 0x001a0606, 0x00904040, 0x60100000, 0x061a0000, 0x0010252a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki830,81,8, "JK183",-2,-3,6,5,8,8,0x5,832,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200a25, 0x00208080, 0x81200000, 0x09220004, 0x80200040, 0x0a200000, 0x00220909, 0x00208160}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki831,81,8, "JK184",-2,-3,6,5,8,8,0x5,794,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0010051a, 0x00104040, 0x42100000, 0x06110008, 0x40100080, 0x05100000, 0x00110606, 0x00104290}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki832,81,8, "JK185",-3,-1,5,7,8,8,0x5,871,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki833,81,8, "JK186",-3,-1,5,7,8,8,0x5,868,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki834,81,8, "JK187",-2,-6,6,2,8,8,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209000, 0x80600000, 0x1a200000, 0x00240809, 0x00608080, 0x90200000, 0x08240000, 0x00201a01}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki835,81,8, "JK188",-2,-6,6,2,8,8,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106020, 0x40900000, 0x25100000, 0x001a0406, 0x00904040, 0x60100000, 0x041a0000, 0x00102522}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki836,81,8, "JK189",-2,-3,6,5,8,8,0x5,832,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200a24, 0x00208080, 0x81200000, 0x09220004, 0x80200040, 0x0a200000, 0x00220908, 0x00208160}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki837,81,8, "JK190",-2,-3,6,5,8,8,0x5,794,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100518, 0x00104040, 0x42100000, 0x06110008, 0x40100080, 0x05100000, 0x00110604, 0x00104290}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki838,99,8, "JK191",-1,-6,9,2,10,8,0x5,692,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202490, 0x00a04000, 0x60200000, 0x04290202, 0x40a00000, 0x24200000, 0x02290400, 0x0020601a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki839,108,8, "JK192",-1,-6,10,2,11,8,0x5,693,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202490, 0x00a04000, 0x60200000, 0x04290202, 0x40a00000, 0x24200000, 0x02290400, 0x0020601a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki840,117,8, "JK193",-1,-6,11,2,12,8,0x5,694,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x00202490, 0x00a04000, 0x60200000, 0x04290202, 0x40a00000, 0x24200000, 0x02290400, 0x0020601a}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki841,81,8, "JK194",-3,-1,5,7,8,8,0x5,760,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki842,81,8, "JK195",-3,-1,5,7,8,8,0x5,798,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100202, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x0010000a, 0x00100000}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki843,81,8, "JK196",-3,-1,5,7,8,8,0x5,868,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200101, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200005, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki844,81,8, "JK197",-2,-6,6,2,8,8,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00209000, 0x80600000, 0x1a200000, 0x00240809, 0x00608080, 0x90200000, 0x08240000, 0x00201a01}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki845,81,8, "JK198",-2,-6,6,2,8,8,0x5,646,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106020, 0x40900000, 0x25100000, 0x001a0406, 0x00904040, 0x60100000, 0x041a0000, 0x00102522}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki846,117,8, "JK199",-1,-5,11,3,12,8,0x5,731,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x002008a4, 0x00208000, 0x80200000, 0x09220200, 0x80200000, 0x08200000, 0x02220900, 0x00208068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki847,108,8, "JK200",-1,-5,10,3,11,8,0x5,730,
    { 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffffff, 0xffffffff},
    { 0x002008a4, 0x00208000, 0x80200000, 0x09220200, 0x80200000, 0x08200000, 0x02220900, 0x00208068}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki848,81,8, "JK201",-2,-6,6,2,8,8,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00106020, 0x40900000, 0x25100000, 0x001a0406, 0x00904040, 0x60100000, 0x041a0000, 0x00102522}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki848,0,0.000000},
  {joseki849,90,8, "JK202",-2,-6,7,2,9,8,0x5,653,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00289010, 0x80602000, 0x1aa00000, 0x20250809, 0x20608080, 0x90280000, 0x08252000, 0x00a01a11}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki850,90,8, "JK203",-2,-6,7,2,9,8,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00146020, 0x40901000, 0x25500000, 0x101a0406, 0x10904040, 0x60140000, 0x041a1000, 0x00502522}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki851,81,8, "JK204",-3,-1,5,7,8,8,0x5,833,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x1800010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,2,NULL,autohelperjoseki851,3,0.000000},
  {joseki852,81,8, "JK205",-3,-1,5,7,8,8,0x5,834,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki853,81,8, "JK206",-3,-1,5,7,8,8,0x5,870,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki854,81,8, "JK207",-3,-1,5,7,8,8,0x5,758,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki855,81,8, "JK208",-3,-1,5,7,8,8,0x5,908,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220100, 0x00200060, 0x00200000, 0x00200000, 0x00200000, 0x01220000, 0x00200024, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki856,81,8, "JK209",-3,-1,5,7,8,8,0x5,909,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110200, 0x00100090, 0x00100000, 0x00100000, 0x00100000, 0x02110000, 0x00100018, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki857,81,8, "JK210",-3,-1,5,7,8,8,0x5,907,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220100, 0x00200060, 0x00200000, 0x00200000, 0x00200000, 0x01220000, 0x00200024, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki858,81,8, "JK211",-3,-1,5,7,8,8,0x5,872,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00110200, 0x00100090, 0x00100000, 0x00100000, 0x00100000, 0x02110000, 0x00100018, 0x00100000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki859,81,8, "JK212",-3,-1,5,7,8,8,0x5,757,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220100, 0x00200060, 0x00200000, 0x00200000, 0x00200000, 0x01220000, 0x00200024, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki860,81,8, "JK213",-2,-3,6,5,8,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00201a26, 0x00608080, 0x91200000, 0x09260004, 0x80600040, 0x1a200000, 0x0026090a, 0x00209160}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki861,63,8, "JK214",-2,-2,6,4,8,6,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki862,63,8, "JK215",-2,-4,4,4,6,8,0x5,611,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100208, 0x00100080, 0x00100000, 0x02100000, 0x00100000, 0x02100000, 0x00100208, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki863,80,8, "JK216",-2,-5,5,4,7,9,0x5,721,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200104, 0x00200040, 0x02200000, 0x01200008, 0x00200080, 0x01200000, 0x00200104, 0x00200240}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki864,72,8, "JK217",-2,-4,5,4,7,8,0x5,685,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00180208, 0x00102080, 0x01900000, 0x22100004, 0x20100040, 0x02180000, 0x00102208, 0x00900180}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,5.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki865,60,8, "JK218",-2,-5,3,4,5,9,0x5,573,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100208, 0x00100080, 0x00100000, 0x02100000, 0x00100000, 0x02100000, 0x00100208, 0x00100080}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki866,66,8, "JK219",-2,-1,3,9,5,10,0x5,942,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00210000, 0x00200010, 0x00200000, 0x00200000, 0x00200000, 0x00210000, 0x00200010, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki867,49,8, "JK220",-2,-2,4,4,6,6,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200104, 0x00200040, 0x00200000, 0x01200000, 0x00200000, 0x01200000, 0x00200104, 0x00200040}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki868,72,8, "JK221",-2,-4,5,4,7,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00108208, 0x80100080, 0x08100000, 0x02100800, 0x00108000, 0x82100000, 0x08100208, 0x00100880}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki869,72,8, "JK222",-2,-2,5,6,7,8,0x5,795,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00220400, 0x00204020, 0x40200000, 0x04200000, 0x40200000, 0x04220000, 0x00200420, 0x00204000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki870,96,8, "JK223",-2,-1,9,6,11,7,0x5,839,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x002a0400, 0x00206020, 0x40a00000, 0x24200000, 0x60200000, 0x042a0000, 0x00202420, 0x00a04000}
   , 0x1820010,28.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki871,64,8, "JK224",-2,-2,5,5,7,7,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00281001, 0x00602000, 0x10a00000, 0x20240000, 0x20600000, 0x10280000, 0x00242001, 0x00a01000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki872,72,8, "JK225",-2,-3,5,5,7,8,0x5,610,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x0014a002, 0x80901000, 0x28500000, 0x10180800, 0x10908000, 0xa0140000, 0x08181002, 0x00502800}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki873,99,8, "JK226",-2,-1,8,7,10,8,0x5,876,
    { 0xffffffff, 0xffffffff, 0xfcfcfcfc, 0xffffff00, 0xffffff00, 0xffffffff, 0xffffffff, 0xfcfcfcfc},
    { 0x00220500, 0x00204060, 0x40200000, 0x04200000, 0x40200000, 0x05220000, 0x00200424, 0x00204000}
   , 0x1820010,28.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki874,77,8, "JK227",-2,-6,4,4,6,10,0x5,574,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki875,81,8, "JK228",-2,-4,6,4,8,8,0x5,687,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100200, 0x00100080, 0x00100000, 0x00100000, 0x00100000, 0x02100000, 0x00100008, 0x00100000}
   , 0x10820010,0.000000,0.000000,0.000000,0.000000,5.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki876,81,8, "JK229",-2,-4,6,4,8,8,0x5,762,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki877,80,8, "JK230",-2,-5,5,4,7,9,0x5,686,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200100, 0x00200040, 0x00200000, 0x00200000, 0x00200000, 0x01200000, 0x00200004, 0x00200000}
   , 0x820010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki878,81,8, "JK231",-2,-4,6,4,8,8,0x5,649,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00100220, 0x00100080, 0x00100000, 0x00120000, 0x00100000, 0x02100000, 0x00120008, 0x00100020}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,0,0.000000},
  {joseki879,63,8, "JK232",-2,-4,4,4,6,8,0x5,723,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
    { 0x00200190, 0x00200040, 0x00200000, 0x00210200, 0x00200000, 0x01200000, 0x02210004, 0x00200018}
   , 0x900010,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0,NULL,NULL,3,0.000000},
  {joseki880,72,8, "JK233",-2,-4,5,4,7,8,0x5,648,
    { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff},
  