.TH "hmmconvert" 1 "May 2003" "HMMER 2.3" "HMMER Manual"

.SH NAME
.TP 
hmmconvert - convert between profile HMM file formats

.SH SYNOPSIS
.B hmmconvert
.I [options]
.I oldhmmfile
.I newhmmfile

.SH DESCRIPTION

.B hmmconvert
reads an HMM file from
.I oldhmmfile
in any HMMER format, and writes it to a new file
.I newhmmfile 
in a new format.
.I oldhmmfile 
and 
.I newhmmfile
must be different files; you can't reliably overwrite 
the old file.
By default, the new HMM file is written in HMMER 2
ASCII format. 

Available formats are HMMER 2 ASCII (default), HMMER 2 binary
.I (-b)
GCG profile 
.I (-p)
, and Compugen XSW extended profile 
.I (-P).

.SH OPTIONS

.TP
.B -a 
Convert to HMMER 2 ASCII file. This is the default, so this option
is unnecessary.

.TP 
.B -b 
Convert to HMMER 2 binary file. 

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -p
Convert to GCG profile .prf format.

.TP 
.B -A
Append mode; append to
.I newhmmfile
rather than creating a new file. 

.TP
.B -F
Force; if 
.I newhmmfile
already exists, and
.I -A 
is not being used to append to the file,
hmmconvert will refuse to clobber the existing
file unless 
.I -F 
is used.

.TP
.B -P
Convert the HMM to Compugen XSW extended profile format,
which is similar to GCG profile format but has two
extra columns for delete-open and delete-extend costs.
(I do not believe that Compugen publicly supports this
format; it may be undocumented.)


.SH SEE ALSO

Master man page, with full list of and guide to the individual man
pages: see 
.B hmmer(1).
.PP
For complete documentation, see the user guide that came with the
distribution (Userguide.pdf); or see the HMMER web page,
http://hmmer.wustl.edu/.

.SH COPYRIGHT

.nf
Copyright (C) 1992-2003 HHMI/Washington University School of Medicine.
Freely distributed under the GNU General Public License (GPL).
.fi
See the file COPYING in your distribution for details on redistribution
conditions.

.SH AUTHOR 

.nf
Sean Eddy
HHMI/Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
http://www.genetics.wustl.edu/eddy/
.fi


