#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/mc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/mc.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/predict.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/predict.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/pixel.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/pixel.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/macroblock.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/macroblock.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/frame.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/frame.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/dct.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/dct.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/cpu.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/cpu.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/cabac.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/cabac.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/common.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/common.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/mdate.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/mdate.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/rectangle.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/rectangle.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/set.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/set.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/quant.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/quant.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/deblock.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/deblock.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/vlc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/vlc.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/common/mvpred.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/common/mvpred.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/analyse.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/analyse.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/me.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/me.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/ratecontrol.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/ratecontrol.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/set.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/set.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/macroblock.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/macroblock.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/cabac.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/cabac.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/cavlc.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/cavlc.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/encoder/lookahead.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/encoder/lookahead.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/input/timecode.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/input/timecode.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/input/yuv.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/input/yuv.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/input/y4m.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/input/y4m.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/output/raw.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/output/raw.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/output/matroska.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/output/matroska.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/output/matroska_ebml.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/output/matroska_ebml.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/output/flv.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/output/flv.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/output/flv_bytestream.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/output/flv_bytestream.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/input/thread.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/input/thread.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/x264.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/x264.c
/usr/bin/gcc     -std=c99   -m64 -c -o x264_src/extras/getopt.o -DSPEC -DSPEC_CPU -DNDEBUG -Ildecod_src/inc -Ix264_src -Ix264_src/extras -Ix264_src/common -DSPEC_AUTO_SUPPRESS_OPENMP -DSPEC_AUTO_BYTEORDER=0x12345678  -g            -fno-strict-aliasing   -DSPEC_LP64  x264_src/extras/getopt.c
/usr/bin/gcc     -std=c99   -m64  -z muldefs    -g         -fno-strict-aliasing x264_src/common/mc.o x264_src/common/predict.o x264_src/common/pixel.o x264_src/common/macroblock.o x264_src/common/frame.o x264_src/common/dct.o x264_src/common/cpu.o x264_src/common/cabac.o x264_src/common/common.o x264_src/common/mdate.o x264_src/common/rectangle.o x264_src/common/set.o x264_src/common/quant.o x264_src/common/deblock.o x264_src/common/vlc.o x264_src/common/mvpred.o x264_src/encoder/analyse.o x264_src/encoder/me.o x264_src/encoder/ratecontrol.o x264_src/encoder/set.o x264_src/encoder/macroblock.o x264_src/encoder/cabac.o x264_src/encoder/cavlc.o x264_src/encoder/encoder.o x264_src/encoder/lookahead.o x264_src/input/timecode.o x264_src/input/yuv.o x264_src/input/y4m.o x264_src/output/raw.o x264_src/output/matroska.o x264_src/output/matroska_ebml.o x264_src/output/flv.o x264_src/output/flv_bytestream.o x264_src/input/thread.o x264_src/x264.o x264_src/extras/getopt.o             -lm         -o x264_r  
