#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/attr.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/attr.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/error.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/error.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-attio.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-attio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-control.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-control.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genatt.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-genatt.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-geninq.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-geninq.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genvar.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-genvar.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-lib.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-lib.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-misc.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-misc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-v2compat.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-v2compat.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-var1io.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-var1io.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varaio.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-varaio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-vario.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-vario.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varmio.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-varmio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varsio.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/fort-varsio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/libvers.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/libvers.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/nc.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/nc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/ncx.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/ncx.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/posixio.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/posixio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/putget.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/putget.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/string.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/string.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v1hpg.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/v1hpg.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v2i.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/v2i.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/var.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  netcdf/var.c
/usr/bin/gfortran           -m64 -c -o netcdf/typeSizes.o -g -fconvert=big-endian -fopenmp netcdf/typeSizes.f90
/usr/bin/gfortran           -m64 -c -o netcdf/netcdf.o -g -fconvert=big-endian -fopenmp netcdf/netcdf.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 fort.F90 -o fort.fppized.f90
/usr/bin/gfortran           -m64 -c -o fort.fppized.o -g -fconvert=big-endian -fopenmp fort.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o mpi.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  mpi.c
/usr/bin/gcc     -std=c99   -m64 -c -o send.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  send.c
/usr/bin/gcc     -std=c99   -m64 -c -o recv.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  recv.c
/usr/bin/gcc     -std=c99   -m64 -c -o collective.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  collective.c
/usr/bin/gcc     -std=c99   -m64 -c -o req.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  req.c
/usr/bin/gcc     -std=c99   -m64 -c -o list.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  list.c
/usr/bin/gcc     -std=c99   -m64 -c -o handles.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  handles.c
/usr/bin/gcc     -std=c99   -m64 -c -o comm.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  comm.c
/usr/bin/gcc     -std=c99   -m64 -c -o group.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  group.c
/usr/bin/gcc     -std=c99   -m64 -c -o time.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  time.c
/usr/bin/gcc     -std=c99   -m64 -c -o pack.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  pack.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_IndexBin_char.F90 -o m_IndexBin_char.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_die.F90 -o m_die.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_dropdead.F90 -o m_dropdead.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_mpif90.F90 -o m_mpif90.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_mpif.F90 -o m_mpif.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpif.fppized.o -g -fconvert=big-endian -fopenmp m_mpif.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_realkinds.F90 -o m_realkinds.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_realkinds.fppized.o -g -fconvert=big-endian -fopenmp m_realkinds.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_stdio.F90 -o m_stdio.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_stdio.fppized.o -g -fconvert=big-endian -fopenmp m_stdio.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpif90.fppized.o -g -fconvert=big-endian -fopenmp m_mpif90.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_dropdead.fppized.o -g -fconvert=big-endian -fopenmp m_dropdead.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_flow.F90 -o m_flow.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_chars.F90 -o m_chars.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_chars.fppized.o -g -fconvert=big-endian -fopenmp m_chars.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_flow.fppized.o -g -fconvert=big-endian -fopenmp m_flow.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_mpout.F90 -o m_mpout.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_ioutil.F90 -o m_ioutil.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ioutil.fppized.o -g -fconvert=big-endian -fopenmp m_ioutil.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpout.fppized.o -g -fconvert=big-endian -fopenmp m_mpout.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_die.fppized.o -g -fconvert=big-endian -fopenmp m_die.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_char.fppized.o -g -fconvert=big-endian -fopenmp m_IndexBin_char.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_IndexBin_integer.F90 -o m_IndexBin_integer.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_integer.fppized.o -g -fconvert=big-endian -fopenmp m_IndexBin_integer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_IndexBin_logical.F90 -o m_IndexBin_logical.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_logical.fppized.o -g -fconvert=big-endian -fopenmp m_IndexBin_logical.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_List.F90 -o m_List.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_String.F90 -o m_String.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_mall.F90 -o m_mall.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mall.fppized.o -g -fconvert=big-endian -fopenmp m_mall.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_String.fppized.o -g -fconvert=big-endian -fopenmp m_String.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_List.fppized.o -g -fconvert=big-endian -fopenmp m_List.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_MergeSorts.F90 -o m_MergeSorts.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MergeSorts.fppized.o -g -fconvert=big-endian -fopenmp m_MergeSorts.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Filename.F90 -o m_Filename.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Filename.fppized.o -g -fconvert=big-endian -fopenmp m_Filename.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_FcComms.F90 -o m_FcComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_FcComms.fppized.o -g -fconvert=big-endian -fopenmp m_FcComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Permuter.F90 -o m_Permuter.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Permuter.fppized.o -g -fconvert=big-endian -fopenmp m_Permuter.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SortingTools.F90 -o m_SortingTools.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_rankMerge.F90 -o m_rankMerge.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_rankMerge.fppized.o -g -fconvert=big-endian -fopenmp m_rankMerge.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SortingTools.fppized.o -g -fconvert=big-endian -fopenmp m_SortingTools.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_StrTemplate.F90 -o m_StrTemplate.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_StrTemplate.fppized.o -g -fconvert=big-endian -fopenmp m_StrTemplate.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_FileResolv.F90 -o m_FileResolv.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_FileResolv.fppized.o -g -fconvert=big-endian -fopenmp m_FileResolv.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_inpak90.F90 -o m_inpak90.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_inpak90.fppized.o -g -fconvert=big-endian -fopenmp m_inpak90.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_TraceBack.F90 -o m_TraceBack.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_TraceBack.fppized.o -g -fconvert=big-endian -fopenmp m_TraceBack.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_zeit.F90 -o m_zeit.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_zeit.fppized.o -g -fconvert=big-endian -fopenmp m_zeit.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o get_zeits.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  get_zeits.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_MCTWorld.F90 -o m_MCTWorld.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MCTWorld.fppized.o -g -fconvert=big-endian -fopenmp m_MCTWorld.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_AttrVect.F90 -o m_AttrVect.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVect.fppized.o -g -fconvert=big-endian -fopenmp m_AttrVect.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GlobalMap.F90 -o m_GlobalMap.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalMap.fppized.o -g -fconvert=big-endian -fopenmp m_GlobalMap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GlobalSegMap.F90 -o m_GlobalSegMap.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalSegMap.fppized.o -g -fconvert=big-endian -fopenmp m_GlobalSegMap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GlobalSegMapComms.F90 -o m_GlobalSegMapComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalSegMapComms.fppized.o -g -fconvert=big-endian -fopenmp m_GlobalSegMapComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Accumulator.F90 -o m_Accumulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Accumulator.fppized.o -g -fconvert=big-endian -fopenmp m_Accumulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SparseMatrix.F90 -o m_SparseMatrix.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrix.fppized.o -g -fconvert=big-endian -fopenmp m_SparseMatrix.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Navigator.F90 -o m_Navigator.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Navigator.fppized.o -g -fconvert=big-endian -fopenmp m_Navigator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_AttrVectComms.F90 -o m_AttrVectComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVectComms.fppized.o -g -fconvert=big-endian -fopenmp m_AttrVectComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_AttrVectReduce.F90 -o m_AttrVectReduce.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVectReduce.fppized.o -g -fconvert=big-endian -fopenmp m_AttrVectReduce.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_AccumulatorComms.F90 -o m_AccumulatorComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AccumulatorComms.fppized.o -g -fconvert=big-endian -fopenmp m_AccumulatorComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GeneralGrid.F90 -o m_GeneralGrid.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GeneralGrid.fppized.o -g -fconvert=big-endian -fopenmp m_GeneralGrid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GeneralGridComms.F90 -o m_GeneralGridComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GeneralGridComms.fppized.o -g -fconvert=big-endian -fopenmp m_GeneralGridComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SpatialIntegral.F90 -o m_SpatialIntegral.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SpatialIntegralV.F90 -o m_SpatialIntegralV.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SpatialIntegralV.fppized.o -g -fconvert=big-endian -fopenmp m_SpatialIntegralV.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SpatialIntegral.fppized.o -g -fconvert=big-endian -fopenmp m_SpatialIntegral.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_MatAttrVectMul.F90 -o m_MatAttrVectMul.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Rearranger.F90 -o m_Rearranger.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Router.F90 -o m_Router.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_ExchangeMaps.F90 -o m_ExchangeMaps.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_ConvertMaps.F90 -o m_ConvertMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ConvertMaps.fppized.o -g -fconvert=big-endian -fopenmp m_ConvertMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ExchangeMaps.fppized.o -g -fconvert=big-endian -fopenmp m_ExchangeMaps.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_GlobalToLocal.F90 -o m_GlobalToLocal.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalToLocal.fppized.o -g -fconvert=big-endian -fopenmp m_GlobalToLocal.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Router.fppized.o -g -fconvert=big-endian -fopenmp m_Router.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Rearranger.fppized.o -g -fconvert=big-endian -fopenmp m_Rearranger.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SparseMatrixPlus.F90 -o m_SparseMatrixPlus.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SparseMatrixComms.F90 -o m_SparseMatrixComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SparseMatrixDecomp.F90 -o m_SparseMatrixDecomp.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixDecomp.fppized.o -g -fconvert=big-endian -fopenmp m_SparseMatrixDecomp.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixComms.fppized.o -g -fconvert=big-endian -fopenmp m_SparseMatrixComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_SparseMatrixToMaps.F90 -o m_SparseMatrixToMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixToMaps.fppized.o -g -fconvert=big-endian -fopenmp m_SparseMatrixToMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixPlus.fppized.o -g -fconvert=big-endian -fopenmp m_SparseMatrixPlus.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MatAttrVectMul.fppized.o -g -fconvert=big-endian -fopenmp m_MatAttrVectMul.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Merge.F90 -o m_Merge.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Merge.fppized.o -g -fconvert=big-endian -fopenmp m_Merge.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 m_Transfer.F90 -o m_Transfer.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Transfer.fppized.o -g -fconvert=big-endian -fopenmp m_Transfer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 alloc_mod.F90 -o alloc_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_kinds.F90 -o pio_kinds.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_kinds.fppized.o -g -fconvert=big-endian -fopenmp pio_kinds.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_support.F90 -o pio_support.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_support.fppized.o -g -fconvert=big-endian -fopenmp pio_support.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_types.F90 -o pio_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_types.fppized.o -g -fconvert=big-endian -fopenmp pio_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o alloc_mod.fppized.o -g -fconvert=big-endian -fopenmp alloc_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 box_rearrange.F90 -o box_rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_spmd_utils.F90 -o pio_spmd_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_spmd_utils.fppized.o -g -fconvert=big-endian -fopenmp pio_spmd_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o box_rearrange.fppized.o -g -fconvert=big-endian -fopenmp box_rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 iompi_mod.F90 -o iompi_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o iompi_mod.fppized.o -g -fconvert=big-endian -fopenmp iompi_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ionf_mod.F90 -o ionf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_utils.F90 -o pio_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_utils.fppized.o -g -fconvert=big-endian -fopenmp pio_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o ionf_mod.fppized.o -g -fconvert=big-endian -fopenmp ionf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mct_rearrange.F90 -o mct_rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o mct_rearrange.fppized.o -g -fconvert=big-endian -fopenmp mct_rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 nf_mod.F90 -o nf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o nf_mod.fppized.o -g -fconvert=big-endian -fopenmp nf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 piodarray.F90 -o piodarray.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pionfread_mod.F90 -o pionfread_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfread_mod.fppized.o -g -fconvert=big-endian -fopenmp pionfread_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pionfwrite_mod.F90 -o pionfwrite_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfwrite_mod.fppized.o -g -fconvert=big-endian -fopenmp pionfwrite_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 rearrange.F90 -o rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o rearrange.fppized.o -g -fconvert=big-endian -fopenmp rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o piodarray.fppized.o -g -fconvert=big-endian -fopenmp piodarray.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio.F90 -o pio.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 piolib_mod.F90 -o piolib_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_mpi_utils.F90 -o pio_mpi_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_mpi_utils.fppized.o -g -fconvert=big-endian -fopenmp pio_mpi_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o piolib_mod.fppized.o -g -fconvert=big-endian -fopenmp piolib_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pionfatt_mod.F90 -o pionfatt_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfatt_mod.fppized.o -g -fconvert=big-endian -fopenmp pionfatt_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pionfget_mod.F90 -o pionfget_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfget_mod.fppized.o -g -fconvert=big-endian -fopenmp pionfget_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pionfput_mod.F90 -o pionfput_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfput_mod.fppized.o -g -fconvert=big-endian -fopenmp pionfput_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio.fppized.o -g -fconvert=big-endian -fopenmp pio.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_nf_utils.F90 -o pio_nf_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_nf_utils.fppized.o -g -fconvert=big-endian -fopenmp pio_nf_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pio_quicksort.F90 -o pio_quicksort.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_quicksort.fppized.o -g -fconvert=big-endian -fopenmp pio_quicksort.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o pnetcdfversion.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  pnetcdfversion.c
/usr/bin/gcc     -std=c99   -m64 -c -o topology.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  topology.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 dead_data_mod.F90 -o dead_data_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_kind_mod.F90 -o shr_kind_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_kind_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_kind_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dead_data_mod.fppized.o -g -fconvert=big-endian -fopenmp dead_data_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 dead_mct_mod.F90 -o dead_mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mct_mod.F90 -o mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_const_mod.F90 -o shr_const_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_const_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_const_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_log_mod.F90 -o shr_log_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_log_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_log_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_mpi_mod.F90 -o shr_mpi_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mpi_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_mpi_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_sys_mod.F90 -o shr_sys_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_sys_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_sys_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o mct_mod.fppized.o -g -fconvert=big-endian -fopenmp mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_flds_mod.F90 -o seq_flds_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_drydep_mod.F90 -o seq_drydep_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_file_mod.F90 -o shr_file_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_file_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_file_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_drydep_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_drydep_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_string_mod.F90 -o shr_string_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_cal_mod.F90 -o shr_cal_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_Mod.F90 -o ESMF_Mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_AlarmClockMod.F90 -o ESMF_AlarmClockMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_AlarmMod.F90 -o ESMF_AlarmMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_BaseMod.F90 -o ESMF_BaseMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_BaseMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_BaseMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_TimeIntervalMod.F90 -o ESMF_TimeIntervalMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_BaseTimeMod.F90 -o ESMF_BaseTimeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_BaseTimeMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_BaseTimeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_CalendarMod.F90 -o ESMF_CalendarMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_CalendarMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_CalendarMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_FractionMod.F90 -o ESMF_FractionMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_FractionMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_FractionMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_TimeIntervalMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_TimeIntervalMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_TimeMod.F90 -o ESMF_TimeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_TimeMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_TimeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_AlarmMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_AlarmMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_ClockMod.F90 -o ESMF_ClockMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_ClockMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_ClockMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_AlarmClockMod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_AlarmClockMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ESMF_Stubs.F90 -o ESMF_Stubs.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_Stubs.fppized.o -g -fconvert=big-endian -fopenmp ESMF_Stubs.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_Mod.fppized.o -g -fconvert=big-endian -fopenmp ESMF_Mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_cal_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_cal_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_timer_mod.F90 -o shr_timer_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_timer_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_timer_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_string_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_string_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flds_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_flds_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dead_mct_mod.fppized.o -g -fconvert=big-endian -fopenmp dead_mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 dead_mod.F90 -o dead_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dead_mod.fppized.o -g -fconvert=big-endian -fopenmp dead_mod.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o f_wrappers.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  f_wrappers.c
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLget_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  GPTLget_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLprint_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  GPTLprint_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLutil.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  GPTLutil.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 Meat.F90 -o Meat.fppized.f90
/usr/bin/gfortran           -m64 -c -o Meat.fppized.o -g -fconvert=big-endian -fopenmp Meat.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 perf_mod.F90 -o perf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 perf_utils.F90 -o perf_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o perf_utils.fppized.o -g -fconvert=big-endian -fopenmp perf_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o perf_mod.fppized.o -g -fconvert=big-endian -fopenmp perf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_cdata_mod.F90 -o seq_cdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_comm_mct.F90 -o seq_comm_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_comm_mct.fppized.o -g -fconvert=big-endian -fopenmp seq_comm_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_infodata_mod.F90 -o seq_infodata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_io_mod.F90 -o seq_io_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_io_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_io_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_orb_mod.F90 -o shr_orb_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_orb_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_orb_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_infodata_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_infodata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_cdata_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_cdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_flds_indices.F90 -o seq_flds_indices.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flds_indices.fppized.o -g -fconvert=big-endian -fopenmp seq_flds_indices.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_timemgr_mod.F90 -o seq_timemgr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_timemgr_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_timemgr_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_dmodel_mod.F90 -o shr_dmodel_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_map_mod.F90 -o shr_map_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_map_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_map_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_ncread_mod.F90 -o shr_ncread_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_ncread_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_ncread_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_stream_mod.F90 -o shr_stream_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_stream_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_stream_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_dmodel_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_dmodel_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_flux_mod.F90 -o shr_flux_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_flux_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_flux_mod.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o shr_jlcp.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  shr_jlcp.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_mct_mod.F90 -o shr_mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_pcdf_mod.F90 -o shr_pcdf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_pcdf_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_pcdf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mct_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_mem_mod.F90 -o shr_mem_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mem_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_mem_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_msg_mod.F90 -o shr_msg_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_msg_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_msg_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_scam_mod.F90 -o shr_scam_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_strdata_mod.F90 -o shr_strdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_tInterp_mod.F90 -o shr_tInterp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_tInterp_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_tInterp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_strdata_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_strdata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_scam_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_scam_mod.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o shr_vmath_fwrap.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  shr_vmath_fwrap.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 shr_vmath_mod.F90 -o shr_vmath_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_vmath_mod.fppized.o -g -fconvert=big-endian -fopenmp shr_vmath_mod.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o threadutil.o -DSPEC -DSPEC_CPU -DNDEBUG  -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP    -DSPEC_LP64  threadutil.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 wrf_error_fatal.F90 -o wrf_error_fatal.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrf_error_fatal.fppized.o -g -fconvert=big-endian -fopenmp wrf_error_fatal.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 wrf_message.F90 -o wrf_message.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrf_message.fppized.o -g -fconvert=big-endian -fopenmp wrf_message.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 atm_comp_mct.F90 -o atm_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 datm_comp_mod.F90 -o datm_comp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 datm_shr_mod.F90 -o datm_shr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o datm_shr_mod.fppized.o -g -fconvert=big-endian -fopenmp datm_shr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o datm_comp_mod.fppized.o -g -fconvert=big-endian -fopenmp datm_comp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o atm_comp_mct.fppized.o -g -fconvert=big-endian -fopenmp atm_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 dlnd_comp_mod.F90 -o dlnd_comp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dlnd_comp_mod.fppized.o -g -fconvert=big-endian -fopenmp dlnd_comp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 lnd_comp_mct.F90 -o lnd_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o lnd_comp_mct.fppized.o -g -fconvert=big-endian -fopenmp lnd_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 dice_comp_mod.F90 -o dice_comp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dice_comp_mod.fppized.o -g -fconvert=big-endian -fopenmp dice_comp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ice_comp_mct.F90 -o ice_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o ice_comp_mct.fppized.o -g -fconvert=big-endian -fopenmp ice_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_BlocksMod.F90 -o POP_BlocksMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_DomainSizeMod.F90 -o POP_DomainSizeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_KindsMod.F90 -o POP_KindsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_KindsMod.fppized.o -g -fconvert=big-endian -fopenmp POP_KindsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_DomainSizeMod.fppized.o -g -fconvert=big-endian -fopenmp POP_DomainSizeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_ErrorMod.F90 -o POP_ErrorMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_CommMod.F90 -o POP_CommMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ocn_communicator.F90 -o ocn_communicator.fppized.f90
/usr/bin/gfortran           -m64 -c -o ocn_communicator.fppized.o -g -fconvert=big-endian -fopenmp ocn_communicator.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_CommMod.fppized.o -g -fconvert=big-endian -fopenmp POP_CommMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_IOUnitsMod.F90 -o POP_IOUnitsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_IOUnitsMod.fppized.o -g -fconvert=big-endian -fopenmp POP_IOUnitsMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_types.F90 -o io_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 broadcast.F90 -o broadcast.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 communicate.F90 -o communicate.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 kinds_mod.F90 -o kinds_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o kinds_mod.fppized.o -g -fconvert=big-endian -fopenmp kinds_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o communicate.fppized.o -g -fconvert=big-endian -fopenmp communicate.fppized.f90
/usr/bin/gfortran           -m64 -c -o broadcast.fppized.o -g -fconvert=big-endian -fopenmp broadcast.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 constants.F90 -o constants.fppized.f90
/usr/bin/gfortran           -m64 -c -o constants.fppized.o -g -fconvert=big-endian -fopenmp constants.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 exit_mod.F90 -o exit_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o exit_mod.fppized.o -g -fconvert=big-endian -fopenmp exit_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_types.fppized.o -g -fconvert=big-endian -fopenmp io_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_ErrorMod.fppized.o -g -fconvert=big-endian -fopenmp POP_ErrorMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_BlocksMod.fppized.o -g -fconvert=big-endian -fopenmp POP_BlocksMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_BroadcastMod.F90 -o POP_BroadcastMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_BroadcastMod.fppized.o -g -fconvert=big-endian -fopenmp POP_BroadcastMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_ConfigMod.F90 -o POP_ConfigMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_ConfigMod.fppized.o -g -fconvert=big-endian -fopenmp POP_ConfigMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_ConstantsMod.F90 -o POP_ConstantsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_ConstantsMod.fppized.o -g -fconvert=big-endian -fopenmp POP_ConstantsMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_DistributionMod.F90 -o POP_DistributionMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 spacecurve_mod.F90 -o spacecurve_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o spacecurve_mod.fppized.o -g -fconvert=big-endian -fopenmp spacecurve_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_DistributionMod.fppized.o -g -fconvert=big-endian -fopenmp POP_DistributionMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_FieldMod.F90 -o POP_FieldMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_GridDimMod.F90 -o POP_GridDimMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_GridDimMod.fppized.o -g -fconvert=big-endian -fopenmp POP_GridDimMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_GridHorzMod.F90 -o POP_GridHorzMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_GridHorzMod.fppized.o -g -fconvert=big-endian -fopenmp POP_GridHorzMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_GridVertMod.F90 -o POP_GridVertMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_GridVertMod.fppized.o -g -fconvert=big-endian -fopenmp POP_GridVertMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_FieldMod.fppized.o -g -fconvert=big-endian -fopenmp POP_FieldMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_FinalMod.F90 -o POP_FinalMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 timers.F90 -o timers.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 domain.F90 -o domain.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_HaloMod.F90 -o POP_HaloMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_ReductionsMod.F90 -o POP_ReductionsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_ReductionsMod.fppized.o -g -fconvert=big-endian -fopenmp POP_ReductionsMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_HaloMod.fppized.o -g -fconvert=big-endian -fopenmp POP_HaloMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 blocks.F90 -o blocks.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 domain_size.F90 -o domain_size.fppized.f90
/usr/bin/gfortran           -m64 -c -o domain_size.fppized.o -g -fconvert=big-endian -fopenmp domain_size.fppized.f90
/usr/bin/gfortran           -m64 -c -o blocks.fppized.o -g -fconvert=big-endian -fopenmp blocks.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 distribution.F90 -o distribution.fppized.f90
/usr/bin/gfortran           -m64 -c -o distribution.fppized.o -g -fconvert=big-endian -fopenmp distribution.fppized.f90
/usr/bin/gfortran           -m64 -c -o domain.fppized.o -g -fconvert=big-endian -fopenmp domain.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 global_reductions.F90 -o global_reductions.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 registry.F90 -o registry.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_tools.F90 -o io_tools.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_tools.fppized.o -g -fconvert=big-endian -fopenmp io_tools.fppized.f90
/usr/bin/gfortran           -m64 -c -o registry.fppized.o -g -fconvert=big-endian -fopenmp registry.fppized.f90
/usr/bin/gfortran           -m64 -c -o global_reductions.fppized.o -g -fconvert=big-endian -fopenmp global_reductions.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io.F90 -o io.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_binary.F90 -o io_binary.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 gather_scatter.F90 -o gather_scatter.fppized.f90
/usr/bin/gfortran           -m64 -c -o gather_scatter.fppized.o -g -fconvert=big-endian -fopenmp gather_scatter.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_binary.fppized.o -g -fconvert=big-endian -fopenmp io_binary.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_netcdf.F90 -o io_netcdf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_pio.F90 -o io_pio.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_pio.fppized.o -g -fconvert=big-endian -fopenmp io_pio.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_netcdf.fppized.o -g -fconvert=big-endian -fopenmp io_netcdf.fppized.f90
/usr/bin/gfortran           -m64 -c -o io.fppized.o -g -fconvert=big-endian -fopenmp io.fppized.f90
/usr/bin/gfortran           -m64 -c -o timers.fppized.o -g -fconvert=big-endian -fopenmp timers.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_FinalMod.fppized.o -g -fconvert=big-endian -fopenmp POP_FinalMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_InitMod.F90 -o POP_InitMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 initial.F90 -o initial.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_SolversMod.F90 -o POP_SolversMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_RedistributeMod.F90 -o POP_RedistributeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_RedistributeMod.fppized.o -g -fconvert=big-endian -fopenmp POP_RedistributeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 grid.F90 -o grid.fppized.f90
/usr/bin/gfortran           -m64 -c -o grid.fppized.o -g -fconvert=big-endian -fopenmp grid.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_SolversMod.fppized.o -g -fconvert=big-endian -fopenmp POP_SolversMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 advection.F90 -o advection.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 diagnostics.F90 -o diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing.F90 -o forcing.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_ap.F90 -o forcing_ap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_tools.F90 -o forcing_tools.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 time_management.F90 -o time_management.fppized.f90
/usr/bin/gfortran           -m64 -c -o time_management.fppized.o -g -fconvert=big-endian -fopenmp time_management.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_tools.fppized.o -g -fconvert=big-endian -fopenmp forcing_tools.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_ap.fppized.o -g -fconvert=big-endian -fopenmp forcing_ap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_coupled.F90 -o forcing_coupled.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_fields.F90 -o forcing_fields.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_fields.fppized.o -g -fconvert=big-endian -fopenmp forcing_fields.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_sfwf.F90 -o forcing_sfwf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_shf.F90 -o forcing_shf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 prognostic.F90 -o prognostic.fppized.f90
/usr/bin/gfortran           -m64 -c -o prognostic.fppized.o -g -fconvert=big-endian -fopenmp prognostic.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_shf.fppized.o -g -fconvert=big-endian -fopenmp forcing_shf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ice.F90 -o ice.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 passive_tracers.F90 -o passive_tracers.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 cfc_mod.F90 -o cfc_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 passive_tracer_tools.F90 -o passive_tracer_tools.fppized.f90
/usr/bin/gfortran           -m64 -c -o passive_tracer_tools.fppized.o -g -fconvert=big-endian -fopenmp passive_tracer_tools.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 tavg.F90 -o tavg.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 diag_bsf.F90 -o diag_bsf.fppized.f90
/usr/bin/gfortran           -m64 -c -o diag_bsf.fppized.o -g -fconvert=big-endian -fopenmp diag_bsf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 diags_on_lat_aux_grid.F90 -o diags_on_lat_aux_grid.fppized.f90
/usr/bin/gfortran           -m64 -c -o diags_on_lat_aux_grid.fppized.o -g -fconvert=big-endian -fopenmp diags_on_lat_aux_grid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 io_ccsm.F90 -o io_ccsm.fppized.f90
/usr/bin/gfortran           -m64 -c -o io_ccsm.fppized.o -g -fconvert=big-endian -fopenmp io_ccsm.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 operators.F90 -o operators.fppized.f90
/usr/bin/gfortran           -m64 -c -o operators.fppized.o -g -fconvert=big-endian -fopenmp operators.fppized.f90
/usr/bin/gfortran           -m64 -c -o tavg.fppized.o -g -fconvert=big-endian -fopenmp tavg.fppized.f90
/usr/bin/gfortran           -m64 -c -o cfc_mod.fppized.o -g -fconvert=big-endian -fopenmp cfc_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ecosys_mod.F90 -o ecosys_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 POP_MCT_vars_mod.F90 -o POP_MCT_vars_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_MCT_vars_mod.fppized.o -g -fconvert=big-endian -fopenmp POP_MCT_vars_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 co2calc.F90 -o co2calc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 state_mod.F90 -o state_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o state_mod.fppized.o -g -fconvert=big-endian -fopenmp state_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o co2calc.fppized.o -g -fconvert=big-endian -fopenmp co2calc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ecosys_parms.F90 -o ecosys_parms.fppized.f90
/usr/bin/gfortran           -m64 -c -o ecosys_parms.fppized.o -g -fconvert=big-endian -fopenmp ecosys_parms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 named_field_mod.F90 -o named_field_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o named_field_mod.fppized.o -g -fconvert=big-endian -fopenmp named_field_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ecosys_mod.fppized.o -g -fconvert=big-endian -fopenmp ecosys_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 iage_mod.F90 -o iage_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o iage_mod.fppized.o -g -fconvert=big-endian -fopenmp iage_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o passive_tracers.fppized.o -g -fconvert=big-endian -fopenmp passive_tracers.fppized.f90
/usr/bin/gfortran           -m64 -c -o ice.fppized.o -g -fconvert=big-endian -fopenmp ice.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_sfwf.fppized.o -g -fconvert=big-endian -fopenmp forcing_sfwf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_ws.F90 -o forcing_ws.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_ws.fppized.o -g -fconvert=big-endian -fopenmp forcing_ws.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ms_balance.F90 -o ms_balance.fppized.f90
/usr/bin/gfortran           -m64 -c -o ms_balance.fppized.o -g -fconvert=big-endian -fopenmp ms_balance.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_coupled.fppized.o -g -fconvert=big-endian -fopenmp forcing_coupled.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_pt_interior.F90 -o forcing_pt_interior.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_pt_interior.fppized.o -g -fconvert=big-endian -fopenmp forcing_pt_interior.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 forcing_s_interior.F90 -o forcing_s_interior.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing_s_interior.fppized.o -g -fconvert=big-endian -fopenmp forcing_s_interior.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 movie.F90 -o movie.fppized.f90
/usr/bin/gfortran           -m64 -c -o movie.fppized.o -g -fconvert=big-endian -fopenmp movie.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 sw_absorption.F90 -o sw_absorption.fppized.f90
/usr/bin/gfortran           -m64 -c -o sw_absorption.fppized.o -g -fconvert=big-endian -fopenmp sw_absorption.fppized.f90
/usr/bin/gfortran           -m64 -c -o forcing.fppized.o -g -fconvert=big-endian -fopenmp forcing.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 vmix_kpp.F90 -o vmix_kpp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 tidal_mixing.F90 -o tidal_mixing.fppized.f90
/usr/bin/gfortran           -m64 -c -o tidal_mixing.fppized.o -g -fconvert=big-endian -fopenmp tidal_mixing.fppized.f90
/usr/bin/gfortran           -m64 -c -o vmix_kpp.fppized.o -g -fconvert=big-endian -fopenmp vmix_kpp.fppized.f90
/usr/bin/gfortran           -m64 -c -o diagnostics.fppized.o -g -fconvert=big-endian -fopenmp diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 overflows.F90 -o overflows.fppized.f90
/usr/bin/gfortran           -m64 -c -o overflows.fppized.o -g -fconvert=big-endian -fopenmp overflows.fppized.f90
/usr/bin/gfortran           -m64 -c -o advection.fppized.o -g -fconvert=big-endian -fopenmp advection.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 baroclinic.F90 -o baroclinic.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 horizontal_mix.F90 -o horizontal_mix.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hmix_aniso.F90 -o hmix_aniso.fppized.f90
/usr/bin/gfortran           -m64 -c -o hmix_aniso.fppized.o -g -fconvert=big-endian -fopenmp hmix_aniso.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hmix_del2.F90 -o hmix_del2.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 topostress.F90 -o topostress.fppized.f90
/usr/bin/gfortran           -m64 -c -o topostress.fppized.o -g -fconvert=big-endian -fopenmp topostress.fppized.f90
/usr/bin/gfortran           -m64 -c -o hmix_del2.fppized.o -g -fconvert=big-endian -fopenmp hmix_del2.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hmix_del4.F90 -o hmix_del4.fppized.f90
/usr/bin/gfortran           -m64 -c -o hmix_del4.fppized.o -g -fconvert=big-endian -fopenmp hmix_del4.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hmix_gm.F90 -o hmix_gm.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hmix_gm_submeso_share.F90 -o hmix_gm_submeso_share.fppized.f90
/usr/bin/gfortran           -m64 -c -o hmix_gm_submeso_share.fppized.o -g -fconvert=big-endian -fopenmp hmix_gm_submeso_share.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 vertical_mix.F90 -o vertical_mix.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 vmix_const.F90 -o vmix_const.fppized.f90
/usr/bin/gfortran           -m64 -c -o vmix_const.fppized.o -g -fconvert=big-endian -fopenmp vmix_const.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 vmix_rich.F90 -o vmix_rich.fppized.f90
/usr/bin/gfortran           -m64 -c -o vmix_rich.fppized.o -g -fconvert=big-endian -fopenmp vmix_rich.fppized.f90
/usr/bin/gfortran           -m64 -c -o vertical_mix.fppized.o -g -fconvert=big-endian -fopenmp vertical_mix.fppized.f90
/usr/bin/gfortran           -m64 -c -o hmix_gm.fppized.o -g -fconvert=big-endian -fopenmp hmix_gm.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mix_submeso.F90 -o mix_submeso.fppized.f90
/usr/bin/gfortran           -m64 -c -o mix_submeso.fppized.o -g -fconvert=big-endian -fopenmp mix_submeso.fppized.f90
/usr/bin/gfortran           -m64 -c -o horizontal_mix.fppized.o -g -fconvert=big-endian -fopenmp horizontal_mix.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 pressure_grad.F90 -o pressure_grad.fppized.f90
/usr/bin/gfortran           -m64 -c -o pressure_grad.fppized.o -g -fconvert=big-endian -fopenmp pressure_grad.fppized.f90
/usr/bin/gfortran           -m64 -c -o baroclinic.fppized.o -g -fconvert=big-endian -fopenmp baroclinic.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 barotropic.F90 -o barotropic.fppized.f90
/usr/bin/gfortran           -m64 -c -o barotropic.fppized.o -g -fconvert=big-endian -fopenmp barotropic.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 budget_diagnostics.F90 -o budget_diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 qflux_mod.F90 -o qflux_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o qflux_mod.fppized.o -g -fconvert=big-endian -fopenmp qflux_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o budget_diagnostics.fppized.o -g -fconvert=big-endian -fopenmp budget_diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 output.F90 -o output.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 history.F90 -o history.fppized.f90
/usr/bin/gfortran           -m64 -c -o history.fppized.o -g -fconvert=big-endian -fopenmp history.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 restart.F90 -o restart.fppized.f90
/usr/bin/gfortran           -m64 -c -o restart.fppized.o -g -fconvert=big-endian -fopenmp restart.fppized.f90
/usr/bin/gfortran           -m64 -c -o output.fppized.o -g -fconvert=big-endian -fopenmp output.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 step_mod.F90 -o step_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 surface_hgt.F90 -o surface_hgt.fppized.f90
/usr/bin/gfortran           -m64 -c -o surface_hgt.fppized.o -g -fconvert=big-endian -fopenmp surface_hgt.fppized.f90
/usr/bin/gfortran           -m64 -c -o step_mod.fppized.o -g -fconvert=big-endian -fopenmp step_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o initial.fppized.o -g -fconvert=big-endian -fopenmp initial.fppized.f90
/usr/bin/gfortran           -m64 -c -o POP_InitMod.fppized.o -g -fconvert=big-endian -fopenmp POP_InitMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 cfc11_mod.F90 -o cfc11_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o cfc11_mod.fppized.o -g -fconvert=big-endian -fopenmp cfc11_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 check_mod.F90 -o check_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o check_mod.fppized.o -g -fconvert=big-endian -fopenmp check_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 current_meters.F90 -o current_meters.fppized.f90
/usr/bin/gfortran           -m64 -c -o current_meters.fppized.o -g -fconvert=big-endian -fopenmp current_meters.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 drifters.F90 -o drifters.fppized.f90
/usr/bin/gfortran           -m64 -c -o drifters.fppized.o -g -fconvert=big-endian -fopenmp drifters.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 hydro_sections.F90 -o hydro_sections.fppized.f90
/usr/bin/gfortran           -m64 -c -o hydro_sections.fppized.o -g -fconvert=big-endian -fopenmp hydro_sections.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 msg_mod.F90 -o msg_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o msg_mod.fppized.o -g -fconvert=big-endian -fopenmp msg_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ocn_comp_mct.F90 -o ocn_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o ocn_comp_mct.fppized.o -g -fconvert=big-endian -fopenmp ocn_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 tracer_types.F90 -o tracer_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o tracer_types.fppized.o -g -fconvert=big-endian -fopenmp tracer_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 glc_comp_mct.F90 -o glc_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o glc_comp_mct.fppized.o -g -fconvert=big-endian -fopenmp glc_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 ccsm_driver.F90 -o ccsm_driver.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_atmatm_mct.F90 -o map_atmatm_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_rearr_mod.F90 -o seq_rearr_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_diag_mct.F90 -o seq_diag_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_diag_mct.fppized.o -g -fconvert=big-endian -fopenmp seq_diag_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_rearr_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_rearr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmatm_mct.fppized.o -g -fconvert=big-endian -fopenmp map_atmatm_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_atmice_mct.F90 -o map_atmice_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmice_mct.fppized.o -g -fconvert=big-endian -fopenmp map_atmice_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_atmlnd_mct.F90 -o map_atmlnd_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmlnd_mct.fppized.o -g -fconvert=big-endian -fopenmp map_atmlnd_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_atmocn_mct.F90 -o map_atmocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmocn_mct.fppized.o -g -fconvert=big-endian -fopenmp map_atmocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_glcglc_mct.F90 -o map_glcglc_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_glcglc_mct.fppized.o -g -fconvert=big-endian -fopenmp map_glcglc_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_iceice_mct.F90 -o map_iceice_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_iceice_mct.fppized.o -g -fconvert=big-endian -fopenmp map_iceice_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_iceocn_mct.F90 -o map_iceocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_iceocn_mct.fppized.o -g -fconvert=big-endian -fopenmp map_iceocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_lndlnd_mct.F90 -o map_lndlnd_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_lndlnd_mct.fppized.o -g -fconvert=big-endian -fopenmp map_lndlnd_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_ocnocn_mct.F90 -o map_ocnocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_ocnocn_mct.fppized.o -g -fconvert=big-endian -fopenmp map_ocnocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_rofocn_mct.F90 -o map_rofocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_rofocn_mct.fppized.o -g -fconvert=big-endian -fopenmp map_rofocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_rofrof_mct.F90 -o map_rofrof_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_rofrof_mct.fppized.o -g -fconvert=big-endian -fopenmp map_rofrof_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_snoglc_mct.F90 -o map_snoglc_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_snoglc_mct.fppized.o -g -fconvert=big-endian -fopenmp map_snoglc_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 map_snosno_mct.F90 -o map_snosno_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_snosno_mct.fppized.o -g -fconvert=big-endian -fopenmp map_snosno_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2a_mct.F90 -o mrg_x2a_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2a_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2a_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2g_mct.F90 -o mrg_x2g_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2g_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2g_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2i_mct.F90 -o mrg_x2i_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2i_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2i_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2l_mct.F90 -o mrg_x2l_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2l_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2l_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2o_mct.F90 -o mrg_x2o_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2o_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2o_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 mrg_x2s_mct.F90 -o mrg_x2s_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2s_mct.fppized.o -g -fconvert=big-endian -fopenmp mrg_x2s_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_avdata_mod.F90 -o seq_avdata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_avdata_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_avdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_domain_mct.F90 -o seq_domain_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_domain_mct.fppized.o -g -fconvert=big-endian -fopenmp seq_domain_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_flux_mct.F90 -o seq_flux_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flux_mct.fppized.o -g -fconvert=big-endian -fopenmp seq_flux_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_frac_mct.F90 -o seq_frac_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_frac_mct.fppized.o -g -fconvert=big-endian -fopenmp seq_frac_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_hist_mod.F90 -o seq_hist_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_hist_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_hist_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -w -I. -Inetcdf/include -D_MPISERIAL -D_NETCDF -D_USEBOX -DCCSMCOUPLED=1 -DNO_SHR_VMATH -DBLCKX=50 -DBLCKY=4 -DMXBLCKS=58 -DNO_GETTIMEOFDAY -DSPEC_AUTO_BYTEORDER=0x12345678 -DSPEC_CASE_FLAG -DSPEC_OPENMP -DSPEC_LP64 seq_rest_mod.F90 -o seq_rest_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_rest_mod.fppized.o -g -fconvert=big-endian -fopenmp seq_rest_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ccsm_driver.fppized.o -g -fconvert=big-endian -fopenmp ccsm_driver.fppized.f90
/usr/bin/gfortran           -m64      -g     -DSPEC_CASE_FLAG -fconvert=big-endian   -fopenmp -DSPEC_OPENMP  netcdf/attr.o netcdf/dim.o netcdf/error.o netcdf/fort-attio.o netcdf/fort-control.o netcdf/fort-dim.o netcdf/fort-genatt.o netcdf/fort-geninq.o netcdf/fort-genvar.o netcdf/fort-lib.o netcdf/fort-misc.o netcdf/fort-v2compat.o netcdf/fort-var1io.o netcdf/fort-varaio.o netcdf/fort-vario.o netcdf/fort-varmio.o netcdf/fort-varsio.o netcdf/libvers.o netcdf/nc.o netcdf/ncx.o netcdf/posixio.o netcdf/putget.o netcdf/string.o netcdf/v1hpg.o netcdf/v2i.o netcdf/var.o netcdf/netcdf.o netcdf/typeSizes.o fort.fppized.o mpi.o send.o recv.o collective.o req.o list.o handles.o comm.o group.o time.o pack.o m_IndexBin_char.fppized.o m_IndexBin_integer.fppized.o m_IndexBin_logical.fppized.o m_List.fppized.o m_MergeSorts.fppized.o m_Filename.fppized.o m_FcComms.fppized.o m_Permuter.fppized.o m_SortingTools.fppized.o m_String.fppized.o m_StrTemplate.fppized.o m_chars.fppized.o m_die.fppized.o m_dropdead.fppized.o m_FileResolv.fppized.o m_flow.fppized.o m_inpak90.fppized.o m_ioutil.fppized.o m_mall.fppized.o m_mpif.fppized.o m_mpif90.fppized.o m_mpout.fppized.o m_rankMerge.fppized.o m_realkinds.fppized.o m_stdio.fppized.o m_TraceBack.fppized.o m_zeit.fppized.o get_zeits.o m_MCTWorld.fppized.o m_AttrVect.fppized.o m_GlobalMap.fppized.o m_GlobalSegMap.fppized.o m_GlobalSegMapComms.fppized.o m_Accumulator.fppized.o m_SparseMatrix.fppized.o m_Navigator.fppized.o m_AttrVectComms.fppized.o m_AttrVectReduce.fppized.o m_AccumulatorComms.fppized.o m_GeneralGrid.fppized.o m_GeneralGridComms.fppized.o m_SpatialIntegral.fppized.o m_SpatialIntegralV.fppized.o m_MatAttrVectMul.fppized.o m_Merge.fppized.o m_GlobalToLocal.fppized.o m_ExchangeMaps.fppized.o m_ConvertMaps.fppized.o m_SparseMatrixDecomp.fppized.o m_SparseMatrixToMaps.fppized.o m_SparseMatrixComms.fppized.o m_SparseMatrixPlus.fppized.o m_Router.fppized.o m_Rearranger.fppized.o m_Transfer.fppized.o alloc_mod.fppized.o box_rearrange.fppized.o iompi_mod.fppized.o ionf_mod.fppized.o mct_rearrange.fppized.o nf_mod.fppized.o piodarray.fppized.o pio.fppized.o pio_kinds.fppized.o piolib_mod.fppized.o pio_mpi_utils.fppized.o pionfatt_mod.fppized.o pionfget_mod.fppized.o pionfput_mod.fppized.o pionfread_mod.fppized.o pio_nf_utils.fppized.o pionfwrite_mod.fppized.o pio_quicksort.fppized.o pio_spmd_utils.fppized.o pio_support.fppized.o pio_types.fppized.o pio_utils.fppized.o pnetcdfversion.o rearrange.fppized.o topology.o dead_data_mod.fppized.o dead_mct_mod.fppized.o dead_mod.fppized.o ESMF_AlarmClockMod.fppized.o ESMF_AlarmMod.fppized.o ESMF_BaseMod.fppized.o ESMF_BaseTimeMod.fppized.o ESMF_CalendarMod.fppized.o ESMF_ClockMod.fppized.o ESMF_FractionMod.fppized.o ESMF_Mod.fppized.o ESMF_Stubs.fppized.o ESMF_TimeIntervalMod.fppized.o ESMF_TimeMod.fppized.o f_wrappers.o GPTLget_memusage.o GPTLprint_memusage.o GPTLutil.o mct_mod.fppized.o Meat.fppized.o perf_mod.fppized.o perf_utils.fppized.o seq_cdata_mod.fppized.o seq_comm_mct.fppized.o seq_drydep_mod.fppized.o seq_flds_indices.fppized.o seq_flds_mod.fppized.o seq_infodata_mod.fppized.o seq_io_mod.fppized.o seq_timemgr_mod.fppized.o shr_cal_mod.fppized.o shr_const_mod.fppized.o shr_dmodel_mod.fppized.o shr_file_mod.fppized.o shr_flux_mod.fppized.o shr_jlcp.o shr_kind_mod.fppized.o shr_log_mod.fppized.o shr_map_mod.fppized.o shr_mct_mod.fppized.o shr_mem_mod.fppized.o shr_mpi_mod.fppized.o shr_msg_mod.fppized.o shr_ncread_mod.fppized.o shr_orb_mod.fppized.o shr_pcdf_mod.fppized.o shr_scam_mod.fppized.o shr_strdata_mod.fppized.o shr_stream_mod.fppized.o shr_string_mod.fppized.o shr_sys_mod.fppized.o shr_timer_mod.fppized.o shr_tInterp_mod.fppized.o shr_vmath_fwrap.o shr_vmath_mod.fppized.o threadutil.o wrf_error_fatal.fppized.o wrf_message.fppized.o atm_comp_mct.fppized.o datm_comp_mod.fppized.o datm_shr_mod.fppized.o dlnd_comp_mod.fppized.o lnd_comp_mct.fppized.o dice_comp_mod.fppized.o ice_comp_mct.fppized.o POP_BlocksMod.fppized.o POP_BroadcastMod.fppized.o POP_CommMod.fppized.o POP_ConfigMod.fppized.o POP_ConstantsMod.fppized.o POP_DistributionMod.fppized.o POP_DomainSizeMod.fppized.o POP_ErrorMod.fppized.o POP_FieldMod.fppized.o POP_FinalMod.fppized.o POP_GridDimMod.fppized.o POP_GridHorzMod.fppized.o POP_GridVertMod.fppized.o POP_HaloMod.fppized.o POP_IOUnitsMod.fppized.o POP_InitMod.fppized.o POP_KindsMod.fppized.o POP_MCT_vars_mod.fppized.o POP_RedistributeMod.fppized.o POP_ReductionsMod.fppized.o POP_SolversMod.fppized.o advection.fppized.o baroclinic.fppized.o barotropic.fppized.o blocks.fppized.o broadcast.fppized.o budget_diagnostics.fppized.o cfc11_mod.fppized.o cfc_mod.fppized.o check_mod.fppized.o co2calc.fppized.o communicate.fppized.o constants.fppized.o current_meters.fppized.o diag_bsf.fppized.o diagnostics.fppized.o diags_on_lat_aux_grid.fppized.o distribution.fppized.o domain.fppized.o domain_size.fppized.o drifters.fppized.o ecosys_mod.fppized.o ecosys_parms.fppized.o exit_mod.fppized.o forcing.fppized.o forcing_ap.fppized.o forcing_coupled.fppized.o forcing_fields.fppized.o forcing_pt_interior.fppized.o forcing_s_interior.fppized.o forcing_sfwf.fppized.o forcing_shf.fppized.o forcing_tools.fppized.o forcing_ws.fppized.o gather_scatter.fppized.o global_reductions.fppized.o grid.fppized.o history.fppized.o hmix_aniso.fppized.o hmix_del2.fppized.o hmix_del4.fppized.o hmix_gm.fppized.o hmix_gm_submeso_share.fppized.o horizontal_mix.fppized.o hydro_sections.fppized.o iage_mod.fppized.o ice.fppized.o initial.fppized.o io.fppized.o io_binary.fppized.o io_ccsm.fppized.o io_netcdf.fppized.o io_pio.fppized.o io_tools.fppized.o io_types.fppized.o kinds_mod.fppized.o mix_submeso.fppized.o movie.fppized.o ms_balance.fppized.o msg_mod.fppized.o named_field_mod.fppized.o ocn_communicator.fppized.o ocn_comp_mct.fppized.o operators.fppized.o output.fppized.o overflows.fppized.o passive_tracer_tools.fppized.o passive_tracers.fppized.o pressure_grad.fppized.o prognostic.fppized.o qflux_mod.fppized.o registry.fppized.o restart.fppized.o spacecurve_mod.fppized.o state_mod.fppized.o step_mod.fppized.o surface_hgt.fppized.o sw_absorption.fppized.o tavg.fppized.o tidal_mixing.fppized.o time_management.fppized.o timers.fppized.o topostress.fppized.o tracer_types.fppized.o vertical_mix.fppized.o vmix_const.fppized.o vmix_kpp.fppized.o vmix_rich.fppized.o glc_comp_mct.fppized.o ccsm_driver.fppized.o map_atmatm_mct.fppized.o map_atmice_mct.fppized.o map_atmlnd_mct.fppized.o map_atmocn_mct.fppized.o map_glcglc_mct.fppized.o map_iceice_mct.fppized.o map_iceocn_mct.fppized.o map_lndlnd_mct.fppized.o map_ocnocn_mct.fppized.o map_rofocn_mct.fppized.o map_rofrof_mct.fppized.o map_snoglc_mct.fppized.o map_snosno_mct.fppized.o mrg_x2a_mct.fppized.o mrg_x2g_mct.fppized.o mrg_x2i_mct.fppized.o mrg_x2l_mct.fppized.o mrg_x2o_mct.fppized.o mrg_x2s_mct.fppized.o seq_avdata_mod.fppized.o seq_diag_mct.fppized.o seq_domain_mct.fppized.o seq_flux_mct.fppized.o seq_frac_mct.fppized.o seq_hist_mod.fppized.o seq_rearr_mod.fppized.o seq_rest_mod.fppized.o                      -o speed_pop2  
