#include "configbase.h"
#include "povms.h"

#include "base/thread.h"

#include <stdlib.h>

POVMS_SPEC_QueueNode *POVMS_SPEC_QueueOpen()
{
	POVMS_SPEC_QueueNode *ptr = (POVMS_SPEC_QueueNode *)malloc(sizeof(POVMS_SPEC_QueueNode));

	if(ptr == NULL)
		return NULL;

	ptr->magic = 0x12345678;
	ptr->entries = 0;
	ptr->first = NULL;
	ptr->last = NULL;
	ptr->mutex = new pov_base::Mutex;

	return (POVMS_SPEC_QueueNode *)ptr;
}

void POVMS_SPEC_QueueClose(POVMS_SPEC_QueueNode *q)
{
	POVMS_SPEC_QueueNode *ptr = (POVMS_SPEC_QueueNode *)q;

	if(ptr != NULL)
	{
		pov_base::Mutex::ScopedLock lock(*(ptr->mutex));

		if(ptr->entries > 0)
		{
			POVMS_SPEC_QueueDataNode *node = ptr->first;
			POVMS_SPEC_QueueDataNode *nextnode = NULL;

			while(node != NULL)
			{
				nextnode = node->next;
				free(node);
				node = nextnode;
			}
		}

		free(ptr);
	}

	delete ptr->mutex;
	ptr->mutex = NULL;
}

void *POVMS_SPEC_QueueReceive(POVMS_SPEC_QueueNode *q, int *l, bool, bool)
{
	POVMS_SPEC_QueueNode *ptr = (POVMS_SPEC_QueueNode *)q;
	POVMS_SPEC_QueueDataNode *node = NULL;
	void *d = NULL;
	pov_base::Mutex::ScopedLock lock(*(ptr->mutex));

	if(l == NULL)
		return NULL;

	*l = 0;

	if(ptr == NULL)
		return NULL;

	if(ptr->magic != 0x12345678)
		return NULL;

	if(ptr->entries <= 0)
		return NULL;

	if(ptr->first == NULL)
		return NULL;

	node = ptr->first;

	d = node->data;
	*l = node->len;

	if(node == ptr->last)
		ptr->last = NULL;

	ptr->first = node->next;

	ptr->entries--;

	free(node);

	return d;
}

int POVMS_SPEC_QueueSend(POVMS_SPEC_QueueNode *q, void *p, int l)
{
	POVMS_SPEC_QueueNode *ptr = (POVMS_SPEC_QueueNode *)q;
	POVMS_SPEC_QueueDataNode *node = NULL;
	pov_base::Mutex::ScopedLock lock(*(ptr->mutex));

	if(ptr == NULL)
		return -1;

	if(ptr->magic != 0x12345678)
		return -2;

	node = (POVMS_SPEC_QueueDataNode *)malloc(sizeof(POVMS_SPEC_QueueDataNode));
	if(node == NULL)
		return -3;

	node->data = p;
	node->len = l;

	node->next = NULL;
	if(ptr->last != NULL)
		ptr->last->next = node;
	if(ptr->first == NULL)
		ptr->first = node;
	ptr->last = node;

	ptr->entries++;

	return 0;
}

int POVMS_SPEC_AddressFromStream(POVMSAddress *a, POVMSStream *s, int z)
{
	POVMSStream *b = s;
	int i;

	// default value in case decoding fails
	*a = POVMSInvalidAddress;

	// system specific address (byte code 1)
	if((z >= (2 + sizeof(POVMSAddress))) && (*s == 1))
	{
		s++;
		if(*s == sizeof(POVMSAddress))
		{
			s++;
			for(i = 0; i < sizeof(POVMSAddress); i++)
				((POVMSStream *)a)[i] = s[i];
			s += sizeof(POVMSAddress);
		}

		z -= (s - b);
	}
	else if((z >= 2) && (*s == 1))
	{
		// skip over unknown system specific address size
		s += *s;
		z -= (s - b);
	}

	// IPv4 address and TCP port (byte code 4)
	if((z >= 7) && (*s == 4))
	{
		// skip
		s += 7;
		z -= 7;
	}

	// IPv6 address and TCP port (byte code 6)
	if((z >= 11) && (*s == 6))
	{
		// skip
		s += 11;
		z -= 11;
	}

	// skip over the remaining data
	s += z;

	// return that everything has been read
	return (s - b);
}

int POVMS_SPEC_AddressToStream(POVMSAddress a, POVMSStream *s, int *z)
{
	int i;

	// check if there is enough space (there should always be)
	if(*z < (2 + sizeof(POVMSAddress)))
		return 0;

	// write system specific address
	*s = 1;
	s++;
	*s = sizeof(POVMSAddress);
	s++;
	for(i = 0; i < sizeof(POVMSAddress); i++)
		s[i] = ((POVMSStream *)(&a))[i];
	s += sizeof(POVMSAddress);

	// substract size written
	*z -= (2 + sizeof(POVMSAddress));

	// return size written
	return (2 + sizeof(POVMSAddress));
}

int POVMS_SPEC_AddressToStreamSize(POVMSAddress)
{
	// default implementation only supports writing system specific address
	return (2 + sizeof(POVMSAddress));
}
