/*******************************************************************************
 * boundingtask.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/bounding/boundingtask.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_BOUNDINGTASK_H
#define POVRAY_BACKEND_BOUNDINGTASK_H

#include <vector>

#include "backend/frame.h"
#include "backend/povray.h"
#include "backend/scene/view.h"
#include "backend/scene/scene.h"
#include "backend/render/rendertask.h"
#include "backend/render/trace.h"
#include "backend/support/bsptree.h"
#include "backend/support/taskqueue.h"

namespace pov
{

class BoundingTask : public Task
{
	public:
		BoundingTask(shared_ptr<SceneData> sd, unsigned int bt);
		virtual ~BoundingTask();

		virtual void Run();
		virtual void Stopped();
		virtual void Finish();

		void AppendObject(ObjectPtr p);

		inline SceneThreadData *GetSceneDataPtr() { return (SceneThreadData *)(GetDataPtr()); }
	private:
		shared_ptr<SceneData> sceneData;
		unsigned int boundingThreshold;

		void SendFatalError(pov_base::Exception& e);
};

}

#endif // POVRAY_BACKEND_BOUNDINGTASK_H
