/*******************************************************************************
 * tracetask.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision(tm) Ray Tracer version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/render/tracetask.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_TRACETASK_H
#define POVRAY_BACKEND_TRACETASK_H

#include <vector>

#include "backend/frame.h"
#include "backend/povray.h"
#include "backend/scene/view.h"
#include "backend/scene/scene.h"
#include "backend/render/rendertask.h"
#include "backend/render/tracepixel.h"

namespace pov
{

#ifdef PROFILE_INTERSECTIONS
	// NB not thread-safe (and not intended to be)
	extern POV_ULONG gIntersectionTime;
	extern vector <vector<POV_ULONG> > gBSPIntersectionTimes;
	extern vector <vector<POV_ULONG> > gBVHIntersectionTimes;
	extern vector <vector<POV_ULONG> > *gIntersectionTimes;
#endif

class TraceTask : public RenderTask
{
	public:
		TraceTask(ViewData *vd, unsigned int tm, DBL js, DBL aat, unsigned int aad, GammaCurvePtr& aag, unsigned int ps, bool psc, bool final, bool hr);
		virtual ~TraceTask();

		virtual void Run();
		virtual void Stopped();
		virtual void Finish();
	private:
		class CooperateFunction : public Trace::CooperateFunctor
		{
			public:
				CooperateFunction(Task& t) : task(t) { }
				virtual void operator()() { task.Cooperate(); }
			private:
				Task& task;
		};

		class SubdivisionBuffer
		{
			public:
				SubdivisionBuffer(size_t s);

				void SetSample(size_t x, size_t y, const Colour& col);
				bool Sampled(size_t x, size_t y);

				Colour& operator()(size_t x, size_t y);

				void Clear();
			private:
				vector<Colour> colors;
				vector<bool> sampled;
				size_t size;
		};

		unsigned int tracingMethod;
		DBL jitterScale;
		DBL aaThreshold;
		unsigned int aaDepth;
		unsigned int previewSize;
		bool previewSkipCorner;
		bool finalTrace;
        bool highReproducibility;
        GammaCurvePtr aaGamma;

		/// tracing core
		TracePixel trace;

		CooperateFunction cooperate;
		MediaFunction media;
		RadiosityFunction radiosity;
		PhotonGatherer photonGatherer;

		void SimpleSamplingM0();
		void SimpleSamplingM0P();
		void NonAdaptiveSupersamplingM1();
		void AdaptiveSupersamplingM2();

		void NonAdaptiveSupersamplingForOnePixel(DBL x, DBL y, Colour& leftcol, Colour& topcol, Colour& curcol, bool& sampleleft, bool& sampletop, bool& samplecurrent);
		void SupersampleOnePixel(DBL x, DBL y, Colour& col);
		void SubdivideOnePixel(DBL x, DBL y, DBL d, size_t bx, size_t by, size_t bstep, SubdivisionBuffer& buffer, Colour& result, int level);
};

}

#endif // POVRAY_BACKEND_TRACETASK_H
