/*******************************************************************************
 * fpmetric.h
 *
 * This module contains all defines, typedefs, and prototypes for fpmetric.cpp.
 *
 * This module was written by D.Skarda&T.Bily and modified by R.Suzuki.
 * Ported to POV-Ray 3.5 by Thorsten Froehlich.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/shape/fpmetric.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef FPMETRIC_H
#define FPMETRIC_H

#include "backend/parser/parse.h"

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define PARAMETRIC_OBJECT        (PATCH_OBJECT) 



/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct PrecompParValues_Struct PRECOMP_PAR_DATA; 

struct PrecompParValues_Struct 
{
	int use, depth;
	char flags;
	DBL *Low[3], *Hi[3];     /*  X,Y,Z  */
};

class Parametric : public ObjectBase
{
	public:
		FunctionVM *vm;
		FUNCTION_PTR Function[3];
		DBL umin, umax, vmin, vmax;
		DBL accuracy;
		DBL max_gradient;
		int Inverted; 

		int container_shape;
		union
		{
			struct
			{
				VECTOR center;
				DBL radius;
			} sphere;
			struct
			{
				VECTOR corner1;
				VECTOR corner2;
			} box;
		} container;

		Parametric();
		virtual ~Parametric();

		virtual ObjectPtr Copy();

		virtual bool All_Intersections(const Ray&, IStack&, TraceThreadData *);
		virtual bool Inside(const VECTOR, TraceThreadData *) const;
		virtual void Normal(VECTOR, Intersection *, TraceThreadData *) const;
		virtual void UVCoord(UV_VECT, const Intersection *, TraceThreadData *) const;
		virtual void Translate(const VECTOR, const TRANSFORM *);
		virtual void Rotate(const VECTOR, const TRANSFORM *);
		virtual void Scale(const VECTOR, const TRANSFORM *);
		virtual void Transform(const TRANSFORM *);
		virtual void Invert();
		virtual void Compute_BBox();

		void Precompute_Parametric_Values(char flags, int depth, FPUContext *ctx);
	protected:
		void Precomp_Par_Int(int depth, DBL umin, DBL vmin, DBL umax, DBL vmax, FPUContext *ctx);
		PRECOMP_PAR_DATA *Copy_PrecompParVal();
		void Destroy_PrecompParVal();

		static inline DBL Evaluate_Function_UV(FPUContext *ctx, FUNCTION funct, const UV_VECT fnvec);
		static inline void Evaluate_Function_Interval_UV(FPUContext *ctx, FUNCTION funct, DBL threshold, const UV_VECT fnvec_low, const UV_VECT fnvec_hi, DBL max_gradient, DBL& low, DBL& hi);
		static void Interval(DBL dx, DBL a, DBL b, DBL max_gradient, DBL *Min, DBL *Max);
	private:
		PRECOMP_PAR_DATA *PData;
		int PrecompLastDepth;
};

}

#endif
