/*******************************************************************************
 * prism.h
 *
 * This module contains all defines, typedefs, and prototypes for PRISM.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/shape/prism.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef PRISM_H
#define PRISM_H

namespace pov
{

/*****************************************************************************
* Global preprocessor definitions
******************************************************************************/

#define PRISM_OBJECT (STURM_OK_OBJECT)

#define LINEAR_SPLINE    1
#define QUADRATIC_SPLINE 2
#define CUBIC_SPLINE     3
#define BEZIER_SPLINE    4

#define LINEAR_SWEEP 1
#define CONIC_SWEEP  2

/* Generate additional prism statistics. */

#define PRISM_EXTRA_STATS 1



/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct Prism_Spline_Struct PRISM_SPLINE;
typedef struct Prism_Spline_Entry_Struct PRISM_SPLINE_ENTRY;

struct Prism_Spline_Entry_Struct
{
  DBL x1, y1, x2, y2;  /* Min./Max. coordinates of segment   */
  DBL v1, u2, v2;      /* Min./Max. coordinates of segment in <u,v>, u1 not needed  */
  UV_VECT A, B, C, D;  /* Coefficients of segment            */
};

struct Prism_Spline_Struct
{
  int References;
  PRISM_SPLINE_ENTRY *Entry;
};

class Prism : public ObjectBase
{
	public:
		int Number;
		int Spline_Type;          /* Spline type (linear, quadratic ...)        */
		int Sweep_Type;           /* Sweep type (linear, conic)                 */
		DBL Height1, Height2;
		DBL x1, y1, x2, y2;       /* Overall bounding rectangle of spline curve */
		PRISM_SPLINE *Spline;     /* Pointer to array of splines                */
		DBL u1, v1, u2, v2;       /* Overall <u,v> bounding rectangle of spline */

		Prism();
		virtual ~Prism();

		virtual ObjectPtr Copy();

		virtual bool All_Intersections(const Ray&, IStack&, TraceThreadData *);
		virtual bool Inside(const VECTOR, TraceThreadData *) const;
		virtual void Normal(VECTOR, Intersection *, TraceThreadData *) const;
		virtual void Translate(const VECTOR, const TRANSFORM *);
		virtual void Rotate(const VECTOR, const TRANSFORM *);
		virtual void Scale(const VECTOR, const TRANSFORM *);
		virtual void Transform(const TRANSFORM *);
		virtual void Invert();
		virtual void Compute_BBox();

		void Compute_Prism(UV_VECT *P, TraceThreadData *Thread);
	protected:
		int in_curve(DBL u, DBL v, TraceThreadData *Thread) const;
		static bool test_rectangle(const VECTOR P, const VECTOR D, DBL x1, DBL y1, DBL x2, DBL y2);
};

}

#endif
