/*******************************************************************************
 * quadrics.h
 *
 * This module contains all defines, typedefs, and prototypes for QUADRICS.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/shape/quadrics.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef QUADRICS_H
#define QUADRICS_H

#include "planes.h"

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define QUADRIC_OBJECT (BASIC_OBJECT)



/*****************************************************************************
* Global typedefs
******************************************************************************/

class Quadric : public ObjectBase
{
	public:
		VECTOR Square_Terms;
		VECTOR Mixed_Terms;
		VECTOR Terms;
		DBL Constant;
		bool Automatic_Bounds;

		Quadric();
		virtual ~Quadric();

		virtual ObjectPtr Copy();

		virtual bool All_Intersections(const Ray&, IStack&, TraceThreadData *);
		virtual bool Inside(const VECTOR, TraceThreadData *) const;
		virtual void Normal(VECTOR, Intersection *, TraceThreadData *) const;
		virtual void Translate(const VECTOR, const TRANSFORM *);
		virtual void Rotate(const VECTOR, const TRANSFORM *);
		virtual void Scale(const VECTOR, const TRANSFORM *);
		virtual void Transform(const TRANSFORM *);
		virtual void Invert();
		virtual void Compute_BBox();

		static void Compute_Plane_Min_Max(Plane *plane, VECTOR Min, VECTOR Max);
		void Compute_BBox(VECTOR ClipMin, VECTOR  ClipMax);
	protected:
		bool Intersect(const Ray& ray, DBL *Depth1, DBL *Depth2) const;
		void Quadric_To_Matrix(MATRIX Matrix) const;
		void Matrix_To_Quadric(const MATRIX Matrix);
};

}

#endif
