/*******************************************************************************
 * imageutil.h
 *
 * This module contains all defines, typedefs, and prototypes for imageutil.cpp.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/support/imageutil.h $
 * $Revision: #3 $
 * $Change: 5050 $
 * $DateTime: 2010/06/30 12:23:03 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef IMAGE_H
#define IMAGE_H

#include "base/image/image.h"

namespace pov
{

using namespace pov_base;

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

// Image/Bump Map projection types. 

enum
{
	PLANAR_MAP       = 0,
	SPHERICAL_MAP    = 1,
	CYLINDRICAL_MAP  = 2,
	PARABOLIC_MAP    = 3,
	HYPERBOLIC_MAP   = 4,
	TORUS_MAP        = 5,
	PIRIFORM_MAP     = 6,
	OLD_MAP          = 7
};

// Bit map interpolation types. 

enum
{
	// NO_INTERPOLATION = 0, // already in pattern.h
	NEAREST_NEIGHBOR = 1, // currently not supported; would be essentially the same as NO_INTERPOLATION
	BILINEAR         = 2,
	BICUBIC          = 3,
	NORMALIZED_DIST  = 4
};

enum
{
	USE_NONE         = 0,
	USE_COLOUR       = 1,
	USE_INDEX        = 2,
	USE_ALPHA        = 3
};

class ImageData
{
	public:
		int References; // Keeps track of number of pointers to this structure 
		int Map_Type;
		int Interpolation_Type;
		bool Once_Flag;
		char Use;
		VECTOR Gradient;
		int iwidth, iheight;
		SNGL width, height;
		UV_VECT Offset;
		DBL AllFilter, AllTransmit; 
		void *Object;
		Image *data;
};

class Parser;
class SceneData;

DBL image_pattern(const VECTOR EPoint, const TPATTERN *TPattern);
bool image_map(const VECTOR EPoint, const PIGMENT *Pigment, Colour& colour);
TEXTURE *material_map(const VECTOR IPoint, const TEXTURE *Texture);
void bump_map(const VECTOR EPoint, const TNORMAL *Tnormal, VECTOR normal);
HF_VAL image_height_at(const ImageData *image, int x, int y);
bool is_image_opaque(const ImageData *image);
ImageData *Copy_Image(ImageData *old);
ImageData *Create_Image(void);
void Destroy_Image(ImageData *image);
Image *Read_Image(Parser *p, shared_ptr<SceneData>& sd, int filetype, const UCS2 *filename, const Image::ReadOptions& options);

}

#endif
