/*******************************************************************************
 * configbase.h
 *
 * This header file defines all types that can be configured by platform
 * specific code for base-layer use. It further allows insertion of platform
 * specific function prototypes making use of those types.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/base/configbase.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef CONFIGBASE_H
#define CONFIGBASE_H

#include "syspovconfigbase.h"

#ifndef DBL
	#define DBL double
#endif

#ifndef SNGL
	#define SNGL float
#endif

#ifndef COLC
	#define COLC float
#endif

#ifndef UCS2
	#define UCS2 unsigned short
#endif

#ifndef UCS4
	#define UCS4 unsigned int
#endif

#ifndef POV_LONG
	#define POV_LONG long long
	#define POV_ULONG unsigned long long
#endif

#ifndef POV_ULONG
	#define POV_ULONG unsigned POV_LONG
#endif

#ifndef M_PI
	#define M_PI   3.1415926535897932384626
#endif

#ifndef M_PI_2
	#define M_PI_2 1.57079632679489661923
#endif

#ifndef TWO_M_PI
	#define TWO_M_PI 6.283185307179586476925286766560
#endif

#ifndef M_PI_180
	#define M_PI_180 0.01745329251994329576
#endif

#ifndef M_PI_360
	#define M_PI_360 0.00872664625997164788
#endif

#ifndef POV_SYS_FILE_EXTENSION
	#define POV_SYS_FILE_EXTENSION ".tga"
#endif

#ifndef POV_FILE_SEPARATOR
	#define POV_FILE_SEPARATOR '/'
#endif

#ifndef POV_UCS2_FOPEN
	#define POV_UCS2_FOPEN(name, mode) fopen(UCS2toASCIIString(UCS2String(name)).c_str(), mode)
#endif

#ifndef POV_UCS2_REMOVE
	#define POV_UCS2_REMOVE(name) unlink(UCS2toASCIIString(UCS2String(name)).c_str())
#endif

#ifndef EXIST_FONT_FILE
	#define EXIST_FONT_FILE(name) (0)
#endif

#ifndef DEFAULT_ITEXTSTREAM_BUFFER_SIZE
	#define DEFAULT_ITEXTSTREAM_BUFFER_SIZE 512
#endif

#ifndef POV_ALLOW_FILE_READ
	#define POV_ALLOW_FILE_READ(f,t) (1)
#endif

#ifndef POV_ALLOW_FILE_WRITE
	#define POV_ALLOW_FILE_WRITE(f,t) (1)
#endif

#ifndef POV_TRACE_THREAD_PREINIT
	#define POV_TRACE_THREAD_PREINIT
#endif

#ifndef POV_TRACE_THREAD_POSTINIT
	#define POV_TRACE_THREAD_POSTINIT
#endif

#include "base/povms.h"
#include "base/povmscpp.h"

namespace pov_base
{

typedef POVMSUCS2String UCS2String;

inline UCS2String ASCIItoUCS2String(const char *s)
{
	return POVMS_ASCIItoUCS2String(s);
}

inline string UCS2toASCIIString(const UCS2String& s)
{
	return POVMS_UCS2toASCIIString(s);
}

}

#include "syspovprotobase.h"

#endif
