/*******************************************************************************
 * pov_err.cpp
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/base/pov_err.cpp $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

// configbase.h must always be the first POV file included within base *.cpp files
#include "base/configbase.h"
#include "base/povmscpp.h"
#include "base/pov_err.h"

// this must be the last file included
#include "base/povdebug.h"

namespace pov_base
{

const char *Exception::lookup_code(int err)
{
	switch(err)
	{
		case kParamErr:
			return "Invalid parameter.";
		case kMemFullErr:
			return "Out of memory.";
		case kInvalidDataSizeErr:
			return "Invalid data size.";
		case kCannotHandleDataErr:
			return "Cannot handle data of this type or kind.";
		case kNullPointerErr:
			return "Unexpected null pointer.";
		case kChecksumErr:
			return "Corrupted data.";
		case kParseErr:
			return "Cannot parse input.";
		case kCannotOpenFileErr:
			return "Cannot open file.";
		case kInvalidDestAddrErr:
			return "Invalid destination address.";
		case kCannotConnectErr:
			return "Cannot establish connection.";
		case kDisconnectedErr:
			return "Disconnection initiated from client.";
		case kHostDisconnectedErr:
			return "Disconnection initiated from host.";
		case kNetworkDataErr:
			return "Network data transmission failed.";
		case kNetworkConnectionErr:
			return "Network connection failed";
		case kObjectAccessErr:
			return "Cannot access object.";
		case kVersionErr:
			return "Invalid version.";
		case kFileDataErr:
			return "Cannot access data in file.";
		case kAuthorisationErr:
			return "Unauthorised access";
		case kDataTypeErr:
			return "Data type or kind does not match.";
		case kTimeoutErr:
			return "Operation timed out.";
		case kInvalidContextErr:
			return "Context is invalid.";
		case kIncompleteDataErr:
			return "Cannot handle data because it is incomplete.";
		case kInvalidIdentifierErr:
			return "Invalid identifier.";
		case kCannotHandleRequestErr:
			return "Cannot handle request.";
		case kFalseErr:
			return "Result was false but true was expected.";
		case kOutOfSyncErr:
			return "Cannot perform this operation now.";
		case kQueueFullErr:
			return "Queue is full.";
		case kUserAbortErr:
			return "Frontend halted render.";
		case kImageAlreadyRenderedErr:
			return "Image already rendered.";
		case kAccessViolationErr:
			return "Memory access violation.";
		case kDivideByZeroErr:
			return "Divide by zero.";
		case kStackOverflowErr:
			return "Stack overflow.";
		case kNativeExceptionErr:
			return "Native operating-system exception.";
		case kUncategorizedError:
			return "Uncategorized error.";
	}

	// default
	return "Unknown internal error!";
}

}
