/*******************************************************************************
 * textstream.h
 *
 * This module contains all defines, typedefs, and prototypes for the
 * C++ interface of textstream.cpp.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/base/textstream.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BASE_TEXTSTREAM_H
#define POVRAY_BASE_TEXTSTREAM_H

#include <cstdio>

// must nuke these since everyone's favourite monopoly's cstdio still defines
// them for some reason (why not just use inlines like everyone else?)
#undef  getc
#undef  putc
#undef  getchar
#undef  putchar

#include "configbase.h"

#include "base/fileinputoutput.h"
#include "base/pov_err.h"
#include "base/types.h"

namespace pov_base
{

const int ITEXTSTREAM_BUFFER_SIZE = DEFAULT_ITEXTSTREAM_BUFFER_SIZE;

class ITextStream
{
  public:
    struct FilePos
    {
      POV_LONG offset;
      POV_LONG lineno;
    };

    ITextStream(const UCS2 *, unsigned int);
    ITextStream(const UCS2 *, IStream *);
    virtual ~ITextStream();

    int getchar();
    void ungetchar(int);

    bool eof();
    bool seekg(FilePos);
    FilePos tellg();

    POV_LONG line() { return lineno; };

    const UCS2 *name() { return filename.c_str(); };
  private:
    IStream *stream;
    char buffer[ITEXTSTREAM_BUFFER_SIZE];
    POV_ULONG bufferoffset;
    POV_ULONG maxbufferoffset;
    POV_ULONG filelength;
    POV_ULONG curpos;
    UCS2String filename;
    POV_LONG lineno;
    int ungetbuffer;

    void RefillBuffer();
};

class OTextStream
{
  public:
    OTextStream(const UCS2 *, unsigned int, bool append = false);
    OTextStream(const UCS2 *, OStream *);
    virtual ~OTextStream();

    void putchar(int);
    void putraw(int);
    void printf(const char *, ...);
	void flush();

    const UCS2 *name() { return filename.c_str(); };
  private:
    OStream *stream;
    UCS2String filename;
};

}

#endif
