/*******************************************************************************
 * timer.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/base/timer.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BASE_TIMER_H
#define POVRAY_BASE_TIMER_H

#include "base/configbase.h"

#include <time.h>

namespace pov_base
{

#ifndef POV_TIMER

/// Use default time if no platform specific implementation is provided.
#define POV_TIMER TimerDefault

/**
 *  Default class for millisecond-precision timers.
 */
class TimerDefault
{
		public:
		/**
		 *  Create a new timer and start it.
		 *  @param  tctime  CPU time shall only be that consumed
		 *                  by the current thread (if supported).
		 */
		TimerDefault(bool tctime = false);
		
		/**
		 *  Destructor.
		 */
		~TimerDefault();
		
		/**
		 *  Determine elapsed real time since creation or last reset.
		 *  @return         Elapsed real time in milliseconds.
		 */
		POV_LONG ElapsedRealTime() const;
		
		/**
		 *  Determine elapsed CPU time since creation or last reset.
		 *  If not supported, return elapsed real time instead!
		 *  @return         Elapsed CPU time in milliseconds.
		 */
		POV_LONG ElapsedCPUTime() const;
		
		/**
		 *  Reset the timer.
		 */
		void Reset();
		
		/**
		 *  Determine if CPU time is supported for the current settings.
		 *  in particular this has to return false if keeping the CPU time
		 *  for the current thread is not supported but was requsted!
		 *  @return         True if the CPU time is validfor the current
		 *                  requested settings, false otherwise.
		 */
		bool HasValidCPUTime() const;
	private:
		/// thread CPU time flag
		bool threadCPUTimeOnly;
		/// real time at last reset
		clock_t realTimeStart;
		/// CPU time at last reset
		clock_t cpuTimeStart;
};
	
#endif

}

#ifdef USE_SYSPROTO
#include "syspovprotobase.h"
#endif

namespace pov_base
{

/// Millisecond-precision timer
typedef POV_TIMER Timer;

}

#endif // POVRAY_BASE_TIMER_H
