/*******************************************************************************
 * imagemessagehandler.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/frontend/imagemessagehandler.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_FRONTEND_IMAGEMESSAGEHANDLER_H
#define POVRAY_FRONTEND_IMAGEMESSAGEHANDLER_H

#include "base/types.h"

#include "frontend/configfrontend.h"
#include "frontend/renderfrontend.h"

#include <vector>
#include <list>
#include <map>

namespace pov_frontend
{

using namespace pov_base;

class ImageMessageHandler
{
	public:
		ImageMessageHandler();
		virtual ~ImageMessageHandler();

		void HandleMessage(const SceneData&, const ViewData&, POVMSType, POVMS_Object&);
	protected:
		virtual void DrawPixelSet(const SceneData&, const ViewData&, POVMS_Object&);
		virtual void DrawPixelBlockSet(const SceneData&, const ViewData&, POVMS_Object&);
		virtual void DrawPixelRowSet(const SceneData&, const ViewData&, POVMS_Object&);
		virtual void DrawRectangleFrameSet(const SceneData&, const ViewData&, POVMS_Object&);
		virtual void DrawFilledRectangleSet(const SceneData&, const ViewData&, POVMS_Object&);

		void GammaCorrect(Colour& c, COLC gf);
};

}

#endif // POVRAY_FRONTEND_IMAGEMESSAGEHANDLER_H
