//=========================================
// Pipe elements
//-----------------------------------------
// Used in "The Swing", "Atlas" and several other pictures
// -----------------------------------------
// Made for Persistence of vision 3.6
//==========================================  
// Copyright 1997-2004 Gilles Tran http://www.oyonale.com
// -----------------------------------------
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//==========================================  
#include "colors"

//=========================================
// Textures
//-----------------------------------------               
#declare C_Pipe=rgb<1,0.7,0.1>;
#declare T_Skin=texture{pigment{C_Pipe} finish{metallic brilliance 6 ambient 0.1 specular 0.8 roughness 0.05}}
#declare N_Pipe1=normal{agate 0.1}
#declare N_Pipe2=normal{bumps 0.1}
#declare T_Pipe1=texture{pigment{C_Pipe*0.8} normal{N_Pipe1} finish{metallic brilliance 7 ambient 0.1 specular 1 roughness 0.015}}
#declare T_Pipe2=texture{pigment{C_Pipe} normal{N_Pipe2} finish{metallic brilliance 6 ambient 0.1 specular 1 roughness 0.01}}
#declare T_Pipe=texture{agate texture_map{[0 T_Pipe1][0.5 T_Pipe1][1 T_Pipe2]} scale 10}

//=========================================
// Accessories
//-----------------------------------------
#declare Wheel=blob{
    threshold 0.6
    sphere{0,1.3,1 scale <1,1.2,1>}
    cylinder{0,-y*8,0.8,1}
    #declare Teta=0;
    #while (Teta<360)
            cylinder{0,x*3.4,0.4,1  rotate y*Teta}
            cylinder{0,y,0.4,1  translate x*3 rotate y*Teta}
            sphere{0,0.6,1 translate x*3 rotate y*Teta}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+6)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+12)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+18)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+24)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+30)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+36)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+42)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+48)}
            sphere{0,0.4,1 translate x*3 rotate y*(Teta+54)}
            sphere{0,0.5,1 translate x*3 rotate y*(Teta+60)}
            sphere{0,0.5,1 translate x*3 rotate y*(Teta+66)}

            #declare Teta=Teta+72;
    #end
}
#declare Eye=union{
    torus{4.5,0.5}
    difference{
            sphere{0,4.3}

            box{-5,5 scale <1,1,0.05>}
            box{-5,5 scale <1,1,0.05> translate z}
            box{-5,5 scale <1,1,0.05> translate z*2}
            box{-5,5 scale <1,1,0.05> translate z*3}
            box{-5,5 scale <1,1,0.05> translate z*4}
            box{-5,5 scale <1,1,0.05> translate -z}
            box{-5,5 scale <1,1,0.05> translate -z*2}
            box{-5,5 scale <1,1,0.05> translate -z*3}
            box{-5,5 scale <1,1,0.05> translate -z*4}
            scale <1,0.7,1>
    }

}
#declare Ring2=union{
    cylinder{-0.2*x,0.2*x,0.6}
    torus{0.55,0.05 rotate z*90 scale <2,1,1> translate -x*0.2}
    torus{0.55,0.05 rotate z*90 scale <2,1,1> translate x*0.2}
}

#declare Elbow2=intersection{torus{2,0.5} plane{z,0 inverse} plane{x,0 inverse} }

#declare Ring1=union{
    cylinder{-0.2*x,0.2*x,1.2}
    torus{1.1,0.1 rotate z*90 scale <2,1,1> translate -x*0.2}
    torus{1.1,0.1 rotate z*90 scale <2,1,1> translate x*0.2}
    union{
            #declare Teta=0;
            #while (Teta<360)
                    union{
                            sphere{0,0.1 translate <0.15,1.2,0>}
                            sphere{0,0.1 translate <-0.15,1.2,0> rotate x*10}
                            rotate x*Teta
                    }
                    #declare Teta=Teta+20;
            #end
    }
}

#declare Elbow1=intersection{torus{2,1} plane{z,0 inverse} plane{x,0 inverse} }

#declare Elbow=union{
    intersection{torus{5,1.5} plane{x,0 inverse}  plane{z,0 inverse} }
    object{Ring1 scale 1.5/1.2 translate z*5}
    object{Ring1 scale 1.5/1.2 translate z*5 rotate y*45}
    object{Ring1 rotate y*90 scale 1.5/1.2 translate x*5}
}

//=========================================
// the 7 pipe elements
//-----------------------------------------
// Pipe 1 Length=10*x
//-----------------------------------------
#declare ElPipe1=union{
    difference{
            intersection{
                    sphere{0,3 scale <2.5,1,1>}
                    plane{x,5}
                    plane{x,-5 inverse}
            }
            torus{3,0.2 rotate z*90 translate x*0.15}
            cylinder{0,6*y,0.8 rotate x*-30 translate -x*3.5}
            cylinder{0,6*y,1 rotate x*-60 translate -x*1.2}
            cylinder{0,6*y,1 rotate x*-45 translate x*1.5}
            cylinder{0,6*y,0.8 rotate x*20 translate -x*3.5}
            cylinder{0,6*y,1 rotate x*30 translate -x*1.2}
            cylinder{0,6*y,1 rotate x*65 translate x*1.5}
    }
    object{Eye scale 0.8/7 translate y*2.5 rotate x*-30 translate -x*3.5}
    torus{0.8,0.2 scale <1,2,1> translate y*2.5 rotate x*-30 translate -x*3.5}
    torus{1,0.2 scale <1,2,1> translate y*2.8 rotate x*-60 translate -x*1.2}
    object{Eye scale 1/7 translate y*2.8 rotate x*-45 translate -x*1.5}
    torus{1,0.2 scale <1,2,1> translate y*2.8 rotate x*-45 translate x*1.5}
    torus{0.8,0.2 scale <1,2,1> translate y*2.5 rotate x*20 translate -x*3.5}
    torus{1,0.2 scale <1,2,1> translate y*2.8 rotate x*30 translate -x*1.2}
    torus{1,0.2 scale <1,2,1> translate y*2.8 rotate x*65 translate x*1.5}
    torus{2,0.3 rotate z*90 translate -x*5}
    torus{2,0.3 rotate z*90 translate x*5}
    torus{3.2,0.2 rotate z*90 translate x*5.2}
    #declare Teta=0;
    #while (Teta<360)
            sphere{0,1 scale <1.5,0.3,0.1> rotate z*10 rotate x*5 translate <4,3,0> rotate x*Teta}
            sphere{0,0.2 scale <3,1,1> translate <-5,2.3,0> rotate x*Teta}
            #declare Teta=Teta+15;
    #end
    translate x*5
}

//-----------------------------------------
// Pipe 2 Length=24*x
//-----------------------------------------
#declare ElPipe2=union{
    cylinder{-x*6,x*6,2 open}
    cylinder{-x*4,-x*2,3}
    cylinder{-x*2,x*2,2.5}
    sphere{0,0.51 scale <0.5,1.5,1>*1.5 translate <1,2.5,0>}
    object{Wheel scale <0.5,1,1>*0.4 translate <1,6.5,0>}
    torus{2.5,0.2 rotate z*90 translate -x*5}
    torus{2.5,0.2 rotate z*90 translate x}
    torus{2.2,0.2 rotate z*90 translate x*6}
    torus{2.2,0.2 rotate z*90 translate -x*6}
    torus{3.2,0.21 rotate z*90 translate -x*3.4}
    torus{3.2,0.21 rotate z*90 translate -x*2.6}
    torus{2,1 rotate z*90 translate -x*4}
    torus{2,1 rotate z*90 translate -x*2}
    torus{2,0.5 rotate z*90 translate x*2}

    #declare Teta=0;
    #while (Teta<360)
            union{
                    torus{1.3,0.3 scale <0.3,1,0.2> translate <-3,0,-3>}
                    torus{1.3,0.3 scale <0.4,1,0.5> translate <-1,0,-3>}
                    cylinder{-x*6,-x*5,0.1  translate -z*2.05}
                    sphere{0,1 scale <2,0.2,0.1> rotate y*45 translate <4.3,2,0>}
                    sphere{0,1 scale <2,0.2,0.1> rotate -y*45 translate <4.3,2,0>}
                    union{
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,2.5,0>}
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,2.5,0> rotate x*10}
                            scale <0.5,1,1>
                            translate x*0.1
                    }
                    union{
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,2.5,0>}
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,2.5,0> rotate x*10}
                            scale <0.5,1,1>
                            translate x*2
                    }
                    union{
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate y*40 translate <0.3,3,0>}
                            sphere{0,0.2 scale <1.2,0.5,0.9> rotate -y*40 translate <-0.3,3,0> rotate x*10}
                            scale <0.5,1,1>
                            translate -x*4
                    }
                    cylinder{0,x*6,0.2  translate -z*2.05}
                    rotate x*Teta
            }
            #declare Teta=Teta+15;
    #end
    union{
            union{
                    object{Ring2 rotate y*90 translate <1.5,0,-4>}
                    object{Ring2 rotate x*90 translate <1.5,2,-6>}
                    object{Ring2 rotate x*90 translate <1.5,4.5,-6>}
                    object{Ring2 rotate y*90 translate <1.5,6.5,-4>}
                    object{Ring2 rotate y*90 translate <1.5,6.5,-2>}
                    object{Ring2 translate <3.5,6.5,0>}
                    object{Ring2 translate <7,6.5,0>}
                    object{Ring2 rotate x*90 translate <9,4.5,0>}
                    cylinder{0,-z*4,0.5 translate x*1.5}
                    cylinder{0,-z*3,0.7 translate x*1.5}

                    object{Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
                    object{Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
                    cylinder{0,y*2.5,0.5 translate <1.5,2,-6>}
                    cylinder{0,2*z,0.5 translate <1.5,6.5,-4>}
                    object{Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
                    cylinder{0,3.5*x,0.5 translate <3.5,6.5,0>}
                    object{Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
                    union{
                            cylinder{-4*y,4.5*y,0.5}
                            union{
                                    cylinder{-z*4,z*4,0.2}
                                    cylinder{-z*3,z*3,0.2 translate y}
                                    cylinder{-z*3,z*3,0.2 translate -y}
                                    cylinder{-z*2.5,z*2.5,0.2 translate y*2}
                                    cylinder{-z*2.5,z*2.5,0.2 translate -y*2}
                                    translate -y*0.5
                            }
                            translate 9*x
                    }
                    translate <1,0.5,0>
            }
            union{
                    object{Ring2 rotate y*90 translate <1.5,0,-4>}
                    object{Ring2 rotate x*90 translate <1.5,2,-6>}
                    object{Ring2 rotate x*90 translate <1.5,4.5,-6>}
                    object{Ring2 rotate y*90 translate <1.5,6.5,-4>}
                    object{Ring2 rotate y*90 translate <1.5,6.5,-2>}
                    object{Ring2 translate <3.5,6.5,0>}
                    object{Ring2 translate <7,6.5,0>}
                    object{Ring2 rotate x*90 translate <9,4.5,0>}
                    cylinder{0,-z*4,0.5 translate x*1.5}
                    cylinder{0,-z*3,0.7 translate x*1.5}
                    object{Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
                    object{Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
                    cylinder{0,y*2.5,0.5 translate <1.5,2,-6>}
                    cylinder{0,2*z,0.5 translate <1.5,6.5,-4>}
                    object{Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
                    cylinder{0,3.5*x,0.5 translate <3.5,6.5,0>}
                    object{Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
                    cylinder{-2*y,4.5*y,0.5 translate <9,0,0>}
                    scale <-1,1,-1>
                    translate x*10
                    translate <0,-1,-1>
            }
            scale <0.5,1,1>*0.6
            translate x*3
    }
    scale <2,1,1>
    translate x*12
}


//-----------------------------------------
// Pipe 3 Length=10*x
//-----------------------------------------
#declare ElPipe3=union{
    torus{1.5,1 rotate z*90 translate -x*5}
    cylinder{-x*5,0,2.4}
    cylinder{0,x*5,1}
    torus{2.4,0.1 rotate z*90 translate -x*0.1}
    sphere{0,2.4 scale <1/2.4,1,1>}
    torus{1,0.3 rotate z*90 translate x*5}
    #declare Teta=-90;
    #while (Teta<91)
            union{
                    box{<-5,-1,-0.3>,<-2,0.2,0.3> translate y*2.4}
                    torus{0.5,0.1 translate <-1.5,2.4,0>}
                    torus{0.5,0.1 translate <2.5,2.4,0>}
                    torus{0.5,0.1 translate <2.5,1.5,0>}
                    cylinder{0,2.4*y,0.5 translate x*2.5}
                    sphere{0,0.3 scale <1,0.6,1> translate <-4.5,2.4,0> rotate x*35}
                    sphere{0,0.3 scale <1,0.6,1> translate <-3.5,2.4,0> rotate x*25}
                    sphere{0,0.3 scale <1,0.6,1> translate <-2.5,2.4,0> rotate x*35}
                    sphere{0,0.3 scale <1,0.6,1> translate <-1.5,2.4,0> rotate x*25}
                    sphere{0,0.3 scale <1,0.6,1> translate <-0.5,2.4,0> rotate x*35}
                    intersection{
                            torus{2,0.4 rotate x*90 translate <0.5,2.4,0>}
                            plane{y,2.4 inverse}
                    }
                    rotate x*Teta
            }
            #declare Teta=Teta+60;
    #end
    translate x*5
}       

//-----------------------------------------
// Pipe 4 Length=36
//-----------------------------------------
#declare ElPipe4=union{
    torus{2,0.3 rotate z*90 translate -x*12}
    torus{1.5,0.2 rotate z*90 translate x*10}
    sphere{0,1.5 scale <0.5,1,1> translate x*10}
    cylinder{-12*x,x*10,1}
    cone{10*x,1.5,x*12,2}
    torus{2,0.2 rotate z*90 translate x*12}
    torus{2.6,0.2 rotate z*90 translate x*11}
    union{
            cylinder{-12*x,-6*x,0.15}
            cylinder{-5*x,-2*x,0.15}
            cylinder{-x,x,0.15}
            cylinder{2*x,4*x,0.15}
            cylinder{5*x,7*x,0.15}
            cylinder{8*x,10*x,0.15}
            sphere{0,0.15 translate -x*6}
            sphere{0,0.15 translate -x*5}
            sphere{0,0.15 translate -x*2}
            sphere{0,0.15 translate -x}
            sphere{0,0.15 translate x}
            sphere{0,0.15 translate x*2}
            sphere{0,0.15 translate x*4}
            sphere{0,0.15 translate x*5}
            sphere{0,0.15 translate x*7}
            sphere{0,0.15 translate x*8}
            sphere{0,0.25 translate -x*5.5}
            sphere{0,0.25 translate -x*1.5}
            sphere{0,0.25 translate x*1.5}
            sphere{0,0.25 translate x*4.5}
            sphere{0,0.25 translate x*7.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate -x*5.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 } translate -x*1.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate x*1.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 } translate x*4.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate x*7.5}
            translate -z
    }
    union{
            cylinder{-12*x,-6*x,0.15}
            cylinder{-5*x,-2*x,0.15}
            cylinder{-x,x,0.15}
            cylinder{2*x,4*x,0.15}
            cylinder{5*x,7*x,0.15}
            cylinder{8*x,10*x,0.15}
            sphere{0,0.15 translate -x*6}
            sphere{0,0.15 translate -x*5}
            sphere{0,0.15 translate -x*2}
            sphere{0,0.15 translate -x}
            sphere{0,0.15 translate x}
            sphere{0,0.15 translate x*2}
            sphere{0,0.15 translate x*4}
            sphere{0,0.15 translate x*5}
            sphere{0,0.15 translate x*7}
            sphere{0,0.15 translate x*8}
            sphere{0,0.25 translate -x*5.5}
            sphere{0,0.25 translate -x*1.5}
            sphere{0,0.25 translate x*1.5}
            sphere{0,0.25 translate x*4.5}
            sphere{0,0.25 translate x*7.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate -x*5.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 } translate -x*1.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate x*1.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 } translate x*4.5}
            intersection{torus{0.5,0.15 rotate x*90} plane{y,0 inverse} translate x*7.5}
            translate -z
            rotate x*90
    }
    object{Wheel scale 0.27 translate <-10,2,0>}
    object{Wheel scale 0.27 translate <-6,3,0>}
    object{Wheel scale 0.27 translate <-2,2.3,0>}
    object{Wheel scale 0.27 translate <2,3.1,0>}
    object{Wheel scale 0.27 translate <7,2.2,0>}
    object{Wheel scale 0.37 translate <10,4,0>}
    torus{1,0.15 rotate z*90 translate -x*10}
    torus{1,0.15 rotate z*90 translate -x*6}
    torus{1,0.15 rotate z*90 translate -x*2}
    torus{1,0.15 rotate z*90 translate x*2}
    torus{1,0.15 rotate z*90 translate x*2}
    torus{1,0.15 rotate z*90 translate x*7}
    #declare Teta=0;
    #while (Teta<360)
            union{
                    sphere{0,0.8 scale <1,0.2,0.2> rotate -z*25 translate <11.5,2.4,0>}
                    cylinder{<-12,2,0>,<-10.5,1,0>,0.1}
                    sphere{0,1 scale <1,0.1,0.1> rotate -z*25 translate <-10.5,1,0>}
                    rotate x*Teta
            }
            #declare Teta=Teta+10;
    #end
    translate x*12
    scale 1.5
}

//-----------------------------------------
// Pipe 5 Length=24*x
//-----------------------------------------
#declare ElPipe5=union{
    torus{1.5,0.3 rotate z*90 translate -x}
    cylinder{-x,x,1.5}
    superellipsoid{<0.2,0.2> scale <1.5,2,2.5> translate x*2.5}
    object{Eye scale 1.5/7 rotate -x*90 translate <2.5,0,-2.5>}
    object{Eye scale 1.5/7 rotate -x*90 translate <2.5,0,-2.5> scale <1,1,-1>}
    sphere{0,1.5 scale <0.5,1,1> translate x*4}
    sphere{0,1.5 scale <0.5,1,1> translate x*16}
    cylinder{x*4,x*16,1.2}
    torus{1.9,0.1 rotate z*90 translate x*16.5}
    cylinder{x*16.5,x*17.5,2}
    torus{1.9,0.1 rotate z*90 translate x*17.5}
    cylinder{x*17.5,x*23,1.5}
    union{
            torus{0.5,0.1}
            intersection{torus{2.5,0.5 rotate x*90} plane{y,0 inverse} plane{x,0} translate x*2.5}
            torus{0.5,0.1 translate -x*2.5 rotate z*-30 translate x*2.5 }
            torus{0.5,0.1 translate -x*2.5 rotate z*-60 translate x*2.5 }
            torus{0.5,0.1 translate -x*2.5 rotate z*-90 translate x*2.5 }
            union{
                    cylinder{0,9*x,0.5}
                            cylinder{2*x,5*x,0.7}
                    torus{0.5,0.2 rotate z*90 translate x*2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.6}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*2.9}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.5}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.8}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.1}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.4}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.7}
                    torus{0.5,0.2 rotate z*90 translate x*5}
                    torus{0.5,0.3 rotate z*90 translate x*8}
                    cone{0,0.7,x,0.9 translate x*8}
                    torus{0.9,0.2 rotate z*90 translate x*9}
                    translate <2.5,2.5,0>
            }
            translate <2.5,2,1.7>
    }
    union{
            torus{0.5,0.1}
            intersection{torus{2.5,0.5 rotate x*90} plane{y,0 inverse} plane{x,0} translate x*2.5}
            torus{0.5,0.1 translate -x*2.5 rotate z*-30 translate x*2.5 }
            torus{0.5,0.1 translate -x*2.5 rotate z*-60 translate x*2.5 }
            torus{0.5,0.1 translate -x*2.5 rotate z*-90 translate x*2.5 }
            union{
                    cylinder{0,9*x,0.5}
                    cylinder{3*x,6*x,0.7}
                    torus{0.5,0.2 rotate z*90 translate x*3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.3}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.6}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*3.9}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.2}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.5}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*4.8}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.1}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.4}
                    torus{0.7,0.2 scale <0.2,1,1> rotate z*90 translate x*5.7}
                    torus{0.5,0.2 rotate z*90 translate x*6}
                    torus{0.5,0.3 rotate z*90 translate x*8}
                    cone{0,0.7,x,0.9 translate x*8}
                    torus{0.9,0.2 rotate z*90 translate x*9}
                    translate <2.5,2.5,0>
            }
            translate <2.5,2,-1.7>
    }
    union{
            superellipsoid{<0.2,0.2> scale <1,1.3,2.6>}
            object{Eye scale 1/7 rotate -x*90 translate z*-2.6}
            object{Eye scale 1/7 rotate -x*90 translate z*2.6}
            object{Eye scale 1/7 rotate y*90 translate <0,1.3,1.7>}
            object{Eye scale 1/7 rotate y*90 translate <0,1.3,-1.7>}
            cylinder{x,x*3,1}
            torus{1,0.2 rotate z*90 translate x*3}
            intersection{torus{4.5,1 rotate x*90} plane{y,0 inverse} plane{x,0 inverse} scale <0.5,1,1> translate <3,-4.5,0>}
            torus{1,0.3 scale <0.5,4,1> translate <3+2.25,-3,0>}
            translate <15,4.5,0>
    }
    #declare Teta=0;
    #while (Teta<360)
            union{
                    box{<0,-0.1,-0.05>,<12,0.1,0.05> translate <4,1.2,0>}
                    cylinder{-x,2*x,0.1 translate y*1.5}
                    sphere{0,0.2 translate <20,1.5,0>}
                    sphere{0,0.1 translate <16.8,2,0>}
                    sphere{0,0.1 translate <17.2,2,0> rotate x*10}
                    cylinder{x*20,x*23,0.18 translate y*1.5}
                    rotate x*Teta
            }
            #declare Teta=Teta+20;
    #end

    translate x
}

//-----------------------------------------
// Pipe 6 Length=44*x
//-----------------------------------------
#declare ElPipe6i=union{
    cylinder{0,8*x,1}
    object{Elbow1 translate <8,0,-2>}
    object{Elbow1 rotate y*180 translate <12,0,-2>}
    object{Elbow1 rotate y*90 translate <12,0,-2>}
    cylinder{0,z*4,1 translate <14,0,-2>}
    object{Elbow1 rotate -y*90 translate <16,0,2>}
    object{Elbow1 translate <16,0,2>}
    object{Elbow1 rotate y*180 translate <20,0,2>}
    object{Elbow1 translate <20,0,-2>}
    object{Elbow1 rotate y*180 translate <24,0,-2>}
    object{Elbow1 rotate y*90 translate <26,0,-2>}
    object{Elbow1 rotate -y*90 translate <30,0,-2>}
    cylinder{0,2*x,1 translate x*30}

    object{Ring1}
    object{Ring1 translate x*8}
    object{Ring1 rotate y*90 translate <10,0,-2>}
    object{Ring1 rotate y*90 translate <14,0,-2>}
    object{Ring1 rotate y*90 translate <14,0,2>}
    object{Ring1 rotate y*90 translate <18,0,2>}
    object{Ring1 translate x*20}
    object{Ring1 rotate y*90 translate <22,0,-2>}
    object{Ring1 scale <3,1,1> translate <25,0,-4>}
    object{Ring1 rotate y*90 translate <28,0,-2>}
    object{Ring1 translate x*30}
    object{Ring1 translate x*32}
    
}       

#declare ElPipe6=union{
    union{
            object{ElPipe6i translate <0,1.5,1>}
            object{ElPipe6i scale <-1,1,-1> translate <33,-1.5,-1>}
            translate x*6
    }
    object{Ring1 scale 1.5}
    blob{
            threshold 0.6
            cylinder{0,2*x,2*1.5,1}
            cylinder{0,<6,1.7,1>,1*1.7,1}
            cylinder{0,<7,-1.7,-1>,1*1.7,1}
    }
    union{
            object{Ring1 scale 1.5}
            blob{
                    threshold 0.6
                    cylinder{0,2*x,2*1.5,1}
                    cylinder{0,<6,1.7,1>,1*1.7,1}
                    cylinder{0,<5,-1.7,-1>,1*1.7,1}
            }
            scale <-1,1,1>
            translate x*44
    }
    object{Wheel scale 0.3 translate <1,3,0>}
}

//-----------------------------------------
// Pipe 7 Length=10*x
//-----------------------------------------
#declare ElPipe7=union{
    object{Ring1 scale 2/1.2}
    object{Ring1 scale 2/1.2 translate x*9.5}
    cylinder{0,x*10,2}
    union{
            object{Ring2 rotate y*90 translate <1.5,0,-4>}
            object{Ring2 rotate x*90 translate <1.5,2,-6>}
            object{Ring2 rotate x*90 translate <1.5,4.5,-6>}
            object{Ring2 rotate y*90 translate <1.5,6.5,-4>}
            object{Ring2 rotate y*90 translate <1.5,6.5,-2>}
            object{Ring2 translate <3.5,6.5,0>}
            object{Ring2 translate <7,6.5,0>}
            object{Ring2 rotate x*90 translate <9,4.5,0>}
            cylinder{0,-z*4,0.5 translate x*1.5}
            cylinder{0,-z*3,0.7 translate x*1.5}

            object{Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
            object{Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
            cylinder{0,y*2.5,0.5 translate <1.5,2,-6>}
            cylinder{0,2*z,0.5 translate <1.5,6.5,-4>}
            object{Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
            cylinder{0,3.5*x,0.5 translate <3.5,6.5,0>}
            object{Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
            cylinder{0,4.5*y,0.5 translate <9,0,0>}
            translate <1,0.5,0>
    }

    union{
            object{Ring2 rotate y*90 translate <1.5,0,-4>}
            object{Ring2 rotate x*90 translate <1.5,2,-6>}
            object{Ring2 rotate x*90 translate <1.5,4.5,-6>}
            object{Ring2 rotate y*90 translate <1.5,6.5,-4>}
            object{Ring2 rotate y*90 translate <1.5,6.5,-2>}
            object{Ring2 translate <3.5,6.5,0>}
            object{Ring2 translate <7,6.5,0>}
            object{Ring2 rotate x*90 translate <9,4.5,0>}
            cylinder{0,-z*4,0.5 translate x*1.5}
            cylinder{0,-z*3,0.7 translate x*1.5}
            object{Elbow2 rotate y*90 rotate -z*90 translate <1.5,2,-4>}
            object{Elbow2 rotate y*90 rotate z*90 translate <1.5,4.5,-4>}
            cylinder{0,y*2.5,0.5 translate <1.5,2,-6>}
            cylinder{0,2*z,0.5 translate <1.5,6.5,-4>}
            object{Elbow2 rotate -y*90 translate <3.5,6.5,-2>}
            cylinder{0,3.5*x,0.5 translate <3.5,6.5,0>}
            object{Elbow2 rotate y*90 rotate z*90 rotate -y*90 translate <7,4.5,0>}
            cylinder{0,4.5*y,0.5 translate <9,0,0>}
            scale <-1,1,-1>
            translate x*10
            translate <0,-1,-1>
    }
    object{Eye scale <1,1.5,1>*0.3 rotate y*90 translate <3.5,1.8,0>}
    object{Eye scale <1,1.5,1>*0.2 rotate y*90 translate <6.3,1.9,0>}
}       

//=========================================
// Pipes
//-----------------------------------------
// Use the pipe dummies below for test
/*
#declare ElPipe1=cylinder{0,10*x,2.5 }
#declare ElPipe2=cylinder{0,24*x,2.5 }
#declare ElPipe3=cylinder{0,10*x,2.5}
#declare ElPipe4=cylinder{0,36*x,2.5 }
#declare ElPipe5=cylinder{0,24*x,2.5 }
#declare ElPipe6=cylinder{0,44*x,2.5 }
#declare ElPipe7=cylinder{0,10*x,2.5 }
*/


#declare PipeA=union{
    object{Elbow rotate y*90}
    object{ElPipe1 rotate y*-90 translate x*5}
    object{ElPipe1 scale <-1,1,-1> translate x*10 rotate y*-90 translate <5,0,10>}
    object{ElPipe6 rotate y*-90 translate <5,0,20>}
    object{ElPipe6 scale <-1,1,1> translate -z*5}
    texture{T_Pipe}
}
#declare PipeB=union{
    object{Elbow rotate y*90}
    object{ElPipe3 rotate y*-90 translate x*5}
    object{ElPipe5 rotate y*-90 translate <5,0,10>}
    object{ElPipe4 rotate y*-90 translate <5,0,34>}
    object{ElPipe2 scale <-1,1,1> translate -z*5}
    object{ElPipe2 scale <-1,1,1> translate <-24,0,-5>}
    object{Elbow rotate -y*90 translate <10,0,70>}
    object{ElPipe1 translate <10,0,75>}
    object{ElPipe3 translate <20,0,75>}
    texture{T_Pipe}
}
#declare PipeC=union{
    object{Elbow}
    object{ElPipe7 scale <-1,1,1> translate z*5}
    object{ElPipe3 scale <-1,1,1> translate <-10,0,5>}
    object{ElPipe3 scale <-1,1,1> translate <-20,0,5>}
    object{ElPipe4 scale <-1,1,1> translate <-30,0,5>}
    object{ElPipe2 scale <-1,1,1> translate <-66,0,5>}
    object{ElPipe1 rotate y*90 translate x*5}
    object{ElPipe3 rotate y*90 translate <5,0,-10>}
    object{ElPipe2 rotate y*90 translate <5,0,-20>}
    object{Elbow rotate y*90 translate <15,0,-10>}
    object{ElPipe7 scale <1,1,-1> translate <5,0,-15>}
    object{ElPipe2 rotate -y*90 translate <20,0,-10>}
    object{ElPipe5 rotate -y*90 translate <20,0,14>}
    texture{T_Pipe}
}


//=========================================
// View the pipes
//-----------------------------------------               
// Camera
camera{
    location <0, 40, -120 >
    direction 3*z
    look_at 0
}
// Light
//light_source {< -1000, 1000, -1000>  color White*2 }
//light_source {< 1000, 1000, -1000>  color White }
light_source{-z*1000 White rotate x*45 rotate y*40}
light_source{-z*1000 Blue*6 rotate x*55 rotate -y*80}
light_source{-z*1000 Orange*3 rotate x*60 rotate -y*220}
//background{Cyan}
object{PipeA rotate x*-90}
object{PipeB rotate y*90}
object{PipeC}
plane{y,-5 texture{pigment{Black}finish{ambient 0 diffuse 0 reflection 0.4}}}