// ========================================
// Example 1 for the MadPipe macro
// -----------------------------------------
// Made for Persistence of vision 3.6
//==========================================  
// Copyright 2000-2004 Gilles Tran http://www.oyonale.com
// -----------------------------------------
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//==========================================  
#include "colors.inc"
// ----------------------------------------

#version 3.7;

#declare Cam_Pos=<0,30,-120>;
#declare Cam_Lookat=<20,-10,10>;
camera{
    location  Cam_Pos  
    direction z*0.8  
    right x*image_width/image_height
    look_at   Cam_Lookat
}

//-----------------------------------------
// Texture
//-----------------------------------------
#declare C_Pipe=rgb<230,240,255>/255;
#declare T_Pipe=texture{pigment{C_Pipe*0.6} finish{diffuse 1 metallic brilliance 5 ambient 0 specular 1 roughness 1/100}}

//-----------------------------------------
// Decorations (must be declared before)
//-----------------------------------------
#declare nDeco=7;
#declare Deco=array[nDeco]
#include "pipedeco.inc"
//#include "pipedeco0.inc" // (test decorations = spheres)
//-----------------------------------------
// Pipes
//-----------------------------------------
#declare yCage=80;  // all pipes are contained in a box of same height


#include "madpipe.inc"
#declare nPipe=100; // all pipes have the sampe number of elements
#declare dPipe=0; // 3D pipes (dPipe=1 = 2D pipes on the x-y plane)

#declare rPipe=1.1;
#declare lPipe=8; 
#declare box_container=<21,yCage,21>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_1=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,30,13,true,"pipe_1.inc") }


#declare rPipe=0.9;
#declare lPipe=6;
#declare box_container=<25,yCage,25>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_2=object{MadPipe(rPipe,lPipe,nPipe,dPipe,box_container,box_hole,20,20,true,"pipe_2.inc") }           

#declare rPipe=0.6;
#declare lPipe=6;        
#declare box_container=<27,yCage,27>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_3=object{MadPipe(rPipe,lPipe,nPipe*2,dPipe,box_container,box_hole,20,30,true,"pipe_3.inc") }           

#declare rPipe=0.3;
#declare lPipe=3;
#declare box_container=<30,yCage,30>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_4=object{MadPipe(rPipe,lPipe,nPipe*3,dPipe,box_container,box_hole,10,53,true,"pipe_4.inc") }           

#declare rPipe=0.2;
#declare lPipe=2;
#declare box_container=<29,yCage,29>;  
#declare box_hole=box_container*0.3;  
#declare Pipe_5=object{MadPipe(rPipe,lPipe,nPipe*3,dPipe,box_container,box_hole,10,54,true,"pipe_5.inc") }           


//-----------------------------------------
// Pipe placement
// once the pipes are created, just include the files (no need to call the macro)
//-----------------------------------------

#declare Cage=union{
    #include "Pipe_1.inc"

    #include "Pipe_2.inc"
    #include "Pipe_4.inc"
    #include "Pipe_5.inc"

    texture{T_Pipe}
}
#declare C_Sky=rgb <100,140,255>/255;
#declare C_Sky2=rgb <255,140,55>/255;
    
union{           
    union{
        object{Cage}
        light_source{0,C_Sky2*4 fade_power 2 fade_distance 100 translate -z*100}
        object{Cage scale -0.9 rotate y*-90}
        rotate z*90 
        rotate y*90
        rotate y*-40
    }
}

//light_source{-z*1000 C_Sky2*5  rotate -x*20  rotate y*120}
light_source{-z*1000 C_Sky*5  rotate x*50  rotate -y*70}
light_source{Cam_Pos C_Sky*0.4}

