// ========================================
// Example 2 for the MadPipe macro
// -----------------------------------------
// Made for Persistence of vision 3.6
//==========================================  
// Copyright 2000-2004 Gilles Tran http://www.oyonale.com
// -----------------------------------------
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//==========================================  

#version 3.7;

global_settings{
//    assumed_gamma 1
    radiosity{
        recursion_limit 1
        normal on
    }
}
#include "colors.inc"
//-----------------------------------------
// Texture
//-----------------------------------------
#declare C_Wall=color rgb<0.85,0.95,0.94>*0.6;
#declare C_Pipe=color rgb<0.95,0.9,0.8>*0.4;
#declare T_Pipe=texture{
        pigment{
            crackle 
            solid 
            color_map{[0 color White*0.8][1 color White]}
            scale 0.1
        }
        normal{agate 0.4}
        finish{ambient 0 diffuse 0.9 specular 0.1 roughness 0.1 metallic brilliance 1}
}

//-----------------------------------------
// Decorations (must be declared before)
//-----------------------------------------
#declare nDeco=7;
#declare Deco=array[nDeco]
#include "pipedeco.inc"
#include "pipedeco0.inc" // (test decorations = spheres)
/*
//-----------------------------------------
// Pipes
//-----------------------------------------
#include "madpipe.inc"

#declare box_hole=<0,0,0>;  // no hole = decorations everywhere
#declare dPipe=0; // 3D pipes (dPipe=1 = 2D pipes on the x-y plane)

#declare nPipe=300;
#declare rPipe=0.3;
#declare lPipe=1; 
#declare container=<20,10,2>;  
#declare Pipe_1=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,0,14,true,"wpipe_1.inc") }

#declare nPipe=300;
#declare rPipe=0.2;
#declare lPipe=1; 
#declare container=<10,10,3>;  
#declare Pipe_2=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,0,20,true,"wpipe_2.inc") }

#declare nPipe=100;
#declare rPipe=0.5;
#declare lPipe=1; 
#declare container=<20,5,1>;  
#declare Pipe_3=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,0,30,true,"wpipe_3.inc") }

#declare nPipe=500;
#declare rPipe=0.1;
#declare lPipe=1; 
#declare container=<20,15,2>;  
#declare Pipe_4=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,30,true,"wpipe_4.inc") }
*/
//-----------------------------------------
// Pipe placement
// once the pipes are created, just include the files (no need to call the macro)
//-----------------------------------------
#declare P1=union{
        object{#include "WPipe_1.inc" texture{T_Pipe}}
        object{#include "WPipe_2.inc" texture{T_Pipe}}
        object{#include "WPipe_3.inc" texture{T_Pipe}}
        object{#include "WPipe_4.inc" texture{T_Pipe}}
}
object{P1}
object{P1 rotate x*90 rotate y*90 scale 0.7 translate x*10}
object{P1 rotate x*90 rotate -y*90 scale 1 translate -x*10+y*10}
#declare C_Light=rgb<243,199,107>/255;
//-----------------------------------------
// Lamp
//-----------------------------------------
light_source{-z*1000 color C_Light*5 rotate x*30 rotate y*80}

#declare C_Sky_Pink=color rgb <1,0.87,0.85>;
#declare C_Sky_Blue=color rgb <0.75,0.9,1>;
sphere {0,1
    texture{
        pigment{
            planar
            turbulence 0.1
            octaves 4
            lambda 3
            colour_map{ 
                [0 C_Sky_Blue*0.5]
                [0.3 C_Sky_Blue]
                [1 C_Sky_Pink]
            }
        }
        finish{ambient 1 diffuse 0}
    }
    hollow
    scale 100000*<2,1,1>
}

//plane{z,6 texture{pigment{C_Wall} finish{diffuse 0.65 ambient 0}}}
camera{
    location  <12,4,-12>
    direction 0.5*z  
    
    look_at   <3, 0,  6.0>
}
