#! /bin/csh -fv

echo "-------------------------------------------------------------------------"
echo " CCSM PRESTAGE SCRIPT STARTING"

# -------------------------------------------------------------------------
# Determining DIN_LOC_ROOT
# -------------------------------------------------------------------------

echo " - CCSM input data directory, DIN_LOC_ROOT_CSMDATA, is $DIN_LOC_ROOT_CSMDATA"
echo " - Case input data directory, DIN_LOC_ROOT, is $DIN_LOC_ROOT"
echo " - Checking the existence of input datasets in DIN_LOC_ROOT"

if !(-d $DIN_LOC_ROOT_CSMDATA) then
  echo " "
  echo "  ERROR DIN_LOC_ROOT_CSMDATA $DIN_LOC_ROOT_CSMDATA does not exist"
  echo " "
  exit -20
endif

if (`./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -check | grep "missing" | wc -l` > 0) then
   echo " "
   echo "The following files were not found, they are required"
   ./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -check
   echo "Invoke the following command to obtain them"
   echo "   ./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -export"
   echo " "
   exit -1
endif

if (`./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -check | grep "undetermined" | wc -l` > 0) then
   echo " "
   echo "The following files were not found, this is informational only"
   ./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -check
   echo " "
endif

if (($PRESTAGE_DATA == TRUE) && ($DIN_LOC_ROOT != $DIN_LOC_ROOT_CSMDATA)) then
   ./check_input_data -inputdata $DIN_LOC_ROOT_CSMDATA -prestage $DIN_LOC_ROOT
   if ($status != 0) then
       echo " "
       echo  "ERROR ccsm_prestage.csh: prestaging failed"
       echo " "
       exit -2
   endif
endif

if (($DIN_LOC_REFCASE != '') && ($CONTINUE_RUN == 'FALSE')) then
  if !(-d $DIN_LOC_ROOT_CSMDATA/$DIN_LOC_REFCASE) then
    set dir = $DIN_LOC_REFCASE
    set dir = $dir:h
    echo "*****************************************************************"
    echo "configure ERROR: $DIN_LOC_REFCASE is required and not on local disk"
    echo "MUST obtain this data from the svn input data repository:"
    echo " "
    echo "> cd $DIN_LOC_ROOT_CSMDATA"
    echo "> mkdir -p $dir"
    echo "> cd $dir"
    echo "> svn export https://svn-ccsm-inputdata.cgd.ucar.edu/trunk/inputdata/$DIN_LOC_REFCASE"
    echo " "
    echo "*****************************************************************"
    exit -1
  endif 

   echo " - Prestaging DIN_LOC_REFCASE ($DIN_LOC_REFCASE) to $RUNDIR"
   set DIR = $RUNDIR 
   if !(-d $DIR) mkdir -p $DIR || "cannot make $DIR" && exit -1
   cp $DIN_LOC_ROOT_CSMDATA/$DIN_LOC_REFCASE/* $RUNDIR || \
         "cannot prestage $DIN_LOC_ROOT_CSMDATA/$DIN_LOC_REFCASE to $RUNDIR" && exit -1
endif

echo " CCSM PRESTAGE SCRIPT HAS FINISHED SUCCESSFULLY"



