#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gcc     -std=c99   -m64 -c -o spec.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  spec.c
/usr/bin/gcc     -std=c99   -m64 -c -o spec_xz.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  spec_xz.c
/usr/bin/gcc     -std=c99   -m64 -c -o pxz.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  pxz.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_physmem.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_physmem.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/common.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/common.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_util.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_util.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/easy_preset.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/easy_preset.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_common.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_common.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/hardware_physmem.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/hardware_physmem.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/index.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/index.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_flags_common.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_flags_common.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/vli_size.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/vli_size.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/alone_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/alone_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_buffer_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_buffer_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_header_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_header_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/easy_buffer_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/easy_buffer_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/easy_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/easy_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/easy_encoder_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/easy_encoder_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_buffer_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_buffer_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_flags_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_flags_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/index_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/index_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_buffer_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_buffer_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_flags_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_flags_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/vli_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/vli_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/alone_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/alone_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/auto_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/auto_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_buffer_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_buffer_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/block_header_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/block_header_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/easy_decoder_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/easy_decoder_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_buffer_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_buffer_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/filter_flags_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/filter_flags_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/index_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/index_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/index_hash.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/index_hash.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_buffer_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_buffer_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/stream_flags_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/stream_flags_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/common/vli_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/common/vli_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/check.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/check.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/crc32_table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/crc32_table.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/crc32_fast.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/crc32_fast.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/crc64_table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/crc64_table.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/crc64_fast.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/crc64_fast.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/check/sha256.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/check/sha256.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lz/lz_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lz/lz_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lz/lz_encoder_mf.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lz/lz_encoder_mf.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lz/lz_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lz/lz_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma_encoder_presets.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma_encoder_presets.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma_encoder_optimum_fast.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma_encoder_optimum_fast.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma_encoder_optimum_normal.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma_encoder_optimum_normal.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/fastpos_table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/fastpos_table.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma2_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma2_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/lzma/lzma2_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/lzma/lzma2_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/rangecoder/price_table.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/rangecoder/price_table.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/delta/delta_common.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/delta/delta_common.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/delta/delta_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/delta/delta_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/delta/delta_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/delta/delta_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/simple_coder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/simple_coder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/simple_encoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/simple_encoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/simple_decoder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/simple_decoder.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/x86.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/x86.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/powerpc.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/powerpc.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/ia64.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/ia64.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/arm.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/arm.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/armthumb.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/armthumb.c
/usr/bin/gcc     -std=c99   -m64 -c -o liblzma/simple/sparc.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  liblzma/simple/sparc.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/args.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/args.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/coder.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/coder.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/file_io.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/file_io.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/hardware.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/hardware.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/list.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/list.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/main.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/main.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/message.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/message.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/options.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/options.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/signals.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/signals.c
/usr/bin/gcc     -std=c99   -m64 -c -o xz/util.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  xz/util.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_open_stdxxx.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_open_stdxxx.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_progname.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_progname.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_exit.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_exit.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_cpucores.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_cpucores.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_mbstr_width.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_mbstr_width.c
/usr/bin/gcc     -std=c99   -m64 -c -o common/tuklib_mbstr_fw.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  common/tuklib_mbstr_fw.c
/usr/bin/gcc     -std=c99   -m64 -c -o spec_mem_io/spec_mem_io.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  spec_mem_io/spec_mem_io.c
/usr/bin/gcc     -std=c99   -m64 -c -o sha-2/sha512.o -DSPEC -DSPEC_CPU -DNDEBUG -DSPEC_AUTO_BYTEORDER=0x12345678 -DHAVE_CONFIG_H=1 -DSPEC_MEM_IO -DSPEC_XZ -DSPEC_AUTO_SUPPRESS_OPENMP -I. -Ispec_mem_io -Isha-2 -Icommon -Iliblzma/api -Iliblzma/lzma -Iliblzma/common -Iliblzma/check -Iliblzma/simple -Iliblzma/delta -Iliblzma/lz -Iliblzma/rangecoder  -g            -fno-strict-aliasing   -DSPEC_LP64  sha-2/sha512.c
/usr/bin/gcc     -std=c99   -m64  -z muldefs    -g         -fno-strict-aliasing spec.o spec_xz.o pxz.o common/tuklib_physmem.o liblzma/common/common.o liblzma/common/block_util.o liblzma/common/easy_preset.o liblzma/common/filter_common.o liblzma/common/hardware_physmem.o liblzma/common/index.o liblzma/common/stream_flags_common.o liblzma/common/vli_size.o liblzma/common/alone_encoder.o liblzma/common/block_buffer_encoder.o liblzma/common/block_encoder.o liblzma/common/block_header_encoder.o liblzma/common/easy_buffer_encoder.o liblzma/common/easy_encoder.o liblzma/common/easy_encoder_memusage.o liblzma/common/filter_buffer_encoder.o liblzma/common/filter_encoder.o liblzma/common/filter_flags_encoder.o liblzma/common/index_encoder.o liblzma/common/stream_buffer_encoder.o liblzma/common/stream_encoder.o liblzma/common/stream_flags_encoder.o liblzma/common/vli_encoder.o liblzma/common/alone_decoder.o liblzma/common/auto_decoder.o liblzma/common/block_buffer_decoder.o liblzma/common/block_decoder.o liblzma/common/block_header_decoder.o liblzma/common/easy_decoder_memusage.o liblzma/common/filter_buffer_decoder.o liblzma/common/filter_decoder.o liblzma/common/filter_flags_decoder.o liblzma/common/index_decoder.o liblzma/common/index_hash.o liblzma/common/stream_buffer_decoder.o liblzma/common/stream_decoder.o liblzma/common/stream_flags_decoder.o liblzma/common/vli_decoder.o liblzma/check/check.o liblzma/check/crc32_table.o liblzma/check/crc32_fast.o liblzma/check/crc64_table.o liblzma/check/crc64_fast.o liblzma/check/sha256.o liblzma/lz/lz_encoder.o liblzma/lz/lz_encoder_mf.o liblzma/lz/lz_decoder.o liblzma/lzma/lzma_encoder.o liblzma/lzma/lzma_encoder_presets.o liblzma/lzma/lzma_encoder_optimum_fast.o liblzma/lzma/lzma_encoder_optimum_normal.o liblzma/lzma/fastpos_table.o liblzma/lzma/lzma_decoder.o liblzma/lzma/lzma2_encoder.o liblzma/lzma/lzma2_decoder.o liblzma/rangecoder/price_table.o liblzma/delta/delta_common.o liblzma/delta/delta_encoder.o liblzma/delta/delta_decoder.o liblzma/simple/simple_coder.o liblzma/simple/simple_encoder.o liblzma/simple/simple_decoder.o liblzma/simple/x86.o liblzma/simple/powerpc.o liblzma/simple/ia64.o liblzma/simple/arm.o liblzma/simple/armthumb.o liblzma/simple/sparc.o xz/args.o xz/coder.o xz/file_io.o xz/hardware.o xz/list.o xz/main.o xz/message.o xz/options.o xz/signals.o xz/util.o common/tuklib_open_stdxxx.o common/tuklib_progname.o common/tuklib_exit.o common/tuklib_cpucores.o common/tuklib_mbstr_width.o common/tuklib_mbstr_fw.o spec_mem_io/spec_mem_io.o sha-2/sha512.o                      -o xz_r  
