#ifndef SYS_POV_CONFIG_H
#define SYS_POV_CONFIG_H

#include <pthread.h>

using namespace std;

#define POV_USE_POSIX_THREADS				1

#define EPSILON								1.0e-7 // 1.0e-10

#define POV_CPP_MEM_HAS_NEW_INCLUDE			1
#define POV_CPP_MEM_HAS_PLACEMENT_FORMS		1
#define POV_CPP_MEM_HAS_NOTHROW_SUPPORT		1

#define POVRAY_PLATFORM_NAME				"SPEC v6"
#define COMPILER_VER						"thorsten@povray.org"

#define MEM_RECLAIM							1
#define MEM_STATS							1

#define DONT_USE_POVMS						1
#define DONT_SHOW_IMAGE_LIB_VERSIONS		1
#define POVMS_NO_ORDERED_STREAM_DATA		1

#define READ_ENV_VAR
#define PROCESS_POVRAY_INI

#define POV_SPEC_NOT_SUPPORT				"This feature is not supported in the POV-Ray 3.7 SPEC version!"

#define POV_NAME_MAX						(31-4)
#define	POV_FILE_SEPARATOR					'/'
#define DELETE_FILE(name)					unlink(name)
#define RENAME_FILE(orig,new)				rename(orig,new)
#define POV_PARSE_PATH_STRING(s, v, f, n)	pov::Sys_Parse_Path_String(s, v, f, n)

#define POV_UCS2_FOPEN(name, mode)			fopen(UCS2toASCIIString(UCS2String(name)).c_str(), mode)
#define POV_UCS2_REMOVE(name)				remove(UCS2toASCIIString(UCS2String(name)).c_str())

#define EXIST_FONT_FILE(name)				(0)
#define POV_ALLOW_FILE_READ(f,t)			(1)
#define POV_ALLOW_FILE_WRITE(f,t)			(1)

//#define POV_TRACE_THREAD_PREINIT
//#define POV_TRACE_THREAD_POSTINIT

#define POV_LONG							long long
#define POV_ULONG							unsigned long long

#define DEFAULT_OUTPUT_FORMAT				kPOVList_FileType_Targa
#define DEFAULT_DISPLAY_GAMMA				2.2

#define POVMSAddress						POVMS_SPEC_QueueNode *
#define POVMSInvalidAddress					NULL

#define POVMS_Sys_Thread_Type				pthread_t
#define POVMS_Sys_Queue_Type				POVMS_SPEC_QueueNode *

#define POVMS_Sys_GetCurrentThread()		pthread_self()
#define POVMS_Sys_QueueToAddress(q)			(q)
#define POVMS_Sys_AddressToQueue(a)			(a)
#define POVMS_Sys_QueueOpen()				POVMS_SPEC_QueueOpen()
#define POVMS_Sys_QueueClose(q)				POVMS_SPEC_QueueClose(q)
#define POVMS_Sys_QueueReceive(q,l,b,y)		POVMS_SPEC_QueueReceive(q, l, b, y)
#define POVMS_Sys_QueueSend(q, p, l)		POVMS_SPEC_QueueSend(q, p, l)
#define POVMS_Sys_AddressFromStream(a, s, z) POVMS_SPEC_AddressFromStream((a), (s), (z))
#define POVMS_Sys_AddressToStream(a, s, z)	POVMS_SPEC_AddressToStream((a), (s), (z))
#define POVMS_Sys_AddressToStreamSize(a)	POVMS_SPEC_AddressToStreamSize((a))

namespace pov_base
{

class Mutex;

};

typedef struct POVMS_SPEC_QueueNode POVMS_SPEC_QueueNode;
typedef struct POVMS_SPEC_QueueDataNode POVMS_SPEC_QueueDataNode;

struct POVMS_SPEC_QueueDataNode
{
	POVMS_SPEC_QueueDataNode *next;
	void *data;
	int len;
};

struct POVMS_SPEC_QueueNode
{
	int magic;
	int entries;
	POVMS_SPEC_QueueDataNode *first;
	POVMS_SPEC_QueueDataNode *last;
	pov_base::Mutex *mutex;
};

#endif // SYS_POV_CONFIG_H
