/*******************************************************************************
 * bcyl.h
 *
 * This module contains all defines, typedefs, and prototypes for BCYL.C.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/bounding/bcyl.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef BCYL_H
#define BCYL_H

namespace pov
{

/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/* Generate additional bcyl statistics. */

#define BCYL_EXTRA_STATS 1


/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct BCyl_Struct BCYL;
typedef struct BCyl_Entry_Struct BCYL_ENTRY;
typedef struct BCyl_Intersection_Struct BCYL_INT;

struct BCyl_Intersection_Struct
{
  int n;     /* Number of cylinder hit    */
  DBL d[2];  /* Intersection distance(s)  */
  DBL w[2];  /* Intersection parameter(s) */
};

struct BCyl_Entry_Struct
{
  short r1, r2;        /* Index of min/max segment radius */
  short h1, h2;        /* Index of min/max segmnet height */
};

struct BCyl_Struct
{
  int number;          /* Number of bounding cylinders.       */
  short nradius;       /* Number of different bound-radii.    */
  short nheight;       /* Number of different bound-heights.  */
  DBL *radius;         /* List of different bound-radii.      */
  DBL *height;         /* List of different bound-heights.    */
  BCYL_ENTRY *entry;   /* BCyl elements.                      */
};



/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

BCYL *Create_BCyl (int, DBL *, DBL *, DBL *, DBL *);
void Destroy_BCyl (BCYL *);

int Intersect_BCyl (BCYL *BCyl, BCYL_INT *Intervals, BCYL_INT *rint, BCYL_INT *hint, VECTOR P, VECTOR D);

}

#endif
