/*******************************************************************************
 * renderbackend.h
 *
 * This file contains ... TODO ...
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/control/renderbackend.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef POVRAY_BACKEND_RENDERBACKEND_H
#define POVRAY_BACKEND_RENDERBACKEND_H

#include <map>
#include <set>

#include "base/povms.h"
#include "base/povmscpp.h"
#include "backend/povray.h"
#include "backend/support/types.h"

namespace pov
{

class Scene;
class View;

/**
 *	RenderBackend class receives render control messages from the
 *	RenderFrontend class.  Thee control messages are processed and
 *	parsing, rendering or other operations are performed as
 *	requested by the frontend.
 */
class RenderBackend : public POVMS_MessageReceiver
{
	public:
		typedef POVMSInt SceneId;
		typedef POVMSInt ViewId;

		RenderBackend(POVMSContext ctx, bool (*val)(POVMSAddress));
		~RenderBackend();

		static void SendSceneOutput(SceneId sid, POVMSAddress addr, POVMSType ident, POVMS_Object& obj);
		static void SendViewOutput(ViewId vid, POVMSAddress addr, POVMSType ident, POVMS_Object& obj);

		static void SendFindFile(POVMSContext ctx, SceneId sid, POVMSAddress addr, const vector<UCS2String>& filenames, UCS2String& filename);
		static void SendReadFile(POVMSContext ctx, SceneId sid, POVMSAddress addr, const UCS2String& filename, UCS2String& localfile, UCS2String& fileurl);
		static void SendCreatedFile(POVMSContext ctx, SceneId sid, POVMSAddress addr, const UCS2String& filename);

		static void SendSuccessResult(POVMSAddress addr);
		static void SendFailedResult(int error, POVMSAddress addr);
		static void SendFailedResult(const pov_base::Exception& e, POVMSAddress addr);
		static void SendFailedResult(const char *str, POVMSAddress addr);

		static void SendSceneSuccessResult(SceneId sid, POVMSAddress addr);
		static void SendSceneFailedResult(SceneId sid, int error, POVMSAddress addr);
		static void SendSceneFailedResult(SceneId sid, const pov_base::Exception& e, POVMSAddress addr);
		static void SendSceneFailedResult(SceneId sid, const char *str, POVMSAddress addr);

		static void SendViewSuccessResult(ViewId vid, POVMSAddress addr);
		static void SendViewFailedResult(ViewId vid, int error, POVMSAddress addr);
		static void SendViewFailedResult(ViewId vid, const pov_base::Exception& e, POVMSAddress addr);
		static void SendViewFailedResult(ViewId vid, const char *str, POVMSAddress addr);
	protected:
		void CreateScene(POVMS_Message& msg, POVMS_Message& result, int mode);
		void CloseScene(POVMS_Message& msg, POVMS_Message& result, int mode);

		void CreateView(POVMS_Message& msg, POVMS_Message& result, int mode);
		void CloseView(POVMS_Message& msg, POVMS_Message& result, int mode);

		void StartParser(POVMS_Message& msg, POVMS_Message& result, int mode);
		void StopParser(POVMS_Message& msg, POVMS_Message& result, int mode);
		void PauseParser(POVMS_Message& msg, POVMS_Message& result, int mode);
		void ResumeParser(POVMS_Message& msg, POVMS_Message& result, int mode);

		void StartRender(POVMS_Message& msg, POVMS_Message& result, int mode);
		void StopRender(POVMS_Message& msg, POVMS_Message& result, int mode);
		void PauseRender(POVMS_Message& msg, POVMS_Message& result, int mode);
		void ResumeRender(POVMS_Message& msg, POVMS_Message& result, int mode);

		void ReadFile(POVMS_Message& msg, POVMS_Message& result, int mode);
	private:
		static POVMSContext context;

		bool (*validateFrontendAddress)(POVMSAddress);

		SceneId scenecounter;
		ViewId viewcounter;

		map<SceneId, shared_ptr<Scene> > scenes;
		map<ViewId, shared_ptr<View> > views;
		map<SceneId, set<ViewId> > scene2views;
		map<ViewId, SceneId> view2scene;

		bool ValidateFrontendAddress(POVMSAddress addr, POVMS_Message& result);

		void MakeFailedResult(int error, POVMS_Message& result);
		void MakeFailedResult(const pov_base::Exception& e, POVMS_Message& result);
		void MakeFailedResult(const char *str, POVMS_Message& result);
		void MakeDoneResult(POVMS_Message& result);
};

}

#endif // POVRAY_BACKEND_RENDERBACKEND_H
