/*******************************************************************************
 * media.h
 *
 * This module contains all defines, typedefs, and prototypes for MEDIA.CPP.
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/interior/media.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/


#ifndef MEDIA_H
#define MEDIA_H

#include "backend/render/trace.h"

namespace pov
{

// Scattering types.
enum
{
	ISOTROPIC_SCATTERING            = 1,
	MIE_HAZY_SCATTERING             = 2,
	MIE_MURKY_SCATTERING            = 3,
	RAYLEIGH_SCATTERING             = 4,
	HENYEY_GREENSTEIN_SCATTERING    = 5,
	SCATTERING_TYPES                = 5
};

void Transform_Density(PIGMENT *Density, const TRANSFORM *Trans);

class MediaFunction : public Trace::MediaFunctor
{
	public:
		MediaFunction(TraceThreadData *td, Trace *t, PhotonGatherer *pg);

		virtual void ComputeMedia(vector<Media>& mediasource, Ray& ray, Intersection& isect, Colour& colour, Trace::TraceTicket& ticket);
		virtual void ComputeMedia(const RayInteriorVector& mediasource, Ray& ray, Intersection& isect, Colour& colour, Trace::TraceTicket& ticket);
		virtual void ComputeMedia(MediaVector& medias, Ray& ray, Intersection& isect, Colour& colour, Trace::TraceTicket& ticket);
	protected:
		/// pseudo-random number sequence
		RandomDoubleSequence randomNumbers;
		/// pseudo-random number generator based on random number sequence
		RandomDoubleSequence::Generator randomNumberGenerator;
		/// thread data
		TraceThreadData *threadData;
		/// tracing functions
		Trace *trace;
		/// photon gather functions
		PhotonGatherer *photonGatherer;

		void ComputeMediaRegularSampling(MediaVector& medias, LightSourceEntryVector& lights, MediaIntervalVector& mediaintervals,
		                                 Ray& ray, Media *IMedia, int minsamples, bool ignore_photons, bool use_scattering,
		                                 bool all_constant_and_light_ray, Trace::TraceTicket& ticket);
		void ComputeMediaAdaptiveSampling(MediaVector& medias, LightSourceEntryVector& lights, MediaIntervalVector& mediaintervals,
		                                  Ray& ray, Media *IMedia, DBL aa_threshold, int minsamples, bool ignore_photons, bool use_scattering, Trace::TraceTicket& ticket);
		void ComputeMediaColour(MediaIntervalVector& mediaintervals, Colour& colour);
		void ComputeMediaSampleInterval(LitIntervalVector& litintervals, MediaIntervalVector& mediaintervals, Media *media);
		void ComputeMediaLightInterval(LightSourceEntryVector& lights, LitIntervalVector& litintervals, Ray& ray, Intersection& isect);
		void ComputeOneMediaLightInterval(LightSource *light, LightSourceEntryVector&lights, Ray& ray, Intersection& isect);
		bool ComputeSpotLightInterval(Ray &ray, LightSource *Light, DBL *d1, DBL *d2);
		bool ComputeCylinderLightInterval(Ray &ray, LightSource *Light, DBL *d1, DBL *d2);
		void ComputeOneMediaSample(MediaVector& medias, LightSourceEntryVector& lights, MediaInterval& mediainterval, Ray &ray, DBL d0, RGBColour& SampCol,
		                           RGBColour& SampOptDepth, int sample_method, bool ignore_photons, bool use_scattering, bool photonPass, Trace::TraceTicket& ticket);
		void ComputeOneMediaSampleRecursive(MediaVector& medias, LightSourceEntryVector& lights, MediaInterval& mediainterval, Ray& ray,
		                                    DBL d1, DBL d3, RGBColour& Result, const RGBColour& C1, const RGBColour& C3, RGBColour& ODResult, const RGBColour& od1, const RGBColour& od3,
		                                    int depth, DBL Jitter, DBL aa_threshold, bool ignore_photons, bool use_scattering, bool photonPass, Trace::TraceTicket& ticket);
		void ComputeMediaPhotons(MediaVector& medias, RGBColour& Te, const RGBColour& Sc, Ray& ray, const VECTOR H);
		void ComputeMediaScatteringAttenuation(MediaVector& medias, RGBColour& OutputColor, const RGBColour& Sc, const RGBColour& Light_Colour, Ray &ray, Ray &Light_Ray);
};

}

#endif
