/*******************************************************************************
 * photonstrategytask.h
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2010 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/spec-3.7/source/backend/lighting/photonstrategytask.h $
 * $Revision: #2 $
 * $Change: 5047 $
 * $DateTime: 2010/06/30 07:58:31 $
 * $Author: thorsten $
 *******************************************************************************/

#ifndef PHOTONSTRATEGYTASK_H
#define PHOTONSTRATEGYTASK_H

#include "base/povms.h"
#include "backend/frame.h"
#include "backend/render/trace.h"
#include "backend/control/messagefactory.h"
#include "backend/colour/colutils.h"
#include "backend/render/rendertask.h"
#include "backend/parser/parse.h"
#include "backend/lighting/photonshootingstrategy.h"

namespace pov
{

using namespace pov_base;

class PhotonStrategyTask : public RenderTask
{
	public:
        MessageFactory messageFactory;
		Timer timer;

		PhotonShootingStrategy* strategy;

		PhotonStrategyTask(ViewData *vd, PhotonShootingStrategy* strategy);
		~PhotonStrategyTask();

		void Run();
		void Stopped();
		void Finish();

        void SendProgress();

		void SearchThroughObjectsCreateUnits(vector<ObjectPtr>& Objects, LightSource *Light);
	private:
		class CooperateFunction : public Trace::CooperateFunctor
		{
			public:
				CooperateFunction(Task& t) : task(t) { }
				virtual void operator()() { task.Cooperate(); }
			private:
				Task& task;
		};

		CooperateFunction cooperate;
};

}
#endif
